/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/


#include <stdio.h>
#include <assert.h>

#include "cache.h"


#if !defined(logical)
#define logical int
#endif

struct key_t {
	int pageno;
	int Iaf;
	};
typedef struct key_t key;

int isequal( key *x, key *y )
{
	assert( x != NULL );
	assert( y != NULL );

	return(   ((x->pageno) == (y->pageno) ) &&
		  ((x->Iaf) == (y->Iaf))
	      );
}

/* very simple minded hash function */
int hash_function( key *x )
{
	assert( x != NULL );
	return( ((x->Iaf) + (x->pageno)) );
}

/* just match the Iaf field, use to purge all entries of one array */

int ismatchIaf( key *x, key *y )
{
	assert( x != NULL );
	assert( y != NULL );

	return( (x->Iaf) == (y->Iaf) );
}



Cache create_cache(  int maxsize )
{
	Cache mycache;

	mycache = (Cache) malloc( sizeof( struct Cache_t ) );
	assert( mycache != NULL );

	mycache->nsize = 0;
	mycache->maxsize = maxsize;
	assert( maxsize >= 0 );

	mycache->htable = create_htable( isequal, hash_function );

	return( mycache );
}

void checksize_cache( Cache mycache ) 
{
	void *pdata;

	assert( mycache != NULL );

        while ((mycache->nsize) > (mycache->maxsize) ) {
                pdata = deletelast_htable( mycache->htable );
                assert(pdata != NULL);
                free(pdata);

                (mycache->nsize)--;
                };
}

int setsize_cache( Cache mycache, int newsize )
{
	int oldsize;

	assert( mycache != NULL );

	oldsize = mycache->maxsize;
	mycache->maxsize = newsize;

	checksize_cache( mycache );


	return(  oldsize );
}


/* leave it to the caller to free the "pdata" */
void *delete_cache( Cache mycache, int Iaf, int pageno )
{
        key mykey;
        logical found;
        HtableCellptr hptr;



        mykey.Iaf = Iaf; mykey.pageno = pageno;

        hptr = delete_htable( mycache->htable, (void *) &mykey );
        found = (hptr != NULL);

        if (found) { (mycache->nsize)--; };

	/* note the "key:" field is free'ed in htable */

        return( hptr->pdata );
}


	



void purge_cache( Cache mycache, int Iaf )
{


	key inkey;
	int ndeletes;

	/* purge the cache of all data associated with Iaf */


	inkey.Iaf = Iaf; inkey.pageno = 0;
	ndeletes = purge_htable( mycache->htable, (&inkey), ismatchIaf );
	mycache->nsize = (mycache->nsize) - ndeletes;

	assert( mycache->nsize >= 0);

	return;
}




	
void insert_cache( Cache mycache, int Iaf, int pageno, void *pdata )
{
	key *mykeyptr;
	logical isfound;
	DLinkCellptr iptr;

	/* need malloc'ed key because the pointer is
	   copied into htable, cannot have the pointer
	   value on the stack. Code in htable should
	   later free the "key:" value. 
	*/



	assert( mycache != NULL );

	assert( (0 <= (mycache->nsize)) &&
		((mycache->nsize) <= (mycache->maxsize))  );

	/* check for common special case, bypass
	   costly memory malloc and free.   */


	if ((mycache->maxsize) == 0) {

		/* free pdata  and do nothing else  */

		assert( pdata != NULL );
		free( pdata );
		return;
		};


	mykeyptr = (key *) malloc( sizeof(key) );
	mykeyptr->Iaf = Iaf; mykeyptr->pageno = pageno;


	iptr = find_htable( mycache->htable, (void *) (mykeyptr) );
	isfound = (iptr != NULL );
	if (!isfound) {
	    insert_htable( mycache->htable, (void *) (mykeyptr), pdata );

	    mycache->nsize += 1;
	   };

	checksize_cache( mycache );


	return;
}
	

void *find_cache( Cache mycache, int Iaf, int pageno )
{
	key mykey;
	HtableCellptr hptr;
	DLinkCellptr iptr;
	void *pdata;
	logical isfound;

	mykey.Iaf = Iaf; mykey.pageno = pageno;

	iptr = find_htable( mycache->htable, (void *) (&mykey) ) ;
	isfound = (iptr != NULL );

	if (!isfound) { return( NULL ) ; };


	/* return the data page */


	hptr = data_doublelist( iptr );
	assert( hptr != NULL );

	pdata = (void *) data_htable( mycache->htable, hptr );

	return( pdata );
}

