#include "stdinc.h"

#include "externs.h"


/* C to c translation */

#if !defined(LIST_SIZE)
#define LIST_SIZE (8*1024)
#endif

#define DECLARE_STORAGE() \
	 \
        int             stack_list[LIST_SIZE]; \
        int            *newlist; 


#define GET_STORAGE(newlist,nsize) \
    { \
	logical use_stack; \
        use_stack = (nsize <= LIST_SIZE); \
        if (use_stack) { \
                newlist = (int *) (&(stack_list[0])); \
        } else { \
                MEMALLOC(newlist, (int *), (nsize * sizeof(int)) ); \
        }; \
    };

#define CONVERT_LIST(newlist,list,nsize) \
   {  \
	int i; \
 \
        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */ \
        for (i = 0; i < nsize; i++) { \
                newlist[i] = list[i] + 1; \
        }; \
   };


#define FREE_STORAGE(newlist) \
   { \
	logical use_stack; \
 \
	use_stack = (nsize <= LIST_SIZE); \
 \
        /* deallocate storage */ \
 \
        if (use_stack) { \
                /* do nothing */ \
        } else { \
                MEMFREE(newlist); \
        }; \
   }





void do_iaxpby( Iaf, nsize, list, xvec, 
		ialpha,ibeta )

int Iaf, nsize, *list;
int *xvec, ialpha,ibeta;
{



	DECLARE_STORAGE();

	GET_STORAGE(newlist,nsize);

	CONVERT_LIST(newlist,list,nsize);

	do_iaxpby_C(Iaf, nsize, newlist, xvec,
		    ialpha, ibeta);

	FREE_STORAGE(newlist);

}


void
do_daxpby(Iaf, nsize, list, xvec,
          dalpha, dbeta)

int Iaf, nsize, *list;
dfloat *xvec, dalpha,dbeta;
{



        DECLARE_STORAGE();

        GET_STORAGE(newlist,nsize);

        CONVERT_LIST(newlist,list,nsize);

        do_daxpby_C(Iaf, nsize, newlist, xvec,
                    dalpha, dbeta);

        FREE_STORAGE(newlist);

}



void
do_raxpby(Iaf, nsize, list, xvec,
          dalpha, dbeta)

int Iaf, nsize, *list;
float *xvec, dalpha,dbeta;


{



        DECLARE_STORAGE();

        GET_STORAGE(newlist,nsize);

        CONVERT_LIST(newlist,list,nsize);

        do_raxpby_C(Iaf, nsize, newlist, xvec,
                    dalpha, dbeta);

        FREE_STORAGE(newlist);

}



void
do_biaxpby(  Iaf, nsize, idxstart,
		xvec,   alpha, beta )

int Iaf,nsize,idxstart;
int *xvec,  alpha,beta;
{

	/* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
	do_biaxpby_C( Iaf, nsize, idxstart+1, 	xvec,alpha,beta );
}


void
do_bdaxpby(  Iaf, nsize, idxstart,
                xvec,   alpha, beta )

int Iaf,nsize,idxstart;
dfloat *xvec,  alpha,beta;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
 
}


void
do_braxpby(  Iaf, nsize, idxstart,
                xvec,   alpha, beta )

int Iaf,nsize,idxstart;
float *xvec,  alpha,beta;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
         do_braxpby_C( Iaf, nsize, idxstart+1,   xvec,alpha,beta );
}




void do_iaxpbyz( Iaf, nsize, list, xvec, 
		ialpha,ibeta )

int Iaf, nsize, *list;
int *xvec, ialpha,ibeta;
{



	DECLARE_STORAGE();

	GET_STORAGE(newlist,nsize);

	CONVERT_LIST(newlist,list,nsize);

	do_iaxpbyz_C(Iaf, nsize, newlist, xvec,
		    ialpha, ibeta);

	FREE_STORAGE(newlist);

}


void
do_daxpbyz(Iaf, nsize, list, xvec,
          dalpha, dbeta)

int Iaf, nsize, *list;
dfloat *xvec, dalpha,dbeta;
{



        DECLARE_STORAGE();

        GET_STORAGE(newlist,nsize);

        CONVERT_LIST(newlist,list,nsize);

        do_daxpbyz_C(Iaf, nsize, newlist, xvec,
                    dalpha, dbeta);

        FREE_STORAGE(newlist);

}



void
do_raxpbyz(Iaf, nsize, list, xvec,
          dalpha, dbeta)

int Iaf, nsize, *list;
float *xvec, dalpha,dbeta;


{



        DECLARE_STORAGE();

        GET_STORAGE(newlist,nsize);

        CONVERT_LIST(newlist,list,nsize);

        do_raxpbyz_C(Iaf, nsize, newlist, xvec,
                    dalpha, dbeta);

        FREE_STORAGE(newlist);

}



void
do_biaxpbyz(  Iaf, nsize, idxstart,
		xvec,   alpha, beta )

int Iaf,nsize,idxstart;
int *xvec,  alpha,beta;
{

	/* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
	do_biaxpbyz_C( Iaf, nsize, idxstart+1, 	xvec,alpha,beta );
}


void
do_bdaxpbyz(  Iaf, nsize, idxstart,
                xvec,   alpha, beta )

int Iaf,nsize,idxstart;
dfloat *xvec,  alpha,beta;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
 
}


void
do_braxpbyz(  Iaf, nsize, idxstart,
                xvec,   alpha, beta )

int Iaf,nsize,idxstart;
float *xvec,  alpha,beta;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
         do_braxpbyz_C( Iaf, nsize, idxstart+1,   xvec,alpha,beta );
}





void
do_gather( Iaf, nsize, list,     xvec )
int Iaf,nsize, *list;
void *xvec;
{

	DECLARE_STORAGE();

	GET_STORAGE(newlist,nsize);

	CONVERT_LIST(newlist,list,nsize );

	do_gather_C( Iaf, nsize, newlist, xvec );


	FREE_STORAGE(newlist);
}


void
do_scatter( Iaf, nsize, list,     xvec )
int Iaf,nsize, *list;
void *xvec;
{

        DECLARE_STORAGE();

        GET_STORAGE(newlist,nsize);

        CONVERT_LIST(newlist,list,nsize );

	do_scatter_C( Iaf, nsize, newlist, xvec );



        FREE_STORAGE(newlist);
}



void
do_bgather( Iaf, nsize, idxstart,  xvec )
int Iaf, nsize, idxstart;
void *xvec;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
	do_bgather_C( Iaf, nsize, idxstart+1,   xvec );
}



void
do_bscatter( Iaf, nsize, idxstart,  xvec )
int Iaf, nsize, idxstart;
void *xvec;
{

        /* convert from C [0:(nsize-1)] to Fortran [1:nsize]  */
        do_bscatter_C( Iaf, nsize, idxstart+1,   xvec );
}


