/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/



/*
 * PVM version 3.3:  Parallel Virtual Machine System University of Tennessee,
 * Knoxville TN. Oak Ridge National Laboratory, Oak Ridge TN. Emory
 * University, Atlanta GA. Authors:  A. L. Beguelin, J. J. Dongarra, G. A.
 * Geist, W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam (C)
 * 1992 All Rights Reserved
 * 
 * NOTICE
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted provided
 * that the above copyright notice appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.
 * 
 * Neither the Institutions (Emory University, Oak Ridge National Laboratory,
 * and University of Tennessee) nor the Authors make any representations
 * about the suitability of this software for any purpose.  This software is
 * provided ``as is'' without express or implied warranty.
 * 
 * PVM version 3 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 * bfunc.h
 * 
 * Bcopy/Memcpy patch.
 * 
 */


#if defined(SYSVBFUNC)
#include <memory.h>

#if !defined(BZERO)
#define BZERO(d,n)      memset(d,0,n)
#endif

#if !defined(BCMP)
#define BCMP(s,d,n)     memcmp(d,s,n)
#endif

#if !defined(BCOPY)
#define BCOPY(s,d,n)    memcpy(d,s,n)
#endif

#else

extern void     bzero(char *d, int n);
extern int      bcmp(char *s, char *d, int n);
extern void 
bcopy(char *s, char *d, int n)
#if !defined(BZERO)
#define BZERO(d,n)      bzero(d,n)
#endif

#if !defined(BCMP)
#define BCMP(s,d,n)     bcmp(s,d,n)
#endif

#if !defined(BCOPY)
#define BCOPY(s,d,n)    bcopy(s,d,n)
#endif

#endif
