/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"


#include <stdio.h>
#include <assert.h>

#if !defined(IDEBUG)
/* IDEBUG == 0 for no dynamic run time checking */
#define IDEBUG 0
#endif

#if !defined(MOD)
#define MOD(ix,ibase)  (  (ix) % (ibase) )
#endif

#if !defined(LOGICAL)
#define LOGICAL int
#endif

#if !defined(min)
#define min(ix,iy) ( ( (ix) < (iy) ) ? (ix) : (iy)  )
#endif

#if !defined(max)
#define max(ix,iy) ( ( (ix) > (iy) ) ? (ix) : (iy)  )
#endif


#define index_list(i) ( index_start + (i) )


int
bencode_list(nitems, index_start, segment_size,
	     maxsets, start_list, size_list)
	int             nitems;
	int             index_start;
	int             segment_size;
	int             maxsets;
	int            *start_list;
	int            *size_list;
{

	int             i, j, nsets, jvalue, istart, iend, ifree, ip, nsize,
	                isegment, jsegment, seglimit, imod;

	LOGICAL         is_valid, is_same, is_sameseg, all_done, spaceok;

	int             index_end;

	/* =============== */

	ASSERT(segment_size >= 1, "bencode_list(): segment_size of %d invalid\n",
	       segment_size);
	ASSERT(maxsets >= 1,"bencode_list(): maxsets of %d invalid\n",
	       maxsets);
	ASSERT(start_list != NULL, "bencode_list(): start_list is NULL\n", 0);
	ASSERT(size_list != NULL, "bencode_list(): size_list is NULL\n", 0);

	if (nitems <= 0) {
		return (-1);
	};


	index_end = index_start + (nitems - 1);

	istart = 0;
	ifree = 0;
	nsets = 0;

	for (;;) {

		nsize = 0;


		/* compute segment boundary */

		imod = MOD(index_list(istart), segment_size);
		if (imod == 0) {
			imod = segment_size;
		};

		seglimit = index_list(istart) + (segment_size - imod);

		is_valid = (1 <= seglimit) &&
			(index_list(istart) <= seglimit) &&
			(MOD(seglimit, segment_size) == 0);
		ASSERT(is_valid, "bencode_list(): segment_size of %d invalid\n",
		       segment_size);

		iend = min(seglimit, index_end);
		nsize = (iend - index_list(istart) + 1);


		spaceok = (ifree < maxsets);
		if (!spaceok) {
			return (-1);
		};



		nsets = nsets + 1;

		/*
		 * NOTE: start_list stores the local index into index_list(
		 * istart )
		 */

		start_list[ifree] = istart;
		is_valid = (0 <= istart) && (istart < nitems);
		ASSERT(is_valid, "bencode_list(): istart of %d out of range\n",
		       istart);

		size_list[ifree] = nsize;
		is_valid = (1 <= nsize) && (nsize <= (nitems - istart));
		ASSERT(is_valid, "bencode_list(): nsize of %d out of range\n",
		       nsize);
		ifree = ifree + 1;
		istart = istart + nsize;

		all_done = (istart >= nitems);
		if (all_done) {
			break;
		};
	};



	/* debug-begin */
	if (IDEBUG >= 3) {
		printf("bencode_list[:]\n");
		for (i = 0; i < nsets; i = i + 1) {
			istart = start_list[i];
			nsize = size_list[i];
			printf("i %d, istart %d, index_list( istart ), %d nsize %d \n",
			       i, istart, index_list(istart), nsize);
		};
		printf("\n");
	};
	/* debug-end */


	if (IDEBUG >= 1) {

		/* --------------------------------- */
		/* double check continguous sequence */
		/* --------------------------------- */


		ip = 0;
		for (i = 0; i < nsets; i = i + 1) {

			/*
			 * NOTE: start_list stores the local index into
			 * index_list[*]
			 */

			istart = start_list[i];
			jvalue = index_list(istart);
			nsize = size_list[i];

			for (j = 0; j < nsize; j = j + 1) {

				is_valid = (0 <= ip) && (ip < nitems);
				ASSERT(is_valid, "bencode_list(): ip of %d out of range\n", ip);

				is_same = (index_list(ip) == jvalue);
				if (!is_same) {
					printf("ip %d, index_list( ip ) %d\n", ip, index_list(ip));
					printf("i %d istart %d, nsize %d, jvalue %d\n",
					       i, istart, nsize, jvalue);
				};
				ASSERT(is_same, "bencode_list(): index_list for ip of %d not same\n", ip);

				ip = ip + 1;
				jvalue = jvalue + 1;
			};	/* end for(j) */

		};		/* end for(i) */

	};			/* end if (IDEBUG) */


	if (IDEBUG >= 2) {

		/* ------------------------ */
		/* check if in same segment */
		/* ------------------------ */

		for (i = 0; i < nsets; i = i + 1) {

			istart = start_list[i];
			jvalue = index_list(istart);
			nsize = size_list[i];

			isegment = ((jvalue - 1) / segment_size) + 1;

			for (j = 0; j < nsize; j = j + 1) {

				jsegment = ((jvalue - 1) / segment_size) + 1;
				is_sameseg = (isegment == jsegment);
				ASSERT(is_sameseg, "bencode_list(): isegment and jsegment differ\n", 0);

			};	/* end for(j) */


		};		/* end for(i) */

	};			/* end if (IDEBUG) */


	return (nsets);		/* NOTE: nsets >= 1 */
}
