/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>


#include "globals.h"
#include "wait_block.h"

static int      wait_node_free = 1;


int
allocwait()
{

	int             wait_id, i;
	logical         is_empty, is_valid, found;

	/* allocate a wait_block */


	/*
	 * first find an empty slot, start search from wait_node_free, which
	 * is like a "roving" free pointer
	 */

	wait_id = wait_node_free;
	found = FALSE;
	is_valid = (1 <= wait_id) && (wait_id <= MAX_WAIT_BLOCK);
	ASSERT(is_valid, "allocwait(): wait_id of %d out of range\n", wait_id);

	for (i = 1; i <= MAX_WAIT_BLOCK; i++) {

		if (wait_id > MAX_WAIT_BLOCK) {
			wait_id = 1;
		};

		is_valid = (1 <= wait_id) && (wait_id <= MAX_WAIT_BLOCK);
		ASSERT(is_valid, "allocwait(): wait_id of %d out of range\n",
		       wait_id);

		found = (Gwait_node_array[wait_id] == NULL);
		if (found) {
			break;
		};

		wait_id += 1;
	};			/* end for */

	if (found) {
		wait_node_free = wait_id + 1;
		if (wait_node_free > MAX_WAIT_BLOCK) {
			wait_node_free = 1;
		};
	} else {

		printf("Too many outstanding gather requests on node %d wait_id %d\n",
		       myid, wait_id);

		printf("Maximum is only %d \n", MAX_WAIT_BLOCK);
		printf("Use do_wait to satisfy outstanding requests \n");
		ASSERT(FALSE,"allocwait(): abort\n", 0); /* abort */
	};

	is_valid = (1 <= wait_id) && (wait_id <= MAX_WAIT_BLOCK);
	ASSERT(is_valid, "allocwait(): wait_id of %d out of range\n", wait_id);

	is_empty = (Gwait_node_array[wait_id] == NULL);
	ASSERT(is_empty, "allocwait(): wait_id %d references null entry\n",
	       wait_id);

	return (wait_id);
}
