/*
*				tri3ddefs.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Three dimensional specific tetrazation functions.
*/

#if !defined(_TRI3DDEFS_H)
#define _TRI3DDEFS_H
#if defined(THREED)

#include <tri/trilocaldecs.h>

typedef struct {
	LINEAR_ELEMENT	el;
	float		D,DN[3];
	bool		coplanar;
} TETRA;

typedef struct {
	TG_PT		*vertex[3];
	Locstate        state[3];
	float		norm[3];
} FACE;

typedef struct {
	TG_PT		*ends[2];
} LINE;

typedef struct {
	FACE 	*faces;
	int 	num_faces;
} HULL;

	/* BLK_BIN--Used to store points, comps and states  */
	/* before making tetrahedrals.			    */

struct _BLK_BIN {
	int num_els;
	TG_PT **el_list;
	COMPONENT *pos_comp, *neg_comp;
	Locstate *pos_st, *neg_st;
};
typedef struct _BLK_BIN BLK_BIN;

struct	_PT_ST {
	TG_PT		*pt;
	Locstate	st;
	float		dist;
};
typedef struct _PT_ST PT_ST;

typedef struct {
	float 		coords[4];
	POINT 		*vertex;
	POINT		*edge[2];
} CRX_STORE;

/* Prototypes */
IMPORT	int	count_num_pcs3d(TRI_GRID*);
IMPORT	int	max_num_3d_lin_els(INTERFACE*);
IMPORT	void	set_seg_index3d_globals(const int*);

#endif /* defined(THREED) */
#endif /* !defined(_TRI3DDEFS_H) */
