/*
*
*
*
* 		ixgraph.c
*
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	J. D. Pinezich
*
*
*/

#if defined(THREED)

#include <intfc/iloc.h>

LOCAL   void    xgraph_surface_tris(const char*,const char*,SURFACE*,
				    const COORDINATE_PLANE);
LOCAL   void 	xgraph_grid(const char*,RECT_GRID*,
			    const COORDINATE_PLANE);
LOCAL   void 	xgraph_curve_file(const char*,const char*,CURVE*,
				  const COORDINATE_PLANE);

EXPORT 	void	xgraph_interface_surfaces(
	const char             *dname,
	const char             *fname,
	INTERFACE 	       *intfc,
	const COORDINATE_PLANE proj)
{
  	SURFACE **s;
	int 	i = 0;
	char 	sname[256];

	if (intfc->dim < 3)
	{
	    return;
	}

	s = intfc->surfaces;
	for ( ; s && *s; s++, i++)
        {
	    (void) sprintf(sname,"%s_surf%d",fname,i);
	    xgraph_surface_tris(dname,sname,*s,proj);
	}
}		/*end xgraph_interface_surfaces*/

EXPORT 	FILE 	*xgraph_file_open(
	const char             *dname,
	const char             *fname,
	const COORDINATE_PLANE proj)
{
	FILE	   *xgraph;
	char	   path[256];
	static const char *x_axis[3] = {"Y-axis","X-axis","X-axis"};
	static const char *y_axis[3] = {"Z-axis","Z-axis","Y-axis"};

	if (create_directory(dname,YES) == FUNCTION_FAILED)
	{
	    screen("WARNING in xgraph_file_open(),",
		   "directory %s doesn't exist and can't be created.\n",dname);
	    clean_up(ERROR);
	}
	(void) sprintf(path,"%s/%s.xg",dname,fname);
	xgraph = fopen(path,"w");
	(void) fprintf(xgraph,"TitleText: %s\n",path);
	(void) fprintf(xgraph,"LargePixels: 1\n");
	(void) fprintf(xgraph,"Background: white\n");
	(void) fprintf(xgraph,"XUnitText: %s\n",x_axis[proj]);
	(void) fprintf(xgraph,"YUnitText: %s\n\n",y_axis[proj]);
	return xgraph;
}		/*end xgraph_file_open*/

EXPORT 	void 	xgraph_tris_list(
	FILE 	               *file,
	TRI 	               **tris,
	int 	               num_tris,
	const COORDINATE_PLANE proj)
{
	int i;

	for (i = 0; i < num_tris; i++)
	    xgraph_tri(file,tris[i],proj);
	(void) printf("xgraph_tris_list()-->%d triangles written\n",i);
}		/*end xgraph_tris_list*/

EXPORT 	void 	xgraph_tri(
	FILE 	               *file,
	TRI 	               *tri,
	const COORDINATE_PLANE proj)
{
	int i,j;

	(void) fprintf(file,"move ");
	for (i = 0; i < 4; i++)
	{
	    for (j = 0; j < 3; j++)
	    {
		if (j != proj)
		    (void) fprintf(file,"%g ",Coords(Point_of_tri(tri)[i%3])[j]);
	    }
	    (void) fprintf(file,"\n");
	}
}		/*end xgraph_tri*/

LOCAL  	void 	xgraph_surface_tris(
	const char             *dname,
	const char             *fname,
	SURFACE	               *surf,
	const COORDINATE_PLANE proj)
{
  	TRI 	*t;
	FILE	*xgraph;
	int	i,j,num = 0;
	char	path[256];

	if (create_directory(dname,YES) == FUNCTION_FAILED)
	{
	    screen("WARNING in xgraph_surface_tris(), ",
		   "directory %s doesn't exist and can't be created.\n",dname);
	    return;
	}

	(void) sprintf(path,"%s/%s.xg",dname,fname);
	xgraph = fopen(path,"w");
	(void) fprintf(xgraph,"\"%s\"\n",fname);
	for (t = surf->_First_tri.tri.next; num < surf->num_tri;
	     t = t->next,num++)
	{
	    (void) fprintf(xgraph,"move ");
	    for (i = 0; i < 4; i++)
	    {
	        for (j = 0; j < 3; j++)
		{
		    if (j != proj)
		        (void) fprintf(xgraph,"%g ",
				       Coords(Point_of_tri(t)[ i%3 ])[j]);
		}
		(void) fprintf(xgraph,"\n");
	    }
	}
	fclose(xgraph);
} 		/*end xgraph_surface_tris*/

EXPORT 	void 	xgraph_new_data_set(
	FILE 	*file)
{
  	(void) fprintf(file,"\n"); /* Provides more colors in xgraph display */
}		/*end xgraph_new_data_set*/

EXPORT 	void 	xgraph_point(
	FILE 	               *file,
	float 	               *p,
	const COORDINATE_PLANE proj,
	const char 	       *name)
{
	int j,k;
	if (name != "")
	{
	    (void) fprintf(file,"\"%s\"\n",name);
	}
	(void) fprintf(file,"move ");
	for (k = 0; k < 2; k++)
	{
	    for (j = 0; j < 3; j++)
            {
		if (j != proj)
		    (void) fprintf(file,"%g ",p[j]);
	    }
	    (void) fprintf(file,"\n");
	}
}		/*end xgraph_point*/

EXPORT 	void 	xgraph_affine_vector(
	FILE 	               *file,
	float 	               *start,
	float 	               *v,
	const COORDINATE_PLANE proj,
	const char 	       *msg)
{
	int j,k;
	if (msg != "") (void) fprintf(file,"\"%s\"\n",msg);
	(void) fprintf(file,"move ");
	for (k = 0; k < 2; k++)
	{
	    for (j = 0; j < 3; j++)
	    {
		if (j != proj)
		    (void) fprintf(file,"%g ",start[j]);
	    }
	    (void) fprintf(file,"\n");
	}
	for (k = 0; k < 2; k++)
        {
	    for (j = 0; j < 3; j++)
            {
		if (j != proj)
		    (void) fprintf(file,"%g ",start[j]+v[j]);
	    }
	    (void) fprintf(file,"\n");
	}
}		/*end xgraph_affine_vector*/

EXPORT 	void 	xgraph_line_segment(
	FILE 	               *file,
	float 	               *start,
	float 	               *end,
	const COORDINATE_PLANE proj,
	const char 	       *msg)
{
	int j,k;
	if (msg != "")
	    (void) fprintf(file,"\"%s\"\n",msg);
	(void) fprintf(file,"move ");
	for (k = 0; k < 2; k++)
        {
	    for (j = 0; j < 3; j++)
            {
		if (j != proj)
		    (void) fprintf(file,"%g ",start[j]);
            }
	    (void) fprintf(file,"\n");
        }
	for (k = 0; k < 2; k++)
        {
	    for (j = 0; j < 3; j++)
            {
		if (j != proj)
		    (void) fprintf(file,"%g ",end[j]);
            }
	    (void) fprintf(file,"\n");
	}
}		/*end xgraph_line_segment*/

EXPORT 	void	xgraph_interface_nodes(
	const char             *dname,
	const char             *fname,
	INTERFACE 	       *intfc,
	const COORDINATE_PLANE proj)
{
  	NODE 	**n;
	int 	i=0,j,k;
	char 	path[256];
	FILE 	*xgraph;

	if (create_directory(dname,YES) == FUNCTION_FAILED)
	{
	    screen("WARNING in xgraph_interface_nodes(),"
		   "directory %s doesn't exist and can't be created\n",dname);
	    return;
        }

	(void) sprintf(path,"%s/%s_nodes.xg",dname,fname);
	xgraph = fopen(path,"w");
	(void) fprintf(xgraph,"\"%s\"\n",fname);

	for (n = intfc->nodes; n && *n; n++,i++)
	{
	    (void) fprintf(xgraph,"move ");
	    for (k = 0; k < 2; k++)
	    {
		for (j = 0; j < 3; j++)
		{
		    if (j != proj)
		        (void) fprintf(xgraph,"%g ",Coords((*n)->posn)[j]);
	        }
		(void) fprintf(xgraph,"\n");
	    }
	}
	(void) fprintf(xgraph,"\n");
}		/*end xgraph_interface_nodes*/

EXPORT  void 	xgraph_interface_curves(
	const char             *dname,
	const char             *fname,
	INTERFACE 	       *intfc,
	const COORDINATE_PLANE proj)
{
  	CURVE 	**c;
	int 	i=0;
	char 	sname[256];

	for (c = intfc->curves; c && *c; c++,i++)
        {
	    (void) sprintf(sname,"%s_curv%d",fname,i);
	    xgraph_curve_file(dname,sname,*c,proj);
	}
}		/*end xgraph_interface_curves*/

LOCAL  	void 	xgraph_curve_file(
	const char             *dname,
	const char             *fname,
	CURVE 	               *c,
	const COORDINATE_PLANE proj)
{
  	BOND 	*b;
	POINT	*start,*end;
  	FILE	*xgraph;
	int	j;
	char	path[256];

	if (create_directory(dname,YES) == FUNCTION_FAILED)
	{
	    screen("WARNING in xgraph_curve_file(),"
		   "directory %s doesn't exist and can't be created.\n",dname);
	    return;
	}

	(void) sprintf(path,"%s/%s.xg",dname,fname);

	xgraph = fopen(path,"w");
	(void) fprintf(xgraph,"\"%s\"\n",fname);

	start = c->start->posn;
	for (j = 0; j < 3; j++)
        {
	    if (j != proj)
	        (void) fprintf(xgraph,"%g ",Coords(start)[j]);
	}
	(void) fprintf(xgraph,"\n");

	for (b = c->first; b != c->last; b = b->next)
        {
	    for (j = 0; j < 3; j++)
            {
		if (j != proj)
		    (void) fprintf(xgraph,"%g ",Coords(b->end)[j]);
	    }
	    (void) fprintf(xgraph,"\n");
	}

	end = c->end->posn;
	for (j = 0; j < 3; j++)
	{
	    if (j != proj)
	        (void) fprintf(xgraph,"%g ",Coords(end)[j]);
	}
	(void) fprintf(xgraph,"\n\n");
	fclose(xgraph);
}		/*end xgraph_curve_file*/

EXPORT 	void 	xgraph_curve(
	FILE 	               *file,
	CURVE 	               *c,
	const COORDINATE_PLANE proj)
{
  	BOND 	*b;
	POINT	*start,*end;
	int	j;


	start = c->start->posn;
	for (j = 0; j < 3; j++)
	{
	    if (j != proj)
	        (void) fprintf(file,"%g ",Coords(start)[j]);
	}
	(void) fprintf(file,"\n");

	for (b = c->first; b != c->last; b = b->next)
        {
	    for (j = 0; j < 3; j++)
	    {
		if (j != proj)
		    (void) fprintf(file,"%g ",Coords(b->end)[j]);
	    }
	    (void) fprintf(file,"\n");
	}

	end = c->end->posn;
	for (j = 0; j < 3; j++)
        {
	    if (j != proj)
	        (void) fprintf(file,"%g ",Coords(end)[j]);
	}
	(void) fprintf(file,"\n\n");
}		/*end xgraph_curve*/

EXPORT 	void 	xgraph_RECT_GRID(
	const char *dname,
	RECT_GRID  *rect_grid)
{
 	char fname[100];

	if (create_directory(dname,YES) == FUNCTION_FAILED)
        {
	    screen("WARNING in xgraph_RECT_GRID(),"
		   "directory %s doesn't exist and can't be created.\n",dname);
	    return;
	}
	(void) sprintf(fname,"%s/XY",dname);
	xgraph_grid(fname,rect_grid,XY_PLANE);

	if (rect_grid->dim > 2)
	    return;
	(void) sprintf(fname,"%s/YZ",dname);
	xgraph_grid(fname,rect_grid,YZ_PLANE);
	(void) sprintf(fname,"%s/XZ",dname);
	xgraph_grid(fname,rect_grid,XZ_PLANE);
}		/*end xgraph_RECT_GRID*/

LOCAL  	void 	xgraph_grid(
	const char 	       *fname,
	RECT_GRID 	       *grid,
	const COORDINATE_PLANE proj)
{
  	int	   i,j;
	FILE	   *xgraph;
	float	   x_l,x_u,y_l,y_u,x,y;
	int	   x_n,y_n;
	float	   delta;
	int	   map[3][2] = {{1,2},
			        {0,2},
			        {0,1}};
	char	   file[100],tag[100];
	static const char *x_axis[3] = {"Y-axis","X-axis","X-axis"};
	static const char *y_axis[3] = {"Z-axis","Z-axis","Y-axis"};

	for (i = 0; i < 2; i++)
	{
	    if (i == 0)
	    {
	        (void) sprintf(file,"%s_REAL.xg",fname);
		(void) sprintf(tag,"REAL");
		x_u = grid->U[map[proj][0]];
		x_l = grid->L[map[proj][0]];
		x_n = grid->gmax[map[proj][0]];
		y_u = grid->U[map[proj][1]];
		y_l = grid->L[map[proj][1]];
		y_n = grid->gmax[map[proj][1]];
	    }
	    else
	    {
	        (void) sprintf(file,"%s_VIRT.xg",fname);
		(void) sprintf(tag,"VIRT");
		x_u = grid->VU[map[proj][0]];
		x_l = grid->VL[map[proj][0]];
		x_n = grid->gmax[map[proj][0]]+
		    grid->lbuf[map[proj][0]]+
		    grid->ubuf[map[proj][0]];
		y_u = grid->VU[map[proj][1]];
		y_l = grid->VL[map[proj][1]];
		y_n = grid->gmax[map[proj][1]]+
		    grid->lbuf[map[proj][1]]+
		    grid->ubuf[map[proj][1]];
	    }

	    xgraph = fopen(file,"w");
	    (void) fprintf(xgraph,"TitleText: %s\n",fname);
	    (void) fprintf(xgraph,"LargePixels: 1\n");
	    (void) fprintf(xgraph,"Background: white\n");
	    (void) fprintf(xgraph,"XUnitText: %s\n",x_axis[proj]);
	    (void) fprintf(xgraph,"YUnitText: %s\n",y_axis[proj]);
	    (void) fprintf(xgraph,"\"%s\"\n",tag);

	    delta = (x_u-x_l)/x_n;
	    for (j = 0; j <= x_n; j++)
	    {
	        x = x_l+j*delta;
		(void) fprintf(xgraph,"move %g %g\n     %g %g\n",x,y_l,x,y_u);
	    }
	    delta = (y_u-y_l)/y_n;
	    for (j = 0; j <= y_n; j++)
	    {
	        y = y_l+j*delta;
		(void) fprintf(xgraph,"move %g %g\n     %g %g\n",x_l,y,x_u,y);
	    }
	    fclose(xgraph);
	}
}		/*end xgraph_grid*/
#endif /* defined(THREED) */
