/*
*                               intfc_amr.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*
*       User definable hooks to the interface library.
*
*       IMPORTANT NOTE: All of the i_user_... functions below are NO-OP
*       functions, i.e. they perform no operations.  These hooks are
*       simply default place holders for the interface hook functions.
*       The reason these functions are NO-OPs is that any operation they
*       perform would be meaningful at the intfc library level and so should
*       properly be included in the actual operation function rather than
*       the user hook function.
*/




#include <intfc/iloc.h>

#if defined(USE_OVERTURE)

EXPORT void set_amr_intfc_tol(
	INTERFACE     *intfc,
	float         coeff)
{
        int           dim = intfc->dim;

        switch(dim)
        {
        case 2:
            /*  
            InterfaceTolerances(intfc)._Parallel; 
            */  
            InterfaceTolerances(intfc)._Min_sin_sqr *= coeff; 
            InterfaceTolerances(intfc)._MinScaledSeparation *= coeff;
            InterfaceTolerances(intfc)._MinScaledLength *= coeff;
            InterfaceTolerances(intfc)._EndOfCurve = 1.0 - 
                      InterfaceTolerances(intfc)._MinScaledSeparation;
            InterfaceTolerances(intfc)._StartOfCurve = 
                      InterfaceTolerances(intfc)._MinScaledSeparation; 
            InterfaceTolerances(intfc)._TolFac = 32.0; 
            InterfaceTolerances(intfc)._RcbMinScaledSep = 
                      InterfaceTolerances(intfc)._MinScaledLength;
            InterfaceTolerances(intfc)._RobustFac *= coeff;
            InterfaceTolerances(intfc)._RcbMacTol = 1.0e-5; 
            InterfaceTolerances(intfc)._RcbcRobustFac = 
                      InterfaceTolerances(intfc)._MinScaledLength; 
            InterfaceTolerances(intfc)._ReflectTol *= coeff; 
            /* 
            InterfaceTolerances(intfc)._ShortCurveNumPoints; 
            */  
        break; 
        }
}

EXPORT void print_rect_componentgrid(
        Rect_ComponentGrid  component_grid)
{
        printf("Component_grid[%d], level[%d]\n", component_grid.grid_id,
                        component_grid.grid_level);

        if(component_grid.dim == 2)
        {
            printf("X dir indexRange base, bond[%d,%d]\n", component_grid.base[0],
                          component_grid.bound[0]);
            printf("Y dir indexRange base, bond[%d,%d]\n", component_grid.base[1],
                          component_grid.bound[1]);
            printf("L[%g, %g], U[%g, %g], h[%g, %g]\n", component_grid.L[0],
                         component_grid.L[1], component_grid.U[0],
                         component_grid.U[1], component_grid.h[0],
                         component_grid.h[1]);
        }
        else if(component_grid.dim == 3)
        {
            printf("X dir indexRange base, bond[%d,%d]\n", component_grid.base[0],
                          component_grid.bound[0]);
            printf("Y dir indexRange base, bond[%d,%d]\n", component_grid.base[1],
                          component_grid.bound[1]);
            printf("Z dir indexRange base, bond[%d,%d]\n", component_grid.base[2],
                          component_grid.bound[2]);
            printf("L[%g, %g, %g], U[%g, %g, %g], h[%g, %g, %g]\n",
                         component_grid.L[0], component_grid.L[1], component_grid.L[2],
                         component_grid.U[0], component_grid.U[1], component_grid.U[2],
                         component_grid.h[0], component_grid.h[1], component_grid.h[2]);
        }
}

EXPORT int box_intersect(
        int           *L1,
        int           *U1,
        int           *L2,
        int           *U2,
        int           dim,
        int           *rL,
        int           *rU)
{
        int           j;
        int           size;
        for(j = 0; j < dim; j++)
        {
            rL[j] = max(L1[j], L2[j]);
            rU[j] = min(U1[j], U2[j]);
            if(rL[j] >= rU[j])
                    rL[j] = rU[j] = 0;
        }
        size = 1;
        for(j = 0; j < dim; j++)
            size *= (rU[j] - rL[j]);

        if(size != 0)
            return YES;
        else
            return NO;
}

EXPORT Trans_box *add_to_box(
        int          *L,
        int          *U,
        int          dim,
        Trans_box    *box,
        int          *nbox,
        int          *alloc)
{
        Trans_box  *tmpbox;
        int          i;

        if(box == NULL)
        {
            *alloc = 10;
            vector(&tmpbox, *alloc, sizeof(Trans_box));
            *nbox = 0;
            for(i = 0; i < dim; i++)
            {
                tmpbox[*nbox].base[i] = L[i];
                tmpbox[*nbox].bound[i] = U[i];
            }
            (*nbox)++;
            return tmpbox;
        }

        if(*nbox == *alloc)
        {
            *alloc += 10;
            vector(&tmpbox, *alloc, sizeof(Trans_box));
            for(i = 0; i < *nbox; i++)
                assign(&tmpbox[i], &box[i], sizeof(Trans_box));
            free(box);
            box = tmpbox;
        }
        for(i = 0; i < dim; i++)
        {
            box[*nbox].base[i] = L[i];
            box[*nbox].bound[i] = U[i];
        }
        (*nbox)++;
        return box;
}

EXPORT int box_in_boxes(
        int          *L,
        int          *U,
        Trans_box    *Tbox,
        int          nbox,
        int          dim)
{
        int     ix, iy, ic[MAXD];

        for(iy = L[1]; iy < U[1]; iy++)
        {
            for(ix = L[0]; ix < U[0]; ix++)
            {
                ic[0] = ix; ic[1] = iy;
                if(! point_in_boxes(ic,Tbox,nbox,dim))
                {
                    return NO;
                }
            }
        }
        return YES;
}

EXPORT int point_in_boxes(
        int          *ic,
        Trans_box  *avgbox,
        int          nbox,
        int          dim)
{

        int          i;
        for(i = 0; i < nbox; i++)
        {
            if(ic[0] >= avgbox[i].base[0] &&
               ic[0] <  avgbox[i].bound[0] &&
               ic[1] >= avgbox[i].base[1] &&
               ic[1] <  avgbox[i].bound[1])
            return YES;
        }
        return NO;
}


#endif /* if defined(USE_OVERTURE) */

