/*
*				hamrscatter.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#define DEBUG_STRING "hamrscatter"

#include <hyp/hlocaldecs.h>

#if defined(USE_OVERTURE)

LOCAL void     set_recv_domain(int*,int*,int*,int,int,int,Wv_on_pc);
LOCAL void     set_search_domain(int*,int*,int*,int,int,Wv_on_pc,int);
LOCAL void     domain_to_glb_indx(int*,int*,int,Wv_on_pc,int,int*,int*);
LOCAL int      **count_recv_intrp_on_wvs(int*,Amr_intrp_set*,int,int*); 
LOCAL int      count_recv_num_intrp_on_wv(int*,Amr_intrp_set*,int,int**,int);
LOCAL int      **count_send_intrp_on_wv(int*,Amr_intrp_set*,int,int*); 
LOCAL void     lic_to_glb_indx(int*,Wv_on_pc,int*,int); 
LOCAL void     gic_to_loc_indx(int*,Wv_on_pc,int*,int); 
LOCAL void     gic_to_level_indx(int*,int,int,int,int*,int); 
LOCAL void     gic_crds(RECT_GRID*,Wv_on_pc**,int*,int*,int*,int,float*);
LOCAL void     aloc_intrp_cps_storage(Intrp_cps*,size_t); 
LOCAL void     bundle_blk_cst(PP_cps*,Intrp_cps*,Wave*);
LOCAL void     unbundle_blk_cst(PP_cps*,Intrp_cps*,Wave*);

LOCAL PP_cps   *collect_recv_blks_on_level(int,int,PP_cps**,Front**,
                    int,Wv_on_pc**,int,int,int*,Amr_intrp_set*,int);
LOCAL void     blk_cst_to_wave(Wave*,Front*,Intrp_cps*,int*,int*,
                   Amr_intrp_set*,int);
LOCAL PP_cps   *collect_recv_intrp_blks_on_level(int,PP_cps**,Front**,int,
                 Wv_on_pc**,int,Amr_intrp_set*,int,int,int*); 
LOCAL void     free_wv_recv_intrp_blks(PP_cps**,Amr_intrp_set*,int,Front**,int,
                  Wv_on_pc**,int); 

/* LOCAL functions for averaging fine to coarse states */
LOCAL int      count_get_avg_patches_at_level(int,int,Front**,int,Wv_on_pc**,
                  int,Overparam*,Amr_avg_set**);
LOCAL int      count_snd_avg_patches_at_level(int,int,Front**,int,Wv_on_pc**,
                  int,Overparam*,Amr_avg_set**);
LOCAL void     set_get_avg_patch_ptset(Amr_avg_set*,Wv_on_pc**,int,
                  Overparam*,int);
LOCAL void     set_snd_avg_patch_ptset(Amr_avg_set*,Wv_on_pc**,int,
                  Overparam*,int);
LOCAL int      pt_get_avg_from_nxt_level(int*,int*,int,int,Overparam*,
                  Wv_on_pc**,int,int*);
LOCAL int      pt_snd_avg_to_prv_level(int*,int*,int,int,Overparam*,
                  Wv_on_pc**,int,int*);
LOCAL void     glb_coarsen_patch(Wv_on_pc,int,int,int*,int*); 
LOCAL void     glb_refine_patch(Wv_on_pc,int,int,int*,int*);
LOCAL Intrp_cps **coarse_post_comp_to_fine(Wave**,Front**,int,
                  Wv_on_pc**,int,Overparam*,Amr_avg_set*,int,
                  Amr_avg_set*,int);
LOCAL int      patch_has_child(int*,Wv_on_pc**,int,int,int); 
LOCAL void     assign_snd_wv_comp(Wave*,Wv_on_pc,Trans_box*,Intrp_cps*); 
LOCAL void     bundle_blk_c(PP_cps*,Intrp_cps*); 
LOCAL void     unbundle_blk_c(PP_cps*,Intrp_cps*);
LOCAL PP_cps   *match_loc_comp_blk(int*,int*,PP_cps**,Amr_avg_set*,int); 
LOCAL PP_cps   *collect_recv_comp_blks(int*,Wv_on_pc**,int,PP_cps**,
                   Amr_avg_set*,int); 
LOCAL void     recv_comp_to_intrp_blks(Intrp_cps**,PP_cps**,Amr_avg_set*,int); 
LOCAL void     perform_average_fine_state_on_level(int,Wave**,Front**,
                   int,Wv_on_pc**,int,Overparam*,Amr_avg_set*,int,Intrp_cps**); 
LOCAL void     assign_avg_st_to_blk(Wave*,Front*,Intrp_cps*,Trans_box*,Wv_on_pc,int);
LOCAL void     coarse_recv_avg_st_from_fine(int,Wave**,Front**,int,Wv_on_pc**,int,
                 Overparam*,Amr_avg_set*,int,Amr_avg_set*,int,Intrp_cps**); 
LOCAL void     assign_recv_avg_to_wv(int,Wave**,Front**,int,Wv_on_pc**,int,
                 Overparam*,Amr_avg_set*,int,PP_cps*,int); 
LOCAL void     avg_state_to_wave(PP_cps*,Front*,Wave*,Wv_on_pc,Trans_box*); 


/* New scatter function calles */
LOCAL int      set_recv_scatter_patch_in_dir(Front**,int,Overparam*,Wv_on_pc**,int,
                    int*,int,Amr_intrp_set**);
LOCAL Amr_intrp_set *buf_scattered_by_patches_in_dir(int*,int,int*,int,int,int,
                       Wv_on_pc**,int,PP_GRID*,Overparam*); 

LOCAL int      set_send_scatter_patch_in_dir(Front**,int,Overparam*,Wv_on_pc**,int,
                    int*,int,Amr_intrp_set**);
LOCAL Amr_intrp_set  *scatter_patch_in_dir_domain(int*,int,int*,int,int,
                        Wv_on_pc**,int,PP_GRID*,Overparam*); 
LOCAL void     patch_scat_buf_in_dir(int*,int*,int*,int,int,Wv_on_pc**,int,int*); 
LOCAL int      patch2_is_patch1_child(int*,int*,Wv_on_pc**,int,int,int);
LOCAL Amr_intrp_pt   *add_box_to_intrp_set(int*,int*,Amr_intrp_pt*,
                         int*,int*,int);
LOCAL void     scatter_nxt_fpatch_in_dir_domain(Amr_intrp_set**,int*,int*,int,
                   int*,int,int,Wv_on_pc**,int,Overparam*,PP_GRID*); 
LOCAL int      buf_scatter_by_coarse_in_dir(Amr_intrp_set**,int*,int*,int,int*,
                  int,int,int,Wv_on_pc**,int,Overparam*,PP_GRID*); 
LOCAL void     add_pts_to_intrp_set(Amr_intrp_pt**,int*,int*,int*,
                  int*,Trans_box*,int,int,int*);
LOCAL int      **count_wave_send_intrp(int*,Amr_intrp_set*,int,int*); 
LOCAL int      count_wave_send_num_intrp(int*,Amr_intrp_set*,int,int**,int);
LOCAL void     copy_same_l_snd_val(Intrp_cps*,Wave*,Front*,int*,Amr_intrp_set*,
                  int,int**,int,Wv_on_pc**);
LOCAL void     wave_snd_intrp_buf_blks_at_lev_to_nxt(int,Front**,Wave**,int,
                  Wv_on_pc**,int,Overparam*,Amr_intrp_set*,int,PP_cps***); 
LOCAL void     intrp_snd_c_t_f_set(Intrp_cps*,Wave*,Front*,int*,
                  Amr_intrp_set*,int,int**,int,Wv_on_pc**,int);
LOCAL void     wait_and_free_all_snd_blks(PP_cps***,Amr_intrp_set*,int,
                  Front**,int,Wv_on_pc**,int);
LOCAL void     perform_recv_slevel_buf_blks(Front**,Wave**,int,Wv_on_pc**,int,
                  PP_cps**,PP_cps**,Amr_intrp_set*,int,Amr_intrp_set*,int);
LOCAL PP_cps   find_match_loc_snd_blk(PP_cps*,PP_cps**,Amr_intrp_set*,int,
                  Wv_on_pc**,Front**,int); 
LOCAL void     wave_rcv_intrp_buf_blks_at_lev_from_prev(int,Front**,Wave**,int,
                  Wv_on_pc**,int,Overparam*,Amr_intrp_set*,int,
                  Amr_intrp_set*,int,PP_cps**,PP_cps**); 

/*  unsplitting buffer intrp functions */
LOCAL int      get_grid_buf_blk(Wv_on_pc,int,int,int*,int*); 

LOCAL void     set_grid_valid_domain(Wv_on_pc,int,int*,int*,int); 

LOCAL int      set_recv_scatter_patch(Front**,int,Overparam*,Wv_on_pc**,
                   int,Amr_intrp_set**); 
LOCAL Amr_intrp_set *bufblk_scattered_by_patches(int,Front*,int*,Wv_on_pc**,int,
                        Overparam*); 
LOCAL int      set_send_scatter_patch(Front**,int,Overparam*,Wv_on_pc**,int,
                     Amr_intrp_set**); 
LOCAL Amr_intrp_set  *scatter_patch_blk_in_domain(int*,int,int,Wv_on_pc**,int,
                        PP_GRID*,Overparam*); 
LOCAL int      scatter_nxt_fpatch_in_domain(Amr_intrp_set**,int*,int*,int,int,
                  Wv_on_pc**,int,Overparam*,PP_GRID*); 
LOCAL void     perform_wave_intrp_buf_blks(Front**,Wave**,int,Overparam*,Wv_on_pc**,int,
                  PP_cps**,Amr_intrp_set*,int,Amr_intrp_set*,int);


LOCAL void gic_crds(
        RECT_GRID *rect,
        Wv_on_pc **redistr_table,
        int      *rectit,
        int      *gicit,
        int      *gic,
        int      refineratio,
        float    *crds)
{
        int      i, dim = rect->dim;
        float    *L = rect->L, *h = rect->h;
        float    rectgL[MAXD], pth[MAXD]; 
        int      rectlevel, ptlevel, refine; 
      
        rectlevel = redistr_table[rectit[0]][rectit[1]].wv_level;
        ptlevel = redistr_table[gicit[0]][gicit[1]].wv_level;

        refine = 1;
        if(rectlevel > ptlevel)
        {
            for(i = ptlevel; i < rectlevel; i++)
                refine *= refineratio; 
            for(i = 0; i < dim; i++)
                pth[i] = h[i]*refine; 
        }
        else
        {
            for(i = rectlevel; i < ptlevel; i++)
                refine *= refineratio; 
            for(i = 0; i < dim; i++)
                pth[i] = h[i]/refine; 
        }

        for(i = 0; i < dim; i++)
        {
            rectgL[i] = L[i] - 
                 h[i]*(redistr_table[rectit[0]][rectit[1]].off_set[i] +
                       redistr_table[rectit[0]][rectit[1]].base[i]); 
        }

        for(i = 0; i < dim; i++)
            crds[i] = rectgL[i] + gic[i]*pth[i] + 0.5*pth[i]; 
}
   

LOCAL void lic_to_glb_indx(
        int      *ic,
        Wv_on_pc redistr_table,
        int      *gic,
        int      dim)
{
        int      j;
        for(j = 0; j < dim; j++)
        {
            gic[j] = ic[j] + redistr_table.off_set[j] 
                           + redistr_table.base[j]; 
        }
} 

LOCAL void gic_to_loc_indx(
        int      *gic,
        Wv_on_pc redistr_table,
        int      *lic,
        int      dim)
{
        int      j;
        for(j = 0; j < dim; j++)
        {
            lic[j] = gic[j] - redistr_table.off_set[j] 
                           - redistr_table.base[j]; 
        }
} 

LOCAL void gic_to_level_indx(
        int      *gic,
        int      level,
        int      itlevel,
        int      refineratio,
        int      *gic2,
        int      dim)
{
        int      i, j; 
        int      tmpgc[MAXD]; 
        
        for(j = 0; j < dim; j++)
            tmpgc[j] = gic[j]; 

        if(level > itlevel)
        {
            for(i = level; i > itlevel; i--)
            {
                for(j = 0; j < dim; j++)
                {
                    tmpgc[j] -= tmpgc[j]%2; 
                    gic2[j] = tmpgc[j]/refineratio; 
                }
                for(j = 0; j < dim; j++)
                    tmpgc[j] = gic2[j]; 
            }
        } 
        else
        {
            for(i = level; i < itlevel; i++)
            {
                for(j = 0; j < dim; j++)
                    gic2[j] = tmpgc[j]*refineratio; 
                for(j = 0; j < dim; j++)
                    tmpgc[j] = gic2[j]; 
            }
        } 
}


LOCAL void set_recv_domain(
        int             *L,
        int             *U,
        int             *iperm,
        int             side,
        int             swp,
        int             dim,
        Wv_on_pc        table_item)
{
        int             *lbuf = table_item.lbuf;
        int             *ubuf = table_item.ubuf;
        int             gmax[MAXD]; 
        int             j;
        
        for(j = 0; j < dim; j++)
            gmax[j] = table_item.bound[j] - table_item.base[j]; 

        for (j = 0; j < swp; ++j)
        {
            L[iperm[j]] = -lbuf[iperm[j]];
            U[iperm[j]] = gmax[iperm[j]] + ubuf[iperm[j]];
        }
        if (side == 0)
        {
            L[iperm[swp]] = -lbuf[iperm[swp]];
            U[iperm[swp]] = 0;
        }
        else
        {
            L[iperm[swp]] = gmax[iperm[swp]];
            U[iperm[swp]] = gmax[iperm[swp]] + ubuf[iperm[swp]];
        }
        for (j = swp+1; j < dim; ++j)
        {
            L[iperm[j]] = -lbuf[iperm[j]];
            U[iperm[j]] = gmax[iperm[j]] + ubuf[iperm[j]];
        }
}

LOCAL void set_search_domain(
        int             *L,
        int             *U,
        int             *iperm,
        int             swp,
        int             dim,
        Wv_on_pc        table_item,
        int             fine_or_coarse)
{
        int             *lbuf = table_item.lbuf;
        int             *ubuf = table_item.ubuf;
        int             gmax[MAXD];
        int             j;

        for(j = 0; j < dim; j++)
            gmax[j] = table_item.bound[j] - table_item.base[j];

        for (j = 0; j < dim; ++j)
        {
            L[iperm[j]] = -lbuf[iperm[j]];
            U[iperm[j]] = gmax[iperm[j]] + ubuf[iperm[j]];
        }

        if(fine_or_coarse == 1) 
        {
            /* On the same fine level */
            L[iperm[swp]] =  0;
            U[iperm[swp]] = gmax[iperm[swp]];
        }
}


LOCAL void domain_to_glb_indx(
        int          *L,
        int          *U,
        int          refine,
        Wv_on_pc     redistr_table,
        int          dim,
        int          *gL,
        int          *gU)
{
        int          j;
        for(j = 0; j < dim; j++)
        {
            gL[j] = L[j] + redistr_table.base[j] + redistr_table.off_set[j];
            gU[j] = U[j] + redistr_table.base[j] + redistr_table.off_set[j];
        }

        for(j = 0; j < dim; j++)
        {
            gL[j] *= refine;  
            gU[j] *= refine;  
        }
}



LOCAL void free_wv_recv_intrp_blks(
        PP_cps       **pprcv_cps,
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch)
{
        int          numnodes, myid;
        int          i, j;
        int          item[2], level;
        int          n_rcv_wvs, **in_item;
        int          recv_src, recv_grid, recv_src_pc;
        Front        *front;
 
        DEBUG_ENTER(free_wv_recv_intrp_blks)

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i]; 
            loc_front_on_redistr_table(front,redistr_table,
                    max_n_patch,item); 
            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_rcv_wvs);
            for(j = 0; j < n_rcv_wvs; j++)
            {
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;
                free(pprcv_cps[i][j].ipp_buf); 
            }            
            if(n_rcv_wvs != 0)
                free(pprcv_cps[i]); 
        }
        free(pprcv_cps); 

        DEBUG_LEAVE(free_wv_recv_intrp_blks)
}



LOCAL void aloc_intrp_cps_storage(
        Intrp_cps   *cps,
        size_t       sizest) 
{
        int    num = cps->num; 
        int    i;  
        byte   *storage;
        Locstate *state; 

        vector(&cps->comp,num,sizeof(COMPONENT));
        vector(&cps->state,num,sizeof(Locstate)); 
        vector(&cps->state_storage,num,sizest);

        state = cps->state;
        storage = cps->state_storage; 
        for(i = 0; i < num; i++)
        {
            *state++ = (Locstate) storage;
            storage += sizest;
        }
}



LOCAL int **count_send_intrp_on_wv(
        int           *item,
        Amr_intrp_set *aintrp,
        int           intrp_blk_n,
        int           *num_wvs)
{
        int          i, j, k, l;
        static int   nin = 10, **do_item; 
        static int   first = YES; 

        *num_wvs = 0;  
        if(YES == first)
        {
            matrix(&do_item, nin, 2, sizeof(int));
            first = NO;  
        }

        k = 0; 
        for(i = 0; i < intrp_blk_n; i++)
        {
            for(j = 0; j < aintrp[i].n_pts; j++)
            {
                if(item[0] == aintrp[i].apts[j].on_item[0] &&
                   item[1] == aintrp[i].apts[j].on_item[1])
                {
                    if(k == 0)
                    {
                        do_item[k][0] = aintrp[i].item[0]; 
                        do_item[k][1] = aintrp[i].item[1]; 
                        k++; 
                    }
                    else
                    {
                        int in_array = NO; 
                        for(l = 0; l < k; l++)
                        {
                            if(aintrp[i].item[0] == do_item[l][0] &&
                               aintrp[i].item[1] == do_item[l][1])
                            {
                                in_array = YES;
                                break; 
                            }
                        }
                        if(in_array == NO)
                        {
                            do_item[k][0] = aintrp[i].item[0]; 
                            do_item[k][1] = aintrp[i].item[1]; 
                            k++; 
                            if(k == nin)
                            {
                                int **tmp_do_item, mm; 
                                nin += 10; 
                                matrix(&tmp_do_item, nin, 2, sizeof(int));
                                for(mm = 0; mm < k; mm++)
                                {
                                    tmp_do_item[mm][0] = do_item[mm][0]; 
                                    tmp_do_item[mm][1] = do_item[mm][1]; 
                                }
                                free(do_item); 
                                do_item = tmp_do_item; 
                            }
                        }
                    }  
                }
            }
        }
        *num_wvs = k;         
        return do_item; 
}

LOCAL int count_recv_num_intrp_on_wv(
        int           *item,
        Amr_intrp_set *aintrp,
        int           intrp_blk_n,
        int           **in_item,
        int           in_n)
{
        int           i, j;
        int           num = 0; 

        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == item[0] &&
               aintrp[i].item[1] == item[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(in_item[in_n][0] == aintrp[i].apts[j].on_item[0] &&
                       in_item[in_n][1] == aintrp[i].apts[j].on_item[1]) 
                    {
                        num++; 
                    }
                }
            }
        }
        return num; 
}

LOCAL int **count_recv_intrp_on_wvs(
        int           *item,
        Amr_intrp_set *aintrp,
        int           intrp_blk_n,
        int           *num_wvs)
{
        int          i, j, k, l;
        static int   nin = 10, **in_item; 
        static int   first = YES; 

        *num_wvs = 0;  
        if(YES == first)
        {
            matrix(&in_item, nin, 2, sizeof(int));
            first = NO;  
        }

        k = 0; 
        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == item[0] &&
               aintrp[i].item[1] == item[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(k == 0)
                    {
                        in_item[k][0] = aintrp[i].apts[j].on_item[0]; 
                        in_item[k][1] = aintrp[i].apts[j].on_item[1]; 
                        k++; 
                    }
                    else
                    {
                        int in_array = NO; 
                        for(l = 0; l < k; l++)
                        {
                            if(aintrp[i].apts[j].on_item[0] == in_item[l][0] &&
                               aintrp[i].apts[j].on_item[1] == in_item[l][1])
                            {
                                in_array = YES;
                                break; 
                            }
                        }
                        if(in_array == NO)
                        {
                            in_item[k][0] = aintrp[i].apts[j].on_item[0]; 
                            in_item[k][1] = aintrp[i].apts[j].on_item[1]; 
                            k++; 
                            if(k == nin)
                            {
                                int **tmp_in_item, mm; 
                                nin += 10; 
                                matrix(&tmp_in_item, nin, 2, sizeof(int));
                                for(mm = 0; mm < k; mm++)
                                {
                                    tmp_in_item[mm][0] = in_item[mm][0]; 
                                    tmp_in_item[mm][1] = in_item[mm][1]; 
                                }
                                free(in_item); 
                                in_item = tmp_in_item; 
                            }
                        }
                    }
                }
            }
        }
        *num_wvs = k;         
        return in_item; 
}

LOCAL void bundle_blk_cst(
        PP_cps      *pp_cps,
        Intrp_cps   *i_cps, 
        Wave        *wave)
{
        int         i, num;
        byte        *pp_buf; 
        size_t      sizecp, sizest = wave->sizest; 

        sizecp = sizeof(COMPONENT);  
        num = i_cps->num;
        pp_buf = pp_cps->ipp_buf; 
        for(i = 0; i < num; i++)
        {
            (*wave->bundle_single_st)(i_cps->state[i],wave,pp_buf);         
            pp_buf += sizest; 
            assign(pp_buf,&(i_cps->comp[i]),sizecp);
            pp_buf += sizecp; 
        }
}

LOCAL void unbundle_blk_cst(
        PP_cps      *pp_cps,
        Intrp_cps   *i_cps, 
        Wave        *wave)
{
        int         i, num;
        byte        *pp_buf; 
        size_t      sizecp, sizest = wave->sizest; 

        sizecp = sizeof(COMPONENT);  
        num = i_cps->num;
        pp_buf = pp_cps->ipp_buf; 
        for(i = 0; i < num; i++)
        {
            (*wave->unbundle_single_st)(i_cps->state[i],wave,pp_buf);         
            pp_buf += sizest; 
            assign(&(i_cps->comp[i]),pp_buf,sizecp);
            pp_buf += sizecp; 
        }
}

LOCAL PP_cps *collect_recv_blks_on_level(
        int          find_on_one_level,
        int          on_level,
        PP_cps       **pprecv_cps,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch, 
        int          find_PP_blk, 
        int          *slevel_blks,
        Amr_intrp_set  *aintrp,
        int            intrp_blk_n)
{
        int          myid;
        int          i, j, k;
        int          item[2];
        int          recv_src, recv_grid;
        int          recv_src_pc, level, recv_level;
        Front        *front;
        int          n_recv_wvs, **in_item;
        PP_cps       *slpprecv_cps = NULL;

        myid = pp_mynode();
        *slevel_blks = 0; 

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level; 
            if(find_on_one_level == YES && level != on_level) continue; 

            loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item);

            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_recv_wvs);

            for(j = 0; j < n_recv_wvs; j++)
            {
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_level = redistr_table[recv_src][recv_grid].wv_level; 
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;                

                if(find_PP_blk == YES)
                {
                    if(recv_level == level && recv_src_pc != myid)
                        (*slevel_blks)++; 
                }
                else
                {
                    if(recv_level == level && recv_src_pc == myid)
                        (*slevel_blks)++; 
                }
            }
        }

        if((*slevel_blks) != 0)
            vector(&slpprecv_cps, (*slevel_blks), sizeof(PP_cps)); 
        k = 0; 
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level; 
            if(find_on_one_level == YES && level != on_level) continue; 

            loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item);
            
            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_recv_wvs);

            for(j = 0; j < n_recv_wvs; j++)
            {
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_level = redistr_table[recv_src][recv_grid].wv_level; 
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;                

                if(find_PP_blk == YES)
                {
                    if(recv_level == level && recv_src_pc != myid)
                    {
                        assign(&(slpprecv_cps[k]),&(pprecv_cps[i][j]), sizeof(PP_cps));  
                        k++;  
                    } 
                }
                else
                {
                    if(recv_level == level && recv_src_pc == myid)
                    {
                        assign(&(slpprecv_cps[k]),&(pprecv_cps[i][j]), sizeof(PP_cps));  
                        k++;  
                    } 
                }
            }
        }
        return slpprecv_cps; 
}

/* The recved intrp. blks are from the next coarser grid */
LOCAL PP_cps *collect_recv_intrp_blks_on_level(
        int          on_level,
        PP_cps       **pprecv_cps,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch, 
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        int          find_PP_blk, 
        int          *slevel_blks)
{
        int          myid;
        int          i, j, k;
        int          item[2];
        int          recv_src, recv_grid;
        int          recv_src_pc, level, recv_src_level;
        Front        *front;
        int          n_recv_wvs, **in_item;
        PP_cps       *slpprecv_cps = NULL;

        myid = pp_mynode();
        *slevel_blks = 0; 

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level; 
            if(level != on_level) continue; 

            loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item);

            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_recv_wvs);

            for(j = 0; j < n_recv_wvs; j++)
            {
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_src_level = redistr_table[recv_src][recv_grid].wv_level; 
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;                

                if(find_PP_blk == YES)
                {
                    if(recv_src_level == (level-1) && recv_src_pc != myid)
                        (*slevel_blks)++; 
                }
                else
                {
                    if(recv_src_level == (level-1) && recv_src_pc == myid)
                        (*slevel_blks)++; 
                }
            }
        }

        if((*slevel_blks) != 0)
            vector(&slpprecv_cps, (*slevel_blks), sizeof(PP_cps)); 
        k = 0; 
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level; 
            if(level != on_level) continue; 

            loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item);
            
            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_recv_wvs);

            for(j = 0; j < n_recv_wvs; j++)
            {
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_src_level = redistr_table[recv_src][recv_grid].wv_level; 
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;                

                if(find_PP_blk == YES)
                {
                    if(recv_src_level == (level-1) && recv_src_pc != myid)
                    {
                        assign(&(slpprecv_cps[k]),&(pprecv_cps[i][j]), sizeof(PP_cps));  
                        k++;  
                    } 
                }
                else
                {
                    if(recv_src_level == (level-1) && recv_src_pc == myid)
                    {
                        assign(&(slpprecv_cps[k]),&(pprecv_cps[i][j]), sizeof(PP_cps));  
                        k++;  
                    } 
                }
            }
        }
        return slpprecv_cps; 
}


LOCAL void blk_cst_to_wave(
        Wave         *wave,
        Front        *front,
        Intrp_cps    *cps, 
        int          *me,
        int          *from_it,
        Amr_intrp_set *aintrp,
        int          intrp_blk_n)
{
        int         i, j, k;
        int         ic[MAXD];
        int         gmin[MAXD], gmax[MAXD];
        int         dim = wave->rect_grid->dim;
        int         num = 0;
        float       *crds; 

        for(i = 0; i < dim; i++)
        {
            gmin[i] = -wave->rect_grid->lbuf[i];
            gmax[i] = wave->rect_grid->gmax[i]
                      + wave->rect_grid->ubuf[i];
        }

        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == me[0] &&
               aintrp[i].item[1] == me[1])        
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(from_it[0] == aintrp[i].apts[j].on_item[0] &&
                       from_it[1] == aintrp[i].apts[j].on_item[1])                     
                    {
                        ic[0] = aintrp[i].apts[j].ic[0];
                        ic[1] = aintrp[i].apts[j].ic[1];

                        for(k = 0; k < dim; k++)
                        {
                            if(ic[k] < gmin[k] || ic[k] >= gmax[k])
                            {
                                printf("ERROR blk_cst_to_wave\n");
                                printf("ic not in wave\n");
                                clean_up(ERROR);
                            }
                        }

                        if(cps->comp[num] == Rect_comp(ic,wave))
                            assign(Rect_state(ic,wave),cps->state[num],wave->sizest); 
                        else
                        {
                            if(is_excluded_comp(Rect_comp(ic,wave),front->interf))
                                (*front->_obstacle_state)(Rect_state(ic,wave),front->sizest);
                            else
                            {
                                float tmpcrds_on[MAXD]; 
                                crds = Rect_coords(ic,wave); 

                                for(k = 0; k < dim; k++)
                                    tmpcrds_on[k] = crds[k];  

                                if (! nearest_intfc_state(tmpcrds_on,Rect_comp(ic,wave),
                                       wave_tri_soln(wave)->tri_grid->grid_intfc, 
                                       Rect_state(ic,wave),tmpcrds_on,NULL))
                                {
                                    printf("ERROR in blk_cst_to_wave\n");
                                    printf("ic[%d,%d] of wave[%d] level[%d] [%d][%d]is unfilled by[%d][%d]\n",
                                      ic[0], ic[1], wave->patch_number, wave->patch_level, 
                                      me[0],me[1],from_it[0], from_it[1]);
                                    printf("cps->comp[%d] = %d, wave_comp = %d\n",
                                            num, cps->comp[num], Rect_comp(ic,wave)); 
                                    print_rectangular_grid(wave->rect_grid); 
                                    clean_up(ERROR);
                                }
                            } 
                        }
                        num++; 
                    }
                }
            }
        }

} 


EXPORT void average_fine_to_coarse_st(
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam)
{
        int            numnodes;  
        int            src, grid, end_level;  
        int            i, j, ii, get_avg_blks, snd_avg_blks; 
        Amr_avg_set    *getavgset, *sndavgset;
        int            dim = wvs[0]->rect_grid->dim;  
        int            **avg_init; 
        Front          *front;
        Wave           *wave; 
        int            item[2], levels, ll; 
        Intrp_cps      **avg_icps;
     
        DEBUG_ENTER(average_fine_to_coarse_st)

        levels = overparam->numberOfRefinementLevels; 
        get_avg_blks = count_get_avg_patches_at_level(YES,0,frs,
             num_patches,redistr_table,max_n_patch,overparam,&getavgset); 
        for(i = 0; i < get_avg_blks; i++)
        {
            /*
            printf("level[%d] item[%d][%d] get avg \n",
                redistr_table[getavgset[i].item[0]][getavgset[i].item[1]].wv_level,
                getavgset[i].item[0], getavgset[i].item[1]);
            */

            set_get_avg_patch_ptset(&getavgset[i],redistr_table,
               max_n_patch,overparam,dim);  

            /*
            for(ll = 0; ll < getavgset[i].num_box; ll++)
            {
                printf("level[%d] item[%d][%d] get avg from[%d][%d] base[%d %d] bound[%d %d]\n",
                  redistr_table[getavgset[i].item[0]][getavgset[i].item[1]].wv_level,
                  getavgset[i].item[0], getavgset[i].item[1],
                  getavgset[i].avgbox[ll].on_item[0], 
                  getavgset[i].avgbox[ll].on_item[1], 
                  getavgset[i].avgbox[ll].base[0],
                  getavgset[i].avgbox[ll].base[1], 
                  getavgset[i].avgbox[ll].bound[0],
                  getavgset[i].avgbox[ll].bound[1]);  
            }
            */
        }

        snd_avg_blks = count_snd_avg_patches_at_level(YES,0,frs,
             num_patches,redistr_table,max_n_patch,overparam,&sndavgset); 
        for(i = 0; i < snd_avg_blks; i++)
        {
            set_snd_avg_patch_ptset(&sndavgset[i],redistr_table,
               max_n_patch,overparam,dim);  
            /*
            for(ll = 0; ll < sndavgset[i].num_box; ll++)
            {
                printf("level[%d] item[%d][%d] snd to [%d][%d] avg base[%d %d] bound[%d %d]\n",
                  redistr_table[sndavgset[i].item[0]][sndavgset[i].item[1]].wv_level, 
                  sndavgset[i].item[0], sndavgset[i].item[1], 
                  sndavgset[i].avgbox[ll].to_item[0], 
                  sndavgset[i].avgbox[ll].to_item[1], 
                  sndavgset[i].avgbox[ll].base[0],
                  sndavgset[i].avgbox[ll].base[1], 
                  sndavgset[i].avgbox[ll].bound[0],
                  sndavgset[i].avgbox[ll].bound[1]);  
            }
            */
        }

        avg_icps = coarse_post_comp_to_fine(wvs,frs,num_patches,
           redistr_table,max_n_patch,overparam,sndavgset,snd_avg_blks,
           getavgset,get_avg_blks);  

        for(ll = levels - 2; ll >= 0; ll--)
        {
            perform_average_fine_state_on_level(ll+1,wvs,frs,num_patches,
               redistr_table,max_n_patch,overparam,sndavgset,
               snd_avg_blks,avg_icps); 
            coarse_recv_avg_st_from_fine(ll,wvs,frs,num_patches,
               redistr_table,max_n_patch,overparam,getavgset,
               get_avg_blks,sndavgset,snd_avg_blks,avg_icps);
        }

        for(i = 0; i < snd_avg_blks; i++)
        {
            for(j = 0; j < sndavgset[i].num_box; j++)
            {
                free_these(3,avg_icps[i][j].comp,avg_icps[i][j].state,
                      avg_icps[i][j].state_storage); 
            }
            free(avg_icps[i]); 
        }
        if(snd_avg_blks != 0)
            free(avg_icps); 

        for(i = 0; i < get_avg_blks; i++)
            free(getavgset[i].avgbox); 
        if(get_avg_blks != 0)
            free(getavgset); 
        for(i = 0; i < snd_avg_blks; i++)
            free(sndavgset[i].avgbox); 
        if(snd_avg_blks != 0)
            free(sndavgset); 

        DEBUG_ENTER(average_fine_to_coarse_st)
}

LOCAL void coarse_recv_avg_st_from_fine(
        int          on_level, 
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_avg_set  *getavgset,
        int          get_avg_blks,
        Amr_avg_set  *sndavgset,
        int          snd_avg_blks,
        Intrp_cps    **avg_icps)
{

        int           i, j, k, ii, level, pprecv_blks; 
        int           item[2], on_item[2], to_item[2];
        int           sndnum,  getnum, myid, numnodes; 
        int           nrecv, nsend, send_dst_pc, recv_src_pc; 
        Front         *front;  
        Wave          *wave; 
        Trans_box   *avgbox; 
        size_t        sizest = wvs[0]->sizest, send_len, recv_len;
#if defined(__MPI__)
        MPI_Request *ipp_reqs;
        MPI_Status  *ipp_stat;
        int         *irecv_indices, *irecv_flags;
        int         ndone, not_all_recved = YES;
#endif /* if defined(__MPI__) */
        PP_cps      *pprecv_cps, *ppsend_cps, *locmatch; 
        int         refine; 

        refine = 1;
        for(i = 0; i < wvs[0]->rect_grid->dim; i++)
            refine *= overparam->refinementRatio;

        myid = pp_mynode(); 
        numnodes = pp_numnodes(); 
        getnum = 0;  
        for(i = 0; i < get_avg_blks; i++)
        {
            item[0] = getavgset[i].item[0]; 
            item[1] = getavgset[i].item[1]; 
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level) continue;
            front = redistr_table[item[0]][item[1]].front;
            wave = NULL; 
            for(j = 0; j < num_patches; j++)
            {
                if(frs[j] == front)
                {
                    wave = wvs[j]; 
                    break;     
                }
            }
            if(wave == NULL)
            {
                printf("ERROR coarse_recv_avg_st_from_fine\n");
                printf("Wave is null\n");
                clean_up(ERROR); 
            }
            for(j = 0; j < getavgset[i].num_box; j++) 
                getnum++;  
        }

        ii = 0; 
        if(getnum != 0)
            vector(&pprecv_cps, getnum, sizeof(PP_cps)); 
        for(i = 0; i < get_avg_blks; i++)
        {
            item[0] = getavgset[i].item[0]; 
            item[1] = getavgset[i].item[1]; 
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level) continue;

            avgbox = getavgset[i].avgbox;
            for(j = 0; j < getavgset[i].num_box; j++) 
            {
                pprecv_cps[ii].me[0] = item[0]; 
                pprecv_cps[ii].me[1] = item[1]; 
                on_item[0] = avgbox[j].on_item[0]; 
                on_item[1] = avgbox[j].on_item[1]; 
                pprecv_cps[ii].from_it[0] = on_item[0]; 
                pprecv_cps[ii].from_it[1] = on_item[1]; 
                recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;

                nrecv = (avgbox[j].bound[0]-avgbox[j].base[0])*
                  (avgbox[j].bound[1]-avgbox[j].base[1]);
                recv_len = (sizeof(COMPONENT)+sizest)*nrecv;
                pprecv_cps[ii].num = nrecv;
                scalar(&pprecv_cps[ii].ipp_buf,recv_len); 
                if(recv_src_pc != myid)
                {
#if defined(__MPI__)
                    pprecv_cps[ii].ipp_tag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch);
                    pp_irecv(pprecv_cps[ii].ipp_tag, recv_src_pc,
                          (POINTER)(pprecv_cps[ii].ipp_buf),recv_len,&(pprecv_cps[ii].ipp_reqs));
#endif /* if defined(__MPI__) */
                    /*
                    printf("Item[%d][%d] PPrecv state from item[%d][%d] level[%d] data_size[%d] tag[%d] \n",
                       item[0], item[1],
                       on_item[0], on_item[1],
                       redistr_table[on_item[0]][on_item[1]].wv_level, nrecv,
                       pprecv_cps[ii].ipp_tag);
                    */
                }
                else
                {
                    /*
                    int tmptag;
                    tmptag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch);
                    printf("Item[%d][%d] CPrecv state from item[%d][%d] level[%d] data_size[%d] tag[%d] \n",
                       item[0], item[1],
                       on_item[0], on_item[1],
                       redistr_table[on_item[0]][on_item[1]].wv_level, nrecv,
                       tmptag);
                    */
                }
                ii++; 
            }
        }


        sndnum = 0;  
        for(i = 0; i < snd_avg_blks; i++)
        {
            item[0] = sndavgset[i].item[0]; 
            item[1] = sndavgset[i].item[1]; 
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level+1) continue;
            for(j = 0; j < sndavgset[i].num_box; j++) 
                sndnum++;  
        }

        ii = 0; 
        if(sndnum != 0)
            vector(&ppsend_cps, sndnum, sizeof(PP_cps)); 
        for(i = 0; i < snd_avg_blks; i++)
        {
            item[0] = sndavgset[i].item[0]; 
            item[1] = sndavgset[i].item[1]; 
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level+1) continue;
            front = redistr_table[item[0]][item[1]].front;
            wave = NULL; 
            for(j = 0; j < num_patches; j++)
            {
                if(frs[j] == front)
                {
                    wave = wvs[j]; 
                    break;     
                }
            }
            if(wave == NULL)
            {
                printf("ERROR coarse_recv_avg_st_from_fine\n");
                printf("send Wave is null\n");
                clean_up(ERROR); 
            }

            avgbox = sndavgset[i].avgbox;
            for(j = 0; j < sndavgset[i].num_box; j++) 
            {
                ppsend_cps[ii].me[0] = item[0]; 
                ppsend_cps[ii].me[1] = item[1]; 
                to_item[0] = avgbox[j].to_item[0]; 
                to_item[1] = avgbox[j].to_item[1]; 
                ppsend_cps[ii].to_it[0] = to_item[0]; 
                ppsend_cps[ii].to_it[1] = to_item[1]; 
                send_dst_pc = redistr_table[to_item[0]][to_item[1]].pc_id;

                nsend = (avgbox[j].bound[0]-avgbox[j].base[0])*
                  (avgbox[j].bound[1]-avgbox[j].base[1])/refine;
                send_len = (sizeof(COMPONENT)+sizest)*nsend;
                ppsend_cps[ii].num = nsend;
                scalar(&ppsend_cps[ii].ipp_buf,send_len); 
                bundle_blk_cst(&ppsend_cps[ii],&avg_icps[i][j],wave);
                if(myid != send_dst_pc)
                {
#if defined(__MPI__)
                    ppsend_cps[ii].ipp_tag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                      trans_item_offset(redistr_table,to_item[0],to_item[1],max_n_patch) +
                      trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;
                    pp_isend(ppsend_cps[ii].ipp_tag,(POINTER)ppsend_cps[ii].ipp_buf,
                        send_len, send_dst_pc, &(ppsend_cps[ii].ipp_reqs));
#endif /* if defined(__MPI__) */
                    /* 
                    printf("Item[%d][%d] PPsend state to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                         item[0], item[1],to_item[0], to_item[1],
                         redistr_table[to_item[0]][to_item[1]].wv_level,
                         nsend, ppsend_cps[ii].ipp_tag);
                    */
                } 
                else
                {
                    /*
                    int tmptag;
                    tmptag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                      trans_item_offset(redistr_table,to_item[0],to_item[1],max_n_patch) +
                      trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;
                    printf("Item[%d][%d] CPsend state to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                         item[0], item[1],to_item[0], to_item[1],
                         redistr_table[to_item[0]][to_item[1]].wv_level,
                         nsend, tmptag);
                    */
                }
                ii++; 
            }
        }

        /* Coarse receiving states from fine */

        pprecv_blks = 0; 
        for(i = 0; i < getnum; i++)
        {
            item[0] = pprecv_cps[i].me[0];
            item[1] = pprecv_cps[i].me[1];
            on_item[0] = pprecv_cps[i].from_it[0]; 
            on_item[1] = pprecv_cps[i].from_it[1]; 
            recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
            if(recv_src_pc == myid)
            {
                for(k = 0; k < sndnum; k++)
                {
                    if(ppsend_cps[k].me[0] == on_item[0] &&
                       ppsend_cps[k].me[1] == on_item[1] &&
                       ppsend_cps[k].to_it[0] == item[0] &&
                       ppsend_cps[k].to_it[1] == item[1])
                    {
                        locmatch = &(ppsend_cps[k]); 
                        break; 
                    }
                }
                if(pprecv_cps[i].num != locmatch->num)
                {
                    printf("ERROR coarse_recv_avg_st_from_fine\n");
                    printf("Loc receive data size does not match\n");
                    clean_up(ERROR); 
                }
                assign(pprecv_cps[i].ipp_buf, locmatch->ipp_buf,
                       pprecv_cps[i].num*(sizeof(COMPONENT)+sizest));
            }
            else
            {
                pprecv_blks++; 
            }
        }
#if defined(__MPI__)
        if(pprecv_blks != 0)
        {
            vector(&ipp_reqs, pprecv_blks, sizeof(MPI_Request));
            vector(&ipp_stat, pprecv_blks, sizeof(MPI_Status));
            vector(&irecv_indices, pprecv_blks, sizeof(int));
            vector(&irecv_flags, pprecv_blks, sizeof(int));

            k = 0; 
            for(i = 0; i < getnum; i++)
            {
                item[0] = pprecv_cps[i].me[0];
                item[1] = pprecv_cps[i].me[1];
                on_item[0] = pprecv_cps[i].from_it[0]; 
                on_item[1] = pprecv_cps[i].from_it[1]; 
                recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                if(recv_src_pc != myid)
                {
                    assign(&ipp_reqs[k], &(pprecv_cps[i].ipp_reqs), sizeof(MPI_Request));
                    irecv_flags[k] = NO;
                    k++; 
                }
            }
            while(not_all_recved == YES)
            {
                MPI_Waitsome(pprecv_blks, ipp_reqs, &ndone, irecv_indices, ipp_stat);
                for(i = 0; i < ndone; i++)
                {
                    ii = irecv_indices[i];
                    if(irecv_flags[ii] != YES)
                    {
                        irecv_flags[ii] = YES;
                    }
                }
                not_all_recved = NO;
                for(i = 0; i < pprecv_blks; i++)
                {
                    if(irecv_flags[i] == NO)
                    {
                        not_all_recved = YES;
                        break;
                    }
                }
            }
            free_these(4,ipp_reqs,ipp_stat,irecv_indices,irecv_flags);
        }
#endif /* if defined(__MPI__) */

        assign_recv_avg_to_wv(on_level,wvs,frs,num_patches,
         redistr_table,max_n_patch,overparam,getavgset,
         get_avg_blks,pprecv_cps,getnum);

        for(i = 0; i < getnum; i++)
            free(pprecv_cps[i].ipp_buf);
        if(getnum != 0)
            free(pprecv_cps); 

        for(i = 0; i < sndnum; i++)
        {
            item[0] = ppsend_cps[i].me[0];
            item[1] = ppsend_cps[i].me[1];
            to_item[0] = ppsend_cps[i].to_it[0]; 
            to_item[1] = ppsend_cps[i].to_it[1]; 
            send_dst_pc = redistr_table[to_item[0]][to_item[1]].pc_id;
            if(send_dst_pc != myid)
            {
#if defined(__MPI__)
                    MPI_Wait(&(ppsend_cps[i].ipp_reqs), &(ppsend_cps[i].ipp_stat));
#endif /* if defined(__MPI__) */
            }
            free(ppsend_cps[i].ipp_buf);
        }
        if(sndnum != 0)
            free(ppsend_cps); 
        
}

LOCAL void assign_recv_avg_to_wv(
        int          on_level, 
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_avg_set  *getavgset,
        int           get_avg_blks,
        PP_cps       *pprecv_cps,
        int          getnum)
{
        int          myid, numnodes; 
        int          item[2], on_item[2], level, i, j, k;
        Front        *front;
        Wave         *wave;
        Trans_box  *avgbox;

        myid = pp_mynode();
        numnodes = pp_numnodes();
        for(i = 0; i < get_avg_blks; i++)
        {
            item[0] = getavgset[i].item[0];
            item[1] = getavgset[i].item[1];
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level) continue;
            front = redistr_table[item[0]][item[1]].front;
            wave = NULL;
            for(j = 0; j < num_patches; j++)
            {
                if(frs[j] == front)
                {
                    wave = wvs[j];
                    break;
                }
            }

            avgbox = getavgset[i].avgbox;
            for(j = 0; j < getavgset[i].num_box; j++)
            {
                on_item[0] = avgbox[j].on_item[0];
                on_item[1] = avgbox[j].on_item[1];
                for(k = 0; k < getnum; k++)
                {
                    if(pprecv_cps[k].me[0] == item[0] &&
                       pprecv_cps[k].me[1] == item[1] && 
                       pprecv_cps[k].from_it[0] == on_item[0] &&
                       pprecv_cps[k].from_it[1] == on_item[1])
                    {
                        /*
                        printf("Me[%d][%d] assign received state from [%d][%d]\n",  
                            item[0], item[1], on_item[0], on_item[1]);
                        */
                        avg_state_to_wave(&pprecv_cps[k],front,wave,
                            redistr_table[item[0]][item[1]],&avgbox[j]); 
                        break; 
                    }
                }
            }
        }
}

LOCAL void avg_state_to_wave(
        PP_cps       *pprecv_cps,
        Front        *front,
        Wave         *wave,
        Wv_on_pc     redistr_table,
        Trans_box  *avgbox)
{
        Intrp_cps   avg_icps; 
        size_t      sizest = wave->sizest; 
        int         i, j, k, ix, iy;
        int         ic[MAXD], level;
        int         gmax[MAXD];
        int         dim = wave->rect_grid->dim;
        int         base[MAXD], bound[MAXD];
        COMPONENT   comp;  

        for(i = 0; i < dim; i++)
        {
            gmax[i] = wave->rect_grid->gmax[i]; 
            base[i] = avgbox->base[i] - redistr_table.base[i];
            bound[i] = avgbox->bound[i] - redistr_table.base[i];
        }
        if(base[0] < 0 || base[1] < 0 ||
           bound[0] > gmax[0] || bound[1] > gmax[1])
        {
            printf("ERROR avg_state_to_wave, box out range\n");
            printf("gmax[%d, %d]\n", gmax[0], gmax[1]);
            printf("base[%d %d] bound[%d %d]\n", base[0], base[1],
                bound[0], bound[1]);
            clean_up(ERROR);
        }
   
        level = wave->patch_level; 
        avg_icps.num = pprecv_cps->num; 
        aloc_intrp_cps_storage(&avg_icps, sizest);
        unbundle_blk_cst(pprecv_cps, &avg_icps, wave);

        /* 
        printf("Wave[%d]level[%d] assign avg state base[%d %d] bound[%d %d], size[%d]\n", 
                wave->patch_number, wave->patch_level,
                base[0], base[1], bound[0], bound[1], pprecv_cps->num);
        */

        j = 0;
        for(iy = base[1]; iy < bound[1]; iy++)
        {
            for(ix = base[0]; ix < bound[0]; ix++)
            {
                ic[0] = ix; 
                ic[1] = iy; 
                comp = Rect_comp(ic,wave);
                if(! is_excluded_comp(comp,front->interf))
                {
                    if(avg_icps.comp[j] == comp)
                    {
                        /*
                        if(level == 0)
                        {
                            printf("Before assign ic[%d %d]: ", ic[0], ic[1]);
                            (*front->print_state)(Rect_state(ic,wave)); 
                        }
                        */
                        assign(Rect_state(ic,wave),avg_icps.state[j],sizest); 
                        /*
                        if(level == 0)
                        {
                            printf("After assign: ");
                            (*front->print_state)(Rect_state(ic,wave)); 
                        }
                        */
                    }
                }
                j++;
            }
        }
        free_these(3,avg_icps.comp, avg_icps.state, avg_icps.state_storage);
}


LOCAL void perform_average_fine_state_on_level(
        int          on_level, 
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_avg_set  *sndavgset,
        int           snd_avg_blks,
        Intrp_cps     **avg_icps)
{
        int           i, j, level; 
        int           item[2]; 
        Trans_box   *avgbox;  
        Front         *front;  
        Wave          *wave; 

        for(i = 0; i < snd_avg_blks; i++)
        {
            item[0] = sndavgset[i].item[0]; 
            item[1] = sndavgset[i].item[1]; 
            level = redistr_table[item[0]][item[1]].wv_level;
            if(level != on_level) continue;
            front = redistr_table[item[0]][item[1]].front;
            wave = NULL; 
            for(j = 0; j < num_patches; j++)
            {
                if(frs[j] == front)
                {
                    wave = wvs[j]; 
                    break;     
                }
            }
            if(wave == NULL)
            {
                printf("ERROR perform_average_fine_state_on_level\n");
                printf("Wave is null\n");
                clean_up(ERROR); 
            }

            for(j = 0; j < sndavgset[i].num_box; j++) 
            {
                /*
                printf("Level[%d] Item[%d][%d] perform_avg st to"
                      " [%d][%d] avg base[%d %d] bound[%d %d]\n",
                  redistr_table[item[0]][item[1]].wv_level,
                  item[0], item[1],
                  sndavgset[i].avgbox[j].to_item[0],
                  sndavgset[i].avgbox[j].to_item[1],
                  sndavgset[i].avgbox[j].base[0],
                  sndavgset[i].avgbox[j].base[1],
                  sndavgset[i].avgbox[j].bound[0],
                  sndavgset[i].avgbox[j].bound[1]);
                */
                assign_avg_st_to_blk(wave,front,&avg_icps[i][j],
                    &sndavgset[i].avgbox[j],redistr_table[item[0]][item[1]],
                    overparam->refinementRatio); 
            }
        }
}

LOCAL void assign_avg_st_to_blk(
        Wave         *wave,
        Front        *front,
        Intrp_cps    *avg_cps,
        Trans_box  *avgbox,
        Wv_on_pc     redistr_table,
        int          refine)
{
        int         i, j, dim, ii, jj;
        int         base[MAXD], bound[MAXD];
        int         ix, iy, ic[MAXD];
        int         gmax[MAXD], level;
        Locstate    st[10];  
        COMPONENT   comp[10]; 

        dim = wave->rect_grid->dim;
        level = wave->patch_level; 
        for(i = 0; i < dim; i++)
        {
            base[i] = avgbox->base[i] - redistr_table.base[i];
            bound[i] = avgbox->bound[i] - redistr_table.base[i];
            gmax[i] = wave->rect_grid->gmax[i];
        }

        if(base[0] < 0 || base[1] < 0 ||
           bound[0] > gmax[0] || bound[1] > gmax[1])
        {
            printf("ERROR assign_avg_st_to_blk, box out range\n");
            printf("gmax[%d, %d]\n", gmax[0], gmax[1]);
            printf("base[%d %d] bound[%d %d]\n", base[0], base[1],
                bound[0], bound[1]);
            clean_up(ERROR);
        }

        /*
        printf("Assign wave[%d] level[%d] state to avg_blk"
               " base[%d %d] bound[%d %d] refine %d\n",
                wave->patch_number, wave->patch_level, base[0], base[1],
                bound[0], bound[1], refine);
        */
 
        j = 0; 
        for(iy = base[1]; iy < bound[1]; iy+=refine)
        {
            for(ix = base[0]; ix < bound[0]; ix+=refine)
            {
                i = 0; 
                for(jj = iy; jj < iy+refine; jj++)
                {
                    for(ii = ix; ii < ix+refine; ii++)
                    {
                        ic[0] = ii;
                        ic[1] = jj;
                        st[i] = Rect_state(ic,wave); 
                        comp[i] = Rect_comp(ic,wave);
                        /*
                        if(level == 1 && ix == 0)
                        {
                            printf(" ic[%d %d] for avg", ic[0], ic[1]); 
                            (*front->print_state)(st[i]); 
                        }
                        */
                        i++;  
                    }
                }
                if(is_excluded_comp(avg_cps->comp[j],front->interf)) 
                    (*front->_obstacle_state)(avg_cps->state[j],front->sizest);
                else
                {
                    (*wave->compute_avg_state)(wave,comp,st,4,
                          &avg_cps->comp[j],avg_cps->state[j]);
                    /*
                    if(level == 1)
                    {
                        printf(" avged state : "); 
                        (*front->print_state)(avg_cps->state[j]); 
                    }
                    */
                }
                j++; 
            }
        }

} 

LOCAL Intrp_cps **coarse_post_comp_to_fine(
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_avg_set  *sndavgset,
        int           snd_avg_blks,
        Amr_avg_set  *getavgset,
        int           get_avg_blks)
{
        int          numnodes, myid;
        int          ii, i, j, grid, nsend, nrecv;
        int          item[2], on_item[2];
        int          from_it[2], me[2]; 
        Front        *front;
        Wave         *wave;
        int          recv_src_pc, send_dst_pc;
        int          ll, levels;
        Intrp_cps    cps, **rcv_icps = NULL;
        size_t       send_len, recv_len;
        Trans_box  *avgbox; 
        PP_cps       **ppsnd_cps, **pprcv_cps;
        int          refine; 
        size_t       sizest = wvs[0]->sizest;
#if defined(__MPI__)
        MPI_Request *ipp_reqs;
        MPI_Status  *ipp_stat;
        int         *irecv_indices, *irecv_flags;
        int         ndone, not_all_recved = YES;
#endif /* if defined(__MPI__) */
        PP_cps      *pprecvcomp, *locmatch; 
        int          cprecv_blks, pprecv_blks; 

        myid = pp_mynode();
        numnodes = pp_numnodes(); 
        refine = 1;
        for(i = 0; i < wvs[0]->rect_grid->dim; i++)
            refine *= overparam->refinementRatio; 
 
        if(snd_avg_blks != 0)
        { 
            vector(&pprcv_cps, snd_avg_blks, sizeof(PP_cps*)); 
            vector(&rcv_icps, snd_avg_blks, sizeof(Intrp_cps*)); 
        }
        for(grid = 0; grid < snd_avg_blks; grid++)
        {
            item[0] = sndavgset[grid].item[0]; 
            item[1] = sndavgset[grid].item[1]; 

            vector(&pprcv_cps[grid],sndavgset[grid].num_box,sizeof(PP_cps)); 
            vector(&rcv_icps[grid],sndavgset[grid].num_box,sizeof(Intrp_cps)); 
            avgbox = sndavgset[grid].avgbox; 
            for(j = 0; j < sndavgset[grid].num_box; j++) 
            {
                on_item[0] = avgbox[j].to_item[0];
                on_item[1] = avgbox[j].to_item[1];
                recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                nrecv = (avgbox[j].bound[0]-avgbox[j].base[0])*
                  (avgbox[j].bound[1]-avgbox[j].base[1])/refine;
                rcv_icps[grid][j].num = nrecv; 
                aloc_intrp_cps_storage(&rcv_icps[grid][j], sizest); 
 
                pprcv_cps[grid][j].num = nrecv; 
                pprcv_cps[grid][j].me[0] = item[0]; 
                pprcv_cps[grid][j].me[1] = item[1]; 
                pprcv_cps[grid][j].from_it[0] = on_item[0]; 
                pprcv_cps[grid][j].from_it[1] = on_item[1]; 
                recv_len = sizeof(COMPONENT)*nrecv;
                scalar(&pprcv_cps[grid][j].ipp_buf,recv_len);
                if(recv_src_pc != myid)
                {
#if defined(__MPI__)
                    pprcv_cps[grid][j].ipp_tag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch);

                    pp_irecv(pprcv_cps[grid][j].ipp_tag, recv_src_pc,
                          (POINTER)(pprcv_cps[grid][j].ipp_buf),recv_len,&(pprcv_cps[grid][j].ipp_reqs));
#endif /* if defined(__MPI__) */
                    /*
                    printf("Item[%d][%d] PPrecv comp from item[%d][%d] level[%d] data_size[%d] tag[%d] \n", 
                       item[0], item[1], 
                       on_item[0], on_item[1],
                       redistr_table[on_item[0]][on_item[1]].wv_level, nrecv,
                       pprcv_cps[grid][j].ipp_tag);
                    */ 
                } 
                else
                {
                    /*
                    int tmptag; 
                    tmptag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch);
                    printf("Item[%d][%d] CPrecv comp from item[%d][%d] level[%d] data_size[%d] tag[%d] \n", 
                       item[0], item[1], 
                       on_item[0], on_item[1],
                       redistr_table[on_item[0]][on_item[1]].wv_level, nrecv,
                       tmptag);
                    */
                }
            }
        }
       
        if(get_avg_blks != 0) 
            vector(&ppsnd_cps, get_avg_blks, sizeof(PP_cps*)); 
        for(grid = 0; grid < get_avg_blks; grid++)
        {
            item[0] = getavgset[grid].item[0]; 
            item[1] = getavgset[grid].item[1]; 
            front = redistr_table[item[0]][item[1]].front;
            wave = NULL; 
            for(i = 0; i < num_patches; i++)
            {
                if(front == frs[i])
                {
                    wave = wvs[i];
                    break;  
                }
            }

            avgbox = getavgset[grid].avgbox; 
            vector(&ppsnd_cps[grid],getavgset[grid].num_box,sizeof(PP_cps)); 
            for(j = 0; j < getavgset[grid].num_box; j++) 
            {
                on_item[0] = avgbox[j].on_item[0]; 
                on_item[1] = avgbox[j].on_item[1]; 
                send_dst_pc = redistr_table[on_item[0]][on_item[1]].pc_id;

                nsend = (avgbox[j].bound[0]-avgbox[j].base[0])*
                  (avgbox[j].bound[1]-avgbox[j].base[1]); 
                send_len = sizeof(COMPONENT)*nsend; 
                cps.num = nsend; 
                vector(&cps.comp,nsend,sizeof(COMPONENT)); 
                assign_snd_wv_comp(wave,redistr_table[item[0]][item[1]],
                    &avgbox[j],&cps); 

                ppsnd_cps[grid][j].me[0]= item[0];  
                ppsnd_cps[grid][j].me[1]= item[1];  
                ppsnd_cps[grid][j].to_it[0] = on_item[0];
                ppsnd_cps[grid][j].to_it[1] = on_item[1];
                ppsnd_cps[grid][j].num = nsend;
                scalar(&ppsnd_cps[grid][j].ipp_buf,send_len);
                bundle_blk_c(&ppsnd_cps[grid][j], &cps); 
                free(cps.comp); 

                if(myid != send_dst_pc)
                {
#if defined(__MPI__)
                    ppsnd_cps[grid][j].ipp_tag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                      trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch) +
                      trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;

                    pp_isend(ppsnd_cps[grid][j].ipp_tag,(POINTER)ppsnd_cps[grid][j].ipp_buf,
                        send_len, send_dst_pc, &(ppsnd_cps[grid][j].ipp_reqs));
#endif /* if defined(__MPI__) */
                    /* 
                    printf("Item[%d][%d] PPsend comp to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                         item[0], item[1],on_item[0], on_item[1],
                         redistr_table[on_item[0]][on_item[1]].wv_level,
                         nsend, ppsnd_cps[grid][j].ipp_tag);
                    */
                }
                else
                {
                    /*
                    int tmptag; 
                    tmptag = USER_MIN_MESG_ID+numnodes*max_n_patch*
                      trans_item_offset(redistr_table,on_item[0],on_item[1],max_n_patch) +
                      trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;
                     printf("Item[%d][%d] CPsend comp to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                         item[0], item[1],on_item[0], on_item[1],
                         redistr_table[on_item[0]][on_item[1]].wv_level,
                         nsend, tmptag);
                     */
                }
            }
        }

        /* Fine receiving components from coarse */
 
        for(grid = 0; grid < snd_avg_blks; grid++)
        {
            item[0] = sndavgset[grid].item[0]; 
            item[1] = sndavgset[grid].item[1]; 
            avgbox = sndavgset[grid].avgbox;
            for(j = 0; j < sndavgset[grid].num_box; j++)
            {
                on_item[0] = avgbox[j].to_item[0];
                on_item[1] = avgbox[j].to_item[1];
                recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                if(recv_src_pc == myid)
                {
                    locmatch = match_loc_comp_blk(item,on_item,ppsnd_cps,getavgset,get_avg_blks);   
                    if(pprcv_cps[grid][j].num != locmatch->num)
                    {
                        printf("ERROR coarse_post_comp_to_fine\n");
                        printf("The size of local send-recv does not match\n");
                        clean_up(ERROR); 
                    }
                    assign(pprcv_cps[grid][j].ipp_buf, locmatch->ipp_buf,
                            pprcv_cps[grid][j].num*sizeof(COMPONENT)); 
                    /*
                    printf("Item[%d][%d] LOCAL CPrecv comp from item[%d][%d] level[%d] by me[%d][%d] to[%d][%d]\n", 
                       item[0], item[1], 
                       on_item[0], on_item[1],
                       redistr_table[on_item[0]][on_item[1]].wv_level, 
                       locmatch->me[0], locmatch->me[1], locmatch->to_it[0],
                       locmatch->to_it[1]);
                    */
                }
            }
        }
#if defined(__MPI__)
        pprecvcomp = collect_recv_comp_blks(&pprecv_blks,redistr_table,max_n_patch,
                      pprcv_cps,sndavgset,snd_avg_blks); 
        /*
        for(j = 0; j < pprecv_blks; j++)
        {
            printf("Item[%d][%d] PPrecv comp from item[%d][%d] tag[%d] \n", 
                 pprecvcomp[j].me[0], pprecvcomp[j].me[1], 
                 pprecvcomp[j].from_it[0], pprecvcomp[j].from_it[1],
                 pprecvcomp[j].ipp_tag);
        }
        */

        if(pprecv_blks != 0) 
        {
            vector(&ipp_reqs, pprecv_blks, sizeof(MPI_Request));
            vector(&ipp_stat, pprecv_blks, sizeof(MPI_Status));
            vector(&irecv_indices, pprecv_blks, sizeof(int));
            vector(&irecv_flags, pprecv_blks, sizeof(int));

            for(i = 0; i < pprecv_blks; i++)
            {
                assign(&ipp_reqs[i], &(pprecvcomp[i].ipp_reqs), sizeof(MPI_Request));
                irecv_flags[i] = NO;
            }
            while(not_all_recved == YES)
            {
                MPI_Waitsome(pprecv_blks, ipp_reqs, &ndone, irecv_indices, ipp_stat);
                for(i = 0; i < ndone; i++)
                {
                    ii = irecv_indices[i];
                    if(irecv_flags[ii] != YES)
                    {
                        irecv_flags[ii] = YES;
                    }
                }
                not_all_recved = NO;
                for(i = 0; i < pprecv_blks; i++)
                {
                    if(irecv_flags[i] == NO)
                    {
                        not_all_recved = YES;
                        break;
                    }
                }
            }
            free_these(4,ipp_reqs,ipp_stat,irecv_indices,irecv_flags);
            free(pprecvcomp);
        } 
#endif /* if defined(__MPI__) */

        recv_comp_to_intrp_blks(rcv_icps,pprcv_cps,sndavgset,snd_avg_blks); 

        /* free pp_send */
        for(grid = 0; grid < get_avg_blks; grid++)
        {
            avgbox = getavgset[grid].avgbox; 
            for(j = 0; j < getavgset[grid].num_box; j++) 
            {
                on_item[0] = avgbox[j].on_item[0]; 
                on_item[1] = avgbox[j].on_item[1]; 
                send_dst_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                if(myid != send_dst_pc)
                {
#if defined(__MPI__)
                    MPI_Wait(&(ppsnd_cps[grid][j].ipp_reqs), &(ppsnd_cps[grid][j].ipp_stat));
#endif /* if defined(__MPI__) */
                }
                free(ppsnd_cps[grid][j].ipp_buf); 
            }
            free(ppsnd_cps[grid]); 
        }
        if(get_avg_blks != 0)
            free(ppsnd_cps); 

        /* free pp_receive */
        for(grid = 0; grid < snd_avg_blks; grid++)
        {
            for(j = 0; j < sndavgset[grid].num_box; j++) 
                free(pprcv_cps[grid][j].ipp_buf); 
            free(pprcv_cps[grid]); 
        }
        if(snd_avg_blks != 0)
            free(pprcv_cps);  

        return rcv_icps; 
}

LOCAL void recv_comp_to_intrp_blks(
        Intrp_cps   **rcv_icps, 
        PP_cps      **pprcv_cps,
        Amr_avg_set *sndavgset,
        int         snd_avg_blks)
{
        int         ii, j, grid; 
        int         myid;
        int         on_item[2]; 
        Trans_box *avgbox;

        for(grid = 0; grid < snd_avg_blks; grid++)
        {
            avgbox = sndavgset[grid].avgbox;
            for(j = 0; j < sndavgset[grid].num_box; j++)
                unbundle_blk_c(&pprcv_cps[grid][j], &rcv_icps[grid][j]);
        }

}

LOCAL PP_cps *collect_recv_comp_blks(
        int         *pprecv_blks,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        PP_cps      **pprcv_cps,
        Amr_avg_set *sndavgset,
        int         snd_avg_blks)
{
        int         ii, j, grid; 
        int         myid;
        int         recv_src_pc; 
        int         on_item[2]; 
        Trans_box *avgbox;
        PP_cps      *collect = NULL; 
       
        *pprecv_blks = 0; 
        myid = pp_mynode(); 
        for(grid = 0; grid < snd_avg_blks; grid++)
        {
            avgbox = sndavgset[grid].avgbox;
            for(j = 0; j < sndavgset[grid].num_box; j++)
            {
                on_item[0] = avgbox[j].to_item[0];
                on_item[1] = avgbox[j].to_item[1];
                recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                if(recv_src_pc != myid)
                    (*pprecv_blks)++; 
            }
        }
 
        ii = 0;        
        if(*pprecv_blks != 0)
        {
            vector(&collect, *pprecv_blks, sizeof(PP_cps)); 
            for(grid = 0; grid < snd_avg_blks; grid++)
            {
                avgbox = sndavgset[grid].avgbox;
                for(j = 0; j < sndavgset[grid].num_box; j++)
                {
                    on_item[0] = avgbox[j].to_item[0];
                    on_item[1] = avgbox[j].to_item[1];
                    recv_src_pc = redistr_table[on_item[0]][on_item[1]].pc_id;
                    if(recv_src_pc != myid)
                    {
                        assign(&collect[ii], &pprcv_cps[grid][j], sizeof(PP_cps));
                        ii++; 
                    }
                }
            }
        }
        return collect; 
}

LOCAL PP_cps *match_loc_comp_blk(
        int         *recvit,
        int         *fromit, 
        PP_cps      **ppsnd_cps,
        Amr_avg_set  *getavgset,
        int           get_avg_blks)
{
        int           j, grid;
        
        for(grid = 0; grid < get_avg_blks; grid++)
        {
            for(j = 0; j < getavgset[grid].num_box; j++)
            {
                if(fromit[0] != ppsnd_cps[grid][j].me[0] ||
                   fromit[1] != ppsnd_cps[grid][j].me[1]) continue;

                if(ppsnd_cps[grid][j].to_it[0] == recvit[0] &&
                   ppsnd_cps[grid][j].to_it[1] == recvit[1])
                return &ppsnd_cps[grid][j]; 
            } 
        }
        return NULL; 
}


LOCAL void unbundle_blk_c(
        PP_cps       *pp_cps,
        Intrp_cps    *i_cps)
{
        int         i;
        byte        *pp_buf; 
        size_t      sizecp = sizeof(COMPONENT);
        
        pp_buf = pp_cps->ipp_buf;
        for(i = 0; i < i_cps->num;  i++)
        {
            assign(&(i_cps->comp[i]),pp_buf,sizecp);
            pp_buf += sizecp; 
        }
}

LOCAL void bundle_blk_c(
        PP_cps       *pp_cps,
        Intrp_cps    *i_cps)
{
        int         i;
        byte        *pp_buf; 
        size_t      sizecp = sizeof(COMPONENT);
        
        pp_buf = pp_cps->ipp_buf;
        for(i = 0; i < i_cps->num;  i++)
        {
            assign(pp_buf,&(i_cps->comp[i]),sizecp);
            pp_buf += sizecp; 
        }
}

LOCAL void assign_snd_wv_comp(
        Wave        *wave,
        Wv_on_pc    redistr_table,
        Trans_box  *avgbox,
        Intrp_cps    *snd_cps)
{
        int         i, j, dim;
        int         base[MAXD], bound[MAXD]; 
        int         ix, iy, ic[MAXD]; 
        int         gmax[MAXD]; 

        dim = wave->rect_grid->dim;
        for(i = 0; i < dim; i++)
        {
            base[i] = avgbox->base[i] - redistr_table.base[i]; 
            bound[i] = avgbox->bound[i] - redistr_table.base[i]; 
            gmax[i] = wave->rect_grid->gmax[i]; 
        } 
        
        if((bound[0] - base[0])*(bound[1] - base[1]) != snd_cps->num)
        {
            printf("ERROR assign_snd_wv_comp, allocated not equal\n");
            printf("num = %d, %d\n", snd_cps->num,
              (bound[0]-base[0])*(bound[1]-base[1])); 
            clean_up(ERROR); 
        }
        if(base[0] < 0 || base[1] < 0 ||
           bound[0] > gmax[0] || bound[1] > gmax[1])
        {
            printf("ERROR assign_snd_wv_comp, box out range\n");
            printf("gmax[%d, %d]\n", gmax[0], gmax[1]); 
            printf("base[%d %d] bound[%d %d]\n", base[0], base[1], 
                bound[0], bound[1]); 
            clean_up(ERROR); 
        }
 
        /*
        printf("wave[%d]level[%d] send comp base[%d %d] bound[%d %d]\n",
                wave->patch_number, wave->patch_level, 
                base[0], base[1], bound[0], bound[1]); 
        */

        j = 0;
        for(iy = base[1]; iy < bound[1]; iy++)
        {
            for(ix = base[0]; ix < bound[0]; ix++)
            {
                ic[0] = ix; 
                ic[1] = iy; 
                snd_cps->comp[j] = Rect_comp(ic,wave); 
                j++; 
            } 
        }
       

}

        
        

LOCAL int count_snd_avg_patches_at_level(
        int         count_all_level, 
        int         on_level,
        Front       **frs,
        int         num_patches,
        Wv_on_pc    **redistr_table,
        int         max_n_patch,
        Overparam   *overparam,
        Amr_avg_set  **sndavgset)
{
        Front       *front; 
        int         i, ii, level, grid; 
        int         item[2];  
        int         snd_avg_blks; 

        snd_avg_blks = 0; 
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i]; 
            level = front->patch_level;
            if(level != on_level && count_all_level == NO) continue;

            if(level != 0)
                snd_avg_blks++;
        }

        ii = 0; 
        if(snd_avg_blks != 0)
            vector(sndavgset, snd_avg_blks, sizeof(Amr_avg_set)); 
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i]; 
            level = front->patch_level;
            if(level != on_level && count_all_level == NO) continue;

            if(level != 0)
            {
                loc_front_on_redistr_table(front,
                      redistr_table,max_n_patch,item); 
                (*sndavgset)[ii].item[0] = item[0];  
                (*sndavgset)[ii].item[1] = item[1];  
                ii++; 
            }
        }
        return snd_avg_blks; 
}

LOCAL void set_snd_avg_patch_ptset(
       Amr_avg_set    *sndavgit,
       Wv_on_pc       **redistr_table,
       int            max_n_patch,
       Overparam      *overparam,
       int            dim)
{
       int          oL[MAXD], oU[MAXD];
       int          iL[MAXD], iU[MAXD];
       int          cgL[MAXD], cgU[MAXD];
       int          i, j, item[2];
       int          ii, level, n_box;
       int          refine = overparam->refinementRatio;

       item[0] = sndavgit->item[0];
       item[1] = sndavgit->item[1];
       level = redistr_table[item[0]][item[1]].wv_level;

       for(i = 0; i < dim; i++)
       {
           oL[i] = redistr_table[item[0]][item[1]].base[i] +
                   redistr_table[item[0]][item[1]].off_set[i];
           oU[i] = redistr_table[item[0]][item[1]].bound[i] +
                   redistr_table[item[0]][item[1]].off_set[i];
       }

       n_box = 0; 
       for(i = 0; i < max_n_patch; i++)
       {
           if(redistr_table[item[0]][i].wv_id == -1) continue;
           if(redistr_table[item[0]][i].wv_level != level-1) continue;
           glb_refine_patch(redistr_table[item[0]][i],refine,dim,cgL,cgU);
           if(YES == box_intersect(oL,oU,cgL,cgU,dim,iL,iU))
               n_box++;
       }

       // printf("Item[%d][%d] send %d boxes\n", item[0], item[1], n_box);         

       if(n_box != 0)
       {
           sndavgit->num_box = n_box; 
           vector(&(sndavgit->avgbox), n_box, sizeof(Trans_box));      
       }
       else
       {
           printf("ERROR set_snd_avg_patch_ptset\n"); 
           printf("item do not find avg_pts\n"); 
           clean_up(ERROR); 
       } 

       ii = 0;
       for(i = 0; i < max_n_patch; i++)
       {
           if(redistr_table[item[0]][i].wv_id == -1) continue;
           if(redistr_table[item[0]][i].wv_level != level-1) continue;
           glb_refine_patch(redistr_table[item[0]][i],refine,dim,cgL,cgU);
           if(YES == box_intersect(oL,oU,cgL,cgU,dim,iL,iU))
           {
               sndavgit->avgbox[ii].on_item[0] = item[0];
               sndavgit->avgbox[ii].on_item[1] = item[1];
               sndavgit->avgbox[ii].to_item[0] = item[0];
               sndavgit->avgbox[ii].to_item[1] = i;
               for(j = 0; j < dim; j++)
               {
                   sndavgit->avgbox[ii].base[j] =
                       iL[j] - redistr_table[item[0]][item[1]].off_set[j];
                   sndavgit->avgbox[ii].bound[j] =
                       iU[j] - redistr_table[item[0]][item[1]].off_set[j];
               }
               /*
               printf("item[%d][%d] send to [%d][%d] base[%d %d] bound[%d %d]\n", 
                   item[0], item[1], item[0], i, 
                   sndavgit->avgbox[ii].base[0], 
                   sndavgit->avgbox[ii].base[1], 
                   sndavgit->avgbox[ii].bound[0], 
                   sndavgit->avgbox[ii].bound[1]); 
               */
               ii++;
           }
       }
}

LOCAL int pt_snd_avg_to_prv_level(
        int        *gic,
        int        *it,
        int        level,
        int        dim,
        Overparam  *overparam,
        Wv_on_pc   **redistr_table,
        int        max_n_patch,
        int        *on_it)
{
        int            numnodes, i;
        int            src, grid;
        int            cgL[MAXD], cgU[MAXD]; /* coarsened patch in global index */
        int            coarsen = overparam->refinementRatio;
        int            gic2[MAXD]; 

        numnodes = pp_numnodes();

        gic_to_level_indx(gic,level,level-1,coarsen,gic2,dim); 
        // printf("coarsen to prv level gic[%d %d]\n", gic2[0], gic2[1]); 

        for(src = 0; src < numnodes; src++)
        {
            for(grid = 0; grid < max_n_patch; grid++)
            {
                if(redistr_table[src][grid].wv_id == -1) continue;
                if(redistr_table[src][grid].wv_level != level-1) continue;

                if(gic2[0] >= redistr_table[src][grid].base[0] + 
                             redistr_table[src][grid].off_set[0] && 
                   gic2[0] < redistr_table[src][grid].bound[0] +
                            redistr_table[src][grid].off_set[0] &&
                   gic2[1] >= redistr_table[src][grid].base[1] + 
                             redistr_table[src][grid].off_set[1] && 
                   gic2[1] < redistr_table[src][grid].bound[1] + 
                            redistr_table[src][grid].off_set[1])
                {
                    on_it[0] = src;
                    on_it[1] = grid;
                    return YES;
                }
            }
        }
        return NO; 
}


LOCAL void set_get_avg_patch_ptset(
       Amr_avg_set    *getavgit,
       Wv_on_pc       **redistr_table,
       int            max_n_patch,
       Overparam      *overparam,
       int            dim)
{
       int          oL[MAXD], oU[MAXD];
       int          i, j, item[2];
       int          level;
       int          ii;
       int          n_box; 
       int          cgL[MAXD], cgU[MAXD]; /* coarsened patch in global index */
       int          iL[MAXD], iU[MAXD]; /* intersection box */
       int          coarsen = overparam->refinementRatio;


       item[0] = getavgit->item[0];
       item[1] = getavgit->item[1];
       level = redistr_table[item[0]][item[1]].wv_level;

       for(i = 0; i < dim; i++)
       {
           oL[i] = redistr_table[item[0]][item[1]].base[i] + 
                   redistr_table[item[0]][item[1]].off_set[i];
           oU[i] = redistr_table[item[0]][item[1]].bound[i] + 
                   redistr_table[item[0]][item[1]].off_set[i];
       }

       n_box = 0; 
       for(i = 0; i < max_n_patch; i++)
       {
           if(redistr_table[item[0]][i].wv_id == -1) continue;
           if(redistr_table[item[0]][i].wv_level != level+1) continue;
           glb_coarsen_patch(redistr_table[item[0]][i],coarsen,dim,cgL,cgU);
           if(YES == box_intersect(oL,oU,cgL,cgU,dim,iL,iU))
               n_box++; 
       }

       if(n_box != 0)
       {
           getavgit->num_box = n_box; 
           vector(&(getavgit->avgbox), n_box, sizeof(Trans_box));      
       }
       else
       {
           printf("ERROR set_get_avg_patch_ptset\n"); 
           printf("item do not find avg_pts\n"); 
           clean_up(ERROR); 
       } 

       ii = 0; 
       for(i = 0; i < max_n_patch; i++)
       {
           if(redistr_table[item[0]][i].wv_id == -1) continue;
           if(redistr_table[item[0]][i].wv_level != level+1) continue;
           glb_coarsen_patch(redistr_table[item[0]][i],coarsen,dim,cgL,cgU);
           if(YES == box_intersect(oL,oU,cgL,cgU,dim,iL,iU))
           {
               getavgit->avgbox[ii].on_item[0] = item[0]; 
               getavgit->avgbox[ii].on_item[1] = i; 
               for(j = 0; j < dim; j++)
               {
                   getavgit->avgbox[ii].base[j] = 
                       iL[j] - redistr_table[item[0]][item[1]].off_set[j];
                   getavgit->avgbox[ii].bound[j] = 
                       iU[j] - redistr_table[item[0]][item[1]].off_set[j];
               }
               ii++; 
           }
       }
}

LOCAL int pt_get_avg_from_nxt_level(
        int        *gic,
        int        *it,
        int        level,
        int        dim, 
        Overparam  *overparam,
        Wv_on_pc    **redistr_table,
        int         max_n_patch,
        int         *on_it)
{
        int            numnodes, i;
        int            src, grid;
        int            cgL[MAXD], cgU[MAXD]; /* coarsened patch in global index */
        int            coarsen = overparam->refinementRatio; 

        numnodes = pp_numnodes();

        for(src = 0; src < numnodes; src++)
        {          
            for(grid = 0; grid < max_n_patch; grid++)
            {
                if(redistr_table[src][grid].wv_id == -1) continue;
                if(redistr_table[src][grid].wv_level != level+1) continue;

                glb_coarsen_patch(redistr_table[src][grid],coarsen,dim,cgL,cgU);  
                if(gic[0] >= cgL[0] && gic[0] < cgU[0] &&
                   gic[1] >= cgL[1] && gic[1] < cgU[1])  
                {
                    on_it[0] = src; 
                    on_it[1] = grid;
                    return YES; 
                }
            }
        }
        return NO; 
}

LOCAL void glb_coarsen_patch(
        Wv_on_pc    redistr_table,
        int         coarse,
        int         dim,
        int         *cgL,
        int         *cgU)
{
        int         i;
        for(i = 0; i < dim; i++)
        {
            cgL[i] = redistr_table.base[i]/coarse +  
                     redistr_table.off_set[i]/coarse; 
            cgU[i] = redistr_table.bound[i]/coarse +  
                     redistr_table.off_set[i]/coarse; 
        }
} 

LOCAL void glb_refine_patch(
        Wv_on_pc    redistr_table,
        int         refine,
        int         dim,
        int         *cgL,
        int         *cgU)
{
        int         i;
        for(i = 0; i < dim; i++)
        {
            cgL[i] = redistr_table.base[i]*refine +  
                     redistr_table.off_set[i]*refine; 
            cgU[i] = redistr_table.bound[i]*refine +  
                     redistr_table.off_set[i]*refine; 
        }
} 

LOCAL int patch_has_child(
       int         *item,
       Wv_on_pc    **redistr_table,
       int         max_n_patch,
       int         coarsen,
       int         dim)
{
       int          oL[MAXD], oU[MAXD];
       int          cgL[MAXD], cgU[MAXD]; 
       int          iL[MAXD], iU[MAXD]; 
       int          level, grid;
       int          i; 

       level = redistr_table[item[0]][item[1]].wv_level; 
       for(i = 0; i < dim; i++)
       {
           oL[i] = redistr_table[item[0]][item[1]].base[i] + 
                   redistr_table[item[0]][item[1]].off_set[i];
           oU[i] = redistr_table[item[0]][item[1]].bound[i] +
                   redistr_table[item[0]][item[1]].off_set[i];
       }

       for(grid = 0; grid < max_n_patch; grid++)
       {
           if(redistr_table[item[0]][grid].wv_id == -1) continue;    
           if(redistr_table[item[0]][grid].wv_level != level+1) continue;    
           glb_coarsen_patch(redistr_table[item[0]][grid],coarsen,dim,cgL,cgU);
           if(YES == box_intersect(oL, oU, cgL, cgU, dim, iL, iU))
               return YES; 
       }
       return NO;  
}

LOCAL int count_get_avg_patches_at_level(
        int         count_all_level, 
        int         on_level,
        Front       **frs,
        int         num_patches,
        Wv_on_pc    **redistr_table,
        int         max_n_patch,
        Overparam  *overparam,
        Amr_avg_set  **getavgset)
{
        int            src, grid;
        int            i, ii, get_avg_blks;
        int            dim = frs[0]->rect_grid->dim;
        Front          *front;
        int            item[2], level, end_level;

        get_avg_blks = 0;
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level;
            if(level != on_level && count_all_level == NO) continue; 
 
            if(YES != loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item))
            {
                printf("ERROR count_get_avg_patches_at_level, ");
                printf("front not on the table\n");
                clean_up(ERROR);
            }
            for(grid = max_n_patch-1; grid >= 0; grid--)
            {
                if(redistr_table[item[0]][grid].wv_id == -1) continue;
                end_level = redistr_table[item[0]][grid].wv_level;
                break; 
            }
            if(end_level > level)
            {
                if(YES == patch_has_child(item,redistr_table,
                    max_n_patch,overparam->refinementRatio,dim)) 
                {
                    get_avg_blks++; 
                }
            }
        }

        ii = 0; 
        if(get_avg_blks != 0) 
            vector(getavgset, get_avg_blks, sizeof(Amr_avg_set)); 
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            level = front->patch_level;
            if(level != on_level && count_all_level == NO) continue; 
 
            loc_front_on_redistr_table(front,
                  redistr_table,max_n_patch,item); 

            for(grid = max_n_patch-1; grid >= 0; grid--)
            {
                if(redistr_table[item[0]][grid].wv_id == -1) continue;
                end_level = redistr_table[item[0]][grid].wv_level;
                break; 
            }
            if(end_level > level)
            {
                if(YES == patch_has_child(item,redistr_table,
                    max_n_patch,overparam->refinementRatio,dim))
                {
                    (*getavgset)[ii].item[0] = item[0]; 
                    (*getavgset)[ii].item[1] = item[1]; 
                    ii++; 
                }
            }
        }

        return get_avg_blks; 
}


LIB_LOCAL void wave_set_recv_intrp_blks_in_dir(
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        int          *iperm,
        int          swp,
        Amr_intrp_set  **getaintrp,
        int          *get_blk_n,
        Amr_intrp_set  **sndaintrp,
        int          *snd_blk_n)
{
        DEBUG_ENTER(wave_set_recv_intrp_blks_in_dir)

        (*get_blk_n) = set_recv_scatter_patch_in_dir(frs,num_patches,overparam,
                          redistr_table,max_n_patch,iperm,swp,getaintrp);

        (*snd_blk_n) = set_send_scatter_patch_in_dir(frs,num_patches,overparam,
                          redistr_table,max_n_patch,iperm,swp,sndaintrp);

        DEBUG_LEAVE(wave_set_recv_intrp_blks_in_dir)
}

LOCAL int set_send_scatter_patch_in_dir(
        Front        **frs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        int          *iperm,
        int          swp,
        Amr_intrp_set  **sndaintrp)
{
        PP_GRID      *pp_grid = frs[0]->pp_grid;
        int          dim = frs[0]->rect_grid->dim;
        int          item[3], level;
        int          i, grid;
        Amr_intrp_set  *tmpintrp, *aintrp = NULL;
        int          num = 0, alloc = 0;
        Front        *front;

        alloc = 10; 
        vector(sndaintrp, alloc, sizeof(Amr_intrp_set)); 

        for(grid = 0; grid < num_patches; grid++)
        {
            front = frs[grid]; 
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item); 
            level = front->patch_level; 
            aintrp = scatter_patch_in_dir_domain(item,level,iperm,swp,dim,
                    redistr_table,max_n_patch,pp_grid,overparam);             
            if(aintrp != NULL)
            {
                assign(&(*sndaintrp)[num],aintrp,sizeof(Amr_intrp_set)); 
                num++;       
                if(num == alloc)
                {
                    alloc += 10; 
                    vector(&tmpintrp, alloc, sizeof(Amr_intrp_set));
                    assign(tmpintrp, *sndaintrp, sizeof(Amr_intrp_set)*num);  
                    free(*sndaintrp); 
                    *sndaintrp = tmpintrp; 
                }
                free(aintrp);
            }
        }
        
        if(num == 0)
        {
            free(*sndaintrp); 
            *sndaintrp = NULL; 
        }

        return num;  
}

LOCAL Amr_intrp_set  *scatter_patch_in_dir_domain(
        int       *item,
        int       level,
        int       *iperm,
        int       swp,
        int       dim,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        PP_GRID   *pp_grid,             
        Overparam    *overparam)
{
 
        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD]; 
        int       iL[MAXD], iU[MAXD]; 
        int       bL[MAXD], bU[MAXD], gbL[MAXD], gbU[MAXD], it[2]; 
        int       *me, him1[MAXD], src_id1, him2[MAXD], src_id2;
        int       i, src, grid, side, numnodes; 
        int       levels; 
        Amr_intrp_set  *sndaintrp = NULL; 
        Amr_intrp_pt *apts = NULL;  
        int       npts = 0;  
        
        numnodes = pp_numnodes(); 
        me = redistr_table[item[0]][item[1]].pc_ic;
        src_id1 = neighbor_id(him1,me,iperm[swp],0,pp_grid);
        src_id2 = neighbor_id(him2,me,iperm[swp],1,pp_grid);

        for(i = max_n_patch-1; i >= 0; i--)
        {
            if(redistr_table[item[0]][i].wv_id == -1) continue;
            levels = redistr_table[item[0]][i].wv_level;
            break; 
        }

        set_search_domain(L,U,iperm,swp,dim,redistr_table[item[0]][item[1]],1);
        for(i = 0; i < dim; i++)
        {
            gL[i] = L[i] + redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i];
            gU[i] = U[i] + redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i];
        }

        for(src = 0; src < numnodes; src++)
        {
            if((redistr_table[src][0].pc_ic[0] == me[0] &&
                redistr_table[src][0].pc_ic[1] == me[1]) ||
               (redistr_table[src][0].pc_ic[0] == him1[0] &&
                redistr_table[src][0].pc_ic[1] == him1[1]) ||
               (redistr_table[src][0].pc_ic[0] == him2[0] &&
                redistr_table[src][0].pc_ic[1] == him2[1]))
            {
                for(grid = 0; grid < max_n_patch; grid++)
                {
                    if(redistr_table[src][grid].wv_id == -1) continue;
                    if(redistr_table[src][grid].wv_level != level) continue;
                    it[0] = src;
                    it[1] = grid; 
                    for(side = 0; side < 2; side++)
                    {
                        if(redistr_table[it[0]][it[1]].rect_bdry_type[iperm[swp]][side] !=
                            AMR_SUBDOMAIN_BOUNDARY &&
                           redistr_table[it[0]][it[1]].rect_bdry_type[iperm[swp]][side] !=
                            SUBDOMAIN_BOUNDARY)
                        continue;
                        patch_scat_buf_in_dir(bL,bU,iperm,swp,side,redistr_table, dim,it); 
                        for(i = 0; i < dim; i++)
                        {
                            gbL[i] = bL[i] + redistr_table[it[0]][it[1]].base[i] +
                                    redistr_table[it[0]][it[1]].off_set[i];
                            gbU[i] = bU[i] + redistr_table[it[0]][it[1]].base[i] +
                                    redistr_table[it[0]][it[1]].off_set[i];
                        } 
                        if(YES == box_intersect(gL,gU,gbL,gbU,dim,iL,iU))
                        {
                            if(sndaintrp == NULL)
                            {
                                scalar(&sndaintrp,sizeof(Amr_intrp_set));
                                sndaintrp->item[0] = item[0]; 
                                sndaintrp->item[1] = item[1]; 
                            }
                            for(i = 0; i < dim; i++)
                            {
                                iL[i] -= (redistr_table[it[0]][it[1]].base[i] +
                                          redistr_table[it[0]][it[1]].off_set[i]);
                                iU[i] -= (redistr_table[it[0]][it[1]].base[i] +
                                          redistr_table[it[0]][it[1]].off_set[i]);
                            } 
                            apts = add_box_to_intrp_set(iL,iU,apts,&npts,
                                         it,dim);  
                        }
                    }
                }
            }
        }

        if(sndaintrp != NULL)
        {
            sndaintrp->apts = apts;
            sndaintrp->n_pts = npts;
        }  

        if(level == levels)
           return sndaintrp;

        /* Check whether this level will intrp. points for the next fine level */

        for(grid = 0; grid < max_n_patch; grid++)
        {
            if(redistr_table[item[0]][grid].wv_id == -1) continue; 
            if(redistr_table[item[0]][grid].wv_level != level+1) continue; 
            it[0] = item[0];
            it[1] = grid; 
            if(NO == patch2_is_patch1_child(item,it,redistr_table,
                max_n_patch,overparam->refinementRatio,dim))
                continue; 

            scatter_nxt_fpatch_in_dir_domain(&sndaintrp,item,it,level+1,
                 iperm,swp,dim,redistr_table,max_n_patch,overparam,pp_grid);
        }

        return sndaintrp;
}

LOCAL Amr_intrp_pt *add_box_to_intrp_set(
        int       *L,
        int       *U,
        Amr_intrp_pt *apts,
        int       *npts,
        int       *item,
        int       dim)
{
        Amr_intrp_pt *tmpapts;
        int          ix, iy, j, size = 1; 
        int        allocpts; 

        for(j = 0; j < dim; j++)
            size *= (U[j]-L[j]);

        j = 0; 
        if(apts == NULL)
        {
            vector(&tmpapts,size,sizeof(Amr_intrp_pt)); 
            *npts = size; 
            for(iy = L[1]; iy < U[1]; iy++)
            {
                for(ix = L[0]; ix < U[0]; ix++)
                {
                    tmpapts[j].ic[0] = ix; 
                    tmpapts[j].ic[1] = iy; 
                    tmpapts[j].on_item[0] = item[0]; 
                    tmpapts[j].on_item[1] = item[1]; 
                    j++; 
                }
            }
            apts = tmpapts; 
        }
        else
        {
            allocpts = size + (*npts); 
            vector(&tmpapts, allocpts, sizeof(Amr_intrp_pt));
            assign(tmpapts, apts, sizeof(Amr_intrp_pt)*(*npts)); 
            free(apts);
            apts = tmpapts; 

            for(iy = L[1]; iy < U[1]; iy++)
            {
                for(ix = L[0]; ix < U[0]; ix++)
                {
                    apts[(*npts)+j].ic[0] = ix; 
                    apts[(*npts)+j].ic[1] = iy; 
                    apts[(*npts)+j].on_item[0] = item[0]; 
                    apts[(*npts)+j].on_item[1] = item[1]; 
                    j++; 
                }
            }
            (*npts) += size; 
        }
        return apts; 
}

LOCAL int patch2_is_patch1_child(
       int         *item,
       int         *item2,
       Wv_on_pc    **redistr_table,
       int         max_n_patch,
       int         coarsen,
       int         dim)
{
       int          oL[MAXD], oU[MAXD];
       int          cgL[MAXD], cgU[MAXD];
       int          iL[MAXD], iU[MAXD];
       int          level, grid, level2;
       int          i;

       level = redistr_table[item[0]][item[1]].wv_level;
       level2 = redistr_table[item2[0]][item2[1]].wv_level;
      
       if(level+1 != level2) return NO;  

       for(i = 0; i < dim; i++)
       {
           oL[i] = redistr_table[item[0]][item[1]].base[i] +
                   redistr_table[item[0]][item[1]].off_set[i];
           oU[i] = redistr_table[item[0]][item[1]].bound[i] +
                   redistr_table[item[0]][item[1]].off_set[i];
       }

       glb_coarsen_patch(redistr_table[item2[0]][item2[1]],coarsen,dim,cgL,cgU);
       if(YES == box_intersect(oL,oU,cgL,cgU,dim,iL,iU))
           return YES;
       else 
           return NO; 
}

LOCAL void scatter_nxt_fpatch_in_dir_domain(
        Amr_intrp_set  **aintrp,
        int       *item,
        int       *fnit,
        int       flevel,
        int       *iperm,
        int       swp,
        int       dim,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        Overparam *overparam,
        PP_GRID   *pp_grid)
{
        int       side; 

        for(side = 0; side < 2; side++)
        {
            if(redistr_table[fnit[0]][fnit[1]].rect_bdry_type[iperm[swp]][side] !=
                 AMR_SUBDOMAIN_BOUNDARY &&
               redistr_table[fnit[0]][fnit[1]].rect_bdry_type[iperm[swp]][side] !=
                 SUBDOMAIN_BOUNDARY)
            continue;

            buf_scatter_by_coarse_in_dir(aintrp,item,fnit,flevel,iperm,
                swp,dim,side,redistr_table, max_n_patch,overparam,pp_grid);
            
        }
}


LOCAL int  buf_scatter_by_coarse_in_dir(
        Amr_intrp_set  **aintrp,
        int       *item,
        int       *fnit,
        int       flevel,
        int       *iperm,
        int       swp,
        int       dim,
        int       side,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        Overparam *overparam,
        PP_GRID   *pp_grid)
{
        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD];
        int       iL[MAXD], iU[MAXD];
        int       bL[MAXD], bU[MAXD], it[2];
        int       bL2[MAXD], bU2[MAXD];
        int       *me, him[MAXD], src_id;
        int       i, src, grid, numnodes;
        int       levels;
        Trans_box  *avgbox = NULL;
        int       allocbox, nbox = 0; 
        Amr_intrp_pt *apts = NULL;  
        int       npts = 0, allocpts = 0;  

        patch_scat_buf_in_dir(bL,bU,iperm,swp,side,redistr_table, dim,fnit);
        set_search_domain(L,U,iperm,swp,dim,redistr_table[item[0]][item[1]],0);
        for(i = 0; i < dim; i++)
        {
            gL[i] = overparam->refinementRatio*(
                    redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i] + L[i]); 
            gU[i] = overparam->refinementRatio*(
                    redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i] + U[i]); 
        }
        for(i = 0; i < dim; i++)
        {
            L[i] = gL[i] - (redistr_table[fnit[0]][fnit[1]].base[i] +
                     redistr_table[fnit[0]][fnit[1]].off_set[i]);
            U[i] = gU[i] - (redistr_table[fnit[0]][fnit[1]].base[i] +
                     redistr_table[fnit[0]][fnit[1]].off_set[i]);
        } 
        if(NO == box_intersect(bL,bU,L,U,dim,bL2,bU2))
            return NO; 

        numnodes = pp_numnodes();
        me = redistr_table[item[0]][item[1]].pc_ic;
        src_id = neighbor_id(him,me,iperm[swp],side,pp_grid);

        for(src = 0; src < numnodes; src++)
        {
            if((redistr_table[src][0].pc_ic[0] == me[0] &&
                redistr_table[src][0].pc_ic[1] == me[1]) ||
               (redistr_table[src][0].pc_ic[0] == him[0] &&
                redistr_table[src][0].pc_ic[1] == him[1]))
            {
                for(grid = 0; grid < max_n_patch; grid++)
                {
                    if(redistr_table[src][grid].wv_id == -1) continue;
                    if(redistr_table[src][grid].wv_level != flevel) continue;
                    it[0] = src;
                    it[1] = grid;
                    set_search_domain(L,U,iperm,swp,dim,redistr_table[it[0]][it[1]],1);
                    for(i = 0; i < dim; i++)
                    {
                        gL[i] = L[i] + redistr_table[it[0]][it[1]].base[i] +
                                redistr_table[it[0]][it[1]].off_set[i] - 
                                (redistr_table[fnit[0]][fnit[1]].base[i] +
                                 redistr_table[fnit[0]][fnit[1]].off_set[i]);
                        gU[i] = U[i] + redistr_table[it[0]][it[1]].base[i] +
                                redistr_table[it[0]][it[1]].off_set[i] -
                                (redistr_table[fnit[0]][fnit[1]].base[i] +
                                 redistr_table[fnit[0]][fnit[1]].off_set[i]);
                    }
                    if(YES == box_intersect(gL,gU,bL,bU,dim,iL,iU))
                        avgbox = add_to_box(iL,iU,dim,avgbox,&nbox,&allocbox); 
                }
            }
        }
 
        if(avgbox != NULL)
        {
            if(YES == box_in_boxes(bL,bU,avgbox,nbox,dim))
            {
                free(avgbox); 
                return NO; 
            } 
        }

        add_pts_to_intrp_set(&apts,&npts,&allocpts,bL2,bU2,avgbox,nbox,dim,fnit); 

        if(*aintrp == NULL)
        {
            scalar(aintrp, sizeof(Amr_intrp_set));  
            (*aintrp)->item[0] = item[0];
            (*aintrp)->item[1] = item[1];
            (*aintrp)->apts = apts;
            (*aintrp)->n_pts = npts; 
        }
        else
        {
            Amr_intrp_pt *tmpapts = NULL;  
            int       tmpnpts;  
            tmpnpts = (*aintrp)->n_pts + npts;
            vector(&tmpapts, tmpnpts, sizeof(Amr_intrp_pt)); 
            assign(tmpapts, (*aintrp)->apts, sizeof(Amr_intrp_pt)*(*aintrp)->n_pts); 
            assign(&tmpapts[(*aintrp)->n_pts], apts, sizeof(Amr_intrp_pt)*npts); 
            free_these(2,apts,(*aintrp)->apts); 
            (*aintrp)->apts = tmpapts;
            (*aintrp)->n_pts = tmpnpts; 
        }

        if(avgbox != NULL)
            free(avgbox); 
        return YES; 
}

LOCAL void add_pts_to_intrp_set(
        Amr_intrp_pt **apts,  
        int         *npts,
        int         *allocpts,  
        int         *L,
        int         *U,
        Trans_box  *avgbox,
        int          nbox,
        int          dim,
        int          *item)
{
        Amr_intrp_pt *tmpapts;
        int          ix, iy, j, ic[MAXD];

        if(*apts == NULL)
        {
            *allocpts = 400; 
            vector(apts, *allocpts, sizeof(Amr_intrp_pt));  
            *npts = 0; 
        }

        j = 0;   
        for(iy = L[1]; iy < U[1]; iy++)
        {
            for(ix = L[0]; ix < U[0]; ix++)
            {
                ic[0] = ix; 
                ic[1] = iy; 
                if(YES == point_in_boxes(ic,avgbox,nbox,dim))
                    continue; 
                (*apts)[*npts+j].ic[0] = ix;
                (*apts)[*npts+j].ic[1] = iy;
                (*apts)[*npts+j].on_item[0] = item[0];
                (*apts)[*npts+j].on_item[1] = item[1];
                j++;
                if((*npts+j) == *allocpts)
                {
                    *allocpts += 400; 
                    vector(&tmpapts, *allocpts, sizeof(Amr_intrp_pt));
                    assign(tmpapts, *apts, sizeof(Amr_intrp_pt)*(j+*npts)); 
                    free(*apts);
                    *apts = tmpapts; 
                }
            }
        }
        *npts += j;
}
        



LOCAL void patch_scat_buf_in_dir(
        int          *L,
        int          *U,
        int          *iperm,
        int          swp,
        int          side,
        Wv_on_pc     **redistr_table,
        int          dim,
        int          *item)
{
        int          i, j;
        int          refine;
        int          ggmin[MAXD], ggmax[MAXD];
        int          patch_number, level;
        int          base[MAXD], bound[MAXD];
        int          tmpL[MAXD], tmpU[MAXD];

        if(redistr_table[item[0]][item[1]].rect_bdry_type[iperm[swp]][side] !=
            AMR_SUBDOMAIN_BOUNDARY &&
           redistr_table[item[0]][item[1]].rect_bdry_type[iperm[swp]][side] !=
            SUBDOMAIN_BOUNDARY)
        {
            for(j = 0; j < dim; j++)
            {
                L[j] = U[j] = 0;
            }
            return;
        }

        set_recv_domain(L,U,iperm,side,swp,dim,
              redistr_table[item[0]][item[1]]);
        return;
}

LOCAL int set_recv_scatter_patch_in_dir(
        Front        **frs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        int          *iperm,
        int          swp,
        Amr_intrp_set  **getaintrp)
{
        PP_GRID      *pp_grid = frs[0]->pp_grid;
        int          dim = frs[0]->rect_grid->dim;
        int          item[3], level;
        int          i, j, side, grid;
        int          alloc = 0, num = 0;
        Amr_intrp_set  *tmpintrp, *aintrp = NULL;
        Front        *front; 

        alloc = 10; 
        vector(getaintrp, alloc, sizeof(Amr_intrp_set)); 
        for(grid = 0; grid < num_patches; grid++)
        {
            front = frs[grid];  
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item); 
            level = front->patch_level;  

            for(side = 0; side < 2; side++)
            {
                if(rect_boundary_type(front->interf,iperm[swp],side) !=
                        AMR_SUBDOMAIN_BOUNDARY &&
                   rect_boundary_type(front->interf,iperm[swp],side) !=
                        SUBDOMAIN_BOUNDARY)
                    continue;
                aintrp = buf_scattered_by_patches_in_dir(item,level,iperm,swp,dim,side,
                    redistr_table,max_n_patch,pp_grid,overparam); 
                if(aintrp != NULL)
                {
                    assign(&(*getaintrp)[num],aintrp,sizeof(Amr_intrp_set));
                    num++;
                    if(num == alloc)
                    {
                        alloc += 10;
                        vector(&tmpintrp, alloc, sizeof(Amr_intrp_set));
                        assign(tmpintrp, *getaintrp, sizeof(Amr_intrp_set)*num);
                        free(*getaintrp);
                        *getaintrp = tmpintrp;
                    }
                    free(aintrp);
                }
            }
        }

        if(num == 0)
        {
            free(*getaintrp);
            *getaintrp = NULL; 
        }

        return num; 
}

LOCAL Amr_intrp_set *buf_scattered_by_patches_in_dir(
        int       *item,
        int       level,
        int       *iperm,
        int       swp,
        int       dim,
        int       side, 
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        PP_GRID   *pp_grid,
        Overparam    *overparam)
{

        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD];
        int       iL[MAXD], iU[MAXD];
        int       bL[MAXD], bU[MAXD], it[2];
        int       bL2[MAXD], bU2[MAXD];
        int       *me, src_id, him[MAXD];
        int       i, src, grid, numnodes;
        Amr_intrp_set  *getaintrp = NULL;
        Amr_intrp_pt *apts = NULL, *apts2 = NULL;
        int       npts = 0, allocpts = 0;
        Trans_box  *avgbox = NULL; 
        int       allocbox, nbox = 0; 

        patch_scat_buf_in_dir(bL,bU,iperm,swp,side,redistr_table,dim,item);

        numnodes = pp_numnodes();
        me = redistr_table[item[0]][item[1]].pc_ic;
        src_id = neighbor_id(him,me,iperm[swp],side,pp_grid);

        for(src = 0; src < numnodes; src++)
        {
            if((redistr_table[src][0].pc_ic[0] == me[0] &&
                redistr_table[src][0].pc_ic[1] == me[1]) ||
               (redistr_table[src][0].pc_ic[0] == him[0] &&
                redistr_table[src][0].pc_ic[1] == him[1]))
            {
                for(grid = 0; grid < max_n_patch; grid++)
                {
                    if(redistr_table[src][grid].wv_id == -1) continue;
                    if(redistr_table[src][grid].wv_level != level) continue;
                    it[0] = src;
                    it[1] = grid;
                    set_search_domain(L,U,iperm,swp,dim,redistr_table[it[0]][it[1]],1);
                    for(i = 0; i < dim; i++)
                    {
                        gL[i] = L[i] + redistr_table[it[0]][it[1]].base[i] +
                                  redistr_table[it[0]][it[1]].off_set[i] -
                                 (redistr_table[item[0]][item[1]].base[i] +
                                  redistr_table[item[0]][item[1]].off_set[i]);
                        gU[i] = U[i] + redistr_table[it[0]][it[1]].base[i] +
                                  redistr_table[it[0]][it[1]].off_set[i] -
                                 (redistr_table[item[0]][item[1]].base[i] +
                                  redistr_table[item[0]][item[1]].off_set[i]);
                    }
                    if(YES == box_intersect(bL,bU,gL,gU,dim,iL,iU))
                    {
                        if(getaintrp == NULL)
                        {
                            scalar(&getaintrp,sizeof(Amr_intrp_set));
                            getaintrp->item[0] = item[0];
                            getaintrp->item[1] = item[1];
                        }
                        apts = add_box_to_intrp_set(iL,iU,apts,&npts,
                                         it,dim);
                        avgbox = add_to_box(iL,iU,dim,avgbox,&nbox,&allocbox);
                    }
                }
            }
        }

        if(getaintrp != NULL)
        {
            getaintrp->apts = apts;
            getaintrp->n_pts = npts;
        }
        
        if(level == 0)
        {
            if(avgbox != NULL) 
                free(avgbox); 
            return getaintrp; 
        }
      
        /* Check whether this buf get it's state from the next coarse */ 
        
        if(avgbox != NULL)
        {
            if(YES == box_in_boxes(bL,bU,avgbox,nbox,dim))
            {
                free(avgbox); 
                return getaintrp; 
            }
        }

        for(grid = 0; grid < max_n_patch; grid++)
        {
            if(redistr_table[item[0]][grid].wv_id == -1) continue;
            if(redistr_table[item[0]][grid].wv_level != level-1) continue;
            it[0] = item[0];
            it[1] = grid;
            if(YES == patch2_is_patch1_child(it,item,redistr_table,
                max_n_patch,overparam->refinementRatio,dim))
            {
                set_search_domain(L,U,iperm,swp,dim,redistr_table[it[0]][it[1]],0);
                for(i = 0; i < dim; i++)
                {
                    gL[i] = overparam->refinementRatio*(
                            redistr_table[it[0]][it[1]].base[i] +
                            redistr_table[it[0]][it[1]].off_set[i] + L[i]);
                    gU[i] = overparam->refinementRatio*(
                            redistr_table[it[0]][it[1]].base[i] +
                            redistr_table[it[0]][it[1]].off_set[i] + U[i]);
                }
                for(i = 0; i < dim; i++)
                {
                    L[i] = gL[i] - (redistr_table[item[0]][item[1]].base[i] +
                             redistr_table[item[0]][item[1]].off_set[i]);
                    U[i] = gU[i] - (redistr_table[item[0]][item[1]].base[i] +
                             redistr_table[item[0]][item[1]].off_set[i]);
                }
                if(YES == box_intersect(bL,bU,L,U,dim,bL2,bU2))
                {
                    add_pts_to_intrp_set(&apts2,&npts,&allocpts,bL2,bU2,avgbox,nbox,dim,it);
                }
            }
        }

        if(apts2 == NULL)
        {
            printf("ERROR buf_scattered_by_patches_in_dir\n");
            printf("buffer is not covered by the same level fine or the next coarse\n"); 
            clean_up(ERROR); 
        }

        if(getaintrp == NULL)
        {
            scalar(&getaintrp,sizeof(Amr_intrp_set));
            getaintrp->item[0] = item[0];
            getaintrp->item[1] = item[1];
            getaintrp->apts = apts2;
            getaintrp->n_pts = npts;
        }
        else
        {
            Amr_intrp_pt *tmpapts = NULL;
            int       tmpnpts;
            tmpnpts = getaintrp->n_pts + npts;
            vector(&tmpapts, tmpnpts, sizeof(Amr_intrp_pt));
            assign(tmpapts, getaintrp->apts, sizeof(Amr_intrp_pt)*getaintrp->n_pts);
            assign(&tmpapts[getaintrp->n_pts], apts2, sizeof(Amr_intrp_pt)*npts);
            free_these(2,apts2,getaintrp->apts);
            getaintrp->apts = tmpapts;
            getaintrp->n_pts = tmpnpts;
        }

        if(avgbox != NULL)
            free(avgbox); 
        return getaintrp; 
}

LIB_LOCAL PP_cps **wave_post_recv_intrp_blks(
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch)
{
        int          numnodes, myid;
        int          i, j, src, grid, nsend;
        int          item[2];
        Front        *front;
        Wave         *wave;
        int          n_recv_wvs, **in_item, **do_item;
        int          recv_src, recv_grid;
        int          recv_src_pc;
        int          it_offset;
        PP_cps       **recv_cps;
        size_t       recv_len, sizest;


        numnodes = pp_numnodes();
        myid = pp_mynode();
        sizest = wvs[0]->sizest;
        vector(&recv_cps, num_patches, sizeof(PP_cps*));

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item);
            in_item = count_recv_intrp_on_wvs(item,aintrp,intrp_blk_n,&n_recv_wvs);
            if(n_recv_wvs != 0)
                vector(&recv_cps[i], n_recv_wvs, sizeof(PP_cps));

            /*
            printf("On node[%d], patch[%d][%d] has to recv intrp on %d waves\n",
                    myid, item[0], item[1], n_recv_wvs);
            */
            for(j = 0; j < n_recv_wvs; j++)
            {
                int recv_n;
                recv_n = count_recv_num_intrp_on_wv(item,aintrp,intrp_blk_n,in_item,j);
                recv_src = in_item[j][0];
                recv_grid = in_item[j][1];
                recv_src_pc = redistr_table[recv_src][recv_grid].pc_id;

                recv_cps[i][j].me[0] = item[0];
                recv_cps[i][j].me[1] = item[1];
                recv_cps[i][j].num = recv_n;
                recv_cps[i][j].from_it[0] = recv_src;
                recv_cps[i][j].from_it[1] = recv_grid;
                recv_len = (sizeof(COMPONENT)+sizest)*recv_n;
                scalar(&recv_cps[i][j].ipp_buf,recv_len);
                if(recv_src_pc != myid)
                {
#if defined(__MPI__)
                    recv_cps[i][j].ipp_tag = numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,recv_src,recv_grid,max_n_patch);
                    pp_irecv(recv_cps[i][j].ipp_tag, recv_src_pc,
                          (POINTER)(recv_cps[i][j].ipp_buf),recv_len,&(recv_cps[i][j].ipp_reqs));
                    /*
                    printf("[%d][%d] PPrecv intrp from item[%d][%d] level[%d] data_size[%d] tag[%d] \n",
                       item[0],item[1],in_item[j][0], in_item[j][1],
                       redistr_table[recv_src][recv_grid].wv_level, recv_n,
                       recv_cps[i][j].ipp_tag);
                    */ 
#endif /* if defined(__MPI__) */
                }
                else
                {
                    /*
                    int tmptag;
                    tmptag = numnodes*max_n_patch*
                          trans_item_offset(redistr_table,item[0],item[1],max_n_patch)+
                          trans_item_offset(redistr_table,recv_src,recv_grid,max_n_patch);
                    printf("[%d][%d] CPrecv intrp from item[%d][%d] level[%d] data_size[%d] tag[%d]\n",
                       item[0],item[1],in_item[j][0], in_item[j][1],
                       redistr_table[recv_src][recv_grid].wv_level, recv_n, tmptag);
                    */
                }
            }
        }

        return recv_cps;
}

LIB_LOCAL void wave_intrp_buf_blks_in_dir(
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        int          *iperm,
        int          swp,
        PP_cps       **pprcv_cps,
        Amr_intrp_set  *getaintrp,
        int            get_blk_n,
        Amr_intrp_set  *sndaintrp,
        int            snd_blk_n)
{
        int          numnodes, myid;
        int          i, j, src, grid, nsend;
        int          item[2], level, side;
        Front        *front;
        Wave         *wave;
        INTERFACE    *intfc;
        int          n_snd_wvs, **do_item;
        int          s_blk, send_dst, send_grid, send_dst_pc;
        int          ll, levels;
        Intrp_cps    snd_cps;
        size_t       send_len, sizest = wvs[0]->sizest;
        PP_cps       **ppsnd_cps;

        DEBUG_ENTER(wave_intrp_buf_blks_in_dir)

        for(i = 0; i < num_patches; i++)
        {
            intfc = frs[i]->interf;
            for(side = 0; side < 2; side++)
            {
                if (rect_boundary_type(intfc,iperm[swp],side)
                       == REFLECTION_BOUNDARY)
                {
                    reflect_states_across_domain(iperm,side,swp,frs[i],wvs[i]);
                }
            }
        }

        numnodes = pp_numnodes();
        myid = pp_mynode();
        levels = overparam->numberOfRefinementLevels;

        vector(&ppsnd_cps, num_patches, sizeof(PP_cps*));
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            wave = wvs[i];
            level = front->patch_level;
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item);
           
            do_item = count_wave_send_intrp(item,sndaintrp,snd_blk_n,&n_snd_wvs);
            /*
            printf("On node[%d], patch[%d][%d] sends intrp to %d waves\n",
                    myid, item[0], item[1], n_snd_wvs);
            */
            if(n_snd_wvs != 0)
            {
                vector(&ppsnd_cps[i], n_snd_wvs, sizeof(PP_cps));
                for(j = 0; j < n_snd_wvs; j++)
                {
                    int send_n;

                    send_dst = do_item[j][0];
                    send_grid = do_item[j][1];
                    if(level == redistr_table[send_dst][send_grid].wv_level)
                    {
                        send_n = count_wave_send_num_intrp(item,sndaintrp,snd_blk_n,do_item,j);
                        send_dst_pc = redistr_table[send_dst][send_grid].pc_id;
                        snd_cps.num = send_n;
                        aloc_intrp_cps_storage(&snd_cps,sizest);
                        copy_same_l_snd_val(&snd_cps,wave,front,
                           item,sndaintrp,snd_blk_n,do_item,j,redistr_table);

                        ppsnd_cps[i][j].me[0] = item[0];
                        ppsnd_cps[i][j].me[1] = item[1];
                        ppsnd_cps[i][j].to_it[0] = send_dst;
                        ppsnd_cps[i][j].to_it[1] = send_grid;
                        ppsnd_cps[i][j].num = send_n;
                        send_len = (sizeof(COMPONENT)+sizest)*send_n;
                        scalar(&ppsnd_cps[i][j].ipp_buf,send_len);

                        bundle_blk_cst(&ppsnd_cps[i][j],&snd_cps,wave);
                        if(myid != send_dst_pc)
                        {
#if defined(__MPI__)
                            ppsnd_cps[i][j].ipp_tag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;
                            pp_isend(ppsnd_cps[i][j].ipp_tag,(POINTER)ppsnd_cps[i][j].ipp_buf,
                              send_len, send_dst_pc, &(ppsnd_cps[i][j].ipp_reqs));
                            /*
                            printf("[%d][%d] PPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst, send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, ppsnd_cps[i][j].ipp_tag);
                            */
#endif /* if defined(__MPI__) */
                        }
                        else
                        {
                            /*
                            int tmptag;
                            tmptag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch);
                            printf("[%d][%d] CPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst, send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, tmptag);
                            */
                        }
                        free_these(3,snd_cps.comp, snd_cps.state, snd_cps.state_storage);
                    }
                }
            }
        }

        perform_recv_slevel_buf_blks(frs,wvs,num_patches,redistr_table,
              max_n_patch,pprcv_cps,ppsnd_cps,getaintrp,get_blk_n,
              sndaintrp,snd_blk_n);

        for(ll = 0; ll < levels-1; ll++)
        {
            // Patch on level (ll) interp for the next fine
            // if there are any. Send the interpolated to level ll+1
            wave_snd_intrp_buf_blks_at_lev_to_nxt(ll,frs,wvs,num_patches,
               redistr_table,max_n_patch,overparam,sndaintrp,snd_blk_n,
               &ppsnd_cps);

            wave_rcv_intrp_buf_blks_at_lev_from_prev(ll+1,frs,wvs,num_patches,
               redistr_table,max_n_patch,overparam,getaintrp,get_blk_n,
                sndaintrp,snd_blk_n,ppsnd_cps,pprcv_cps);
        }

        wait_and_free_all_snd_blks(&ppsnd_cps,sndaintrp,snd_blk_n,
         frs,num_patches,redistr_table,max_n_patch);
       free_wv_recv_intrp_blks(pprcv_cps,getaintrp,get_blk_n,
         frs,num_patches,redistr_table,max_n_patch);

        for(i = 0; i < snd_blk_n; i++)
            free(sndaintrp[i].apts);
        if(snd_blk_n != 0)
            free(sndaintrp);
        for(i = 0; i < get_blk_n; i++)
            free(getaintrp[i].apts);
        if(get_blk_n != 0)
            free(getaintrp);

        DEBUG_LEAVE(wave_intrp_buf_blks_in_dir)
}

LOCAL void wave_rcv_intrp_buf_blks_at_lev_from_prev(
        int          on_level,
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        Amr_intrp_set  *sndaintrp,
        int          snd_blk_n,
        PP_cps       **ppsnd_cps,
        PP_cps       **pprcv_cps)
{
        Front        *front;
        Wave         *wave;
        size_t       sizest = wvs[0]->sizest;
        PP_cps       *lpprecv_cps, *lcprecv_cps, cpcps;
        int          i, j, ii, level_blks;
        int          me[2], from_it[2], n_snd_wvs;
        int          **do_item;
        Intrp_cps    i_cps;
#if defined(__MPI__)
        MPI_Request *ipp_reqs;
        MPI_Status  *ipp_stat;
        int         *irecv_indices, *irecv_flags;
        int         ndone, not_all_recved = YES;
#endif /* if defined(__MPI__) */

        DEBUG_ENTER(wave_rcv_intrp_buf_blks_at_lev_from_prev)

        lcprecv_cps = collect_recv_intrp_blks_on_level(on_level,pprcv_cps,
            frs,num_patches,redistr_table,max_n_patch,
            aintrp,intrp_blk_n,NO,&level_blks);

        if(level_blks != 0)
        {
            for(i = 0; i < level_blks; i++)
            {
                from_it[0] = lcprecv_cps[i].from_it[0];
                from_it[1] = lcprecv_cps[i].from_it[1];
                me[0] = lcprecv_cps[i].me[0];
                me[1] = lcprecv_cps[i].me[1];
                i_cps.num = lcprecv_cps[i].num;
                aloc_intrp_cps_storage(&i_cps,sizest);

                cpcps = find_match_loc_snd_blk(&lcprecv_cps[i],ppsnd_cps,sndaintrp,
                       snd_blk_n,redistr_table,frs,num_patches);
                /*
                printf("me[%d][%d][%d] CPrecv from [%d][%d][%d]\n",
                  me[0], me[1],
                  redistr_table[me[0]][me[1]].wv_level,
                  from_it[0], from_it[1],
                  redistr_table[from_it[0]][from_it[1]].wv_level);
                */

                front = redistr_table[me[0]][me[1]].front;
                if(front == NULL)
                {
                    printf("ERROR: wv_perform_recv_intrp_buf_blks\n");
                    printf("loc front is null\n");
                    clean_up(ERROR);
                }
                for(j = 0; j < num_patches; j++)
                {
                    if(front == frs[j])
                    {
                        wave = wvs[j];
                        break;
                    }
                }
                unbundle_blk_cst(&cpcps, &i_cps,wave);
                blk_cst_to_wave(wave,front,&i_cps,me,from_it,aintrp,intrp_blk_n);
                free_these(3,i_cps.comp, i_cps.state,i_cps.state_storage);
            }
            free(lcprecv_cps);
        }
#if defined(__MPI__)
        lpprecv_cps = collect_recv_intrp_blks_on_level(on_level,
             pprcv_cps,frs,num_patches,redistr_table,max_n_patch,
             aintrp,intrp_blk_n,YES,&level_blks);
        if(level_blks != 0)
        {
            vector(&ipp_reqs, level_blks, sizeof(MPI_Request));
            vector(&ipp_stat, level_blks, sizeof(MPI_Status));
            vector(&irecv_indices, level_blks, sizeof(int));
            vector(&irecv_flags, level_blks, sizeof(int));

            for(i = 0; i < level_blks; i++)
            {
                assign(&ipp_reqs[i], &(lpprecv_cps[i].ipp_reqs), sizeof(MPI_Request));
                irecv_flags[i] = NO;
            }
            while(not_all_recved == YES)
            {
                MPI_Waitsome(level_blks, ipp_reqs, &ndone, irecv_indices, ipp_stat);
                for(i = 0; i < ndone; i++)
                {
                    ii = irecv_indices[i];
                    if(irecv_flags[ii] != YES)
                    {
                        irecv_flags[ii] = YES;
                        me[0] = lpprecv_cps[ii].me[0];
                        me[1] = lpprecv_cps[ii].me[1];
                        from_it[0] = lpprecv_cps[ii].from_it[0];
                        from_it[1] = lpprecv_cps[ii].from_it[1];
                        i_cps.num = lpprecv_cps[ii].num;
                        aloc_intrp_cps_storage(&i_cps,sizest);

                        front = redistr_table[me[0]][me[1]].front;
                        if(front == NULL)
                        {
                            printf("ERROR: wave_rcv_intrp_buf_blks_at_lev_from_prev\n");
                            printf("front is null\n");
                            clean_up(ERROR);
                        }
                        for(j = 0; j < num_patches; j++)
                        {
                            if(front == frs[j])
                            {
                                wave = wvs[j];
                                break;
                            }
                        }
                        unbundle_blk_cst(&lpprecv_cps[ii], &i_cps,wave);
                        blk_cst_to_wave(wave,front,&i_cps,me,from_it,aintrp,intrp_blk_n);
                        free_these(3,i_cps.comp, i_cps.state,i_cps.state_storage);
                        /*
                        printf("me[%d][%d][%d] PPrecv from [%d][%d][%d] data_size[%d] tag[%d] done\n",
                            me[0], me[1], redistr_table[me[0]][me[1]].wv_level,
                             from_it[0], from_it[1],
                            redistr_table[from_it[0]][from_it[1]].wv_level,
                            i_cps.num, lpprecv_cps[ii].ipp_tag);
                        */
                    }
                }
                not_all_recved = NO;
                for(i = 0; i < level_blks; i++)
                {
                    if(irecv_flags[i] == NO)
                    {
                        not_all_recved = YES;
                        break;
                    }
                }
            }
            free(lpprecv_cps);
            free_these(4,ipp_reqs,ipp_stat,irecv_indices,irecv_flags);
        }
#endif /* if defined(__MPI__) */

        DEBUG_LEAVE(wave_rcv_intrp_buf_blks_at_lev_from_prev)
}

LOCAL void perform_recv_slevel_buf_blks(
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        PP_cps       **pprcv_cps,
        PP_cps       **ppsnd_cps,
        Amr_intrp_set  *aintrp,
        int            intrp_blk_n,
        Amr_intrp_set  *sndaintrp,
        int            snd_blk_n)
{
        Front        *front;
        Wave         *wave;
        size_t       sizest = wvs[0]->sizest;
        PP_cps       *slpprecv_cps, *slcprecv_cps, cpcps;
        int          i, j, ii, slevel_blks;
        int          me[2], from_it[2], n_snd_wvs;
        int          **do_item;
        Intrp_cps    i_cps;
#if defined(__MPI__)
        MPI_Request *ipp_reqs;
        MPI_Status  *ipp_stat;
        int         *irecv_indices, *irecv_flags;
        int         ndone, not_all_recved = YES;
#endif /* if defined(__MPI__) */

        DEBUG_ENTER(perform_recv_slevel_buf_blks)

        slcprecv_cps = collect_recv_blks_on_level(NO,0,pprcv_cps,frs,num_patches,
           redistr_table,max_n_patch, NO, &slevel_blks,aintrp,intrp_blk_n);
        if(slevel_blks != 0)
        {
            for(i = 0; i < slevel_blks; i++)
            {
                from_it[0] = slcprecv_cps[i].from_it[0];
                from_it[1] = slcprecv_cps[i].from_it[1];
                me[0] = slcprecv_cps[i].me[0];
                me[1] = slcprecv_cps[i].me[1];
                i_cps.num = slcprecv_cps[i].num;
                aloc_intrp_cps_storage(&i_cps,sizest);

                cpcps = find_match_loc_snd_blk(&slcprecv_cps[i],ppsnd_cps,sndaintrp,
                       snd_blk_n,redistr_table,frs,num_patches);
                /*
                printf("me[%d][%d][%d] CPrecv from [%d][%d][%d]\n",
                  me[0], me[1],
                  redistr_table[me[0]][me[1]].wv_level,
                  from_it[0], from_it[1],
                  redistr_table[from_it[0]][from_it[1]].wv_level);
                */

                front = redistr_table[me[0]][me[1]].front;
                if(front == NULL)
                {
                    printf("ERROR: wv_perform_recv_intrp_buf_blks\n");
                    printf("loc front is null\n");
                    clean_up(ERROR);
                }
                for(j = 0; j < num_patches; j++)
                {
                    if(front == frs[j])
                    {
                        wave = wvs[j];
                        break;
                    }
                }
                unbundle_blk_cst(&cpcps, &i_cps,wave);
                blk_cst_to_wave(wave,front,&i_cps,me,from_it,aintrp,intrp_blk_n);
                free_these(3,i_cps.comp, i_cps.state,i_cps.state_storage);
            }
            free(slcprecv_cps);
        }
#if defined(__MPI__)
        slpprecv_cps = collect_recv_blks_on_level(NO,0,pprcv_cps,frs,num_patches,
           redistr_table,max_n_patch, YES, &slevel_blks,aintrp,intrp_blk_n);
        if(slevel_blks != 0)
        {
            vector(&ipp_reqs, slevel_blks, sizeof(MPI_Request));
            vector(&ipp_stat, slevel_blks, sizeof(MPI_Status));
            vector(&irecv_indices, slevel_blks, sizeof(int));
            vector(&irecv_flags, slevel_blks, sizeof(int));

            for(i = 0; i < slevel_blks; i++)
            {
                assign(&ipp_reqs[i], &(slpprecv_cps[i].ipp_reqs), sizeof(MPI_Request));
                irecv_flags[i] = NO;
            }
            while(not_all_recved == YES)
            {
                MPI_Waitsome(slevel_blks, ipp_reqs, &ndone, irecv_indices, ipp_stat);
                for(i = 0; i < ndone; i++)
                {
                    ii = irecv_indices[i];
                    if(irecv_flags[ii] != YES)
                    {
                        irecv_flags[ii] = YES;
                        me[0] = slpprecv_cps[ii].me[0];
                        me[1] = slpprecv_cps[ii].me[1];
                        from_it[0] = slpprecv_cps[ii].from_it[0];
                        from_it[1] = slpprecv_cps[ii].from_it[1];
                        i_cps.num = slpprecv_cps[ii].num;
                        aloc_intrp_cps_storage(&i_cps,sizest);
                        /*
                        printf("me[%d][%d][%d] PPrecv from [%d][%d][%d] data_size[%d] tag[%d]\n",
                          me[0], me[1], redistr_table[me[0]][me[1]].wv_level,
                          from_it[0], from_it[1],
                          redistr_table[from_it[0]][from_it[1]].wv_level,
                          i_cps.num, slpprecv_cps[ii].ipp_tag);
                        */
                        front = redistr_table[me[0]][me[1]].front;
                        if(front == NULL)
                        {
                            printf("ERROR: wv_perform_recv_intrp_buf_blks\n");
                            printf("front is null\n");
                            clean_up(ERROR);
                        }
                       for(j = 0; j < num_patches; j++)
                        {
                            if(front == frs[j])
                            {
                                wave = wvs[j];
                                break;
                            }
                        }
                        unbundle_blk_cst(&slpprecv_cps[ii], &i_cps,wave);
                        blk_cst_to_wave(wave,front,&i_cps,me,from_it,aintrp,intrp_blk_n);
                        free_these(3,i_cps.comp,i_cps.state,i_cps.state_storage);
                    }
                }
                not_all_recved = NO;
                for(i = 0; i < slevel_blks; i++)
                {
                    if(irecv_flags[i] == NO)
                    {
                        not_all_recved = YES;
                        break;
                    }
                }
            }
            free(slpprecv_cps);
            free_these(4,ipp_reqs,ipp_stat,irecv_indices,irecv_flags);

        }
#endif /* if defined(__MPI__) */

        DEBUG_LEAVE(perform_recv_slevel_buf_blks)
}


LOCAL PP_cps find_match_loc_snd_blk(
        PP_cps       *cprecv_cps,
        PP_cps       **ppsnd_cps,
        Amr_intrp_set  *sndaintrp,
        int            snd_blk_n,
        Wv_on_pc     **redistr_table,
        Front        **frs,
        int          num_patches)
{
        int          me[2], from_it[2];
        int          **do_item, n_snd_wvs;
        int          i, j;

        from_it[0] = cprecv_cps->from_it[0];
        from_it[1] = cprecv_cps->from_it[1];
        me[0] = cprecv_cps->me[0];
        me[1] = cprecv_cps->me[1];

        if(redistr_table[from_it[0]][from_it[1]].front == NULL)
        {
            printf("ERROR find_match_loc_snd_blk\n");
            printf("from NULL front\n");
            clean_up(ERROR);
        }
        for(i = 0; i < num_patches; i++)
        {
            if(frs[i] == redistr_table[from_it[0]][from_it[1]].front)
                break;
        }
        if(redistr_table[from_it[0]][from_it[1]].front != frs[i])
        {
            printf("ERROR find_match_loc_snd_blk\n");
            printf("NO match front\n");
            clean_up(ERROR);
        }


        do_item = count_wave_send_intrp(from_it,sndaintrp,snd_blk_n,&n_snd_wvs);
        for(j = 0; j < n_snd_wvs; j++)
        {
            if(do_item[j][0] == me[0] && do_item[j][1] == me[1])
                return ppsnd_cps[i][j];
        }

        printf("ERROR find_match_loc_snd_blk\n");
        printf("no match found\n");
        clean_up(ERROR);
}



LOCAL void wait_and_free_all_snd_blks(
        PP_cps       ***ppsnd_cps,
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch)
{
        int          numnodes, myid;
        int          i, j;
        int          item[2], level;
        int          n_snd_wvs, **do_item;
        int          send_dst, send_grid, send_dst_pc;
        Front        *front;

        DEBUG_ENTER(wait_and_free_all_snd_blks)

        numnodes = pp_numnodes();
        myid = pp_mynode();

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            loc_front_on_redistr_table(front,redistr_table,
                    max_n_patch,item);
            do_item = count_wave_send_intrp(item,aintrp,intrp_blk_n,&n_snd_wvs);
            if(n_snd_wvs != 0)
            {
                for(j = 0; j < n_snd_wvs; j++)
                {
                    send_dst = do_item[j][0];
                    send_grid = do_item[j][1];
                    send_dst_pc = redistr_table[send_dst][send_grid].pc_id;
                    if(myid != send_dst_pc)
                    {
#if defined(__MPI__)
                        MPI_Wait(&((*ppsnd_cps)[i][j].ipp_reqs), &((*ppsnd_cps)[i][j].ipp_stat));
#endif /* if defined(__MPI__) */
                    }
                    free((*ppsnd_cps)[i][j].ipp_buf);
                }
                free((*ppsnd_cps)[i]);
            }
        }
        free((*ppsnd_cps));
        *ppsnd_cps = NULL;

        DEBUG_LEAVE(wait_and_free_all_snd_blks)
}


LOCAL void wave_snd_intrp_buf_blks_at_lev_to_nxt(
        int          on_level,
        Front        **frs,
        Wave         **wvs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam,
        Amr_intrp_set  *aintrp,
        int          intrp_blk_n,
        PP_cps       ***ppsnd_cps)
{
        int          numnodes, myid;
        int          i, j, src, grid, nsend;
        int          item[2], level;
        Front        *front;
        Wave         *wave;
        int          n_snd_wvs, **do_item;
        int          s_blk, send_dst, send_grid, send_dst_pc;
        int          ll;
        Intrp_cps    snd_cps;
        size_t       send_len, sizest = wvs[0]->sizest;

        DEBUG_ENTER(wave_snd_intrp_buf_blks_at_lev_to_nxt)
      
        numnodes = pp_numnodes();
        myid = pp_mynode();

        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            wave = wvs[i];
            level = front->patch_level;
            if(level == on_level)
            {
                // interp for the next fine if there are any
                loc_front_on_redistr_table(front,
                      redistr_table,max_n_patch,item);
                do_item = count_wave_send_intrp(item,
                             aintrp,intrp_blk_n,&n_snd_wvs);
                for(j = 0; j < n_snd_wvs; j++)
                {
                    int send_n;
                    send_dst = do_item[j][0];
                    send_grid = do_item[j][1];
                    send_dst_pc = redistr_table[send_dst][send_grid].pc_id;

                    if((on_level+1) == redistr_table[send_dst][send_grid].wv_level)
                    {
                        // perform interp. for level+1 (next fine)
                        /*
                        printf("On node[%d], patch[%d][%d] has to intrp for[%d][%d] l[%d]\n",
                           myid, item[0], item[1], send_dst, send_grid,
                           redistr_table[send_dst][send_grid].wv_level);
                        */
                        send_n = count_wave_send_num_intrp(item,aintrp,
                                intrp_blk_n,do_item,j);
                        snd_cps.num = send_n;
                        aloc_intrp_cps_storage(&snd_cps,sizest);
                        intrp_snd_c_t_f_set(&snd_cps,wave,front,
                                  item,aintrp,intrp_blk_n,do_item,j,
                                   redistr_table,overparam->refinementRatio);
                        (*ppsnd_cps)[i][j].me[0] = item[0];
                        (*ppsnd_cps)[i][j].me[1] = item[1];
                        (*ppsnd_cps)[i][j].to_it[0] = send_dst;
                        (*ppsnd_cps)[i][j].to_it[1] = send_grid;
                        (*ppsnd_cps)[i][j].num = send_n;
                        send_len = (sizeof(COMPONENT)+sizest)*send_n;
                        scalar(&(*ppsnd_cps)[i][j].ipp_buf,send_len);

                        bundle_blk_cst(&(*ppsnd_cps)[i][j],&snd_cps,wave);
                        free_these(3,snd_cps.comp, snd_cps.state,snd_cps.state_storage);
                        if(myid != send_dst_pc)
                        {
#if defined(__MPI__)
                            (*ppsnd_cps)[i][j].ipp_tag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch);
                            pp_isend((*ppsnd_cps)[i][j].ipp_tag,(POINTER)(*ppsnd_cps)[i][j].ipp_buf,
                                send_len, send_dst_pc, &((*ppsnd_cps)[i][j].ipp_reqs));
                            /*
                            printf("[%d][%d] PPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst,send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, (*ppsnd_cps)[i][j].ipp_tag);
                            */
#endif /* if defined(__MPI__) */
                        }
                        else
                        {
                            /*
                            int tmptag;
                            tmptag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch);

                            printf("[%d][%d] CPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst,send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, tmptag);
                            */
                        }
                    }
                }
            }
        }

        DEBUG_LEAVE(wave_snd_intrp_buf_blks_at_lev_to_nxt)
}

LOCAL void intrp_snd_c_t_f_set(
        Intrp_cps   *cps,
        Wave        *wave,
        Front       *front,
        int         *it,
        Amr_intrp_set  *aintrp,
        int         intrp_blk_n,
        int         **do_item,
        int         do_n,
        Wv_on_pc**  redistr_table,
        int         refineratio)
{
        int         i, j, k;
        int         ic[MAXD], gic[MAXD], lic[MAXD], gic2[MAXD];
        int         gmin[MAXD], gmax[MAXD];
        int         p_onit[2];
        int         dim = wave->rect_grid->dim;
        int         level, itlevel, num = 0;
        float       crds[MAXD];

        for(i = 0; i < dim; i++)
        {
            gmin[i] = -wave->rect_grid->lbuf[i];
            gmax[i] = wave->rect_grid->gmax[i]
                      + wave->rect_grid->ubuf[i];
        }

        p_onit[0] = do_item[do_n][0];
        p_onit[1] = do_item[do_n][1];
        itlevel = redistr_table[it[0]][it[1]].wv_level;
        level = redistr_table[p_onit[0]][p_onit[1]].wv_level;
        if(level <= itlevel)
        {
            printf("ERROR intrp_snd_c_t_f_set\n");
            printf("NOt interp fine on the coarse\n");
            clean_up(ERROR);
        }

        /*
        printf("intrp_snd_c_t_f_set, item[%d][%d] interp for item[%d][%d]\n",
                   it[0], it[1], p_onit[0], p_onit[1]); 
        */

        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == it[0] &&
               aintrp[i].item[1] == it[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(p_onit[0] == aintrp[i].apts[j].on_item[0] &&
                       p_onit[1] == aintrp[i].apts[j].on_item[1])
                    {
                        ic[0] = aintrp[i].apts[j].ic[0];
                        ic[1] = aintrp[i].apts[j].ic[1];
                        lic_to_glb_indx(ic,redistr_table[p_onit[0]][p_onit[1]],
                             gic,dim);
                        gic_crds(wave->rect_grid,redistr_table,
                              it,p_onit,gic,refineratio,crds);

                        gic_to_level_indx(gic,level,itlevel,refineratio,gic2,dim);
                        gic_to_loc_indx(gic2,redistr_table[it[0]][it[1]],lic,dim);
                        for(k = 0; k < dim; k++)
                        {
                            if(lic[k] < gmin[k] || lic[k] >= gmax[k])
                            {
                                printf("ERROR intrp_snd_c_t_f_set\n");
                                printf("lic not in wave[%d][%d] item[%d][%d] ",
                                   wave->patch_number,wave->patch_level,
                                   it[0],it[1]);
                                printf("This wave intrp for item[%d][%d] at level[%d]\n",
                                     p_onit[0], p_onit[1], level);
                                printf("Level[%d] Ic[%d %d], gic[%d %d] lgic[%d %d], to level[%d] gic2[%d %d]",
                                        level, ic[0], ic[1], gic[0], gic[1],
                                        gic[0] - redistr_table[p_onit[0]][p_onit[1]].off_set[0],
                                        gic[1] - redistr_table[p_onit[0]][p_onit[1]].off_set[1],
                                        itlevel, gic2[0], gic2[1]);
                                printf("Local index [%d %d]\n", lic[0], lic[1]);
                                printf("Wave's base[%d %d] bound[%d %d]\n", 
                                     redistr_table[it[0]][it[1]].base[0],
                                     redistr_table[it[0]][it[1]].base[1],
                                     redistr_table[it[0]][it[1]].bound[0],
                                     redistr_table[it[0]][it[1]].bound[1]);
                                printf("intrped base[%d %d] bound[%d %d]\n", 
                                     redistr_table[p_onit[0]][p_onit[1]].base[0],
                                     redistr_table[p_onit[0]][p_onit[1]].base[1],
                                     redistr_table[p_onit[0]][p_onit[1]].bound[0],
                                     redistr_table[p_onit[0]][p_onit[1]].bound[1]);
                                clean_up(ERROR);
                            }
                        }

                        /* 
                        if(it[0] == 1 && it[1] == 0 &&
                           p_onit[0] == 1 && p_onit[1] == 1)
                        {
                            printf("ic[%d %d] of[%d][%d][%d] on[%d][%d][%d] is"
                                " loc[%d %d][%g %g] comp[%d] num %d\n",
                              ic[0], ic[1], p_onit[0],
                            p_onit[1], level, it[0], it[1],
                            itlevel, lic[0], lic[1], crds[0], crds[1],
                             Rect_comp(lic,wave), num);
                            // print_rectangular_grid(wave->rect_grid);
                        }
                        */

                        cps->comp[num] = Rect_comp(lic,wave);
                        if(is_excluded_comp(Rect_comp(lic,wave),front->interf))
                            (*front->_obstacle_state)(cps->state[num],front->sizest);
                        else
                        {
                            hyp_solution(crds,cps->comp[num],NULL,
                                 UNKNOWN_SIDE,front,wave,cps->state[num],NULL);
                        }
                        num++;
                        if(num > cps->num)
                        {
                            printf("ERROR intrp_snd_c_t_f_set\n");
                            printf("greater than the allocated num[%d]\n",
                                cps->num);
                            clean_up(ERROR);
                        }
                    }
                }
            }
        }
}


LOCAL void copy_same_l_snd_val(
        Intrp_cps   *cps,
        Wave        *wave,
        Front       *front,
        int         *it,
        Amr_intrp_set  *aintrp,
        int         intrp_blk_n,
        int         **do_item,
        int         do_n,
        Wv_on_pc**  redistr_table)
{
        int         i, j, k;
        int         ic[MAXD], gic[MAXD], lic[MAXD];
        int         gmin[MAXD], gmax[MAXD];
        int         p_onit[2];
        int         dim = wave->rect_grid->dim;
        int         num = 0;

        for(i = 0; i < dim; i++)
        {
            gmin[i] = -wave->rect_grid->lbuf[i];
            gmax[i] = wave->rect_grid->gmax[i]
                      + wave->rect_grid->ubuf[i];
        }

        p_onit[0] = do_item[do_n][0];
        p_onit[1] = do_item[do_n][1];

        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == it[0] &&
               aintrp[i].item[1] == it[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(p_onit[0] == aintrp[i].apts[j].on_item[0] &&
                       p_onit[1] == aintrp[i].apts[j].on_item[1])
                    {
                        ic[0] = aintrp[i].apts[j].ic[0];
                        ic[1] = aintrp[i].apts[j].ic[1];
                        lic_to_glb_indx(ic,redistr_table[p_onit[0]][p_onit[1]],
                             gic,dim);
                        gic_to_loc_indx(gic,redistr_table[it[0]][it[1]],
                             lic,dim);
                        for(k = 0; k < dim; k++)
                        {
                            if(lic[k] < gmin[k] || lic[k] >= gmax[k])
                            {
                                printf("ERROR assign_snd_sl_intrp_val\n");
                                printf("lic not in wave\n");
                                clean_up(ERROR);
                            }
                        }
                        if(wave->patch_level == 0)
                        {
                            /*
                            printf("ic[%d %d] of[%d][%d] on[%d][%d] is [%d %d] comp[%d] state:",
                              ic[0], ic[1], aintrp[i].apts[j].on_item[0],
                            aintrp[i].apts[j].on_item[1], it[0], it[1], 
                            lic[0], lic[1], Rect_comp(lic,wave));
                            (*front->print_state)(Rect_state(lic,wave));
                            */
                        }
                        assign(cps->state[num],Rect_state(lic,wave),wave->sizest);
                        cps->comp[num] = Rect_comp(lic,wave);
                        num++;

                        if(num > cps->num)
                        {
                            printf("ERROR assign_snd_sl_intrp_val\n");
                            printf("greater than the allocated num[%d]\n",cps->num);
                            clean_up(ERROR);
                        }
                    }
                }
            }
        }
}

LOCAL  int count_wave_send_num_intrp(
        int           *item,
        Amr_intrp_set *aintrp,
        int           intrp_blk_n,
        int           **do_item,
        int           do_n)
{
        int           i, j;
        int           num = 0;

        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == item[0] &&
               aintrp[i].item[1] == item[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(do_item[do_n][0] == aintrp[i].apts[j].on_item[0] &&
                       do_item[do_n][1] == aintrp[i].apts[j].on_item[1])
                    {
                        num++;
                    }
                }
            }
        }
        return num;
}


LOCAL int **count_wave_send_intrp(
        int           *item,
        Amr_intrp_set *aintrp,
        int           intrp_blk_n,
        int           *num_wvs)
{
        int          i, j, k, l;
        static int   nin = 10, **do_item;
        static int   first = YES;

        *num_wvs = 0;
        if(YES == first)
        {
            matrix(&do_item, nin, 2, sizeof(int));
            first = NO;
        }

        k = 0;
        for(i = 0; i < intrp_blk_n; i++)
        {
            if(aintrp[i].item[0] == item[0] &&
               aintrp[i].item[1] == item[1])
            {
                for(j = 0; j < aintrp[i].n_pts; j++)
                {
                    if(k == 0)
                    {
                        do_item[k][0] = aintrp[i].apts[j].on_item[0];
                        do_item[k][1] = aintrp[i].apts[j].on_item[1];
                        k++;
                    }
                    else
                    {
                        int in_array = NO;
                        for(l = 0; l < k; l++)
                        {
                            if(aintrp[i].apts[j].on_item[0] == do_item[l][0] &&
                               aintrp[i].apts[j].on_item[1] == do_item[l][1])
                            {
                                in_array = YES;
                                break;
                            }
                        }
                        if(in_array == NO)
                        {
                            do_item[k][0] = aintrp[i].apts[j].on_item[0];
                            do_item[k][1] = aintrp[i].apts[j].on_item[1];
                            k++;
                            if(k == nin)
                            {
                                int **tmp_in_item, mm;
                                nin += 10;
                                matrix(&tmp_in_item, nin, 2, sizeof(int));
                                for(mm = 0; mm < k; mm++)
                                {
                                    tmp_in_item[mm][0] = do_item[mm][0];
                                    tmp_in_item[mm][1] = do_item[mm][1];
                                }
                                free(do_item);
                                do_item = tmp_in_item;
                            }
                        }
                    }
                }
            }
        }
        *num_wvs = k;
        return do_item;
}

EXPORT void wave_intrp_buf_blks(
        Wave         **wvs,
        Front        **frs,
        int          num_patches,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Overparam    *overparam)
{
        Amr_intrp_set  *getaintrp;
        int          get_blk_n;
        Amr_intrp_set  *sndaintrp;
        int          snd_blk_n;
        PP_cps       **recv_cps;
        int          i, j, side, dim = frs[0]->rect_grid->dim;
        int          *iperm; /* permutation of {0,...,dim-1} */

        DEBUG_ENTER(wave_intrp_buf_blks)

        iperm = set_iperm(frs[0]->step,dim);
        for(i = 0; i < num_patches; i++)
        {
            for(j = 0; j < dim; j++)
            {
                for(side = 0; side < 2; side++)
                {
                    if (rect_boundary_type(frs[i]->interf,iperm[j],side)
                           == REFLECTION_BOUNDARY)
                    {
                        reflect_states_across_domain(iperm,side,j,frs[i],wvs[i]);
                    }
                }
            }
        }

        get_blk_n = set_recv_scatter_patch(frs,num_patches,overparam,
                          redistr_table,max_n_patch,&getaintrp); 

        snd_blk_n = set_send_scatter_patch(frs,num_patches,overparam,
                          redistr_table,max_n_patch,&sndaintrp);

        recv_cps = wave_post_recv_intrp_blks(frs,wvs,num_patches,
               getaintrp,get_blk_n,overparam,redistr_table,max_n_patch);        

        perform_wave_intrp_buf_blks(frs,wvs,num_patches,overparam,
           redistr_table,max_n_patch,recv_cps,getaintrp,
           get_blk_n,sndaintrp,snd_blk_n);

        DEBUG_LEAVE(wave_intrp_buf_blks)
}

LOCAL void perform_wave_intrp_buf_blks(
        Front        **frs,
        Wave         **wvs, 
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        PP_cps       **pprcv_cps, 
        Amr_intrp_set  *getaintrp,
        int            get_blk_n,
        Amr_intrp_set  *sndaintrp,
        int            snd_blk_n)
{
        int          numnodes, myid;
        int          i, j, src, grid, nsend;
        int          item[2], level, side;
        Front        *front;
        Wave         *wave;
        INTERFACE    *intfc;
        int          n_snd_wvs, **do_item;
        int          s_blk, send_dst, send_grid, send_dst_pc;
        int          ll, levels;
        Intrp_cps    snd_cps;
        size_t       send_len, sizest = wvs[0]->sizest;
        PP_cps       **ppsnd_cps;

        DEBUG_ENTER(perform_wave_intrp_buf_blks)

        numnodes = pp_numnodes();
        myid = pp_mynode();
        levels = overparam->numberOfRefinementLevels;

        vector(&ppsnd_cps, num_patches, sizeof(PP_cps*));
        for(i = 0; i < num_patches; i++)
        {
            front = frs[i];
            wave = wvs[i];
            level = front->patch_level;
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item);

            do_item = count_wave_send_intrp(item,sndaintrp,snd_blk_n,&n_snd_wvs);

            /*
            printf("On node[%d], patch[%d][%d] sends intrp to %d waves\n",
                    myid, item[0], item[1], n_snd_wvs);
            */
            if(n_snd_wvs != 0)
            {
                vector(&ppsnd_cps[i], n_snd_wvs, sizeof(PP_cps));
                for(j = 0; j < n_snd_wvs; j++)
                {
                    int send_n;

                    send_dst = do_item[j][0];
                    send_grid = do_item[j][1];
                    if(level == redistr_table[send_dst][send_grid].wv_level)
                    {
                        send_n = count_wave_send_num_intrp(item,sndaintrp,snd_blk_n,do_item,j);
                        send_dst_pc = redistr_table[send_dst][send_grid].pc_id;
                        snd_cps.num = send_n;
                        aloc_intrp_cps_storage(&snd_cps,sizest);
                        copy_same_l_snd_val(&snd_cps,wave,front,
                           item,sndaintrp,snd_blk_n,do_item,j,redistr_table);

                        ppsnd_cps[i][j].me[0] = item[0];
                        ppsnd_cps[i][j].me[1] = item[1];
                        ppsnd_cps[i][j].to_it[0] = send_dst;
                        ppsnd_cps[i][j].to_it[1] = send_grid;
                        ppsnd_cps[i][j].num = send_n;
                        send_len = (sizeof(COMPONENT)+sizest)*send_n;
                        scalar(&ppsnd_cps[i][j].ipp_buf,send_len);

                        bundle_blk_cst(&ppsnd_cps[i][j],&snd_cps,wave);
                        if(myid != send_dst_pc)
                        {
#if defined(__MPI__)
                            ppsnd_cps[i][j].ipp_tag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch) ;
                            pp_isend(ppsnd_cps[i][j].ipp_tag,(POINTER)ppsnd_cps[i][j].ipp_buf,
                              send_len, send_dst_pc, &(ppsnd_cps[i][j].ipp_reqs));
                            /*
                            printf("[%d][%d] PPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst, send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, ppsnd_cps[i][j].ipp_tag);
                            */
#endif /* if defined(__MPI__) */
                        }
                        else
                        {
                            /*
                            int tmptag;
                            tmptag = numnodes*max_n_patch*
                              trans_item_offset(redistr_table,send_dst,send_grid,max_n_patch) +
                              trans_item_offset(redistr_table,item[0],item[1],max_n_patch);
                            printf("[%d][%d] CPsend to item[%d][%d] level[%d] data_size[%d] slevel tag[%d]\n",
                               item[0],item[1],send_dst, send_grid,redistr_table[send_dst][send_grid].wv_level,
                               send_n, tmptag);
                            */
                        }
                        free_these(3,snd_cps.comp, snd_cps.state, snd_cps.state_storage);
                    }
                }
            }
        }

        perform_recv_slevel_buf_blks(frs,wvs,num_patches,redistr_table,
              max_n_patch,pprcv_cps,ppsnd_cps,getaintrp,get_blk_n,
              sndaintrp,snd_blk_n);

        for(ll = 0; ll < levels-1; ll++)
        {
            // Patch on level (ll) interp for the next fine
            // if there are any. Send the interpolated to level ll+1
            wave_snd_intrp_buf_blks_at_lev_to_nxt(ll,frs,wvs,num_patches,
               redistr_table,max_n_patch,overparam,sndaintrp,snd_blk_n,
               &ppsnd_cps);

            wave_rcv_intrp_buf_blks_at_lev_from_prev(ll+1,frs,wvs,num_patches,
               redistr_table,max_n_patch,overparam,getaintrp,get_blk_n,
                sndaintrp,snd_blk_n,ppsnd_cps,pprcv_cps);
        }

        wait_and_free_all_snd_blks(&ppsnd_cps,sndaintrp,snd_blk_n,
         frs,num_patches,redistr_table,max_n_patch);
       free_wv_recv_intrp_blks(pprcv_cps,getaintrp,get_blk_n,
         frs,num_patches,redistr_table,max_n_patch);


        for(i = 0; i < snd_blk_n; i++)
            free(sndaintrp[i].apts);
        if(snd_blk_n != 0)
            free(sndaintrp);
        for(i = 0; i < get_blk_n; i++)
            free(getaintrp[i].apts);
        if(get_blk_n != 0)
            free(getaintrp);

        DEBUG_LEAVE(perform_wave_intrp_buf_blks)
}


LOCAL int set_send_scatter_patch(
        Front        **frs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Amr_intrp_set  **sndaintrp)
{
        PP_GRID      *pp_grid = frs[0]->pp_grid;
        int          dim = frs[0]->rect_grid->dim;
        int          item[3], level;
        int          grid;
        Amr_intrp_set  *tmpintrp, *aintrp = NULL;
        int          num = 0, alloc = 0;
        Front        *front;

        alloc = 10;
        vector(sndaintrp, alloc, sizeof(Amr_intrp_set));

        for(grid = 0; grid < num_patches; grid++)
        {
            front = frs[grid];
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item);
            level = front->patch_level;
            aintrp = scatter_patch_blk_in_domain(item,level,dim,
                    redistr_table,max_n_patch,pp_grid,overparam);
            if(aintrp != NULL)
            {
                assign(&(*sndaintrp)[num],aintrp,sizeof(Amr_intrp_set));
                num++;
                if(num == alloc)
                {
                    alloc += 10;
                    vector(&tmpintrp, alloc, sizeof(Amr_intrp_set));
                    assign(tmpintrp, *sndaintrp, sizeof(Amr_intrp_set)*num);
                    free(*sndaintrp);
                    *sndaintrp = tmpintrp;
                }
                free(aintrp); 
            }
       }

       if(num == 0)
       {
           free(*sndaintrp);
           *sndaintrp = NULL;
       }
       return num;  
}

LOCAL Amr_intrp_set  *scatter_patch_blk_in_domain(
        int       *item,
        int       level,
        int       dim,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        PP_GRID   *pp_grid,
        Overparam    *overparam)
{
        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD];
        int       iL[MAXD], iU[MAXD];
        int       bL[MAXD], bU[MAXD], gbL[MAXD], gbU[MAXD], it[2];
        int       *me, him[MAXD];
        int       i, src, grid, side, numnodes;
        int       levels;
        Amr_intrp_set  *sndaintrp = NULL;
        Amr_intrp_pt *apts = NULL;
        int       k, npts = 0;

        numnodes = pp_numnodes();
        me = redistr_table[item[0]][item[1]].pc_ic;

        set_grid_valid_domain(redistr_table[item[0]][item[1]],dim,L,U,1);
        for(i = 0; i < dim; i++)
        {
            gL[i] = L[i] + redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i];
            gU[i] = U[i] + redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i];
        }

        for(i = max_n_patch-1; i >= 0; i--)
        {
            if(redistr_table[item[0]][i].wv_id == -1) continue;
            levels = redistr_table[item[0]][i].wv_level;
            break;
        }

        for(src = 0; src < numnodes; src++)
        {
            if(YES == pp_node_in_neighbor(src,pp_grid,him,me) || 
               (redistr_table[src][0].pc_ic[0] == me[0] &&
                redistr_table[src][0].pc_ic[1] == me[1]))
            {
                for(grid = 0; grid < max_n_patch; grid++)
                {
                    if(redistr_table[src][grid].wv_id == -1) continue;
                    if(redistr_table[src][grid].wv_level != level) continue;
                    it[0] = src;
                    it[1] = grid;
                    for(k = 0; k < 8; k++)
                    {
                        if(YES != get_grid_buf_blk(redistr_table[it[0]][it[1]],dim,k,bL,bU))
                        continue; 
                        for(i = 0; i < dim; i++)
                        {
                            gbL[i] = bL[i] + redistr_table[it[0]][it[1]].base[i] +
                                    redistr_table[it[0]][it[1]].off_set[i];
                            gbU[i] = bU[i] + redistr_table[it[0]][it[1]].base[i] +
                                    redistr_table[it[0]][it[1]].off_set[i];
                        }
                        if(YES == box_intersect(gL,gU,gbL,gbU,dim,iL,iU))
                        {
                            /*
                            printf("Item[%d][%d] Domain intersect it[%d][%d] on glb L[%d %d] U[%d %d]\n",
                               item[0], item[1], it[0], it[1], iL[0], iL[1], iU[0], iU[1]);
                            */
                            if(sndaintrp == NULL)
                            {
                                scalar(&sndaintrp,sizeof(Amr_intrp_set));
                                sndaintrp->item[0] = item[0];
                                sndaintrp->item[1] = item[1];
                            }
                            for(i = 0; i < dim; i++)
                            {
                                iL[i] -= (redistr_table[it[0]][it[1]].base[i] +
                                          redistr_table[it[0]][it[1]].off_set[i]);
                                iU[i] -= (redistr_table[it[0]][it[1]].base[i] +
                                          redistr_table[it[0]][it[1]].off_set[i]);
                            }
                            apts = add_box_to_intrp_set(iL,iU,apts,&npts,
                                         it,dim);
                        }
                    }
                }
            }
        }

        if(sndaintrp != NULL)
        {
            sndaintrp->apts = apts;
            sndaintrp->n_pts = npts;
        }

        if(level == levels)
           return sndaintrp;

        /* Check whether this level will intrp. points for the next fine level */

        for(grid = 0; grid < max_n_patch; grid++)
        {
            if(redistr_table[item[0]][grid].wv_id == -1) continue;
            if(redistr_table[item[0]][grid].wv_level != level+1) continue;
            it[0] = item[0];
            it[1] = grid;
            if(NO == patch2_is_patch1_child(item,it,redistr_table,
                max_n_patch,overparam->refinementRatio,dim))
                continue;

            scatter_nxt_fpatch_in_domain(&sndaintrp,item,it,level+1,
                 dim,redistr_table,max_n_patch,overparam,pp_grid);
        }

        return sndaintrp;
}

LOCAL int scatter_nxt_fpatch_in_domain(
        Amr_intrp_set  **aintrp,
        int       *item,
        int       *fnit,
        int       flevel,
        int       dim,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        Overparam *overparam, 
        PP_GRID   *pp_grid)
{
        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD];
        int       iL[MAXD], iU[MAXD];
        int       bL[MAXD], bU[MAXD], it[2];
        int       bL2[MAXD], bU2[MAXD];
        int       *me, him[MAXD], src_id;
        int       i, src, grid, numnodes;
        int       k, levels;
        Trans_box  *avgbox = NULL;
        int       allocbox, nbox = 0;
        Amr_intrp_pt *apts = NULL;
        int       npts = 0, allocpts = 0;
        int       all_covered = YES; 


        numnodes = pp_numnodes();
        me = redistr_table[item[0]][item[1]].pc_ic;

        for(src = 0; src < numnodes; src++)
        {
            if(YES == pp_node_in_neighbor(src,pp_grid,him,me) ||
               (redistr_table[src][0].pc_ic[0] == me[0] &&
                redistr_table[src][0].pc_ic[1] == me[1]))
            {
                for(grid = 0; grid < max_n_patch; grid++)
                {
                    if(redistr_table[src][grid].wv_id == -1) continue;
                    if(redistr_table[src][grid].wv_level != flevel) continue;
                    it[0] = src;
                    it[1] = grid;
                    set_grid_valid_domain(redistr_table[it[0]][it[1]],dim,L,U,1);
                    for(i = 0; i < dim; i++)
                    {
                        gL[i] = L[i] + redistr_table[it[0]][it[1]].base[i] +
                                redistr_table[it[0]][it[1]].off_set[i] -
                                (redistr_table[fnit[0]][fnit[1]].base[i] +
                                 redistr_table[fnit[0]][fnit[1]].off_set[i]);
                        gU[i] = U[i] + redistr_table[it[0]][it[1]].base[i] +
                                redistr_table[it[0]][it[1]].off_set[i] -
                                (redistr_table[fnit[0]][fnit[1]].base[i] +
                                 redistr_table[fnit[0]][fnit[1]].off_set[i]);
                    }
                    for(k = 0; k < 8; k++)
                    {
                        if(YES == get_grid_buf_blk(redistr_table[fnit[0]][fnit[1]],
                                dim,k,bL,bU))
                        {
                            if(YES == box_intersect(gL,gU,bL,bU,dim,iL,iU))
                                avgbox = add_to_box(iL,iU,dim,avgbox,&nbox,&allocbox);
                        }
                    }
                }
            }
        }

        if(avgbox != NULL)
        {
            for(k = 0; k < 8; k++)
            {
                if(YES == get_grid_buf_blk(redistr_table[fnit[0]][fnit[1]],
                            dim,k,bL,bU))
                {
                    if(YES != box_in_boxes(bL,bU,avgbox,nbox,dim))
                    {
                        all_covered = NO; 
                        break; 
                    }
                }
            }
        }
        else
        {
            all_covered = NO; 
        }      

        if(all_covered == YES)
        {
            if(avgbox != NULL)
                free(avgbox);
            return NO; 
        }

        set_grid_valid_domain(redistr_table[item[0]][item[1]],dim,L,U,0);
        for(i = 0; i < dim; i++)
        {
            gL[i] = overparam->refinementRatio*(
                    redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i] + L[i]);
            gU[i] = overparam->refinementRatio*(
                    redistr_table[item[0]][item[1]].base[i] +
                    redistr_table[item[0]][item[1]].off_set[i] + U[i]);
        }
        for(i = 0; i < dim; i++)
        {
            L[i] = gL[i] - (redistr_table[fnit[0]][fnit[1]].base[i] +
                     redistr_table[fnit[0]][fnit[1]].off_set[i]);
            U[i] = gU[i] - (redistr_table[fnit[0]][fnit[1]].base[i] +
                     redistr_table[fnit[0]][fnit[1]].off_set[i]);
        }
        for(k = 0; k < 8; k++)
        {
            if(YES == get_grid_buf_blk(redistr_table[fnit[0]][fnit[1]],
                            dim,k,bL,bU))
            {
                if(YES == box_intersect(bL,bU,L,U,dim,bL2,bU2))
                {
                    add_pts_to_intrp_set(&apts,&npts,&allocpts,bL2,bU2,avgbox,nbox,dim,fnit); 
                }
            }
        } 

        if(*aintrp == NULL)
        {
            scalar(aintrp, sizeof(Amr_intrp_set));
            (*aintrp)->item[0] = item[0];
            (*aintrp)->item[1] = item[1];
            (*aintrp)->apts = apts;
            (*aintrp)->n_pts = npts;
        }
        else
        {
            Amr_intrp_pt *tmpapts = NULL;  
            int       tmpnpts;  
            tmpnpts = (*aintrp)->n_pts + npts;
            vector(&tmpapts, tmpnpts, sizeof(Amr_intrp_pt)); 
            assign(tmpapts, (*aintrp)->apts, sizeof(Amr_intrp_pt)*(*aintrp)->n_pts);
            assign(&tmpapts[(*aintrp)->n_pts], apts, sizeof(Amr_intrp_pt)*npts);
            free_these(2,apts,(*aintrp)->apts);
            (*aintrp)->apts = tmpapts;
            (*aintrp)->n_pts = tmpnpts;
        }
        if(avgbox != NULL)
            free(avgbox);
        return YES;
}


LOCAL int set_recv_scatter_patch(
        Front        **frs,
        int          num_patches,
        Overparam    *overparam,
        Wv_on_pc     **redistr_table,
        int          max_n_patch,
        Amr_intrp_set  **getaintrp)
{
        int          item[3];
        int          i, j, k, grid;
        int          L[MAXD], U[MAXD]; 
        int          alloc = 0, num = 0;
        Amr_intrp_set  *tmpintrp, *aintrp = NULL;
        Front        *front;

        alloc = 10;
        vector(getaintrp, alloc, sizeof(Amr_intrp_set));

        for(grid = 0; grid < num_patches; grid++)
        {
            front = frs[grid];
            loc_front_on_redistr_table(front,redistr_table,max_n_patch,item);
            for(k = 0; k < 8; k++)
            {
                aintrp = bufblk_scattered_by_patches(k,front,item,redistr_table,
                             max_n_patch,overparam);
                if(aintrp != NULL)
                {
                    assign(&(*getaintrp)[num],aintrp,sizeof(Amr_intrp_set));
                    num++;
                    if(num == alloc)
                    {
                        alloc += 10;
                        vector(&tmpintrp, alloc, sizeof(Amr_intrp_set));
                        assign(tmpintrp, *getaintrp, sizeof(Amr_intrp_set)*num);
                        free(*getaintrp);
                        *getaintrp = tmpintrp;
                    }
                    free(aintrp);
                }
            }
        }

        if(num == 0)
        {
            free(*getaintrp);
            *getaintrp = NULL;
        }
        return num;
}

LOCAL Amr_intrp_set *bufblk_scattered_by_patches(
        int       pos, 
        Front     *front,
        int       *item,
        Wv_on_pc  **redistr_table,
        int       max_n_patch,
        Overparam    *overparam)
{
        int       dim = front->rect_grid->dim;
        int       bL[MAXD], bU[MAXD], it[2]; 
        int       bL2[MAXD], bU2[MAXD]; 
        int       L[MAXD], U[MAXD], gL[MAXD], gU[MAXD];
        int       iL[MAXD], iU[MAXD];
        int       *me, him[MAXD],level;
        // int       src_id; 
        int       i, src, grid, numnodes;
        Amr_intrp_set  *getaintrp = NULL;
        Amr_intrp_pt *apts = NULL, *apts2 = NULL;
        int       npts = 0, allocpts = 0;
        Trans_box  *avgbox = NULL;
        int       allocbox, nbox = 0;
        PP_GRID   *pp_grid = front->pp_grid; 

        numnodes = pp_numnodes();
        me = redistr_table[item[0]][item[1]].pc_ic;
        // src_id = blk2d_neighbor_id(him,me,pos,pp_grid);
        level = front->patch_level; 
 
        if(YES == get_grid_buf_blk(redistr_table[item[0]][item[1]],dim,pos,bL,bU))
        {
            for(src = 0; src < numnodes; src++)
            {
                /*
                if((redistr_table[src][0].pc_ic[0] == me[0] &&
                    redistr_table[src][0].pc_ic[1] == me[1]) ||
                   (redistr_table[src][0].pc_ic[0] == him[0] &&
                    redistr_table[src][0].pc_ic[1] == him[1]))
                */
                if((redistr_table[src][0].pc_ic[0] == me[0] &&
                    redistr_table[src][0].pc_ic[1] == me[1]) ||
                   YES == pp_node_in_neighbor(src,pp_grid,him,me))
                {
                    for(grid = 0; grid < max_n_patch; grid++)
                    {
                        if(redistr_table[src][grid].wv_id == -1) continue;
                        if(redistr_table[src][grid].wv_level != level) continue;
                        it[0] = src;
                        it[1] = grid;
                        set_grid_valid_domain(redistr_table[it[0]][it[1]],dim,L,U,1);
                        /*
                        printf("The intrp searching domain L[%d %d] U[%d %d]\n",
                               L[0],L[1],U[0],U[1]);
                        */ 
                        for(i = 0; i < dim; i++)
                        {
                            gL[i] = L[i] + redistr_table[it[0]][it[1]].base[i] +
                                      redistr_table[it[0]][it[1]].off_set[i] -
                                     (redistr_table[item[0]][item[1]].base[i] +
                                      redistr_table[item[0]][item[1]].off_set[i]);
                            gU[i] = U[i] + redistr_table[it[0]][it[1]].base[i] +
                                      redistr_table[it[0]][it[1]].off_set[i] -
                                     (redistr_table[item[0]][item[1]].base[i] +
                                      redistr_table[item[0]][item[1]].off_set[i]);
                        }
                        if(YES == box_intersect(bL,bU,gL,gU,dim,iL,iU))
                        {
                            if(getaintrp == NULL)
                            {
                                scalar(&getaintrp,sizeof(Amr_intrp_set));
                                getaintrp->item[0] = item[0];
                                getaintrp->item[1] = item[1];
                            }
                            apts = add_box_to_intrp_set(iL,iU,apts,&npts,
                                             it,dim);
                            avgbox = add_to_box(iL,iU,dim,avgbox,&nbox,&allocbox);
                        }
                    }
                }
            }
        }
        else
        {
            return NULL; 
        }


        if(getaintrp != NULL)
        {
            getaintrp->apts = apts;
            getaintrp->n_pts = npts;
        }

        if(level == 0)
        {
            if(avgbox != NULL)
                free(avgbox);
            return getaintrp;
        }

        /* Check whether this buf get it's state from the next coarse */

        if(avgbox != NULL)
        {
            if(YES == box_in_boxes(bL,bU,avgbox,nbox,dim))
            {
                free(avgbox);
                return getaintrp;
            }
        }

        for(grid = 0; grid < max_n_patch; grid++)
        {
            if(redistr_table[item[0]][grid].wv_id == -1) continue;
            if(redistr_table[item[0]][grid].wv_level != level-1) continue;
            it[0] = item[0];
            it[1] = grid;
            if(YES == patch2_is_patch1_child(it,item,redistr_table,
                max_n_patch,overparam->refinementRatio,dim))
            {
                set_grid_valid_domain(redistr_table[it[0]][it[1]],dim,L,U,0);
                for(i = 0; i < dim; i++)
                {
                    gL[i] = overparam->refinementRatio*(
                            redistr_table[it[0]][it[1]].base[i] +
                            redistr_table[it[0]][it[1]].off_set[i] + L[i]);
                    gU[i] = overparam->refinementRatio*(
                            redistr_table[it[0]][it[1]].base[i] +
                            redistr_table[it[0]][it[1]].off_set[i] + U[i]);
                }
                for(i = 0; i < dim; i++)
                {
                    L[i] = gL[i] - (redistr_table[item[0]][item[1]].base[i] +
                             redistr_table[item[0]][item[1]].off_set[i]);
                    U[i] = gU[i] - (redistr_table[item[0]][item[1]].base[i] +
                             redistr_table[item[0]][item[1]].off_set[i]);
                }
                if(YES == box_intersect(bL,bU,L,U,dim,bL2,bU2))
                {
                    add_pts_to_intrp_set(&apts2,&npts,&allocpts,bL2,bU2,avgbox,nbox,dim,it);
                }
            }
        }

        if(apts2 == NULL)
        {
            printf("ERROR bufblk_scattered_by_patches\n");
            printf("buffer is not covered by the same level fine or the next coarse\n");
            clean_up(ERROR);
        }

        if(getaintrp == NULL)
        {
            scalar(&getaintrp,sizeof(Amr_intrp_set));
            getaintrp->item[0] = item[0];
            getaintrp->item[1] = item[1];
            getaintrp->apts = apts2;
            getaintrp->n_pts = npts;
        }
        else
        {
            Amr_intrp_pt *tmpapts = NULL;
            int       tmpnpts;
            tmpnpts = getaintrp->n_pts + npts;
            vector(&tmpapts, tmpnpts, sizeof(Amr_intrp_pt));
            assign(tmpapts, getaintrp->apts, sizeof(Amr_intrp_pt)*getaintrp->n_pts);
            assign(&tmpapts[getaintrp->n_pts], apts2, sizeof(Amr_intrp_pt)*npts);
            free_these(2,apts2,getaintrp->apts);
            getaintrp->apts = tmpapts;
            getaintrp->n_pts = tmpnpts;
        }

        if(avgbox != NULL)
            free(avgbox);
        return getaintrp;
}

LOCAL void set_grid_valid_domain(
        Wv_on_pc   redistr_table,
        int        dim, 
        int        *L, 
        int        *U,
        int        fine_or_coarse) /* 1: fine */
{
        int        i;
        int        *lbuf = redistr_table.lbuf;
        int        *ubuf = redistr_table.ubuf;
        int        gmax[MAXD];

        for(i = 0; i < dim; i++)
            gmax[i] = redistr_table.bound[i] - redistr_table.base[i];        

        if(fine_or_coarse == 0)
        {
            /* Coarse grid for the next fine domain */
            for(i = 0; i < dim; i++)
            {
                L[i] = -lbuf[i];
                U[i] = gmax[i] + ubuf[i]; 
            }
            return; 
        }
        
        for(i = 0; i < dim; i++)
        {
            L[i] = 0; 
            U[i] = gmax[i]; 
        }

        for(i = 0; i < dim; i++) 
        {
            if(redistr_table.rect_bdry_type[i][0] == REFLECTION_BOUNDARY) 
                L[i] -= redistr_table.lbuf[i]; 
            if(redistr_table.rect_bdry_type[i][1] == REFLECTION_BOUNDARY) 
                U[i] += redistr_table.ubuf[i]; 
        }
}

/* 
      6  |  5  |  4
     ----------------
      7  |     |  3
     ----------------
      0  |  1  |  2
NOTE: If 1, 3, 5 , 7 are on the reflection boundary side,
      these blks are not considered as buffer blks.
*/

LOCAL int get_grid_buf_blk(
        Wv_on_pc   redistr_table,
        int        dim, 
        int        pos, 
        int        *L, 
        int        *U)
{
        int        i;
        
        if(dim == 2)
        {
            switch(pos)
            {
            case 0:
                if(buffered_boundary_type(redistr_table.rect_bdry_type[0][0]) &&
                   buffered_boundary_type(redistr_table.rect_bdry_type[1][0]))
                {
                    for(i = 0; i < dim; i++)
                    {
                        L[i] = -redistr_table.lbuf[i];  
                        U[i] = 0; 
                    } 
                    return YES; 
                }
            break;
            case 1:
                if(redistr_table.rect_bdry_type[1][0] == AMR_SUBDOMAIN_BOUNDARY ||
                   redistr_table.rect_bdry_type[1][0] == SUBDOMAIN_BOUNDARY)
                {
                    L[0] = 0; 
                    L[1] = -redistr_table.lbuf[1];
                    U[0] = redistr_table.bound[0] - redistr_table.base[0];
                    U[1] = 0; 
                    return YES; 
                }
            break; 
            case 2:
                if(buffered_boundary_type(redistr_table.rect_bdry_type[0][1]) &&
                   buffered_boundary_type(redistr_table.rect_bdry_type[1][0]))
                {
                    L[0] = redistr_table.bound[0] - redistr_table.base[0];
                    L[1] = -redistr_table.lbuf[1];
                    U[0] = redistr_table.bound[0] - redistr_table.base[0]
                            + redistr_table.ubuf[0]; 
                    U[1] = 0;  
                    return YES; 
                }
            break; 
            case 3:
                if(redistr_table.rect_bdry_type[0][1] == AMR_SUBDOMAIN_BOUNDARY ||
                   redistr_table.rect_bdry_type[0][1] == SUBDOMAIN_BOUNDARY) 
                {
                    L[0] = redistr_table.bound[0] - redistr_table.base[0];
                    L[1] = 0;
                    U[0] = redistr_table.bound[0] - redistr_table.base[0]
                           + redistr_table.ubuf[0]; 
                    U[1] = redistr_table.bound[1] - redistr_table.base[1]; 
                    return YES; 
                }
            break; 
            case 4:
                if(buffered_boundary_type(redistr_table.rect_bdry_type[0][1]) &&
                   buffered_boundary_type(redistr_table.rect_bdry_type[1][1]))
                {
                    for(i = 0; i < dim; i++)
                    {
                        L[i] = redistr_table.bound[i] - redistr_table.base[i];
                        U[i] = redistr_table.bound[i] - redistr_table.base[i]
                               + redistr_table.ubuf[i]; 
                    }
                    return YES; 
                }
            break; 
            case 5:
                if(redistr_table.rect_bdry_type[1][1] == AMR_SUBDOMAIN_BOUNDARY ||
                   redistr_table.rect_bdry_type[1][1] == SUBDOMAIN_BOUNDARY)
                {
                    L[0] = 0;
                    L[1] = redistr_table.bound[1] - redistr_table.base[1];
                    U[0] = redistr_table.bound[0] - redistr_table.base[0]; 
                    U[1] = redistr_table.bound[1] - redistr_table.base[1]
                           + redistr_table.ubuf[1]; 
                    return YES;  
                }
            break;
            case 6:
                if(buffered_boundary_type(redistr_table.rect_bdry_type[0][0]) &&
                   buffered_boundary_type(redistr_table.rect_bdry_type[1][1]))
                {
                    L[0] = -redistr_table.lbuf[0]; 
                    U[0] = 0;
                    L[1] = redistr_table.bound[1] - redistr_table.base[1]; 
                    U[1] = redistr_table.bound[1] - redistr_table.base[1]
                           + redistr_table.ubuf[1]; 
                    return YES; 
                }
            break; 
            case 7:
                if(redistr_table.rect_bdry_type[0][0] == AMR_SUBDOMAIN_BOUNDARY ||
                   redistr_table.rect_bdry_type[0][0] == SUBDOMAIN_BOUNDARY)
                {
                    L[0] = -redistr_table.lbuf[0];
                    U[0] = 0;
                    L[1] = 0;
                    U[1] = redistr_table.bound[1] - redistr_table.base[1]; 
                    return YES; 
                }
            break; 
            default:
                printf("ERROR get_grid_buf_blk Unknown position\n"); 
                clean_up(ERROR); 
            }
            return NO; 
        }
        else
        {
            printf("ERROR get_grid_buf_blk\n");
            clean_up(ERROR); 
        } 

        return NO; 
}

#endif /* #if defined(USE_OVERTURE) */

