#ifdef MHD
/*
*				minit.c:
*
*	Contains initialization routines for magnetic field
*
*/
#include <ginit/ginit.h>
#include <errno.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#include <intfc/array.h>
#include <mellip/mhd_soln.h>

EXPORT	void init_magnetic_field(
       	INIT_PHYSICS	*ip)
{				
        COIL            *coil;
	char	    	s[Gets_BUF_SIZE],s1[Gets_BUF_SIZE];;
	Front		*front = ip->root->front;
	int		dim = front->interf->dim;
	float           dflt_center[3];
	float           dflt_velocity[3];
	M_PARAMS        *pm_params;

	ip->root->ellip = m_parabolic_solution;
	ip->root->parab = mhd_modify_state;		
	m_set_el_map_hook((M_TO_ELLIP *)ip->root->el_map);
	
  	if (dim < 2)
	{
	    screen("ERROR in init_cyl_riem_prob(), dim < 2 not supported\n");
	    clean_up(ERROR);
	    return;
	}

	scalar(&m_params,sizeof(M_PARAMS));
	m_params.coil_vel[0] = 0.0;
	m_params.coil_vel[1] = 0.0;
	m_params.coil_vel[2] = 0.0;
		
	screen("\n\tEnter the source of margnetic field\n\n");
	screen("\tCoil (C)\n");
	screen("\tTransverse (T)\n");
	screen("\tEnter choice: ");
	(void) Gets(s);
	switch (s[0])
	{
	case 'C':
	case 'c':		
	    m_params.magnetic_field = m_rect_coil_B;
	    m_params.magnetic_field_deriv_1 = m_rect_coil_B_deriv_1;

	    scalar(&coil,sizeof(COIL));
	    coil->center[0] = 0.0;
	    coil->center[1] = 0.0;
	    coil->center[2] = 0.0;
		
	    screen("\n\t Magnetic coil parameters\n\n");
	    screen("Enter the magnetic coil shape, choices are:\n");
	    screen("Rectangular coil (R)\n");
	    screen("Cylindrical coil (C)\n");
	    screen("Enter choice: ");
	    (void) Gets(s);

	    screen("Enter %d coordinates of the center of the coil\n",dim);
	    screen("(Defaults are %g %g %g): ",coil->center[0],
		   coil->center[0],coil->center[2]);
	    read_vector(coil->center,coil->center,dim);

	    switch (s[0])
	    {
	    case 'R':
	    case 'r':
		screen("Enter the semi length of the coil in x direction");
		screen(": ");
		(void) Gets(s);
		(void) sscan_float(s,&coil->Lx);
			
		screen("Enter the semi length of the coil in y direction");
		screen(": ");
		(void) Gets(s);
		(void) sscan_float(s,&coil->Ly);

		screen("Enter the semi length of the coil in z direction");
		screen(": ");
		(void) Gets(s);
		(void) sscan_float(s,&coil->Lz);

		break;
	    case 'C':
	    case 'c':
		screen("Enter the semi length of the coil in z direction");
		screen(": ");
		(void) Gets(s);
		(void) sscan_float(s,&coil->Lz);

		screen("Enter the radius of the coil");
		screen(": ");
		(void) Gets(s);
		(void) sscan_float(s,&coil->R);

		break;
	    default:
		break;
	    }
	    screen("Enter the deviation angle of the coil axis");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&coil->alpha);

	    screen("Enter the current density in the coil");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&coil->I);
	    break;
	case 'T':
	case 't':
	    m_params.magnetic_field = m_transverse_B;
	    m_params.magnetic_field_deriv_1 = m_transverse_B_deriv_1;
	    screen("Enter the maximum value for B: ");
	    (void) Gets(s);
	    (void) sscan_float(s,&m_params.Bmax);
	    break;
	default:
	    break;
	}
	screen("Enter %d velocity of the source when it is moving\n",dim);
	screen("(Defaults are %g %g %g): ",m_params.coil_vel[0],
	       m_params.coil_vel[1],m_params.coil_vel[2]);
	read_vector(m_params.coil_vel,m_params.coil_vel,dim);

        screen("Enter the speed of light in consistent units");
        screen(": ");
        (void) Gets(s);
        (void) sscan_float(s,&m_params.c);

        screen("Enter the value of fluid conductivity");
        screen(": ");
        (void) Gets(s);
        (void) sscan_float(s,&m_params.conduct);

        screen("Enter the value of fluid magnetic permeability");
        screen(": ");
        (void) Gets(s);
        (void) sscan_float(s,&m_params.mu);

//        screen("Enter the value of rho_min");
//        screen(": ");
//        (void) Gets(s);
//        (void) sscan_float(s,&m_params.rho_min);

	pm_params = &m_params;
	pm_params->coil = coil;



} /* end of init_magnetic_field() */

/*
EXPORT	void init_cyl_riem_prob(
	INIT_DATA	*init,
	INIT_PHYSICS	*ip)
{
	char		s[Gets_BUF_SIZE];
	init_magnetic_field(ip);
	init_el_riem_prob(init,ip);
//	init_cyl_riem_prob_roman(init,ip);
	screen("\nType y to initialize the external energy deposition: ");
	(void) Gets(s);
	if (s[0] == 'y' or s[0] == 'Y')
	    init_energy_deposition();	
}*/	/*end init_cyl_riem_prob*/


#endif
