/*
*				ghypprotos.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if !defined(_GHYPPROTOS_H)
#define _GHYPPROTOS_H

#if defined(cray)
#define artvsc ARTVSC
#define lwvec1 LWVEC1
#define lwvec2 LWVEC2
#endif /* defined(cray) */

/* Flag for FV volume simulation of central scheme */
//#if !defined(_FV_CENTRAL_)
//#define  _FV_CENTRAL_
//#endif /* if !defined(_FV_CENTRAL_) */
/* END: Flag for FV volume simulation of central scheme */

	/* ghyp EXPORTED Function Declarations */
#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */
/*	gflw.F */
FORTRAN	void FORTRAN_NAME(artvsc)(float*,float*,float*,float*,float*,float*,
				  float*,float*,float*,float*,float*,float*,
				  float*,int*);
FORTRAN	void	FORTRAN_NAME(lwvec1)(float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,bool*,int*);
FORTRAN	void	FORTRAN_NAME(lwvec2)(float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     int*,float*,float*,bool*);
#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */

/*	ggodunov.c */
IMPORT	void	godunov(float,float,Locstate,const float*,int,
                        int*,int*,Stencil*);
IMPORT	void	godunovobl(float,float,Tan_stencil*,Locstate,Front*);

/*	glf.c */
IMPORT	void	LF(float,float,Locstate,const float*,int,int*,int*,Stencil*);
IMPORT	void	LFoblique(float,float,Tan_stencil*,Locstate,Front*);

/*	ghyperbolic.c */
IMPORT	TIME_DYNAMICS g_load_state_vectors(int,int*,Vec_Gas*,int,int,
				           Wave*,Wave*,int*,int);
IMPORT	bool	check_ans(const char*,float,float,Locstate,
			  COMPONENT,Stencil*,int);
IMPORT	bool	check_gas(const char*,Locstate*,Locstate,Tan_stencil*,
	                  int,Front*);
IMPORT	void	g_two_side_npt_tang_solver(float,float,Tan_stencil*,
                                           Locstate,Locstate,Front*);
IMPORT	void	point_FD(float,float,Locstate,const float*,
                         int,int*,int*,Stencil*);
IMPORT	void	set_rotation(float**,const float*,int);
// From local to global 
IMPORT  void    g_init_obstacle_states(Vec_Gas*,int,int); 

/*	ghypvec.c */
IMPORT	void	ghyp_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                         int*,int,int,float,float);
IMPORT	void	copy_states_to_new_time_level(int*,Wave*,Wave*,
					      int,int,int*,int);

/*	glw.c */
IMPORT	void	LW_alloc_phys_vecs(Wave*,int);
IMPORT	void	LW_free_phys_vecs(Wave*);
IMPORT	void    LW(float,float,Locstate,const float*,int,int*,int*,Stencil*);
IMPORT	void	LWoblique(float,float,Tan_stencil*,Locstate,Front*);
IMPORT	void	LW_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                       int*,int,int,float,float);

/*	gmuscl.c */
IMPORT	void	oned_MUSCL(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                           Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
			   float,float,int);
IMPORT	void	set_muscl_default_hooks(Muscl_Opts*,Hyp_method*,int);
IMPORT	void	set_muscl_default_opts(Muscl_Opts*,Hyp_method*,int);
/* from local to global */
IMPORT  float   *g_set_vmuscl_vec_gas_storage(float**,Vec_Gas*,Vec_Muscl*,int);

/*      curv_muscl.c */
IMPORT  void    curv_oned_MUSCL(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                           Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
                           float,float,int);
/*	gplm.c */
IMPORT	void	oned_PLM(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                         Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
			 float,float,int);
IMPORT	void	set_plm_default_opts(Muscl_Opts*,Hyp_method*,int);

/*	ghypprt.c */
IMPORT	void	g_print_internal_energy(const char*,float**,Vec_Muscl*,int,int);
IMPORT  void    g_print_state_vectors(int,int,const char**,
                                      float*,float*,float**,int);
IMPORT	void	g_printout_vec_data(const char*,float*,float*,float**,
				    int,int,int,const char*);

/*	grsolve.c */
IMPORT	void	g_exact_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                         float*,float*,Vec_Muscl*);
IMPORT	void	g_gamma_law_fit_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                                 float*,float*,Vec_Muscl*);
IMPORT	void	g_gamma_law_fit_rsolver(int,int,float**,Vec_Gas*,float**,
                                        Vec_Gas*,float**,Vec_Gas*,
				        MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	g_linear_us_up_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                                float*,float*,Vec_Muscl*);
IMPORT	void	g_linear_us_up_rsolver(int,int,float**,Vec_Gas*,float**,
                                       Vec_Gas*,float**,Vec_Gas*,
				       MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	g_muscl_exact_rsolver(int,int,float**,Vec_Gas*,float**,Vec_Gas*,
                                      float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);

/*	gcgrsolve.c */
IMPORT	void	g_cg_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,float*,float*,
				      Vec_Muscl*);
IMPORT	void	cg_rsolve(int,int,float**,Vec_Gas*,float**,Vec_Gas*,
                          float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	set_cg_params(CG_PARAMS*);

/*	ghypsub.c */
IMPORT	Muscl_Opts *muscl_options(void);
IMPORT	Vec_Gas	   *g_alloc_vgas(Vec_Gas*,int,int);
IMPORT	Vec_Muscl  *alloc_Vec_Muscl(Vec_Muscl*);
IMPORT	Vec_Muscl  *g_muscl_free_wk_space(Vec_Muscl*);
IMPORT	Vec_Muscl  *load_state_data(int,int*,Front*,Wave*,Stencil*,
                                    Tan_stencil*,Vec_Gas*,Vec_Src*,
				    int,int,int,float,float);
IMPORT	Vec_Src    *muscl_alloc_vsrc(Vec_Src*,int,Wave*);
IMPORT	void	g_MUSCLoblique(float,float,Tan_stencil*,Locstate,Front*);
IMPORT	void	g_assign_wave_state_vectors(int,int*,Wave*,Wave*,Vec_Gas*,
                                            int,int,int*,int);
IMPORT	void	g_muscl_alloc_phys_vecs(Wave*,int);
IMPORT	void	g_muscl_free_phys_vecs(Wave*);
IMPORT	void	clear_Vec_Gas_set_flags(Vec_Gas*);
IMPORT	void	compute_slope_limiting_coeffs(int,int,Vec_Muscl*);
IMPORT	void	copy_vec_state_params(Vec_Gas*,Vec_Gas*,int,int);
IMPORT	void	g_free_vgas(Vec_Gas*);
IMPORT	void	g_free_vsrc(Vec_Src*);
IMPORT	void	g_load_VGas_state_vectors(int,int,Vec_Gas*,int);
IMPORT	void	g_load_muscl_flux(int,int,float**,Vec_Gas*,
                                  MUSCL_FLUX*,Vec_Muscl*);
/*** replaced with  g_compute_Jacobi() 
IMPORT  void    gvol_compute_Jacobi(int,int*,int,int,Stencil*,struct _Vec_Muscl*,
                                Wave*,Front*,Vec_Gas*,int);
***/
/*  curvilinear */
IMPORT  void    g_compute_Jacobi(int,int*,int,int,Stencil*,Tan_stencil*,
                  struct _Vec_Muscl*,Wave*,Front*,Vec_Gas*,int);
IMPORT  void    g_unsplit_cons_src(int,int,int,int*,Tan_stencil*,struct _Vec_Muscl*);

/*	gmoc.c */
IMPORT	void	  g_implicit_characteristic_solve(int,int,Vec_Muscl*);
IMPORT	void	  g_riemann_characteristic_solve(int,int,Vec_Muscl*);
IMPORT	void	  g_first_order_direct_characteristic_solve(int,int,Vec_Muscl*);

/*      gvisc.c */
IMPORT	int	parab_driver(float,float*,Wave*,Front*);
IMPORT  void    parab_npt(float,Front*,Wave*,Wave*);

/* gunsplithypsub.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT  void    g_unsplit_muscl_alloc_phys_vecs(Wave*,int);
IMPORT  void    g_unsplit_muscl_free_phys_vecs(Wave*);
IMPORT  Vec_Muscl  *g_load_unsplit_muscl_state_data(Muscl_Opts*,int,int*,Front*,
                         Wave*,Stencil*,Tan_stencil*,Vec_Gas*,Vec_Gas**,Vec_Src*,int,int,
                         int,float,float);
IMPORT  Vec_Muscl  *g_init_unsplit_muscl_state_data(Muscl_Opts*,int,int*,Front*,
                         Wave*,Stencil*,Tan_stencil*,Vec_Gas*,Vec_Gas**,Vec_Src*,int,int,
                         int,float,float);
IMPORT  bool    g_unsplit_muscl_load_source_vectors(int,int*,Tan_stencil*,float**,
                                            Vec_Gas*,Vec_Src*,float*,int,int,
                                            RECT_GRID*);
IMPORT  void    g_compute_2dunsplit_eigens(int,int,int,int*,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_bct_linear_reconstructor(int,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_N_half_step(int,int,float,float*,int,int*,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_T_half_step(int,int,float,float*,int,int*,int,Vec_Muscl*);
IMPORT  void    g_unsplit_muscl_exact_rsolver(int,int,int,int*,float**,Vec_Gas*,
                      float**,Vec_Gas*,float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);
IMPORT  void    ghyp_unsplit_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                         int*,int,int,float,float*); 
IMPORT  void    unsplit_point_FD(float*,float,Locstate,const float*,
                    int,int*,int*,Stencil*);
IMPORT  void    g_compute_2dunsplit_art_visc_coefs(int,int,int,int*,int,Vec_Muscl*);
IMPORT  void    set_unsplit_muscl_debug_flag(int);
#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

/* ghypvol.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT  void    contrl_vol_FD(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  void    contrl_vol_FD_ver2(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  void    contrl_vol_update(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  int     update_top_face_state(size_t,CSG_Solid*,Locstate);
IMPORT  void    g_alloc_stintfc_st_pool(Wave*);
IMPORT  void    g_free_stintfc_st_pool(void);

/* gDG.c */
IMPORT int       WENO_mod(float*,float*,float*,int,float,float*);
IMPORT void      gFV_tri_vec(int*,float*,float,Wave*,Wave*,Front*,Front*,COMPONENT);
IMPORT void      g_init_FV_MHD_reconstruction(Wave*,Front*);
IMPORT float     time_step_on_tri(Front*,TRI*);
IMPORT void      show_state_on_tri(const char*,int,Front*);
IMPORT void      show_state_to_rect(const char*,int,Front*);
IMPORT void      con_u_at_pt(Locstate,float*,double*,double,double*);
IMPORT void      A_z_at_pt(Locstate,TRI*,double*,double*);
IMPORT void      g_set_HR_times(void);
IMPORT void      R_degree2_above_term_P3_pt(TRI*,Locstate,double**,float*,float*,float*);
IMPORT void      extrema_detec(float*,float nbuave[ ][4],int*);
IMPORT void      extrema_detec_MHD(float*,float nbuave[ ][8],int,int*);
IMPORT void      get_sten_neighbr(TRI  *nbtri[],TRI*,TRI  *nntri[],int*);
IMPORT void      all_neighboring_cells(TRI*,TRI  *nntri[],int*);

IMPORT void      update_buffer_x_peri(Front*,Mid_soln*,int,Limiting_store**);
IMPORT void      update_buffer_x_ref(Front*,Mid_soln*,int,Limiting_store**);
IMPORT void      update_buffer_x_per_y_ref(Front*,Mid_soln*,int);
IMPORT void      update_buffer(Front*,Mid_soln*,int,Limiting_store**);
IMPORT void      zero_moments(Locstate);
IMPORT void      update_coef(TRI*,Mid_soln*,int,Front*,size_t,int);
IMPORT void      u_x_average(TRI*,Locstate,float*);
IMPORT void      u_y_average(TRI*,Locstate,float*);
IMPORT void      comp_coef(float A[ ][2],float*,float*);
IMPORT void      comp_coef2(double***,double*,double*,int);
IMPORT float     minmod(float, float);
IMPORT void      R_degree2_term_average(TRI*,Locstate,float*);
IMPORT void      R_degree2_term_average_Liu(TRI*,Locstate,double**,float*);
IMPORT float     ff_g_sin(float*,int,float);
IMPORT float     obtain_time_step_on_tri(Front*);
///////// new change
IMPORT void      attach_buffer_states(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT void      db_Mach_attach_buffer_states(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT void      Mach_step_attach_buffer_states(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT void      shock_vort_attach_buffer_states(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT int       overshoot_state_Shu_V(TRI*,Mid_soln*,int);
IMPORT int       overshoot_state_Shu_V_ver2(TRI*,Mid_soln*,int);
IMPORT void      fix_unphysical_st(TRI*,Mid_soln*,int,Front*);
IMPORT void      positivity_preserving(TRI*,Mid_soln*,int,Front*);
IMPORT void      u_average_indx(TRI*,Locstate,int,float*);
IMPORT float     cond_num(float A[ ][2]);
IMPORT double    cond_num2(double ***A,int);
IMPORT int       WENO_mod_on_3rd(float*,float*,float*,int,float,float*);
IMPORT float     minmod2(float, float);
IMPORT void      R_degree3_term_averageP3(TRI*,Locstate,double**,int,double,double*);
IMPORT int       WENO_mod_on_2nd(float*,float*,float*,int,float,float*);
IMPORT void      R_degree2_above_term_averageP3(TRI*,Locstate,double**,float*);
IMPORT void      R_degree2_above_term_averageP3_pt(TRI*,Locstate,double**,float*);
IMPORT int       WENO_mod_1(float*,float*,float*,int,float*);
IMPORT int       WENO_mod_1_sqr_weight(float*,float*,float*,int,float*);
IMPORT int       unphysical_st_at_quadrature(TRI*,Locstate);
IMPORT void      update_db_Mach_buffer(Front*,Mid_soln*,int,Limiting_store**);
IMPORT void      limiting_3rd_degreeP3(TRI*,TRI *nbtri[],int,Mid_soln*,int,int);
IMPORT void      convert_con_char(Locstate,float**,Locstate);
IMPORT void      save_reconstruct_st(TRI*,Mid_soln*,int,float conu[4][MAX_N_COEF]);
IMPORT void      save_weno_st_to_midsoln(TRI*,Mid_soln*,int,float conu[4][MAX_N_COEF]);
IMPORT void      weno_combine_P3(TRI*,float u[3][4][MAX_N_COEF],float out[4][MAX_N_COEF]);
IMPORT void      limiting_2nd_degreeP3(TRI*,TRI *nbtri[],int,Mid_soln*,int,int);
IMPORT void      limiting_2nd_degreeP3_multi_pt(TRI*,TRI *nbtri[3],Mid_soln*,int,int);
IMPORT void      limiting_1st_degreeP3(TRI*,TRI *nbtri[],int,Mid_soln*,int,int);
IMPORT int       overshoot_state(TRI*,Mid_soln*,int);
IMPORT void      get_sten_neighbr_B_field(TRI  *nbtri[],TRI*,TRI  *nntri[],int*);
IMPORT void      tri_comput_P2_polynomials_from_avg_MHD(TRI*,TRI *nbtri[],int,Mid_soln*,Limiting_store**,int,double**);
IMPORT void      tri_comput_P2_polynomials_from_avg_MHD_6sten_one_side(TRI*,TRI *nbtri[],int,Mid_soln*,Limiting_store**,int,int,double**);
IMPORT void      tri_comput_P2_polynomials_from_avg_MHD_7sten_reverse(TRI*,TRI *nbtri[],int,Mid_soln*,Limiting_store**,int,int,double**);
IMPORT double    weno_weight_P2(TRI*,double*);
IMPORT int       count_num_tris_vertex(TRI*,POINT*,int*);
IMPORT void      tris_between_edge_neighbrs(TRI*,POINT*,int,TRI *tris[],int*);
IMPORT void      tris_between_edge_neighbrs_ver2(TRI*,POINT*,int,TRI *tris[],int*);
IMPORT int       dens_out_range(TRI*,Locstate,float,float);
IMPORT void      tri_B_P0_polynomial_reconstruction(TRI*,Mid_soln*,int,double*);
IMPORT float     mag_vort_sol(float*,float,float*);
IMPORT void      Bn_for_accurate_magnetic_vort(double*,double*,double,double*);
IMPORT void      impose_mag_acc_vert_BC(Front*,Mid_soln*,int,double);
IMPORT void      impose_decay_alfven_BC(Front*,Mid_soln*,int,double);
IMPORT void      Mag_at_tri_edge_quadrature_for_P1(POLYGON*,Front*,Mid_soln*,int,double qt_crds[][4][3],double B[][4][2]);
IMPORT void      quadrature_Mag_at_tri_for_P1(POLYGON*,Front*,Mid_soln*,int,double qt_crds[][6][3],double B[][6][2]);
IMPORT void      quadrature_Mag_at_tri_for_P1_ver2(POLYGON*,Front*,Mid_soln*,int,double qt_crds[][6][3],double B[][6][2]);
IMPORT void      quadrature_Mag_at_tri_for_P1_ver3_5pts(POLYGON*,Front*,Mid_soln*,int,double qt_crds[][6][3],double B[][6][2]);
IMPORT void      accurate_mag_vort_L1(Front*);
IMPORT void      B_tri_mesh_2nd_reconstruction(Front*,Mid_soln*,int,Limiting_store**);
IMPORT void      update_edge_B_buffer(Front*,Mid_soln*,int);
IMPORT void      update_center_and_edge_phys_buffer(Front*,Front*,Mid_soln*,int);
IMPORT void      impose_mag_acc_vert_tri_edge_B_buffer(Front*,Mid_soln*,int,double);
IMPORT void      impose_decay_alfven_tri_edge_B_buffer(Front*,Mid_soln*,int,double);
IMPORT void      impose_blast_MHD_tri_edge_B_buffer(Front*,Mid_soln*,int,double);
IMPORT void      impose_blast_MHD_tri_cell_phys_buffer(Front*,Mid_soln*,int,double);
IMPORT void      Collect_by_press_at_tri_quadrature_on_dual_cell_Gauss_N2(Front*,POLYGON*,
                   Mid_soln*,Dual_cell_Mid_soln*,int,double neg_qB[][5][2],double  neg_qt_crds[][5][3],int*,int*,
                   double qB[][5][2],double  qt_crds[][5][3],int*,int*);
IMPORT void      Print_by_press_at_tri_quadrature_on_dual_cell_Gauss_N2(Front*,POLYGON*,Mid_soln*,Dual_cell_Mid_soln*,int);
IMPORT void      tmp_set_receive_domain(float*,float*,int,int,RECT_GRID*,float);
IMPORT void      tmp_set_send_domain(float*,float*,int,int,RECT_GRID*,float);
IMPORT int       count_num_of_tris_inside(float*,float*,Front*,TRI***);
IMPORT Buf_soln  *find_match_tri(float*,Buf_soln*,int);
IMPORT Buf_soln *find_match_tri_in_periodicBC( RECT_GRID*, float*,Buf_soln*,int);
IMPORT int       Add_dual_to_dual_cell_pair_list(DUAL_CELL_PAIR*,int,POLYGON*,TRI*,TRI*);
IMPORT void      B_dual_mesh_edge_b_reconstruction_using_tri_B(Front*,Mid_soln*,Dual_cell_Mid_soln*,int);

/* gDG2.c */
IMPORT void      NEW_extrema_detec(float*,float nbuave[][8],int,int*);
IMPORT void      compute_Roemean_MHD(Locstate,Locstate,float*,float*,float*);
IMPORT void      init_tri_comput_P1_polynomials_from_avg_MHD(TRI*,TRI *tris[],int,Mid_soln*,int,double**);
IMPORT void      Positivity_preserve(TRI*,TRI *nbtri[], Mid_soln*,Limiting_store**,int,Front*);
IMPORT float     POLY_thermal_pressure_MHD(Locstate);
IMPORT float     POLY_magnetosonic_speed_MHD(Locstate);
IMPORT void      WENO_FV_P2(TRI*,TRI *nbtri[3],Mid_soln*,Limiting_store**,int,Front*);
IMPORT void      WENO_FV_P1(TRI*,TRI *nbtri[3],Mid_soln*,Limiting_store**,int,Front*);
IMPORT void      limiting_P1_MHD(TRI*,TRI *sten_tri[],int,Mid_soln*,int,Front*);
IMPORT void      FV_P0(TRI*,TRI *nbtri[3],Mid_soln*,Limiting_store**,int,Front*);
IMPORT void      R_degree2_above_term_pt(TRI*,Locstate,double**,float*,float*,float*);
IMPORT void      set_HR_sten(TRI *nbtri[3],TRI*,TRI *nntri[30],int*);
IMPORT void      LARGE_STEN_local_limiting_soln_with_buffer_tris_multiple_times(Front*,Mid_soln*,int,int,
			Limiting_store**);
IMPORT void      LARGE_STEN_limiting_soln_with_buffer_tris(Front*,Mid_soln*,int,int,int,Limiting_store**);
IMPORT int       area_WENO_mod_on_3rd(float*,float*,float*,int,float,float,float*);
IMPORT int       area_WENO_mod_on_2nd(float*,float*,float*,int,float,float,float*);
IMPORT int       area_WENO_mod_1(float*,float*,float*,int,float,float*);
IMPORT void      map_poly_SV_to_CV_p2(TRI*);
IMPORT void      map_poly_SV_to_CV_ver2_p2(TRI*,Limiting_store*);
IMPORT void      map_poly_SV_to_CV_p3(TRI*);
IMPORT void      map_poly_SV_to_CV_ver2_p3(TRI*,Limiting_store*);
IMPORT void      con_u_at_CV_pt(TRI*,int,float*,float*,float*);
IMPORT void      con_u_at_CV_pt_from_store(TRI*,int,float*,float*,Limiting_store*,float*);
IMPORT int       CV_side_on_SV_side(int,int);
IMPORT int       get_tri_CV_stencil(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT void      Subcell_limiting_soln_with_buffer_tris_multiple_times(Front*,Mid_soln*,Limiting_store**,int,int);
IMPORT void      Subcell_limiting_soln_with_separating_orders(Front*,Mid_soln*,Limiting_store**,int,int);
IMPORT void      Subcell_limiting_soln_accuracy_test(Front*,Mid_soln*,Limiting_store**,int,int,int,int);
IMPORT void      WENO_FV_limiting_soln(Front*,Mid_soln*,Limiting_store**,int,int,int,int);

IMPORT int       get_tri_near_neighbr_CV_stencil_ver2(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT int       get_tri_near_neighbr_CV_stencil(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT int       get_tri_near_neighbr_overlap_CV_stencil(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT int       get_tri_liu_neighbr_overlap_CV_stencil(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT int       get_tri_neighbr_CV_stencil_from_set_HR_sten(TRI*,TRI *nbtri[],int,int*,int*,TRI**,int*);

IMPORT void      attach_Burgers_buffer_states_ver2(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT void      attach_g_sine_buffer_states_ver2(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT void      twod_riemann_attach_buffer_states(Front*,Mid_soln*,int,TRI*,Limiting_store**);
IMPORT int       get_tri_CV_stencil_unstable_SV_P2_partition(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT int       get_tri_CV_stencil_unstable_SV_P2_partition_no_regrouping(TRI*,TRI *nbtri[3],int,int*,int*,TRI**,int*);
IMPORT void      Subcell_limiting_soln_with_buffer_tris_multiple_times_rearrange_order(Front*,Mid_soln*,Limiting_store**,int,int,int,int);
IMPORT void      Subcell_limiting_soln_with_buffer_tris_multiple_times_local_HR(Front*,Mid_soln*,Limiting_store**,int,int,int,int);
IMPORT void      Subcell_limiting_soln_with_buffer_tris_multiple_times_local_HR_MHD(Front*,Mid_soln*,Limiting_store**,int,int,int,int);
IMPORT void      R_degree3_term_pt_P3(Locstate,int,double*,double*,float*);

IMPORT void      limiting_2nd_degree(TRI*,TRI *nbtri[],int,Mid_soln*,int);
IMPORT void      limiting_1st_degree(TRI*,TRI *nbtri[],int,Mid_soln*,int);
IMPORT double    biased_min_mod(double*,int,double);
IMPORT void      Construct_Mag_field_on_both_grids(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int,double,int);
IMPORT void      Construct_Mag_field_on_dual_cell_P1(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int);
IMPORT void      Construct_Mag_field_on_dual_cell_P2(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int);
IMPORT void      Construct_Mag_field_on_dual_cell_P1_no_div_free_constraint(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int);
IMPORT void      Construct_Mag_field_on_dual_cell_P1_DG(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int);
IMPORT DUAL_CELL_PAIR     *Positivity_press_dens_at_tri_quadrature(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int,int*);
IMPORT void      Modify_tri_states_for_trouble_dual_cell(Front*,Mid_soln*,Dual_cell_Mid_soln*,int);
IMPORT void      Modify_B_of_unphysical_state_at_tri_quadrature(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,int,DUAL_CELL_PAIR*,int); 
IMPORT void      Construct_Mag_field_on_tri_mesh_P1_DG(Front*,Front*,Mid_soln*,Dual_cell_Mid_soln*,int,double);
IMPORT void      Init_Construct_Mag_field_on_dual_cell(Wave*,Front*);
IMPORT void      accuracy_Mag_field_on_dual_cell_L1(Front*);
IMPORT void      accuracy_Mag_field_on_dual_cell_L1_DG(Front*);
IMPORT double    net_Bn_flux_on_polygon_edges(POLYGON*,double Bn[][N_COEF_EDGE]);
IMPORT void      check_dual_cell_face_B_match_edge(POLYGON*,Dual_cell_Mid_soln*,int);
IMPORT void      Bn_at_dual_cell_edges(POLYGON*,Mid_soln*,Dual_cell_Mid_soln*,int,double Bn[][N_COEF_EDGE]);
IMPORT void      Build_Mag_field_on_individual_dual_cell_P1_DG(POLYGON*,Front*,Mid_soln*,Dual_cell_Mid_soln*,int);
IMPORT void      Build_Mag_field_on_individual_dual_cell_P1_DG_ver2(POLYGON*,Front*,Mid_soln*,Dual_cell_Mid_soln*,int);
IMPORT void      Reduce_interior_Bn_variation_dual_cell_P1_DG(POLYGON*,Front*,Mid_soln*,Dual_cell_Mid_soln*,int);
IMPORT void      Dual_cell_edge_B_reconstruction_P1(Front*,Mid_soln*,Dual_cell_Mid_soln*,int,double);
IMPORT void      single_Dual_cell_edge_B_reconstruction_P1(POLYGON*,Mid_soln*,Dual_cell_Mid_soln*,int,int);
IMPORT void      parallel_update_dual_cell_B_buffer(Front*,Dual_cell_Mid_soln*,int);
IMPORT void      parallel_update_tri_edge_B_buffer(Front*,Mid_soln*,int);
IMPORT int       count_num_of_polygs_inside(float*,float*,Front*,POLYGON***);
IMPORT Dual_cell_Buf_soln *find_match_polyg(float*,Dual_cell_Buf_soln*,int);
IMPORT Dual_cell_Buf_soln *find_match_polyg_in_periodicBC(RECT_GRID*,float*,
                                        Dual_cell_Buf_soln*,int);
IMPORT Dual_cell_Buf_soln *find_match_polyg_in_periodicBC_ver2(RECT_GRID*,POLYGON*,
                                        Dual_cell_Buf_soln*,int,int*);
IMPORT Dual_cell_Buf_soln *find_match_polyg_ver2(POLYGON*,Dual_cell_Buf_soln*,int,int*);
IMPORT void      match_Bn_at_comm_dual_cell_edges(POLYGON*,POLYGON*,Dual_cell_Mid_soln*,int);
IMPORT void      match_Bn_at_comm_tri_edges(TRI*,TRI*,Mid_soln*,int);
IMPORT void      check_b_match_on_dual_edges(Front*,Dual_cell_Mid_soln*,int);
IMPORT void      check_b_match_on_tri_edges(Front*,Mid_soln*,int);

#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

#endif /* !defined(_GHYPPROTOS_H) */
