/*
*
*				spoly.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Template file for the implementation of new equation of state models
*
*/

#if !defined(_SPOLY_H)
#define _SPOLY_H

#include <geos/poly.h>

	/* Structures for accessing equation of state information */

struct _SPOLY_EOS {
	POLY_EOS Poly;
	float	 pinf;
	float	 einf;
	float    rhoinf;
	float	 et;
};
typedef struct _SPOLY_EOS SPOLY_EOS;

#define	SPOLY_Eos(state)	((SPOLY_EOS *)Params(state)->eos)

	/* Macros */

#define Pinf(state)		(SPOLY_Eos(state)->pinf)
#define Einf(state)		(SPOLY_Eos(state)->einf)
#define Et(state)		(SPOLY_Eos(state)->et)
#define	stiff_pressure(state) 	(pressure(state) + Pinf(state))

#endif /* !defined(_SPOLY_H) */
