/*
*
*				mpoly.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Template file for the implementation of new equation of state models
*
*/

#if defined(MULTI_COMPONENT)
#if !defined(_MPOLY_H)
#define _MPOLY_H

#include <geos/geosdecs.h>

	/* Structures for accessing equation of state information */

struct _MPOLY_EOS {
	EOS	eos;

	/* Add private EOS parameters below */

	float _gamma[MAX_NUM_GAS_COMPS];/* Molecular weights of components */
	float _M[MAX_NUM_GAS_COMPS];	/* Molecular weights of components */
	float R;			/* Ideal gas constant PV = R T */
};
typedef struct _MPOLY_EOS MPOLY_EOS;

#define	MPOLY_Eos(state)	((MPOLY_EOS *)Params(state)->eos)

	/* Macros */
#define	gamma(state)	(MPOLY_Eos(state))->_gamma
#define	M(state)	(MPOLY_Eos(state))->_M

#endif /* !defined(_MPOLY_H) */
#endif /* defined(MULTI_COMPONENT) */
