/*
*				geosdecs.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	This file contains definitions and structures for equation of 
*	state calculations.
*
*	THIS FILE MAY ONLY BE VALIDLY INCLUDED IN GEOS FILES.  INCLUSION
*	OF THIS FILE IN FILES IN OTHER DIRECTORIES WILL DESTROY THE EQUATION 
*	OF STATE MODULARITY OF THE CODE.
*/

#if !defined(_GEOSDECS_H)
#define _GEOSDECS_H

#include <gdecs/gdecs.h>

		/* possible equations of state */

enum {
	POLYTROPIC	      = FIRST_PHYSICAL_EOS_TYPE +  1,
	POLYTROPIC_ZND,
	STIFFENED_POLYTROPIC,
	BKW,
	LJD,
	HOM_GAS,
	HOM_SOLID,
	SESAME,
	MULTI_COMP_POLYTROPIC,
	JWL,
	MIE_GRUNEISEN,
	ISENTROPIC_TWO_PHASE,
	GENTEST
};

#if defined(LOG10)
#define plog(x) log10(x)
#define pexp(x) pow(10.0,x)
#else /* defined(LOG10) */
#define plog(x) log(x)
#define pexp(x) exp(x)
#endif  /* defined(LOG10) */

	/* Geos limited function prototypes */

/* geosutils.c */
IMPORT	void	limit_pressure(float*,float*,int);


#endif /* !defined(_GEOSDECS_H) */
