/*
*				fprotos.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/
#if !defined(_FPROTOS_H)
#define _FPROTOS_H

#include <front/fdecs.h>

		/* Front EXPORTED Function Prototypes*/

	/* fadv.c*/
IMPORT	void	set_advance_front(INIT_DATA*,Front*);

#if defined(TWOD)
	/* fbdry1.c*/
IMPORT	int	f_boundary_untangle(Front*,CROSS**,RPROBLEM*,NODE*,int);
IMPORT	int	is_bdry_interior_cross(Front*,CROSS*,ORIENTATION*,
				       ANGLE_DIRECTION*,
				       COMPONENT*,COMPONENT*);
IMPORT	int	is_c_in_another_bdry_cr(CROSS*,CURVE*);
IMPORT	int	next_boundary(CURVE*,ORIENTATION,CURVE**,ORIENTATION*);
IMPORT	int	split_curves_at_bdry_cross(CROSS*,Front*,ORIENTATION,
					   ANGLE_DIRECTION,CURVE**,
					   CURVE**,CURVE**,COMPONENT*,
					   COMPONENT*,int,RPROBLEM*);
IMPORT	void	classify_bdry_crosses(CROSS*,int*);
IMPORT	void	f_impose_bc(POINT*,BOND*,CURVE*,float*,Front*,bool,bool);
IMPORT	void	map_phys_cur_states_to_bdry_cur(CURVE*,ORIENTATION,SIDE,
						CURVE*,ORIENTATION,SIDE,
						int,int,INTERFACE*,Front*);
IMPORT	int	modify_exterior_curve(CURVE*,CURVE*,CURVE**,ORIENTATION,
				      ANGLE_DIRECTION,NODE*,
				      RPROBLEM*,CROSS*,int,Front*);

	/* fbdry2.c*/
IMPORT	SIDE	physical_side_of_bdry_curve(CURVE*);
IMPORT	int	is_curve_in_cross_list(CROSS*,CURVE*);

	/* fbdry3.c*/
IMPORT	bool	correct_for_exterior_curves(Front*);
IMPORT	int	curve_exits_parallel_to_bdry(Front*,POINTER,RPROBLEM*);
IMPORT	void	replace_cphys_by_cbdry(CURVE*,CURVE*,Front*);

	/* fbdry4.c*/
IMPORT	bool	all_pts_of_c_are_exterior_like(CURVE*,INTERFACE*);
IMPORT	bool	all_pts_on_c_are_ext_to_rect(CURVE*,RECT_GRID*);
IMPORT	bool	f_delete_phys_remn_on_bdry(Front*);
IMPORT	bool	c_parallel_to_bdry_like_curves(CURVE*,float,float);
IMPORT	bool	shortest_connecting_bdry_like_path(CURVE*,ORIENTATION,
						   CURVE**,ORIENTATION*,
						   bool*,bool*,float*,
						   bool*,bool*,float*);
IMPORT	void	f_delete_exterior_curves(Front*,INTERFACE*);
IMPORT	void	shift_c_states_to_bdry_curves(CURVE*,CURVE*,Front*);
#endif /* defined(TWOD) */

	/* fcorrspnd.c*/
IMPORT	HYPER_SURF	*find_correspond_hyper_surface(HYPER_SURF*,
				       HYPER_SURF_BDRY**,HYPER_SURF_BDRY**,
				       Front*,INTERFACE*);
IMPORT	bool	rst_cor_after_delete_hyper_surf(HYPER_SURF*);
IMPORT	bool	rst_cor_after_make_hyper_surf(HYPER_SURF*);
IMPORT	bool	set_correspondence_between_interfaces(INTERFACE*,INTERFACE*);
IMPORT	void	print_correspond_hyper_surf_list(INTERFACE*);
IMPORT	void	remove_corresponds_to_deleted_interface(INTERFACE*);
IMPORT	void	rst_cor_after_delete_interface(INTERFACE*);
IMPORT	void	set_add_to_correspond_list(bool);
IMPORT	void	set_correspond_hyper_surf_bdrys_to_NULL(INTERFACE*);
IMPORT	void	set_correspond_hyper_surfaces_to_NULL(INTERFACE*);
IMPORT	void	zero_corr_of_hyper_surf(HYPER_SURF*);
#if defined(TWOD) || defined(THREED)
IMPORT	int	rst_cor_after_join_hypersurfaces(HYPER_SURF*,HYPER_SURF*,
						 HYPER_SURF*);
#endif /* defined(TWOD) || defined(THREED) */
#if defined(TWOD)
IMPORT	CURVE	*find_correspond_curve(CURVE*,NODE*,NODE*,Front*,INTERFACE*);
IMPORT	NODE	*node_corresponding_to(NODE*,Front*);
IMPORT	bool	find_correspond_of_oriented_curve(O_CURVE*,O_CURVE*,NODE*,
						  Front*,INTERFACE*);
IMPORT	bool	rst_cor_after_attach_curve_to_node(CURVE*,CURVE*);
IMPORT	bool	rst_cor_after_invert_curve(CURVE*);
IMPORT	bool	rst_cor_after_split_curve(CURVE*,CURVE**);
#endif /* defined(TWOD) */

#if defined(TWOD)
	/* fcrosscur.c*/
IMPORT   bool    cross_segments(float,float,float,float,float,float,
                     float,float,float*);
IMPORT	bool	intersection_of_two_o_curves(O_CURVE*,O_CURVE*,O_CURVE*,
					     O_CURVE*,BOND**,BOND**,POINT**,
					     float*,float*,Front*,POINTER,
					     float,NODE_FLAG);
IMPORT	int	check_cross(float,BOND*,O_CURVE*,float,BOND*,O_CURVE*,POINT*,
			    float*,float*,int);
IMPORT	int	crossing_of_a_propagated_curve_and_circle(O_CURVE*,O_CURVE*,
				float,POINT*,POINT*,BOND**,float*,Front*,
				POINTER,RPROBLEM**,float,float*,NODE_FLAG);
IMPORT	int	crossing_of_two_propagated_curves(O_CURVE*,O_CURVE*,O_CURVE*,
				O_CURVE*,POINT*,BOND**,BOND**,float*,float*,
				Front*,POINTER,RPROBLEM**,float,float*,
				NODE_FLAG);
IMPORT	int	set_node_velocity(POINT*,POINT*,NODE*,O_CURVE*,O_CURVE*,
				  float*,float*,Front*,float,float*);
IMPORT	void	reverse_states_at_point(POINT*,Front*);
IMPORT	void	init_curve_for_crossing(POINT*,POINT*,BOND*,O_CURVE*,
					O_CURVE*,NODE**,BOND**,Front*,
					POINTER,float,float*,NODE_FLAG);
IMPORT	void	set_vel_of_crossing_node(BOND*,BOND*,BOND*,BOND*,int,int,
					 NODE*,NODE*,float,Front*);
IMPORT	void	set_virtual_bond_at_node(POINT*,BOND*,CURVE*,ORIENTATION,Front*,
					 int,NODE_FLAG);

	/* fcrossext.c*/
IMPORT	int	cross_or_extend_to_cross_two_propagated_curves(O_CURVE*,
				O_CURVE*,O_CURVE*,O_CURVE*,POINT**,BOND**,
				BOND**,float*,float*,Front*,POINTER,
				RPROBLEM**,float,float*,NODE_FLAG,bool*);
IMPORT	int	D_extend_crossing_of_two_propagated_curves(O_CURVE*,O_CURVE*,
				O_CURVE*,O_CURVE*,O_CURVE*,O_CURVE*,COMPONENT,
				COMPONENT,POINT*,BOND**,BOND**,float*,float*,
				Front*,POINTER,RPROBLEM**,float,float*,
				NODE_FLAG);
IMPORT	int	H_extend_crossing_of_two_propagated_curves(O_CURVE*,O_CURVE*,
				O_CURVE*,O_CURVE*,COMPONENT,COMPONENT,POINT*,
				BOND**,BOND**,float*,float*,Front*,POINTER,
				RPROBLEM**,float,float*,NODE_FLAG);
IMPORT	void	find_bonds_for_extension_direction(BOND*,O_CURVE*,O_CURVE*,
						   BOND*,BOND*,Front*);
IMPORT	void	set_use_circle_D_extend(bool);
IMPORT	void	set_use_normal_D_extend(bool);

	/* fcrstatus.c*/
IMPORT	int	find_D_extend_status(O_CURVE*,O_CURVE*,POINT*,BOND*,BOND*,
				     POINT*,Front*,POINTER,float,float*);
IMPORT	int	find_H_extend_status(O_CURVE*,O_CURVE*,POINT*,O_CURVE*,
				     O_CURVE*,float*,int,BOND*,POINT*,Front*,
				     POINTER,float,float*);
IMPORT	int	find_circle_cross_status(O_CURVE*,O_CURVE*,POINT*,float,
					 POINT*,Front*,float*);
IMPORT	int	find_cross_or_extend_to_cross_status(int,O_CURVE*,O_CURVE*,
				O_CURVE*,O_CURVE*,POINT*,POINT*,BOND*,BOND*,
				BOND*,BOND*,POINT*,NODE**,NODE**,Front*,
				POINTER,float,float*);
IMPORT	int	find_cross_status(int,O_CURVE*,O_CURVE*,O_CURVE*,O_CURVE*,
				  POINT*,POINT*,BOND*,BOND*,POINT*,NODE**,
				  NODE**,Front*,POINTER,float,float*);
IMPORT	int	robust_circle_cross_trace(POINT*,POINT*,POINT*,POINT*,
					  float,float*,POINT*);
IMPORT	int	robust_cross_trace(RECT_GRID*,POINT*,POINT*,BOND*,BOND*,
				   float*,POINT*);
IMPORT	void	set_prop_status_for_pseudo_cross_node(O_CURVE*,O_CURVE*,
				                      O_CURVE*,O_CURVE*,
						      Front*,POINTER,float,
						      NODE_FLAG);
#endif /* defined(TWOD) */

	/* finit.c*/
IMPORT	void	f_read_print_front_options(INIT_DATA*,Front*);
IMPORT	bool	f_read_print_max_front_speed_info(INIT_DATA*,const IO_TYPE*,
                                                  Front*,MAX_FRONT_SPEED*);
IMPORT	void	f_copy_redistribution_values(INIT_DATA*,Front*);
IMPORT	void	f_init_redistribute(INIT_DATA*,Front*);
IMPORT	void	f_prompt_for_front_options(INIT_DATA*,Front*);
IMPORT	void	f_prompt_for_redistribute(INIT_DATA*);
IMPORT	void	f_read_print_front(INIT_DATA*,Front*);
IMPORT	void	f_set_redistribution_defaults(INIT_DATA*);
IMPORT	void	init_front(INIT_DATA*,Front*);
IMPORT  void    initial_front_redistribute(Front*,const IO_TYPE*);
IMPORT	void	init_front_states(Front*,INIT_DATA*,
				  void (*)(POINT*,HYPER_SURF_ELEMENT*,
				           HYPER_SURF*,Locstate,Locstate,
					   INIT_DATA*));
IMPORT	void	set_dflt_cur_redist_params(Front*);
IMPORT	void	set_front_hooks(INIT_DATA*);

	/* fint.c*/
IMPORT	HYPER_SURF_BDRY	*f_make_hypersurface_boundary(void);
IMPORT	HYPER_SURF      *f_make_hypersurface(COMPONENT,COMPONENT);
IMPORT	INTERFACE       *f_copy_interface(INTERFACE*);
IMPORT	POINT	*f_Point(float*);
IMPORT	POINT	*f_Static_point(INTERFACE*);
IMPORT	POINT	*f_copy_point(POINT*);
IMPORT	bool	copy_intfc_states(void);
IMPORT	bool f_merge_hs_flags(HYPER_SURF*,HYPER_SURF*);
IMPORT	int	add_bstate_to_list(BOUNDARY_STATE*,INTERFACE*,int);
IMPORT	int	f_delete_interface(INTERFACE*);
IMPORT	bool	f_nearest_intfc_state(float*,COMPONENT,INTERFACE*,
				      Locstate,float*,HYPER_SURF**);
IMPORT	const char *f_wave_type_as_string(int);
IMPORT	int	f_read_hsbdry_type_from_string(const char*,INTERFACE*);
IMPORT	int	f_read_wave_type_from_string(const char*);
IMPORT	int	f_user_read_print_interface(INIT_DATA*,const IO_TYPE*,
                                            INTERFACE*,bool);
IMPORT	void	f_fprint_boundary_state_data(FILE*,INTERFACE*,BOUNDARY_STATE*);
IMPORT	void	f_fprint_hsbdry_type(FILE*,const char*,int,
				     const char*,INTERFACE*);
IMPORT	void	f_fprint_wave_type(FILE*,const char*,int,const char*,
                                   INTERFACE*);
IMPORT	void	f_read_print_boundary_state_data(INIT_DATA*,const IO_TYPE*,
                                                 INTERFACE*,int);
IMPORT	void	f_reconstruct_interface_pointers(INTERFACE*,struct Table *,
						 POINTER*,POINTER*);
IMPORT	void	f_reconstruct_point_pointers(POINT*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
IMPORT	void	f_user_copy_hyper_surf(HYPER_SURF*,HYPER_SURF*);
IMPORT	void	f_user_fprint_interface(FILE*,INTERFACE*);
IMPORT	void	f_user_fprint_intfc_rect_grids(FILE*,INTERFACE*);
IMPORT	void	f_user_make_interface(INTERFACE*);
IMPORT	void	f_user_read_print_intfc_rect_grids(const IO_TYPE*,INTERFACE*,
						   bool,REMAP*);
IMPORT	void	fixed_boundary_state(float*,HYPER_SURF*,Front*,
				     POINTER,Locstate);
IMPORT	void	set_computational_grid(INTERFACE*,RECT_GRID*);
IMPORT	void	set_copy_intfc_states(bool);
IMPORT	void	set_size_of_intfc_state(size_t);
#if defined(TWOD) || defined(THREED)
IMPORT	CURVE	*f_copy_curve(CURVE*,NODE*,NODE*);
IMPORT	CURVE	*f_make_curve(COMPONENT,COMPONENT,NODE*,NODE*);
IMPORT	NODE	*f_copy_node(NODE*);
IMPORT	NODE	*f_make_node(POINT*);
IMPORT	bool	interpolate_states_at_split_curve_node(void);
IMPORT	bool	f_delete_end_of_bond(BOND*,CURVE*);
IMPORT	bool	f_delete_node(NODE*);
IMPORT	bool	f_delete_start_of_bond(BOND*,CURVE*);
IMPORT	bool	f_insert_point_in_bond(POINT*,BOND*,CURVE*);
IMPORT	bool	f_user_join_curves(CURVE*,CURVE*,CURVE*);
IMPORT	bool	f_user_read_print_curve(CURVE*,const IO_TYPE*,bool);
IMPORT	bool	f_user_split_curve(int,POINT*,BOND*,CURVE*,CURVE**);
IMPORT	int	f_delete_curve(CURVE*);
IMPORT	int	f_user_read_node(NODE*);
IMPORT	void	f_reconstruct_bond_pointers(BOND*,INTERFACE*,INTERFACE*,
					    POINTER*,POINTER*,int);
IMPORT	void	f_reconstruct_curve_pointers(CURVE*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
IMPORT	void	f_reconstruct_node_pointers(NODE*,INTERFACE*,INTERFACE*,
					    POINTER*,POINTER*,int);
IMPORT	void	f_user_fprint_curve(FILE*,CURVE*);
IMPORT	void	f_user_fprint_node(FILE*,NODE*);
IMPORT	void	f_user_read_curve(CURVE*);
IMPORT	void	f_user_read_print_node(NODE*,const IO_TYPE*,bool);
IMPORT	void	set_interpolate_states_at_split_curve_node(bool);
#endif /* defined(TWOD) || defined(THREED) */
#if defined(ONED)
IMPORT	POINT	*f_make_point(float*,COMPONENT,COMPONENT);
#endif /* defined(ONED) */
#if defined(TWOD)
IMPORT	void	test_for_mono_comp_curves(INTERFACE*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	BOND_TRI *f_link_tri_to_bond(BOND_TRI*,TRI*,SURFACE*,BOND*,CURVE*);
IMPORT	C_BOND	*f_CBond(C_BOND*,POINT*,POINT*,TRI*,TRI*);
IMPORT	SURFACE	*f_join_surfaces(CURVE*);
IMPORT	SURFACE	*f_make_surface(COMPONENT,COMPONENT,CURVE**,CURVE**);
IMPORT	SURFACE	*f_copy_surface(SURFACE*,CURVE**,CURVE**,bool);
IMPORT	bool	f_insert_point_in_tri(POINT*,TRI*,SURFACE*);
IMPORT	bool	f_insert_point_in_tri_side(POINT*,int,TRI*,SURFACE*);
IMPORT	int	f_delete_surface(SURFACE*);
IMPORT	void 	f_reverse_bond(BOND*);
IMPORT	void 	f_reorder_curve_link_list(CURVE*);
IMPORT	void	f_assign_curve_boundary_flag(CURVE*);
IMPORT	void	f_user_fprint_surface(FILE*,SURFACE*);
IMPORT	void	f_user_install_faces(SURFACE*,int);
IMPORT	void	f_user_read_print_surface(SURFACE*,const IO_TYPE*,bool);
IMPORT	void	f_user_read_surface(SURFACE*);
#endif /* defined(THREED) */

#if defined(TWOD)
	/* fnode.c*/
IMPORT	int	B_node_propagate(Front*,POINTER,NODE*,NODE*,RPROBLEM**,
				 float,float*,NODE_FLAG);
IMPORT	int	closed_node_propagate(Front*,POINTER,NODE*,NODE*,float);
IMPORT	int	fixed_node_propagate(Front*,POINTER,NODE*,NODE*,float);
IMPORT	int	pp_node_propagate(Front*,POINTER,NODE*,NODE*,RPROBLEM**,
				  float,float*);
IMPORT  int	set_node_states_and_continue(NODE*,NODE*,Front*);
IMPORT	void	reset_fixed_node_states(NODE*,Front*);
#endif /* defined(TWOD) */

	/* fnodesub.c*/
#if defined(TWOD) || defined(THREED)
IMPORT	void	find_tangent_to_curve(POINT*,BOND*,CURVE*,ORIENTATION,
				      float*,Front*);
IMPORT	void	bond_secant_to_curve(POINT*,BOND*,CURVE*,ORIENTATION,BOND*,
				     Front*,float);
IMPORT	void	find_secant_to_curve(POINT*,BOND*,CURVE*,ORIENTATION,float*,
				     Front*,float);
#endif /* defined(TWOD) || defined(THREED) */
#if defined(TWOD)
IMPORT	CURVE	*find_physical_curve_at_node(NODE*,ORIENTATION*);
IMPORT	SIDE	find_propagation_side(O_CURVE*,POINT*,SIDE,Front*);
IMPORT	bool	delete_redundant_node(NODE*,CROSS*,RPROBLEM*,Front*);
IMPORT	bool	f_check_delete_redundant_node(NODE*,CURVE*,CURVE*);
IMPORT	int	bdry_node_type(int);
IMPORT	ANGLE_DIRECTION	f_find_i_to_prop_dir(Front*,POINTER,NODE*,CURVE*,
					     ORIENTATION,float,
					     COMPONENT*,POINT*,float*);
IMPORT	int	modify_B_node(NODE*,NODE*,O_CURVE*,O_CURVE*,O_CURVE*,O_CURVE*,
			      O_CURVE*,O_CURVE*,O_CURVE*,O_CURVE*,O_CURVE*,
			      O_CURVE*,POINT*,BOND*,BOND*,ANGLE_DIRECTION,
			      float,float,RPROBLEM**,Front*,POINTER,
			      float,float*,NODE_FLAG);
IMPORT	int	velocity_satisfies_CFL(NODE*,float,float*,Front*);
IMPORT	void	assign_interacting_states(POINT*,CURVE*,ORIENTATION,Front*,
					  Locstate,Locstate);
IMPORT	void	cut_curve(POINT*,BOND*,CURVE*,ORIENTATION,
			  Front*,Locstate,Locstate);
IMPORT	void	find_propagation_orientation(Front*,POINTER,NODE*,NODE*,POINT*,
					     O_CURVE*,float,ANGLE_DIRECTION*,
					     O_CURVE*,O_CURVE*,O_CURVE*,
					     O_CURVE*,SIDE*,SIDE*,
					     COMPONENT*,COMPONENT*);
IMPORT	void	find_tangent_to_propagated_curve(POINT*,BOND*,O_CURVE*,
						 O_CURVE*,float*,Front*,
						 POINTER,float);
IMPORT	void	init_redundant_node_for_deletion(NODE*,NODE*,Front*,
						 POINTER,float);
IMPORT	void	insert_point_adjacent_to_node(POINT*,CURVE*,ORIENTATION);
IMPORT	void	propagated_tangent_bond_at_node(BOND*,CURVE*,ORIENTATION,Front*,
						POINTER,float);
IMPORT	void	shift_node(POINT*,BOND*,CURVE*,ORIENTATION,
			   CURVE*,ORIENTATION,NODE*,Front*,
			   Locstate,Locstate,Locstate,Locstate);
IMPORT	void	shift_node_past(POINT*,BOND*,CURVE*,ORIENTATION,
				CURVE*,ORIENTATION,ANGLE_DIRECTION,NODE*,
				Front*,NODE_FLAG,Locstate,Locstate,
				Locstate,Locstate);
#endif /* defined(TWOD) */

#if defined(THREED)
	/* fdiagnostic.c */
IMPORT  void 	detail_of_curve(CURVE*);
IMPORT	void	summary_of_interface(INTERFACE*);
IMPORT  void	summarize_interface(const char*,const char*,INTERFACE*,
				    const COORDINATE_PLANE,
				    const char*,const char*);
#endif /* defined(THREED) */

	/* fprint.c*/
IMPORT	const char	*time_step_status_as_string(int);
IMPORT	void	f_fprint_front(Front*,FILE*);
IMPORT	void	f_print_Front_structure(Front*);
IMPORT	void	f_fprint_FlowSpecifiedRegion_data(FILE*,FlowSpecifiedRegion*,
						  Front*);
IMPORT	void	fprint_Tan_stencil(FILE*,Front*,Tan_stencil*);
IMPORT	void	print_AFLIN(FILE*,AFLIN*,int);
IMPORT	void	print_Tan_stencil(Front*,Tan_stencil*);
IMPORT  void    print_time_step_status(const char*,int,const char*);
IMPORT	void	debug_front(const char*,const char*,Front*);
IMPORT	void	f_fprint_max_front_speed_info(FILE*,Front*);
#if defined(TWOD)
IMPORT	const char *propagation_status_as_string(NODE_PROPAGATION_STATUS);
IMPORT	const char *redistribution_direction_as_string(REDISTRIBUTION_DIRECTION);
IMPORT	const char *untangle_status_as_string(int);
IMPORT	void	f_print_rp_node(RP_NODE*,RPROBLEM*);
IMPORT	void	f_print_rproblem(RPROBLEM*);
IMPORT	void	fprint_redistribution_direction(FILE*,const char*,
						REDISTRIBUTION_DIRECTION,
						const char*);
IMPORT	void	fshow_curve_states(FILE*,CURVE*);
IMPORT	void	print_bond_and_states(BOND*,CURVE*,Front*);
IMPORT	void	print_propagation_status(NODE*);
IMPORT  void    print_untangle_status(int);
IMPORT	void	show_curve_states(CURVE*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT  void    f_gview_plot_interface(const char*,INTERFACE*);
IMPORT	void	fshow_surface_states(FILE*,SURFACE*);
IMPORT	void	print_tri_states(TRI*,HYPER_SURF*);
IMPORT	void	show_surface_states(SURFACE*);
#endif /* defined(THREED) */
#if defined(TWOD) || defined(THREED)
IMPORT	void	print_node_status(const char*,int,const char*);
IMPORT	const char *node_status_as_string(int);
#endif /* defined(TWOD) || defined(THREED) */

#if defined(TWOD)
	/* fprop2d.c*/
IMPORT	void	f_curve_propagate2d(Front*,POINTER,CURVE*,CURVE*,float);
IMPORT	void	f_tan_curve_propagate(Front*,Front*,INTERFACE*,CURVE*,
				      CURVE*,float);
IMPORT	void	oblique_propagate_at_node(Front*,POINTER,POINT*,O_CURVE*,
					  O_CURVE*,float*,float);
IMPORT	void	set_no_tan_propagate(CURVE *);
#endif /* defined(TWOD) */

	/* fprop3d.c*/
#if defined(THREED)
IMPORT	bool	f_tan_point_propagate(Front*,POINT*,POINT*, 
				      HYPER_SURF_ELEMENT*,HYPER_SURF*,float);
IMPORT	void	set_weight_for_tri_interpolation(float*,TRI*,float*,float*,
	                                         INTERFACE*);
#endif /* defined(THREED) */

#if defined(TWOD) || defined(THREED)
	/*	fredist.c*/
IMPORT	bool	f_perform_redistribution(HYPER_SURF*,Front*,bool);
IMPORT	bool	interface_is_tangled(CROSS*);
IMPORT	bool	redist_needed(Front*,int);
IMPORT	int	redistribute(Front*,bool,bool);
IMPORT	void	Clear_redistribution_parameters(Front*);
#endif /* defined(TWOD) || defined(THREED) */

#if defined(ONED)
	/* fredist1d.c*/
IMPORT	int	redistribute1d(Front*);
#endif /* defined(ONED) */

#if defined(TWOD)
	/* fredist2d.c*/
IMPORT	bool	backward_equi_curve_redistribute(Front*,CURVE*,bool);
IMPORT	bool	equi_curve_redistribute(Front*,CURVE*,bool);
IMPORT	bool	expand_redist_cur(Front*,CURVE*);
IMPORT	bool	expansion_redistribute(Front*,bool*);
IMPORT	bool	force_tangle(void);
IMPORT	bool	full_dec_redist_cur(Front*,CURVE*,bool);
IMPORT	bool	full_inc_redist_cur(Front*,CURVE*,bool);
IMPORT	bool	full_redistribute(Front*,bool*);
IMPORT	int	join_curves_at_closed_nodes(INTERFACE*);
IMPORT	int	redistribute2d(Front*,bool,bool);
#endif /* defined(TWOD) */

	/* fredist3d.c*/
IMPORT	int	redistribute3d(Front*,bool,bool);
IMPORT	bool	surface_redistribute(Front*,bool*);

#if defined(TWOD)
	/* frp1.c */
IMPORT	F_USER_RPROBLEM	*rp_user_hook(void);
IMPORT	RP_NODE	*add_to_rp_node_list(RPROBLEM*,NODE*,NODE*);
IMPORT	bool	f_untrack_curve(O_CURVE*,O_CURVE*,COMPONENT,float,Front*,
				POINTER,RPROBLEM*,UNTRACK_FLAG);
IMPORT	int	is_bdry_type(RPROBLEM*);
IMPORT	int	is_null_curve(CURVE*,RPROBLEM*);
IMPORT	void	add_oc_curve_to_family(O_CURVE*,O_CURVE_FAMILY**);
IMPORT	void	delete_curve_from_o_curve_family(CURVE*,O_CURVE_FAMILY**);
IMPORT	void	delete_null_physical_curves(RPROBLEM*);
IMPORT	void	delete_o_curve_with_curve(O_CURVE**,CURVE*);
IMPORT	void	find_corr_cur_in_rp(O_CURVE*,O_CURVE*,Front*,RPROBLEM*);
IMPORT	void	find_curves_with_wave_type(NODE*,CURVE**,ORIENTATION*,
					   CURVE**,ORIENTATION*,int);
IMPORT	void	init_ocurve_lists(RPROBLEM*,Front*);
IMPORT	void	join_cfamilies(O_CURVE_FAMILY**,O_CURVE_FAMILY*);
IMPORT	void	roclists_after_invert(RPROBLEM*,CURVE*,O_CURVE*);
IMPORT	void	roclists_after_join(RPROBLEM*,CURVE*,O_CURVE*,CURVE*,
				    O_CURVE*,CURVE*);
IMPORT	void	roclists_after_split(RPROBLEM*,CURVE*,CURVE**,int);
IMPORT	void	rrpnlist_after_delete_node(RPROBLEM*,NODE*);
IMPORT	void	f_set_rp_statistics(RPROBLEM*);
IMPORT	void	set_states_at_node_by_propagate(Front*,POINTER,O_CURVE*,
						O_CURVE*,float);
IMPORT	void	augment_rproblem_list(RPROBLEM**,NODE**,float,float,
				      INTERFACE*,INTERFACE*,Front*,POINTER);
IMPORT	void	delete_null_boundary_curves(RPROBLEM*,Front*,POINTER);
IMPORT	void	delete_oc_curve_from_family(O_CURVE**,O_CURVE_FAMILY**);
IMPORT	void	f_delete_curve_from_rp_node(CURVE*,RP_NODE*,RPROBLEM*);
IMPORT	void	f_init_rp_nodes(RPROBLEM*);
IMPORT	void	free_o_curve_family(O_CURVE_FAMILY*);
IMPORT	void	free_rp(RPROBLEM*);
IMPORT	void	free_rp_list(RPROBLEM**);
IMPORT	void	fshow_intfc_states(FILE*,INTERFACE*);
IMPORT	void	init_cfamily(O_CURVE_FAMILY**,CURVE*,ORIENTATION);
IMPORT	void	init_o_curve(O_CURVE**,CURVE*,ORIENTATION);
IMPORT	void	merge_and_delete_overlaps(RPROBLEM*,RPROBLEM*);
IMPORT	void	merge_rproblems(RPROBLEM*,RPROBLEM*);
IMPORT	void	relocate_null_pointer(POINTER*,POINTER*);
IMPORT	void	reset_component_of_loop(CURVE*,ORIENTATION,
					ANGLE_DIRECTION,COMPONENT,Front*);

	/* frp2.c */
IMPORT	bool	fixed_type_node(NODE*);
IMPORT	bool	generate_boundary_cross_list(CROSS**,RPROBLEM*,Front*,POINTER);
IMPORT	bool	rp_node_with_node(RP_NODE**,RPROBLEM*,NODE*);
IMPORT	int	incident_curve_crosses_fixed_node(Front*,Front*,POINTER,
						  RPROBLEM*);
IMPORT	int	join_propagated_curves(NODE**,CURVE**,O_CURVE**,O_CURVE**,
				       int,Front*,Front*,POINTER,RPROBLEM*);
IMPORT	int	phys_node_crosses_bdry(Front*,Front*,POINTER,RPROBLEM*,
				       NODE_FLAG);
IMPORT	void	find_rpn_with_physical_node(RP_NODE**,RPROBLEM*,int);
#endif /* defined(TWOD) */

	/* fscatter.c*/
IMPORT	INTERFACE	*f_zoom_interface(INTERFACE*,RECT_GRID*,float*,
					  float*,float**);
IMPORT	bool	scatter_front(Front*);
IMPORT	void	delete_subdomain_boundaries(INTERFACE*);

#if defined(ONED)
IMPORT	bool	f_intfc_communication1d(Front*);
#endif /* defined(ONED) */

#if defined(TWOD)
	/* fscat2d.c*/
IMPORT	bool	f_intfc_communication2d(Front*);
IMPORT	void 	cut_interface(INTERFACE*,float,int,int,bool,bool);
IMPORT	void	delete_subdomain_curves(INTERFACE*);
#if defined(USE_OVERTURE)
IMPORT  void    clip_interface_with_rect(INTERFACE*,float*,float*,bool);
IMPORT  void    set_cut_none_local_flag(int);
IMPORT  int     get_cut_none_local_flag(void);
IMPORT  void    set_min_sc_sep_val_flag(int);
IMPORT  void    set_use_delete_short_bonds_flag(void);
IMPORT  void    set_center_comp(int,COMPONENT); 
IMPORT  void    set_debug_cut_flag(int);  
#endif /* if defined(USE_OVERTURE) */
#endif /* defined(TWOD) */

#if defined(THREED)
	/* fscat3d1.c*/
IMPORT	CURVE	*matching_curve(CURVE*,P_LINK*,int);
IMPORT	NODE	*matching_node(NODE*,P_LINK*,int);
IMPORT	SURFACE	*copy_buffer_surface(SURFACE*,P_LINK*,int);
IMPORT	bool	curves_match(CURVE*,CURVE*,P_LINK*,int);
IMPORT	bool	f_intfc_communication3d(Front*);
IMPORT	void	cut_out_curves_in_buffer(INTERFACE*);
IMPORT	void	install_subdomain_bdry_curves(INTERFACE*);
IMPORT	void	merge_two_tris(TRI*,TRI*,SURFACE*,SURFACE*);
IMPORT	void	remove_out_domain_tri(TRI*,SURFACE*);
IMPORT	void	strip_subdomain_bdry_curves(INTERFACE*);
IMPORT  void    set_floating_point_tolerance1(float*);
IMPORT  void    open_null_sides1(INTERFACE*,float*,float*,int,int);
IMPORT  void    copy_mesh(Front*,Front*);

#if defined(USE_OVERTURE)
IMPORT  bool    f_form_patch_subintfc_via_cut3d(Front*); 
#endif /* if defined(USE_OVERTURE) */

	/* fscat3d2.c*/
IMPORT	bool	f_intfc_communication3d2(Front*);
IMPORT  void    clip_front_for_output(Front*,RECT_GRID*);
IMPORT	float	line_cross_tolerance(RECT_GRID*);
#endif /* defined(THREED) */

	/* fstate.c*/
IMPORT	ConstantFlowRegion	*SetConstantFlowRegion(COMPONENT,Locstate,
						       INTERFACE*);
IMPORT	FlowSpecifiedRegion	*SetSkipComponentRegion(COMPONENT);
IMPORT	FlowSpecifiedRegion	*SetSkipAllComponents(void);
IMPORT	FlowSpecifiedRegion	*AddToFsrList(FlowSpecifiedRegion*);
IMPORT	Locstate	f_alloc_intfc_state(size_t);
IMPORT	bool	ComponentIsFlowSpecified(COMPONENT,Front*);
IMPORT	bool	RegionIsFlowSpecified(Locstate,Locstate,float*,COMPONENT,
				      COMPONENT,Front*);
IMPORT	void	f_alloc_state(Locstate*,size_t);
IMPORT	void	f_clear_state(Locstate,size_t);
IMPORT	void	SetActiveFlowComponent(COMPONENT,Front*);
IMPORT	void	nearest_intfc_state_and_pt(float*,COMPONENT,Front*,Front*,
					   Locstate,float*,HYPER_SURF**);
#if defined(THREED)
IMPORT	bool	f_sort_bond_tris(INTERFACE*);
#endif /* defined(THREED) */

#if defined(THREED)
	/* fcheck3d.c */
IMPORT	bool	f_consistent_interface(INTERFACE*);
#endif /* defined(THREED) */

#if defined(TWOD)
	/* fstate2d.c */
IMPORT	void	set_states_by_interpolation(CURVE*,BOND*,BOND*,SIDE,Locstate,
					    Locstate,size_t);
IMPORT	void	states_at_distance_along_curve(POINT*,BOND*,CURVE*,ORIENTATION,
					       float,int,Locstate*,Locstate*,
					       HYPER_SURF**,
					       HYPER_SURF_ELEMENT**,
					       float*,POINT**,Front*);
#endif /* defined(TWOD) */

	/* fsub.c*/
IMPORT	Tan_stencil	*alloc_tan_stencil(Front*,int);
IMPORT	MAX_FRONT_SPEED	*f_alloc_MaxFrontSpeed(MAX_FRONT_SPEED*,INTERFACE*,
                                               size_t);
IMPORT	POINT	*f_average_points(bool,POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
			               POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*);
IMPORT	float	f_max_front_time_step(Front*,float*);
IMPORT	int	syncronize_time_step_status(int,PP_GRID*);
IMPORT	void	assign_interface_and_free_front(Front*,Front*);
IMPORT	void	delete_passive_boundaries(INTERFACE*);
IMPORT	void	f_copy_into_front(Front*,Front*);
IMPORT	void	f_initialize_max_front_speed(Front*);
IMPORT	void	f_principal_tangent(POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
				    float*,float*);
IMPORT	void	f_set_default_front_parameters(INIT_DATA*,Front*);
IMPORT	void	f_set_max_front_speed(int,float,Locstate,float*,Front*);
IMPORT	void	assign_front_interface(Front*,Front*);
IMPORT	void	measure_front(Front*);
IMPORT	void	set_default_tan_stencil(Tan_stencil*);
#if defined(TWOD)
IMPORT	ANGLE_DIRECTION	c1_to_c2_direction(O_CURVE*,O_CURVE*);
IMPORT	float	angle_from_c1_to_c2_at_common_node(CURVE*,ORIENTATION,
						   CURVE*,ORIENTATION,Front*);
IMPORT	float	f_mean_curvature_at_point2d(POINT*,HYPER_SURF_ELEMENT*,
					    HYPER_SURF*,Front*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	float	f_mean_curvature_at_point3d(POINT*,HYPER_SURF_ELEMENT*,
					    HYPER_SURF*,Front*);
#endif /* defined(THREED) */

	/* ftop.c*/
IMPORT	bool	f_is_subdomain_boundary(HYPER_SURF*);
IMPORT	void	f_reflect_point(POINT*,float*,float*,INTERFACE*);
IMPORT	void	f_fset_hyper_surf_color(FILE*,HYPER_SURF*);
#if defined(ONED) || defined(TWOD)
IMPORT	int	synchronize_untangle_status(int);
#endif /* defined(ONED) || defined(TWOD) */
#if defined(TWOD) || defined(THREED)
IMPORT	void	f_invert_curve(CURVE*);
IMPORT	void	f_reverse_curve(CURVE*);
#endif /* defined(TWOD) || defined(THREED) */
#if defined(ONED)
IMPORT	bool	f_untrack_point(POINT*,COMPONENT,Front*);
#endif /* defined(ONED) */
#if defined(TWOD)
IMPORT	CURVE	*f_attach_curve_to_node(CURVE*,POINT*,BOND*,NODE*);
IMPORT	O_CURVE_FAMILY	*find_loop(CURVE*,ORIENTATION,ANGLE_DIRECTION);
IMPORT	bool	f_delete_point_adjacent_to_node(Front*,CURVE*,ORIENTATION);
IMPORT	bool	intfc_delete_fold_back_bonds(Front*);
IMPORT	bool	f_is_subdomain_node(NODE*);
IMPORT	bool	f_is_virtual_fixed_node(NODE*);
IMPORT  bool	f_move_closed_loop_node(CURVE*,BOND*);
IMPORT	bool	is_stationary_node(NODE*);
IMPORT	float	f_area_of_loop(CURVE*,ORIENTATION,CURVE*);
IMPORT	void	curve_delete_very_short_bonds(CURVE*);
IMPORT	void	delete_interior_points_of_curve(Front*,CURVE*);
IMPORT	void	f_delete_fold_back_bonds(Front*,CURVE*,float,int*,int*);
IMPORT	void	f_delete_small_loops(Front*);
IMPORT	void	f_reflect_curve2d(CURVE*,float*,float*);
IMPORT	void	f_reflect_node2d(NODE*,float*,float*);
IMPORT	void	intfc_delete_very_short_bonds(Front*);
IMPORT	void	split_curves_at_cross(CROSS*,Front*,NODE**,CURVE**,COMPONENT*,
				      COMPONENT*,CURVE**,COMPONENT*,COMPONENT*,
				      float,POINTER);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	void	f_reflect_surface(SURFACE*,float*,float*);
IMPORT	bool f_untrack_surface(SURFACE*,COMPONENT,Front*);
#endif /* defined(THREED) */

#if defined(TWOD)
	/* funtan2d.c*/
IMPORT	CURVE	*next_curve_of_gen_curve(CURVE*,ORIENTATION,int*,NODE**);
IMPORT	NODE	*opp_node_of_gen_curve(CURVE*,ORIENTATION);
IMPORT	bool	f_delete_loop(NNLIST*,NNLIST**,CURVE**,Front*,int,float,int);
IMPORT	bool	f_replace_unphys_loop(NNLIST*,NNLIST**,CURVE**,Front*,
				      int,float,int);
IMPORT	bool	is_scalar_vector_cross(CROSS*);
IMPORT	bool	is_vector_vector_cross(CROSS*);
IMPORT	int	scalar_unravel(Front*,CROSS**,int);
IMPORT	void	eliminate_small_loops(INTERFACE*,float,float,CROSS**);
#endif /* defined(TWOD) */

#if defined(THREED)
	/*funtan3d.c*/
IMPORT	bool scalar_unravel_3d(Front*,CROSS**);
#endif /* defined(THREED) */

	/* fuserintfc.c */
IMPORT	F_USER_INTERFACE *f_user_hook(int);
IMPORT	void	f_set_interface_hooks(int);
IMPORT	void	f_preserve_user_hooks(int,PRESERVE_USER_HOOKS);
IMPORT	void	f_set_normal_function(const char*,NORMAL_FUNCTION*,INTERFACE*);
IMPORT	void	f_set_tangent_function(const char*,TANGENT_FUNCTION*,
                                       INTERFACE*);
#if defined(TWOD)
IMPORT	void	set_tangent_operator(TANGENT_METHOD,int);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	void	set_normal3d_method(NORMAL3D_METHOD,int);
#endif /* defined(THREED) */

	/* fuserhooks.c */
IMPORT	MAX_FRONT_SPEED	*alloc_MaxFrontSpeed(MAX_FRONT_SPEED*,INTERFACE*,
                                             size_t);
IMPORT	Locstate read_print_state_data(INIT_DATA*,const IO_TYPE*,
                                       Locstate,INTERFACE*);
IMPORT	bool	form_subintfc_via_communication(Front*);
IMPORT	bool merge_hs_flags(HYPER_SURF*,HYPER_SURF*);
IMPORT	bool	tri_interpolate_intfc_states(INTERFACE*,float,float,float,
					     float*,Locstate,float*,Locstate,
					     float*,Locstate,Locstate);
IMPORT	float	mean_curvature_at_point(POINT*,HYPER_SURF_ELEMENT*,
					HYPER_SURF*,Front*);
IMPORT	bool	nearest_intfc_state(float*,COMPONENT,INTERFACE*,Locstate,
				    float*,HYPER_SURF**);
IMPORT	const char *wave_type_as_string(int,INTERFACE*);
IMPORT	int	read_hsbdry_type_from_string(char*,INTERFACE*);
IMPORT	int	read_wave_type_from_string(const char*,INTERFACE*);
IMPORT	void	bi_interpolate_intfc_states(INTERFACE*,float,float,float*,
					    Locstate,float *,Locstate,Locstate);
IMPORT	void	delete_curve_from_rp_node(CURVE*,RP_NODE*,RPROBLEM*);
IMPORT	void	fprint_hsbdry_type(FILE*,const char*,int,const char*,
				   INTERFACE*);
IMPORT	void	fprint_intfc_state(FILE*,Locstate,INTERFACE*);
IMPORT	void	fprint_state_data(FILE*,Locstate,INTERFACE*);
IMPORT	void	fprint_wave_type(FILE*,const char*,int,const char*,INTERFACE*);
IMPORT	void	free_rp_node(RP_NODE*,RPROBLEM*);
IMPORT	void	init_rp_nodes(RPROBLEM*);
IMPORT	void	normal(POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,float*,Front*);
IMPORT	void	print_intfc_state(Locstate,INTERFACE*);
IMPORT	void	print_rp_node(RP_NODE*,RPROBLEM*);
IMPORT	void	print_rproblem(RPROBLEM*);
IMPORT	void	reflect_state(Locstate,INTERFACE*,float*,float*,float*);
IMPORT	void	show_intfc_states(INTERFACE*);
IMPORT	void	set_phys_ocurves_to_null(RP_NODE*,RPROBLEM*);
IMPORT	void	set_rp_statistics(RPROBLEM*);
IMPORT	void	set_normal_function(const char*,NORMAL_FUNCTION*,INTERFACE*);
IMPORT	void	set_tangent_function(const char *s,TANGENT_FUNCTION*,
                                     INTERFACE*);
IMPORT	void	slsr(POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
		     Locstate*,Locstate*);
IMPORT	void	state_along_hypersurface_element(COMPONENT,float*,
						 HYPER_SURF_ELEMENT*,
						 HYPER_SURF*,Locstate);
IMPORT	void	tangent(POINT*,BOND*,CURVE*,float*,Front*);
IMPORT	void	user_print_rp_node(RP_NODE*,RPROBLEM*);
IMPORT	void	user_print_rproblem(RPROBLEM*);
IMPORT	void	user_free_rp_node(RP_NODE*,RPROBLEM*);

#if defined(USE_OVERTURE)
        /* fpatch.c */
IMPORT  void    newfront_to_distri_table(Front*,Front*,int,Wv_on_pc**,int);
IMPORT  void    set_patch_front(Front*,Front*,RECT_GRID*,int);
IMPORT  void    set_patch_topo_grid(RECT_GRID*,RECT_GRID*);
IMPORT  bool    clip_patch_front(Front*,int);
IMPORT  int     assembly_fine_patch_fronts_to_one(Front**,Front*);
IMPORT  int     assembly_distribute_patch_fronts(Front**,int,Wv_on_pc**,
                    int,int);
IMPORT  int     assembly_coarse_patch_fronts(Front**,int,Wv_on_pc**,int);
IMPORT  void    send_front_misc(Front*,COMPONENT*,int);
IMPORT  void    recv_front_misc(Front*,COMPONENT*,int);
IMPORT  void    send_mini_front_misc(Front*,COMPONENT*,int);
IMPORT  void    recv_mini_front_misc(Front*,COMPONENT*,int);
IMPORT  int     set_copy_proc_frs(Front***,int,Wv_on_pc**,int,int*);
IMPORT  void    fast_ireinstall_undistribute_fronts(Front**,Front**,
                  Wv_on_pc**,int,int,int);
IMPORT  void    unbundle_recv_front_misc(Front*,COMPONENT*,byte*);
IMPORT  void    fast_patch_front_trans(Front**,Front**,Wv_on_pc**,int,int,int);
IMPORT  void    patch_front_distribute_to_nodes(Front**,Front**,Wv_on_pc**,int,int,int);
IMPORT  int     trans_item_offset(Wv_on_pc**,int,int,int);
IMPORT  Front   *front_on_redistr_table(Wv_on_pc**,int,int,int,int);
#if defined(__MPI__)
IMPORT  void    irecv_front_misc(Front*,int,byte**,int,MPI_Request*);
IMPORT  void    isend_front_misc(Front*,COMPONENT*,int,byte**,int,MPI_Request*);
#endif /* if defined(__MPI__) */
IMPORT  int     scatter_patch_fronts(Front**,int,Wv_on_pc**,int,Overparam*,int);

#if defined(TWOD) 
        /* fpatch2d.c */
IMPORT  void    remove_patch_all_boundary_curves(Front*);
IMPORT  void    delete_patch_all_curves(Front*);
IMPORT  bool    f_form_patch_subintfc_via_cut2d(Front*);
IMPORT  bool    f_form_patch_subintfc_2d(Front*,COMPONENT);
IMPORT  int     assembly_fine_patch_fronts_to_one2d(Front**,Front*);
IMPORT  int     assembly_fine_patch_fronts_to_one2d_ver2(Front**,Front*);
IMPORT  void    delete_interior_curves(INTERFACE*);

         /* famrscat2d.c */
IMPORT  int     loc_front_on_redistr_table(Front*,Wv_on_pc**,int,int*);
IMPORT  int     blk2d_neighbor_id(int*,int*,int,PP_GRID*);
IMPORT  int     pp_node_in_neighbor(int,PP_GRID*,int*,int*);
#endif /* if defined(TWOD) */

	/* fpatchplot.c  */
IMPORT  void    geomview_amr_fronts_plot(const char*,Front**,int,Wv_on_pc**,int);
        /* fpatch3d.c */
#if defined(THREED)
IMPORT  int     assembly_fine_patch_fronts_to_one3d(Front**,Front*);
#endif /* if defined(THREED) */
#endif /* if defined(USE_OVERTURE) */

#endif /* !defined(_FPROTOS_H) */
