/*
*				test_init.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains the driver initializing routines, as called in main,
*	and the principle or default initializing subroutines.
*/


#include <driver/ddecs.h>

#define Next_m4(n)              (((n) + 1) % 4)
#define Prev_m4(n)              (((n) + 3) % 4)

#define state_id(i)     (STATE_ID + (i+1)) // combine with other replications.
LOCAL size_t BLOCK_SIZE = 0; /*TOLERANCE - TODO: what is a good value*/ // combine with other replications.

#if !defined(RAND_MAX)
 #if defined(__cplusplus)
  #include <cstdlib>
 #endif /* defined(__cplusplus) */
#endif // if !defined(RAND_MAX)

	/* LOCAL Function Declarations */
LOCAL   TRI    **read_input_easy_mesh(char*,Front*,int*,int***);
LOCAL   TRI    **read_input_easy_mesh_MHD(char*,Front*,int*,int***);
LOCAL   TRI    **read_input_mesh(char*,Front*,int*);
LOCAL   char   *readline(char*,FILE*,char*);
LOCAL   char   *findfield(char *string);
LOCAL   void   comput_normal3d(float*,float*,float*,float*);
LOCAL   void   init_true_diag_triangle_gas_sine(Front*);
LOCAL   int    tris_share_edge(TRI*,TRI*);
// LOCAL   void   attach_buffer_tris(Front*);
// LOCAL   void   clip_tris_to_subdomain(Front*);
// LOCAL   bool   tri_out_rect(TRI*,float*,float*);
LOCAL   void   remove_out_rect_tri(TRI*,SURFACE*);
LOCAL   void   tmp_remove_tri_from_surface(TRI*,SURFACE*);
LOCAL   void   split_tri_on_corner(Front*);
LOCAL   int    tri_side_on_domain_boundary(TRI*,int,RECT_GRID*);
LOCAL   void   install_dual_cell_to_tris(POINT*,TRI**,int,POLYGON*);
// LOCAL   void   comp_C0_conformal_basis_polygon(POLYGON*);
LOCAL   void   remove_out_rect_polygon(POLYGON*,SURFACE*);
LOCAL   void   tmp_remove_polygon_from_surface(POLYGON*,SURFACE*);

LOCAL   void   perturb_struc_triangle(Front*,POINT***,int);
LOCAL   void   parallel_perturb_struc_triangle(Front*,POINT***);
LOCAL   double RNG(void);
LOCAL   void   pp_send_interior_point_crds(int*,int,int,Front*,POINT***);
LOCAL   void   pp_receive_interior_point_crds(int*,int,int,Front*,POINT***);
LOCAL   void   local_set_send_domain(int*,int*,int,int,RECT_GRID*);
LOCAL   void   local_set_receive_domain(int*,int*,int,int,RECT_GRID*);

//Random number generator to give random numbers in [0, 1]
LOCAL double RNG()
{
    double random;
    random=(1.0*(rand()%RAND_MAX))/(1.0*RAND_MAX);
    return (random);
}

LOCAL char *readline(
	char *string, 
	FILE *infile, 
	char *infilename)
{
  char *result;

  do {
    result = fgets(string, 1024, infile);
    if (result == (char *) NULL) 
    {
      printf("  Error:  Unexpected end of file in %s.\n",
             infilename);
      clean_up(ERROR);
    }
    while ((*result != '\0') && (*result != '#')
           && (*result != '.') && (*result != '+') && (*result != '-')
           && ((*result < '0') || (*result > '9'))) 
    {
      result++;
    }
  } while ((*result == '#') || (*result == '\0'));
  return result;
}

LOCAL char *findfield(char *string)
{
  char *result;
  result = string;
  while ((*result != '\0') && (*result != '#')
         && (*result != ' ') && (*result != '\t')) {
    result++;
  }
  while ((*result != '\0') && (*result != '#')
         && (*result != '.') && (*result != '+') && (*result != '-')
         && ((*result < '0') || (*result > '9'))) {
    result++;
  }
  if (*result == '#') {
    *result = '\0';
  }
  return result;
}

LOCAL TRI **read_input_mesh(
	char    *name,
	Front   *fr,
        int     *tri_num)
{
	FILE    *fp[7];
	char    outname[7][256];
	int     n_node = 0, i, nodenumber, j, dim = 2;
        int     n_tri, **tri_node, **neigh;
        float   **crds_node, coords[3];
	char    inputline[1024];
        char    *stringptr; 

        TRI        **tri, *tmptri;
        POINT      **p, *pt[4], *tmpp[3];
        INTERFACE  *cur_intfc;
        bool       sav_copy;
        SURFACE    *s;
        float      nor[3];
        int        side;

	sprintf(outname[0],"Mesh/%s.1.node",name);
	sprintf(outname[1],"Mesh/%s.1.ele",name);
	sprintf(outname[2],"Mesh/%s.1.neigh",name);

        if ((fp[0] = fopen(outname[0],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[0]); 
            clean_up(ERROR);
        } 

        if ((fp[1] = fopen(outname[1],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[1]); 
            clean_up(ERROR);
        } 
        
        if ((fp[2] = fopen(outname[2],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[2]);
            clean_up(ERROR);
        }


	fscanf(fp[0],"%d %*d %*d %*d\n",&n_node);

        matrix(&crds_node,n_node,dim,sizeof(float));

        printf("TRI n_node = %d\n", n_node);

        for(i = 0; i < n_node; i++)
        {
            stringptr = readline(inputline, fp[0], outname[0]);

            // printf("string %s\n", stringptr);
            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < dim; j++) 
	    {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0') 
                {
                   printf("Error:  Point %d is missing a coordinate in %s.\n",
                     i+1, outname[0]);
                   clean_up(ERROR);
                }
                crds_node[i][j] = (float) strtod(stringptr, &stringptr);
            }
            // printf("node[%d] crds %g %g\n", i+1, crds[0], crds[1]);
        }

        fscanf(fp[1],"%d %*d %*d\n",&n_tri);       

        printf("TRI number = %d\n", n_tri);

        matrix(&tri_node,n_tri,3,sizeof(float));
        matrix(&neigh,n_tri,3,sizeof(float));

        for(i = 0; i < n_tri; i++)
        {
            stringptr = readline(inputline, fp[1], outname[1]);

            // printf("string %s\n", stringptr);
            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                tri_node[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // printf("tri[%d] node[%d %d %d]\n", i+1, tri_node[i][0], tri_node[i][1], tri_node[i][2]);
        }

        fscanf(fp[2],"%*d %*d\n");       
        for(i = 0; i < n_tri; i++)
        {
            fscanf(fp[2],"%*d %d %d %d\n", &neigh[i][0], &neigh[i][1], &neigh[i][2]);  
            // printf("tri[%d] neighbr[%d %d %d]\n", i+1, neigh[i][0], neigh[i][1], neigh[i][2]);
        }

        ////////////////////
        // make_tris
        ////////////////////
        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(fr->interf));
        set_copy_intfc_states(YES);

        if(NULL == (fr->mesh = copy_interface(fr->interf)))
        {
            printf("ERROR make_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(fr->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);
 
        set_alloc_mass_storage_flag(YES);

        s = i_make_surface(2,3,NULL,NULL);

        vector(&p, n_node,sizeof(POINT *));
        vector(&tri, n_tri, sizeof(TRI *));

        for(i = 0; i < n_node; i++)
        {
            coords[0] = crds_node[i][0];
            coords[1] = crds_node[i][1];
            coords[2] = 0.0;
            p[i] = Point(coords);
        }
    
        // triangle pt is COUNTER_CLOCK oriented.
        for(i = 0; i < n_tri; i++)
        {
            pt[0] = p[tri_node[i][0]-1];
            pt[1] = p[tri_node[i][1]-1];
            pt[2] = p[tri_node[i][2]-1];

            comput_normal3d(Coords(pt[0]), Coords(pt[1]), Coords(pt[2]), nor);
            if(nor[2] > 0.0)
            {
                tri[i] = i_make_tri(pt[0],pt[1],pt[2],
                                 NULL,NULL,NULL,YES);
                tri[i]->id = i;
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Lmass_matrix);
                // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                inverse_matrix(tri[i]->Lmass_matrix,MAX_N_COEF,tri[i]->mass_inv);
            }
            else
            {
               tri[i] = i_make_tri(pt[0],pt[2],pt[1],
                                 NULL,NULL,NULL,YES);
               printf("ERROR: CLOCK-wise tri created\n");
               clean_up(ERROR);
            }
            insert_tri_at_tail_of_list(tri[i],s);

            // TMP
            /**
            printf("print tri[%d] coords:\n", i);
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
            **/ 
        }

        s->num_tri = n_tri;

        // Set tri neighbr
        // The first neighbor of triangle i is opposite the first corner of triangle i, and so on.
        for(i = 0; i < n_tri; i++)
        {
            set_01_bdry(Boundary_tri(tri[i]),NO);
            set_12_bdry(Boundary_tri(tri[i]),NO);
            set_20_bdry(Boundary_tri(tri[i]),NO);

            for(j = 0; j < 3; j++)
            {
                side = (j+1)%3;
                if(neigh[i][j] != -1)
                {
                    Tri_on_side(tri[i], side) = tri[neigh[i][j]-1];  
                    if(tris_share_edge(tri[i], tri[neigh[i][j]-1]) == NO)
                    {
                        printf("ERROR: tris do not share edge\n");
                        clean_up(ERROR); 
                    }

                    /**
                    printf("tri[%d] side[%d] is tri[%d]\n", 
                           i+1, (j+1)%3, neigh[i][j]);
                    printf("print tri[%d] coords:\n", i+1);
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
                    printf("print neigh tri[%d] coords:\n", neigh[i][j]);
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[0]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[1]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[2]), dim, "\n\n");
                    **/
                }
                else
                {
                    // Boundary_tri(tri[i]) = YES;
                    set_side_bdry(Boundary_tri(tri[i]),side,YES);
                }
            } 

            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
            
            // if(i == 2)
            //     printf("tri[%d] is boundary tri %d, neigh[%d %d %d]\n", 
            //          i, Boundary_tri(tri[i]), neigh[i][0], neigh[i][1], neigh[i][2]);    
             
        }

        free(crds_node);
        free(tri_node); free(neigh);
        free(p); 

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        // NEW
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

#if !defined(_MPI_)
        output_tri_mesh("visual",0,fr->mesh);
#endif // if !defined(_MPI_)

        fclose(fp[0]);
        fclose(fp[1]);
        fclose(fp[2]);

        *tri_num = n_tri;
        return tri;
}

LOCAL TRI **read_input_easy_mesh(
        char    *name,
        Front   *fr,
        int     *tri_num,
	int     ***out_neigh)
{
        FILE    *fp[7];
        char    outname[7][256];
        int     n_node = 0, i, nodenumber, j, dim = 2;
        int     n_tri, **tri_node, **neigh;
        float   **crds_node, coords[3];
        char    inputline[1024];
        char    *stringptr;

        TRI        **tri, *tmptri;
        POINT      **p, *pt[4], *tmpp[3];
        INTERFACE  *cur_intfc;
        bool       sav_copy;
        SURFACE    *s;
        float      nor[3], tmpcent[3];
        int        side;
        RECT_GRID  *gr = fr->rect_grid;
        float      *dh = gr->h;


        sprintf(outname[0],"Mesh/%s.n",name);
        sprintf(outname[1],"Mesh/%s.e",name);
        sprintf(outname[2],"Mesh/%s.s",name);

        if ((fp[0] = fopen(outname[0],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[0]);
            clean_up(ERROR);
        }
        if ((fp[1] = fopen(outname[1],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[1]);
            clean_up(ERROR);
        }
        if ((fp[2] = fopen(outname[2],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[2]);
            clean_up(ERROR);
        }

        fscanf(fp[0],"%d\n",&n_node);
        matrix(&crds_node,n_node,dim,sizeof(float));
        printf("TRI n_node = %d\n", n_node);

        for(i = 0; i < n_node; i++)
        {
            stringptr = readline(inputline, fp[0], outname[0]);
            // printf("print read string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < dim; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Point %d is missing a coordinate in %s.\n",
                     i+1, outname[0]);
                   clean_up(ERROR);
                }
                crds_node[i][j] = (float) strtod(stringptr, &stringptr);
            }
            // printf("node[%d] crds %g %g\n", i+1, crds_node[i][0], crds_node[i][1]);
            // clean_up(0);
        }

        fscanf(fp[1],"%d\n",&n_tri);
        printf("TRI number = %d\n", n_tri);

        matrix(&tri_node,n_tri,3,sizeof(float));
        matrix(&neigh,n_tri,3,sizeof(float));

        for(i = 0; i < n_tri; i++)
        {
            stringptr = readline(inputline, fp[1], outname[1]);
            // printf("string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                tri_node[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // NEW, easy_mesh
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                neigh[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // printf("tri[%d] node[%d %d %d], neigh[%d %d %d]\n",
            //         i+1, tri_node[i][0], tri_node[i][1], tri_node[i][2], neigh[i][0], neigh[i][1], neigh[i][2]);
            // clean_up(0);
        }
        /**
        fscanf(fp[2],"%*d %*d\n");
        for(i = 0; i < n_tri; i++)
        {
            fscanf(fp[2],"%*d %d %d %d\n", &neigh[i][0], &neigh[i][1], &neigh[i][2]);
            // printf("tri[%d] neighbr[%d %d %d]\n", i+1, neigh[i][0], neigh[i][1], neigh[i][2]);
        }
        **/

        ////////////////////
        // make_tris
        ////////////////////
        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(fr->interf));
        set_copy_intfc_states(YES);

        if(NULL == (fr->mesh = copy_interface(fr->interf)))
        {
            printf("ERROR make_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(fr->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);

        s = i_make_surface(2,3,NULL,NULL);

        vector(&p, n_node,sizeof(POINT *));
        vector(&tri, n_tri, sizeof(TRI *));

        for(i = 0; i < n_node; i++)
        {
            coords[0] = crds_node[i][0];
            coords[1] = crds_node[i][1];
            coords[2] = 0.0;
            p[i] = Point(coords);
        }

        // triangle pt is COUNTER_CLOCK oriented.
        for(i = 0; i < n_tri; i++)
        {
            pt[0] = p[tri_node[i][0]];
            pt[1] = p[tri_node[i][1]];
            pt[2] = p[tri_node[i][2]];
#if defined(__MPI__)
            /////// DO NOT MAKE TRI IN OTHER SUBDOMAIN
            for(j = 0; j < 3; j++)
                tmpcent[j] = 0.33333333*(Coords(pt[0])[j] + Coords(pt[1])[j] + Coords(pt[2])[j]);
            if(tmpcent[0] < (gr->L[0]-2.5*dh[0]) ||
               tmpcent[0] > (gr->U[0]+2.5*dh[0]) ||
               tmpcent[1] < (gr->L[1]-2.5*dh[1]) ||
               tmpcent[1] > (gr->U[1]+2.5*dh[1]))
            {
                tri[i] = NULL;
                continue;
            }
#endif // if defined(__MPI__) //
            comput_normal3d(Coords(pt[0]), Coords(pt[1]), Coords(pt[2]), nor);
            if(nor[2] > 0.0)
            {
                tri[i] = i_make_tri(pt[0],pt[1],pt[2],
                                 NULL,NULL,NULL,YES);
                tri[i]->id = i;
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Lmass_matrix);
                // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                inverse_matrix(tri[i]->Lmass_matrix,MAX_N_COEF,tri[i]->mass_inv);
            }
            else
            {
               tri[i] = i_make_tri(pt[0],pt[2],pt[1],
                                 NULL,NULL,NULL,YES);
               printf("ERROR: CLOCK-wise tri created\n");
               clean_up(ERROR);
            }
            insert_tri_at_tail_of_list(tri[i],s);
            /**
            printf("print tri[%d] coords:\n", i);
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
            **/
        }
        s->num_tri = n_tri;

        // Set tri neighbr
        // The first neighbor of triangle i is opposite the first corner of triangle i, and so on.
        for(i = 0; i < n_tri; i++)
        {
            if(tri[i] == NULL) continue; /// NEW 022210

            set_01_bdry(Boundary_tri(tri[i]),NO);
            set_12_bdry(Boundary_tri(tri[i]),NO);
            set_20_bdry(Boundary_tri(tri[i]),NO);

            for(j = 0; j < 3; j++)
            {
                side = (j+1)%3;
                if(neigh[i][j] != -1 && tri[neigh[i][j]] != NULL) //// NEW 022210
                // if(neigh[i][j] != -1)
                {
                    // Tri_on_side(tri[i], side) = tri[neigh[i][j]-1];
                    Tri_on_side(tri[i], side) = tri[neigh[i][j]];
                    // if(tris_share_edge(tri[i], tri[neigh[i][j]-1]) == NO)
                    if(tris_share_edge(tri[i], tri[neigh[i][j]]) == NO)
                    {
                        printf("ERROR: tris do not share edge\n");
                        clean_up(ERROR);
                    }
                }
                else
                {
                    // Boundary_tri(tri[i]) = YES;
                    set_side_bdry(Boundary_tri(tri[i]),side,YES);
                }
                if(neigh[i][j] != -1 && tri[neigh[i][j]] == NULL) //// NEW 022210
                    Tri_on_side(tri[i], side) = NULL;
            }
#if defined(__MPI__)   ///// NEW 022210
            if(Tri_on_side(tri[i], 0) != NULL && Tri_on_side(tri[i], 1) != NULL &&
               Tri_on_side(tri[i], 2) != NULL)
                Boundary_tri(tri[i]) = NO;
#else //// if defined(__MPI__)
            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
#endif //// if defined(__MPI__)
/*** OLD 022210
            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
//// END OLD 022210
***/
        }

        free(crds_node);
        free(tri_node); 
        //// free(neigh);
        free(p);

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        // NEW
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

#if !defined(_MPI_)
        output_tri_mesh("visual",0,fr->mesh);
#endif // if !defined(_MPI_)

        fclose(fp[0]);
        fclose(fp[1]);
        fclose(fp[2]);

        *tri_num = n_tri;
        *out_neigh = neigh;

        // printf("EXIT in read_input_easy_mesh\n");
        // exit(0);
        return tri;
}

LOCAL TRI **read_input_easy_mesh_MHD(
        char    *name,
        Front   *fr,
        int     *tri_num,
	int     ***out_neigh)
{
        FILE    *fp[7];
        char    outname[7][256];
        int     n_node = 0, i, nodenumber, j, dim = 2;
        int     n_tri, **tri_node, **neigh;
        float   **crds_node, coords[3];
        char    inputline[1024];
        char    *stringptr;

        TRI        **tri, *tmptri;
        POINT      **p, *pt[4], *tmpp[3];
        INTERFACE  *cur_intfc;
        bool       sav_copy;
        SURFACE    *s;
        float      nor[3], tmpcent[3];
        int        side;
        RECT_GRID  *gr = fr->rect_grid;
        float      *dh = gr->h;


        sprintf(outname[0],"Mesh/%s.n",name);
        sprintf(outname[1],"Mesh/%s.e",name);
        sprintf(outname[2],"Mesh/%s.s",name);

        if ((fp[0] = fopen(outname[0],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[0]);
            clean_up(ERROR);
        }
        if ((fp[1] = fopen(outname[1],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[1]);
            clean_up(ERROR);
        }
        if ((fp[2] = fopen(outname[2],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[2]);
            clean_up(ERROR);
        }

        fscanf(fp[0],"%d\n",&n_node);
        matrix(&crds_node,n_node,dim,sizeof(float));
        printf("TRI n_node = %d\n", n_node);

        for(i = 0; i < n_node; i++)
        {
            stringptr = readline(inputline, fp[0], outname[0]);
            // printf("print read string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < dim; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Point %d is missing a coordinate in %s.\n",
                     i+1, outname[0]);
                   clean_up(ERROR);
                }
                crds_node[i][j] = (float) strtod(stringptr, &stringptr);
            }
            // printf("node[%d] crds %g %g\n", i+1, crds_node[i][0], crds_node[i][1]);
            // clean_up(0);
        }

        fscanf(fp[1],"%d\n",&n_tri);
        printf("TRI number = %d\n", n_tri);

        matrix(&tri_node,n_tri,3,sizeof(float));
        matrix(&neigh,n_tri,3,sizeof(float));

        for(i = 0; i < n_tri; i++)
        {
            stringptr = readline(inputline, fp[1], outname[1]);
            // printf("string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                tri_node[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // NEW, easy_mesh
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                neigh[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // printf("tri[%d] node[%d %d %d], neigh[%d %d %d]\n",
            //         i+1, tri_node[i][0], tri_node[i][1], tri_node[i][2], neigh[i][0], neigh[i][1], neigh[i][2]);
            // clean_up(0);
        }

        ////////////////////
        // make_tris
        ////////////////////
        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(fr->interf));
        set_copy_intfc_states(YES);

        if(NULL == (fr->mesh = copy_interface(fr->interf)))
        {
            printf("ERROR make_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(fr->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);

        s = i_make_surface(2,3,NULL,NULL);

        vector(&p, n_node,sizeof(POINT *));
        vector(&tri, n_tri, sizeof(TRI *));

        for(i = 0; i < n_node; i++)
        {
            coords[0] = crds_node[i][0];
            coords[1] = crds_node[i][1];
            coords[2] = 0.0;
            p[i] = Point(coords);
        }

        // triangle pt is COUNTER_CLOCK oriented.
        for(i = 0; i < n_tri; i++)
        {
            pt[0] = p[tri_node[i][0]];
            pt[1] = p[tri_node[i][1]];
            pt[2] = p[tri_node[i][2]];
#if defined(__MPI__)
            /////// DO NOT MAKE TRI IN OTHER SUBDOMAIN
            for(j = 0; j < 3; j++)
                tmpcent[j] = 0.33333333*(Coords(pt[0])[j] + Coords(pt[1])[j] + Coords(pt[2])[j]);
            if(tmpcent[0] < (gr->L[0]-7.5*dh[0]) ||
               tmpcent[0] > (gr->U[0]+7.5*dh[0]) ||
               tmpcent[1] < (gr->L[1]-7.5*dh[1]) ||
               tmpcent[1] > (gr->U[1]+7.5*dh[1]))
            {
                tri[i] = NULL;
                continue;
            }
#endif // if defined(__MPI__) //
            comput_normal3d(Coords(pt[0]), Coords(pt[1]), Coords(pt[2]), nor);
            if(nor[2] > 0.0)
            {
                tri[i] = i_make_tri(pt[0],pt[1],pt[2],
                                 NULL,NULL,NULL,YES);
                tri[i]->id = i;
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Lmass_matrix);
                // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                inverse_matrix(tri[i]->Lmass_matrix,MAX_N_COEF,tri[i]->mass_inv);

                comp_Mag_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Bmass_matrix);
                inverse_matrix(tri[i]->Bmass_matrix,MAX_N_COEF,tri[i]->Bmass_inv);
            }
            else
            {
               tri[i] = i_make_tri(pt[0],pt[2],pt[1],
                                 NULL,NULL,NULL,YES);
               printf("ERROR: CLOCK-wise tri created\n");
               clean_up(ERROR);
            }
            insert_tri_at_tail_of_list(tri[i],s);
        }
        s->num_tri = n_tri;

        // Set tri neighbr
        // The first neighbor of triangle i is opposite the first corner of triangle i, and so on.
        for(i = 0; i < n_tri; i++)
        {
            if(tri[i] == NULL) continue; /// NEW 022210

            set_01_bdry(Boundary_tri(tri[i]),NO);
            set_12_bdry(Boundary_tri(tri[i]),NO);
            set_20_bdry(Boundary_tri(tri[i]),NO);

            for(j = 0; j < 3; j++)
            {
                side = (j+1)%3;
                if(neigh[i][j] != -1 && tri[neigh[i][j]] != NULL) //// NEW 022210
                // if(neigh[i][j] != -1)
                {
                    // Tri_on_side(tri[i], side) = tri[neigh[i][j]-1];
                    Tri_on_side(tri[i], side) = tri[neigh[i][j]];
                    // if(tris_share_edge(tri[i], tri[neigh[i][j]-1]) == NO)
                    if(tris_share_edge(tri[i], tri[neigh[i][j]]) == NO)
                    {
                        printf("ERROR: tris do not share edge\n");
                        clean_up(ERROR);
                    }
                }
                else
                {
                    // Boundary_tri(tri[i]) = YES;
                    set_side_bdry(Boundary_tri(tri[i]),side,YES);
                }
                if(neigh[i][j] != -1 && tri[neigh[i][j]] == NULL) //// NEW 022210
                    Tri_on_side(tri[i], side) = NULL;
            }
#if defined(__MPI__)   ///// NEW 022210
            if(Tri_on_side(tri[i], 0) != NULL && Tri_on_side(tri[i], 1) != NULL &&
               Tri_on_side(tri[i], 2) != NULL)
                Boundary_tri(tri[i]) = NO;
#else //// if defined(__MPI__)
            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
#endif //// if defined(__MPI__)
/*** OLD 022210
            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
//// END OLD 022210
***/
        }

        free(crds_node);
        free(tri_node); 
        //// free(neigh);
        free(p);

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        // NEW
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

#if !defined(_MPI_)
        output_tri_mesh("visual",0,fr->mesh);
#endif // if !defined(_MPI_)

        fclose(fp[0]);
        fclose(fp[1]);
        fclose(fp[2]);

        *tri_num = n_tri;
        *out_neigh = neigh;

        // printf("EXIT in read_input_easy_mesh\n");
        // exit(0);
        return tri;
}


LOCAL void comput_normal3d(
	float *p0,
        float *p1,
        float *p2,
        float *n)
{
        float s[3][3], ns;
        int   i;

        for(i = 0; i < 3; i++)
        {
            s[0][i] = p1[i] - p0[i];
            s[1][i] = p2[i] - p1[i];
            s[2][i] = p0[i] - p2[i]; 
        }

        n[0] = s[2][1]*s[0][2] - s[2][2]*s[0][1];
        n[1] = s[2][2]*s[0][0] - s[2][0]*s[0][2];
        n[2] = s[2][0]*s[0][1] - s[2][1]*s[0][0];
}

EXPORT void init_Mach_step_mesh(
        char  *name,
        Front *fr)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2, **neigh, on_BC[3];
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD], *cent;
        int     debug_flag = NO;

        tri = read_input_easy_mesh(name, fr, &n_tri, &neigh);

        for(i = 0; i < n_tri; i++)
        {
#if defined(__MPI__)
            if(tri[i] == NULL) continue;
#endif //// if defined(__MPI__)

            if(Boundary_tri(tri[i]))
            {
#if defined(__MPI__)
                /////// NEW 022210
                if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
                {
                    tri[i]->BC_type = SUBDOMAIN;
                    continue;
                }
                /////// END NEW 022210
#endif //// if defined(__MPI__)
                for(side = 0; side < 3; side++)
                {
#if defined(__MPI__)
                    if((on_BC[side] = tri_side_on_domain_boundary(tri[i],side,fr->rect_grid))
                        == NO
                      )
                    {
                        continue;
                    }
#endif //// if defined(__MPI__)
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        cent = fg_centroid(tri[i]);
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side
                            fg_e_type(tri[i])[side] = NEUMANN;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = NEUMANN;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            if(cent[1] > 1.0)
                            {
                                fg_e_type(tri[i])[side] = OUT_FLOW;
                            }
                            else // at the step
                            {
                                fg_e_type(tri[i])[side] = NEUMANN;
                            }
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                } /// END for(side = 0; side < 3; side++)
#if defined(__MPI__)
                /////// NEW 022210
                if(on_BC[0] == NO && on_BC[1] == NO && on_BC[2] == NO)
                    tri[i]->BC_type = SUBDOMAIN;
                /////// END NEW 022210
#endif ///// if defined(__MPI__)
            }
        }

        free(tri);
        free(neigh);
}

EXPORT void  init_blast_MHD_mesh(
        char  *name,    
        Front *fr)      
{                   
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2, **neigh = NULL, on_BC[3];
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        tri = read_input_easy_mesh_MHD(name, fr, &n_tri, &neigh);
        // tri = init_diag_triangle_vortex_evo(fr, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
#if defined(__MPI__)
            if(tri[i] == NULL) continue;
#endif //// if defined(__MPI__)
            
            if(tri_out_rect(tri[i], fr->rect_grid->GL, fr->rect_grid->GU) == YES)
            {
                tri[i]->BC_type = SUBDOMAIN;  
                continue;
            }

            for(side = 0; side < 3; side++)
            {
                if((on_BC[side] = tri_side_on_domain_boundary(tri[i],side,fr->rect_grid))
                    == NO)
                {
                    continue;
                }

                // for(j = 0; j < dim; j++)
                //     t[j] = fg_side_vector(tri[i])[side][j];
                // nor[0] = t[1];
                // nor[1] = -t[0];

                // ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                tri[i]->BC_type = OUT_FLOW; 
                fg_e_type(tri[i])[side] = OUT_FLOW;
            }
        }

        free(tri);

        if(neigh != NULL) 
            free(neigh);
}

EXPORT void  init_db_Mach_mesh(
	char  *name,
        Front *fr)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2, **neigh, on_BC[3];
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        tri = read_input_easy_mesh(name, fr, &n_tri, &neigh);
	// tri = read_input_mesh(name, fr, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
#if defined(__MPI__)
            if(tri[i] == NULL) continue;
#endif //// if defined(__MPI__)
            if(Boundary_tri(tri[i]))
            {
#if defined(__MPI__)
                /////// NEW 022210
                if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
                {
                    tri[i]->BC_type = SUBDOMAIN;
                    continue;
                }
                /////// END NEW 022210
#endif //// if defined(__MPI__)
                for(side = 0; side < 3; side++)
                {
#if defined(__MPI__)
                    if((on_BC[side] = tri_side_on_domain_boundary(tri[i],side,fr->rect_grid))
                        == NO)
                    {
                        continue;
                    }
#endif //// if defined(__MPI__)
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];                        

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        
                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side 
                            p[0] = Point_of_tri(tri[i])[side];
                            p[1] = Point_of_tri(tri[i])[(side+1)%3];
                            crds[1] = (Coords(p[0])[1] + Coords(p[1])[1])/2.0;
                            if(crds[1] > 0.16666666666667)
                                fg_e_type(tri[i])[side] = NEUMANN;
                            else
                                fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = IN_FLOW; // need

                            if(debug_flag == YES)
                            {
                                printf("tri[%d] side [%d], edge type = %d\n",
                                      i, side, CONST_P);
                            }
                        }
                    }
                } /// END for(side = 0; side < 3; side++)
#if defined(__MPI__)
                /////// NEW 022210
                if(on_BC[0] == NO && on_BC[1] == NO && on_BC[2] == NO)
                    tri[i]->BC_type = SUBDOMAIN;
                /////// END NEW 022210
#endif ///// if defined(__MPI__)
            }
        }

        free(tri);
        free(neigh);
}

EXPORT void  init_shock_vort_mesh(
	char  *name,
        Front *fr)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2;
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

	tri = read_input_mesh(name, fr, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
            if(Boundary_tri(tri[i]))
            {
                for(side = 0; side < 3; side++)
                {
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];                        

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        
                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side 
                            // fg_e_type(tri[i])[side] = NEUMANN;
                            // tri[i]->BC_type = OUT_FLOW; // No need since the buffer will be attached
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            // fg_e_type(tri[i])[side] = NEUMANN;
                            // tri[i]->BC_type = IN_FLOW; // No need since the buffer will be attached
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                }
            }
        }

        free(tri);
}

EXPORT POLYGON **init_dual_cell(
	Front           *front,
        TRI             **tris,
        int             tri_num)
{
        RECT_GRID   *gr = front->rect_grid; 
        INTERFACE           *intfc = front->interf;
        SURFACE             *s, **surf;
        float               *L = gr->L;
        float               *U = gr->U; 
        int                 i, j, k, iy, ix, vtri_N = 0, closed;
        TRI                 *tmptri, *tri, *vert_tris[50], *iso_tri1, *iso_tri2;
        POINT               **p, *pt[30], *pt1, *pt2, **p_on_bdry;
        POINT               *poly1_vt1, *poly1_vt2, *poly2_vt1, *poly2_vt2;
        int                 imax, jmax, ip1, ip2, ip3, side, vt_count = 0, edge_pt_N = 0;
        double              coords[3] = {0.0, 0.0, 0.0};
        ANGLE_DIRECTION     orient;
        INTERFACE           *cur_intfc;
        bool                sav_copy, found;
        double              *cent, tol = 5.0e-11;
        POLYGON             *polyg, *polyg2;
        P_LINK              *hash_table;
        int                 h_size = 0, tri_id = 0, poly1_side, poly2_side, N_null_sides;
        int                 is_vert_dual_cent[50], null_side, share_side;
        TRI                 *vert_at_tri[50];
        int                 sav_alloc_mass_storage_flag, debug = NO;

        DEBUG_ENTER(init_dual_cell)

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        set_current_interface(front->mesh);

        sav_alloc_mass_storage_flag = alloc_mass_storage_flag();

        set_alloc_mass_storage_flag(YES);

        // printf("Entered init_dual_cell()\n");

        for(surf = front->mesh->surfaces;
               surf && *surf; surf++)
        {
            for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf); 
                 tri = tri->next)
            {
                for (k = 0; k < 3; ++k)
                    Index_of_point(Point_of_tri(tri)[k]) = NO;
                h_size += 3;
                tri->id = tri_id;
                tri_id++;
            }
        }
        printf("\n\n ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
        printf("In init_dual_cell(), size of hash_table = %d\n", h_size);

        h_size += 50000;

        vector(&hash_table,h_size,sizeof(P_LINK));
        reset_hash_table(hash_table,h_size);

        vector(&p,h_size,sizeof(POINT*));
        zero_scalar(p,h_size*sizeof(POINT*));
        vector(&p_on_bdry,h_size,sizeof(POINT*));

        // printf("before create polygon\n");
        
        for(surf = front->mesh->surfaces; surf && *surf; surf++)
        {
            (*surf)->num_polyg = 0;

            for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf); 
                 tri = tri->next)
            {
                 for(k = 0; k < 3; k++)
                 {
                     if(Index_of_point(Point_of_tri(tri)[k]) == YES)
                         continue;

                     ///// Start to construct dual-cell with centroid Point_of_tri(tri)[k]
                     Index_of_point(Point_of_tri(tri)[k]) = YES;

                     closed = collect_vtris_counterclock(tri, Point_of_tri(tri)[k], 
                                     vert_tris, &vtri_N);

                     ///// TMP
                     /**
                     if(fabs(Coords(Point_of_tri(tri)[k])[0] + 0.075) < 1.0e-8 && 
                        fabs(Coords(Point_of_tri(tri)[k])[1] + 0.575) < 1.0e-8)
                     {
                         debug = YES;
                         printf("construct dual cell at (%g, %g), number of tris %d, closed %d\n",
                             Coords(Point_of_tri(tri)[k])[0], Coords(Point_of_tri(tri)[k])[1], vtri_N, closed);
                         for(side =0; side < vtri_N; side++)
                             print_tri_crds(vert_tris[side]);
                     }
                     else
                         debug = NO; 
                     **/
                     ///// END:::: TMP

                     /***
                     ///// TMP
                     if(vtri_N == 1)
                     {
                         printf("deal with corner tri k = %d\n", k);
                         print_tri_coords(vert_tris[0]);
                     }
                     ***/

                     // printf("collect_vtris_counterclock(), vtri_N = %d\n", vtri_N);
                     vt_count = 0;
                     if(NO == closed)
                     {   /// find starting vertex point of dual cell
                         iso_tri1 = vert_tris[0];
                         iso_tri2 = vert_tris[vtri_N-1];
                         N_null_sides = 0;
                         for(side = 0; side < 3; side++)
                         {
                            if(NULL == Tri_on_side(iso_tri1,side))
                                N_null_sides++;
                         }

                         /// identify the starting vertex of dual cell 
                         if(iso_tri1 == iso_tri2)
                         {
                             for(side = 0; side < 3; side++)
                             {
                                if(NULL != Tri_on_side(iso_tri1,side))
                                    break;
                             }
                             /// midpoint on the previous edge of the shared side.
                             pt1 = Point_of_tri(iso_tri1)[(side+2)%3];
                             pt2 = Point_of_tri(iso_tri1)[side];
                         }
                         else if(1 == N_null_sides)
                         {
                             for(side = 0; side < 3; side++)
                             {
                                if(NULL == Tri_on_side(iso_tri1,side))
                                    break;
                             }
                             pt1 = Point_of_tri(iso_tri1)[side];
                             pt2 = Point_of_tri(iso_tri1)[(side+1)%3];
                         }
                         else if(2 == N_null_sides)
                         {
                             for(share_side = 0; share_side < 3; share_side++)
                             {
                                if(NULL != Tri_on_side(iso_tri1,share_side))
                                    break;
                             }

                             for(side = 0; side < 3; side++)
                             {
                                if(Point_of_tri(tri)[k] == 
                                   Point_of_tri(iso_tri1)[(share_side+side)%3])
                                    break;
                             }
                             if(1 == side)
                             {   /// vertex is on the next edge of the shared one.
                                 pt1 = Point_of_tri(iso_tri1)[(share_side+1)%3];
                                 pt2 = Point_of_tri(iso_tri1)[(share_side+2)%3];
                             }
                             else
                             {
                                 printf("ERROR: init_dual_cell()\n");
                                 printf("implement case for starting vertex\n");
                                 printf("share_side = %d, side = %d\n",
                                      share_side, side);
                                 clean_up(ERROR);
                             }
                         }
                         coords[0] = 0.5*(Coords(pt1)[0] + Coords(pt2)[0]); 
                         coords[1] = 0.5*(Coords(pt1)[1] + Coords(pt2)[1]); 

                         is_vert_dual_cent[vt_count] = NO;
                         vert_at_tri[vt_count] = iso_tri1;

                         /// find vertex point
                         found = NO;
                         for(j = 0; j < edge_pt_N; j++)
                         {
                             if(fabs(coords[0] - Coords(p_on_bdry[j])[0]) < tol &&
                                fabs(coords[1] - Coords(p_on_bdry[j])[1]) < tol)
                             {
                                 found = YES;
                                 break;
                             }
                         }
                         if(NO == found)
                         {
                             pt[vt_count] = Point(coords);  
                             p_on_bdry[edge_pt_N] = pt[vt_count];
                             edge_pt_N++;
                         }
                         else
                         {
                             pt[vt_count] = p_on_bdry[j];
                         }
                         vt_count++;  
                     } /// END::: if(NO == closed)

                     // if(1 == vtri_N) 
                     // {
                         // clean_up(ERROR);
                         // continue;
                     // }

                     // for(i = 0; i < vtri_N; i++)
                     //      printf("tri-id[%d]\n", vert_tris[i]->id);  
                     // clean_up(0);

                     for(i = 0; i < vtri_N; i++)
                     {
                         cent = fg_centroid(vert_tris[i]);

                         if(NULL == p[vert_tris[i]->id])
                         {
                             pt[vt_count] = Point(cent);  
                             p[vert_tris[i]->id] = pt[vt_count];
                         }
                         else
                             pt[vt_count] = p[vert_tris[i]->id];

                         is_vert_dual_cent[vt_count] = YES;
                         vert_at_tri[vt_count] = vert_tris[i];

                         vt_count++;
                     }

                     if(NO == closed)
                     { /// find end vertex point of dual cell.
                         iso_tri1 = vert_tris[0];
                         iso_tri2 = vert_tris[vtri_N-1];
                         N_null_sides = 0;
                         for(side = 0; side < 3; side++)
                         {
                            if(NULL == Tri_on_side(iso_tri2,side))
                                N_null_sides++;
                         }
                         /// identify the end vertex of dual cell
                         if(iso_tri1 == iso_tri2)
                         {
                             for(side = 0; side < 3; side++)
                             {
                                if(NULL != Tri_on_side(iso_tri2,side))
                                    break;
                             }
                             /// midpoint on the next edge of the shared side.
                             pt1 = Point_of_tri(iso_tri2)[(side+1)%3];
                             pt2 = Point_of_tri(iso_tri2)[(side+2)%3];
                         }
                         else if(1 == N_null_sides)
                         {
                             for(side = 0; side < 3; side++)
                             {
                                if(NULL == Tri_on_side(iso_tri2,side))
                                    break;
                             }
                             pt1 = Point_of_tri(iso_tri2)[side];
                             pt2 = Point_of_tri(iso_tri2)[(side+1)%3];
                         }
                         else if(2 == N_null_sides)
                         {
                             for(share_side = 0; share_side < 3; share_side++)
                             {
                                if(NULL != Tri_on_side(iso_tri2,share_side))
                                    break;
                             }
                             for(side = 0; side < 3; side++)
                             {
                                if(Point_of_tri(tri)[k] == 
                                   Point_of_tri(iso_tri2)[(share_side+side)%3])
                                    break;
                             }
                             if(side == 0)
                             {
                                 pt1 = Point_of_tri(iso_tri2)[(share_side+2)%3];
                                 pt2 = Point_of_tri(iso_tri2)[share_side];
                             }
                             else
                             {
                                 printf("ERROR: init_dual_cell()\n");
                                 printf("implement case for end vertex\n");
                                 printf("share_side = %d, side = %d\n",
                                      share_side, side);
                                 print_tri_coords(iso_tri2);
                                 clean_up(ERROR);
                             }
                         }
                         coords[0] = 0.5*(Coords(pt1)[0] + Coords(pt2)[0]);
                         coords[1] = 0.5*(Coords(pt1)[1] + Coords(pt2)[1]);

                         is_vert_dual_cent[vt_count] = NO;
                         vert_at_tri[vt_count] = iso_tri2;
                         /// find vertex point
                         found = NO;
                         for(j = 0; j < edge_pt_N; j++)
                         {
                             if(fabs(coords[0] - Coords(p_on_bdry[j])[0]) < tol &&
                                fabs(coords[1] - Coords(p_on_bdry[j])[1]) < tol)
                             {
                                 found = YES;
                                 break;
                             }
                         }
                         if(NO == found)
                         {
                             pt[vt_count] = Point(coords);
                             p_on_bdry[edge_pt_N] = pt[vt_count];
                             edge_pt_N++;
                         }
                         else
                         {
                             pt[vt_count] = p_on_bdry[j];
                         }
                         vt_count++;
                     } //// END::: if(NO == closed) // for end vertex of dual cell
  
                     if(YES == debug)
                         printf("Before i_make_polygon()\n");

                     polyg = i_make_polygon(pt, vt_count, 
                               Coords(Point_of_tri(tri)[k]), closed);

                     // printf("comp_C0, vt_count = %d, closed = %d\n", vt_count, closed);

                     if(YES == closed && polyg->conformal_basis_tri != NULL)
                         comp_C0_conformal_basis_polygon(polyg);

                     install_dual_cell_to_tris(Point_of_tri(tri)[k],vert_tris,vtri_N,polyg);

                     for(i = 0; i < vt_count; i++)
                     {
                         tri_at_polyg_vert(polyg)[i] = vert_at_tri[i]; 
                         is_vert_dual_cent(polyg)[i] = is_vert_dual_cent[i];
                     }

                     // printf("Before insert_polygon_at_tail_of_list()\n");
                     insert_polygon_at_tail_of_list(polyg,*surf);
                     // printf("after insert_polygon_at_tail_of_list()\n");

                     (void) add_to_hash_table((POINTER)Point_of_tri(tri)[k], 
                                   (POINTER)polyg,hash_table,h_size);
                 }
            }
        }

        /// TMP
        /***
        for(surf = front->mesh->surfaces; surf && *surf; surf++)
        {         
            for (polyg = first_polyg(*surf); !at_end_of_polyg_list(polyg,*surf); 
                 polyg = polyg->next)
            {  
                // print_general_vector("polygon cent", polyg_centroid(polyg), 3, "\n");
                if(polyg->n_sides != 3) continue;
                for(side = 0; side < polyg->n_sides; side++)
                {
                    pt1 = Point_of_polyg(polyg)[side];
                    printf("vert[%d]  %g  %g\n", side, Coords(pt1)[0], Coords(pt1)[1]);
                }
                // break;
            }
        }
        ***/

        i = 0;
        for(surf = front->mesh->surfaces; surf && *surf;  surf++)
        {
            for (polyg = first_polyg(*surf);
                !at_end_of_polyg_list(polyg,*surf); polyg = polyg->next)
            {
                polyg->id = i;
                i++;
                /***
                if(polyg->id == 393)
                {
                    printf("found dual cell %d in setting up indx\n", polyg->id);
                    print_polyg_crds(polyg);
                }
                ***/
            }
        }

        printf("\n\ninit_dual_cell(), created total %d dual cells\n\n", i);
 
        ////// Now set polygon adjacent topology
        for(surf = front->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                 for(side = 0; side < 3; side++)
                 {
                     pt1 = Point_of_tri(tri)[side];
                     pt2 = Point_of_tri(tri)[(side+1)%3];
                     polyg = (POLYGON*)find_from_hash_table((POINTER)pt1,hash_table,h_size);
                     polyg2 = (POLYGON*)find_from_hash_table((POINTER)pt2,hash_table,h_size);

                     /***
                     if(polyg != NULL && polyg->id == 393)
                     {
                         printf("init_dual_cell, found dual cell %d\n", polyg->id);
                     }
                     if(polyg2 != NULL && polyg2->id == 393)
                     {
                         printf("init_dual_cell, (2)found dual cell %d\n", polyg2->id);
                     }
                     ***/
                   
                     if(NULL == polyg || NULL == polyg2)
                     {
                         // printf("ERROR: init_dual_cell(), should be pairwise polygon\n");
                         // printf("polygon1 = %d, polygon2 = %d\n", polyg, polyg2); 
                         // print_general_vector("coords",Coords(pt1), 2, "\n");
                         // print_general_vector("coords",Coords(pt2), 2, "\n");
                         continue;
                     }
                     /// pair up common edges of polyg and polyg2
                     for(poly1_side = 0; poly1_side < polyg->n_sides; poly1_side++)
                     {
                         poly1_vt1 = Point_of_polyg(polyg)[poly1_side];
                         poly1_vt2 = Point_of_polyg(polyg)[(poly1_side+1)%polyg->n_sides];

                         found = NO;
                         for(poly2_side = 0; poly2_side < polyg2->n_sides; poly2_side++)
                         {
                             poly2_vt1 = Point_of_polyg(polyg2)[poly2_side];
                             poly2_vt2 = Point_of_polyg(polyg2)[(poly2_side+1)%polyg2->n_sides];

                             if(poly1_vt1 == poly2_vt2 && poly1_vt2 == poly2_vt1)
                             {
                                 Polyg_on_side(polyg,poly1_side) = polyg2;
                                 Polyg_on_side(polyg2, poly2_side) = polyg;
                                 found = YES;
                                 break;
                             }
                         }

                         if(YES == found)
                             break;
                     }
  
                     if(NO == found)
                     {
                         // printf("ERROR: init_dual_cell(),"
                         //   " polygons do not share edge, tri side = %d\n", side);
                         // print_tri_coords(tri);
                         // print_general_vector("coords",Coords(pt1), 2, "\n");
                         // print_general_vector("coords",Coords(pt2), 2, "\n");
                         // clean_up(ERROR);
                         continue;
                     }

                     ///// TMP--- debug
                     /***
                     if(YES == found)
                     {
                         if(polyg->id == 393)
                         {
                             printf("dual cell[%d] side[%d] neighbor = %d\n",
                                    polyg->id, poly1_side, polyg2->id);
                             // gview_output_polygon("visual", 0, polyg, "polygon1");
                             // gview_output_polygon("visual", 0, polyg2, "polygon2");
                         }    
                     }
                     ***/
                     ///// END:::: TMP--- debug
                 } /// END::: for(side = 0; side < 3; side++)
            }
        }

        free(p); free(p_on_bdry); free(hash_table);

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);
        set_alloc_mass_storage_flag(sav_alloc_mass_storage_flag);

        // printf("WARNING: exit at init_dual_cell()\n");
        // clean_up(0);
#if !defined(_MPI_) 
        gview_output_polygon_mesh("visual",0,front->mesh);
#endif // if !defined(_MPI_)

        DEBUG_LEAVE(init_dual_cell)

        return NULL;
}

//                  
//        dual cell     
//  __      /|\     __ (verti+1) // for R portion of intersections      
//    __  /  |  \ __    
//      /__L | R__\     
//    /    __|__    \       
//  /   tri (verti)   \ 
//                      
// dual_tri_mass_matrix:  // matrix for nodal basis on dual multiplied by 
                          // locally divergence-free basis on tri   
                          // [vertex ID][(R subregion = 0)/(L subregion = 1)]
                          // [index of basis function on dual cell][index of DG basis function on tri]
                          // NOTE: the last two dimensions of matrix can be viewed as the 
                          // integral of tensor product of these basis functions over either R/L subregion.

EXPORT void compute_dual_tri_basis_DG_P1(
        Front       *fr)
{
        SURFACE     **surf = fr->mesh->surfaces;
        TRI         *tri;
        int         side, N_sides, trii, verti, k;
        POLYGON     *polygs[3];
        POINT       **pts, **tmppts;
        double      area;
        double      tri_e_s[2], tri_e_e[2];
        double      pol_e_s[2], pol_e_e[2];
        double      crs[3], *t_cent, sqrt_area;
        bool        crs_flag;
        long double det;
        double      tmp_int[10], nodal_Bx[3], nodal_By[3], int_xval, int_yval;
        double      int_x2val, int_y2val, int_xyval;
        double      ****dual_tri_mass_matrix;
        double      int_x4val, int_x3val, int_x2yval, int_xy2val, int_y3val, int_y4val, tmp1, tmp2, tmp3;
        double      polyg_sqrt_area, **piece_cent, area_prod;
    
        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf);
                 tri = tri->next)
            {
                for(side = 0; side < 3; side++)
                    polygs[side] = fg_polyg_at_tri_vert(tri)[side];

                /*** 01/26/2016 **/
                if(debugging("field_loop"))
                {
                    if(polygs[0] == NULL || polygs[1] == NULL || polygs[2] == NULL)
                        continue;
                }
                else
                {
                    if(tri->BC_type == SUBDOMAIN)
                        continue;
                }
                /***END: 01/26/2016 **/

                /*** 01/26/2016
                if(tri->BC_type == SUBDOMAIN)
                    continue;
                ***/

                t_cent = fg_centroid(tri);
                dual_tri_mass_matrix = tri->dual_tri_mass_matrix;
                sqrt_area = sqrt(fg_area(tri));

                // for(side = 0; side < 3; side++)
                //     polygs[side] = fg_polyg_at_tri_vert(tri)[side];

                for(side = 0; side < 3; side++) // side of triangle
                {
                    pts = Point_of_polyg(polygs[side]);
                    N_sides = polygs[side]->n_sides;

                    //  get tri edge for interection with polygon edge 
                    /// between nodes verti and (verti+1)
                    for(trii = 0; trii < 3; trii++)
                    {
                        if(YES== same_point2d(polyg_centroid(polygs[side]),
                                      Coords(Point_of_tri(tri)[trii]),
                                      0.1*fg_length_side(tri)[0] ) )
                        {
                            tri_e_e[0] = Coords(Point_of_tri(tri)[trii])[0];
                            tri_e_e[1] = Coords(Point_of_tri(tri)[trii])[1];

                            tri_e_s[0] = Coords(Point_of_tri(tri)[(trii+2)%3])[0];
                            tri_e_s[1] = Coords(Point_of_tri(tri)[(trii+2)%3])[1];
                            break;
                        }
                    }

                    for(verti = 0; verti < N_sides; verti++)
                    {
                        if(YES == same_point2d(Coords(pts[verti]),
                                      t_cent, 0.1*fg_length_side(tri)[0]) )
                        {
                            pol_e_s[0] = Coords(pts[verti])[0];
                            pol_e_s[1] = Coords(pts[verti])[1];

                            pol_e_e[0] = Coords(pts[(verti+1)%N_sides])[0];
                            pol_e_e[1] = Coords(pts[(verti+1)%N_sides])[1];
                            break;
                        }
                    }

                    // integrate out Bx, By from the right portion (R) of the region where tri overlaps 
                    // with current opolyg[side];
                    crs_flag = cross_segments(tri_e_s[0], tri_e_s[1], tri_e_e[0], tri_e_e[1],
                                   pol_e_s[0], pol_e_s[1], pol_e_e[0], pol_e_e[1], crs);
                    if(NO == crs_flag)
                    {
                        printf("ERROR: compute_dual_tri_basis_DG_P1()\n");
                        printf("tri edge and polygon edge do not cross 1\n");
                        clean_up(ERROR);
                    }

                    det = (long double)((tri_e_e[0]-crs[0])*(pol_e_s[1]-crs[1]) -
                                        (pol_e_s[0]-crs[0])*(tri_e_e[1]-crs[1]));
                    area = 0.5*det;

                    polyg_sqrt_area = polygs[side]->_piece_sqrt_area[verti];
                    piece_cent = polygs[side]->_piece_cent;

                    if(3 == MAX_N_COEF)
                    {
                        int_xval = (double)int_x(crs,tri_e_e,pol_e_s,det);
                        int_yval = (double)int_y(crs,tri_e_e,pol_e_s,det);
                        int_x2val = (double)int_x2(crs,tri_e_e,pol_e_s,det);
                        int_y2val = (double)int_y2(crs,tri_e_e,pol_e_s,det);
                        int_xyval = (double)int_xy(crs,tri_e_e,pol_e_s,det);
                        area_prod = sqrt_area*polyg_sqrt_area;

                        dual_tri_mass_matrix[trii][0][0][0] = area;
                        dual_tri_mass_matrix[trii][0][1][0] = (int_xval - piece_cent[verti][0]*area)/polyg_sqrt_area;
                        dual_tri_mass_matrix[trii][0][2][0] = (int_yval - piece_cent[verti][1]*area)/polyg_sqrt_area;

                        dual_tri_mass_matrix[trii][0][0][1] = (int_xval - t_cent[0]*area)/sqrt_area;
                        dual_tri_mass_matrix[trii][0][1][1] = (int_x2val - int_xval*(piece_cent[verti][0]+t_cent[0]))/area_prod + 
                                                              piece_cent[verti][0]*t_cent[0]*area/area_prod;
                        dual_tri_mass_matrix[trii][0][2][1] = int_xyval/area_prod - 
                                                          (int_yval*t_cent[0] + int_xval*piece_cent[verti][1])/area_prod +
                                                           piece_cent[verti][1]*t_cent[0]*area/area_prod;

                        dual_tri_mass_matrix[trii][0][0][2] = (int_yval - t_cent[1]*area)/sqrt_area;
                        dual_tri_mass_matrix[trii][0][1][2] = int_xyval/area_prod - 
                                                           (int_xval*t_cent[1]+int_yval*piece_cent[verti][0])/area_prod + 
                                                           piece_cent[verti][0]*t_cent[1]*area/area_prod;
                        dual_tri_mass_matrix[trii][0][2][2] = (int_y2val - int_yval*(piece_cent[verti][1]+t_cent[1]))/area_prod +
                                                              piece_cent[verti][1]*t_cent[1]*area/area_prod;
                    }
                    else /// END::: if(3 == MAX_N_COEF) on R side
                    {
                        printf("ERROR: compute_dual_tri_basis_DG_P1()\n");
                        printf("Implement MAX_N_COEF = %d on R side\n", MAX_N_COEF);
                        clean_up(ERROR);
                    }

                    /// get tri edge for interection (L portion) with polygon edge 
                    ///   between nodes (verti-1) and (verti)
                    tri_e_s[0] = Coords(Point_of_tri(tri)[trii])[0];
                    tri_e_s[1] = Coords(Point_of_tri(tri)[trii])[1];

                    tri_e_e[0] = Coords(Point_of_tri(tri)[(trii+1)%3])[0];
                    tri_e_e[1] = Coords(Point_of_tri(tri)[(trii+1)%3])[1];

                    verti = (verti+N_sides-1)%N_sides;

                    pol_e_s[0] = Coords(pts[verti])[0];
                    pol_e_s[1] = Coords(pts[verti])[1];

                    pol_e_e[0] = Coords(pts[(verti+1)%N_sides])[0];
                    pol_e_e[1] = Coords(pts[(verti+1)%N_sides])[1];

                    crs_flag = cross_segments(tri_e_s[0], tri_e_s[1], tri_e_e[0], tri_e_e[1],
                                   pol_e_s[0], pol_e_s[1], pol_e_e[0], pol_e_e[1], crs);

                    if(NO == crs_flag)
                    {
                        printf("ERROR: compute_dual_tri_basis_DG_P1()\n");
                        printf("tri edge and polygon edge do not cross 2\n");
                        clean_up(ERROR);
                    }
                    det = (long double)((pol_e_e[0]-crs[0])*(tri_e_s[1]-crs[1]) -
                                        (tri_e_s[0]-crs[0])*(pol_e_e[1]-crs[1]));
                    area = 0.5*det;

                    polyg_sqrt_area = polygs[side]->_piece_sqrt_area[verti];

                    if(3 == MAX_N_COEF)
                    {
                        int_xval = int_x(crs,pol_e_e,tri_e_s,det);
                        int_yval = int_y(crs,pol_e_e,tri_e_s,det);
                        int_x2val = int_x2(crs,pol_e_e,tri_e_s,det);
                        int_y2val = int_y2(crs,pol_e_e,tri_e_s,det);
                        int_xyval = int_xy(crs,pol_e_e,tri_e_s,det);
                        area_prod = sqrt_area*polyg_sqrt_area;

                        dual_tri_mass_matrix[trii][1][0][0] = area;
                        dual_tri_mass_matrix[trii][1][1][0] = (int_xval - piece_cent[verti][0]*area)/polyg_sqrt_area;
                        dual_tri_mass_matrix[trii][1][2][0] = (int_yval - piece_cent[verti][1]*area)/polyg_sqrt_area;

                        dual_tri_mass_matrix[trii][1][0][1] = (int_xval - t_cent[0]*area)/sqrt_area;
                        dual_tri_mass_matrix[trii][1][1][1] = (int_x2val - int_xval*(piece_cent[verti][0]+t_cent[0]))/area_prod +
                                                              piece_cent[verti][0]*t_cent[0]*area/area_prod;
                        dual_tri_mass_matrix[trii][1][2][1] = int_xyval/area_prod -
                                                          (int_yval*t_cent[0] + int_xval*piece_cent[verti][1])/area_prod +
                                                           piece_cent[verti][1]*t_cent[0]*area/area_prod;

                        dual_tri_mass_matrix[trii][1][0][2] = (int_yval - t_cent[1]*area)/sqrt_area;
                        dual_tri_mass_matrix[trii][1][1][2] = int_xyval/area_prod -
                                                           (int_xval*t_cent[1]+int_yval*piece_cent[verti][0])/area_prod +
                                                           piece_cent[verti][0]*t_cent[1]*area/area_prod;
                        dual_tri_mass_matrix[trii][1][2][2] = (int_y2val - int_yval*(piece_cent[verti][1]+t_cent[1]))/area_prod +
                                                              piece_cent[verti][1]*t_cent[1]*area/area_prod;
                    } /// END::: if(3 == MAX_N_COEF) on L side
                    else
                    {
                        printf("ERROR: compute_dual_tri_basis_DG_P1()\n");
                        printf("Implement MAX_N_COEF = %d on L side\n", MAX_N_COEF);
                        clean_up(ERROR);
                    }

                }//// END::: for(side = 0; side < 3; side++)

            }/// END:: for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf); ... 
        } ////END::: for(surf = fr->mesh->surfaces; surf && *surf; surf++)
}

EXPORT void compute_crs_on_tri_skeleton(
	Front       *fr)
{
        SURFACE           **surf = fr->mesh->surfaces;
        TRI               *tri;
        POLYGON           *polyg[3];
        int               i, side, j, p_sect, dim = 2, k, tmp_side;
        double            *p_pt, *n_pt, bound;
        double            t[3], nor[3];
        double            x_bar, y_bar, dx, dy;
        double            *crds0, *crds1, crs[3], len, len_to_crs, sqrt_area;
        POINT             **pts;
        int               debug = NO;

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for(tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                // if(tri->BC_type == SUBDOMAIN) continue;

                for(i = 0; i < 3; i++)
                    polyg[i] = fg_polyg_at_tri_vert(tri)[i];

                /***
                if(tri->id == 922)
                {
                    printf("\n\ntri[%d] in compute_crs_on_tri_skeleton()\n", tri->id);
                    debug = YES;
                }
                else
                    debug = NO;
                ***/

                for(side = 0; side < 3; side++)
                {
                    /****
                    if((tri->id == 806 && side == 0) || (tri->id == 807 && side == 2))
                    {
                        printf("\n\ntri[%d] side %d in compute_crs_on_tri_skeleton(), cross polygon %d\n",
                                 tri->id, side, polyg[side]->id);
                        debug = YES;
                    }
                    else 
                        debug = NO;
                    ****/

                    for(j = 0; j < polyg[side]->n_sides; j++)
                    {
                        if(tri_at_polyg_vert(polyg[side])[j] == tri)
                            break;
                    }

                    if(polyg[side]->closed == NO)
                    {
                        continue; // need to implement
                    }

                    p_sect = (j+polyg[side]->n_sides-1)%(polyg[side]->n_sides);
                    pts = Point_of_polyg(polyg[side]);

                    /// 1) the portion of the edge that starts at the center of polyg[side]
                    p_pt = Coords(Point_of_tri(tri)[side]);
                    n_pt = Coords(Point_of_tri(tri)[(side+1)%3]);

                    if(debug == YES)
                    {
                        print_general_vector("start point of tri_edge", p_pt, 2, "\n"); 
                        print_general_vector("end   point of tri_edge", n_pt, 2, "\n\n"); 
                    }

                    crds0 = Coords(pts[p_sect]);
                    crds1 = Coords(pts[(p_sect+1)%polyg[side]->n_sides]);

                    cross_segments(crds0[0], crds0[1], crds1[0], crds1[1],
                                  p_pt[0], p_pt[1], n_pt[0], n_pt[1], crs);

                    len_to_crs = sqrt(sqr(crs[0]- p_pt[0]) + sqr(crs[1]-p_pt[1]));

                    len = fg_length_side(tri)[side];
                    bound = 2.0*(len_to_crs/len) - 1.0; // crds of crossing point mapped onto [-1, 1].

                    tri->edge_crs[side] = bound;

                    if(debug == YES)
                    {
                        print_general_vector("start point of poly_edge", crds0, 2, "\n"); 
                        print_general_vector("end   point of poly_edge", crds1, 2, "\n\n"); 
 
                        print_general_vector("crossing point", crs, 2, "\n\n"); 
                 
                        printf("len_to_crs = %12.10g, len of tri_edge = %12.10g, bound = %12.10g\n\n", 
                                 len_to_crs, len, bound);

                    }

                    /***
                    /// 2) the portion of the edge that ends at the center of polyg[side]
                    tmp_side = (side+2)%3;
                    p_sect = (p_sect+1)%(polyg[side]->n_sides);

                    p_pt = Coords(Point_of_tri(tri)[tmp_side]);
                    n_pt = Coords(Point_of_tri(tri)[(tmp_side+1)%3]);
                    crds0 = Coords(pts[p_sect]);
                    crds1 = Coords(pts[(p_sect+1)%polyg[side]->n_sides]);

                    cross_segments(crds0[0], crds0[1], crds1[0], crds1[1],
                                  p_pt[0], p_pt[1], n_pt[0], n_pt[1], crs);

                    len_to_crs = sqrt(sqr(crs[0]- p_pt[0]) + sqr(crs[1]-p_pt[1]));
                    bound = 0.5 + 0.5*(len_to_crs/len); // crds of crossing point mapped onto [-1, 1].

                    tri->edge_crs[tmp_side] = bound;
                    ***/ 
                } /// END::: for(side = 0; side < 3; side++)
            }/// END::: for(tri = first_tri(*surf);
        }
}

EXPORT void compute_dual_polygon_edge_basis_DG_P1(
        Front       *fr)
{               
        SURFACE     **surf = fr->mesh->surfaces;
        TRI         *tris[2];
        int         side, N_sides, trii, verti, k, share_e;        
        POLYGON     *polyg;
        POINT       **pts, **tmppts;
        double      *crds0, *crds1, *tri_e_pt0, *tri_e_pt1, crs[3];
        int         crs_flag, debug = NO;
        double      sqrt_area0, sqrt_area1, len, len_to_crs, bound;
        double      mass[2][N_COEF_EDGE][N_COEF_EDGE], ****mass_edge;

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (polyg = first_polyg(*surf); !at_end_of_polyg_list(polyg,*surf); polyg = polyg->next)
            {
                if(polyg->closed == NO) continue;

                N_sides = polyg->n_sides;
                pts = Point_of_polyg(polyg);
                mass_edge = polyg->mass_edge;
          
                for(side = 0; side < N_sides; side++)
                {
                    /*****
                    if(polyg->id == 447 && side == 0)
                    {
                         printf("\n\n compute_dual_polygon_edge_basis_DG_P1(), polygon %d\n", 
                                polyg->id);
                         debug = YES;
                    }
                    else
                       debug = NO;
                    ******/
                    
                    crds0 = Coords(pts[side]);   
                    crds1 = Coords(pts[(side+1)%N_sides]);   
                    tris[0] = tri_at_polyg_vert(polyg)[side];
                    tris[1] = tri_at_polyg_vert(polyg)[(side+1)%N_sides];
 
                    sqrt_area0 = sqrt(fg_area(tris[0]));
                    sqrt_area1 = sqrt(fg_area(tris[1]));

                    for(share_e = 0; share_e < 3; share_e++)
                    {
                       if(Tri_on_side(tris[0],share_e) == tris[1])
                           break;
                    }
                    tri_e_pt0 = Coords(Point_of_tri(tris[0])[share_e]); 
                    tri_e_pt1 = Coords(Point_of_tri(tris[0])[(share_e+1)%3]); 

                    crs_flag = cross_segments(crds0[0], crds0[1], crds1[0], crds1[1], 
                                          tri_e_pt0[0], tri_e_pt0[1], tri_e_pt1[0], tri_e_pt1[1], crs);
                    
                    len = polyg_length_side(polyg)[side];
                    len_to_crs = sqrt(sqr(crs[0]- crds0[0]) + sqr(crs[1]-crds0[1]));

                    bound = 2.0*(len_to_crs/len) - 1.0; // crds of crossing point mapped onto [-1, 1].

                    if(debug == YES)
                    {
                        printf("side[%d], len, len_to_crs %g, %g, bound = %12.10g\n\n", 
                              side, len, len_to_crs, bound);
                    }


                    if(2 == N_COEF_EDGE)
                    {
                        mass_edge[side][0][0][0] = bound+1.0;
                        mass_edge[side][0][0][1] = mass_edge[side][0][1][0] = 0.5*(sqr(bound) - 1.0);
                        mass_edge[side][0][1][1] = 1.0/3.0*(cub(bound) + 1.0);

                        mass_edge[side][1][0][0] = 1.0-bound;
                        mass_edge[side][1][0][1] = mass_edge[side][1][1][0] = 0.5*(1.0-sqr(bound));
                        mass_edge[side][1][1][1] = 1.0/3.0*(1.0-cub(bound));
                    }
                    else
                    {
                        printf("ERROR: compute_dual_polygon_edge_basis_DG_P1() implement N_COEF_EDGE = %d\n",
                                  N_COEF_EDGE);
                        clean_up(ERROR);
                    }
                } //// END::: for(side = 0; side < N_sides; side++)
            }
        }
}

//
//        dual cell    
//  __      /|\     __ (verti+1) // for R portion of intersections      
//    __  /  |  \ __  
//      /__L | R__\
//    /    __|__    \
//  /   tri (verti)   \
//
// dual_tri_mass_matrix:  // matrix for nodal basis on dual multiplied by 
                          // locally divergence-free basis on tri   
                          // [vertex ID][(R subregion = 0)/(L subregion = 1)]
                          // [index of basis function on dual cell][index of DG basis function on tri]
                          // NOTE: the last two dimensions of matrix can be viewed as the 
                          // integral of tensor product of these basis functions over either R/L subregion.
EXPORT void compute_dual_tri_basis(
	Front       *fr)
{
        SURFACE     **surf = fr->mesh->surfaces;
        TRI         *tri;
        int         side, N_sides, trii, verti, k;
        POLYGON     *polygs[3];
        POINT       **pts, **tmppts;
        double      ***conformal_basis_tri, area;
        double      tri_e_s[2], tri_e_e[2];
        double      pol_e_s[2], pol_e_e[2];
        double      crs[3], *t_cent, sqrt_area;
        bool        crs_flag;
        long double det;
        double      tmp_int[10], nodal_Bx[3], nodal_By[3], int_xval, int_yval;
        double      int_x2val, int_y2val, int_xyval;
        double      ****dual_tri_mass_matrix; 
        double      int_x4val, int_x3val, int_x2yval, int_xy2val, int_y3val, int_y4val, tmp1, tmp2, tmp3;

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf); !at_end_of_tri_list(tri,*surf);
                 tri = tri->next)
            {
                if(tri->BC_type == SUBDOMAIN)
                    continue;

                t_cent = fg_centroid(tri);
                dual_tri_mass_matrix = tri->dual_tri_mass_matrix;
                sqrt_area = sqrt(fg_area(tri));

                for(side = 0; side < 3; side++)
                    polygs[side] = fg_polyg_at_tri_vert(tri)[side];         
 
                for(side = 0; side < 3; side++)
                {
                    pts = Point_of_polyg(polygs[side]);
                    conformal_basis_tri = polygs[side]->conformal_basis_tri;
                    N_sides = polygs[side]->n_sides;

                    //  get tri edge for interection with polygon edge 
                    /// between nodes verti and (verti+1)
                    for(trii = 0; trii < 3; trii++)
                    {
                        if(YES== same_point2d(polyg_centroid(polygs[side]),
                                      Coords(Point_of_tri(tri)[trii]),
                                      0.1*fg_length_side(tri)[0] ) )
                        {
                            tri_e_e[0] = Coords(Point_of_tri(tri)[trii])[0];
                            tri_e_e[1] = Coords(Point_of_tri(tri)[trii])[1];

                            tri_e_s[0] = Coords(Point_of_tri(tri)[(trii+2)%3])[0];
                            tri_e_s[1] = Coords(Point_of_tri(tri)[(trii+2)%3])[1];
                            break;
                        }
                    }

                    for(verti = 0; verti < N_sides; verti++)
                    {
                        if(YES == same_point2d(Coords(pts[verti]),
                                      t_cent, 0.1*fg_length_side(tri)[0]) )
                        {
                            pol_e_s[0] = Coords(pts[verti])[0];
                            pol_e_s[1] = Coords(pts[verti])[1];

                            pol_e_e[0] = Coords(pts[(verti+1)%N_sides])[0];
                            pol_e_e[1] = Coords(pts[(verti+1)%N_sides])[1];
                            break;
                        }
                    }

                    // integrate out Bx, By from the right portion (R) of the region where tri overlaps 
                    // with current opolyg[side];
                    crs_flag = cross_segments(tri_e_s[0], tri_e_s[1], tri_e_e[0], tri_e_e[1],
                                   pol_e_s[0], pol_e_s[1], pol_e_e[0], pol_e_e[1], crs);
                    if(NO == crs_flag)
                    {
                        printf("ERROR: compute_dual_tri_basis()\n");
                        printf("tri edge and polygon edge do not cross 1\n");
                        clean_up(ERROR);
                    }

                    det = (long double)((tri_e_e[0]-crs[0])*(pol_e_s[1]-crs[1]) -
                                        (pol_e_s[0]-crs[0])*(tri_e_e[1]-crs[1]));
                    area = 0.5*det;

                    if(3 == C0_MAX_N_COEF)
                    {
                        int_xval = (double)int_x(crs,tri_e_e,pol_e_s,det);
                        int_yval = (double)int_y(crs,tri_e_e,pol_e_s,det);

                        // tmp_int[0] = (area)*conformal_basis_tri[verti][0][0] +
                        //                     conformal_basis_tri[verti][0][1]*int_xval +
                        //                     conformal_basis_tri[verti][0][2]*int_yval;
                        for(k = 0; k < 3; k++)
                            tmp_int[k] = conformal_basis_tri[verti][k][0]*area +
                                         conformal_basis_tri[verti][k][1]*int_xval +
                                         conformal_basis_tri[verti][k][2]*int_yval;
                        if(1 == MAX_N_COEF || 3 == MAX_N_COEF)
                        {
                            for(k = 0; k < 3; k++)
                                dual_tri_mass_matrix[side][0][k][0] = tmp_int[k];
                        }
                        if(3 == MAX_N_COEF)
                        {
                            int_x2val = (double)int_x2(crs,tri_e_e,pol_e_s,det);
                            int_y2val = (double)int_y2(crs,tri_e_e,pol_e_s,det);
                            int_xyval = (double)int_xy(crs,tri_e_e,pol_e_s,det);

                            // int_x3val, int_x2yval, int_xy2val, int_y3val;
                            // int_x4val =  (double)int_x4(crs,tri_e_e,pol_e_s,det);
                            int_x3val =  (double)int_x3(crs,tri_e_e,pol_e_s,det);
                            int_x2yval = (double)int_x2y(crs,tri_e_e,pol_e_s,det);
                            int_xy2val = (double)int_xy2(crs,tri_e_e,pol_e_s,det);
                            int_y3val =  (double)int_y3(crs,tri_e_e,pol_e_s,det);
                            // int_y4val =  (double)int_y4(crs,tri_e_e,pol_e_s,det);

                            // tmp_int[0] = conformal_basis_tri[verti][0][0]*int_xval  + 
                            //              conformal_basis_tri[verti][0][1]*int_x2val +
                            //              conformal_basis_tri[verti][0][2]*int_xyval - 
                            //             (area*conformal_basis_tri[verti][0][0] +
                            //              conformal_basis_tri[verti][0][1]*int_xval +
                            //              conformal_basis_tri[verti][0][2]*int_yval
                            //             )*t_cent[0];
                            // tmp_int[0] /= sqrt_area;

                            // calculate integral of (x-x0)/sqrt_area_tri *(a+bx+cy) 
                            // x0 is the x-coord of center of tri. 
                            // a+bx+cy is the nodal basis on one node of triagular-subregion of dual cell
                            for(k = 0; k < 3; k++)
                            {
                                tmp_int[k] = conformal_basis_tri[verti][k][0]*int_xval  + 
                                             conformal_basis_tri[verti][k][1]*int_x2val +
                                             conformal_basis_tri[verti][k][2]*int_xyval - 
                                            (conformal_basis_tri[verti][k][0]*area +
                                             conformal_basis_tri[verti][k][1]*int_xval +
                                             conformal_basis_tri[verti][k][2]*int_yval
                                            )*t_cent[0];
                                tmp_int[k] /= sqrt_area;
                                dual_tri_mass_matrix[side][0][k][1] = tmp_int[k];
                            }
                            
                            // calculate integral of (y-y0)/sqrt_area_tri *(a+bx+cy) 
                            // y0 is the y-coord of center of tri. 
                            // a+bx+cy is the nodal basis on one node of triagular-subregion of dual cell
                            for(k = 0; k < 3; k++)
                            {
                                tmp_int[k] = conformal_basis_tri[verti][k][0]*int_yval  + 
                                             conformal_basis_tri[verti][k][1]*int_xyval +
                                             conformal_basis_tri[verti][k][2]*int_y2val - 
                                            (conformal_basis_tri[verti][k][0]*area +
                                             conformal_basis_tri[verti][k][1]*int_xval +
                                             conformal_basis_tri[verti][k][2]*int_yval
                                            )*t_cent[1];
                                tmp_int[k] /= sqrt_area;
                                dual_tri_mass_matrix[side][0][k][2] = tmp_int[k];
                            }

                            // R side: calculate integral of 
                            // bubble_functions(x^2, xy, y^2) times tri_basis_functions 
                            // (1, (x-x0)/sqrt_area_tri ,(y-y0)/sqrt_area_tri)
                            // respectively.
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF][0] = int_x2val;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+1][0] = int_xyval;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+2][0] = int_y2val;

                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF][1] = (int_x3val - int_x2val*t_cent[0])/sqrt_area;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+1][1] = (int_x2yval - int_xyval*t_cent[0])/sqrt_area;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+2][1] = (int_xy2val - int_y2val*t_cent[0])/sqrt_area;

                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF][2] = (int_x2yval - int_x2val*t_cent[1])/sqrt_area;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+1][2] = (int_xy2val - int_xyval*t_cent[1])/sqrt_area;
                            dual_tri_mass_matrix[side][0][C0_MAX_N_COEF+2][2] = (int_y3val - int_y2val*t_cent[1])/sqrt_area;
                           
                        }/// END::: if(3 == MAX_N_COEF), R side.

                        if(1 != MAX_N_COEF && 3 !=  MAX_N_COEF)
                        {
                            printf("ERROR: compute_dual_tri_basis()\n");
                            printf("Implement C0_MAX_N_COEF = %d, MAX_N_COEF %d on R side\n",
                                  C0_MAX_N_COEF, MAX_N_COEF);
                            clean_up(ERROR);
                        }
                    } // END::: if(3 == C0_MAX_N_COEF) on R side
                    else
                    {
                        printf("ERROR: compute_dual_tri_basis()\n");
                        printf("Implement C0_MAX_N_COEF = %d on R side\n", C0_MAX_N_COEF);
                        clean_up(ERROR);
                    }

                    /// get tri edge for interection (L portion) with polygon edge 
                    ///   between nodes (verti-1) and (verti)
                    tri_e_s[0] = Coords(Point_of_tri(tri)[trii])[0];
                    tri_e_s[1] = Coords(Point_of_tri(tri)[trii])[1];
        
                    tri_e_e[0] = Coords(Point_of_tri(tri)[(trii+1)%3])[0];
                    tri_e_e[1] = Coords(Point_of_tri(tri)[(trii+1)%3])[1];

                    verti = (verti+N_sides-1)%N_sides;

                    pol_e_s[0] = Coords(pts[verti])[0];
                    pol_e_s[1] = Coords(pts[verti])[1];

                    pol_e_e[0] = Coords(pts[(verti+1)%N_sides])[0];
                    pol_e_e[1] = Coords(pts[(verti+1)%N_sides])[1];

                    crs_flag = cross_segments(tri_e_s[0], tri_e_s[1], tri_e_e[0], tri_e_e[1],
                                   pol_e_s[0], pol_e_s[1], pol_e_e[0], pol_e_e[1], crs);

                    if(NO == crs_flag)
                    {
                        printf("ERROR: compute_dual_tri_basis()\n");
                        printf("tri edge and polygon edge do not cross 2\n");
                        clean_up(ERROR);
                    }
                    det = (long double)((pol_e_e[0]-crs[0])*(tri_e_s[1]-crs[1]) -
                                        (tri_e_s[0]-crs[0])*(pol_e_e[1]-crs[1]));
                    area = 0.5*det;

                    if(3 == C0_MAX_N_COEF)
                    {
                        int_xval = int_x(crs,pol_e_e,tri_e_s,det);
                        int_yval = int_y(crs,pol_e_e,tri_e_s,det);

                        // tmp_int[0] = (area)*conformal_basis_tri[verti][0][0] +
                        //                     conformal_basis_tri[verti][0][1]*int_xval +
                        //                     conformal_basis_tri[verti][0][2]*int_yval;
                        for(k = 0; k < 3; k++)
                            tmp_int[k] = conformal_basis_tri[verti][k][0]*area +
                                         conformal_basis_tri[verti][k][1]*int_xval +
                                         conformal_basis_tri[verti][k][2]*int_yval;

                        if(1 == MAX_N_COEF || 3 == MAX_N_COEF)
                        {
                            for(k = 0; k < 3; k++)
                                dual_tri_mass_matrix[side][1][k][0] = tmp_int[k];
                        }
                        if(3 == MAX_N_COEF)
                        {
                            int_x2val = int_x2(crs,pol_e_e,tri_e_s,det);
                            int_y2val = int_y2(crs,pol_e_e,tri_e_s,det);
                            int_xyval = int_xy(crs,pol_e_e,tri_e_s,det);

                            int_x3val = int_x3(crs,pol_e_e,tri_e_s,det);
                            int_x2yval = int_x2y(crs,pol_e_e,tri_e_s,det);
                            int_xy2val = int_xy2(crs,pol_e_e,tri_e_s,det);
                            int_y3val = int_y3(crs,pol_e_e,tri_e_s,det);
                            
                            // calculate integral of (x-x0)/sqrt_area_tri *(a+bx+cy) 
                            // x0 is the x-coord of center of tri. 
                            // a+bx+cy is the nodal basis on one node of triagular-subregion of dual cell

                            for(k = 0; k < 3; k++)
                            {
                                tmp_int[k] = conformal_basis_tri[verti][k][0]*int_xval  +
                                             conformal_basis_tri[verti][k][1]*int_x2val +
                                             conformal_basis_tri[verti][k][2]*int_xyval -
                                            (conformal_basis_tri[verti][k][0]*area +
                                             conformal_basis_tri[verti][k][1]*int_xval +
                                             conformal_basis_tri[verti][k][2]*int_yval
                                            )*t_cent[0];
                                tmp_int[k] /= sqrt_area;
                                dual_tri_mass_matrix[side][1][k][1] = tmp_int[k];
                            }

                            for(k = 0; k < 3; k++)
                            {
                                tmp_int[k] = conformal_basis_tri[verti][k][0]*int_yval  +
                                             conformal_basis_tri[verti][k][1]*int_xyval +
                                             conformal_basis_tri[verti][k][2]*int_y2val -
                                            (conformal_basis_tri[verti][k][0]*area +
                                             conformal_basis_tri[verti][k][1]*int_xval +
                                             conformal_basis_tri[verti][k][2]*int_yval
                                            )*t_cent[1];
                                tmp_int[k] /= sqrt_area;
                                dual_tri_mass_matrix[side][1][k][2] = tmp_int[k];
                            }

                            // L side: calculate integral of 
                            // bubble_functions(x^2, xy, y^2) times tri_basis_functions 
                            // (1, (x-x0)/sqrt_area_tri ,(y-y0)/sqrt_area_tri)
                            // respectively.

                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF][0] = int_x2val;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+1][0] = int_xyval;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+2][0] = int_y2val;

                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF][1] = (int_x3val - int_x2val*t_cent[0])/sqrt_area;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+1][1] = (int_x2yval - int_xyval*t_cent[0])/sqrt_area;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+2][1] = (int_xy2val - int_y2val*t_cent[0])/sqrt_area;

                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF][2] = (int_x2yval - int_x2val*t_cent[1])/sqrt_area;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+1][2] = (int_xy2val - int_xyval*t_cent[1])/sqrt_area;
                            dual_tri_mass_matrix[side][1][C0_MAX_N_COEF+2][2] = (int_y3val - int_y2val*t_cent[1])/sqrt_area; 
                        } /// END::: if(3 == MAX_N_COEF), L side
             
                        if(1 != MAX_N_COEF && 3 !=  MAX_N_COEF)
                        {
                            printf("ERROR: compute_dual_tri_basis()\n");
                            printf("Implement C0_MAX_N_COEF = %d, MAX_N_COEF %d on L side\n",
                                  C0_MAX_N_COEF, MAX_N_COEF);
                            clean_up(ERROR);
                        }
                    } // END::: if(3 == C0_MAX_N_COEF) on L side
                    else
                    {
                        printf("ERROR: compute_dual_tri_basis()\n");
                        printf("Implement C0_MAX_N_COEF = %d on L side %d\n",
                              C0_MAX_N_COEF, MAX_N_COEF);
                        clean_up(ERROR);
                    }
                } /// END::: for(side = 0; side < 3; side++)
            }/// END::: for (tri = first_tri(*surf); ...
        }/// END::: for(surf = fr->mesh->surfaces; ...
}


LOCAL void install_dual_cell_to_tris(
	POINT     *pt,
        TRI       **tris,
        int       tri_N,
        POLYGON   *polyg)
{
        int       i, side;

        for(i = 0; i < tri_N; i++)
        {
            for(side =0; side < 3; side++)
            {
                if(Point_of_tri(tris[i])[side] == pt)
                    break;
            }
            fg_polyg_at_tri_vert(tris[i])[side] = polyg;
        }
}

// Split triangles with the rect. diagnoal
// Periodic BC on both sides
EXPORT TRI **init_diag_triangle_vortex_evo(
        Front           *front,
        int             *tri_num)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri, **all_tris;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_diag_triangle_vortex_evo\n");
        print_rectangular_grid(gr);
        // clean_up(0);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,2,sizeof(TRI *));

        vector(&all_tris, imax*jmax*2, sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                tri[ix][iy][0] = i_make_tri(pt[0],pt[2],pt[3],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][0]->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][0]->Bmass_inv);

                tri[ix][iy][0]->id = num_tri;
                /// NEW
                all_tris[num_tri] = tri[ix][iy][0];
                /// END NEW
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][0],s);

                tri[ix][iy][1] = i_make_tri(pt[0],pt[1],pt[2],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][1]->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][1]->Bmass_inv);

                tri[ix][iy][1]->id = num_tri;
                /// NEW
                all_tris[num_tri] = tri[ix][iy][1];
                /// END NEW
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][1],s);

                // TMP
                // print_tri(tri[ix][iy][0],intfc);
                // print_tri(tri[ix][iy][1],intfc);
            }
        }

        *tri_num = num_tri;

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                Boundary_tri(tri[ix][iy][0]) = NO;
                Boundary_tri(tri[ix][iy][1]) = NO;

                if (iy != 0)
                {
                    // south
                    Tri_on_side01(tri[ix][iy][1]) = tri[ix][iy-1][0];
                    // TMP
                    // print_tri(tri[ix][iy][0],intfc);
                }
                if(ix !=(imax-1))
                {
                    // east
                    Tri_on_side12(tri[ix][iy][1]) = tri[ix+1][iy][0];
                }
                if(iy !=(jmax-1))
                {
                    // north
                    Tri_on_side12(tri[ix][iy][0]) = tri[ix][iy+1][1];
                }
                if(ix != 0)
                {
                    // west
                    Tri_on_side20(tri[ix][iy][0]) = tri[ix-1][iy][1];
                }
                Tri_on_side01(tri[ix][iy][0]) = tri[ix][iy][1];
                Tri_on_side20(tri[ix][iy][1]) = tri[ix][iy][0];
            }
        }

        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 2; i++)
                {
                    if(iy == 0 && i == 1)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }

                    if(iy == jmax-1 && i == 0)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[1] = SUBDOMAIN;
                    }
                    if(ix == 0 && i == 0)
                    {
                        set_20_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[2] = SUBDOMAIN;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[1] = SUBDOMAIN;
                    }
                }
            }
        }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                 tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);
            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {   
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // num_tri++;
        }
        s->num_tri = num_tri;
        // TMP
        // printf("num_tri = %d\n", num_tri);

        if(!debugging("field_loop"))
        {
#if defined(__MPI__)
            BLOCK_SIZE = GetHypPPBlockSize();
            parallel_perturb_struc_triangle(front, p);
#else
            perturb_struc_triangle(front, p, PERIODIC_BOUNDARY);
#endif // if defined(__MPI__)
        }

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);


#if !defined(_MPI_)
        output_tri_mesh("visual",0,front->mesh);
#endif // if !defined(_MPI_)

        // printf("EXIT **** Leaving init_diag_triangle_vortex_evo\n");
        // clean_up(0);

        return all_tris;
}


// Split triangles with the rect. two diagnoals
// Periodic BC on both sides
EXPORT void init_triangle_vortex_evo(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_triangle_vortex_evo\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,4,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                for (i = 0; i < 3; i++)
                    coords[i] = 0.5*(Coords(pt[0])[i]+ Coords(pt[2])[i]);
                midp = Point(coords);

                for (i = 0; i < 4; i++)
                {
                    ip1 = (orient == COUNTER_CLOCK) ? i : Next_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Next_m4(i): i;
                    tri[ix][iy][i] = i_make_tri(pt[ip1],pt[ip2],midp,
                                              NULL,NULL,NULL,YES);
                    // new, compute mass_matrix and inverse on tri
                    comp_mass_matrix(MAX_N_COEF,tri[ix][iy][i],2,tri[ix][iy][i]->Lmass_matrix);
                    // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                    inverse_matrix(tri[ix][iy][i]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][i]->mass_inv);
                    tri[ix][iy][i]->id = num_tri;
                    num_tri++;

                    insert_tri_at_tail_of_list(tri[ix][iy][i],s);
                }
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);

                    if ((i == 0) && (iy != 0))
                    {
                        /* south */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy-1][2];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 1) && ix !=(imax-1))
                    {
                        /* east */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix+1][iy][3];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 2) && iy !=(jmax-1))
                    {
                        /* north */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy+1][0];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 3) && ix !=0)
                    {
                        /* west */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix-1][iy][1];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    ip1 = (orient == COUNTER_CLOCK) ? Next_m4(i): Prev_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Prev_m4(i): Next_m4(i);
                    Tri_on_side12(tri[ix][iy][i]) = tri[ix][iy][ip1];
                    Tri_on_side20(tri[ix][iy][i]) = tri[ix][iy][ip2];
                    set_12_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    set_20_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                }
            }
        }

        /* set tri neighbors */  
            for (iy = 0; iy < jmax; iy++)
            {
                for (ix = 0; ix < imax; ix++)
                {
                    for (i = 0; i < 4; i++)
                    {
                        // set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        // set_12_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        // set_20_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        if(iy == 0 && i == 0)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                            // tri[ix][iy][i]->BC_type = IN_FLOW;
                            // printf("bottom side boundary tri\n");
                            // print_tri(tri[ix][iy][i],front->interf);
                        }

                        if(iy == jmax-1 && i == 2)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;

                            // printf("top side side boundary tri\n");
                            // print_tri(tri[ix][iy][i],front->interf);
                        }
                        if(ix == 0 && i == 3)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                        }
                        if(ix == imax -1 && i == 1)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                        }
                    }
                }
            }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                 tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);
            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // num_tri++;
        }
        s->num_tri = num_tri;

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

}


// x direction, REflection BC,
// Top and bottom: Flow through
EXPORT void init_shock_vortex(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        TRI       *nbtri[3];
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3, dim = 2;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR init_shock_vortex\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_shock_vortex\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,4,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        num_tri = 0;
        /* make triangles */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {

                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                for (i = 0; i < 3; i++)
                    coords[i] = 0.5*(Coords(pt[0])[i]+ Coords(pt[2])[i]);
                midp = Point(coords);

                for (i = 0; i < 4; i++)
                {
                    ip1 = (orient == COUNTER_CLOCK) ? i : Next_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Next_m4(i): i;
                    tri[ix][iy][i] = i_make_tri(pt[ip1],pt[ip2],midp,
                                              NULL,NULL,NULL,YES);
                    tri[ix][iy][i]->id = num_tri;
                    num_tri++;
                    // new, compute mass_matrix and inverse on tri
                    comp_mass_matrix(MAX_N_COEF,tri[ix][iy][i],2,tri[ix][iy][i]->Lmass_matrix);
                    // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                    inverse_matrix(tri[ix][iy][i]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][i]->mass_inv);

                    insert_tri_at_tail_of_list(tri[ix][iy][i],s);
                }
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    Boundary_tri(tri[ix][iy][i]) = NO;

                    if ((i == 0) && (iy != 0))
                    {
                        /* south */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy-1][2];
                    }
                    else if ((i == 1) && ix !=(imax-1))
                    {
                        /* east */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix+1][iy][3];
                    }
                    else if ((i == 2) && iy !=(jmax-1))
                    {
                        /* north */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy+1][0];
                    }
                    else if ((i == 3) && ix !=0)
                    {
                        /* west */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix-1][iy][1];
                    }
                    ip1 = (orient == COUNTER_CLOCK) ? Next_m4(i): Prev_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Prev_m4(i): Next_m4(i);
                    Tri_on_side12(tri[ix][iy][i]) = tri[ix][iy][ip1];
                    Tri_on_side20(tri[ix][iy][i]) = tri[ix][iy][ip2];
                }
            }
        }

        // set boundary tris
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    if(iy == 0 && i == 0)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = IN_FLOW;
                    }

                    if(iy == jmax-1 && i == 2)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = OUT_FLOW;
                    }
                    if(ix == 0 && i == 3)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                }
            }
        }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                                   tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);

            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // print_tri(tmptri,intfc);
        }
        s->num_tri = num_tri;
        // TMP
        // printf("num_tri = %d\n", num_tri);

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

        printf("**** Leaving init_shock_vortex\n");
        // clean_up(0);
}

// Split triangles with the rect. diagnoal
// EXACT BC on both sides
LOCAL void init_true_diag_triangle_gas_sine(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_diag_triangle_gas_sine\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,2,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                tri[ix][iy][0] = i_make_tri(pt[0],pt[2],pt[3],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][0]->mass_inv);
                tri[ix][iy][0]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][0],s);

                tri[ix][iy][1] = i_make_tri(pt[0],pt[1],pt[2],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][1]->mass_inv);
                tri[ix][iy][1]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][1],s);

                // TMP
                // print_tri(tri[ix][iy][0],intfc);
                // print_tri(tri[ix][iy][1],intfc);
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                Boundary_tri(tri[ix][iy][0]) = NO;
                Boundary_tri(tri[ix][iy][1]) = NO;

                if (iy != 0)
                {
                    // south
                    Tri_on_side01(tri[ix][iy][1]) = tri[ix][iy-1][0];
                    // TMP
                    // print_tri(tri[ix][iy][0],intfc);
                }
                if(ix !=(imax-1))
                {
                    // east
                    Tri_on_side12(tri[ix][iy][1]) = tri[ix+1][iy][0];
                }
                if(iy !=(jmax-1))
                {
                    // north
                    Tri_on_side12(tri[ix][iy][0]) = tri[ix][iy+1][1];
                }
                if(ix != 0)
                {
                    // west
                    Tri_on_side20(tri[ix][iy][0]) = tri[ix-1][iy][1];
                }
                Tri_on_side01(tri[ix][iy][0]) = tri[ix][iy][1];
                Tri_on_side20(tri[ix][iy][1]) = tri[ix][iy][0];
            }
        }

        // set boundary type
        // actually, exact BC is imposed
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 2; i++)
                {
                    if(iy == 0 && i == 1)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = IN_FLOW;
                    }

                    if(iy == jmax-1 && i == 0)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[1] = OUT_FLOW;
                    }
                    if(ix == 0 && i == 0)
                    {
                        set_20_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[2] = IN_FLOW;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[1] = OUT_FLOW;
                    }
                }
            }
        }

        s->num_tri = num_tri;

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

}

LOCAL int tri_side_on_domain_boundary(
        TRI   *tri,
        int   side,
        RECT_GRID *gr)
{
        int   i;
        float crds0[3], crds1[3], crds[3];

        for(i = 0; i < 2; i++)
        {
            crds0[i] = Coords(Point_of_tri(tri)[side%3])[i];
            crds1[i] = Coords(Point_of_tri(tri)[(side+1)%3])[i];
            crds[i] = 0.5*(crds0[i] + crds1[i]);
        }

        if( fabs(crds[0] - gr->GL[0]) < 0.0000001 &&
            crds[1] > gr->GL[1] && crds[1] < gr->GU[1])
            return YES;
        if( fabs(crds[0] - gr->GU[0]) < 0.0000001 &&
            crds[1] > gr->GL[1] && crds[1] < gr->GU[1])
            return YES;
        if( fabs(crds[1] - gr->GL[1]) < 0.0000001 &&
            crds[0] > gr->GL[0] && crds[0] < gr->GU[0])
            return YES;
        if( fabs(crds[1] - gr->GU[1]) < 0.0000001 &&
            crds[0] > gr->GL[0] && crds[0] < gr->GU[0])
            return YES;

        if(debugging("Mach_step"))
        {
            if( fabs(crds[0] - 0.8) < 0.0000001 &&
                crds[1] > 0.6 && crds[1] < 3.0)
                return YES;
            if( fabs(crds[1] - 0.6) < 0.0000001 &&
                crds[0] > 0.8 && crds[0] < 1.0)
                return YES;
        }

        return NO;
}

EXPORT void init_diag_triangle_gas_sine(
        char   *fname,
	Front  *front)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2, **neigh, on_BC[3];
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        // return init_true_diag_triangle_gas_sine(front);
        tri = read_input_easy_mesh(fname, front, &n_tri, &neigh);
        // tri = read_input_mesh(fname, front, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
#if defined(__MPI__)
            if(tri[i] == NULL) continue;
#endif //// if defined(__MPI__)

            if(Boundary_tri(tri[i]))
            {
#if defined(__MPI__)
                /////// NEW 022210
                if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
                {
                    tri[i]->BC_type = SUBDOMAIN;
                    continue;
                }
                /////// END NEW 022210
#endif //// if defined(__MPI__)
                for(side = 0; side < 3; side++)
                {
#if defined(__MPI__)
                    if((on_BC[side] = tri_side_on_domain_boundary(tri[i],side,front->rect_grid))
                        == NO
                      )
                    {
                        continue;
                    }
#endif //// if defined(__MPI__)
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);

                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                } /// END for(side = 0; side < 3; side++)
#if defined(__MPI__)
                /////// NEW 022210
                if(on_BC[0] == NO && on_BC[1] == NO && on_BC[2] == NO)
                    tri[i]->BC_type = SUBDOMAIN;
                /////// END NEW 022210
#endif ///// if defined(__MPI__)
            }
        }

        free(tri);
        free(neigh);
}

EXPORT void init_tri_shock_vortex(
        char   *fname,
        Front  *front)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2, **neigh, on_BC[3];
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        // return init_shock_vortex(front);
        tri = read_input_easy_mesh(fname, front, &n_tri, &neigh);
        // tri = read_input_mesh(fname, front, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
#if defined(__MPI__)
            if(tri[i] == NULL) continue;
#endif //// if defined(__MPI__)
            if(Boundary_tri(tri[i]))
            {
#if defined(__MPI__)
                /////// NEW 022210
                if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
                {
                    tri[i]->BC_type = SUBDOMAIN;
                    continue;
                }
                /////// END NEW 022210
#endif //// if defined(__MPI__)
                for(side = 0; side < 3; side++)
                {
#if defined(__MPI__)
                    if((on_BC[side] = tri_side_on_domain_boundary(tri[i],side,front->rect_grid))
                        == NO)
                    {
                        continue;
                    }
#endif //// if defined(__MPI__)
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];
                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side
                            fg_e_type(tri[i])[side] = SUBDOMAIN;
                            tri[i]->BC_type = ON_SUBDOMAIN; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = SUBDOMAIN;
                            tri[i]->BC_type = ON_SUBDOMAIN; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                } /// END for(side = 0; side < 3; side++)
#if defined(__MPI__)
                /////// NEW 022210
                if(on_BC[0] == NO && on_BC[1] == NO && on_BC[2] == NO)
                    tri[i]->BC_type = SUBDOMAIN;
                /////// END NEW 022210
#endif ///// if defined(__MPI__)
            }
        }

        free(tri);
        free(neigh);
}

LOCAL int tris_share_edge(
	TRI *tri1,
        TRI *tri2)
{

        int i, j, same =0;
        POINT *p1[3], *p2[3];

        for(i = 0; i < 3; i++)
        {
            p1[i] = Point_of_tri(tri1)[i];
            p2[i] = Point_of_tri(tri2)[i];
        }
        
        for(i = 0; i < 3; i++)
        {
            for(j = 0; j < 3; j++)
            {
                if(p1[i] == p2[j])
                {
                    same++;
                    break;
                }
            }    
        } 

        if(same == 2)
            return YES;
        else 
            return NO;
}


EXPORT void attach_buffer_tris(
	Front *fr)
{
	INTERFACE  *current_intfc, *mesh;
        TRI       *tri, *crsp_tri, *nbtri[3], **tris, **row_tris[20];
        SURFACE   **surf;
        int       side, i, j, dim = 2;
        float     nor[MAXD], t[MAXD], coords[3], u, crds[3];
        POINT     *gp, *p[3];
        int       N_alloc = 500, N_row, N_use =0, N;

        current_intfc = current_interface();
        set_current_interface(fr->mesh);
        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);
        set_comput_tri_geom_flag(YES);

        vector(&tris, N_alloc, sizeof(TRI*));
        row_tris[0] = tris;
        N_row = 1;

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == IN_FLOW || tri->BC_type == OUT_FLOW ||
                   tri->BC_type == NEUMANN || tri->BC_type == CONST_P ||
                   debugging("shock_vort") || debugging("Sod"))
                {
                    for(side = 0; side < 3; side++)
                    {
                        if(NULL == Tri_on_side(tri,side))
                        {
                            for(i = 0; i < 3; i++)
                                p[i] = Point_of_tri(tri)[(side+i)%3]; 
                            for(i = 0; i < dim; i++)
                                coords[i] = Coords(p[2])[i];
                            coords[2] = 0.0;
                            gp = Point(coords);

                            for(i = 0; i < dim; i++)
                               t[i] = fg_side_vector(tri)[side][i];
                            nor[0] = t[1];
                            nor[1] = -t[0];
                            // projection
                            u = ((Coords(p[2])[0]-Coords(p[0])[0])*(Coords(p[1])[0]-Coords(p[0])[0]) +
                                 (Coords(p[2])[1]-Coords(p[0])[1])*(Coords(p[1])[1]-Coords(p[0])[1]) )
                                    /fg_length_side(tri)[side];

                            crds[0] = Coords(p[0])[0] + u*(Coords(p[1])[0]-Coords(p[0])[0]);
                            crds[1] = Coords(p[0])[1] + u*(Coords(p[1])[1]-Coords(p[0])[1]);

                            i_reflect_point(gp, crds, nor, fr->interf);
                            tris[N_use] = i_make_tri(p[0],gp,p[1], NULL,NULL,NULL,YES);
                            tris[N_use]->id = -1;
                            comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                            inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                            Tri_on_side(tri,side) = tris[N_use];
                            Tri_on_side(tris[N_use],2) = tri; 
                            tris[N_use]->BC_type = SUBDOMAIN;
                            set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                            set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                            // The "tri" is not a boundary tri anymore
                            Boundary_tri(tri) = NO;

                            // TMP
                            /**
                            printf("print interior tri:\n");
                            print_tri_crds(tri);
                            printf("print exterior tri:\n");
                            print_tri_crds(tris[N_use]);
                            **/

                            N_use++;

                            if(N_use == N_alloc)
                            {
                                if(N_row +1 >= 20)
                                {
                                    printf("ERROR: attach_buffer_tris, exceed alloc. limit\n");
                                    clean_up(ERROR);
                                }
                                vector(&tris, N_alloc, sizeof(TRI*));
                                row_tris[N_row] = tris;
                                N_row++;
                                N_use = 0;
                            }

                        }
                    }
                }
            }
            // insert tris to the surface
            for(i = 0; i < N_row; i++)
            {
                if(i == N_row-1)
                    N = N_use;
                else
                    N = N_alloc;
                for(j = 0; j < N; j++)
                {
                    insert_tri_at_tail_of_list(row_tris[i][j],*surf);
                }
            }
        }

        set_current_interface(current_intfc);
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);


        for(i = 0; i < N_row; i++)
            free(row_tris[i]);

        // TMP
        /**
        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == SUBDOMAIN)
                    continue;
                if(Boundary_tri(tri))
                {
                    for(side = 0; side < 3; side++)
                    {
                        nbtri[side] = Tri_on_side(tri,side);
                    }
                    printf("tri[%d] cent[%Lg, %Lg] side[%d %d %d]\n", 
                            tri->id, fg_centroid(tri)[0], fg_centroid(tri)[1], 
                            nbtri[0], nbtri[1], nbtri[2]);
                }
            }
        }
        **/
        // END TMP

        // output_tri_mesh("visual", 0, fr->mesh);
        // printf("EXIT in attach_buffer_tris()\n");
        // clean_up(0);
}


//// This function detects tris at the 
//// corner of the rect. domain that have two edges on the boundary (Only one neighboring tri).
LOCAL void split_tri_on_corner(
	Front  *fr)
{
        INTERFACE  *current_intfc, *mesh;
        TRI       *tri, *crsp_tri, *tmptri, *nbtri[3], *tris[100], *newtri[4], *ntris[100], *tris2[100];
        SURFACE   **surf;
        int       side, i, j, dim = 2, tmpside, old_side;
        float     nor[MAXD], t[MAXD], coords[3], u, crds[3], dirx[2] = {1.0, 0.0}, ans;
        POINT     *gp, *p[3], *newgp[3][3]; 
        float     newp[3][3][3], newp2[3][3][3]; //[tri#][pt#][crds]
        int       N_use =0, N, N_use2 = 0;
        GRID_DIRECTION direction;
        float     *L = fr->rect_grid->L, *U = fr->rect_grid->U;
                    
        current_intfc = current_interface();
        set_current_interface(fr->mesh);
        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);
            
        set_alloc_mass_storage_flag(YES);
        set_comput_tri_geom_flag(YES);
                
        /// output_tri_mesh("visual", 100, fr->mesh);

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == IN_FLOW || tri->BC_type == OUT_FLOW ||
                   tri->BC_type == NEUMANN || tri->BC_type == CONST_P ||
                   tri->BC_type == ON_SUBDOMAIN)
                {
                    i = 0;
                    for(side = 0; side < 3; side++)
                    {
                        if(NULL != Tri_on_side(tri,side))
                            i++;
                    }

                    if(i == 1)
                    {
                        tris[N_use] = tri;

                        // printf("one neighbor tri cent[%g %g], %p %p %p\n",
                        //      fg_centroid(tri)[0], fg_centroid(tri)[1], Tri_on_side(tri,0), Tri_on_side(tri,1),
                        //      Tri_on_side(tri,2));
                        // print_tri_crds(tri);

                        for(side = 0; side < 3; side++)
                        {
                            if(NULL != Tri_on_side(tri,side))
                            {
                                tris2[N_use2] = Tri_on_side(tri,side);
                                break;
                            }
                        }
                        N_use++;
                        N_use2++;
                    }
                }
            }
        }

        for(N = 0; N < N_use; N++)
        {
            for(side = 0; side < 3; side++)
            {
                if(NULL != Tri_on_side(tris[N],side))
                {
                    crsp_tri = Tri_on_side(tris[N],side);
                    tri = tris[N];
                    old_side = side;
                    break;
                }
            }
            for(i = 0; i < 3; i++)
                p[i] = Point_of_tri(tri)[(side+i)%3];
            //// make the point where tri is going to split.
            for(i = 0; i < dim; i++)
                newp[0][0][i] = 0.5*(Coords(p[0])[i] + Coords(p[1])[i]);
            gp = Point(newp[0][0]);

            //// now make new tris to split the corner tri.
            newtri[0] = i_make_tri(p[0],gp,p[2],NULL,NULL,NULL,YES);
            newtri[1] = i_make_tri(gp,p[1],p[2],NULL,NULL,NULL,YES);

            //// now make new tris to split the neighbor of corner tri
            //// to avoid hanging node. this side is used later
            for(side = 0; side < 3; side++)
            {   
                if(tri == Tri_on_side(crsp_tri,side))
                    break;
            }
            for(i = 0; i < 3; i++)
                p[i] = Point_of_tri(crsp_tri)[(side+i)%3];
            newtri[2] = i_make_tri(p[0],gp,p[2],NULL,NULL,NULL,YES);
            newtri[3] = i_make_tri(gp,p[1],p[2],NULL,NULL,NULL,YES);
            //// now install new tri neighbors.
            Tri_on_side(newtri[0],0) = newtri[3];
            Tri_on_side(newtri[0],1) = newtri[1];
            fg_e_type(newtri[0])[2] = fg_e_type(tri)[(old_side+2)%3];
            newtri[0]->BC_type = fg_e_type(tri)[(old_side+2)%3];
            if(newtri[0]->BC_type == SUBDOMAIN)
                newtri[0]->BC_type = ON_SUBDOMAIN;
            set_side_bdry(Boundary_tri(newtri[0]),0,NO);
            set_side_bdry(Boundary_tri(newtri[0]),1,NO);
            set_side_bdry(Boundary_tri(newtri[0]),2,YES);

            Tri_on_side(newtri[1],0) = newtri[2];
            Tri_on_side(newtri[1],2) = newtri[0];
            fg_e_type(newtri[1])[1] = fg_e_type(tri)[(old_side+1)%3];
            newtri[1]->BC_type = fg_e_type(tri)[(old_side+1)%3];
            if(newtri[1]->BC_type == SUBDOMAIN)
                newtri[1]->BC_type = ON_SUBDOMAIN;
            set_side_bdry(Boundary_tri(newtri[1]),0,NO);
            set_side_bdry(Boundary_tri(newtri[1]),1,YES);
            set_side_bdry(Boundary_tri(newtri[1]),2,NO);

            Tri_on_side(newtri[2],0) = newtri[1];
            Tri_on_side(newtri[2],1) = newtri[3];
            Tri_on_side(newtri[2],2) = Tri_on_side(crsp_tri,(side+2)%3);
            Tri_on_side(newtri[3],0) = newtri[0];
            Tri_on_side(newtri[3],1) = Tri_on_side(crsp_tri,(side+1)%3);
            Tri_on_side(newtri[3],2) = newtri[2];

            for(i = 0; i < 3; i++)
            {
                set_side_bdry(Boundary_tri(newtri[2]),i,NO);
                set_side_bdry(Boundary_tri(newtri[3]),i,NO);
            }
            
            ///// set crsp tri's neighbor
            tmptri = Tri_on_side(crsp_tri,(side+2)%3);
            for(i = 0; i < 3; i++)
            {
                if(Tri_on_side(tmptri,i) == crsp_tri)
                {
                    Tri_on_side(tmptri,i) = newtri[2];
                    break;
                }
            }
            tmptri = Tri_on_side(crsp_tri,(side+1)%3);
            for(i = 0; i < 3; i++)
            {
                if(Tri_on_side(tmptri,i) == crsp_tri)
                {
                    Tri_on_side(tmptri,i) = newtri[3];
                    break;
                }
            }
            for(side = 0; side < 3; side++)
            {
                Tri_on_side(tri,side) = NULL;
                Tri_on_side(crsp_tri,side) = NULL;
            }

            for(i = 0; i < 4; i++)
            {
                comp_mass_matrix(MAX_N_COEF,newtri[i],2,newtri[i]->Lmass_matrix);
                inverse_matrix(newtri[i]->Lmass_matrix,MAX_N_COEF,newtri[i]->mass_inv);
            }
           
            // printf("Beofre insert tris to the surface\n");

            // insert tris to the surface
            for(i = 0; i < 4; i++) 
                insert_tri_at_tail_of_list(newtri[i],tri->surf);


        }

        /// printf("Beofre delete old tris \n");
        ///// Now need to delete old tris.
        for(j = 0; j < N_use; j++)
            remove_out_rect_tri(tris[j], tris[j]->surf);
        for(j = 0; j < N_use2; j++)
            remove_out_rect_tri(tris2[j], tris[j]->surf);

        for(j = 0; j < N_use; j++)
            free(tris[j]);
        for(j = 0; j < N_use2; j++)
            free(tris2[j]);

        // if(N_use != 0)
        // {
        //     printf("ERROR: split_tri_on_corner()\n");
        //     printf("%d tri only has 1 neighbor\n", N_use);
        //     clean_up(0);
        // }

        set_current_interface(current_intfc);
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);
        // printf("Leaving split_tri_on_corner()\n");
}

// reflect interior tries by the boundary
EXPORT void attach_buffer_tris_ver2(
	Front *fr)
{
	INTERFACE  *current_intfc, *mesh;
        TRI       *tri, *crsp_tri, *nbtri[3], **tris, **row_tris[100], *newtri[3];
        SURFACE   **surf;
        int       side, i, j, dim = 2, tmpside;
        float     nor[MAXD], t[MAXD], coords[3], u, crds[3], dirx[2] = {1.0, 0.0}, ans;
        POINT     *gp, *p[3], *newgp[3][3]; 
        float     newp[3][3][3], newp2[3][3][3]; //[tri#][pt#][crds]
        int       N_alloc = 500, N_row, N_use =0, N;
        GRID_DIRECTION direction;
        float     *L = fr->rect_grid->L, *U = fr->rect_grid->U;

        split_tri_on_corner(fr);

        current_intfc = current_interface();
        set_current_interface(fr->mesh);
        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);
        set_comput_tri_geom_flag(YES);

        vector(&tris, N_alloc, sizeof(TRI*));
        row_tris[0] = tris;
        N_row = 1;

        // output_tri_mesh("visual", 100, fr->mesh);

        if(debugging("shock_vort"))
        {
            printf("ERROR:  attach_buffer_tris_ver2(), examine how to add ghost");
            printf(" tris in buffer for P3 finite volume scheme\n");
            clean_up(ERROR);
        }

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == IN_FLOW || tri->BC_type == OUT_FLOW ||
                   tri->BC_type == NEUMANN || tri->BC_type == CONST_P ||
                   tri->BC_type == ON_SUBDOMAIN)
                {
                    nbtri[0] = tri;
                    i = 1;
                    for(side = 0; side < 3; side++)
                    {
                        if(NULL == Tri_on_side(tri,side))
                            break;
                    }
                    if( (nbtri[1] = Tri_on_side(tri,(side+1)%3)) != NULL)
                        i++;
                    if( (nbtri[2] = Tri_on_side(tri,(side+2)%3)) != NULL)
                        i++;

#if defined(__MPI__)
                    if(i != 3) continue;
#endif ////// if defined(__MPI__)

                    if(i != 3)
                    {
                        printf("ERROR: attach_buffer_tris_ver2()\n");
                        printf("Did not find enough tris i = %d\n", i);
                        clean_up(ERROR);
                    }

                    ///// this side is saved for later usage.
                    for(side = 0; side < 3; side++)
                    {
                        if(NULL == Tri_on_side(tri,side))
                        {
                            for(i = 0; i < 3; i++)
                                p[i] = Point_of_tri(tri)[(side+i)%3]; 
                            for(i = 0; i < dim; i++)
                               t[i] = fg_side_vector(tri)[side][i];
                            nor[0] = t[1];
                            nor[1] = -t[0];
                            for(i = 0; i < 3; i++)
                            {
                                newp[0][i][0] = Coords(Point_of_tri(tri)[(side+i)%3])[0];
                                newp[0][i][1] = Coords(Point_of_tri(tri)[(side+i)%3])[1];
                            }
                            break;
                        }
                    }
                    for(tmpside = 0; tmpside < 3; tmpside++)
                    {
                        if(Tri_on_side(nbtri[1],tmpside) == tri)
                        {
                            for(i = 0; i < 3; i++)
                            {
                                newp[1][i][0] = Coords(Point_of_tri(nbtri[1])[(tmpside+i)%3])[0];
                                newp[1][i][1] = Coords(Point_of_tri(nbtri[1])[(tmpside+i)%3])[1];
                            }                            
                            break;
                        }
                    }
                    for(tmpside = 0; tmpside < 3; tmpside++)
                    {
                        if(Tri_on_side(nbtri[2],tmpside) == tri)
                        {
                            for(i = 0; i < 3; i++)
                            {
                                newp[2][i][0] = Coords(Point_of_tri(nbtri[2])[(tmpside+i)%3])[0];
                                newp[2][i][1] = Coords(Point_of_tri(nbtri[2])[(tmpside+i)%3])[1];
                            }
                            break;
                        }
                    }

                    ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                    if(ans > 0.5 && nor[0] > 0.5)
                    {
                         // right side
                         direction = EAST;
                         for(i = 0; i < 3; i++)
                         {
                             for(j = 0; j < 3; j++)
                             {
                                 newp2[i][j][0] = U[0]*2.0 - newp[i][j][0]; 
                                 newp2[i][j][1] = newp[i][j][1]; 
                             }
                         }
                    }
                    else if(ans > 0.5 && nor[0] < -0.5)
                    {
                        //  left side
                         direction = WEST;
                         for(i = 0; i < 3; i++)
                         {
                             for(j = 0; j < 3; j++)
                             {
                                 newp2[i][j][0] = L[0]*2.0 - newp[i][j][0];
                                 newp2[i][j][1] = newp[i][j][1];            
                             }
                         }
                    }
                    else if(ans < 0.5 && nor[1] > 0.5)
                    {
                        // top
                         direction = NORTH;
                         for(i = 0; i < 3; i++)
                         {
                             for(j = 0; j < 3; j++)
                             {
                                 newp2[i][j][0] = newp[i][j][0];
                                 newp2[i][j][1] = U[1]*2.0 - newp[i][j][1];            
                             }
                         }
                    }
                    else
                    {
                        // bottom
                         direction = SOUTH;
                         for(i = 0; i < 3; i++)
                         {
                             for(j = 0; j < 3; j++)
                             {
                                 newp2[i][j][0] = newp[i][j][0];
                                 newp2[i][j][1] = L[1]*2.0 - newp[i][j][1]; 
                             }
                         }
                    }
                    for(j = 0; j < 3; j++)
                    {
                        newgp[j][0] = Point(newp2[j][0]);
                        newgp[j][1] = Point(newp2[j][1]);
                        newgp[j][2] = Point(newp2[j][2]);
                    }
                    ///////// make image of tri....
                    newtri[0] = tris[N_use] = i_make_tri(p[0],newgp[0][2],p[1], NULL,NULL,NULL,YES);
                    tris[N_use]->id = -1;
                    comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                    inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                    Tri_on_side(tri,side) = tris[N_use];
                    Tri_on_side(tris[N_use],2) = tri;
                    tris[N_use]->BC_type = SUBDOMAIN;
                    set_side_bdry(Boundary_tri(tris[N_use]),0,NO);
                    set_side_bdry(Boundary_tri(tris[N_use]),1,NO);
                    set_side_bdry(Boundary_tri(tris[N_use]),2,NO); /// new
                    // The "tri" is not a boundary tri anymore
                    Boundary_tri(tri) = NO;

                    N_use++;
                    if(N_use == N_alloc)
                    {
                        if(N_row +1 >= 100)
                        {
                            printf("ERROR: attach_buffer_tris_ver2, exceed alloc. limit\n");
                            clean_up(ERROR);
                        }
                        vector(&tris, N_alloc, sizeof(TRI*));
                        row_tris[N_row] = tris;
                        N_row++;
                        N_use = 0;
                    }
                    ///////// END::::make image of tri....
                    ///////// make image of nbtri[1], which is adjacent to point p1 of tri.
                    for(j = 0; j < 3; j++)
                    {
                        if((fabs(Coords(p[1])[0] - Coords(newgp[1][j])[0]) < 1.0e-9 &&
                            fabs(Coords(p[1])[1] - Coords(newgp[1][j])[1]) < 1.0e-9
                           ) ||
                           (fabs(Coords(newgp[0][2])[0] - Coords(newgp[1][j])[0]) < 1.0e-9 &&
                            fabs(Coords(newgp[0][2])[1] - Coords(newgp[1][j])[1]) < 1.0e-9
                           )
                          )
                        {
                            NULL;
                        }
                        else
                            break;
                    }
                    // newtri[1] = tris[N_use] = i_make_tri(p[1],newgp[0][2],newgp[1][j], NULL,NULL,NULL,YES);
                    // tris[N_use]->id = -1;
                    // comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                    // inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                    // Tri_on_side(newtri[1],0) = newtri[0];
                    // Tri_on_side(newtri[0],2) = newtri[1];
                    // tris[N_use]->BC_type = SUBDOMAIN;
                    // set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                    // set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                    newtri[1] = tris[N_use] = i_make_tri(p[1],newgp[0][2],newgp[1][j], NULL,NULL,NULL,YES);
                    tris[N_use]->id = -1;
                    comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                    inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);

                    Tri_on_side(newtri[1],0) = newtri[0];
                    // Tri_on_side(newtri[0],2) = newtri[1];
                    Tri_on_side(newtri[0],1) = newtri[1];
                    // set_side_bdry(Boundary_tri(newtri[0]),2,NO); /// new
                    tris[N_use]->BC_type = SUBDOMAIN;

                    /**
                    set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                    set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                    **/
                    set_side_bdry(Boundary_tri(tris[N_use]),0,NO);
                    set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                    set_side_bdry(Boundary_tri(tris[N_use]),2,YES);
                    // Bond_tri_on_side(tris[N_use],0) = Bond_tri_on_side(tris[N_use],1) 
                    //                                 = Bond_tri_on_side(tris[N_use],2) = NULL;

                    N_use++;
                    if(N_use == N_alloc)
                    {
                        if(N_row +1 >= 100)
                        {
                            printf("ERROR: attach_buffer_tris_ver2, exceed alloc. limit\n");
                            clean_up(ERROR);
                        }
                        vector(&tris, N_alloc, sizeof(TRI*));
                        row_tris[N_row] = tris;
                        N_row++;
                        N_use = 0;
                    }
                    ///////// END::::make image of nbtri[1], which is adjacent to point p1 of tri.
                    ///////// make image of nbtri[2], which is adjacent to point p0 of tri.
                    for(j = 0; j < 3; j++)
                    {
                        if((fabs(Coords(p[0])[0] - Coords(newgp[2][j])[0]) < 1.0e-9 &&
                            fabs(Coords(p[0])[1] - Coords(newgp[2][j])[1]) < 1.0e-9
                           ) ||
                           (fabs(Coords(newgp[0][2])[0] - Coords(newgp[2][j])[0]) < 1.0e-9 &&
                            fabs(Coords(newgp[0][2])[1] - Coords(newgp[2][j])[1]) < 1.0e-9
                           )
                          )
                        {
                            NULL;
                        }
                        else
                            break;
                    }
                    // newtri[2] = tris[N_use] = i_make_tri(p[0],newgp[2][j],newgp[0][2],NULL,NULL,NULL,YES);
                    // tris[N_use]->id = -1;
                    // comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                    // inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                    // Tri_on_side(newtri[0],1) = newtri[2];
                    // Tri_on_side(newtri[2],2) = newtri[0];
                    // tris[N_use]->BC_type = SUBDOMAIN;
                    // set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                    // set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                    newtri[2] = tris[N_use] = i_make_tri(p[0],newgp[2][j],newgp[0][2],NULL,NULL,NULL,YES);
                    tris[N_use]->id = -1;
                    comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                    inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                    // Tri_on_side(newtri[0],1) = newtri[2];
                    Tri_on_side(newtri[0],0) = newtri[2];
                    Tri_on_side(newtri[2],2) = newtri[0];
                    tris[N_use]->BC_type = SUBDOMAIN;
                    set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                    set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                    set_side_bdry(Boundary_tri(tris[N_use]),2,NO);
                    // Bond_tri_on_side(tris[N_use],0) = Bond_tri_on_side(tris[N_use],1)                    
                    //                                 = Bond_tri_on_side(tris[N_use],2) = NULL;

                    N_use++;
                    if(N_use == N_alloc)
                    {
                        if(N_row +1 >= 100)
                        {
                            printf("ERROR: attach_buffer_tris_ver2, exceed alloc. limit\n");
                            clean_up(ERROR);
                        }
                        vector(&tris, N_alloc, sizeof(TRI*));
                        row_tris[N_row] = tris;
                        N_row++;
                        N_use = 0;
                    }
                    ///////// END::::make image of nbtri[2], which is adjacent to point p0 of tri.
                    ////// end new code
                }
            }
            // insert tris to the surface
            for(i = 0; i < N_row; i++)
            {
                if(i == N_row-1)
                    N = N_use;
                else
                    N = N_alloc;
                for(j = 0; j < N; j++)
                {
                    insert_tri_at_tail_of_list(row_tris[i][j],*surf);
                }
            }
        }

        set_current_interface(current_intfc);
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);


        for(i = 0; i < N_row; i++)
            free(row_tris[i]);

        output_tri_mesh("visual", 0, fr->mesh);
        // printf("EXIT in attach_buffer_tris_ver2()\n");
        // clean_up(0);
}

EXPORT void clip_tris_to_subdomain(
	Front   *fr)
{
        RECT_GRID *gr = fr->rect_grid;
        float     l[MAXD],u[MAXD], diam;
        int       dir, dim = gr->dim, remove_flag, tri_num = 0, total = 0;
        TRI       *tri, *nbtri[3];
        SURFACE   **s;
        TRI       **tris, **row_tris[2500];
        int       N_alloc = 800, N_row, N_use = 0, N, i, j, k;
        POLYGON   *polyg;

        print_rectangular_grid(fr->rect_grid);

        vector(&tris, N_alloc, sizeof(TRI*));
        row_tris[0] = tris;
        N_row = 1;

        for(s= fr->mesh->surfaces; s&& *s; s++)
        {
            for (tri = first_tri(*s); !at_end_of_tri_list(tri,*s);
                tri = tri->next)
            {
                diam = fg_length_side(tri)[0];
                break;
            }
        }

        pp_global_max(&diam, 1);

        for (dir = 0; dir < dim; ++dir)
        {
            // l[dir] = gr->L[dir] - 0.0005;
            // u[dir] = gr->U[dir] + 0.0005;
            l[dir] = gr->L[dir] - 8.0*diam;
            u[dir] = gr->U[dir] + 8.0*diam;
        }

        printf("clip rect_size, x[%g %g], y[%g %g]\n", l[0], u[0], l[1], u[1]);
        fflush(stdout);
        // printf("front rect_side, x[%g %g], y[%g %g]\n", gr->L[0], gr->U[0], gr->L[1], gr->U[1]);
        printf("clip_tris_to_subdomain, mem = %dK\n", get_vmalloc_storage_use()/1000);


        for (s = fr->mesh->surfaces; s && *s; ++s)
        {
            for (tri=first_tri(*s); !at_end_of_tri_list(tri,*s); tri=tri->next)
            {
                if (tri_out_rect(tri,l,u))
                {
                    /*
                    // printf("tri[%d] outside domain\n", tri->id);
                    for(dir = 0; dir < 3; dir++)
                        nbtri[dir] = Tri_on_side(tri,dir);
 
                    remove_flag = YES;
                    for(dir = 0; dir < 3; dir++)
                    {
                        if(nbtri[dir] != NULL && tri_out_rect(nbtri[dir],l,u) == NO)
                        {
                            remove_flag = NO; 
                            break;
                        }
                    }

                    if(remove_flag == YES)
                        remove_out_domain_tri(tri,*s);
                    */
                    // Do not remove the attached buffers
                    // if(tri->BC_type != SUBDOMAIN)
                        // remove_out_domain_tri(tri,*s);
                    remove_out_rect_tri(tri,*s);
                    tris[N_use] = tri;
                    N_use++;
                    if(N_use == N_alloc)
                    {
                        if(N_row +1 >= 2500)
                        {
                            printf("ERROR: clip_tris_to_subdomain, exceed alloc. limit\n");
                            clean_up(ERROR);
                        }
                        vector(&tris, N_alloc, sizeof(TRI*));
                        row_tris[N_row] = tris;
                        N_row++;
                        N_use = 0;
                    }
                }
            }
        }

        /// Need to remove tri-polygon correspondence
        for(i = 0; i < N_row; i++)
        {
            if(i == N_row-1)
                N = N_use;
            else
                N = N_alloc;
            for(j = 0; j < N; j++)
            {
                for(k = 0; k < 3; k++)
                {
                    polyg = fg_polyg_at_tri_vert(row_tris[i][j])[k];
                    if(NULL != polyg)
                    {
                        for(int tmpi = 0; tmpi < polyg->n_sides; tmpi++)
                        {
                            if(row_tris[i][j] == tri_at_polyg_vert(polyg)[tmpi])
                            {
                                tri_at_polyg_vert(polyg)[tmpi] = NULL;
                                break;
                            }
                        }
                    }
                    fg_polyg_at_tri_vert(row_tris[i][j])[k] = NULL;
                }
            }
        }

        /// free un-used tris
        for(i = 0; i < N_row; i++)
        {
            if(i == N_row-1)
                N = N_use;
            else
                N = N_alloc;
            for(j = 0; j < N; j++)
                free(row_tris[i][j]);
            free(row_tris[i]);
        }

        for (s = fr->mesh->surfaces; s && *s; ++s)
        {
            for (tri=first_tri(*s); !at_end_of_tri_list(tri,*s); tri=tri->next)
            {
                total++;
                if (tri_out_rect(tri,gr->L,gr->U) == NO)
                {
                    tri_num++;

                    for(dir = 0; dir < 3; dir++)
                    { 
                        nbtri[dir] = Tri_on_side(tri,dir);

                        if(nbtri[dir] == NULL)
                        {
                            printf("ERROR: interior tri has null neighbr on side %d\n", dir);
                            print_tri_crds(tri);
                            clean_up(ERROR);
                        }
                    }
                }
                else
                {
                    tri->BC_type = SUBDOMAIN;
                }
            }

            (*s)->num_tri = total;
        }

        printf("END clip_tris_to_subdomain, number of interior tris = %d, total = %d,mem = %dK\n",
              tri_num, total,get_vmalloc_storage_use()/1000);
        output_tri_mesh("visual",0,fr->mesh);
        // clean_up(0);
}

/**
LOCAL bool tri_out_rect(
        TRI             *tri,
        float           *L,
        float           *U)
{
        float           *cent;

        cent = fg_centroid(tri);
        if(cent[0] < L[0] || cent[0] > U[0])
            return YES;
        if(cent[1] < L[1] || cent[1] > U[1])
            return YES;
        return NO;
}       
**/

LOCAL void remove_out_rect_tri(
        TRI             *tri,
        SURFACE         *s)
{
        TRI             *nbtri;
        int             i;

        for (i = 0; i < 3; ++i)
        {
            if (!is_side_bdry(tri,i))
            {
                nbtri = Tri_on_side(tri,i);
                if (nbtri != NULL)
                {
                    if (Tri_on_side01(nbtri) == tri)
                        Tri_on_side01(nbtri) = NULL;
                    else if (Tri_on_side12(nbtri) == tri)
                        Tri_on_side12(nbtri) = NULL;
                    else if (Tri_on_side20(nbtri) == tri)
                        Tri_on_side20(nbtri) = NULL;
                }
            }
        }
        tmp_remove_tri_from_surface(tri,s);
}               /*end remove_out_domain_tri*/


LOCAL  void    tmp_remove_tri_from_surface(
        TRI     *tri,
        SURFACE *s)
{
        int i,j;

        if (tri == NULL)
            return;

        free(tri->Lmass_matrix);
        if(tri->mass_inv != NULL)
            free(tri->mass_inv);
        // free_these(2,tri->Lmass_matrix,tri->mass_inv);
        free(tri->st);
        if(tri->CVmass_matrix != NULL)
            free(tri->CVmass_matrix);
        if(tri->cv_soln != NULL)
            free(tri->cv_soln);

        --s->num_tri;
        if (tri == first_tri(s))
        {
            first_tri(s) = tri->next;
            first_tri(s)->prev = head_of_tri_list(s);
        }
        else
            tri->prev->next = tri->next;
        if (tri == last_tri(s))
        {
            last_tri(s) = tri->prev;
            last_tri(s)->next = tail_of_tri_list(s);
        }
        else
            tri->next->prev = tri->prev;
        for (i = 0; i < 3; ++i)
        {
            if (is_side_bdry(tri,i))
            {
                NULL;
            }
            else
            {
                TRI *nbtri = Tri_on_side(tri,i);
                if (nbtri != NULL)
                {
                    for (j = 0; j < 3; ++j)
                    {
                        if (Tri_on_side(nbtri,j) == tri)
                        {
                            Tri_on_side(nbtri,j) = NULL;
                            break;
                        }
                    }
                }
            }
            Neighbor_on_side(tri,i) = NULL;
            Tri_workspace(tri) = NULL;
        }
}               /*end tmp_remove_tri_from_surface*/


EXPORT void clip_polygons_to_subdomain(
	Front   *fr)
{
        RECT_GRID *gr = fr->rect_grid;
        float     l[MAXD],u[MAXD], diam;
        int       dir, dim = gr->dim, remove_flag, tri_num = 0, total = 0;
        TRI       *tri, *nbtri[3];
        SURFACE   **surf;
        int       N_alloc = 800, N_row, N_use = 0, N, i, j, k, crsp_tri_flag, side;
        POLYGON   *polyg;
        POLYGON   **polygs, **row_polygs[2500]; 

        print_rectangular_grid(fr->rect_grid);
                
        vector(&polygs, N_alloc, sizeof(POLYGON*));
        row_polygs[0] = polygs;
        N_row = 1;

        for(surf = fr->mesh->surfaces; surf && *surf ; surf ++)
        {
            for (tri = first_tri(*surf ); !at_end_of_tri_list(tri,*surf );
                tri = tri->next)
            {
                diam = fg_length_side(tri)[0];
                break;
            }
        }

        pp_global_max(&diam, 1);

        for (dir = 0; dir < dim; ++dir)
        {
            l[dir] = gr->L[dir] - 8.0*diam;
            u[dir] = gr->U[dir] + 8.0*diam;
        }

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (polyg = first_polyg(*surf); !at_end_of_polyg_list(polyg,*surf); polyg = polyg->next)
            {

                // 02/02/2016 ADD
                //  make sure tris are always on vertices of polygon
                crsp_tri_flag = YES;
                for(side = 0; side < polyg->n_sides; side++)
                {
                    if(NULL == tri_at_polyg_vert(polyg)[side])
                    {
                        crsp_tri_flag = NO;
                        break;
                    }
                }
                // END::02/02/2016 ADD

                // if(polyg_out_rect(polyg,l,u))
                if(polyg_out_rect(polyg,l,u) || NO == crsp_tri_flag)
                {
                    remove_out_rect_polygon(polyg, *surf);
                    polygs[N_use] = polyg;
                    N_use++;
                    if(N_use == N_alloc)
                    {
                        if(N_row +1 >= 2500)
                        {
                            printf("ERROR: clip_polygons_to_subdomain, exceed alloc. limit\n");
                            clean_up(ERROR);
                        }
                        vector(&polygs, N_alloc, sizeof(POLYGON*));
                        row_polygs[N_row] = polygs;
                        N_row++;
                        N_use = 0;
                    }
                }
            }
        }

        /// NEED to remove correspondence between polygon and tri
        for(i = 0; i < N_row; i++)
        {
            if(i == N_row-1)
                N = N_use;
            else
                N = N_alloc;
            for(j = 0; j < N; j++)
            {
                for(k =0; k < row_polygs[i][j]->n_sides; k++)
                {
                    tri = tri_at_polyg_vert(row_polygs[i][j])[k]; 
                    if(NULL != tri)
                    {
                        for(int tmpi = 0; tmpi < 3; tmpi++)
                        {
                            if(row_polygs[i][j] == fg_polyg_at_tri_vert(tri)[tmpi])
                            {
                                fg_polyg_at_tri_vert(tri)[tmpi] = NULL;
                                break;
                            }
                        }
                    }
                    tri_at_polyg_vert(row_polygs[i][j])[k] = NULL;
                }  
            }
        }
 
        /// free un-used polygons
        for(i = 0; i < N_row; i++)
        {
            if(i == N_row-1)
                N = N_use;
            else
                N = N_alloc;
            for(j = 0; j < N; j++)
                free(row_polygs[i][j]);
            free(row_polygs[i]);
        }
}

LOCAL void remove_out_rect_polygon(
        POLYGON     *polyg,
        SURFACE     *surf)
{
        int          i, k;
        POLYGON      *nbpolyg;

        for(i = 0; i < polyg->n_sides; i++)
        {
            nbpolyg = Polyg_on_side(polyg, i);
            if(NULL != nbpolyg)
            {
                for(k = 0; k < nbpolyg->n_sides; k++)
                {
                    if(polyg == Polyg_on_side(nbpolyg, k))
                    {
                        Polyg_on_side(nbpolyg, k) = NULL;
                        break;
                    }
                }
            }
        }

        tmp_remove_polygon_from_surface(polyg,surf);
}

LOCAL  void    tmp_remove_polygon_from_surface(
        POLYGON     *polyg,
        SURFACE     *surf)
{
        int         i, j, n_sides, nb_n_sides;
        POLYGON     *nbpolyg;

        if (polyg == NULL)
            return;
        n_sides = polyg->n_sides;

        if(NULL != polyg->_piece_cent)
            free(polyg->_piece_cent);
        if(NULL != polyg->_piece_sqrt_area)
            free(polyg->_piece_sqrt_area);
        if(NULL != polyg->mass_edge)
            free(polyg->mass_edge);

        --surf->num_polyg;

        if (polyg == first_polyg(surf))
        {
            first_polyg(surf) = polyg->next;
            first_polyg(surf)->prev = head_of_polyg_list(surf);
        }
        else
            polyg->prev->next = polyg->next;

        if(polyg == last_polyg(surf))
        {
            last_polyg(surf) = polyg->prev;
            last_polyg(surf)->next = tail_of_polyg_list(surf);
        }
        else
            polyg->next->prev = polyg->prev;

        for (i = 0; i < n_sides; ++i)
        {
            nbpolyg = Polyg_on_side(polyg,i);
            if(NULL != nbpolyg)
            {
                nb_n_sides = nbpolyg->n_sides;
                for(j = 0; j < nb_n_sides; j++)
                {
                    if(polyg == Polyg_on_side(nbpolyg,j))
                    {
                        Polyg_on_side(nbpolyg,j) = NULL;
                        break;
                    }
                }
            }

            polyg->private_data._workspace = NULL;
        }
}


LOCAL void perturb_struc_triangle(
        Front           *front,
        POINT           ***p,
        int             BC_type)
{
        RECT_GRID   *gr = front->rect_grid;
        INTERFACE           *intfc;
        SURFACE             **surf;
        int                 ix, iy, imax, jmax, icrds[3];
        double              nor[2], tmp, rad, *pcrds, disp[2];
        POINT               *pt, *pt2;
        TRI                 *tri;

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];
        rad = 0.237*gr->h[0];

	// srand((unsigned)time(NULL));
	srand(314159265);
 
        for(iy = 1; iy < gr->gmax[1]; iy++)
        {
            icrds[1] = gr->lbuf[1] + iy;
            for(ix = 1; ix < gr->gmax[0]; ix++)
            {
               tmp = RNG();
               nor[0] = cos(tmp*2.0*PI);
               nor[1] = sin(tmp*2.0*PI);
               // tmp = RNG()*rad;
               tmp *= rad;
               disp[0] = tmp*nor[0];  
               disp[1] = tmp*nor[1];  

               icrds[0] = gr->lbuf[0] + ix;

               // pt = p[icrds[0]][icrds[1]];
               pcrds = Coords(p[icrds[0]][icrds[1]]);
               pcrds[0] += disp[0];
               pcrds[1] += disp[1];
            }
        }

        if(PERIODIC_BOUNDARY == BC_type)
        {
            // Left side
            for(ix = 0; ix < gr->lbuf[0]; ix++)
            {
                icrds[0] = ix;
                for(iy = 1; iy < gr->gmax[1]; iy++)
                {
                    icrds[1] = gr->lbuf[1] + iy;
                    pt  = p[icrds[0]][icrds[1]];
                    pt2 = p[icrds[0]+gr->gmax[0]][icrds[1]]; 
                    Coords(pt)[0] = Coords(pt2)[0] - (gr->U[0] - gr->L[0]);
                    Coords(pt)[1] = Coords(pt2)[1];
                }
            }  
            // right side
            for(ix = gr->gmax[0]+1; ix <= gr->gmax[0] + gr->ubuf[0]; ix++)
            {
                icrds[0] = ix + gr->lbuf[0];
                for(iy = 1; iy < gr->gmax[1]; iy++)
                {
                    icrds[1] = gr->lbuf[1] + iy;
                    pt  = p[icrds[0]][icrds[1]];
                    pt2 = p[icrds[0]-gr->gmax[0]][icrds[1]];
                    Coords(pt)[0] = Coords(pt2)[0] + (gr->U[0] - gr->L[0]);
                    Coords(pt)[1] = Coords(pt2)[1];
                }
            }
            // top side
            // for(ix = 1; ix < gr->gmax[0]; ix++)
            for(ix = 0; ix <= gr->gmax[0] + gr->lbuf[0] + gr->ubuf[0]; ix++)
            {
                // icrds[0] = gr->lbuf[0] + ix;
                icrds[0] = ix;
                for(iy = gr->gmax[1]+1; iy <= gr->gmax[1] + gr->ubuf[1]; iy++)
                { 
                    icrds[1] = gr->lbuf[1] + iy;
                    pt  = p[icrds[0]][icrds[1]];
                    pt2 = p[icrds[0]][icrds[1]-gr->gmax[1]];
                    Coords(pt)[0] = Coords(pt2)[0];
                    Coords(pt)[1] = Coords(pt2)[1] + (gr->U[1] - gr->L[1]);
                }
            }
            // bottom side
            // for(ix = 1; ix < gr->gmax[0]; ix++)
            for(ix = 0; ix <= gr->gmax[0] + gr->lbuf[0] + gr->ubuf[0]; ix++)
            {
                // icrds[0] = gr->lbuf[0] + ix;
                icrds[0] = ix;
                for(iy = 0; iy < gr->lbuf[1]; iy++)
                {
                    icrds[1] = iy;
                    pt  = p[icrds[0]][icrds[1]];
                    pt2 = p[icrds[0]][icrds[1]+gr->gmax[1]];
                    Coords(pt)[0] = Coords(pt2)[0];
                    Coords(pt)[1] = Coords(pt2)[1] - (gr->U[1] - gr->L[1]);
                }
            }
        }
        else
        {
            printf("ERROR: perturb_struc_triangle(), implement for other boundary type\n");
            clean_up(ERROR);
        }

        // i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        // set_comput_tri_geom_flag(YES);

        for(surf = front->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                set_normal_of_tri(tri);
                comp_mass_matrix(MAX_N_COEF,tri,2,tri->Lmass_matrix);
                inverse_matrix(tri->Lmass_matrix,MAX_N_COEF,tri->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri,2,tri->Bmass_matrix);
                inverse_matrix(tri->Bmass_matrix,MAX_N_COEF,tri->Bmass_inv);
            }
        }
        // set_comput_tri_geom_flag(NO);
}



LOCAL void parallel_perturb_struc_triangle(
        Front           *front,
        POINT           ***p)
{
        RECT_GRID   *gr = front->rect_grid;
        INTERFACE           *intfc;
        SURFACE             **surf;
        int                 ix, iy, imax, jmax, icrds[3];
        double              nor[2], tmp, rad, *pcrds, disp[2];
        POINT               *pt, *pt2;
        TRI                 *tri;
        PP_GRID    *pp_grid = front->pp_grid;
        int         myid;
        int         me[MAXD];
        int         side, dim = 2, dir;

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];
        rad = 0.225*gr->h[0];

        srand(314159265 + pp_mynode());
        // srand(314159265);

        for(iy = 1; iy < gr->gmax[1]; iy++)
        {
            icrds[1] = gr->lbuf[1] + iy;
            for(ix = 1; ix < gr->gmax[0]; ix++)
            {
               tmp = RNG();
               nor[0] = cos(tmp*2.0*PI);
               nor[1] = sin(tmp*2.0*PI);
               // tmp = RNG()*rad;
               tmp *= rad;
               disp[0] = tmp*nor[0];
               disp[1] = tmp*nor[1];

               icrds[0] = gr->lbuf[0] + ix;

               // pt = p[icrds[0]][icrds[1]];
               pcrds = Coords(p[icrds[0]][icrds[1]]);
               pcrds[0] += disp[0];
               pcrds[1] += disp[1];
            }
        }

        myid = pp_mynode();
        dim = front->rect_grid->dim;
        find_Cartesian_coordinates(myid,pp_grid,me);

        for(dir = 0; dir < dim; dir++)
        {
            for (side = 0; side < 2; ++side)
            {
                pp_gsync();
                pp_send_interior_point_crds(me,dir,side,front,p);
                pp_receive_interior_point_crds(me,dir,(side+1)%2,front,p);
            }
        }

        // i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        // set_comput_tri_geom_flag(YES);
        for(surf = front->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                set_normal_of_tri(tri);
                comp_mass_matrix(MAX_N_COEF,tri,2,tri->Lmass_matrix);
                inverse_matrix(tri->Lmass_matrix,MAX_N_COEF,tri->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri,2,tri->Bmass_matrix);
                inverse_matrix(tri->Bmass_matrix,MAX_N_COEF,tri->Bmass_inv);

                //// TMP
                /***
                if(tri->id == 114)
                {
                    printf("\nparallel_perturb_struc_triangle(), after perturbation\n");
                    print_tri_crds(tri);
                    printf("---------------------\n\n");
                }
                ***/
            }
        }
}

LOCAL void pp_send_interior_point_crds(
        int             *me,
        int             dir,
        int             side,
        Front           *front,
        POINT           ***p)
{
        INTERFACE     *intfc = front->interf;
        PP_GRID       *pp_grid = front->pp_grid;
        RECT_GRID     *gr = front->rect_grid;
        int           L[MAXD], U[MAXD];
        int           i, ix, iy, icrds[MAXD];
        int           him[MAXD];
        int           myid, dst_id, send_num;
        int           num_tris;
        size_t        len;
        byte          *buf, *ps;
        byte          *storage = NULL;
        float         *pcrds;
        Locstate      state;

        if (rect_boundary_type(intfc,dir,side) == REFLECTION_BOUNDARY)
        {
            printf("ERROR: pp_send_interior_point_crds\n");
            printf("Implement  reflect_fields_across_domain\n");
            clean_up(ERROR);
            return;
        }
        if (rect_boundary_type(intfc,dir,side) != SUBDOMAIN_BOUNDARY)
            return;

        myid = pp_mynode();
        dst_id = neighbor_id(him,me,dir,side,pp_grid);
        if (myid == dst_id)
        {
            printf("ERROR: pp_send_interior_point_crds\n");
            printf("Implement  copy_fields_across_domain\n");
            clean_up(ERROR);
            return;
        }

        local_set_send_domain(L,U,dir,side,gr);

        len = sizeof(float)*(U[1]-L[1]+1)*(U[0]-L[0]+1)*2;
        scalar(&storage, len);
        buf = storage;

        for(iy = L[1]; iy <= U[1]; iy++)
        {
            icrds[1] = gr->lbuf[1] + iy;
            for(ix = L[0]; ix <= U[0]; ix++)
            {
                state = (Locstate)buf;
                icrds[0] = ix + gr->lbuf[0];
                pcrds = Coords(p[icrds[0]][icrds[1]]);
                assign(state,pcrds,sizeof(float)*2);
                buf+= sizeof(float)*2;
            }
        }

        for (ps = storage, i = 0; len >= BLOCK_SIZE;
                                len -= BLOCK_SIZE, ps += BLOCK_SIZE, ++i)
        {
            pp_send(state_id(i),(POINTER)ps,BLOCK_SIZE,dst_id);
        }
        if (len != 0)
            pp_send(state_id(i),(POINTER)ps,len,dst_id);

        free(storage);
}

LOCAL   void    local_set_receive_domain(
        int             *L,
        int             *U,
        int             dir,
        int             side,
        RECT_GRID       *gr)
{
        int             dim = gr->dim;
        int             *lbuf = gr->lbuf;
        int             *ubuf = gr->ubuf;
        int             *gmax = gr->gmax;
        int             j;

        for (j = 0; j < dir; ++j)
        {
            L[j] = -lbuf[j];
            U[j] = gmax[j] + ubuf[j];
        }
        if (side == 0)
        {
            L[dir] = -lbuf[dir];
            U[dir] = 0;
        }
        else
        {
            L[dir] = gmax[dir];
            U[dir] = gmax[dir] + ubuf[dir];
        }

        for (j = dir+1; j < dim; ++j)
        {
            L[j] = -lbuf[j];
            U[j] = gmax[j] + ubuf[j];
        }
        if (DEBUG)
        {
            (void) printf("swp = %d, side = %d, ",dir,side);
            print_int_vector("L = ",L,dim,", ");
            print_int_vector("U = ",U,dim,"\n");
        }
}               /*end set_receive_domain*/


/// TMP, copied from hscatter.
LOCAL   void    local_set_send_domain(
        int           *L,
        int           *U,
        int           dir,
        int           side,
        RECT_GRID     *gr)
{

        int             dim = gr->dim;
        int             *lbuf = gr->lbuf;
        int             *ubuf = gr->ubuf;
        int             *gmax = gr->gmax;
        int             j;

        for (j = 0; j < dir; ++j)
        {
            L[j] = -lbuf[j];
            U[j] = gmax[j] + ubuf[j];
        }

        if (side == 0)
        {
            L[dir] = 0;
            U[dir] = lbuf[dir];
        }
        else
        {
            L[dir] = gmax[dir] - ubuf[dir];
            U[dir] = gmax[dir];
        }

        for (j = dir+1; j < dim; ++j)
        {
            L[j] = -lbuf[j];
            U[j] = gmax[j]+ubuf[j];
        }
}

LOCAL void pp_receive_interior_point_crds(
        int             *me,
        int             dir,
        int             side,
        Front           *front,
        POINT           ***p)
{
        INTERFACE     *intfc = front->interf;
        PP_GRID       *pp_grid = front->pp_grid;
        RECT_GRID     *gr = front->rect_grid;
        int           L[MAXD], U[MAXD];
        int           him[MAXD];
        int           myid, src_id;
        int           dim = gr->dim;
        int           i, j, k, ix, iy, icrds[MAXD];
        size_t        len;
        byte          *buf, *ps;
        byte          *storage = NULL;
        Locstate      state, st;
        int           IS_PER_BUF = YES, src_side;
        float         *pcrds, shifted_crds[2];
        double        shift_offset[3];
        int           debug = NO;

        if (rect_boundary_type(intfc,dir,side) != SUBDOMAIN_BOUNDARY)
        {
            return;
        }

        myid = pp_mynode();
        src_id = neighbor_id(him,me,dir,side,pp_grid);
        if (myid == src_id)
        {
            return; /* Already done */
        }

        ///// Distinguish between interior subdomain buffer and
        ///// Periodic BC buffer. 
        ///// Assume me and him share interior subdomain boundary.
        ///// This is to calculate the src side for interior subdomain
        if(side == 0)
            src_side = 1;
        else
            src_side = 0;
        if((me[dir]+side) == (him[dir]+src_side))
            IS_PER_BUF = NO;
        else
        {
            /// calculate the shift needed to correct the position of received tris.
            shift_offset[0] = shift_offset[1] = 0.0;
            if(me[dir] == 0)
            {
                shift_offset[dir] = gr->GL[dir] - gr->GU[dir];
            }
            else if((pp_grid->gmax[dir]-1) == me[dir])
            {
                shift_offset[dir] = gr->GU[dir] - gr->GL[dir];
            }
            else
            {
                printf("ERROR: pp_receive_interior_point_crds(), error in computing shift_offset\n");
                printf("Node[%d] dir[%d] side[%d] receive "
                   " from node[%d]'s side[%d]  periodic_BC = %d\n",
                     myid, dir, side, src_id,src_side, IS_PER_BUF);
                printf("Me[%d %d], pp_grid L[%d, %d], U[%d, %d]\n",
                           me[0], me[1], 0,0, pp_grid->gmax[0], pp_grid->gmax[1]);
                clean_up(ERROR);
            }
        }
        ////////////////////////////////////

        local_set_receive_domain(L, U, dir, side, gr);

        len = sizeof(float)*(U[1]-L[1]+1)*(U[0]-L[0]+1)*2;
        scalar(&storage, len);
        buf = storage;

        for (ps = storage, i = 0; len >= BLOCK_SIZE;
                                len -= BLOCK_SIZE, ps += BLOCK_SIZE,++i)
        {
            pp_recv(state_id(i),src_id,(POINTER)ps,BLOCK_SIZE);
        }
        if (len != 0)
            pp_recv(state_id(i),src_id,(POINTER)ps,len);

        if(NO == IS_PER_BUF)
        {
            for(iy = L[1]; iy <= U[1]; iy++)
            {
                icrds[1] = gr->lbuf[1] + iy;
                for(ix = L[0]; ix <= U[0]; ix++)
                {
                    state = (Locstate)buf;
                    icrds[0] = ix + gr->lbuf[0];
                    pcrds = Coords(p[icrds[0]][icrds[1]]);
                    assign(pcrds,state,sizeof(float)*2);

                    buf+= sizeof(float)*2;
                }
            }
        }
        else
        {
            for(iy = L[1]; iy <= U[1]; iy++)
            {
                icrds[1] = gr->lbuf[1] + iy;
                for(ix = L[0]; ix <= U[0]; ix++)
                {
                    state = (Locstate)buf;
                    icrds[0] = ix + gr->lbuf[0];
                    pcrds = Coords(p[icrds[0]][icrds[1]]);
                    assign(pcrds,state,sizeof(float)*2);

                    for(k = 0; k < dim; k++)
                        pcrds[k] += shift_offset[k];

                    buf+= sizeof(float)*2;
                }
            }
        }

        free(storage);
}

EXPORT TRI **init_four_triangle_in_rect_cell(
        Front           *front,
        int             *tri_num)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri, **all_tris;
        POINT     ***p, *pt[5], *midp, *corner, ***centp;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR init_four_triangle_in_rect_cell\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_four_triangle_in_rect_cell\n");
        print_rectangular_grid(gr);
        // clean_up(0);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,4,sizeof(TRI *));

        matrix(&centp,imax,jmax,sizeof(POINT *));

        vector(&all_tris, imax*jmax*4, sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }

        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                coords[0] = vd_cell_edge(ix+0.5,0,gr);
                coords[1] = vd_cell_edge(iy+0.5,1,gr);
                coords[2] = 0.0;
                centp[ix][iy] = Point(coords);
            }
        }

        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];
                pt[4] = centp[ix][iy]; 

                tri[ix][iy][0] = i_make_tri(pt[0],pt[1],pt[4],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][0]->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][0]->Bmass_inv);

                tri[ix][iy][0]->id = num_tri;
                /// NEW
                all_tris[num_tri] = tri[ix][iy][0];
                /// END NEW
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][0],s);

                /**********************************/

                tri[ix][iy][1] = i_make_tri(pt[1],pt[2],pt[4],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][1]->mass_inv);

                //// NEW, for Magnetic field
                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][1]->Bmass_inv);

                tri[ix][iy][1]->id = num_tri;
                /// NEW
                all_tris[num_tri] = tri[ix][iy][1];
                /// END NEW
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][1],s);

                /**********************************/
                tri[ix][iy][2] = i_make_tri(pt[2],pt[3],pt[4],
                                          NULL,NULL,NULL,YES);

                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][2],2,tri[ix][iy][2]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][2]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][2]->mass_inv);

                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][2],2,tri[ix][iy][2]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][2]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][2]->Bmass_inv);

                tri[ix][iy][2]->id = num_tri;
                all_tris[num_tri] = tri[ix][iy][2];
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][2],s);

                /**********************************/
                tri[ix][iy][3] = i_make_tri(pt[3],pt[0],pt[4],
                                          NULL,NULL,NULL,YES);

                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][3],2,tri[ix][iy][3]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][3]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][3]->mass_inv);

                comp_Mag_mass_matrix(MAX_N_COEF,tri[ix][iy][3],2,tri[ix][iy][3]->Bmass_matrix);
                inverse_matrix(tri[ix][iy][3]->Bmass_matrix,MAX_N_COEF,tri[ix][iy][3]->Bmass_inv);

                tri[ix][iy][3]->id = num_tri;
                all_tris[num_tri] = tri[ix][iy][3];
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][3],s);
               
            }
        }

        *tri_num = num_tri;

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                Boundary_tri(tri[ix][iy][0]) = NO;
                Boundary_tri(tri[ix][iy][1]) = NO;
                Boundary_tri(tri[ix][iy][2]) = NO;
                Boundary_tri(tri[ix][iy][3]) = NO;

                if (iy != 0)
                {
                    // south
                    Tri_on_side01(tri[ix][iy][0]) = tri[ix][iy-1][2];
                    // TMP
                    // print_tri(tri[ix][iy][0],intfc);
                }
                if(ix !=(imax-1))
                {
                    // east
                    Tri_on_side01(tri[ix][iy][1]) = tri[ix+1][iy][3];
                }
                if(iy !=(jmax-1))
                {
                    // north
                    Tri_on_side01(tri[ix][iy][2]) = tri[ix][iy+1][0];
                }
                if(ix != 0)
                {
                    // west
                    Tri_on_side01(tri[ix][iy][3]) = tri[ix-1][iy][1];
                }
                Tri_on_side12(tri[ix][iy][0]) = tri[ix][iy][1];
                Tri_on_side20(tri[ix][iy][0]) = tri[ix][iy][3];

                Tri_on_side12(tri[ix][iy][1]) = tri[ix][iy][2];
                Tri_on_side20(tri[ix][iy][1]) = tri[ix][iy][0];

                Tri_on_side12(tri[ix][iy][2]) = tri[ix][iy][3];
                Tri_on_side20(tri[ix][iy][2]) = tri[ix][iy][1];

                Tri_on_side12(tri[ix][iy][3]) = tri[ix][iy][0];
                Tri_on_side20(tri[ix][iy][3]) = tri[ix][iy][2];
            }
        }

        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    if(iy == 0 && i == 0)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }

                    if(iy == jmax-1 && i == 2)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                    if(ix == 0 && i == 3)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                }
            }
        }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                 tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);
            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {   
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // num_tri++;
        }
        s->num_tri = num_tri;
        // TMP
        // printf("num_tri = %d\n", num_tri);

        if(!debugging("field_loop"))
        {
#if defined(__MPI__)
            BLOCK_SIZE = GetHypPPBlockSize();
            parallel_perturb_struc_triangle(front, p);
#else
            perturb_struc_triangle(front, p, PERIODIC_BOUNDARY);
#endif // if defined(__MPI__)
        }

        free(p);
        free(tri); free(centp); 
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);


#if !defined(_MPI_)
        output_tri_mesh("visual",0,front->mesh);
#endif // if !defined(_MPI_)

        // printf("EXIT **** Leaving init_diag_triangle_vortex_evo\n");
        // clean_up(0);

        return all_tris;
}


