/*
*                       doverlocaldecs.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       Frontier 3D amr interpolation function calls.
*/


#if !defined(_DOVERLOCALDECS_H)
#define _DOVERLOCALDECS_H

#include <driver/ddecs.h>

#if defined(USE_OVERTURE)
#if defined(TWOD) || defined(THREED)
#define normal_advance_front(dt,dt_frac,front,newfront,wave)                    \
        (*(front)->_normal_advance_front)(dt,dt_frac,front,newfront,wave)
#define tangnt_advance_front(dt,dt_frac,front,newfront,wave)                    \
        (*(front)->_tangnt_advance_front)(dt,dt_frac,front,newfront,wave)
#endif /* if defined(TWOD) || defined(THREED) */
#if defined(TWOD) 
#define redist_advance_front(dt,dt_frac,front,newfront,wave)                    \
        (*(front)->_redist_advance_front)(dt,dt_frac,front,newfront,wave)
#endif /* if defined(TWOD) */
#endif /* if defined(USE_OVERTURE) */

             /*  dmain.c */
IMPORT   void    set_modified_time_step(Grid*,Front*,Wave*,Printplot*,float);

#if defined(USE_OVERTURE)
/* doverturepatch.c */ 
IMPORT   void    show_grids_info(CompositeGrid&);
IMPORT   int     stop_adding_amr_grids(CompositeGrid,CompositeGrid);

/* doverturepatch2d.c */
#if defined(TWOD)
IMPORT   void    set_refinement_global2d(Front*);
IMPORT   int     perform_overture_init_mesh_refinement2d(CompositeGrid*,
                   doubleCompositeGridFunction*,CompositeGrid**,Overparam*,int);
IMPORT   void    Aug_compositegrid_by_error2d(doubleCompositeGridFunction&,CompositeGrid&,Overparam*);
IMPORT   void    pp_update_compositegrid2d(CompositeGrid&,doubleCompositeGridFunction&,Overparam*);
IMPORT   int     overture_perform_regrid2d(CHART*,Printplot*,CompositeGrid*,
                   doubleCompositeGridFunction*,CompositeGrid**,
                   doubleCompositeGridFunction**,int*);
IMPORT   void    init_patch_states2d(Wave*,Front*,INIT_DATA*, 
                   void(*)(float*,COMPONENT,Locstate,INTERFACE*,INIT_DATA*));
IMPORT   int     pseudo_advance_amr_fronts2d(Front***,float,float*,
                     Overparam*,Wave**,Front**,int,Wv_on_pc**,int);
#endif /* if defined(TWOD) */

/* doverturepatch3d.c */
#if defined(THREED)
IMPORT   void    set_refinement_global3d(Front*);
IMPORT   int     perform_overture_init_mesh_refinement3d(CompositeGrid*,
                   doubleCompositeGridFunction*,CompositeGrid**,Overparam*,int);
IMPORT   void    Aug_compositegrid_by_error3d(doubleCompositeGridFunction&,CompositeGrid&,Overparam*);
IMPORT   void    init_patch_states3d(Wave*,Front*,INIT_DATA*, 
                   void(*)(float*,COMPONENT,Locstate,INTERFACE*,INIT_DATA*));
IMPORT   int     pseudo_advance_amr_fronts3d(Front***,float,float*,
                     Overparam*,Wave**,Front**,int,Wv_on_pc**,int);
#endif /* if defined(THREED) */
#endif /* if defined(USE_OVERTURE) */

#endif /* if !defined(_DOVERLOCALDECS_H) */
