/*
*			uinit.c
*
*	Utility programs for program initialization.
*/

/* LINTLIBRARY */

#include <cdecs.h>
#include <vmalloc.h>

EXPORT	void	init_prompting_and_debugging(
	INIT_DATA	*init)
{
	IMPORT bool	suppress_prompts;
	IMPORT bool	fgetstring_debug;		/* from fgetstring.c */
	char		s[Gets_BUF_SIZE];

	screen("\nType 'p' to obtain prompting on input: ");
	(void) fgets(s,Gets_BUF_SIZE-2,stdin);
	screen("\n");

	if (s[0] == 'p')
	{
	    (void) fprintf(stderr,"\n\n");
	    interactive_prompting(init) = YES;
	    suppress_prompts = NO;
	}
	else
	{
	    interactive_prompting(init) = NO;
	    suppress_prompts = YES;
	}

	dbparams(init) = init_debug(PROMPT_FOR_DEBUG);

	if (debugging("vm_1") || debugging("vmalloc_1"))
	    vmalloc_debug(1);
	if (debugging("vm_2") || debugging("vmalloc_2"))
	    vmalloc_debug(2);
	if (debugging("vm_3") || debugging("vmalloc_3"))
	    vmalloc_debug(3);
	if (debugging("vm_4") || debugging("vmalloc_4"))
	    vmalloc_debug(4);
	if (debugging("vm_5") || debugging("vmalloc_5"))
	    vmalloc_debug(5);
	if (debugging("make_core"))
	    set_dump_core(YES);

	if (debugging("fgetstring") || debugging("init"))
		fgetstring_debug = YES;
	if (debugging("nobuf"))
	{
	    (void) fflush(stdout);
	    setbuf(stdout,NULL);
	}
}		/*end init_prompting_and_debugging*/
