
/*                     
*				matrix.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains simple routines for the manipulation of matrices.
*
*		rotate_matrix()
*		rotate_vector()
*/

#include <cdecs.h>
#include <vmalloc.h>

/*
*	               rotate_vector():
*	               rotate_matrix():
*
*	Multiply the given vector by the matrix M.
*	Multiply two matricies.  Both functions assume the
*	dimension of these objects is at most 3.  The function
*	MatrixTimesMatix also assumes the matricies are square.
*/

EXPORT void rotate_vector(
	float		*rv,
	float		**M,
	float		*v,
	int		dim)
{
	int		i, j;
	float		vtemp[3];
	float		*v1;

	if (v == rv)
	{
		for (i = 0; i < dim; i++) vtemp[i] = v[i];
		v1 = vtemp;
	}
	else
		v1 = v;

	for (i = 0; i < dim; i++)
	{
		rv[i] = 0.0;
		for (j = 0; j < dim; j++)
			rv[i] += M[i][j]*v1[j];
	}
}		/*end rotate_vector*/

EXPORT void rotate_matrix(
	float		**M,
	float		**M1,
	float		**M2,
	int		dim)
{
	int		i, j, k;
	float		**m1, **m2;
	static bool	first = YES;
	static float	**mtmp1 = NULL, **mtmp2 = NULL;

	if (first)
	{
	    first = NO;
	    matrix(&mtmp1,3,3,FLOAT);
	    matrix(&mtmp2,3,3,FLOAT);
	}

	if (M == M1)
	{
	    for (i = 0; i < dim; i++)
	    	for (j = 0; j < dim; j++)
	    	    mtmp1[i][j] = M1[i][j];
	    m1 = mtmp1;
	}
	else
	    m1 = M1;

	if (M == M2)
	{
	    for (i = 0; i < dim; i++)
	    	for (j = 0; j < dim; j++)
	    	    mtmp2[i][j] = M2[i][j];
	    m2 = mtmp2;
	}
	else
	    m2 = M2;

	for (i = 0; i < dim; i++)
	{
	    for (j = 0; j < dim; j++)
	    {
	    	M[i][j] = 0.0;
	    	for (k = 0; k < dim; k++)
	    	    M[i][j] += m1[i][k]*m2[k][j];
	    }
	}
}		/*end rotate_matrix*/
