/*
*			triprotos.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*/

#if !defined(_TRIPROTOS_H)
#define _TRIPROTOS_H

#include <tri/trigrid.h>

	/* Trigrid EXPORTED Function Declarations*/
#if defined(ONED)
/*	tri1d.c*/
IMPORT	int     set_components1d(TRI_GRID*,INTERFACE*,int);
#endif /* defined(ONED) */

#if defined(TWOD)
/*	tri2d.c*/
IMPORT	int	set_components2d(TRI_GRID*,INTERFACE*,int);
#endif /* defined(TWOD) */

#if defined(THREED)
/*	tri3dv0.c*/
IMPORT	void	set_tri3dv0_tri_grid_hooks(TRI_GRID_HOOKS*);

/*	tri3dv1.c*/

/*	tri3dutils.c*/
IMPORT	bool	point_in_tetra(float*,LINEAR_ELEMENT*,COMPONENT,TRI_GRID*);
IMPORT	bool	fast_point_in_tetra(float*,LINEAR_ELEMENT*,COMPONENT,TRI_GRID*);
IMPORT	int	triangulate_mesh3d(TRI_GRID*);

#endif /* defined(THREED) */

/*	tricpy.c*/
IMPORT	void	copy_tri_grid(TRI_GRID*,TRI_GRID*,size_t);
IMPORT	void	free_copy_tri_grid(TRI_GRID**);

/*	triel1.c*/
IMPORT	bool	fast_blk_triangulate(TRI_GRID*,int*,
				     LINEAR_ELEMENT**,BILINEAR_ELEMENT**);
IMPORT	int	triangulate_mesh2d(TRI_GRID*);

/*	triel2.c*/
IMPORT	bool	exact_blk_triangulate(TRI_GRID*,int*,LINEAR_ELEMENT**,
				      BILINEAR_ELEMENT**);

/*	triel3.c*/

/*	trigrid1.c*/
IMPORT	BLK_EL0	*blk_el0_for_coords(float*,TRI_GRID*);
IMPORT	TRI_GRID	*allocate_tri_grid(TRI_GRID_HOOKS*);
IMPORT	int	**set_node_index_list(TRI_GRID*);
IMPORT	int	t_construct_tri_grid(TRI_GRID*,RECT_GRID*,Front*);
IMPORT	void	free_hyp_tri_grid(TRI_GRID**);
IMPORT	void	free_tri_grid(TRI_GRID*);
/* IMPORT	void	init_seg_crx_lists(TRI_GRID*,int,int); */
IMPORT	void	set_dual_interface_topology(TRI_GRID*);
IMPORT	void	set_tri_grid_rect_grids(TRI_GRID*,RECT_GRID*,INTERFACE*);

/*	trigrid2.c*/

/*	triloc.c*/
IMPORT	int	crossings_in_direction(CRXING**,int*,GRID_DIRECTION,TRI_GRID*);
#if defined(ONED)
IMPORT	CRXING *nearest_crossing1d(int*,GRID_DIRECTION,TRI_GRID*);
#endif /* defined(ONED) */
#if defined(TWOD)
IMPORT	CRXING	*nearest_crossing2d(int*,GRID_DIRECTION,TRI_GRID*);
IMPORT	bool	point_in_triangle(float*,LINEAR_ELEMENT*,COMPONENT,TRI_GRID*);
IMPORT  bool    pt_in_tri(float*,TRI*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	CRXING	*nearest_crossing3d(int*,GRID_DIRECTION,TRI_GRID*);
IMPORT  bool    nearest_crossing_state_with_comp(int*,float*,COMPONENT,
                                        TRI_GRID*,Locstate*);
#endif /* defined(THREED) */
#if defined(DEBUG_TRI_LOC)
IMPORT	void	set_debug_tri_loc(int);
#endif /* defined(DEBUG_TRI_LOC) */

/*	tripcs.c*/
#if defined(TWOD)
IMPORT	int	collect_pcs_in_mesh2d(TRI_GRID*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	int	collect_pcs_in_mesh3d(TRI_GRID*);
#endif /* defined(THREED) */

/*	triprint.c*/
IMPORT	void	print_BILINEAR_ELEMENT(BILINEAR_ELEMENT*,TRI_GRID*);
IMPORT	void	print_LINEAR_ELEMENT(LINEAR_ELEMENT*,TRI_GRID*);
IMPORT  void    print_components(TRI_GRID*);
IMPORT  char    *grid_dir(GRID_DIRECTION);
#if defined(TWOD)
IMPORT	const char *crossing_direction_name(CROSSING_DIRECTION);
IMPORT	void	print_triangulation(FILE*,TRI_GRID*);
IMPORT	void	print_blk_els0(TRI_GRID*);
IMPORT	void	print_blk_els1(TRI_GRID*);
#endif /* defined(TWOD) */
#if defined(TWOD) || defined(THREED)
IMPORT	const char *grid_direction_name(GRID_DIRECTION);
IMPORT	void	print_crxings(CRXING*,bool);
#endif /* defined(TWOD) || defined(THREED) */

#if defined(THREED)
/*	tricrx.c*/
IMPORT	INTERFACE *rebuild_intfc_at_crossings3d(TRI_GRID*,RECT_GRID*,Front*);
IMPORT  INTERFACE *repair_intfc_at_crossings3d(TRI_GRID*,RECT_GRID*,Front*);
IMPORT	bool	track_comp_through_crxings3d(int*,int*,int*,TRI_GRID*,CRX_TYPE);
IMPORT  void    initialize_comp_via_crossings(TRI_GRID*);
#endif /* defined(THREED) */

/* tricrx2d.c */
#if defined(TWOD) && defined(CONSERVATIVE_ALG)
IMPORT void      free_comp_crx_lists(TRI_GRID*);
IMPORT void      free_comp_tri_storage(TRI_GRID*);
IMPORT void      free_frac_state_storage(TRI_GRID*);
IMPORT TRI_GRID  *rebuild_intfc_at_crossings2d(RECT_GRID*,Front*,Front*,int);
IMPORT void      reset_pt_index_on_intfc(INTERFACE*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

/* tricrx2d2.c */
#if defined(TWOD) && defined(CONSERVATIVE_ALG)
IMPORT TIME_SPACE_INTFC2D  **time_space_intfc_construct2d(TRI_GRID*,
                               TRI_GRID*,Front*,Front*,int*,float);
IMPORT int       set_t_crxes_storage_for_volume(TIME_SPACE_INTFC2D**,
                    int,TRI_GRID*,TRI_GRID*,CRXING**,float);
IMPORT int       init_vol_state_storage(TRI_GRID*,INTERFACE*,size_t);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

/* tricrx2d3.c */
#if defined(TWOD) && defined(CONSERVATIVE_ALG)
IMPORT int       build_CSG_volume3d(Front*,Front*,TRI_GRID*,TRI_GRID*,
                    CRXING**,float);
IMPORT int       neighbors_for_solid(CSG_Solid*,TRI_GRID*,Solid_nghbr**);
IMPORT int       is_interior_face(CSG_Face*);
IMPORT CSG_Face  *find_match_face_in_region4(CSG_Face*,int*,TRI_GRID*);
IMPORT int       long_is_top_or_bottom_face(CSG_Face*,int*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

/* tri_csg_opt.c */
#if defined(TWOD) && defined(CONSERVATIVE_ALG)
IMPORT void      facels(CSG_Face*,int);
IMPORT void      solidls(CSG_Solid*,int); 
IMPORT void      print_solid(CSG_BLK_CRX*);  
IMPORT void      print_CSG_point(CSG_POINT*);  
IMPORT void      CSG_point_Coord(CSG_POINT*,float*);
IMPORT int       point_in_face2d(CSG_Loop*,float*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

#if defined(TWOD) && defined(CONSERVATIVE_ALG)
/* tricrx2d3.c */
IMPORT  int     comp_crossings_in_direction(CRXING**,int*,GRID_DIRECTION,TRI_GRID*);
IMPORT  void    free_control_volume_storage(TRI_GRID*);
IMPORT  int     is_top_or_bottom_face(CSG_Face*,int*);
IMPORT  CSG_Face  *match_face_in_other(CSG_Face*,CSG_Solid*); 
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

#if defined(TWOD) && defined(CONSERVATIVE_ALG)
/* tri_csgutil.c */
IMPORT  int     CSG_vol_to_geomview(char*,int,CSG_BLK_CRX**,TRI_GRID*,float);
IMPORT  void    top_and_btm_stat_with_tri(int*,CSG_Solid*,TRI_GRID*,
                     TRI_GRID*,int,void(*)(Locstate));
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

/*	triuserintfc.c*/
IMPORT	void	t_set_interface_hooks(int);

/*     imass.c */
IMPORT void      matrix_inv(double**,int,double**);
IMPORT void      comp_mass_matrix(int,TRI*,int,double**);
IMPORT void      comp_mass_matrix_1st_row(int,TRI*,int,double*,double**);
IMPORT void      inverse_matrix(double**,int,double**);
IMPORT void      print_ldb_matrix(const char*,int,int,double**,const char*);
IMPORT void      matrix_vec_mult(double**,double*,int,int,double*);
IMPORT float     vh_val(float*,double*,int);
IMPORT TRI       *find_corres_tri(float*,INTERFACE*);
IMPORT void      matrix_matrix_mult(double**,double**,int,int,double**);
IMPORT void      trans_matrix(double**,int,int,double**);
IMPORT void      d_trans_matrix(double**,int,int,double**);
IMPORT long double     int_x(float*,float*,float*,long double);
IMPORT long double     int_y(float*,float*,float*,long double);
IMPORT long double     int_x2(float*,float*,float*,long double);
IMPORT long double     int_y2(float*,float*,float*,long double);
IMPORT long double     int_xy(float*,float*,float*,long double);
IMPORT long double     int_x3(float*,float*,float*,long double);
IMPORT long double     int_y3(float*,float*,float*,long double);
IMPORT long double     int_x2y(float*,float*,float*,long double);
IMPORT long double     int_xy2(float*,float*,float*,long double);
IMPORT long double     int_x4(float*,float*,float*,long double);
IMPORT long double     int_y4(float*,float*,float*,long double);
IMPORT long double     int_x3y(float*,float*,float*,long double);
IMPORT long double     int_x2y2(float*,float*,float*,long double);
IMPORT long double     int_xy3(float*,float*,float*,long double);
IMPORT void      tri_quadrature_13_pts(float*,float*,float*,float crds[][2]);
IMPORT void      tri_quadrature_7_pts(float*,float*,float*,double*,float crds[][2]);
IMPORT void      print_tri_crds(TRI*);
IMPORT int       tri_on_phy_bdry(TRI*);
IMPORT bool      tri_out_rect(TRI*,float*,float*);


#endif /* !defined(_TRIPROTOS_H) */
