/*
*			trilocaldecs.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Trigrid library limited declaration.
*/


#if !defined(_TRILOCALDECS_H)
#define _TRILOCALDECS_H

#include <tri/trigrid.h>

struct _CRX_SORT {
        float *compare_coord;
        CRXING *crx;
};
typedef struct _CRX_SORT CRX_SORT;

enum _EDGE_TYPE {
        UNPHYSICAL_EDGE = 0,
        PHYSICAL_EDGE = 1
};
typedef enum _EDGE_TYPE EDGE_TYPE;

struct _GRID_PT {
        struct _GRID_PT *prev;
        int             ip[MAXD];
        COMPONENT       comp;
        GRID_DIRECTION  cur_dir;
};
typedef struct _GRID_PT GRID_PT;

		/* Trigrid tolerances */

IMPORT const float NTOL, ONEMNTOL, TOL, ONEMTOL;

	/* Trigrid private Function Declarations*/

#if defined(ONED)
/*	tri1d.c*/
IMPORT	int	insert_grid_crossings1d(TRI_GRID*);
IMPORT	void	set_crx_structure_storage1d(TRI_GRID*);
#endif /* defined(ONED) */

#if defined(TWOD)
/*	tri2d.c*/
IMPORT	int	insert_grid_crossings2d(TRI_GRID*,int**,INTERFACE*,RECT_GRID*,int);
IMPORT	void	set_crx_structure_storage2d(TRI_GRID*,int**);
IMPORT  int     count_intfc_crossings_of_grid_lattice2d(TRI_GRID*,INTERFACE*,
                            RECT_GRID*,int**,int);
#if defined(CONSERVATIVE_ALG)
IMPORT  void    set_crx_indx_local_global(TRI_GRID*,int);
IMPORT  void    set_crx_storage_for_reconstruction_on_grid2d(TRI_GRID*,INTERFACE*,
                      RECT_GRID*,int**,int);
#endif /* if defined(CONSERVATIVE_ALG) */
IMPORT  int     seg_index2d(int*,int);
IMPORT  bool    next_ip_in_dir(const int*,int,int*,int*,int*);
#endif /* defined(TWOD) */

#if defined(THREED)
/*	tri3dutils.c*/
IMPORT	int	seg_index3d(int,int,int,GRID_DIRECTION);
IMPORT	void	copy_tg_pts_from_regular_grid(TRI_GRID*);
#endif /* defined(THREED) */

/*	tricpy.c*/
#if defined(TWOD)
#if defined(DEBUG_TRI_GRID)
IMPORT  void    debug_copy_2d_tri_grid(TRI_GRID*,TRI_GRID*,size_t);
#endif /* defined(DEBUG_TRI_GRID) */
#endif /* defined(TWOD) */

/*	triel1.c*/
IMPORT	bool	triangulate_el0(TRI_GRID*,int,int*,int,int,int*,int,int,int*,
				int,int,int*,int,LINEAR_ELEMENT**,int*);
IMPORT	void	retrieve_crossing_lists(TRI_GRID*,int*,int*,int*,int*,int*,
					int*,int*,int*,int*,int**,int**,
					int**,int**);
IMPORT	void	set_quad(TRI_GRID*,int*,int,int,int,int,BILINEAR_ELEMENT**);
IMPORT	void	set_tri(TRI_GRID*,LINEAR_ELEMENT**,int*,TG_PT*,TG_PT*,TG_PT*,
			Locstate,Locstate,Locstate,
			LIN_EL_FACE_TYPE,LIN_EL_FACE_TYPE,LIN_EL_FACE_TYPE,
			COMPONENT);
IMPORT	void	triangulate_el1(TRI_GRID*,CRXING*,int,int*,int,int,int*,
				CRXING*,LINEAR_ELEMENT**,int*);
IMPORT	void	triangulate_el2(TRI_GRID*,CRXING*,int,int*,int,int,int*,int,
				int,int*,CRXING*,LINEAR_ELEMENT**,int*);
IMPORT	void	triangulate_el4(TRI_GRID*,CRXING*,int,int*,int,int,int*,
				int,int,int*,int,int,int*,CRXING*,
				LINEAR_ELEMENT**,int*);

/*	triel2.c*/
EXPORT	INTERFACE	*make_blk_intfc(TRI_GRID*,int,int*,int,int,int*,
					int,int,int*,int,int,int*,
					int,int,NODE**);
IMPORT	bool	triangulate_blk_with_nodes(TRI_GRID*,int*,LINEAR_ELEMENT**,
					   BILINEAR_ELEMENT**);
IMPORT	void	free_ntg_blk_node_lists(TRI_GRID*,int*);

/*	triel3.c*/
IMPORT	bool	exact_triangulate_el3(TRI_GRID*,NODE**,int,int*,int,int,int,
				      int,int,int,int,int,int*,int*,int*,
				      int*,LINEAR_ELEMENT**);
/*      tricrx.c */
#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */
IMPORT  int     crx_ascend(const void*,const void*);
IMPORT  int     crx_descend(const void *,const void *);
#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */
IMPORT  EDGE_TYPE   edge_comp_walk(GRID_PT*,TRI_GRID*,COMPONENT*,CRX_TYPE,int);

/*	trigrid1.c*/
IMPORT  int     set_untracked_components(TRI_GRID*,INTERFACE*);
IMPORT	void	free_triangulation_storage(TRI_GRID*);
IMPORT	void	init_seg_crx_lists(TRI_GRID*,int,int,int);
IMPORT	void	init_triangulation_storage(TRI_GRID*,int**,size_t);
IMPORT  int     ERROR_RETURN_FROM_CONSTRUCT_TRI_GRID(const char*,
                                int,INTERFACE*,TRI_GRID*);

#if defined(THREED)
/*	trigrid2.c*/
IMPORT	int	reconstruct_intfc_and_tri_grid(TRI_GRID*,RECT_GRID*,Front*);
#endif /* defined(THREED) */

/*	triloc.c*/
IMPORT	bool    tg_build(float*,COMPONENT,TRI_GRID*,BILINEAR_ELEMENT**,
                   LINEAR_ELEMENT**,LEAST_SQR_CLUSTER**);
IMPORT	bool	tg_locate(float*,COMPONENT,TRI_GRID*,BILINEAR_ELEMENT**,
			  LINEAR_ELEMENT**,LEAST_SQR_CLUSTER**);
#if defined(TWOD)
IMPORT  void    tri_grid_index_from_comp_grid_index(int*,int*,TRI_GRID*,int);
IMPORT  int     crossings_in_direction2d(CRXING**,int*,GRID_DIRECTION,TRI_GRID*,int);
IMPORT	float	tg_area(int*,COMPONENT,TRI_GRID*);
#endif /* defined(TWOD) */

#if defined(TWOD) || defined(THREED)
/*	tripcs.c*/
IMPORT	void	copy_tg_pts_from_intfc(TRI_GRID*,P_LINK*,int);
#endif /* defined(TWOD) || defined(THREED) */

/*	triprint.c*/
IMPORT	void	print_trigrid_alloc_status(const char*,TRI_GRID*);
#if defined(TWOD)
IMPORT	void	print_BLK_EL0(BLK_EL0*,TRI_GRID*);
IMPORT	void	print_el0(TRI_GRID*,int,int*,TG_PT*,int,int*,TG_PT*,int,int*,
			  TG_PT*,int,int*,TG_PT*);
IMPORT	void	print_el1(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,CRXING*);
IMPORT	void	print_el10(TRI_GRID*,CRXING*,int,int*,CRXING*,CRXING*,
			   int,int*,CRXING*,CRXING*,int,int*,CRXING*,CRXING*,
			   int,int*,CRXING*);
IMPORT	void	print_el2(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,TG_PT*,
			  int,int*,CRXING*);
IMPORT	void	print_el3(TRI_GRID*,CRXING*,int,int*,CRXING*,CRXING*,
			  int,int*,CRXING*);
IMPORT	void	print_el4(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,TG_PT*,
			  int,int*,TG_PT*,int,int*,CRXING*);
IMPORT	void	print_el5(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,
			  CRXING*,CRXING*,int,int*,CRXING*);
IMPORT	void	print_el6(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,
			  CRXING*,CRXING*,int,int*,TG_PT*,int,int*,CRXING*);
IMPORT	void	print_el7(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,TG_PT*,
			  int,int*,CRXING*,CRXING*,int,int*,CRXING*);
IMPORT	void	print_el8(TRI_GRID*,CRXING*,int,int*,CRXING*,CRXING*,int,int*,
			  CRXING*,CRXING*,int,int*,CRXING*);
IMPORT	void	print_el9(TRI_GRID*,CRXING*,int,int*,TG_PT*,int,int*,CRXING*,
			  CRXING*,int,int*,CRXING*,CRXING*,int,int*,CRXING*);
IMPORT	void	print_seg_crx_count(TRI_GRID*,int);
IMPORT	void	print_seg_crx_lists(TRI_GRID*);
IMPORT	void	print_seg_crx_lists_store(TRI_GRID*,int);
IMPORT	void	print_side_crx_list(TRI_GRID*,char,int,int*);
#endif /* defined(TWOD) */
#if defined(TWOD) || defined(THREED)
IMPORT	void	print_crx_store(TRI_GRID*ntg,int n_crx);
#endif /* defined(TWOD) || defined(THREED) */
#if defined(THREED) && defined(NAVIGATOR)
IMPORT  void 	gview_blk_tri(BLK_TRI*,int,int,int,RECT_GRID*);
IMPORT  void    gview_block_and_tris(TRI**,int,float*,float*,int);
#endif /* defined(THREED) && defined(NAVIGATOR) */

#if defined(THREED)
/*	trisurgery.c*/
IMPORT	void 	identify_detached_surface_curve_pair(INTERFACE*);
IMPORT  int     next_null_sided_tri(TRI*,POINT*,TRI**);
IMPORT  int     prev_null_sided_tri(TRI*,POINT*,TRI**);
#endif /* defined(THREED) */

#if defined(USE_OVERTURE)
/* overture_trigrid1.c */
IMPORT  void    use_overture_init_triangulation_storage(TRI_GRID*,int**,size_t);
IMPORT  void    set_AMR_triangulation_storage(TRI_GRID*,size_t);
IMPORT  void    copy_AMR_tri_storage2d(TRI_GRID*,TRI_GRID*,size_t);
#endif /* if defined(USE_OVERTURE) */

#if defined(TWOD) && defined(CONSERVATIVE_ALG) 
/* tricrx2d.c */
IMPORT  void    set_tri_grid_aug_comp_grids(TRI_GRID*,RECT_GRID*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

#if defined(TWOD) && defined(CONSERVATIVE_ALG) 
/* tricrx2d2.c */
IMPORT  void    print_tri2d(TRI*);  
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

#if defined(TWOD) && defined(CONSERVATIVE_ALG) 
/* tri_csg_opt.c */
IMPORT CSG_Solid    *create_corner_vol2(CSG_BLK_CRX*,CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*); 
IMPORT CSG_Solid    *create_complement_vol_for_corner_vol2( CSG_BLK_CRX*, CSG_POINT*, CSG_POINT*,
                      CSG_POINT*, CSG_POINT*, CSG_POINT*, CSG_POINT*, CSG_POINT*, CSG_POINT*,
                      CSG_POINT*, CSG_POINT*);
IMPORT CSG_Solid    *create_3rd_vol_for_2pt_isolate1(CSG_BLK_CRX*, CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *create_3rd_vol_for_2pt_isolate2(CSG_BLK_CRX*, CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *create_3rd_vol_for_2pt_isolate4(CSG_BLK_CRX*, CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_edge_case(CSG_BLK_CRX*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_edge_case(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_edge_case_angl2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_edge_case_angl2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *create_float_vol_3pt(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *create_center_vol_degenerate_3pt(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *create_complement_center_vol_degenerate_3pt(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_vol_for_ceining_case(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_floor_case(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_case2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_floor_case2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_case3(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_floor_case3(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_case4(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_floor_case4(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_case5(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_floor_case5(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_ceining_case(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_ceining_case2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_ceining_case2(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_ceining_case3(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_ceining_case4(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_ceining_case4(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ceining_ceining_case5(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_complement_vol_for_ceining_case5(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_plane_case(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *creat_vol_for_corner_star_hexagon(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_corner_star_hexagon(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ij_twist1(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_ij_twist1(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_vol_for_ji_twist1(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *creat_complement_vol_for_ji_twist1(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*);  
IMPORT CSG_Solid    *create_vol_for_plan_float_vol(CSG_BLK_CRX*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*, 
                      CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
IMPORT CSG_Solid    *create_box_vol(CSG_BLK_CRX*);

IMPORT void     set_CSG_local_global(TRI_GRID*,TRI_GRID*,float);  
IMPORT void     free_CSG_vol(CSG_Solid**); 
IMPORT int      faceeq(CSG_Loop*,float*,TRI_GRID*,float); 
IMPORT float    larea(CSG_Loop*,float*,TRI_GRID*,float);  
IMPORT float    edge_len(CSG_HalfEdge*); 

IMPORT void     solid_glue(CSG_Solid*,CSG_Solid**);
IMPORT int      CSG_face_match(CSG_Face*,CSG_Face*);
IMPORT int      CSG_Point_equal(CSG_POINT*,CSG_POINT*);
IMPORT int      CSG_Vertex_equal(CSG_Vertex*,CSG_Vertex*);
IMPORT int      CSG_loop_vtx_num(CSG_Loop*); 
IMPORT void     polygon_centroid_3d(CSG_Loop*);  
IMPORT float    findNormal3D(CSG_Loop*,float*);

/* tricrx2d3.c */
// IMPORT int      long_is_top_or_bottom_face(CSG_Face*,int*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */

/* tricrx2d4.c */
#if defined(TWOD) && defined(CONSERVATIVE_ALG) 
IMPORT void     stitch_curves2d(TRI_GRID*,BLK_BOND*,
                      JC_BLK_BOND*,int*,int*);
#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */


#endif /* !defined(_TRILOCALDECS_H) */
