/*
*                               tricrx2d3.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/


#define DEBUG_STRING    "tricrx2d3"

#include <tri/trilocaldecs.h>

#if defined(TWOD) && defined(CONSERVATIVE_ALG)

struct _FILL_VOL
{
        int  ic[MAXD];
        struct _FILL_VOL *prev;
        struct _FILL_VOL *next;
};
typedef struct _FILL_VOL  FILL_VOL;

   /* LOCAL GLOBAL VARIABLE */
LOCAL float   box_volume = 0.0, rect_area = 0.0; 

LOCAL int     CSG_blk_on_front(int*,TRI_GRID*,
                  TRI_GRID*,CRXING**,float,CSG_BLK_CRX**);
LOCAL int     set_irregular_blk(int*,TRI_GRID*,TRI_GRID*,CSG_BLK_CRX**,
                  CRXING **crx[], int*, int);  
LOCAL int     CSG_volume_construct(int*,CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*); 

LOCAL int     CSG_vol_merger(CSG_BLK_CRX**,CSG_BLK_CRX**,int,
                     TRI_GRID*,TRI_GRID*,float);
LOCAL int     if_need_fill_vol_blk(int*,int,int*,int*,CSG_BLK_CRX**,TRI_GRID*); 
LOCAL FILL_VOL   *insert_fill_vol_ic(FILL_VOL**,int*,int); 
LOCAL void    free_fill_vol_ic(FILL_VOL**);
LOCAL void    find_need_merge_top_tri_quadr_vol(CSG_BLK_CRX*,CSG_merger**); 
LOCAL void    add_to_merge_list(CSG_Solid*,CSG_BLK_CRX*,CSG_merger**);
LOCAL void    free_merge_list(CSG_merger**);
LOCAL void    find_1st_merger_candidate(CSG_merger*,int*,int*,CSG_BLK_CRX**,
                   TRI_GRID*,TRI_GRID*); 
LOCAL void    find_merger_candidate_tri(CSG_merger*,CSG_HalfEdge*,int*,int*,int*,
                   CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*,int);
LOCAL void    find_merger_candidate_quadr(CSG_merger*, CSG_HalfEdge*, int*, int*,
                             int*, CSG_BLK_CRX**, TRI_GRID*, TRI_GRID*, int);
LOCAL void    remove_duplicate_from_merger_lst(CSG_merger**); 
LOCAL int     merger_edge_of_loop(CSG_Loop*,CSG_HalfEdge**);
LOCAL CSG_HalfEdge   *match_vol_in_other(CSG_HalfEdge*,CSG_POINT*,CSG_Solid*); 
LOCAL void    install_merger_candidate_tri(CSG_HalfEdge*,CSG_HalfEdge*,CSG_HalfEdge*,
                 CSG_merger*,int); 
LOCAL void    install_merger_candidate_tri_5_5(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*,int);
LOCAL void    install_merger_candidate_tri_4_4(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*,int);
LOCAL void    install_merger_candidate_tri_3_3(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL void    install_merger_candidate_tri_6_5(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL void    install_merger_candidate_tri_6_3(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL void    install_merger_candidate_tri_5_4(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL void    install_merger_candidate_tri_5_3(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL void    install_merger_candidate_tri_4_3(CSG_HalfEdge*, CSG_merger*,
                        CSG_Face*, CSG_Face*, int, int,int);
LOCAL CSG_HalfEdge  *match_edge_in_other(CSG_HalfEdge*,CSG_Loop*);  
LOCAL void    merge_1st_solid(CSG_merger*,CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*); 
LOCAL void    merge_solid_with_1_nghbr(CSG_merger*,CSG_merger*,CSG_BLK_CRX**,
                    TRI_GRID*,TRI_GRID*);
LOCAL void    remove_vol_from_blk_list(CSG_BLK_CRX*,CSG_Solid*); 
LOCAL void    reset_merge_list_for_2nd(CSG_merger*);
LOCAL void    merge_2nd_solid(CSG_merger*,CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*);
LOCAL void    perform_merge_2nd_solid(CSG_merger*,CSG_BLK_CRX**,TRI_GRID*,
                  int*,int*); 
LOCAL int     can_two_solid_merge(CSG_Solid*,CSG_HalfEdge*);
LOCAL CSG_Solid  *if_unmerged_trivial_btm_vol_left(int*,int*,CSG_BLK_CRX**,
                        TRI_GRID*); 
LOCAL void    perform_merge_solid(CSG_Solid*,CSG_BLK_CRX**,TRI_GRID*,
                     int*,int*,char*); 
// LOCAL int     is_interior_face(CSG_Face*); 
LOCAL int     can_two_solid_merge_by_f(CSG_Solid*,CSG_Face*);  
LOCAL void    find_need_merge_btm_tri_quadr_vol(CSG_BLK_CRX*,
                   CSG_merger**,int*,int*); 
LOCAL int     find_btm_merger_candidate(CSG_merger*,int*,int*,
                 CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*); 
LOCAL void    find_btm_merger_candidate_tri(CSG_merger*,CSG_HalfEdge*,
                int*,int*,int*,CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*,int);  
LOCAL CSG_HalfEdge  *find_merger_candidate_tri_1(CSG_merger*,CSG_HalfEdge*,
                   int*,int*,int*,CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*,int); 
LOCAL void    find_btm_merger_candidate_quadr(CSG_merger*,CSG_HalfEdge*,
                int*,int*,int*,CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*,int); 
LOCAL CSG_Solid *if_unmerged_trivial_top_vol_left(int*,int*,
                   CSG_BLK_CRX**,TRI_GRID*); 
LOCAL CSG_Solid *if_unmerged_small_top_vol_left(int*,int*,
                   CSG_BLK_CRX**,TRI_GRID*); 

LOCAL void    init_csg_blk_crx(CSG_BLK_CRX**,int*,TRI_GRID*,TRI_GRID*);
LOCAL void    alloc_csg_blk_crx(CSG_BLK_CRX**);
LOCAL void    free_csg_blk_crx_vol(CSG_BLK_CRX**);
LOCAL void    alloc_csg_blk_crx_r(CSG_BLK_CRX_r**);
LOCAL void    copy_csg_blk_crx_r(CSG_BLK_CRX*,CSG_BLK_CRX_r*);

LOCAL CSG_POINT *CSG_crx_in_idir(CSG_BLK_CRX*, int, int);
LOCAL CSG_POINT *CSG_crx_in_jdir(CSG_BLK_CRX*, int, int);
LOCAL CSG_POINT *CSG_crx_in_kdir(CSG_BLK_CRX*, int, int);
LOCAL CSG_POINT *CSG_crxing_in_between(int*, int*, CSG_BLK_CRX*);

LOCAL CSG_POINT *CSG_crx_in_idir_r(CSG_BLK_CRX_r*, int, int);
LOCAL CSG_POINT *CSG_crx_in_jdir_r(CSG_BLK_CRX_r*, int, int);
LOCAL CSG_POINT *CSG_crx_in_kdir_r(CSG_BLK_CRX_r*, int, int);
LOCAL CSG_POINT *CSG_crxing_in_between_r(int*, int*, CSG_BLK_CRX_r*);

LOCAL void    print_csg_blk_crx(CSG_BLK_CRX*);
LOCAL void    print_csg_blk_crx_r(CSG_BLK_CRX_r*);


LOCAL int     csg_num_rotation(int,int);
LOCAL int     csg_i_rot(int,int,int); 
LOCAL int     csg_j_rot(int,int,int); 

LOCAL void  csg_rot_xy(CSG_BLK_CRX*, CSG_BLK_CRX*, int);
LOCAL void  csg_rot_yz(CSG_BLK_CRX*, CSG_BLK_CRX*, int);
LOCAL void  csg_rot_zx(CSG_BLK_CRX*, CSG_BLK_CRX*, int);

LOCAL void  csg_rot_xy_r(CSG_BLK_CRX_r*, CSG_BLK_CRX_r*, int);
LOCAL void  csg_rot_yz_r(CSG_BLK_CRX_r*, CSG_BLK_CRX_r*, int);
LOCAL void  csg_rot_zx_r(CSG_BLK_CRX_r*, CSG_BLK_CRX_r*, int);
LOCAL void  csg_rot_xy_r1(CSG_BLK_CRX*, CSG_BLK_CRX_r*, int);
LOCAL void  csg_rot_yz_r1(CSG_BLK_CRX*, CSG_BLK_CRX_r*, int);
LOCAL void  csg_rot_zx_r1(CSG_BLK_CRX*, CSG_BLK_CRX_r*, int);

LOCAL bool  CSG_is_isolated_point(COMPONENT***,int,int,int,COMPONENT);

LOCAL void    find_odd_point_and_create_CSG_vol(CSG_BLK_CRX*,
                      TRI_GRID*,TRI_GRID*);
LOCAL void    rot_point_and_create_corner_vol(int,int,int,
                      CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*);
LOCAL void    create_CSG_vol_for_two_point(CSG_BLK_CRX*);
LOCAL void    rot_point_and_create_3vol_for_2pt_isolate( int,int,
                      int,CSG_BLK_CRX*);
LOCAL void    rot_line_and_create_float_vol(int,int,int,CSG_BLK_CRX*);
LOCAL void    create_CSG_vol_for_three_point(CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*);
LOCAL void    rot_line_and_create_float_vol_3pt(int,int,int,CSG_BLK_CRX*,
                TRI_GRID*,TRI_GRID*);
LOCAL void    rot_height_and_create_angle_vol(int,int,int,CSG_BLK_CRX*,
                TRI_GRID*,TRI_GRID*);
LOCAL int     angles_for_create_angle_vol(
               CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*);
LOCAL void    create_CSG_vol_for_four_point(CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*);
LOCAL bool    csg_is_twist(COMPONENT***,int,int,int,COMPONENT);
LOCAL void    rot_plan_and_create_plan_vol(int,int,CSG_BLK_CRX*);
LOCAL void    rot_vortex_and_create_star_vol(int,int,int,CSG_BLK_CRX*);  
LOCAL void    rot_stem_and_create_twist_vol(int,int,int,CSG_BLK_CRX*);
LOCAL void    rot_line_and_create_float_vol_4(int,int,int,CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*);

LOCAL void    set_time_space_front_tri(TRI*,CSG_POINT*,CSG_POINT*,CSG_POINT*);

LOCAL COMPONENT solid_comp(CSG_Solid*,TRI_GRID*,TRI_GRID*); 
LOCAL void    set_vol_face_par(CSG_BLK_CRX*,TRI_GRID*,TRI_GRID*,float); 
LOCAL float   tetrahedron_vol(CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*); 
LOCAL float   pyramid_vol(CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*,CSG_POINT*); 
LOCAL void    fill_vol_for_sten(CSG_BLK_CRX**,TRI_GRID*,TRI_GRID*,float); 


LOCAL   CSG_POINT *CSG_crx_in_idir(
        CSG_BLK_CRX      *blk_crx,
        int              j,
        int              k)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_idir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[0][j][k];
        ip[1] = iy[0][j][k];
        ip[2] = iz[0][j][k];
        ipn[0] = ix[1][j][k];
        ipn[1] = iy[1][j][k];
        ipn[2] = iz[1][j][k];
        bbi = CSG_crxing_in_between(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_idir)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_idir*/

LOCAL   CSG_POINT *CSG_crx_in_jdir(
        CSG_BLK_CRX      *blk_crx,
        int              k,
        int              i)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_jdir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[i][0][k];
        ip[1] = iy[i][0][k];
        ip[2] = iz[i][0][k];
        ipn[0] = ix[i][1][k];
        ipn[1] = iy[i][1][k];
        ipn[2] = iz[i][1][k];
        bbi = CSG_crxing_in_between(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_jdir)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_jdir*/

LOCAL   CSG_POINT *CSG_crx_in_kdir(
        CSG_BLK_CRX      *blk_crx,
        int              i,
        int              j)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_kdir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[i][j][0];
        ip[1] = iy[i][j][0];
        ip[2] = iz[i][j][0];
        ipn[0] = ix[i][j][1];
        ipn[1] = iy[i][j][1];
        ipn[2] = iz[i][j][1];
        bbi = CSG_crxing_in_between(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_kdir)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_kdir*/

LOCAL   CSG_POINT *CSG_crxing_in_between(
        int             *ip,
        int             *ipn,
        CSG_BLK_CRX     *blk_crx)
{

#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */

        if (ip[0] != ipn[0])
        {
            if (blk_crx->crx[0][ip[1]][ip[2]].csg_pt.crx == NULL)
            {
                screen("ERROR in CSG_crxing_in_between(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return &(blk_crx->crx[0][ip[1]][ip[2]]);
        }
        else if (ip[1] != ipn[1])
        {
            if (blk_crx->crx[1][ip[2]][ip[0]].csg_pt.crx == NULL)
            {
                screen("ERROR in CSGcrxing_in_between(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return &(blk_crx->crx[1][ip[2]][ip[0]]);
        }
        else if (ip[2] != ipn[2])
        {
            if (blk_crx->crx[2][ip[0]][ip[1]].csg_pt.crx == NULL)
            {
                screen("ERROR in CSG_crxing_in_between(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx(blk_crx);
                printf("In CSG_crxing_in_between(), ip[0] ip[1] <%d, %d>\n",
                  ip[0], ip[1]);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return &(blk_crx->crx[2][ip[0]][ip[1]]);
        }
        screen("ERROR in crxing_in_between(), "
               "Inconsistent values of ip and ipn arrays\n");
        clean_up(ERROR);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
        return NULL;
}               /* end CSG_crxing_in_between */


LOCAL   CSG_POINT *CSG_crx_in_idir_r(
        CSG_BLK_CRX_r    *blk_crx,
        int              j,
        int              k)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_idir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[0][j][k];
        ip[1] = iy[0][j][k];
        ip[2] = iz[0][j][k];
        ipn[0] = ix[1][j][k];
        ipn[1] = iy[1][j][k];
        ipn[2] = iz[1][j][k];
        bbi = CSG_crxing_in_between_r(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_idir)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_idir_r*/

LOCAL   CSG_POINT *CSG_crx_in_jdir_r(
        CSG_BLK_CRX_r    *blk_crx,
        int              k,
        int              i)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_jdir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[i][0][k];
        ip[1] = iy[i][0][k];
        ip[2] = iz[i][0][k];
        ipn[0] = ix[i][1][k];
        ipn[1] = iy[i][1][k];
        ipn[2] = iz[i][1][k];
        bbi = CSG_crxing_in_between_r(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_jdir_r)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_jdir_r*/


LOCAL   CSG_POINT *CSG_crx_in_kdir_r(
        CSG_BLK_CRX_r    *blk_crx,
        int              i,
        int              j)
{
        int ip[3],ipn[3];
        int ***ix = blk_crx->ix;
        int ***iy = blk_crx->iy;
        int ***iz = blk_crx->iz;
        CSG_POINT *bbi;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crx_in_kdir)
#endif /* defined(NAVIGATOR) */

        ip[0] = ix[i][j][0];
        ip[1] = iy[i][j][0];
        ip[2] = iz[i][j][0];
        ipn[0] = ix[i][j][1];
        ipn[1] = iy[i][j][1];
        ipn[2] = iz[i][j][1];
        bbi = CSG_crxing_in_between_r(ip,ipn,blk_crx);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crx_in_kdir_r)
#endif /* defined(NAVIGATOR) */
        return bbi;
}               /*end CSG_crx_in_kdir_r*/


LOCAL   CSG_POINT *CSG_crxing_in_between_r(
        int             *ip,
        int             *ipn,
        CSG_BLK_CRX_r   *blk_crx)
{

#if defined(NAVIGATOR)
        NAV_ENTER(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */

        if (ip[0] != ipn[0])
        {
            if (blk_crx->crx[0][ip[1]][ip[2]]->csg_pt.crx == NULL)
            {
                screen("ERROR 1 CSG_crxing_in_between_r(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx_r(blk_crx);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return (blk_crx->crx[0][ip[1]][ip[2]]);
        }
        else if (ip[1] != ipn[1])
        {
            if (blk_crx->crx[1][ip[2]][ip[0]]->csg_pt.crx == NULL)
            {
                screen("ERROR 2 CSG_crxing_in_between_r(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx_r(blk_crx);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return (blk_crx->crx[1][ip[2]][ip[0]]);
        }
        else if (ip[2] != ipn[2])
        {
            if (blk_crx->crx[2][ip[0]][ip[1]]->csg_pt.crx == NULL)
            {
                screen("ERROR 3 CSG_crxing_in_between_r(), "
                       "no crossing point between:\n"
                       "(%d %d %d) and (%d %d %d)\n",
                        ip[0],ip[1],ip[2],ipn[0],ipn[1],ipn[2]);
                print_csg_blk_crx_r(blk_crx);
                printf("In CSG_crxing_in_between(), ip[0] ip[1] <%d, %d>\n",
                  ip[0], ip[1]);
                clean_up(ERROR);
            }
#if defined(NAVIGATOR)
            NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
            return (blk_crx->crx[2][ip[0]][ip[1]]);
        }
        screen("ERROR in crxing_in_between_r(), "
               "Inconsistent values of ip and ipn arrays\n");
        clean_up(ERROR);
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_crxing_in_between)
#endif /* defined(NAVIGATOR) */
        return NULL;
}               /* end CSG_crxing_in_between */


LOCAL int  csg_num_rotation(
        int i,
        int j)
{
        if (i == 0 && j == 0)
            return 0;
        if (i == 1 && j == 0)
            return 1;
        if (i == 1 && j == 1)
            return 2;
        if (i == 0 && j == 1)
            return 3;
        return -1;
}    /*end csg_num_rotation()*/

LOCAL   int  csg_i_rot(
        int i,
        int j,
        int n)
{
        if (n == 0)
            return i;
        if (n == 1)
            return j;
        if (n == 2)
            return (i == 1 ? 0 : 1);
        if (n == 3)
            return (j == 1 ? 0 : 1);
        return -1;
}   /*end csg_i_rot()*/


LOCAL   int  csg_j_rot(
        int i,
        int j,
        int n)
{
        if (n == 0)
            return j;
        if (n == 1)
            return (i == 1 ? 0 : 1);
        if (n == 2)
            return (j == 1 ? 0 : 1);
        if (n == 3)
            return i;
        return -1;
}   /*end csg_j_rot()*/

LOCAL void csg_rot_zx(
        CSG_BLK_CRX      *bc,
        CSG_BLK_CRX      *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ***icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int ir,kr;


#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_zx)
#endif /* defined(NAVIGATOR) */
        for (i = 0; i < 2; i++)

        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    kr = csg_i_rot(k,i,n_rot);
                    ir = csg_j_rot(k,i,n_rot);
                    ix_rot[ir][j][kr] = ix[i][j][k];
                    iy_rot[ir][j][kr] = iy[i][j][k];
                    iz_rot[ir][j][kr] = iz[i][j][k];
                    comp_rot[ir][j][kr] = comp[i][j][k];
                    memcpy(icrds_rot[ir][j][kr].csg_pt.icrds,
                       icrds[i][j][k].csg_pt.icrds, sizeof(int)*3);
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_zx)
#endif /* defined(NAVIGATOR) */
}


LOCAL void csg_rot_yz(
        CSG_BLK_CRX      *bc,
        CSG_BLK_CRX      *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ***icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int jr,kr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_yz)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    jr = csg_i_rot(j,k,n_rot);
                    kr = csg_j_rot(j,k,n_rot);
                    ix_rot[i][jr][kr] = ix[i][j][k];
                    iy_rot[i][jr][kr] = iy[i][j][k];
                    iz_rot[i][jr][kr] = iz[i][j][k];
                    comp_rot[i][jr][kr] = comp[i][j][k];
                    memcpy(icrds_rot[i][jr][kr].csg_pt.icrds,
                        icrds[i][j][k].csg_pt.icrds, sizeof(int)*3);
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_yz)
#endif /* defined(NAVIGATOR) */
}

LOCAL void csg_rot_xy(
        CSG_BLK_CRX      *bc,
        CSG_BLK_CRX      *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ***icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int ir,jr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_xy)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    ir = csg_i_rot(i,j,n_rot);
                    jr = csg_j_rot(i,j,n_rot);
                    ix_rot[ir][jr][k] = ix[i][j][k];
                    iy_rot[ir][jr][k] = iy[i][j][k];
                    iz_rot[ir][jr][k] = iz[i][j][k];
                    comp_rot[ir][jr][k] = comp[i][j][k];
                    memcpy(icrds_rot[ir][jr][k].csg_pt.icrds,
                        icrds[i][j][k].csg_pt.icrds, sizeof(int)*3);
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_xy)
#endif /* defined(NAVIGATOR) */
}


LOCAL void csg_rot_xy_r(
        CSG_BLK_CRX_r    *bc,
        CSG_BLK_CRX_r    *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ****icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ****icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int ir,jr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_xy)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    ir = csg_i_rot(i,j,n_rot);
                    jr = csg_j_rot(i,j,n_rot);
                    ix_rot[ir][jr][k] = ix[i][j][k];
                    iy_rot[ir][jr][k] = iy[i][j][k];
                    iz_rot[ir][jr][k] = iz[i][j][k];
                    comp_rot[ir][jr][k] = comp[i][j][k];
                    icrds_rot[ir][jr][k] = icrds[i][j][k];
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_xy)
#endif /* defined(NAVIGATOR) */
}

LOCAL void csg_rot_xy_r1(
        CSG_BLK_CRX      *bc,
        CSG_BLK_CRX_r    *rbc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = rbc_rot->comp;
        CSG_POINT ****icrds_rot = rbc_rot->icrds;
        int ***ix_rot = rbc_rot->ix;
        int ***iy_rot = rbc_rot->iy;
        int ***iz_rot = rbc_rot->iz;
        int ir,jr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_xy)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    ir = csg_i_rot(i,j,n_rot);
                    jr = csg_j_rot(i,j,n_rot);
                    ix_rot[ir][jr][k] = ix[i][j][k];
                    iy_rot[ir][jr][k] = iy[i][j][k];
                    iz_rot[ir][jr][k] = iz[i][j][k];
                    comp_rot[ir][jr][k] = comp[i][j][k];
                    icrds_rot[ir][jr][k] = &icrds[i][j][k];
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_xy)
#endif /* defined(NAVIGATOR) */
}

LOCAL void csg_rot_zx_r1(
        CSG_BLK_CRX      *bc,
        CSG_BLK_CRX_r    *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ****icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int ir,kr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_zx)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    kr = csg_i_rot(k,i,n_rot);
                    ir = csg_j_rot(k,i,n_rot);
                    ix_rot[ir][j][kr] = ix[i][j][k];
                    iy_rot[ir][j][kr] = iy[i][j][k];
                    iz_rot[ir][j][kr] = iz[i][j][k];
                    comp_rot[ir][j][kr] = comp[i][j][k];
                    icrds_rot[ir][j][kr] = &icrds[i][j][k];
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_zx)
#endif /* defined(NAVIGATOR) */
}


LOCAL void csg_rot_yz_r1(
        CSG_BLK_CRX        *bc,
        CSG_BLK_CRX_r      *bc_rot,
        int                n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ***icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ****icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int jr,kr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_yz)
#endif /* defined(NAVIGATOR) */


        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    jr = csg_i_rot(j,k,n_rot);
                    kr = csg_j_rot(j,k,n_rot);
                    ix_rot[i][jr][kr] = ix[i][j][k];
                    iy_rot[i][jr][kr] = iy[i][j][k];
                    iz_rot[i][jr][kr] = iz[i][j][k];
                    comp_rot[i][jr][kr] = comp[i][j][k];
                    icrds_rot[i][jr][kr] = &icrds[i][j][k];
                }
            }
        }
#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_yz)
#endif /* defined(NAVIGATOR) */
}

LOCAL void csg_rot_yz_r(
        CSG_BLK_CRX_r      *bc,
        CSG_BLK_CRX_r      *bc_rot,
        int                n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ****icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ****icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int jr,kr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_yz)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    jr = csg_i_rot(j,k,n_rot);
                    kr = csg_j_rot(j,k,n_rot);
                    ix_rot[i][jr][kr] = ix[i][j][k];
                    iy_rot[i][jr][kr] = iy[i][j][k];
                    iz_rot[i][jr][kr] = iz[i][j][k];
                    comp_rot[i][jr][kr] = comp[i][j][k];
                    icrds_rot[i][jr][kr] = icrds[i][j][k];
                }
            }
        }
#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_yz)
#endif /* defined(NAVIGATOR) */
}

LOCAL void csg_rot_zx_r(
        CSG_BLK_CRX_r    *bc,
        CSG_BLK_CRX_r    *bc_rot,
        int              n_rot)
{
        int i,j,k;
        COMPONENT ***comp = bc->comp;
        CSG_POINT ****icrds = bc->icrds;
        int ***ix = bc->ix;
        int ***iy = bc->iy;
        int ***iz = bc->iz;
        COMPONENT ***comp_rot = bc_rot->comp;
        CSG_POINT ****icrds_rot = bc_rot->icrds;
        int ***ix_rot = bc_rot->ix;
        int ***iy_rot = bc_rot->iy;
        int ***iz_rot = bc_rot->iz;
        int ir,kr;

#if defined(NAVIGATOR)
        NAV_ENTER(csg_rot_zx)
#endif /* defined(NAVIGATOR) */

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    kr = csg_i_rot(k,i,n_rot);
                    ir = csg_j_rot(k,i,n_rot);
                    ix_rot[ir][j][kr] = ix[i][j][k];
                    iy_rot[ir][j][kr] = iy[i][j][k];
                    iz_rot[ir][j][kr] = iz[i][j][k];
                    comp_rot[ir][j][kr] = comp[i][j][k];
                    icrds_rot[ir][j][kr] = icrds[i][j][k];
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(csg_rot_zx)
#endif /* defined(NAVIGATOR) */
}


LOCAL void print_csg_blk_crx(
        CSG_BLK_CRX      *blk)
{
        int i, j, k;

        for(k = 0; k < 2; k++)
        {
            printf("ICRDS & COMP of Layer %d\n", k);
            for(j = 1; j >= 0; j--)
            {
                printf("<%2d %2d %2d> %d \t <%2d %2d %2d> %d",
                     blk->icrds[0][j][k].csg_pt.icrds[0],
                     blk->icrds[0][j][k].csg_pt.icrds[1],
                     blk->icrds[0][j][k].csg_pt.icrds[2],
                     blk->comp[0][j][k],
                     blk->icrds[1][j][k].csg_pt.icrds[0],
                     blk->icrds[1][j][k].csg_pt.icrds[1],
                     blk->icrds[1][j][k].csg_pt.icrds[2],
                     blk->comp[1][j][k]);
                printf("\n");
            }
        }

        printf("Print crds of this blk\n");
        for(k = 0; k < 2; k++)
        {
            printf("CRDS of Layer %d\n", k);
            for(j = 1; j >= 0; j--)
            {
                print_CSG_point(&blk->icrds[0][j][k]);
                print_CSG_point(&blk->icrds[1][j][k]);
            }
        }
}

LOCAL void print_csg_blk_crx_r(
        CSG_BLK_CRX_r      *blk)
{
        int i, j, k;

        for(k = 0; k < 2; k++)
        {
            printf("ICRDS & COMP of Layer %d\n", k);
            for(j = 1; j >= 0; j--)
            {
                 printf("<%2d %2d %2d> %d \t <%2d %2d %2d> %d",
                        blk->icrds[0][j][k]->csg_pt.icrds[0],
                        blk->icrds[0][j][k]->csg_pt.icrds[1],
                        blk->icrds[0][j][k]->csg_pt.icrds[2],
                        blk->comp[0][j][k],
                        blk->icrds[1][j][k]->csg_pt.icrds[0],
                        blk->icrds[1][j][k]->csg_pt.icrds[1],
                        blk->icrds[1][j][k]->csg_pt.icrds[2],
                        blk->comp[1][j][k]);
                 printf("\n");
             }
         }
}



EXPORT int build_CSG_volume3d(
        Front           *fr,
        Front           *newfr, 
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        CRXING          **t_crx,
        float           dt)
{
        int             i, j, smin[MAXD], smax[MAXD];
        int             icrds[MAXD+1];
        float           *L, *h;
        float           crds[MAXD+1], crds_end[MAXD+1];
        CSG_BLK_CRX     **csg_blk_crx;
        CSG_BLK_CRX     **onfront_blk_crx;

        RECT_GRID       aug_comp_grid = old_ntg->aug_comp_grid;
        RECT_GRID       comp_grid = old_ntg->comp_grid;
        int             total_vol = 0, ii = 0;

        DEBUG_ENTER(build_CSG_volume3d)
 
        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = new_ntg->comp_grid.gmax[i];
            smin[i] -= new_ntg->comp_grid.lbuf[i];
            smax[i] += new_ntg->comp_grid.ubuf[i];
        }
        L = new_ntg->comp_grid.L;
        h = new_ntg->comp_grid.h;

        /* SET LOCAL GLOBALs */
        box_volume = dt*h[0]*h[1]; rect_area = h[0]*h[1];
        set_CSG_local_global(new_ntg,old_ntg,dt); 

        vector(&csg_blk_crx, (aug_comp_grid.gmax[0])*(aug_comp_grid.gmax[1]),
                sizeof(CSG_BLK_CRX*));
        old_ntg->Volume.blk = csg_blk_crx; 

        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            crds_end[0] = crds[0] = L[0] + i*h[0];
            crds_end[1] = crds[1] = L[1] + j*h[1];
            crds_end[0] += h[0];
            crds_end[1] += h[1];
            icrds[0] = i; icrds[1] = j;

            if(is_complex_blk(Comp_blk(icrds,new_ntg->blk_type,new_ntg)))
            {
#if defined(DEBUG)
                printf("Step[%d] blk[%d %d] does not build vol by new\n",
                    fr->step, icrds[0],icrds[1]); 
#endif /* if defined(DEBUG) */
                continue; 
            }
            if(is_complex_blk(Comp_blk(icrds,old_ntg->blk_type,old_ntg)))
            {
#if defined(DEBUG)
                printf("Step[%d] blk[%d %d] does not build vol by old\n",
                    fr->step, icrds[0],icrds[1]); 
#endif /* if defined(DEBUG) */
                continue; 
            }

            if( CSG_blk_on_front(icrds, new_ntg, old_ntg, t_crx, dt,
                  &Comp_blk(icrds,csg_blk_crx,old_ntg)))
            {
                if (YES != CSG_volume_construct(icrds,
                    Comp_blk(icrds,csg_blk_crx,old_ntg),
                     new_ntg, old_ntg))
                {
                    printf("ERROR: In build_CSG_volume3d(),");
                    printf(" can not construct CSG_vol\n");
                    print_csg_blk_crx(Comp_blk(icrds,csg_blk_crx,old_ntg)); 
                    print_solid(Comp_blk(icrds,csg_blk_crx,old_ntg));
                    free_csg_blk_crx_vol(&Comp_blk(icrds,csg_blk_crx,old_ntg));
                    clean_up(ERROR);
                }

                Comp_blk(icrds,old_ntg->blk_type,old_ntg) = F_VOL; 
                total_vol++;
            }
            else
                Comp_blk(icrds,csg_blk_crx,old_ntg) = NULL;
        }

        vector(&onfront_blk_crx, total_vol, sizeof(CSG_BLK_CRX*));
        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            icrds[0] = i; icrds[1] = j;
            if(Comp_blk(icrds,csg_blk_crx,new_ntg) != NULL)
            {
                set_vol_face_par(Comp_blk(icrds,csg_blk_crx,old_ntg),
                           new_ntg, old_ntg, dt);
                onfront_blk_crx[ii++] = Comp_blk(icrds,csg_blk_crx,old_ntg);
            }
        }

        if(fr->step %10 == 0)
           CSG_vol_to_geomview("gviewout",fr->step,csg_blk_crx,old_ntg, dt);
        
        CSG_vol_merger(csg_blk_crx, onfront_blk_crx, total_vol,
            new_ntg, old_ntg, dt);

        /*** DO not free here ***/
        // free_control_volume_storage(old_ntg);  

        DEBUG_LEAVE(build_CSG_volume3d)
        return YES;  
}

LOCAL  int  CSG_vol_merger(
         CSG_BLK_CRX     **csg_blk_crx,
         CSG_BLK_CRX     **onfront_blk_crx,
         int             total_vol,
         TRI_GRID        *new_ntg,
         TRI_GRID        *old_ntg,
         float           dt)
{
        int              i, j, smin[MAXD], smax[MAXD], min[MAXD], max[MAXD];
        CSG_merger       *top_merger_1st = NULL;
        CSG_merger       *btm_merger_l = NULL;
        CSG_merger       *singular_merger_l = NULL;
        CSG_merger       *tmp;
        int              ic[MAXD];
        CSG_Solid        *s, *unmerged_s;
        int              found = NO;

        DEBUG_ENTER(CSG_vol_merger)

        for (i = 0; i < 2; i++)
        {
            min[i] = smin[i] = 0;
            max[i] = smax[i] = new_ntg->comp_grid.gmax[i];
            smin[i] -= new_ntg->comp_grid.lbuf[i];
            smax[i] += new_ntg->comp_grid.ubuf[i];
        }

        fill_vol_for_sten(csg_blk_crx,new_ntg,old_ntg,dt); 

        DEBUG_ENTER(find_need_merge_top_tri_quadr_vol)
        for(i = 0; i < total_vol; i++)
        {
            find_need_merge_top_tri_quadr_vol(onfront_blk_crx[i],
                     &top_merger_1st);
        }
        DEBUG_LEAVE(find_need_merge_top_tri_quadr_vol)

        tmp = top_merger_1st;
        while(tmp)
        {
            find_1st_merger_candidate(tmp, smin, smax,
              csg_blk_crx, new_ntg, old_ntg);
            if(tmp->he == NULL)
            {
                printf("IN CSG_vol_merger()\n");
                printf("ERROR after find_1st_merger_candidate()\n");
                clean_up(ERROR);
            }
            tmp = tmp->next;
        }

        DEBUG_ENTER(remove_duplicate_from_merger_lst)

        remove_duplicate_from_merger_lst(&top_merger_1st);

        DEBUG_LEAVE(remove_duplicate_from_merger_lst)

        merge_1st_solid(top_merger_1st,
            csg_blk_crx, new_ntg, old_ntg);

        if(debugging("CSG_vol_merger"))
            printf("pass top merge_1st_solid()\n");

        reset_merge_list_for_2nd(top_merger_1st);

        merge_2nd_solid(top_merger_1st,
            csg_blk_crx, new_ntg, old_ntg);

        if(debugging("CSG_vol_merger"))
            printf("pass top merge_2nd_solid()\n");

        free_merge_list(&top_merger_1st);

        do{
            found = NO;
            unmerged_s = if_unmerged_trivial_btm_vol_left(
              min, max, csg_blk_crx, new_ntg);
            if(NULL != unmerged_s && unmerged_s->merged == NO)
            {
                perform_merge_solid(unmerged_s,csg_blk_crx,old_ntg,
                   smin,smax,"if_unmerged_trivial_btm_vol_left");
                found = YES;
            }
        }while(found);


        DEBUG_ENTER(find_need_merge_btm_tri_quadr_vol)
        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            ic[0] = i; ic[1] = j;
            find_need_merge_btm_tri_quadr_vol(
                Comp_blk(ic,csg_blk_crx,old_ntg), &btm_merger_l, min, max);
        }
        DEBUG_LEAVE(find_need_merge_btm_tri_quadr_vol)

        tmp = btm_merger_l;
        while(tmp)
        {
            find_btm_merger_candidate(tmp, smin, smax,
            csg_blk_crx, new_ntg, old_ntg);
            if(tmp->he == NULL)
            {
                 printf("ERROR in CSG_vol_merger()\n");
                 printf("find_btm_merger_candidate(), tmp->he is NULL\n");
                 clean_up(ERROR);
            }
            tmp = tmp->next;
        }

        merge_1st_solid(btm_merger_l,
            csg_blk_crx, new_ntg, old_ntg);

        if(debugging("CSG_vol_merger"))
            printf("pass top merge_1st_solid() for btm\n");

        reset_merge_list_for_2nd(btm_merger_l);

        merge_2nd_solid(btm_merger_l,
            csg_blk_crx, new_ntg, old_ntg);

        if(debugging("CSG_vol_merger"))
            printf("pass top merge_2nd_solid() for btm\n");

        free_merge_list(&btm_merger_l);

        DEBUG_ENTER(if_unmerged_trivial_top_vol_left)
        do{
            found = NO;
            unmerged_s = if_unmerged_trivial_top_vol_left(
              min, max, csg_blk_crx, old_ntg);

            if(NULL != unmerged_s && unmerged_s->merged == NO)
            {
                perform_merge_solid(unmerged_s,csg_blk_crx,old_ntg,
                  smin,smax,"if_unmerged_trivial_top_vol_left");
                found = YES;
            }
        }while(found);
        DEBUG_LEAVE(if_unmerged_trivial_top_vol_left)

        DEBUG_ENTER(if_unmerged_small_top_vol_left)
        do{
            found = NO;
            unmerged_s = if_unmerged_small_top_vol_left(
              min, max, csg_blk_crx, old_ntg);
            if(NULL != unmerged_s && unmerged_s->merged == NO)
            {
                perform_merge_solid(unmerged_s,csg_blk_crx,old_ntg,
                   smin,smax,"if_unmerged_small_top_vol_left");
                found = YES;
            }
        }while(found);
        DEBUG_LEAVE(if_unmerged_small_top_vol_left)

        if(debugging("CSG_vol_merger"))
            printf("pass trivial top merge\n");

        DEBUG_LEAVE(CSG_vol_merger)
        return YES;
}

LOCAL void fill_vol_for_sten(
         CSG_BLK_CRX     **csg_blk_crx,
         TRI_GRID        *new_ntg,
         TRI_GRID        *old_ntg,
         float           dt)
{
        int              i, j, smin[MAXD], smax[MAXD];
        int              ic[MAXD];
        FILL_VOL         *fill_vol = NULL, *nxt_fill_vol;

        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = new_ntg->comp_grid.gmax[i];
            smin[i] -= new_ntg->comp_grid.lbuf[i];
            smax[i] += new_ntg->comp_grid.ubuf[i];
        }

        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            ic[0] = i; ic[1] = j;

            if(is_complex_blk(Comp_blk(ic,new_ntg->blk_type,new_ntg)))
                continue;
            if(is_complex_blk(Comp_blk(ic,old_ntg->blk_type,old_ntg)))
                continue;

            /* USE radius = 3, see if intfc smoothes */
            /* Comment: Probably 2 is better ???? */
            if(YES == if_need_fill_vol_blk(ic,2,smin,smax,csg_blk_crx,new_ntg))
                insert_fill_vol_ic(&fill_vol, ic, 2);
#if defined(DEBUG)
            /*
            if(ic[0] == 20 && ic[1] == 20)
                insert_fill_vol_ic(&fill_vol, ic, 2);
            */
#endif /* if defined(DEBUG) */
        }

        nxt_fill_vol = fill_vol;
        while(nxt_fill_vol)
        {
            if(NULL == Comp_blk(nxt_fill_vol->ic,csg_blk_crx,new_ntg))
            {
                init_csg_blk_crx(&Comp_blk(nxt_fill_vol->ic,csg_blk_crx,old_ntg),
                                 nxt_fill_vol->ic, new_ntg, old_ntg);
                create_box_vol(Comp_blk(nxt_fill_vol->ic,csg_blk_crx,old_ntg));
                Comp_blk(nxt_fill_vol->ic,csg_blk_crx,old_ntg)->s->vol = box_volume;
                Comp_blk(nxt_fill_vol->ic,csg_blk_crx,old_ntg)->s->unset = NO;

                set_vol_face_par(Comp_blk(nxt_fill_vol->ic, csg_blk_crx, new_ntg),
                            new_ntg, old_ntg, dt);
            }
            nxt_fill_vol = nxt_fill_vol->next;
        }
        free_fill_vol_ic(&fill_vol);

}


LOCAL CSG_Solid *if_unmerged_small_top_vol_left(
        int             *min,
        int             *max,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *old_ntg)
{
        int             i, j, n;
        CSG_Solid       *s, *root;
        CSG_Face        *f, *stat_f[2];
        int             where[3];
        int             icrds[MAXD+1], ic[MAXD];
        CSG_HalfEdge    *he[2];
        CURVE           **c;
        CSG_BLK_CRX     *blk_crx;
        int             found_top;
        float           area;

        for(i= min[0]; i < max[0]; i++)
            for(j = min[1]; j < max[1]; j++)
        {
            ic[0] = i; ic[1] = j;

            if((blk_crx = Comp_blk(ic,csg_blk_crx,old_ntg)) == NULL)
                continue;
            s = blk_crx->s;
            if(s == NULL)
            {
                continue;
            }
            while(s)
            {
                f = s->sfaces;
                area = 0.0;
                while(f)
                {
                    if(YES == long_is_top_or_bottom_face(f,where))
                    {
                        if(where[2] == 1)
                            area +=f->area;
                    }
                    f = f->nextf;
                }

                if(area < 0.5*rect_area)
                {
                    printf("THERE ARE unmerged_small_top_vol %f\n",
                            area);
                    if(s->merged == NO)
                        return s;
                }
                s = s->nexts;
            }
        }
        return NULL;
}


LOCAL CSG_Solid *if_unmerged_trivial_top_vol_left(
        int             *min,
        int             *max,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *old_ntg)
{
        int             i, j, n;
        CSG_Solid       *s, *root;
        CSG_Face        *f, *stat_f[2];
        int             where[3];
        int             icrds[MAXD+1], ic[MAXD];
        CSG_HalfEdge    *he[2];
        CURVE           **c;
        CSG_BLK_CRX     *blk_crx;
        int             found_top;

        for(i= min[0]; i < max[0]; i++)
            for(j = min[1]; j < max[1]; j++)
        {
            ic[0] = i; ic[1] = j;

            if((blk_crx = Comp_blk(ic,csg_blk_crx,old_ntg)) == NULL)
                continue;
            s = blk_crx->s;
            if(s == NULL)
            {
                continue;
                printf("ERROR: In if_unmerged_trivial_top_vol_left(),NULL Vol\n");
                clean_up(ERROR);
            }
            while(s)
            {
                f = s->sfaces;
                found_top = NO;
                while(f)
                {
                    if(YES == long_is_top_or_bottom_face(f,where))
                    {
                        if(where[2] == 1)
                        {
                            found_top = YES;
                            break;
                        }
                    }
                    f = f->nextf;
                }
                if(NO == found_top && s->merged == NO)
                {
                    return s;
                    /*
                    printf("ERROR, in if_unmerged_trivial_top_vol_left()\n");
                    printf("found trivial top vol:\n");
                    solidls(s,2);
                    clean_up(ERROR);
                    */
                }
                s = s->nexts;
            }
        }
        return NULL;
}




LOCAL int find_btm_merger_candidate(
        CSG_merger      *merger,
        int             *smin,
        int             *smax,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{

        int             i, j, n;
        int             icrds[MAXD+1], base[MAXD+1];
        CSG_Solid       *s;
        CSG_Face        *f, *stat_f[2];
        CSG_HalfEdge    *he[2];
        int             where[3], num_v[2];

        debug_print("tri", "Entered find_btm_merger_candidate()\n");

        // assert(merger->blk != NULL);
        memcpy(base, merger->s->blk->icrds[0][0][0].csg_pt.icrds,
               sizeof(int)*3);
        s = merger->s;
        // assert(s != NULL);
        f = s->sfaces;
        i = 0; n = 0;
        while(f)
        {
            if(YES == long_is_top_or_bottom_face(f,where))
            {
                n++;
                if(where[2] == 0)
                {
                    num_v[i] = merger_edge_of_loop(f->floops, &he[i]);
                    stat_f[i++] = f;
                }
            }
            f = f->nextf;
        }
        // assert(i > 0);
        switch(i)
        {
        case 1:
            if(n == 1)
            {
                switch(num_v[0])
                {
                case 3:
                    find_btm_merger_candidate_tri(merger,
                     he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    // assert(merger->he != NULL);
                break;
                case 4:
                    find_btm_merger_candidate_quadr(merger,
                    he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    // assert(merger->he != NULL);
                break;
                default:
                    printf("ERROR, find_merger_candidate(), unknown face case2 \n");
                    clean_up(ERROR);
                }
            }
        break;
        default:
            printf("ERROR, find_btm_merger_candidate(), unknown face case2 \n");
            clean_up(ERROR);
        break;
        }

        // assert(merger->he != NULL);
        debug_print("tri", "Left find_btm_merger_candidate()\n");
        return YES;
}


LOCAL void find_btm_merger_candidate_quadr(
        CSG_merger      *merger,
        CSG_HalfEdge    *he,
        int             *smin,
        int             *smax,
        int             *base,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        int             first)
{
        int             i, j;
        int             ic[MAXD+1];
        int             where;
        CSG_Solid       *s, *tmps;
        CSG_HalfEdge    *h1=NULL;
        CSG_POINT       *v1;

        s = merger->s;
        merger->he = he;

        /*
        assert(s != NULL);
        assert(he->vtx->pt->type == IS_ICRDS and
               he->nxt->vtx->pt->type == IS_ICRDS);
        assert(he->vtx->pt->csg_pt.icrds[2]
             == he->nxt->vtx->pt->csg_pt.icrds[2]);
        assert(s == he->wloop->lface->fsolid);
        assert(he->vtx->pt->type == IS_ICRDS and
               mate(he)->vtx->pt->type == IS_ICRDS);
        */

        for(i = base[0]-3; i < base[0]+3; i++)
        {
        for(j = base[1]-3; j < base[1]+3; j++)
        {

            ic[0] = i; ic[1] = j;
            if(ic[0] < smin[0] || ic[0] >= smax[0])
                continue;
            if(ic[1] < smin[1] || ic[1] >= smax[1])
                continue;
            if(Comp_blk(ic,old_ntg->Volume.blk,old_ntg) == NULL)
                continue;

            // assert(Comp_blk(ic,csg,new_ntg) != NULL);
            tmps = Comp_blk(ic,csg,old_ntg)->s;
            v1 = he->vtx->pt;
            while(tmps)
            {
                if(tmps == he->wloop->lface->fsolid)
                {
                    tmps = tmps->nexts;
                    continue;
                }

                h1=match_vol_in_other(mate(he), v1, tmps);
                if(h1 != NULL)
                {
                    goto jumpout;
                }
                tmps = tmps->nexts;
            }
        }
        }

        // assert(h1 != NULL);
jumpout:

        merger->h_nghbr[0] = mate(h1);
        merger->merge = YES;
}


LOCAL void find_btm_merger_candidate_tri(
        CSG_merger      *merger,
        CSG_HalfEdge    *he,
        int             *smin,
        int             *smax,
        int             *base,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        int             first)
{
        CSG_HalfEdge    *h1=NULL, *h2=NULL;

        h1 = find_merger_candidate_tri_1(merger,
                     he, smin, smax, base, csg, new_ntg, old_ntg,YES);
        h2 = find_merger_candidate_tri_1(merger,
                     he->prv, smin, smax, base, csg, new_ntg, old_ntg,YES);

        if(h1 != NULL && h2 != NULL)
            install_merger_candidate_tri(he, mate(h1), mate(h2), merger,first);
        else
        {
            /*
            printf("WARNING: IN find_merger_candidate_tri()\n");
            printf("Solid %d has NULL nghbr, nghbr blk[%d, %d], [%d, %d]\n",
                    s->solidno, icrds1[0], icrds1[1], icrds2[0], icrds2[1]);
            solidls(s, 2);
            assert(h1 != NULL or h2 != NULL);
            */
            if(h1 != NULL)
                install_merger_candidate_tri(he, mate(h1), NULL, merger,first);
            else
                install_merger_candidate_tri(he, mate(h2), NULL, merger,first);
        }

}

LOCAL CSG_HalfEdge *find_merger_candidate_tri_1(
        CSG_merger      *merger,
        CSG_HalfEdge    *he,
        int             *smin,
        int             *smax,
        int             *base,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        int             first)
{
        int             i, j;
        int             ic[MAXD+1];
        CSG_Solid       *s, *tmps;
        CSG_HalfEdge    *h1=NULL, *h2=NULL;
        CSG_POINT       *v1, *v2;
        int             where;

        s = merger->s;
        // assert(s != NULL);
        // assert(s == he->wloop->lface->fsolid);

        for(i = base[0]-3; i < base[0]+3; i++)
            for(j = base[1]-3; j < base[1]+3; j++)
        {

            ic[0] = i; ic[1] = j;
            if(ic[0] < smin[0] || ic[0] >= smax[0])
                continue;
            if(ic[1] < smin[1] || ic[1] >= smax[1])
                continue;
            if(Comp_blk(ic,old_ntg->Volume.blk,new_ntg) == NULL)
                continue;

            // assert(Comp_blk(ic,csg,new_ntg) != NULL);
            tmps = Comp_blk(ic,csg,old_ntg)->s;
            v2 = he->prv->vtx->pt;
            v1 = he->vtx->pt;
            while(tmps)
            {
                if(tmps == he->wloop->lface->fsolid)
                {
                    tmps = tmps->nexts;
                    continue;
                }

                h1=match_vol_in_other(mate(he), v1, tmps);
                if(h1 != NULL)
                    return h1;
                tmps = tmps->nexts;
            }
        }
        return NULL;
}


LOCAL void  find_need_merge_btm_tri_quadr_vol(
        CSG_BLK_CRX     *blk_crx,
        CSG_merger      **top_merger,
        int             *min,
        int             *max)
{
        int             i, j, n;
        CSG_Solid       *s, *root;
        CSG_Face        *f, *stat_f[2];
        int             where[3];
        int             icrds[MAXD+1], base[MAXD+1];
        CSG_HalfEdge    *he[2];

        if(blk_crx == NULL) return;

        s = blk_crx->s;
        if(s == NULL)
        {
            return;
            printf("ERROR: In find_need_merge_btm_tri_quadr_vol(),NULL Vol\n");
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }

        while(s)
        {
            i = 0; n = 0;
            f = s->sfaces;
            while(f)
            {
                if(YES == long_is_top_or_bottom_face(f,where))
                {
                    n++;
                    if(where[2] == 0)
                    {
                        stat_f[i++] = f;
                    }
                }
                f = f->nextf;
            }
            switch(i)
            {
            case 1:
                 if(n == 1)
                 {
                     if(CSG_loop_vtx_num(stat_f[0]->floops) > 4)
                     {
                         printf("ERROR, in find_need_merge_btm_tri_quadr_vol()\n");
                         printf("ERROR, btm face vertices > 4 \n");
                         print_csg_blk_crx(blk_crx);
                         solidls(s, 2);
                         clean_up(ERROR);
                     }
                     add_to_merge_list(s, blk_crx, top_merger);
                 }
            break;
            case 0:
                 if(blk_crx->icrds[0][0][0].csg_pt.icrds[0] >= min[0]
                    && blk_crx->icrds[0][0][0].csg_pt.icrds[0] <= max[0]
                    && blk_crx->icrds[0][0][0].csg_pt.icrds[1] >= min[1]
                    && blk_crx->icrds[0][0][0].csg_pt.icrds[1] <= max[1])
                 {
                     printf("ERROR, in find_need_merge_btm_tri_quadr_vol()\n");
                     printf("ERROR, NONE_BTM_VOL still exist\n");
                     print_csg_blk_crx(blk_crx);
                     solidls(s, 2);
                     clean_up(ERROR);
                 }
            break;
            }
            s = s->nexts;
        }
}



LOCAL void perform_merge_solid(
        CSG_Solid       *mgs,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *old_ntg,
        int             *smin,
        int             *smax,
        char            *msg)
{
        int             ic[MAXD+1], icrds[MAXD+1];
        int             i, j;
        CSG_BLK_CRX     *blk;
        CSG_Face        *f = NULL;
        CSG_Solid       *s;
        int             found = NO;

        debug_print("tri","Entered perform_merge_solid()\n");

        if(mgs == NULL) return;
        else
        {
            f = mgs->sfaces;
            while(f)
            {
                if(YES == is_interior_face(f))
                {
                    found = YES;
                    break;
                }
                f = f->nextf;
            }

            if(NO == found)
            {
                (void)printf("ERROR: does not find interior"
                             " face in perform_merge_solid()\n");
                printf("at the case: %s\n", msg);
                solidls(mgs, 2);
                clean_up(ERROR);
            }

            found = NO;
            memcpy(ic, mgs->icrds,sizeof(int)*3);
            for(i = ic[0]-4; i < ic[0]+4; i++)
            {
                for(j = ic[1]-4; j < ic[1]+4; j++)
                {
                    icrds[0] = i; icrds[1] = j;
                    if(icrds[0] < smin[0] || icrds[0] >= smax[0])
                        continue;
                    if(icrds[1] < smin[1] || icrds[1] >= smax[1])
                        continue;
                    if((blk = Comp_blk(icrds,old_ntg->Volume.blk,old_ntg)) == NULL)
                        continue;
                    s = blk->s;
                    while(s)
                    {
                        if(s == mgs)
                        {
                             s = s->nexts;
                             continue;
                        }
                        if(can_two_solid_merge_by_f(s,f))
                        {
                            remove_vol_from_blk_list(
                                     mgs->blk, mgs);

                            solid_glue(s,&mgs);

                            debug_print("tri","Leaving perform_merge_solid()\n");
                            return;
                        }
                        s = s->nexts;
                    }
                }
            }
        }

        printf("WARNING:  perform_merge_solid(), solid %d"
               " does not merge with other\n", mgs->solidno); 
        mgs->merged = YES; 
        /*
        printf("ERROR in perform_merge_solid()\n");
        printf("DO not found solid to merge with\n");
        solidls(mgs, 2);
        clean_up(ERROR);
        */
}


LOCAL int can_two_solid_merge_by_f(
        CSG_Solid        *master,
        CSG_Face        *slave_f)
{
        CSG_Face        *mf;

        if(master->comp != slave_f->fsolid->comp)
            return NO;

        for(mf = master->sfaces; mf != NULL; mf = mf->nextf)
        {
             if(CSG_face_match(mf, slave_f))
             {
                 return YES;
             }
        }

        return NO;
}

/*  is_interior_face() by the observation:
 *  The front face must only be composed
 *  of crxing points. It replaces
 *  if_interior_face()
 */
EXPORT int is_interior_face(
        CSG_Face      *f)
{
        CSG_HalfEdge  *lh;
        int           all_crx = YES;

        lh = f->floops->ledg;
        do
        {
            if(lh->vtx->pt->type == IS_ICRDS)
            {
                all_crx = NO;
                break;
            }
        }while((lh = lh->nxt) != f->floops->ledg);

        if(all_crx == YES)
            return NO;
        else
            return YES;
}

/*** if_interior_face() is costly and 
 *** might not right. 
LOCAL int if_interior_face(
        CSG_Face      *f,
        TRI_GRID      *ntg)
{
        int           icrds[MAXD], ic1[MAXD];
        int           i, j;
        static int    smin[MAXD], smax[MAXD];
        static float  dh[MAXD];
        static int    first = YES;
        CSG_BLK_CRX   *blk;
        CSG_Solid     *s;
        CSG_Face      *match_f = NULL;
        CSG_POINT     *pt;
        CSG_HalfEdge  *h;
        float         crds[MAXD+1], p[MAXD+1];
        int           found = NO;

        DEBUG_ENTER(if_interior_face)

        if(first)
        {
            for (i = 0; i < 2; i++)
            {
                smin[i] = 0;
                smax[i] = ntg->comp_grid.gmax[i];
                smin[i] -= ntg->comp_grid.lbuf[i];
                smax[i] += ntg->comp_grid.ubuf[i];
                dh[i] = ntg->rect_grid.h[i];
            }
            first = NO;
        }

        if(fabs(f->face_eqn[2]) >= 0.1*TOL)
        {
            DEBUG_LEAVE(if_interior_face)
            return NO;
        }

        h = f->floops->ledg;
        do
        {
            if(h->vtx->pt->type == IS_ICRDS)
            {
                ic1[0] = h->vtx->pt->csg_pt.icrds[0];
                ic1[1] = h->vtx->pt->csg_pt.icrds[1];
                break;
            }
        }while((h = h->nxt) != f->floops->ledg);

        for(i = ic1[0]-1; i <= ic1[0]+1; i++)
        {
            for(j = ic1[1]-1; j <= ic1[1]+1; j++)
            {
                icrds[0] = i; icrds[1] = j;
                if(icrds[0] < smin[0] || icrds[0] >= smax[0])
                    continue;
                if(icrds[1] < smin[1] || icrds[1] >= smax[1])
                    continue;
                if((blk = Comp_blk(icrds,ntg->Volume.blk,ntg)) == NULL)
                    continue;

                s = blk->s;
                while(s)
                {
                    if(s == f->fsolid)
                    {
                        s = s->nexts;
                        continue;
                    }
                    match_f = match_face_in_other(f, s);
                    if(match_f != NULL)
                    {
                        if(f->fsolid->comp != match_f->fsolid->comp)
                        {
                            DEBUG_LEAVE(if_interior_face)
                            return NO;
                        }
                        DEBUG_LEAVE(if_interior_face)
                        return YES;
                    }
                    s = s->nexts;
                }
            }
        }

        for(i = ic1[0]-3; i < ic1[0]+3; i++)
        {
            for(j = ic1[1]-3; j < ic1[1]+3; j++)
            {
                icrds[0] = i; icrds[1] = j;
                if(icrds[0] < smin[0] || icrds[0] >= smax[0])
                    continue;
                if(icrds[1] < smin[1] || icrds[1] >= smax[1])
                    continue;
                if((blk = Comp_blk(icrds,ntg->Volume.blk,ntg)) == NULL)
                    continue;
                s = blk->s;
                while(s)
                {
                    if(s == f->fsolid)
                    {
                        s = s->nexts;
                        continue;
                    }

                    match_f = match_face_in_other(f, s);

                    if(match_f != NULL)
                    {
                        if(f->fsolid->comp != match_f->fsolid->comp)
                        {
                            DEBUG_LEAVE(if_interior_face)
                            return NO;
                        }
                        DEBUG_LEAVE(if_interior_face)
                        return YES;
                    }
                    s = s->nexts;
                }
            }
        }

        // in the case there is no outter nghbr
        if((fabs(f->face_eqn[0]) > ONEMTOL &&
            fabs(f->face_eqn[1]) < 0.01*TOL &&
            fabs(f->face_eqn[2]) <  0.01*TOL) ||
            (fabs(f->face_eqn[1]) > ONEMTOL &&
            fabs(f->face_eqn[0]) < 0.01*TOL &&
            fabs(f->face_eqn[2]) <  0.01*TOL))
        {
            i = 0;
            crds[0] = crds[1] = 0.0;
            h = f->floops->ledg;
            do
            {
                if(h->vtx->pt->type == IS_ICRDS)
                {
                    CSG_point_Coord(h->vtx->pt,p);
                    crds[0] += p[0];
                    crds[1] += p[1];
                    i++;
                }
            }while((h = h->nxt) != f->floops->ledg);
            if(i == 0)
            {
                printf("ERROR in is_interior_face(), "
                       " i =0 \n");
                clean_up(ERROR);
            }
            crds[0] = crds[0]/i;
            crds[1] = crds[1]/i;
            crds[0] = crds[0]+f->face_eqn[0]*dh[0]/2;
            crds[1] = crds[1]+f->face_eqn[1]*dh[1]/2;
            if(rect_in_which(crds,icrds, &ntg->comp_grid) == FUNCTION_FAILED)
            {
                printf("ERROR in is_interior_face(), "
                       "rect_in_which() failed\n");
                clean_up(ERROR);
            }
            if(icrds[0] < smin[0] || icrds[0] >= smax[0])
            {
                DEBUG_LEAVE(if_interior_face_old)
                return YES;
            }
            if(icrds[1] < smin[1] || icrds[1] >= smax[1])
            {
                DEBUG_LEAVE(if_interior_face)
                return YES;
            }
            if((blk = Comp_blk(icrds,ntg->Volume.blk,ntg)) == NULL)
            {
                if(f->fsolid->comp != Regular_grid_comp(icrds,ntg))
                {
                    printf("ERROR in is_interior_face_old()\n");
                    printf("f->fsolid->comp != Regular_grid_com, ic[%d,%d]\n",
                        icrds[0], icrds[1]); 
                    facels(f, 2);
                    solidls(f->fsolid,2);
                }
                DEBUG_LEAVE(if_interior_face)
                return YES;
            }
        }
        (void)printf("In if_interior_face()\n");
        (void)printf("Face does not find outter state\n");
        (void)printf("face-eqn<%f, %f, %f> ic1<%d, %d> <%f, %f>\n",
                f->face_eqn[0], f->face_eqn[1], f->face_eqn[2],
                ic1[0], ic1[1], Coords(Regular_comp_grid_node(ic1,ntg))[0],
                 Coords(Regular_comp_grid_node(ic1,ntg))[0]);
        facels(f, 2);
        solidls(f->fsolid,2);
        clean_up(ERROR);

        DEBUG_LEAVE(if_interior_face)
}
***/


EXPORT  CSG_Face *match_face_in_other(
        CSG_Face        *f,
        CSG_Solid       *s)
{
        CSG_Face        *match_f;

        for(match_f = s->sfaces; match_f != NULL; 
            match_f = match_f->nextf)
        {
            if(CSG_face_match(f,match_f))
            {
                return match_f;
            }
        }
        return NULL;
}

/*** For a given face, find its match.
 *** The matched face might be on the
 *** other side of the interface.
 ***/
EXPORT CSG_Face *find_match_face_in_region4(
        CSG_Face    *f,
        int         *ic,
        TRI_GRID    *ntg)
{
        int         i, j;
        CSG_Face    *match_f;
        int         icrds[MAXD];
        CSG_Solid   *s;
        CSG_BLK_CRX   *blk;

        for(i = ic[0]-3; i <= ic[0]+3; i++)
        {
            for(j = ic[1]-3; j <= ic[1]+3; j++)
            {
                icrds[0] = i; icrds[1] = j;
                if(icrds[0] < -ntg->comp_grid.lbuf[0] || 
                   icrds[0] >= (ntg->comp_grid.gmax[0] + 
                                ntg->comp_grid.ubuf[0]))
                    continue;
                if(icrds[1] < -ntg->comp_grid.lbuf[1] || 
                   icrds[1] >= (ntg->comp_grid.gmax[1] +
                                ntg->comp_grid.ubuf[1]))
                    continue;
                if((blk = Comp_blk(icrds,ntg->Volume.blk,ntg)) == NULL)
                    continue;
                s = blk->s;
                while(s)
                {
                    if(s == f->fsolid)
                    {
                        s = s->nexts;
                        continue;
                    }
                    match_f = match_face_in_other(f, s);
                    if(match_f == NULL)
                        s = s->nexts;
                    else
                        return match_f;
                 }
             }  /* End of for loop */
         }
         return NULL;
}

/* Find the surrounding neighbors for the solid "s". 
 * The solid on the other side of the interface is
 * also considered as a neighbor of "s" 
 * if they share common face.
 */
EXPORT int neighbors_for_solid(
        CSG_Solid       *s,
        TRI_GRID        *ntg,
        Solid_nghbr     **nghbrs)
{
        int        icrds[MAXD], ic[MAXD], i; 
        CSG_Face      *f, *match_f; 
        Solid_nghbr   *snghbrs; 
        int        alloc = 10;  
        int        where[3], num = 0;
        float      crds[MAXD]; 
        RECT_GRID  *rgr = &(ntg->comp_grid);

        vector(&snghbrs, 10, sizeof(Solid_nghbr));
        memcpy(ic, s->icrds, sizeof(int)*rgr->dim); 

        f = s->sfaces; 
        while(f)
        {
            if(YES != is_top_or_bottom_face(f,where))
            {
                match_f = find_match_face_in_region4(f,ic,ntg); 
                if(match_f == NULL)
                {
                    if(! is_interior_face(f))
                    {
                        printf("ERROR neighbors_for_solid\n");
                        printf("front face does not have match\n");
                        facels(f, 2); 
                        solidls(f->fsolid, 2);
                        clean_up(ERROR); 
                    }
                    else
                    {
                        for(i = 0; i < 2; i++)
                            crds[i] = f->centroid[i];
                        crds[0] = crds[0]+f->face_eqn[0]*rgr->h[0]/2;
                        crds[1] = crds[1]+f->face_eqn[1]*rgr->h[1]/2;
                        /** cell inside the domain **/
                        if(rect_in_which(crds,icrds, rgr) != 
                                FUNCTION_FAILED)
                        {
                            if(icrds[0] >= -rgr->lbuf[0] &&
                               icrds[0] < (rgr->gmax[0]+rgr->ubuf[0]) &&
                               icrds[1] >= -rgr->lbuf[1] &&
                               icrds[1] < (rgr->gmax[1]+rgr->ubuf[1]))
                            {
                                snghbrs[num].type = IS_ICRDS; 
                                memcpy(snghbrs[num].nghbr.icrds,icrds,
                                       sizeof(int)*rgr->dim);  
                                num++; 
                                if(num == alloc)
                                {
                                    Solid_nghbr   *tmpnghbrs; 
                                    alloc += 10;
                                    vector(&tmpnghbrs,alloc,sizeof(Solid_nghbr));
                                    assign(tmpnghbrs,snghbrs,
                                       sizeof(Solid_nghbr)*num); 
                                    free(snghbrs); 
                                    snghbrs = tmpnghbrs; 
                                }
                            }
                        }
                    }
                }
                else
                {
                    snghbrs[num].type = IS_SOLID; 
                    snghbrs[num].nghbr.s = match_f->fsolid; 
                    num++; 
                    if(num == alloc)
                    {
                        Solid_nghbr   *tmpnghbrs; 
                        alloc += 10;
                        vector(&tmpnghbrs,alloc,sizeof(Solid_nghbr));
                        assign(tmpnghbrs,snghbrs,sizeof(Solid_nghbr)*num); 
                        free(snghbrs); 
                        snghbrs = tmpnghbrs; 
                    }
                }
            }
            f = f->nextf;
        }

        if(num == 0)
        {
            free(snghbrs);  
            (*nghbrs) = NULL; 
        }
        else
            (*nghbrs) = snghbrs; 
        return num;  
}

LOCAL CSG_Solid *if_unmerged_trivial_btm_vol_left(
        int             *min,
        int             *max,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *new_ntg)
{
        int             i, j, n;
        CSG_Solid       *s, *root;
        CSG_Face        *f, *stat_f[2];
        int             where[3];
        int             icrds[MAXD+1], ic[MAXD];
        CSG_HalfEdge    *he[2];
        CURVE           **c;
        CSG_BLK_CRX     *blk_crx;
        int             found_btm;

        for(i= min[0]; i < max[0]; i++)
            for(j = min[1]; j < max[1]; j++)
        {
            ic[0] = i; ic[1] = j;

            if((blk_crx = Comp_blk(ic,csg_blk_crx,new_ntg)) == NULL)
                continue;
            s = blk_crx->s;
            if(s == NULL)
            {
                continue;
                printf("ERROR: In if_unmerged_trivial_btm_vol_left(),NULL Vol\n");
                clean_up(ERROR);
            }
            while(s)
            {
                f = s->sfaces;
                found_btm = NO;
                while(f)
                {
                    if(YES == long_is_top_or_bottom_face(f,where))
                    {
                        if(where[2] == 0)
                        {
                            found_btm = YES;
                            break;
                        }
                    }
                    f = f->nextf;
                }
                if(NO == found_btm && s->merged == NO)
                {
                    return s;
                    /*
                    printf("ERROR, in if_unmerged_trivial_btm_vol_left()\n");
                    printf("found trivial top vol:\n");
                    solidls(s,2);
                    clean_up(ERROR);
                    */
                }
                s = s->nexts;
            }
        }
        return NULL;
}



LOCAL void merge_2nd_solid(
        CSG_merger      *merger,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        CSG_merger      *tmp;
        int             ic[MAXD+1], icrds[MAXD+1];
        int             i, j;
        int             smin[MAXD], smax[MAXD];
        CSG_BLK_CRX     *blk;
        CSG_Solid       *s;
        CSG_Face        *match_f = NULL;
        CSG_POINT       *pt;
        float           p[MAXD+1];
        int             found = NO;
        float           crds[MAXD];

        debug_print("tri","Entered merge_2nd_solid()\n");

        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = new_ntg->comp_grid.gmax[i];
            smin[i] -= new_ntg->comp_grid.lbuf[i];
            smax[i] += new_ntg->comp_grid.ubuf[i];
        }

        tmp = merger;
        while(tmp)
        {
            if(tmp->merge)
            {
                perform_merge_2nd_solid(tmp,csg_blk_crx,old_ntg,smin,smax);
            }
            tmp = tmp->next;
        }

        debug_print("tri","Leaving merge_2nd_solid()\n");
}


LOCAL void perform_merge_2nd_solid(
        CSG_merger      *now,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *old_ntg,
        int             *smin,
        int             *smax)
{
        int             ic[MAXD+1], icrds[MAXD+1];
        int             i, j;
        CSG_BLK_CRX     *blk;
        CSG_Solid       *s, *merg_s;
        CSG_Face        *match_f = NULL;
        CSG_POINT       *pt;
        float           p[MAXD+1];
        int             found = NO;
        float           crds[MAXD];

        debug_print("tri","Entered perform_merge_2nd_solid()\n");

        if(now->merge)
        {
            memcpy(ic,now->he->wloop->lface->fsolid->icrds,sizeof(int)*3);
            for(i = ic[0]-3; i < ic[0]+3; i++)
            {
                for(j = ic[1]-3; j < ic[1]+3; j++)
                {
                    icrds[0] = i; icrds[1] = j;
                    if(icrds[0] < smin[0] || icrds[0] >= smax[0])
                        continue;
                    if(icrds[1] < smin[1] || icrds[1] >= smax[1])
                        continue;
                    if((blk = Comp_blk(icrds,old_ntg->Volume.blk,old_ntg)) == NULL)
                        continue;
                    s = blk->s;
                    while(s)
                    {
                        if(s == now->he->wloop->lface->fsolid)
                        {
                             s = s->nexts;
                             continue;
                        }
                        /*
                        if(can_two_solid_merge(s,now->he->wloop->lface->fsolid))
                        */
                        if(now->he == NULL)
                        {
                            printf("ERRROR, in perform_merge_2nd_solid()\n");
                            printf("now->he == NULL\n");
                            clean_up(ERROR);
                        }
                        if(can_two_solid_merge(s,now->he))
                        {
                            remove_vol_from_blk_list(
                                  now->he->wloop->lface->fsolid->blk,
                                  now->he->wloop->lface->fsolid);
                            merg_s = now->he->wloop->lface->fsolid;
                            /*
                            s->n_btm += merg_s->n_btm;
                            */
                            solid_glue(s,&merg_s);

                            debug_print("tri","Leaving perform_merge_2nd_solid()\n");
                            return;
                        }
                        s = s->nexts;
                    }
                }
            }
        }

        printf("ERROR in perform_merge_2nd_solid()\n");
        printf("DO not found solid to merge with\n");
        solidls(now->he->wloop->lface->fsolid, 2);
        facels(mate(now->he)->wloop->lface, 2);
        clean_up(ERROR);

}

LOCAL int can_two_solid_merge(
        CSG_Solid        *master,
        CSG_HalfEdge     *slave_he)
{
        CSG_Face        *mf;

        if(master->comp != slave_he->wloop->lface->fsolid->comp)
            return NO;

        for(mf = master->sfaces; mf != NULL; mf = mf->nextf)
        {
             if(CSG_face_match(mf,mate(slave_he)->wloop->lface))
             {
                 return YES;
             }
        }

        return NO;
}



LOCAL void reset_merge_list_for_2nd(
        CSG_merger      *list)
{
        CSG_merger      *tmp;
        tmp = list;
        while(tmp)
        {
            if(tmp->he == NULL)
            {
                printf("ERROR in reset_merge_list_for_2nd()\n");
                clean_up(ERROR);
            }
            if(tmp->merge == YES)
                tmp->merge = NO;
            else
                tmp->merge = YES;
            tmp = tmp->next;
        }
}


LOCAL void merge_1st_solid(
        CSG_merger      *merger,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int             where[2], num_v[2];
        CSG_merger      *tmp;

        debug_print("tri","Entered merge_1st_solid()\n");

        tmp = merger;
        while(tmp)
        {
            if(tmp->merge)
            {
                if(tmp->h_nghbr[0] == NULL)
                {
                    printf("ERROR in merge_1st_solid()\n");
                    printf("tmp->h_nghbr[0] == NULL\n");
                    clean_up(ERROR);
                }
                if(tmp->h_nghbr[1] != NULL)
                {
                    printf("ERROR in merge_1st_solid()\n");
                    printf("tmp->h_nghbr[1] != NULL\n");
                    clean_up(ERROR);
                }
                if(tmp->he->wloop->lface->fsolid ==
                       tmp->h_nghbr[0]->wloop->lface->fsolid)
                {
                    tmp = tmp->next;
                    continue;
                }
                merge_solid_with_1_nghbr(NULL, tmp, 
                        csg_blk_crx, new_ntg, old_ntg);
            }
            tmp = tmp->next;
        }

        debug_print("tri","Leaving merge_1st_solid()\n");
}


LOCAL void merge_solid_with_1_nghbr(
        CSG_merger      *merger,
        CSG_merger      *now,
        CSG_BLK_CRX     **csg_blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int             base[MAXD+1];
        int             where[2], num_v[2];
        CSG_BLK_CRX     *src;
        int             i, n_st_face;
        CSG_Solid       *merge_s, *tmps;

        // debug_print("tri", "Entered merge_solid_with_1_nghbr()\n");

        src = now->blk;
        memcpy(base, now->blk->icrds[0][0][0].csg_pt.icrds,
                 sizeof(int)*3);

        tmps = now->s;
        remove_vol_from_blk_list(now->s->blk, now->s);
        if(now->s != now->he->wloop->lface->fsolid)
        {
            printf("ERROR in merge_solid_with_1_nghbr()\n");
            printf("after emove_vol_from_blk_list(), s not equal he->s\n");
            clean_up(ERROR);
        }
        if(tmps != now->s)
        {
            printf("ERROR in merge_solid_with_1_nghbr()\n");
            printf("after emove_vol_from_blk_list(), s changed\n");
            clean_up(ERROR);
        }
        merge_s = now->s;
        solid_glue(now->h_nghbr[0]->wloop->lface->fsolid,
             &merge_s);
        now->s = NULL;
        // debug_print("tri", "Left merge_solid_with_1_nghbr()\n");
}


LOCAL void remove_vol_from_blk_list(
        CSG_BLK_CRX     *blk,
        CSG_Solid       *vol)
{
        int             found = NO;
        CSG_Solid       *s;
        if(blk == NULL)
            return;
        s = blk->s;
        while(s)
        {
            if(s == vol)
            {
                found = YES;
                break;
            }
            s = s->nexts;
        }

        if(found == NO)
            return;
        if(blk->s == vol)
        {
            if(blk->s->prevs != NULL)
            {
                printf("ERROR in remove_vol_from_blk_list()\n");
                printf("s is not the first in blk\n");
                clean_up(ERROR);
            }
            blk->s = vol->nexts;
            if(blk->s)
                blk->s->prevs = NULL;
            vol->prevs = NULL; vol->nexts = NULL;
            return;
        }
        if(vol->prevs)
            vol->prevs->nexts = vol->nexts;
        if(vol->nexts)
            vol->nexts->prevs = vol->prevs;
        vol->prevs = NULL; vol->nexts = NULL;
}



LOCAL void remove_duplicate_from_merger_lst(
        CSG_merger      **merger_lst)
{
        CSG_merger      *tmp, *tmp2, *tmp3;

        tmp = *merger_lst;
        while(tmp)
        {
            tmp2 = tmp->next;
            while(tmp2)
            {
                if(tmp->merge)
                {
                    if((tmp->he->wloop->lface->fsolid ==
                        tmp2->he->wloop->lface->fsolid &&
                        tmp->h_nghbr[0]->wloop->lface->fsolid ==
                        tmp2->h_nghbr[0]->wloop->lface->fsolid) ||
                       (tmp->he->wloop->lface->fsolid ==
                        tmp2->h_nghbr[0]->wloop->lface->fsolid &&
                        tmp->h_nghbr[0]->wloop->lface->fsolid ==
                        tmp2->he->wloop->lface->fsolid))
                    {
                        if(! tmp2->merge)
                        {
                            printf("ERROR in remove_duplicate_from_merger_lst()\n");
                            printf("tmp and tmp2 have diff flags\n");
                            clean_up(ERROR);
                        }
                        if(tmp->h_nghbr[1] != NULL || tmp2->h_nghbr[1] != NULL)
                        {
                            printf("ERROR in remove_duplicate_from_merger_lst()\n");
                            printf("tmp or tmp2 have h_nghbr[1] set\n");
                            clean_up(ERROR);
                        }
                        tmp3 = tmp2;
                        if(tmp2->prev)
                            tmp2->prev->next = tmp2->next;
                        if(tmp2->next)
                            tmp2->next->prev = tmp2->prev;
                        tmp2 = tmp2->next;
                        free(tmp3);
                        continue;
                    }
                }
                tmp2 = tmp2->next;
            }
            tmp = tmp->next;
        }
}

/**** find_1st_merger_candidate() ****/
/** Merge the volume with small top face. 
 **   The top face is single. 
 **/
LOCAL void find_1st_merger_candidate(
        CSG_merger      *merger,
        int             *smin,
        int             *smax,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int             i, j, n;
        int             icrds[MAXD+1], base[MAXD+1];
        CSG_Solid       *s;
        CSG_Face        *f, *stat_f[2];
        CSG_HalfEdge    *he[2];
        int             where[3], num_v[2];

        if(merger->blk == NULL || merger->s == NULL)
        {
            printf("ERROR in find_1st_merger_candidate(), merger->blk NULL\n");
            clean_up(ERROR);
        }

        memcpy(base, merger->s->blk->icrds[0][0][0].csg_pt.icrds,
               sizeof(int)*3);
        s = merger->s;
        f = s->sfaces;
        i = 0; n = 0;
        while(f)
        {
            if(YES == long_is_top_or_bottom_face(f,where))
            {
                n++;
                if(where[2] == 1)
                {
                    num_v[i] = merger_edge_of_loop(f->floops, &he[i]);
                    stat_f[i++] = f;
                    if(i > 2)
                    {
                        printf("ERROR find_1st_merger_candidate()\n");
                        printf("i > 2, i = %d\n", i);
                        clean_up(ERROR);
                    }
                }
            }
            f = f->nextf;
        }

        switch(i)
        {
        case 1:
            if(n == 1)
            {
                switch(num_v[0])
                {
                case 3:
                    find_merger_candidate_tri(merger,
                     he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    if(merger->he == NULL)
                    {
                        printf("ERROR, find_1st_merger_candidate()\n");
                        printf("After find_merger_candidate_tri, merger->he = NULL\n");
                        clean_up(ERROR);
                    }
                break;
                case 4:
                    find_merger_candidate_quadr(merger,
                    he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    if(merger->he == NULL)
                    {
                        printf("ERROR, find_1st_merger_candidate()\n");
                        printf("After find_merger_candidate_quadr, merger->he = NULL\n");
                        clean_up(ERROR);
                    }
                break;
                case 5:
                case 6:
                    printf("IN find_1st_merger_candidate(), "
                        "processing n = %d\n",num_v[0]);
                    solidls(s, 2); 
                    clean_up(ERROR);
                break;
                default:
                    printf("ERROR, find_1st_merger_candidate(), unknown face case2 \n");
                    clean_up(ERROR);
                }
            }
            else if(stat_f[0]->area < 0.5*rect_area)
            {
                switch(num_v[0])
                {
                case 3:
                    find_merger_candidate_tri(merger,
                     he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    if(merger->he == NULL)
                    {
                        printf("ERROR, find_1st_merger_candidate()\n");
                        printf("(2) After find_merger_candidate_tri, merger->he = NULL\n");
                        clean_up(ERROR);
                    }
                break;
                case 4:
                    find_merger_candidate_quadr(merger,
                    he[0], smin, smax, base, csg, new_ntg, old_ntg,YES);
                    if(merger->he == NULL)
                    {
                        printf("ERROR, find_1st_merger_candidate()\n");
                        printf("(2) After find_merger_candidate_quadr, merger->he = NULL\n");
                        clean_up(ERROR);
                    }
                break;
                case 5:
                case 6:
                    printf("IN find_1st_merger_candidate(), 5,6"
                        "processing n = %d\n",num_v[0]);
                    solidls(s, 2);
                    facels(stat_f[0],2);
                    clean_up(ERROR);
                break;
                default:
                    printf("ERROR, find_1st_merger_candidate(), unknown face case2 \n");
                    clean_up(ERROR);
                }
            }
        break;
        default:
            printf("ERROR, find_merger_candidate(), unknown face case2 i = %d\n",i);
            clean_up(ERROR);
        break;
        }

        if(merger->he == NULL)
        {
            printf("ERROR in find_1st_merger_candidate()\n");
            printf("merger->he is NULL\n");
            clean_up(ERROR);
        }
}

LOCAL void find_merger_candidate_quadr(
        CSG_merger      *merger,
        CSG_HalfEdge    *he,
        int             *smin,
        int             *smax,
        int             *base,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        int             first)
{
        int             i, j;
        int             icrds[MAXD+1];
        int             where;
        CSG_Solid       *s, *tmps;
        CSG_HalfEdge    *h1=NULL;
        CSG_POINT       *v1;

        debug_print("tri", "Entered find_merger_candidate_quadr()\n");

        s = merger->s;

#if defined(DEBUG)
        if(he->vtx->pt->type != IS_ICRDS ||
               he->nxt->vtx->pt->type != IS_ICRDS)
        {
            printf("ERROR: find_merger_candidate_quadr()\n");
            printf(" he->vtx->pt->type != IS_ICRDS or he->nxt->vtx->pt->type != IS_ICRDS\n");
            solidls(s,2);
            clean_up(ERROR);
        }
        if(he->vtx->pt->csg_pt.icrds[2]
             != he->nxt->vtx->pt->csg_pt.icrds[2])
        {
            printf("ERROR: find_merger_candidate_quadr()\n");
            printf(" he->vtx->pt->csg_pt.icrds[2] != he->nxt->vtx->pt->csg_pt.icrds[2] \n");
            solidls(s,2);
            clean_up(ERROR);
        }
        if(s != he->wloop->lface->fsolid)
        {
            printf("ERROR: find_merger_candidate_quadr()\n");
            printf(" s != he->wloop->lface->fsolid\n");
            solidls(s,2);
            solidls(he->wloop->lface->fsolid,2);
            clean_up(ERROR);
        }
#endif /* if defined(DEBUG) */

        where = he->vtx->pt->csg_pt.icrds[2];
        if(he->vtx->pt->csg_pt.icrds[0] ==
           he->nxt->vtx->pt->csg_pt.icrds[0])
        {
            if(he->vtx->pt->csg_pt.icrds[0] == base[0])
                icrds[0] = base[0]-1;
            else
                icrds[0] = he->vtx->pt->csg_pt.icrds[0];
            icrds[1] = base[1];
        }
        else if(he->vtx->pt->csg_pt.icrds[1] ==
               he->nxt->vtx->pt->csg_pt.icrds[1])
        {
            if(he->vtx->pt->csg_pt.icrds[1] == base[1])
                icrds[1] = base[1]-1;
            else
                icrds[1] = he->vtx->pt->csg_pt.icrds[1];
            icrds[0] = base[0];
        }
        else
        {
            printf("ERROR, find_merger_candidate_quadr(),"
                " he is not coincident with cell edge\n");
            clean_up(ERROR);
        }
        merger->he = he;
        if(icrds[0] >= smin[0] && icrds[1] >= smin[1] &&
           icrds[0] < smax[0] && icrds[1] < smax[1])
        {
            if(Comp_blk(icrds,csg,old_ntg) == NULL)
            {
                /***  022003 changed
                init_csg_blk_crx(&Comp_blk(icrds,csg,old_ntg),
                 icrds, new_ntg, old_ntg);
                creat_vol_blk(Comp_blk(icrds,csg,old_ntg));
                set_CSG_vol(Comp_blk(icrds,csg,old_ntg),
                            new_ntg, old_ntg, dt_step);
                ***/
                printf("ERROR: in find_merger_candidate_quadr() neighbour is NULL\n");
                solidls(s, 2);
                print_csg_blk_crx(Comp_blk(icrds,csg,old_ntg));
                clean_up(ERROR);
            }

            tmps = Comp_blk(icrds,csg,old_ntg)->s;
            v1 = he->vtx->pt;
            while(tmps)
            {
                h1=match_vol_in_other(mate(he), v1, tmps);
                if(h1 != NULL) break;
                tmps = tmps->nexts;
            }
            if(h1 == NULL)
            {
                printf("ERROR: IN find_merger_candidate_quadr(),"
                       " Solid %d in blk[%d, %d] do not have match vol\n",
                       s->solidno, icrds[0], icrds[1]);
                print_CSG_point(he->vtx->pt);
                print_CSG_point(mate(he)->vtx->pt);
                print_csg_blk_crx(Comp_blk(icrds,csg,old_ntg));
                solidls(s, 2);
                print_solid(Comp_blk(icrds,csg,old_ntg));
                clean_up(ERROR);
            }
            merger->h_nghbr[0] = mate(h1);
            merger->merge = YES;
            /*
            facels(h1->wloop->lface,2);
            solidls(h1->wloop->lface->fsolid,2);
            facels(mate(he)->wloop->lface,2);
            solidls(mate(he)->wloop->lface->fsolid,2);
            */
            return;
        }
        else
        {
            printf("WARNING: IN find_merger_candidate_quadr(), vol is on boundary\n");
            /*
            solidls(s,2);
            clean_up(ERROR);
            */
            /* we do not merge this kind of vol on the boundary */
            merger->h_nghbr[0] = he;
            merger->merge = YES;

        }

        debug_print("tri", "Left find_merger_candidate_quadr()\n");
}



LOCAL void find_merger_candidate_tri(
        CSG_merger      *merger,
        CSG_HalfEdge    *he,
        int             *smin,
        int             *smax,
        int             *base,
        CSG_BLK_CRX     **csg,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        int             first)
{
        int             i, j;
        int             icrds[MAXD+1];
        int             icrds1[MAXD+1], icrds2[MAXD+1];
        int             where;
        CSG_Solid       *s, *tmps;
        CSG_HalfEdge    *h1=NULL, *h2=NULL;
        CSG_POINT       *v1, *v2;
        CURVE           **c;

        debug_print("tri", "Entered find_merger_candidate_tri()\n");

        s = merger->s;
        if(s == NULL)
        {
            printf("ERROR in find_merger_candidate_tri(), s is NULL\n");
            clean_up(ERROR);
        }
        if(he->vtx->pt->type != IS_ICRDS)
        {
            printf("ERROR in find_merger_candidate_tri(),"
                    " he->pt->type not IS_ICRDS\n");
            clean_up(ERROR);
        }
        if(s != he->wloop->lface->fsolid)
        {
            printf("ERROR in find_merger_candidate_tri(),"
                    " s and he->fsolid are not the same\n");
            clean_up(ERROR);
        }
        if(he->prv->vtx->pt->type != IS_BBI_P ||
               he->nxt->vtx->pt->type != IS_BBI_P)
        {
            printf("ERROR in find_merger_candidate_tri(),"
                    " he->prv or he->nxt pt->type not IS_ICRDS\n");
            clean_up(ERROR);
        }

        memcpy(icrds, he->vtx->pt->csg_pt.icrds, sizeof(int)*3);
        where = icrds[2];

        if(icrds[0] == base[0] &&
           icrds[1] == base[1])
        {
            icrds1[0] = base[0]-1; icrds1[1] = base[1];
            icrds2[0] = base[0]; icrds2[1] = base[1]-1;
        }
        else if(icrds[0] == base[0] &&
                icrds[1] == base[1]+1)
        {
            icrds1[0] = base[0]-1; icrds1[1] = base[1];
            icrds2[0] = base[0]; icrds2[1] = base[1]+1;
        }
        else if(icrds[0] == base[0]+1 &&
                icrds[1] == base[1]+1)
        {
            icrds1[0] = base[0]; icrds1[1] = base[1]+1;
            icrds2[0] = base[0]+1; icrds2[1] = base[1];
        }
        else if(icrds[0] == base[0]+1 &&
                icrds[1] == base[1])
        {
            icrds1[0] = base[0]+1; icrds1[1] = base[1];
            icrds2[0] = base[0]; icrds2[1] = base[1]-1;
        }
        else
        {
            printf("ERROR: In find_merger_candidate_tri(), vol outside base blk\n");
            clean_up(ERROR);
        }

        if(icrds1[0] >= smin[0] && icrds1[1] >= smin[1]
           && icrds1[0] < smax[0] && icrds1[1] < smax[1])
        {

            if(Comp_blk(icrds1,csg,old_ntg) != NULL)
            {
                tmps = Comp_blk(icrds1,csg,old_ntg)->s;
                v2 = he->prv->vtx->pt;
                v1 = he->vtx->pt;
                while(tmps)
                {
                    h1=match_vol_in_other(mate(he), v1, tmps);
                    if(h1 != NULL)
                        break;
                    h1 = match_vol_in_other(mate(he->prv), v2, tmps);
                    if(h1 != NULL)
                        break;
                    tmps = tmps->nexts;
                }
                if(h1 == NULL)
                {
                    printf("ERROR: IN find_merger_candidate_tri(),"
                      " merger blk[%d, %d] do not have match vol\n",
                      icrds1[0], icrds1[1]);
                    solidls(s, 2);
                    print_solid(Comp_blk(icrds1,csg,old_ntg));
                    clean_up(ERROR);
                }
            }
            else
            {
                // if(Comp_blk(icrds1,old_ntg->blk_type,old_ntg) != F_NO_VOL &&
                //    Comp_blk(icrds1,new_ntg->blk_type,new_ntg) != F_NO_VOL)
                if((!is_complex_blk(Comp_blk(icrds1,old_ntg->blk_type,old_ntg))) &&
                   (!is_complex_blk(Comp_blk(icrds1,new_ntg->blk_type,new_ntg))))
                {
                    printf("ERROR: In find_merger_candidate_tri(),"
                      " Comp_blk(icrds[%d,%d]) is NULL\n",icrds1[0],icrds1[1]);
                    clean_up(ERROR);
                }
            }
        }
        else
        {
            /*
            printf("Warning IN find_merger_candidate_tri(),");
            printf(" merger blk[%d, %d] is outside boundary\n",
               icrds1[0], icrds1[1]);
            */
        }
        if(icrds2[0] >= smin[0] && icrds2[1] >= smin[1]
           && icrds2[0] < smax[0] && icrds2[1] < smax[1])
        {
            if(Comp_blk(icrds2,csg,old_ntg) != NULL)
            {
                tmps = Comp_blk(icrds2,csg,old_ntg)->s;
                v2 = he->prv->vtx->pt;
                v1 = he->vtx->pt;
                while(tmps)
                {
                    h2=match_vol_in_other(mate(he), v1, tmps);
                    if(h2 != NULL)
                        break;
                    h2 = match_vol_in_other(mate(he->prv), v2, tmps);
                    if(h2 != NULL)
                        break;
                    tmps = tmps->nexts;
                }
                if(h2 == NULL)
                {
                    printf("ERROR: IN find_merger_candidate_tri(),"
                      " merger blk2[%d, %d] do not have match vol\n",
                        icrds2[0], icrds2[1]);

                    printf("IN find_merger_candidate_tri(),"
                      " merger blk1[%d, %d] do not have match vol\n",
                        icrds1[0], icrds1[1]);
                    printf("The used searching points are v1,v2\n");
                    print_CSG_point(v1);
                    print_CSG_point(v2);
                    solidls(s, 2);
                    print_solid(Comp_blk(icrds2,csg,old_ntg));
                    printf("Print grid_based new interface\n");
                    for (c = new_ntg->grid_intfc->curves;
                         c && *c; c++)
                    {
                     if(!is_bdry(*c))
                         print_curve(*c);
                    }

                    printf("Print grid_based old interface\n");
                    for (c = old_ntg->grid_intfc->curves;
                         c && *c; c++)
                    {
                         if(!is_bdry(*c))
                             print_curve(*c);
                    }
                    clean_up(ERROR);
                }
            }
            else
            {
                // if(Comp_blk(icrds2,old_ntg->blk_type,old_ntg) != F_NO_VOL &&
                //    Comp_blk(icrds2,new_ntg->blk_type,new_ntg) != F_NO_VOL)
                if((! is_complex_blk(Comp_blk(icrds2,old_ntg->blk_type,old_ntg))) &&
                   (! is_complex_blk(Comp_blk(icrds2,new_ntg->blk_type,new_ntg)))) 
                {
                    printf("ERROR: In find_merger_candidate_tri(),"
                      " Comp_blk(icrds[%d,%d]) is NULL\n",icrds1[0],icrds1[1]);
                    clean_up(ERROR);
                }
            }
        }
        else
        {
            /*
            printf("Warning IN find_merger_candidate_tri(),");
            printf(" merger blk2[%d, %d] is outside boundary\n",
               icrds2[0], icrds2[2]);
            */
        }
        /* Install CSG_merger list according to state face*/

        if(h1 != NULL && h2 != NULL)
            install_merger_candidate_tri(he, mate(h1), mate(h2), merger,first);
        else
        {
            /*
            printf("WARNING: IN find_merger_candidate_tri()\n");
            printf("Solid %d has NULL nghbr, nghbr blk[%d, %d], [%d, %d]\n",
                    s->solidno, icrds1[0], icrds1[1], icrds2[0], icrds2[1]);
            solidls(s, 2);
            */
            if(h1 == NULL && h2 == NULL)
            {
                printf("ERROR: find_merger_candidate_tri()\n");
                printf("h1 and h2 both NULL\n");
                clean_up(ERROR); 
            }
            if(h1 != NULL)
                install_merger_candidate_tri(he, mate(h1), NULL, merger,first);
            else
                install_merger_candidate_tri(he, mate(h2), NULL, merger,first);
        }

        debug_print("tri", "Left find_merger_candidate_tri()\n");
}


/* look into the state face, (top or btm face) */
LOCAL void install_merger_candidate_tri(
        CSG_HalfEdge    *he,
        CSG_HalfEdge    *h1,
        CSG_HalfEdge    *h2,
        CSG_merger      *merger,
        int             first)
{
        CSG_Face        *f1, *f2;
        int             where[2], num_v[2];
        CSG_HalfEdge    *h[2], *match;

        if(h1 != NULL && h2 != NULL)
        {
            f1 = h1->wloop->lface;
            f2 = h2->wloop->lface;
            if(YES != is_top_or_bottom_face(f1,&where[0]))
            {
                printf("ERROR install_merger_candidate_tri, f1 not the face needed\n");
                clean_up(ERROR);  
            }
            if(YES != is_top_or_bottom_face(f2,&where[1]))
            {
                printf("ERROR install_merger_candidate_tri, f2 not the face needed\n");
                clean_up(ERROR);  
            }
            num_v[0] = merger_edge_of_loop(f1->floops, &h[0]);
            num_v[1] = merger_edge_of_loop(f2->floops, &h[1]);

            if(num_v[0] == num_v[1] &&
               num_v[1] == 6)
            {
                /* remark, follows 5-5 case */
                install_merger_candidate_tri_5_5(he,merger,f1,f2,first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 0\n");
                    clean_up(ERROR);  
                }
                return;
                /*
                printf("Processing 6-6 case in
                   install_merger_candidate_tri\n");
                clean_up(ERROR);
                */
            }
            if(num_v[0] == num_v[1] &&
               num_v[1] == 5)
            {
                install_merger_candidate_tri_5_5(he,merger,f1,f2,first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 1\n");
                    clean_up(ERROR);  
                }
                return;
            }
            if(num_v[0] == num_v[1] &&
               num_v[1] == 4)
            {
                install_merger_candidate_tri_4_4(he,merger,f1,f2,first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 2\n");
                    clean_up(ERROR);  
                }
                return;
            }
            if(num_v[0] == num_v[1] &&
               num_v[1] == 3)
            {
                /*
                printf("Processing 3-3 case in
                   install_merger_candidate_tri\n");
                */
                install_merger_candidate_tri_3_3(he,merger,f1,f2,num_v[0],num_v[1],first);
                return;
            }

            if((num_v[0] == 6 && num_v[1] == 5) ||
               (num_v[0] == 5 && num_v[1] == 6))
            {
                /*
                printf("Processing 6-5 case in"
                   " install_merger_candidate_tri\n");
                */
                install_merger_candidate_tri_6_5(he,merger,f1,f2,num_v[0],num_v[1],first);
                return;
            }
            if((num_v[0] == 6 && num_v[1] == 4) ||
               (num_v[0] == 4 && num_v[1] == 6))
            {
                /*
                printf("Processing 6-4 case in"
                   " install_merger_candidate_tri\n");
                */
                /* remark, to merge tri with hexagon face */
                install_merger_candidate_tri_6_3(he,merger,f1,f2,num_v[0],num_v[1],first);
                return;
            }
            if((num_v[0] == 6 && num_v[1] == 3) ||
               (num_v[0] == 3 && num_v[1] == 6))
            {
                /*
                printf("Processing 6-3 case in"
                   " install_merger_candidate_tri\n");
                facels(f1, 2);
                facels(f2, 2);
                */
                install_merger_candidate_tri_6_3(he,merger,f1,f2,num_v[0],num_v[1],first);
                return;
            }
            if((num_v[0] == 5 && num_v[1] == 4) ||
               (num_v[0] == 4 && num_v[1] == 5))
            {
                install_merger_candidate_tri_5_4(he,merger,f1,f2,num_v[0],num_v[1],first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 3\n");
                    clean_up(ERROR);  
                }
                return;
            }
            if((num_v[0] == 5 && num_v[1] == 3) ||
               (num_v[0] == 3 && num_v[1] == 5))
            {
                install_merger_candidate_tri_5_3(he,merger,f1,f2,num_v[0],num_v[1],first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 4\n");
                    clean_up(ERROR);  
                }
                return;
            }
            if((num_v[0] == 4 && num_v[1] == 3) ||
               (num_v[0] == 3 && num_v[1] == 4))
            {
                install_merger_candidate_tri_4_3(he,merger,f1,f2,num_v[0],num_v[1],first);
                if(merger->he == NULL)
                {
                    printf("ERROR install_merger_candidate_tri, merger->he null 5\n");
                    clean_up(ERROR);  
                }
                return;
            }
            printf("ERROR: install_merger_candidate_tri(), unknown state face case\n");
            clean_up(ERROR);
            return;
        }
        else
        {
            f1 = h1->wloop->lface;
            if(YES != is_top_or_bottom_face(f1,&where[0]))
            {
                printf("ERROR install_merger_candidate_tri, f1 not the face\n");
                clean_up(ERROR);  
            }
            num_v[0] = merger_edge_of_loop(f1->floops, &h[0]);

            merger->he = he;
            match = match_edge_in_other(
                        he,f1->floops);
            if(match == NULL)
            {
               match = match_edge_in_other(
                       he->prv,f1->floops);
                merger->he = he->prv;
            }
            if(match == NULL)
            {
                printf("ERROR: install_merger_candidate_tri, match is NULL\n");
                clean_up(ERROR); 
            }
            merger->h_nghbr[0] = match;
            merger->merge = YES;

            if(merger->he == NULL)
            {
                printf("ERROR: install_merger_candidate_tri, merger->he is NULL\n");
                clean_up(ERROR); 
            }
            return;
        }
}

LOCAL void install_merger_candidate_tri_5_5(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             first)
{
        CSG_HalfEdge    *match;

        if(edge_len(he) > edge_len(he->prv))
            merger->he = he;
        else
            merger->he = he->prv;

         match = match_edge_in_other(
                    merger->he,f1->floops);
         if(match == NULL)
             match = match_edge_in_other(
                   merger->he,f2->floops);
         if(match == NULL)
         {
             printf("ERROR install_merger_candidate_tri_5_5, match is null\n");
             clean_up(ERROR);  
         }
         merger->h_nghbr[0] = match;
         merger->merge = YES;
         return;
}

LOCAL void install_merger_candidate_tri_4_4(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             first)
{
        CSG_HalfEdge    *match;

        if(f1->area >= 0.5*rect_area && f2->area < 0.5*rect_area)
        {
             match = match_edge_in_other(
                     he,f1->floops);
             if(match != NULL)
             {
                  merger->he = he;
                  merger->h_nghbr[0] = match;
                  merger->merge = YES;
                  return;
             }
             else
             {
                  match = match_edge_in_other(
                     he->prv,f1->floops);
                  merger->he = he->prv;
                  merger->h_nghbr[0] = match;
                  if(match == NULL)
                  {
                      printf("ERROR install_merger_candidate_tri_4_4, match null\n");
                      clean_up(ERROR);  
                  }
                  merger->merge = YES;
                  return;
             }
             printf("ERROR: in install_merger_candidate_tri_4_4()\n");
             printf("Should find merger candidate but not\n");
             facels(f1,2);
             solidls(f1->fsolid,2);
             solidls(he->wloop->lface->fsolid,2);
             clean_up(ERROR);
        }
        else if( f1->area < 0.5*rect_area && f2->area >= 0.5*rect_area)
        {
             match = match_edge_in_other(
                     he,f2->floops);
             if(match != NULL)
             {
                  merger->he = he;
                  merger->h_nghbr[0] = match;
                  merger->merge = YES;
                  return;
             }
             else
             {
                  match = match_edge_in_other(
                     he->prv,f2->floops);
                  merger->he = he->prv;
                  merger->h_nghbr[0] = match;
                  if(match == NULL)
                  {
                      printf("ERROR install_merger_candidate_tri_4_4, match null 2\n");
                      clean_up(ERROR);  
                  }
                  merger->merge = YES;
                  return;
             }
             printf("ERROR: in install_merger_candidate_tri_4_4()\n");
             printf("Should find merger candidate but not 2\n");
             facels(f2,2);
             solidls(f2->fsolid,2);
             solidls(he->wloop->lface->fsolid,2);
             clean_up(ERROR);
         }
         else if(f1->area >= 0.5*rect_area && f2->area >= 0.5*rect_area)
         {   /* following case 5-5  */
             if(edge_len(he) > edge_len(he->prv))
                   merger->he = he;
              else
                   merger->he = he->prv;

              match = match_edge_in_other(
                      merger->he,f1->floops);
              if(match == NULL)
                   match = match_edge_in_other(
                           merger->he,f2->floops);
              if(match == NULL)
              {
                  printf("ERROR install_merger_candidate_tri_4_4, match null 3\n");
                  clean_up(ERROR);  
              }
              merger->h_nghbr[0] = match;
              merger->merge = YES;
              return;
          }
          else
          {
               if(first)
               {
                   merger->he = he;
                   merger->merge = NO;
                   match = match_edge_in_other(
                         merger->he,f1->floops);
                   if(match == NULL)
                       match = match_edge_in_other(
                         merger->he,f2->floops);
                   merger->h_nghbr[0] = match;
                   return;
               }
               merger->he = he;
               match = match_edge_in_other(
                     merger->he,f1->floops);
               if(match == NULL)
                    match = match_edge_in_other(
                      merger->he,f2->floops);
                merger->h_nghbr[0] = match;
                match = match_edge_in_other(
                    he->prv,f1->floops);
                if(match == NULL)
                    match = match_edge_in_other(
                      he->prv,f2->floops);
                merger->h_nghbr[1] = match;
                if(merger->h_nghbr[0] == NULL || merger->h_nghbr[1] == NULL)
                {
                    printf("ERROR install_merger_candidate_tri_4_4, merger null\n");
                    clean_up(ERROR);  
                }
                merger->merge = NO;
                return;
          }
}

LOCAL void install_merger_candidate_tri_3_3(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        /*
        screen("Processing 3-3 case in\n");
        screen("install_merger_candidate_tri, write after 4-3 case\n");
        screen("f1_area, f2_area<%g, %g> v<%d, %d>\n",
                 f1->area, f2->area, num_v[0], num_v[1]);
        */
         merger->he = he;
         match = match_edge_in_other(
                     he, f1->floops);
         if(match == NULL)
         {
              match = match_edge_in_other(
                          he->prv, f1->floops);
              merger->he = he->prv;
         }

         if(match == NULL)
         {
             printf("ERROR in install_merger_candidate_tri_3_3()\n");
             printf("Match is NULL\n");
             clean_up(ERROR);
         }
         merger->h_nghbr[0] = match;

         match = match_edge_in_other(
                 he->prv, f2->floops);
         if(match == NULL)
         {
              match = match_edge_in_other(
                     he, f2->floops);
         }
         if(match == NULL)
         {
             printf("ERROR in install_merger_candidate_tri_3_3()\n");
             printf("Match is NULL 2\n");
             clean_up(ERROR);
         }
         merger->h_nghbr[1] = match;

         merger->merge = NO;
         if(first)
         {
             merger->h_nghbr[1] = NULL;
         }
         return;

          printf("ERROR: in install_merger_candidate_tri_3_3()\n");
          printf("Should not get to here\n");
          facels(f1,2);
          solidls(f1->fsolid,2);
          facels(f2,2);
          solidls(f2->fsolid,2);
          clean_up(ERROR);
}

LOCAL void install_merger_candidate_tri_6_5(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        /*
        printf("Processing 6-5 case in"
             " install_merger_candidate_tri\n");
        printf("write after 5-5 case\n");
        */
        if(edge_len(he) > edge_len(he->prv))
            merger->he = he;
        else
            merger->he = he->prv;

         match = match_edge_in_other(
                    merger->he,f1->floops);
         if(match == NULL)
             match = match_edge_in_other(
                   merger->he,f2->floops);

         if(match == NULL)
         {
              printf("ERROR; In install_merger_candidate_tri_6_5()\n");
              printf("did not find match\n");
              clean_up(ERROR);
         }
         merger->h_nghbr[0] = match;
         merger->merge = YES;
         return;
}

LOCAL void install_merger_candidate_tri_4_3(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        /*
        screen("Processing 4-3 case in\n");
        screen("install_merger_candidate_tri\n");
        screen("f1_area, f2_area<%g, %g> v<%d, %d>\n",
                 f1->area, f2->area, num_v[0], num_v[1]);
        */

        if(nv1 == 4)
        {
             merger->he = he;
             match = match_edge_in_other(
                         he, f1->floops);
             if(match == NULL)
             {
                  match = match_edge_in_other(
                          he->prv, f1->floops);
                  merger->he = he->prv;
             }

             if(match == NULL)
             {
                 printf("ERROR install_merger_candidate_tri_4_3, match null\n");
                 clean_up(ERROR);  
             }
             merger->h_nghbr[0] = match;

             if(f1->area < 0.5*rect_area)
             {
                 match = match_edge_in_other(
                         he->prv, f2->floops);
                 if(match == NULL)
                 {
                      match = match_edge_in_other(
                              he, f2->floops);
                 }
                 if(match == NULL)
                 {
                     printf("ERROR install_merger_candidate_tri_4_3, match null 1\n");
                     clean_up(ERROR);  
                 }
                  merger->h_nghbr[1] = match;
              }
              if(f1->area < 0.5*rect_area && first)
              {
                  merger->h_nghbr[1] = NULL;
                  merger->merge = NO;
                  return;
              }
              merger->merge = YES;
              return;
          }
          else
          {
              merger->he = he;
              match = match_edge_in_other(
                        he,f2->floops);
              if(match == NULL)
              {
                  match = match_edge_in_other(
                             he->prv,f2->floops);
                  merger->he = he->prv;
              }
              if(match == NULL)
              {
                  printf("ERROR install_merger_candidate_tri_4_3, match null 2\n");
                  clean_up(ERROR);  
              }
              merger->h_nghbr[0] = match;

              if(f2->area < 0.5*rect_area)
              {
                   match = match_edge_in_other(
                          he,f1->floops);
                   if(match == NULL)
                   {
                       match = match_edge_in_other(
                                  he->prv,f1->floops);
                   }
                   if(match == NULL)
                   {
                       printf("ERROR install_merger_candidate_tri_4_3, match null 3\n");
                       clean_up(ERROR);  
                   }
                   merger->h_nghbr[1] = match;
              }
              if(f2->area < 0.5*rect_area && first)
              {
                  merger->h_nghbr[1] = NULL;
                  merger->merge = NO;
                  return;
              }
              merger->merge = YES;
              return;
          }
          printf("ERROR: in install_merger_candidate_tri_4_3()\n");
          printf("Should not get to here\n");
          facels(f1,2);
          solidls(f1->fsolid,2);
          facels(f2,2);
          solidls(f2->fsolid,2);
          clean_up(ERROR);
}



LOCAL void install_merger_candidate_tri_6_3(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        /*
        printf("Processing 6-3 case in
             install_merger_candidate_tri\n");
        */
        if(nv1 == 6)
        {
              match = match_edge_in_other(
                    he,f1->floops);
              merger->he = he;
              if(match == NULL)
              {
                   match = match_edge_in_other(
                       he->prv,f1->floops);
                   merger->he = he->prv;
              }
              merger->h_nghbr[0] = match;
              merger->merge = YES;
              if(match == NULL)
              {
                  printf("ERROR; In install_merger_candidate_tri_6_3()\n");
                  printf("did not find match\n");
                  clean_up(ERROR);
              }
        }
        else
        {
              match = match_edge_in_other(
                    he,f2->floops);
              merger->he = he;
              if(match == NULL)
              {
                   match = match_edge_in_other(
                     he->prv,f2->floops);
                   merger->he = he->prv;
              }
              merger->h_nghbr[0] = match;
              merger->merge = YES;
              if(match == NULL)
              {
                  printf("ERROR; In install_merger_candidate_tri_6_3()\n");
                  printf("did not find match\n");
                  clean_up(ERROR);
              }
        }
        return;
}

LOCAL void install_merger_candidate_tri_5_4(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        if(nv1 == 5)
        {
             if(f2->area < rect_area/2.0)
             {
                  match = match_edge_in_other(
                        he,f1->floops);
                  merger->he = he;
                  if(match == NULL)
                  {
                       match = match_edge_in_other(
                           he->prv,f1->floops);
                       merger->he = he->prv;
                  }
                  if(match == NULL)
                  {
                      printf("ERROR; In install_merger_candidate_tri_5_4()\n");
                      printf("did not find match\n");
                      clean_up(ERROR);
                  }
                  merger->h_nghbr[0] = match;
                  merger->merge = YES;
                  return;
             }
        }
        else
        {
             if(f1->area < rect_area/2.0)
             {
                  match = match_edge_in_other(
                        he,f2->floops);
                  merger->he = he;
                  if(match == NULL)
                  {
                       match = match_edge_in_other(
                         he->prv,f2->floops);
                       merger->he = he->prv;
                  }
                  if(match == NULL)
                  {
                      printf("ERROR; In install_merger_candidate_tri_5_4()\n");
                      printf("did not find match 2\n");
                      clean_up(ERROR);
                  }
                  merger->h_nghbr[0] = match;
                  merger->merge = YES;
                  return;
            }
        }

        if(f1->area < rect_area/2.0 || f2->area < rect_area/2.0)
        {
            printf("ERROR; In install_merger_candidate_tri_5_4()\n");
            printf("f1->area = %g, f2->area = %g, 1/2rect_area = %g\n",
                f1->area, f2->area, rect_area/2.0);
            clean_up(ERROR);
        }
        if(edge_len(he) > edge_len(he->prv))
            merger->he = he;
        else
            merger->he = he->prv;
        match = match_edge_in_other(
            merger->he,f1->floops);
        if(match == NULL)
            match = match_edge_in_other(
                merger->he,f2->floops);
        if(match == NULL)
        {
            printf("ERROR; In install_merger_candidate_tri_5_4()\n");
            printf("did not find match 3\n");
            clean_up(ERROR);
        }
        merger->h_nghbr[0] = match;
        merger->merge = YES;
        return;
}

LOCAL void install_merger_candidate_tri_5_3(
        CSG_HalfEdge    *he,
        CSG_merger      *merger,
        CSG_Face        *f1,
        CSG_Face        *f2,
        int             nv1,
        int             nv2,
        int             first)
{
        CSG_HalfEdge    *match;
        /*
        printf("Processing 5-3 case in
            install_merger_candidate_tri\n");
        */
        if(nv1 == 5)
        {
              match = match_edge_in_other(
                    he,f1->floops);
              merger->he = he;
              if(match == NULL)
              {
                   match = match_edge_in_other(
                       he->prv,f1->floops);
                   merger->he = he->prv;
              }
              merger->h_nghbr[0] = match;
              merger->merge = YES;
              if(match == NULL)
              {
                  printf("ERROR; In install_merger_candidate_tri_5_3()\n");
                  printf("did not find match \n");
                  clean_up(ERROR);
              }
        }
        else
        {
              match = match_edge_in_other(
                    he,f2->floops);
              merger->he = he;
              if(match == NULL)
              {
                   match = match_edge_in_other(
                     he->prv,f2->floops);
                   merger->he = he->prv;
              }
              merger->h_nghbr[0] = match;
              merger->merge = YES;
              if(match == NULL)
              {
                  printf("ERROR; In install_merger_candidate_tri_5_3()\n");
                  printf("did not find match 2\n");
                  clean_up(ERROR);
              }
        }
        return;
}


/* v1 is he's end point */
/* find the matching face which he belongs in other vol */
/* require the solids the same components */

LOCAL CSG_HalfEdge *match_vol_in_other(
        CSG_HalfEdge    *he,
        CSG_POINT       *v1,
        CSG_Solid       *s)
{
        CSG_POINT       *v = he->vtx->pt;
        CSG_POINT       *hv1, *hv2;
        CSG_Face        *f;
        CSG_Loop        *l;
        CSG_HalfEdge    *h;
        int             found = NO;

        // debug_print("tri","Entered match_vol_in_other()\n");
        if(v == v1)
        {
            printf("ERROR in match_vol_in_other(), v == v1\n");
            clean_up(ERROR);
        }

        for(f = s->sfaces; f != NULL; f = f->nextf)
        {
            if(CSG_face_match(f,he->wloop->lface))
            {
                found = YES;
                break;
            }
        }
        if(found == NO)
        {
            // debug_print("tri","Leaving match_vol_in_other()\n");
            return NULL;
        }

        if(he->wloop->lface == NULL)
        {
            printf("ERROR in match_vol_in_other(), face NULL\n");
            clean_up(ERROR);
        }
        if(CSG_face_match(f,he->wloop->lface) != YES)
        {
            printf("ERROR in match_vol_in_other(), face not match\n");
            clean_up(ERROR);
        }

        h = f->floops->ledg;
        do
        {
             hv1 = h->vtx->pt; hv2 = h->nxt->vtx->pt;
             if(CSG_Point_equal(v1,hv1) && CSG_Point_equal(v,hv2))
             {
                 if(f->fsolid->comp != he->wloop->lface->fsolid->comp)
                 {
                     printf("ERROR in match_vol_in_other()\n");
                     printf("different comp. solids are matched\n");
                     solidls(he->wloop->lface->fsolid,2);
                     solidls(f->fsolid,2);
                     clean_up(ERROR);
                 }
                 // debug_print("tri","Leaving match_vol_in_other()\n");
                 return h;
             }
        }while((h = h->nxt) != f->floops->ledg);

        printf("ERROR in match_vol_in_other()\n");
        printf("Should find match vol's HalfEdge, but not\n");
        clean_up(ERROR);
}



LOCAL CSG_HalfEdge *match_edge_in_other(
        CSG_HalfEdge    *he,
        CSG_Loop        *l)
{
        CSG_HalfEdge    *h;
        CSG_Vertex      *hv1, *hv2;
        CSG_Vertex      *v1,  *v2;

        hv1 = he->vtx;
        hv2 = mate(he)->vtx;

        h = l->ledg;
        do{
            if(edge_len(he)*edge_len(h) == 0.0)
            {
                printf("ERROR match_edge_in_other, edge_len = 0.0\n");
                clean_up(ERROR); 
            }
            v1 = h->vtx;
            v2 = mate(h)->vtx;

            if(CSG_Vertex_equal(hv1,v1) && CSG_Vertex_equal(hv2,v2))
                return h;
            if(CSG_Vertex_equal(hv1,v2) && CSG_Vertex_equal(hv2,v1))
                return h;
        }while((h = h->nxt) != l->ledg);
        return NULL;
}

/* long_is_top_or_bottom_face() and 
 * is_top_or_bottom_face(). Tol has to be the same
 */
EXPORT int  is_top_or_bottom_face(
        CSG_Face        *f,
        int             *where)
{
        CSG_Loop        *l;
        CSG_HalfEdge    *he;
        CSG_POINT       *pt;
        float      *dir, nor[2][3] = {0.0, 0.0, 1.0,
                                      0.0, 0.0, -1.0};
        float      prod; 
        int        i;
  
        for(i = 0; i < 2; i++)
        {
           dir = nor[i];
           prod = scalar_product(dir,f->face_eqn,3);
           if(fabs(prod - 1.0) >  0.0001*TOL &&
              fabs(prod + 1.0) >  0.0001*TOL )
               return NO;
        }
       
        l = f->floops;
        if(fabs(f->face_eqn[0]) < 0.01*TOL &&
           fabs(f->face_eqn[1]) < 0.01*TOL &&
           fabs(f->face_eqn[2]) > ONEMTOL)
        {
            he = l->ledg;
            do
            {
                pt = he->vtx->pt;
                if(pt->type == IS_ICRDS)
                {
                    *where = pt->csg_pt.icrds[2];
                    break;
                }
            }while((he = he->nxt) != l->ledg);
            return YES;
        }
        else
            return NO;
}

LOCAL int merger_edge_of_loop(
         CSG_Loop       *l,
         CSG_HalfEdge   **rhe)
{
         CSG_HalfEdge   *he;
         CSG_Vertex     *v1, *v2;
         int            n = 0;

         n = CSG_loop_vtx_num(l);

         he = l->ledg;
         switch(n)
         {
         case 3:
             do
             {
                 if(he->vtx->pt->type == IS_ICRDS)
                 {
                     *rhe = he;
                     break;
                 }
             }while((he = he->nxt) != l->ledg);
         break;
         case 4:
             do
             {
                 if(he->vtx->pt->type == IS_ICRDS &&
                    he->nxt->vtx->pt->type == IS_ICRDS)
                 {
                     *rhe = he;
                     break;
                 }
             }while((he = he->nxt) != l->ledg);
         break;
         case 5:
         case 6:
             *rhe = NULL;
         break;
         default:
             printf("ERROR: IN merger_edge_of_loop(),"
                 " unknown state face case, #of vertice = %d\n",n);
             clean_up(ERROR);
         }
         return n;
}



LOCAL void  find_need_merge_top_tri_quadr_vol(
        CSG_BLK_CRX     *blk_crx,
        CSG_merger      **top_merger)
{
        int             i, j, n;
        CSG_Solid       *s, *root;
        CSG_Face        *f, *stat_f[2];
        int             where[3], num_v[2];
        int             icrds[MAXD+1], base[MAXD+1];
        CSG_HalfEdge    *he[2];

        s = blk_crx->s;
        if(s == NULL)
        {
            printf("ERROR: find_need_merge_top_tri_quadr_vol(),NULL Vol\n");
            clean_up(ERROR);
        }

        while(s)
        {
            i = 0; n = 0;
            f = s->sfaces;
            while(f)
            {
                if(YES == long_is_top_or_bottom_face(f,where))
                {
                    n++;
                    if(where[2] == 1)
                    {
                        stat_f[i] = f;
                        num_v[i++] = CSG_loop_vtx_num(f->floops);
                        if(i >= 2)
                        {
                            printf("ERROR  find_need_merge_top_tri_quadr_vol()\n");
                            printf("top face i = %d\n", i);
                            clean_up(ERROR);
                        }
                    }
                }
                f = f->nextf;
            }

            switch(i)
            {
            case 1:
                 if(n == 1)
                 {
                     add_to_merge_list(s, blk_crx, top_merger);
                 }
                 else if(stat_f[0]->area < 0.5*rect_area)
                 {
                     if(num_v[0] <= 4)
                     {
                         add_to_merge_list(s, blk_crx, top_merger);
                     }
                     if(n != 2)
                     {
                         printf("ERROR, in find_need_merge_top_tri_quadr_vol()\n");
                         printf("ERROR, n[%d] should be 2\n",n);
                         print_csg_blk_crx(blk_crx);
                         solidls(s, 2);
                         clean_up(ERROR);
                     }
                 }
            break;
            case 0:
                if(n != 1)
                {
                    printf("ERROR, in find_need_merge_top_tri_quadr_vol()\n");
                    printf("ERROR, NONE_TOP_BTM_VOL 1\n");
                    print_csg_blk_crx(blk_crx);
                    solidls(s, 2);
                    clean_up(ERROR);
                }
                if(n == 0)
                {
                    printf("ERROR, in find_need_merge_top_tri_quadr_vol()\n");
                    printf("ERROR, NONE_TOP_BTM_VOL\n");
                    print_csg_blk_crx(blk_crx);
                    solidls(s, 2);
                    clean_up(ERROR);
                }
            break;
            default:
                printf("ERROR, in find_need_merge_vol()\n");
                printf("ERROR, total number of top & btm face > 2\n");
                print_csg_blk_crx(blk_crx);
                solidls(s, 2);
                clean_up(ERROR);
            }
            s = s->nexts;
        }
}

LOCAL void add_to_merge_list(
         CSG_Solid      *s,
         CSG_BLK_CRX    *blk,
         CSG_merger     **merger)
{
         CSG_merger     *root, *tmp;
         static CSG_merger *last;

         scalar(&tmp,sizeof(CSG_merger));
         tmp->he = NULL;
         tmp->s = s;
         tmp->blk = blk;
         tmp->h_nghbr[0] = tmp->h_nghbr[1] = NULL;
         tmp->n_nghbr = 0;
         tmp->merge = NO;
         tmp->prev = NULL;
         tmp->next = NULL;

         if((*merger) != NULL)
         {
             last->next = tmp;
             tmp->prev = last;
             last = tmp;
         }
         else
             (*merger) = last = tmp;
}


LOCAL void free_merge_list(
        CSG_merger      **merger)
{
        CSG_merger      *node;

        if(merger != NULL)
        {
            if(*merger != NULL)
            {
                node = *merger;
                while(node)
                {
                    *merger = node->next;
                    free(node);
                    node = *merger;
                }
                *merger = NULL;
            }
        }
}


EXPORT  int  long_is_top_or_bottom_face(
        CSG_Face        *f,
        int             *where)
{
        CSG_Loop        *l;
        CSG_HalfEdge    *he;
        CSG_POINT       *pt;
        float      *dir, nor[2][3] = {0.0, 0.0, 1.0,
                                      0.0, 0.0, -1.0};
        float      prod;
        int        i;

        for(i = 0; i < 2; i++)
        {
           dir = nor[i];
           prod = scalar_product(dir,f->face_eqn,3);
           if(fabs(prod - 1.0) >  0.0001*TOL &&
              fabs(prod + 1.0) >  0.0001*TOL )
               return NO;
        }

        l = f->floops;
        if(fabs(f->face_eqn[0]) < 0.01*TOL &&
           fabs(f->face_eqn[1]) < 0.01*TOL &&
           fabs(f->face_eqn[2]) > ONEMTOL)
        {
            he = l->ledg;
            do
            {
                pt = he->vtx->pt;
                if(pt->type == IS_ICRDS)
                {
                    memcpy(where, pt->csg_pt.icrds, sizeof(int)*3);
                    break;
                }
            }while((he = he->nxt) != l->ledg);
            return YES;
        }
        else
            return NO;
}



LOCAL void free_fill_vol_ic(
         FILL_VOL        **fill)
{
         FILL_VOL        *start;

         start = *fill;
         while(start)
         {
             *fill = (*fill)->next;
             free(start);
             start = *fill;
         }
         *fill = NULL;
}


LOCAL int if_need_fill_vol_blk(
         int             *ic,
         int             rad,
         int             *imin,
         int             *imax,
         CSG_BLK_CRX     **csg_blk_crx,
         TRI_GRID        *new_ntg)
{
         int             i;
         int             rmin[MAXD], rmax[MAXD];  /* sten point range in X & Y*/
         int             ic_now[MAXD];
         CSG_BLK_CRX     *blk;
         int             found = NO;

         if(Comp_blk(ic,csg_blk_crx,new_ntg) != NULL)
             return NO;

         for (i = 0; i < 2; i++)
         {
             rmin[i] = ic[i] - rad;
             rmax[i] = ic[i] + rad;
         }
         if(rmin[0] < imin[0])
             rmin[0] = imin[0];
         if(rmin[1] < imin[1])
             rmin[1] = imin[1];
         if(rmax[0] > imax[0]-1)
             rmax[0] = imax[0]-1;
         if(rmax[1] > imax[1]-1)
             rmax[1] = imax[1]-1;

        /* Test if the Five point Cross sten touch the CSG_Vol  */
        for(i = rmin[0]; i <= rmax[0]; i++)
        {
            ic_now[0] = i;
            ic_now[1] = ic[1];
            blk = Comp_blk(ic_now,csg_blk_crx,new_ntg);
            if(blk != NULL)
            {
                /*
                if(blk->s == NULL)
                {
                    found = YES;
                    return YES;
                }
                */
                if(blk->s == NULL)
                {
                    printf("ERROR:  if_need_fill_vol_blk\n");
                    printf("blk DOES not contain Solid\n");
                    clean_up(ERROR);
                }
                found = YES;
                return YES;
            }
        }

        for(i = rmin[1]; i <= rmax[1]; i++)
        {
            ic_now[1] = i;
            ic_now[0] = ic[0];
            blk = Comp_blk(ic_now,csg_blk_crx,new_ntg);
            if(blk != NULL)
            {
                if(blk->s == NULL)
                {
                    printf("ERROR:  if_need_fill_vol_blk\n");
                    printf("blk DOES not contain Solid\n");
                    clean_up(ERROR);
                }
                found = YES;
                return YES;
            }
        }
        return NO;
}


LOCAL FILL_VOL *insert_fill_vol_ic(
         FILL_VOL        **fill,
         int             *ic,
         int             dim)
{
         FILL_VOL        *tmp_fill_vol;
         int             i;

         scalar(&tmp_fill_vol, sizeof(FILL_VOL));
         for(i = 0; i < dim; i++)
             tmp_fill_vol->ic[i] = ic[i];
         tmp_fill_vol->prev = tmp_fill_vol->next = NULL;

         if(*fill == NULL)
         {
             *fill = tmp_fill_vol;
         }
         else
         {
             tmp_fill_vol->next = *fill;
             (*fill)->prev = tmp_fill_vol;
             *fill = tmp_fill_vol;
         }
         return *fill;
}


LOCAL int  CSG_volume_construct(
        int             *icrds,
        CSG_BLK_CRX     *blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int             i,j,k;
        int             num_pos, num_crx;
        COMPONENT       ***comp = blk_crx->comp;
        CSG_POINT       *crxs[12];


        num_crx = 0;
        for (j = 0; j < 2; j++)
        {
            for (k = 0; k < 2; k++)
            {
                if (comp[0][j][k] != comp[1][j][k])
                {
                    crxs[num_crx] = CSG_crx_in_idir(blk_crx,j,k);
                    if (crxs[num_crx] == NULL)
                    {
#if defined(NAVIGATOR)
                         NAV_LEAVE(CSG_vol_construct)
#endif /* defined(NAVIGATOR) */
                         return NO;
                    }
                    num_crx++;
                }
            }
        }

        for (k = 0; k < 2; k++)
        {
            for (i = 0; i < 2; i++)
            {
                if (comp[i][0][k] != comp[i][1][k])
                {
                    crxs[num_crx] = CSG_crx_in_jdir(blk_crx,k,i);
                    if (crxs[num_crx] == NULL)
                    {
#if defined(NAVIGATOR)
                         NAV_LEAVE(CSG_vol_construct)
#endif /* defined(NAVIGATOR) */
                         return NO;
                    }
                    num_crx++;
                }
            }
        }


        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                if (comp[i][j][0] != comp[i][j][1])
                {
                    crxs[num_crx] = CSG_crx_in_kdir(blk_crx,i,j);
                    if (crxs[num_crx] == NULL)
                    {
#if defined(NAVIGATOR)
                         NAV_LEAVE(CSG_vol_construct)
#endif /* defined(NAVIGATOR) */
                         return NO;
                    }
                    num_crx++;
                }
            }
        }

        if (num_crx == 0)
        {
            return NO;
        }

        num_pos = 0;
        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == blk_crx->pos_comp)
                        num_pos++;
                }
            }
        }

#if defined(DEBUG)
        /*
        if(icrds[0] == 20 && icrds[1] == -4)
            printf("CSG_volume_construct, case %d for ic[%d %d]\n",
                num_pos, icrds[0], icrds[1]); 
        */
#endif /* if defined(DEBUG) */

        switch (num_pos)
        {
        case 1:
            blk_crx->min_comp = blk_crx->pos_comp;
            find_odd_point_and_create_CSG_vol(blk_crx, new_ntg, old_ntg);
        break;
        case 7:
            blk_crx->min_comp = blk_crx->neg_comp;
            find_odd_point_and_create_CSG_vol(blk_crx, new_ntg, old_ntg);
        break;
        case 2:
            blk_crx->min_comp = blk_crx->pos_comp;
            create_CSG_vol_for_two_point(blk_crx);
        break;
        case 6:
            blk_crx->min_comp = blk_crx->neg_comp;
            create_CSG_vol_for_two_point(blk_crx);
        break; 
        case 3:
            blk_crx->min_comp = blk_crx->pos_comp;
            create_CSG_vol_for_three_point(blk_crx, new_ntg, old_ntg);
        break;
        case 5:
            blk_crx->min_comp = blk_crx->neg_comp;
            create_CSG_vol_for_three_point(blk_crx, new_ntg, old_ntg);
        break; 
        case 4:
            blk_crx->min_comp = blk_crx->pos_comp;
            create_CSG_vol_for_four_point(blk_crx,new_ntg,old_ntg);
        break;
        default:
            printf("\n\nIn CSG_vol_construct(), processing\n\n");
            printf("num_pos component = %d exit(0)\n", num_pos);
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }

        return YES;  
}

LOCAL int CSG_blk_on_front(
        int             *icrds,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        CRXING          **t_crx,
        float           dt,
        CSG_BLK_CRX     **blk_crx)
{
        int             nc[4], nc2[4];   /* number of CRXING */
        int             i, j, k;
        int             ic[MAXD+1];
        static int      first = YES;
        static CRXING   **crx[4], **crx2[4];

        int             icrds_end[MAXD+1];
        int             yes_no;
        int             iii, jjj;
        icrds_end[0] = icrds[0] + 1;
        icrds_end[1] = icrds[1] + 1;
        yes_no = NO;

        if(YES == first)
        {
             first = NO;
             for(i = 0; i < 4; i++)
             {
                 /* matrix(&crx[i],4,1,sizeof(CRXING *)); */
                 vector(&crx[i],4,sizeof(CRXING *));
                 vector(&crx2[i],4,sizeof(CRXING *));
             }
        }

        nc[0] = comp_crossings_in_direction(crx[0],icrds,EAST,new_ntg);
        nc[2] = comp_crossings_in_direction(crx[2],icrds,NORTH,new_ntg);
        nc[1] = comp_crossings_in_direction(crx[1],icrds_end,WEST,new_ntg);
        nc[3] = comp_crossings_in_direction(crx[3],icrds_end,SOUTH,new_ntg);

        if(nc[0] > 1 || nc[1] > 1 || nc[2] > 1 || nc[3] > 1)
        {
            printf("ERROR in CSG_blk_on_front() on ic[%d,%d]\n", icrds[0], icrds[1]);
            printf("Mutiple crxings (1) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
              nc[0], nc[1], nc[2], nc[3]);

            if(! set_irregular_blk(icrds, new_ntg, old_ntg, blk_crx, crx, nc, 1))
            {
                printf("ERROR in CSG_blk_on_front() on ic[%d,%d]\n", 
                            icrds[0], icrds[1]);
                printf("Mutiple crxings (1) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
                  nc[0], nc[1], nc[2], nc[3]);
                clean_up(ERROR);  
            }     
            else
            {
                yes_no = YES;  
                return yes_no;
            }    
            clean_up(ERROR);
        }

        nc2[0] = comp_crossings_in_direction(crx2[0],icrds,EAST,old_ntg);
        nc2[2] = comp_crossings_in_direction(crx2[2],icrds,NORTH,old_ntg);
        nc2[1] = comp_crossings_in_direction(crx2[1],icrds_end,WEST,old_ntg);
        nc2[3] = comp_crossings_in_direction(crx2[3],icrds_end,SOUTH,old_ntg);

        if(nc2[0] > 1 || nc2[1] > 1 || nc2[2] > 1 || nc2[3] > 1)
        {
            printf("ERROR in CSG_blk_on_front() ic[%d,%d]\n", icrds[0], icrds[1]);
            printf("Mutiple crxings (2) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
              nc2[0], nc2[1], nc2[2], nc2[3]);
            clean_up(ERROR);
        }

        if(nc[0] != 0 || nc[1] != 0 || nc[2] != 0 || nc[3] != 0 || 
           nc2[0] != 0 || nc2[1] != 0 || nc2[2] != 0 || nc2[3] != 0)
        {
            init_csg_blk_crx(blk_crx, icrds, new_ntg, old_ntg);
        }
        else
            return yes_no;

        /* install CRX on Z = 1 plane */
        if(nc[0] != 0 || nc[1] != 0 || nc[2] != 0 || nc[3] != 0)
        {
            for(j = 0; j < 2; j++)
            {
                /* t(z)  = 1, Y(z,x) order, looking along Y axis. */
                /* crx[1][j][1], first component is index for axis,
                in this case, '1st comp of array' rep. Y axis,
                the rest two rep. z, and x, resp.*/

                 if ((*blk_crx)->comp[j][1][1] != (*blk_crx)->comp[j][0][1])
                 {
                      if(crx[j+2][0] == NULL)
                      {
                          printf("ERROR CSG_blk_on_front()\n");
                          printf("crx[j+2][0] == NULL, j = %d\n",j);
                          clean_up(ERROR);
                      }
                      (*blk_crx)->crx[1][1][j].type = IS_BBI_P;
                      (*blk_crx)->crx[1][1][j].csg_pt.crx = crx[j+2][0];
                      (*blk_crx)->pos_comp = crx[j+2][0]->hs->pos_comp;
                      (*blk_crx)->neg_comp = crx[j+2][0]->hs->neg_comp;
                 }
            }
            for(j = 0; j < 2; j++)
            {
                /* t(z)  = 1, X(y,z) order, looking along X axis. */
                 if ((*blk_crx)->comp[0][j][1] != (*blk_crx)->comp[1][j][1])
                 {
                      if(crx[j][0] == NULL)
                      {
                          printf("ERROR CSG_blk_on_front()\n");
                          printf("crx[j][0] == NULL, j = %d\n",j);
                          clean_up(ERROR);
                      }
                      (*blk_crx)->crx[0][j][1].type = IS_BBI_P;
                      (*blk_crx)->crx[0][j][1].csg_pt.crx = crx[j][0];
                      (*blk_crx)->pos_comp = crx[j][0]->hs->pos_comp;
                      (*blk_crx)->neg_comp = crx[j][0]->hs->neg_comp;
                 }
            }
            (*blk_crx)->type = F_VOL;
            yes_no = YES;
        }

        /* install CRX on Z = 0 plane */
        if(nc2[0] != 0 || nc2[1] != 0 || nc2[2] != 0 || nc2[3] != 0)
        {
            for (j = 0; j < 2; j++)
            {
                /* t(z)  = 1, Y(z,x) order */
                if ((*blk_crx)->comp[j][1][0] != (*blk_crx)->comp[j][0][0])
                {
                     if(crx2[j+2][0] == NULL)
                     {
                         printf("ERROR CSG_blk_on_front()\n");
                         printf("crx2[j+2][0] == NULL, j = %d\n",j);
                         clean_up(ERROR);
                     }
                     (*blk_crx)->crx[1][0][j].type = IS_BBI_P;
                     (*blk_crx)->crx[1][0][j].csg_pt.crx = crx2[j+2][0];
                     (*blk_crx)->pos_comp = crx2[j+2][0]->hs->pos_comp;
                     (*blk_crx)->neg_comp = crx2[j+2][0]->hs->neg_comp;
                }
            }
            for(j = 0; j < 2; j++)
            {
                /* t(z)  = 1, X(y,z)  */
                 if ((*blk_crx)->comp[0][j][0] != (*blk_crx)->comp[1][j][0])
                 {
                      if(crx2[j][0] == NULL)
                      {
                          printf("ERROR CSG_blk_on_front()\n");
                          printf("crx2[j][0] == NULL, j = %d\n",j);
                          clean_up(ERROR);
                      }
                      (*blk_crx)->crx[0][j][0].type = IS_BBI_P;
                      (*blk_crx)->crx[0][j][0].csg_pt.crx = crx2[j][0];
                      (*blk_crx)->pos_comp = crx2[j][0]->hs->pos_comp;
                      (*blk_crx)->neg_comp = crx2[j][0]->hs->neg_comp;
                 }
            }
            (*blk_crx)->type = F_VOL;
            yes_no = YES;
        }

        /* printf("ICRDS[0] = %d, ICRDS[1] = %d\n", icrds[0] , icrds[1]); */
        /* install CRX along Z axis  */
        /* do not need to set pos_comp and neg_comp component here because of
           INTERFACE propagating assumption */
        for(i = 0; i < 2; i++)
            for(j = 0; j < 2; j++)
        {
            ic[0] = icrds[0]+i; ic[1] = icrds[1]+j;
            if(Comp_node(ic,t_crx,new_ntg) != NULL)
            {
                (*blk_crx)->crx[2][i][j].type = IS_BBI_P;
                (*blk_crx)->crx[2][i][j].csg_pt.crx =
                                    Comp_node(ic,t_crx,new_ntg);

                /* reset lcomp and ucomp to NO_COMP for find bond state */
                (*blk_crx)->crx[2][i][j].csg_pt.crx->lcomp =
                (*blk_crx)->crx[2][i][j].csg_pt.crx->ucomp = NO_COMP;
                (*blk_crx)->crx[2][i][j].csg_pt.crx->hs = NULL;
                (*blk_crx)->type = F_VOL;
                yes_no = YES;
            }
        }

#if defined(DEBUG)
        if((*blk_crx)->type == F_VOL)
        {
            if( (*blk_crx)->pos_comp == -1 || (*blk_crx)->neg_comp == -1)
            {
                printf("ERROR: CSG_blk_on_front() ic[%d,%d]\n", icrds[0], icrds[1]);
                printf("crxings (1) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
                  nc[0], nc[1], nc[2], nc[3]);
                for(i = 0; i < 4; i++)
                {
                    if(nc[i] != 0)
                    {
                        for(j = 0; j < nc[i]; j++)
                            print_crxings(crx[i][j], NO); 
                    }
                }
                printf("crxings (2) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
                  nc2[0], nc2[1], nc2[2], nc2[3]);
                for(i = 0; i < 4; i++)
                {
                    if(nc2[i] != 0)
                    {
                        for(j = 0; j < nc2[i]; j++)
                            print_crxings(crx2[i][j], NO); 
                    }
                }
                printf("(*blk_crx)->pos_comp = %d\n", (*blk_crx)->pos_comp);
                printf("(*blk_crx)->neg_comp = %d\n", (*blk_crx)->neg_comp);
                clean_up(ERROR);
            }
        }
#endif /* if defined(DEBUG) */

        return yes_no;
}

LOCAL void init_csg_blk_crx(
        CSG_BLK_CRX     **blk_crx,
        int             *icrds,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int            i, j, k;
        int            icrds_now[MAXD+1];

        alloc_csg_blk_crx(blk_crx);

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    icrds_now[0] = icrds[0] + i;
                    icrds_now[1] = icrds[1] + j;
                    icrds_now[2] = k;
                    (*blk_crx)->icrds[i][j][k].type = IS_ICRDS;
                    memcpy((*blk_crx)->icrds[i][j][k].csg_pt.icrds,
                    icrds_now, sizeof(int)*3);
                }
                (*blk_crx)->comp[i][j][1] =
                             Regular_comp_grid_comp(icrds_now, new_ntg);
                (*blk_crx)->comp[i][j][0] =
                             Regular_comp_grid_comp(icrds_now, old_ntg);
            }
        }
}

LOCAL void alloc_csg_blk_crx_r(
         CSG_BLK_CRX_r    **blk_crx)
{
        int            i, j, k;

        scalar(blk_crx, sizeof(CSG_BLK_CRX_r));
        tri_array(&((*blk_crx)->comp),2,2,2,sizeof(COMPONENT));
        tri_array(&((*blk_crx)->icrds),2,2,2,sizeof(CSG_POINT*));
        tri_array(&((*blk_crx)->ix),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->iy),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->iz),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->crx),3,2,2,sizeof(CSG_POINT*));
        (*blk_crx)->type = UNSET;
        (*blk_crx)->s = NULL;
        (*blk_crx)->pos_comp = -1;
        (*blk_crx)->neg_comp = -1;

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    (*blk_crx)->ix[i][j][k] = i;
                    (*blk_crx)->iy[i][j][k] = j;
                    (*blk_crx)->iz[i][j][k] = k;
                }
            }
        }

}


LOCAL void copy_csg_blk_crx_r(
        CSG_BLK_CRX       *blk_src,
        CSG_BLK_CRX_r     *blk_des)
{
        int i,j,k;

        blk_des->type = blk_src->type;
        blk_des->pos_comp = blk_src->pos_comp;
        blk_des->neg_comp = blk_src->neg_comp;
        blk_des->min_comp = blk_src->min_comp;
        blk_des->s = blk_src->s;

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    blk_des->comp[i][j][k] = blk_src->comp[i][j][k];
                    blk_des->icrds[i][j][k] = &blk_src->icrds[i][j][k];
                }
            }
        }


        for (i = 0; i < 3; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    blk_des->crx[i][j][k] = &blk_src->crx[i][j][k];
                }
            }
        }
}


LOCAL void alloc_csg_blk_crx(
         CSG_BLK_CRX    **blk_crx)
{
        int            i, j, k;

        scalar(blk_crx, sizeof(CSG_BLK_CRX));
        tri_array(&((*blk_crx)->comp),2,2,2,sizeof(COMPONENT));
        tri_array(&((*blk_crx)->icrds),2,2,2,sizeof(CSG_POINT));
        tri_array(&((*blk_crx)->ix),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->iy),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->iz),2,2,2,sizeof(int));
        tri_array(&((*blk_crx)->crx),3,2,2,sizeof(CSG_POINT));
        (*blk_crx)->type = UNSET;
        (*blk_crx)->s = NULL;
        (*blk_crx)->pos_comp = -1;
        (*blk_crx)->neg_comp = -1;

        for (i = 0; i < 2; i++)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    (*blk_crx)->ix[i][j][k] = i;
                    (*blk_crx)->iy[i][j][k] = j;
                    (*blk_crx)->iz[i][j][k] = k;
                }
            }
        }
}

/* The old function is del_vol_blk(). 
 */
LOCAL void free_csg_blk_crx_vol(
        CSG_BLK_CRX     **blk)
{
      CSG_Solid        *s;
      s = (*blk)->s;
      while(s)
      {
          if(s->nexts)
          {
              s = s->nexts;
              free_CSG_vol(&(s->prevs));
              s->prevs = NULL;
          }
          else
          {
              free_CSG_vol(&s);
              s = NULL;
          }
      }

      (*blk)->s = NULL;
      free((*blk)->comp);
      free((*blk)->icrds);
      free((*blk)->ix);
      free((*blk)->iy);
      free((*blk)->iz);
      free((*blk)->crx);
      free(*blk);
      (*blk) = NULL;
}

EXPORT void free_control_volume_storage(
       TRI_GRID   *ntg)
{
        CSG_BLK_CRX **blk = ntg->Volume.blk;
        CRXING      **t_crxes = ntg->Volume.t_crxes;
        int         i, j, smin[MAXD], smax[MAXD]; 
        int         icrds[MAXD+1];

        if(blk == NULL) 
            return;

        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = ntg->comp_grid.gmax[i];
            smin[i] -= ntg->comp_grid.lbuf[i];
            smax[i] += ntg->comp_grid.ubuf[i];
        }

        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            icrds[0] = i; icrds[1] = j;
            if(Comp_blk(icrds,blk,ntg)!= NULL)
                free_csg_blk_crx_vol(&Comp_blk(icrds,blk,ntg));
        }

        free(blk);
        ntg->Volume.blk = NULL;

        for(i= smin[0]; i < smax[0]+1; i++)
            for(j = smin[1]; j < smax[1]+1; j++)
        {
            icrds[0] = i; icrds[1] = j;
            if(Comp_node(icrds,t_crxes,ntg) != NULL)
                free(Comp_node(icrds,t_crxes,ntg));
        }
        free(t_crxes);
        ntg->Volume.t_crxes = NULL;  
}


EXPORT  int comp_crossings_in_direction(
        CRXING          **crx_list,
        int             *icoords,
        GRID_DIRECTION  dir,
        TRI_GRID        *ntg)
{
        int             dim = ntg->tg_grid.dim;
        int             ic[MAXD];
        int             ncross = 0;

        tri_grid_index_from_comp_grid_index(ic,icoords,ntg,ON_COMP_GRID);
        switch (dim)
        {
#if defined(TWOD)
        case 2:
            ncross = crossings_in_direction2d(crx_list,ic,dir,ntg,ON_COMP_GRID);
            break;
#endif /* defined(TWOD) */
        }
        return ncross;
}               /*end comp_crossings_in_direction*/


LOCAL void find_odd_point_and_create_CSG_vol(
        CSG_BLK_CRX     *blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int           i,j,k;
        int           num_isolated = 0;
        COMPONENT     ***comp = blk_crx->comp;
        COMPONENT     min_comp = blk_crx->min_comp;
        CSG_POINT     ***icrds = blk_crx->icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;

        /* Search for isolated points */
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        rot_point_and_create_corner_vol(
                           i,j,k,blk_crx, new_ntg, old_ntg);
                    }
                }
            }
        }
}

LOCAL void rot_point_and_create_corner_vol(
        int              ic,
        int              jc,
        int              kc,
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID         *new_ntg,
        TRI_GRID         *old_ntg)
{
        COMPONENT min_comp = blk_crx->min_comp;
        COMPONENT pos_comp = blk_crx->pos_comp;
        CSG_POINT ****ricrds;
        CSG_POINT *rcrx1, *rcrx2, *rcrx3;
        int       n_rot_xy,n_rot_yz;
        static CSG_BLK_CRX_r  *rbc_rot, *rbc_tmp = NULL;
        CSG_Solid  *s;
        float      vol1;  

#if defined(NAVIGATOR)
        NAV_ENTER(rot_point_and_create_corner_vol)
#endif /* defined(NAVIGATOR) */

        if (rbc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&rbc_tmp);
            alloc_csg_blk_crx_r(&rbc_rot);
        }
        copy_csg_blk_crx_r(blk_crx,rbc_rot);
        copy_csg_blk_crx_r(blk_crx,rbc_tmp);
        rbc_rot->s = NULL;
        blk_crx->s = NULL;

        /* Determine number of rotationas in  */
        /*  x-y and y-z plans respectively    */

        n_rot_xy = csg_num_rotation(ic,jc);
        n_rot_yz = csg_num_rotation(0,kc);

        /* Perform rotations */

        csg_rot_xy_r1(blk_crx,rbc_tmp,n_rot_xy);
        csg_rot_yz_r(rbc_tmp,rbc_rot,n_rot_yz);
        
        /*
        print_csg_blk_crx(blk_crx);
        print_csg_blk_crx(bc_rot);
        */

        ricrds = rbc_rot->icrds;
        rcrx1 = CSG_crx_in_idir_r(rbc_rot,0,0);
        rcrx2 = CSG_crx_in_jdir_r(rbc_rot,0,0);
        rcrx3 = CSG_crx_in_kdir_r(rbc_rot,0,0);

        /*      
        This part of the code for constructing VOL is
        implemented via the VOL. Splitting Tec.
        create_corner_vol(bc_rot, &icrds[0][0][0],
             crx1, crx2, crx3, new_ntg, old_ntg);
        */

        s = create_corner_vol2(blk_crx, ricrds[0][0][0],
             rcrx2, rcrx1, rcrx3);

        vol1 = s->vol = tetrahedron_vol(ricrds[0][0][0], 
             rcrx2, rcrx1, rcrx3); 
        s->unset = NO; 
 
        s = create_complement_vol_for_corner_vol2(blk_crx,
            rcrx2, rcrx1, rcrx3, ricrds[0][0][1],
         ricrds[1][0][1], ricrds[1][1][1], ricrds[0][1][1],
         ricrds[1][0][0], ricrds[1][1][0], ricrds[0][1][0]);

        s->vol = box_volume - vol1;
        s->unset = NO;  
}

LOCAL bool CSG_is_isolated_point(
        COMPONENT ***comp,
        int i,
        int j,
        int k,
        COMPONENT min_comp)
{
        bool status;
#if defined(NAVIGATOR)
        NAV_ENTER(CSG_is_isolated_point)
#endif /* defined(NAVIGATOR) */

        if (comp[(i+1)%2][j][k] == min_comp)
            status = NO;
        else if (comp[i][(j+1)%2][k] == min_comp)
            status = NO;
        else if (comp[i][j][(k+1)%2] == min_comp)
            status = NO;
        else
            status = YES;
#if defined(NAVIGATOR)
        NAV_LEAVE(CSG_is_isolated_point)
#endif /* defined(NAVIGATOR) */
        return status;
}               /*end CSG_is_isolated_point*/


LOCAL void create_CSG_vol_for_two_point(
        CSG_BLK_CRX      *blk_crx)
{
        int           i,j,k;
        int           num_isolated = 0;
        COMPONENT     ***comp = blk_crx->comp;
        COMPONENT     min_comp = blk_crx->min_comp;
        CSG_POINT     ***icrds = blk_crx->icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;

#if defined(NAVIGATOR)
        NAV_ENTER(create_CSG_vol_for_two_point)
#endif /* defined(NAVIGATOR) */


        /* Search for isolated points */
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        if (CSG_is_isolated_point(comp,i,j,k,min_comp) == YES)
                        {
                            num_isolated++;
/* Rotation one isolated pt to [0][0][0], then find another pt */
                            rot_point_and_create_3vol_for_2pt_isolate(i,j,k,blk_crx);
                            return;
                        }
                    }
                }
            }
        }

        if(num_isolated != 0)
        {
            printf("IN create_CSG_vol_for_two_point, ");
            printf("there are %d isolated_points, Handle this case exit(0)\n",num_isolated);
            printf("min, neg, pos COMP<%d, %d, %d>\n", min_comp,
                    blk_crx->neg_comp,blk_crx->pos_comp);
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        int i_line,i1,i2;
                        if ((i == 0 && comp[1][j][k] == min_comp) ||
                            (i == 1 && comp[0][j][k] == min_comp))
                        {
                                i_line = 1; i1 = j; i2 = k;
                                rot_line_and_create_float_vol(i_line,i1,i2,blk_crx);
#if defined(NAVIGATOR)
                                NAV_LEAVE(create_CSG_vol_for_two_point)
#endif /* defined(NAVIGATOR) */
                                return;
                        }
                        else if ((j == 0 && comp[i][1][k] == min_comp)
                             || (j == 1 && comp[i][0][k] == min_comp))
                        {
                                i_line = 2; i1 = k; i2 = i;
                                rot_line_and_create_float_vol(i_line,i1,i2,blk_crx);
#if defined(NAVIGATOR)
                                NAV_LEAVE(create_CSG_vol_for_two_point)
#endif /* defined(NAVIGATOR) */
                                return;
                        }
                        else if ((k == 0 && comp[i][j][1] == min_comp)
                             || (k == 1 && comp[i][j][0] == min_comp))
                        {
                                i_line = 3; i1 = i; i2 = j;
                                rot_line_and_create_float_vol(i_line,i1,i2,blk_crx);
#if defined(NAVIGATOR)
                                NAV_LEAVE(create_CSG_vol_for_two_point)
#endif /* defined(NAVIGATOR) */
                                return;
                        }
                    }
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(create_CSG_vol_for_two_point)
#endif /* defined(NAVIGATOR) */
}

LOCAL void rot_point_and_create_3vol_for_2pt_isolate(
        int              ic,
        int              jc,
        int              kc,
        CSG_BLK_CRX      *blk_crx)
{
        static CSG_BLK_CRX_r *bc_rot,*bc_tmp = NULL;
        int n_rot_xy,n_rot_yz;
        int           i,j,k;
        int           num_isolated = 0;
        COMPONENT     ***comp;
        COMPONENT     min_comp = blk_crx->min_comp;
        CSG_POINT     ****icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4, *crx5, *crx6;
        CSG_Solid     *s;  
        float         vol1, vol2; 

        comp = blk_crx->comp;
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        if (CSG_is_isolated_point(comp,i,j,k,min_comp) == YES)
                        {
                            num_isolated++;
                        }
                    }
                }
            }
        }

        if(num_isolated != 2)
        {
            printf("ERROR num_isolated = %d\n", num_isolated);  
            printf("IN rot_point_and_create_3vol_for_2pt_isolate, rotated\n");
            print_csg_blk_crx_r(bc_rot);
            printf("min, neg, pos COMP<%d, %d, %d>\n", min_comp,
                    blk_crx->neg_comp,blk_crx->pos_comp);
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }

        if (bc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&bc_tmp);
            alloc_csg_blk_crx_r(&bc_rot);
        }
        copy_csg_blk_crx_r(blk_crx,bc_rot);
        copy_csg_blk_crx_r(blk_crx,bc_tmp);

        /* Determine number of rotationas in  */
        /*  x-y and y-z plans respectively    */

        n_rot_xy = csg_num_rotation(ic,jc);
        n_rot_yz = csg_num_rotation(0,kc);

                /* Perform rotations */

        csg_rot_xy_r1(blk_crx,bc_tmp,n_rot_xy);
        csg_rot_yz_r(bc_tmp,bc_rot,n_rot_yz);

        comp = bc_rot->comp;
        icrds = bc_rot->icrds;


        if(comp[0][0][0] == min_comp &&
           comp[1][0][1] == min_comp)
        {
            crx1 = CSG_crx_in_idir_r(bc_rot,0,0);
            crx2 = CSG_crx_in_jdir_r(bc_rot,0,0);
            crx3 = CSG_crx_in_kdir_r(bc_rot,0,0);

            crx4 = CSG_crx_in_idir_r(bc_rot,0,1);
            crx5 = CSG_crx_in_jdir_r(bc_rot,1,1);
            crx6 = CSG_crx_in_kdir_r(bc_rot,1,0);

            s = create_corner_vol2(blk_crx, icrds[0][0][0],
                  crx2, crx1, crx3);
            vol1 = s->vol = tetrahedron_vol(icrds[0][0][0], crx2, crx1, crx3);
            s->unset = NO;  
 
            s = create_corner_vol2(blk_crx, icrds[1][0][1],
                  crx5, crx4, crx6);
            vol2 = s->vol = tetrahedron_vol(icrds[1][0][1], crx5, crx4, crx6);
            s->unset = NO;  
       
            s = create_3rd_vol_for_2pt_isolate1(blk_crx,
                crx1,crx2,crx3,crx4,crx5,crx6,icrds[0][0][1],icrds[0][1][1],
                icrds[1][1][1],icrds[0][1][0],icrds[1][1][0],icrds[1][0][0]);
            s->vol = box_volume - vol1 - vol2; 
            s->unset = NO;  
          
            return;
        }


        if(comp[0][0][0] == min_comp &&
           comp[0][1][1] == min_comp)
        {
            crx1 = CSG_crx_in_idir_r(bc_rot,0,0);
            crx2 = CSG_crx_in_jdir_r(bc_rot,0,0);
            crx3 = CSG_crx_in_kdir_r(bc_rot,0,0);

            crx4 = CSG_crx_in_idir_r(bc_rot,1,1);
            crx5 = CSG_crx_in_jdir_r(bc_rot,1,0);
            crx6 = CSG_crx_in_kdir_r(bc_rot,0,1);

            s = create_corner_vol2(blk_crx, icrds[0][0][0],
                   crx2, crx1, crx3);
            vol1 = s->vol = tetrahedron_vol(icrds[0][0][0], crx2, crx1, crx3);
            s->unset = NO;  
          
            s = create_corner_vol2(blk_crx, icrds[0][1][1],
                   crx5, crx4, crx6);
            vol2 = s->vol = tetrahedron_vol(icrds[0][1][1], crx5, crx4, crx6);
            s->unset = NO;  

            s = create_3rd_vol_for_2pt_isolate2(blk_crx,
                crx1,crx2,crx3,crx4,crx5,crx6,icrds[1][1][1],icrds[1][0][1],
                icrds[0][0][1],icrds[0][1][0],icrds[1][1][0],icrds[1][0][0]);
            s->vol = box_volume - vol1 - vol2; 
            s->unset = NO;  

            return;
        }

        if(comp[0][0][0] == min_comp &&
           comp[1][1][0] == min_comp)
        {
            crx1 = CSG_crx_in_idir_r(bc_rot,0,0);
            crx2 = CSG_crx_in_jdir_r(bc_rot,0,0);
            crx3 = CSG_crx_in_kdir_r(bc_rot,0,0);

            crx4 = CSG_crx_in_jdir_r(bc_rot,0,1);
            crx5 = CSG_crx_in_kdir_r(bc_rot,1,1);
            crx6 = CSG_crx_in_idir_r(bc_rot,1,0);

            s = create_corner_vol2(blk_crx, icrds[0][0][0],
                   crx2, crx1, crx3);
            vol1 = s->vol = tetrahedron_vol(icrds[0][0][0], crx2, crx1, crx3);
            s->unset = NO;
 
            s = create_corner_vol2(blk_crx, icrds[1][1][0],
                   crx5, crx4, crx6);
            vol2 = s->vol = tetrahedron_vol(icrds[1][1][0], crx5, crx4, crx6);
            s->unset = NO;

            s = create_3rd_vol_for_2pt_isolate2(blk_crx,
                crx5,crx6,crx4,crx3,crx1,crx2,icrds[0][0][1],icrds[1][0][1],
                icrds[1][0][0],icrds[0][1][0],icrds[0][1][1],icrds[1][1][1]);
            s->vol = box_volume - vol1 - vol2; 
            s->unset = NO;  

            return;
        }


        if(comp[0][0][0] == min_comp &&
           comp[1][1][1] == min_comp)
        {
            crx1 = CSG_crx_in_idir_r(bc_rot,0,0);
            crx2 = CSG_crx_in_jdir_r(bc_rot,0,0);
            crx3 = CSG_crx_in_kdir_r(bc_rot,0,0);

            crx4 = CSG_crx_in_jdir_r(bc_rot,1,1);
            crx5 = CSG_crx_in_kdir_r(bc_rot,1,1);
            crx6 = CSG_crx_in_idir_r(bc_rot,1,1);

            s = create_corner_vol2(blk_crx, icrds[0][0][0],
                   crx2, crx1, crx3);
            vol1 = s->vol = tetrahedron_vol(icrds[0][0][0], crx2, crx1, crx3);
            s->unset = NO; 

            s = create_corner_vol2(blk_crx, icrds[1][1][1],
                   crx4, crx5, crx6);
            vol2 = s->vol = tetrahedron_vol(icrds[1][1][1], crx4, crx5, crx6);
            s->unset = NO; 

            s = create_3rd_vol_for_2pt_isolate4(blk_crx,
                crx1,crx2,crx3,crx4,crx5,crx6,icrds[1][0][0],icrds[1][1][0],
                icrds[1][0][1],icrds[0][0][1],icrds[0][1][1],icrds[0][1][0]);
            s->vol = box_volume - vol1 - vol2; 
            s->unset = NO;  

            return;
        }
        printf("IN rot_point_and_create_3vol_for_2pt_isolate, rotated\n");
        print_csg_blk_crx_r(bc_rot);
        printf("min, neg, pos COMP<%d, %d, %d>\n", min_comp,
                blk_crx->neg_comp,blk_crx->pos_comp);
        print_csg_blk_crx(blk_crx);
        clean_up(ERROR);
}

LOCAL void rot_line_and_create_float_vol(
        int              i_line,
        int              i1,
        int              i2,
        CSG_BLK_CRX      *blk_crx)
{
        static CSG_BLK_CRX_r *bc_rot,*bc_tmp = NULL;
        CSG_POINT     ****icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;
        static TRI    *tri1, *tri2;
        float         *n, nor1[MAXD+1], nor2[MAXD+1], D;
        float         angl1, angl2;
        int           i;
        CSG_Solid     *s;
        float         vol1; 

#if defined(NAVIGATOR)
        NAV_ENTER(rot_line_and_create_float_vol)
#endif /* defined(NAVIGATOR) */

        if (bc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&bc_tmp);
            alloc_csg_blk_crx_r(&bc_rot);
            scalar(&tri1,sizeof(TRI_Plus_normal));
            scalar(&tri2,sizeof(TRI_Plus_normal));
        }

        copy_csg_blk_crx_r(blk_crx,bc_rot);
        copy_csg_blk_crx_r(blk_crx,bc_tmp);
        blk_crx->s = NULL;

        /* Rotate the line to the z-axis */
        if (i_line == 1)
        {
            int n_rot_yz = csg_num_rotation(i1,i2);
            int n_rot_zx = 3;
            csg_rot_yz_r1(blk_crx,bc_tmp,n_rot_yz);
            csg_rot_zx_r(bc_tmp,bc_rot,n_rot_zx);
        }
        else if (i_line == 2)
        {
            int n_rot_zx = csg_num_rotation(i1,i2);
            int n_rot_yz = 1;
            csg_rot_zx_r1(blk_crx,bc_tmp,n_rot_zx);
            csg_rot_yz_r(bc_tmp,bc_rot,n_rot_yz);
        }
        else if (i_line == 3)
        {
            int n_rot_xy = csg_num_rotation(i1,i2);
            csg_rot_xy_r1(blk_crx,bc_rot,n_rot_xy);
        }
         /*
         print_csg_blk_crx_r(bc_rot);
         */
         icrds = bc_rot->icrds;
         crx1 = CSG_crx_in_idir_r(bc_rot,0,1);
         crx2 = CSG_crx_in_idir_r(bc_rot,0,0);
         crx3 = CSG_crx_in_jdir_r(bc_rot,0,0);
         crx4 = CSG_crx_in_jdir_r(bc_rot,1,0);

         if(crx1 == NULL || crx2 == NULL ||
            crx3 == NULL || crx4 == NULL)
         {
             printf("ERROR rot_line_and_create_float_vol\n");
             printf("crx1...crx4, one of them is null\n");
             clean_up(ERROR);  
         }

         tri1->__pts[0] = crx1->csg_pt.crx->pt;
         tri1->__pts[1] = crx2->csg_pt.crx->pt;
         tri1->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri1);
         D = sqrt(((TRI_Plus_normal*)tri1)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri1)->_nor;
         for (i = 0; i < 3; i++)
             nor1[i] = n[i]/D;

         tri2->__pts[0] = crx2->csg_pt.crx->pt;
         tri2->__pts[1] = crx3->csg_pt.crx->pt;
         tri2->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri2);
         // D = sqrt(sqr_normal_vector(tri2));
         D = sqrt(((TRI_Plus_normal*)tri2)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri2)->_nor;
         for (i = 0; i < 3; i++)
             nor2[i] = n[i]/D;

         angl1 = scalar_product(nor1,nor2,3);
         /*
         if(blk_crx->icrds[0][0][0].csg_pt.icrds[0] == 14 and
            blk_crx->icrds[0][0][0].csg_pt.icrds[1] == 10)
         {
             printf("In rot_line_and_create_float_vol(): ");
             printf("1st angl1<%f>\n", angl1);
             fv_print_single_tri(tri1);
             fv_print_single_tri(tri2);
         }
         */
         tri1->__pts[0] = crx1->csg_pt.crx->pt;
         tri1->__pts[1] = crx2->csg_pt.crx->pt;
         tri1->__pts[2] = crx3->csg_pt.crx->pt;
         set_normal_of_tri(tri1);
         // D = sqrt(sqr_normal_vector(tri1));
         D = sqrt(((TRI_Plus_normal*)tri1)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri1)->_nor;
         for (i = 0; i < 3; i++)
             nor1[i] = n[i]/D;

         tri2->__pts[0] = crx1->csg_pt.crx->pt;
         tri2->__pts[1] = crx3->csg_pt.crx->pt;
         tri2->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri2);
         // D = sqrt(sqr_normal_vector(tri2));
         D = sqrt(((TRI_Plus_normal*)tri2)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri2)->_nor;
         for (i = 0; i < 3; i++)
             nor2[i] = n[i]/D;

         angl2 = scalar_product(nor1,nor2,3);
         /*
         if(blk_crx->icrds[0][0][0].csg_pt.icrds[0] == 14 and
            blk_crx->icrds[0][0][0].csg_pt.icrds[1] == 10)
         {
             printf("In rot_line_and_create_float_vol(): ");
             printf("2nd angl2< %f>\n", angl2);
             fv_print_single_tri(tri1);
             fv_print_single_tri(tri2);
         }
         */

         /*
         if(angl1 >  1.0 or angl1 < -1.0 or
            angl2 >  1.0 or angl2 < -1.0)
         {
             printf("angl1, angl2<%f, %f>\n", angl1, angl2);
             print_tri(tri1);
             print_tri(tri2);
             print_csg_blk_crx(blk_crx);
         }
         */
         if(angl1 > 1.000001 || angl1 < -1.0)
         {
             printf("ERROR in rot_line_and_create_float_vol()\n ");
             printf("angle1 = %g\n", angl1);
             clean_up(ERROR);  
         }
         if(angl2 > 1.000001 || angl2 < -1.0)
         {
             printf("ERROR in rot_line_and_create_float_vol()\n ");
             printf("angle2 = %g\n", angl2);
             clean_up(ERROR);  
         }

         if(angl1 >= angl2)
         {
             vol1 = 0.0; 
             s = creat_vol_for_edge_case(blk_crx,
                       icrds[0][0][1], crx4, crx3,
                       icrds[0][0][0], crx2, crx1);
             vol1 += tetrahedron_vol(crx2, crx1, crx4, icrds[0][0][1]); 
             vol1 += tetrahedron_vol(crx2, crx4, crx3, icrds[0][0][1]); 
             vol1 += tetrahedron_vol(icrds[0][0][0], crx2, crx3, icrds[0][0][1]); 
             s->vol = vol1;
             s->unset = NO; 

             s = creat_complement_vol_for_edge_case(blk_crx,
                       crx2, icrds[1][0][0], icrds[1][0][1], crx1,
                       crx4, icrds[0][1][1], icrds[1][1][1], icrds[1][1][0],
                       crx3, icrds[0][1][0]);
             s->vol = box_volume - vol1;
             s->unset = NO; 
             
             return;
          }
          else
          {
             /*
             print_csg_blk_crx(blk_crx);
             */
             vol1 = 0.0; 
             s = creat_vol_for_edge_case_angl2(blk_crx,
                       icrds[0][0][1], crx4, crx3,
                       icrds[0][0][0], crx2, crx1);
             vol1 += tetrahedron_vol(crx2, crx1, crx3, icrds[0][0][1]); 
             vol1 += tetrahedron_vol(crx1, crx4, crx3, icrds[0][0][1]); 
             vol1 += tetrahedron_vol(icrds[0][0][0], crx2, crx3, icrds[0][0][1]); 
             s->vol = vol1;
             s->unset = NO; 

             s = creat_complement_vol_for_edge_case_angl2(blk_crx,
                       crx2, icrds[1][0][0], icrds[1][0][1], crx1,
                       crx4, icrds[0][1][1], icrds[1][1][1], icrds[1][1][0],
                       crx3, icrds[0][1][0]);
             s->vol = box_volume - vol1;
             s->unset = NO; 
              /*
              print_solid(blk_crx);
              screen("in rot_line_and_create_float_vol(), other case\n");
              clean_up(ERROR); 
              */
              return;
          }
          printf("ERROR: IN rot_line_and_create_float_vol()\n ");
          printf("Could not create vol\n");
          print_csg_blk_crx(blk_crx);
          clean_up(ERROR);

#if defined(NAVIGATOR)
        NAV_LEAVE(rot_line_and_create_float_vol)
#endif /* defined(NAVIGATOR) */
}

LOCAL void create_CSG_vol_for_three_point(
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID         *new_ntg,
        TRI_GRID         *old_ntg)
{
        int           i,j,k;
        int           num_isolated = 0;
        COMPONENT     ***comp = blk_crx->comp;
        COMPONENT     min_comp = blk_crx->min_comp;
        CSG_POINT     ***icrds = blk_crx->icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;

#if defined(NAVIGATOR)
        NAV_ENTER(create_CSG_vol_for_three_point)
#endif /* defined(NAVIGATOR) */

        /* Search for isolated points */
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        if (CSG_is_isolated_point(comp,i,j,k,min_comp) == YES)
                            num_isolated++;
                    }
                }
            }
        }

        if(num_isolated == 3)
        {
            printf("ERROR\n");
            screen("PROCESSING IN create_CSG_vol_for_three_point(),"
                   " num_isolated = 3, exit(0), processing \n");
            clean_up(ERROR);
        }
        else if(num_isolated == 1)
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[0][j][k] == min_comp && comp[1][j][k] == min_comp)
                    {
                        rot_line_and_create_float_vol_3pt(1,j,k,blk_crx,new_ntg,old_ntg);
                        return;
                    }
                }
            }
            for (i = 0; i < 2; i++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][0][k] == min_comp && comp[i][1][k] == min_comp)
                    {
                        rot_line_and_create_float_vol_3pt(2,k,i,blk_crx,new_ntg,old_ntg);
                        return;
                    }
                }
            }
            for (i = 0; i < 2; i++)
            {
                for (j = 0; j < 2; j++)
                {
                    if (comp[i][j][0] == min_comp && comp[i][j][1] == min_comp)
                    {
                        rot_line_and_create_float_vol_3pt(3,i,j,blk_crx,new_ntg,old_ntg);
                        return;
                    }
                }
            }
        }
        else
        {
            for (j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    for (i = 0; i < 2; i++)
                    {
                        if (comp[i][j][k]       == min_comp &&
                            comp[i][(j+1)%2][k] == min_comp &&
                            comp[i][j][(k+1)%2] == min_comp)
                        {
                            rot_height_and_create_angle_vol(1,j,k,blk_crx, new_ntg, old_ntg);
                            return;
                        }
                    }
                }
            }


            for (i = 0; i < 2; i++)
            {
                for (k = 0; k < 2; k++)
                {
                    for (j = 0; j < 2; j++)
                    {
                        if (comp[i][j][k]       == min_comp &&
                            comp[(i+1)%2][j][k] == min_comp &&
                            comp[i][j][(k+1)%2] == min_comp)
                        {
                            rot_height_and_create_angle_vol(2,k,i,blk_crx, new_ntg, old_ntg);
                            return;
                        }
                    }
                }
            }



            for (i = 0; i < 2; i++)
            {
                for (j = 0; j < 2; j++)
                {
                    for (k = 0; k < 2; k++)
                    {
                        if (comp[i][j][k]       == min_comp &&
                            comp[(i+1)%2][j][k] == min_comp &&
                            comp[i][(j+1)%2][k] == min_comp)
                        {
                            printf("ERROR: rot_height_and_create_angle_vol(), exit(0)\n");
                            screen("3rd, <%d, %d, %d>\n", i, j ,k);
                            screen("3rd, rot_height_and_create_angle_vol(), exit(0)\n");
                            rot_height_and_create_angle_vol(3,i,j,blk_crx, new_ntg, old_ntg);
                            print_solid(blk_crx);
                            clean_up(ERROR);  
                        }
                    }
                }
            }
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(create_CSG_vol_for_three_point)
#endif /* defined(NAVIGATOR) */
}

LOCAL void rot_line_and_create_float_vol_3pt(
        int              i_line,
        int              i1,
        int              i2,
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID         *new_ntg,
        TRI_GRID         *old_ntg)
{
        COMPONENT min_comp = blk_crx->min_comp;
        COMPONENT pos_comp = blk_crx->pos_comp;
        COMPONENT ***comp_rot;
        COMPONENT neg_comp = blk_crx->neg_comp;
        CSG_POINT     ****icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4, *crx5, *crx6, *crx7;
        static CSG_BLK_CRX_r *rbc_rot,*rbc_tmp = NULL;
        int              ic[MAXD];
        CSG_Solid     *s;
        float         vol1, vol2, vol3; 

#if defined(NAVIGATOR)
        NAV_ENTER(rot_line_and_create_float_vol_3pt)
#endif /* defined(NAVIGATOR) */

        if (rbc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&rbc_tmp);
            alloc_csg_blk_crx_r(&rbc_rot);
        }

        copy_csg_blk_crx_r(blk_crx,rbc_rot);
        copy_csg_blk_crx_r(blk_crx,rbc_tmp);
        rbc_rot->s = NULL;
        blk_crx->s = NULL;

        if (i_line == 1)
        {
            int n_rot_yz = csg_num_rotation(i1,i2);
            int n_rot_zx = 3;
            csg_rot_yz_r1(blk_crx,rbc_tmp,n_rot_yz);
            csg_rot_zx_r(rbc_tmp,rbc_rot,n_rot_zx);
        }
        else if (i_line == 2)
        {
            int n_rot_zx = csg_num_rotation(i1,i2);
            int n_rot_yz = 1;
            csg_rot_zx_r1(blk_crx,rbc_tmp,n_rot_zx);
            csg_rot_yz_r(rbc_tmp,rbc_rot,n_rot_yz);
        }
        else if (i_line == 3)
        {
            int n_rot_xy = csg_num_rotation(i1,i2);
            csg_rot_xy_r1(blk_crx,rbc_rot,n_rot_xy);
        }

        icrds = rbc_rot->icrds;
        comp_rot = rbc_rot->comp;
        ic[0] = blk_crx->icrds[0][0][0].csg_pt.icrds[0];
        ic[1] = blk_crx->icrds[0][0][0].csg_pt.icrds[1];

        if(min_comp == comp_rot[0][0][0] && min_comp == comp_rot[0][0][1] &&
           min_comp == comp_rot[1][1][0] &&
           comp_rot[0][0][0] != Regular_grid_comp(ic, old_ntg))
        {
            crx1 = CSG_crx_in_idir_r(rbc_rot,0,0);
            crx2 = CSG_crx_in_idir_r(rbc_rot,0,1);
            crx3 = CSG_crx_in_jdir_r(rbc_rot,1,0);
            crx4 = CSG_crx_in_jdir_r(rbc_rot,0,0);
            crx5 = CSG_crx_in_jdir_r(rbc_rot,0,1);
            crx6 = CSG_crx_in_kdir_r(rbc_rot,1,1);
            crx7 = CSG_crx_in_idir_r(rbc_rot,1,0);

            vol1 = 0.0; 
            s = creat_vol_for_edge_case_angl2(blk_crx,
                      icrds[0][0][1], crx3, crx4,
                      icrds[0][0][0], crx1, crx2);
            vol1 += tetrahedron_vol(crx1, crx2, crx4, icrds[0][0][1]);
            vol1 += tetrahedron_vol(crx2, crx3, crx4, icrds[0][0][1]);
            vol1 += tetrahedron_vol(icrds[0][0][0], crx1, crx4, icrds[0][0][1]);
            s->vol = vol1;
            s->unset = NO;
   
            s = create_corner_vol2(blk_crx, icrds[1][1][0],
                      crx6, crx5, crx7);
            vol2 = s->vol = tetrahedron_vol(icrds[1][1][0], crx6, crx5, crx7);
            s->unset = NO;
 
            s = create_float_vol_3pt(blk_crx, crx1, crx2, crx3, crx4, crx5, crx6, crx7,
                      icrds[1][0][0], icrds[1][0][1], icrds[1][1][1], icrds[0][1][1],
                      icrds[0][1][0]);
            s->vol = box_volume - vol1 - vol2; 
            s->unset = NO;
        }
        else if(min_comp == comp_rot[0][0][0] && min_comp == comp_rot[0][0][1] &&
                min_comp == comp_rot[1][1][0] &&
                comp_rot[0][0][0] == Regular_grid_comp(ic, old_ntg))
        {
            if(Regular_grid_comp(ic, old_ntg) == Regular_grid_comp(ic, new_ntg))
            {
                print_csg_blk_crx_r(rbc_rot);
                printf("ERROR In rot_line_and_create_float_vol_3pt()\n");
                printf("should not degenerate old-ic comp<%d> =  new-ic comp<%d>\n",
                    Regular_grid_comp(ic, old_ntg), Regular_grid_comp(ic, new_ntg));
                clean_up(ERROR);
            }
            crx1 = CSG_crx_in_idir_r(rbc_rot,0,0);
            crx2 = CSG_crx_in_idir_r(rbc_rot,0,1);
            crx3 = CSG_crx_in_jdir_r(rbc_rot,1,0);
            crx4 = CSG_crx_in_jdir_r(rbc_rot,0,0);
            crx5 = CSG_crx_in_jdir_r(rbc_rot,0,1);
            crx6 = CSG_crx_in_kdir_r(rbc_rot,1,1);
            crx7 = CSG_crx_in_idir_r(rbc_rot,1,0);

            vol1 = 0.0; 
            s = create_center_vol_degenerate_3pt(blk_crx, crx1, crx2, crx3, crx4, crx5,
               crx6, crx7,icrds[0][0][0], icrds[0][0][1], icrds[1][1][0]);
            vol1 += tetrahedron_vol(crx5, crx6, crx7, icrds[1][1][0]);;
            vol1 += tetrahedron_vol(crx2, crx5, crx6, crx7);
            vol1 += tetrahedron_vol(crx2, crx6, crx3, crx7);
    
            vol1 += tetrahedron_vol(icrds[0][0][0], crx1, crx2, crx4);
            vol1 += tetrahedron_vol(icrds[0][0][0], crx2, icrds[0][0][1], crx4);

            vol1 += tetrahedron_vol(crx1, crx5, crx7, crx2);
            vol1 += tetrahedron_vol(crx1, crx7, crx4, crx2);
 
            vol1 += tetrahedron_vol(icrds[0][0][1], crx3, crx4, crx2);
            vol1 += tetrahedron_vol(crx3, crx7, crx4, crx2);
            s->vol = vol1;
            s->unset = NO; 

            s = create_complement_center_vol_degenerate_3pt(blk_crx, crx1, crx2, crx3, crx4, crx5,
               crx6, crx7,icrds[1][0][0], icrds[1][0][1], icrds[1][1][1], icrds[0][1][1],
               icrds[0][1][0]);
            s->vol = box_volume - vol1;
            s->unset = NO; 

        }
        else if(min_comp == comp_rot[0][0][0] && min_comp == comp_rot[0][0][1] &&
                min_comp == comp_rot[1][1][1] &&
                comp_rot[0][0][1] != Regular_grid_comp(ic, new_ntg))
        {
            crx1 = CSG_crx_in_jdir_r(rbc_rot,1,0);
            crx2 = CSG_crx_in_jdir_r(rbc_rot,0,0);
            crx3 = CSG_crx_in_idir_r(rbc_rot,0,0);
            crx4 = CSG_crx_in_idir_r(rbc_rot,0,1);
            crx5 = CSG_crx_in_idir_r(rbc_rot,1,1);
            crx6 = CSG_crx_in_kdir_r(rbc_rot,1,1);
            crx7 = CSG_crx_in_jdir_r(rbc_rot,1,1);

            vol1 = 0.0; 
            s = creat_vol_for_edge_case_angl2(blk_crx,
                      icrds[0][0][0], crx3, crx4,
                      icrds[0][0][1], crx1, crx2);
            vol1 += tetrahedron_vol(crx1, crx2, crx4, icrds[0][0][0]);
            vol1 += tetrahedron_vol(crx2, crx3, crx4, icrds[0][0][0]);
            vol1 += tetrahedron_vol(icrds[0][0][1], crx1, crx4, icrds[0][0][0]);
            s->vol = vol1;
            s->unset = NO;

            s = create_corner_vol2(blk_crx, icrds[1][1][1],
                      crx6, crx5, crx7);
            vol2 = s->vol = tetrahedron_vol(icrds[1][1][1], crx6, crx5, crx7);
            s->unset = NO;

            s = create_float_vol_3pt(blk_crx, crx1, crx2, crx3, crx4, crx5, crx6, crx7,
                      icrds[0][1][1], icrds[0][1][0], icrds[1][1][0], icrds[1][0][0],
                      icrds[1][0][1]);
            s->vol = box_volume - vol1 - vol2;
            s->unset = NO; 
        }
        else
        {
            print_csg_blk_crx_r(rbc_rot);
            printf("Stop In rot_line_and_create_float_vol_3pt()\n");
            printf("case need processing\n");
            clean_up(ERROR);
        }
}

LOCAL void rot_height_and_create_angle_vol(
        int              i_height,
        int              i1,
        int              i2,
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID         *new_ntg,
        TRI_GRID         *old_ntg)
{
        COMPONENT min_comp = blk_crx->min_comp;
        COMPONENT pos_comp = blk_crx->pos_comp;
        COMPONENT ***rcomp_rot;
        COMPONENT neg_comp = blk_crx->neg_comp;
        CSG_POINT     ****ricrds;
        CSG_POINT     *rcrx1, *rcrx2, *rcrx3, *rcrx4, *rcrx5;
        static CSG_BLK_CRX_r *rbc_rot,*rbc_tmp = NULL;
        int           ncase;
        CSG_Solid     *s;
        float         vol1; 

#if defined(NAVIGATOR)
        NAV_ENTER(rot_height_and_create_angle_vol)
#endif /* defined(NAVIGATOR) */

        if (rbc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&rbc_tmp);
            alloc_csg_blk_crx_r(&rbc_rot);
        }

        copy_csg_blk_crx_r(blk_crx,rbc_rot);
        copy_csg_blk_crx_r(blk_crx,rbc_tmp);
        rbc_rot->s = NULL;
        blk_crx->s = NULL;

        if (i_height == 1)
        {
            int n_rot_yz = csg_num_rotation(i1,i2);
            int n_rot_zx = 3;

            csg_rot_yz_r1(blk_crx,rbc_tmp,n_rot_yz);
            csg_rot_zx_r(rbc_tmp,rbc_rot,n_rot_zx);
        }
        else if (i_height == 2)
        {
            int n_rot_zx = csg_num_rotation(i1,i2);
            int n_rot_yz = 1;

            csg_rot_zx_r1(blk_crx,rbc_tmp,n_rot_zx);
            csg_rot_yz_r(rbc_tmp,rbc_rot,n_rot_yz);
        }
        else if (i_height == 3)
        {
            int n_rot_xy = csg_num_rotation(i1,i2);

            csg_rot_xy_r1(blk_crx,rbc_rot,n_rot_xy);
        }

        rcomp_rot = rbc_rot->comp;
        if ((min_comp == pos_comp && rcomp_rot[0][0][0] == min_comp) ||
            (min_comp == neg_comp && rcomp_rot[0][0][0] == min_comp))
        {
            /*
            screen("In rot_height_and_create_angle_vol, floor_corner\n");
            print_csg_blk_crx(bc_rot);
            */
            rcrx1 = CSG_crx_in_kdir_r(rbc_rot,1,0);
            rcrx2 = CSG_crx_in_jdir_r(rbc_rot,0,1);
            rcrx3 = CSG_crx_in_idir_r(rbc_rot,1,0);
            rcrx4 = CSG_crx_in_kdir_r(rbc_rot,0,1);
            rcrx5 = CSG_crx_in_kdir_r(rbc_rot,0,0);
            ricrds = rbc_rot->icrds;

            ncase = angles_for_create_angle_vol(rcrx1, rcrx2,rcrx3,rcrx4,rcrx5);
            switch(ncase)
            {
            case 1:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_case(blk_crx, ricrds[0][0][0], ricrds[1][0][0],
                      rcrx2, rcrx3, ricrds[0][1][0], rcrx4, rcrx5, rcrx1);
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[0][1][0], rcrx4, rcrx5, rcrx1); 
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[1][0][0], rcrx2, ricrds[0][1][0], rcrx1); 
                vol1 += pyramid_vol(rcrx1, rcrx2, rcrx3, rcrx4, ricrds[0][1][0]);
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_floor_case(blk_crx, ricrds[0][1][1], ricrds[0][0][1],
                    ricrds[1][0][1], ricrds[1][1][1], rcrx3, rcrx2, ricrds[1][1][0], rcrx4,
                    rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO;

                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 1\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            break;
            case 2:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_case2(blk_crx, ricrds[0][0][0], ricrds[1][0][0],
                      rcrx2, rcrx3, ricrds[0][1][0], rcrx4, rcrx5, rcrx1);
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[1][0][0], rcrx1, rcrx5, rcrx2); 
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[0][1][0], rcrx4, rcrx5, rcrx2); 
                vol1 += tetrahedron_vol(rcrx4, ricrds[0][1][0], rcrx2, rcrx3); 
                s->vol = vol1; 
                s->unset = NO; 

                s = creat_complement_vol_for_floor_case2(blk_crx, ricrds[0][1][1],
                      ricrds[0][0][1], ricrds[1][0][1], ricrds[1][1][1], rcrx3, rcrx2,
                      ricrds[1][1][0], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 

                return;
            break;
            case 3:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_case3(blk_crx, ricrds[0][0][0], ricrds[1][0][0],
                      rcrx2, rcrx3, ricrds[0][1][0], rcrx4, rcrx5, rcrx1);
                vol1 += tetrahedron_vol(ricrds[0][0][0], ricrds[1][0][0], rcrx3, rcrx5);
                vol1 += pyramid_vol(ricrds[1][0][0], rcrx2, rcrx3, rcrx5, rcrx1);
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[0][1][0], rcrx4, rcrx5, rcrx3);
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_floor_case3(blk_crx, ricrds[0][1][1],
                      ricrds[0][0][1], ricrds[1][0][1], ricrds[1][1][1], rcrx3, rcrx2,
                      ricrds[1][1][0], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 

                return;
            break;
            case 4:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_case4(blk_crx, ricrds[0][0][0], ricrds[1][0][0],
                      rcrx2, rcrx3, ricrds[0][1][0], rcrx4, rcrx5, rcrx1);
                vol1 += tetrahedron_vol(ricrds[0][1][0], rcrx2, rcrx3, rcrx4);
                vol1 += pyramid_vol(ricrds[0][0][0], ricrds[1][0][0],rcrx2, ricrds[0][1][0], rcrx1);
                vol1 += pyramid_vol(ricrds[0][0][0],ricrds[0][1][0],rcrx4,rcrx5,rcrx1); 
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_floor_case4(blk_crx, ricrds[0][1][1],
                      ricrds[0][0][1], ricrds[1][0][1], ricrds[1][1][1], rcrx3, rcrx2,
                      ricrds[1][1][0], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 

                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 4\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            break;
            case 5:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_case5(blk_crx, ricrds[0][0][0], ricrds[1][0][0],
                      rcrx2, rcrx3, ricrds[0][1][0], rcrx4, rcrx5, rcrx1);
                vol1 += pyramid_vol(ricrds[0][0][0],ricrds[0][1][0],rcrx4,rcrx5,rcrx3);
                vol1 += tetrahedron_vol(ricrds[0][0][0],rcrx2,rcrx3,rcrx5);
                vol1 += pyramid_vol(ricrds[0][0][0],ricrds[1][0][0],rcrx1,rcrx5,rcrx2);
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_floor_case5(blk_crx, ricrds[0][1][1],
                      ricrds[0][0][1], ricrds[1][0][1], ricrds[1][1][1], rcrx3, rcrx2,
                      ricrds[1][1][0], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 
                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 4\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            break;
            default:
                screen("ERROR In rot_height_and_create_angle_vol() case %d processing\n",
                        ncase);
                printf("rotated blk print\n");
                print_csg_blk_crx_r(rbc_rot);
                printf("original blk print\n");
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);  
            break;
            }
            screen("ERROR in rot_height_and_create_angle_vol, ceining_floor\n");
            clean_up(ERROR);
        }
        else
        {
            rcrx1 = CSG_crx_in_kdir_r(rbc_rot,1,0);  /* 6 */
            rcrx2 = CSG_crx_in_jdir_r(rbc_rot,1,1);  /* 4 */
            rcrx3 = CSG_crx_in_idir_r(rbc_rot,1,1);  /* 3 */
            rcrx4 = CSG_crx_in_kdir_r(rbc_rot,0,1);  /* 8 */
            rcrx5 = CSG_crx_in_kdir_r(rbc_rot,0,0);  /* 7 */
            ricrds = rbc_rot->icrds;

            ncase = angles_for_create_angle_vol(rcrx4, rcrx3,rcrx2,rcrx1,rcrx5);
            switch(ncase)
            {
            case 1:
                vol1 = 0.0;
                s = creat_vol_for_ceining_case(blk_crx, ricrds[0][0][1], ricrds[0][1][1],
                     rcrx3, rcrx2, ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[0][1][1], rcrx3, ricrds[1][0][1], rcrx4);
                vol1 += pyramid_vol(rcrx4, rcrx3, rcrx2, rcrx1, ricrds[1][0][1]);
                s->vol = vol1;
                s->unset = NO;
                 
                s = creat_complement_vol_for_ceining_case(blk_crx, ricrds[0][1][0], ricrds[1][1][0],
                     ricrds[1][0][0], ricrds[0][0][0], rcrx3, rcrx2, ricrds[1][1][1], rcrx4,
                     rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 

                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 21\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            case 2:
                vol1 = 0.0;
                s = creat_vol_for_ceining_ceining_case2(blk_crx, ricrds[0][0][1], ricrds[0][1][1],
                     rcrx3, rcrx2, ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += tetrahedron_vol(rcrx3, rcrx2, rcrx1, ricrds[1][0][1]);
                vol1 += pyramid_vol(ricrds[0][0][1],ricrds[1][0][1],rcrx1,rcrx5,rcrx3);
                vol1 += pyramid_vol(ricrds[0][0][1],ricrds[0][1][1],rcrx4,rcrx5,rcrx3);
                s->vol = vol1;
                s->unset = NO; 
               
                s = creat_complement_vol_for_ceining_case2(blk_crx, ricrds[0][1][0],
                     ricrds[1][1][0], ricrds[1][0][0], ricrds[0][0][0], rcrx3, rcrx2,
                     ricrds[1][1][1], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 
                return;
            break;
            case 3:
                vol1 = 0.0;
                s = creat_vol_for_ceining_case3(blk_crx, ricrds[0][0][1], ricrds[0][1][1],
                      rcrx3, rcrx2, ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += tetrahedron_vol(ricrds[0][0][1], ricrds[0][1][1], rcrx2, rcrx5);
                vol1 += pyramid_vol(ricrds[0][1][1], rcrx3, rcrx2, rcrx5, rcrx4);
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[1][0][1], rcrx1, rcrx5, rcrx2);
                s->vol = vol1;
                s->unset = NO;

                s = creat_complement_vol_for_ceining_case3(blk_crx, ricrds[0][1][0],
                      ricrds[1][1][0], ricrds[1][0][0], ricrds[0][0][0], rcrx3, rcrx2,
                      ricrds[1][1][1], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 
                return;
            break;
            case 4:
                vol1 = 0.0;
                s = creat_vol_for_ceining_ceining_case4(blk_crx, ricrds[0][0][1], ricrds[0][1][1],
                      rcrx3, rcrx2, ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += tetrahedron_vol(rcrx3, rcrx2, rcrx1, ricrds[1][0][1]);
                vol1 += tetrahedron_vol(rcrx3, rcrx1, rcrx4, ricrds[1][0][1]);
                vol1 += tetrahedron_vol(ricrds[1][0][1], rcrx4, ricrds[0][1][1], rcrx3); 
                vol1 += tetrahedron_vol(rcrx4, rcrx1, rcrx5, ricrds[1][0][1]);
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[0][1][1], rcrx4, rcrx5, ricrds[1][0][1]);
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_ceining_case4(blk_crx, ricrds[0][1][0],
                      ricrds[1][1][0], ricrds[1][0][0], ricrds[0][0][0], rcrx3, rcrx2,
                      ricrds[1][1][1], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 

                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 24\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            break;
            case 5:
                vol1 = 0.0; 
                s = creat_vol_for_ceining_ceining_case5(blk_crx, ricrds[0][0][1], ricrds[0][1][1],
                      rcrx3, rcrx2, ricrds[1][0][1], rcrx1, rcrx5, rcrx4);
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[0][1][1], rcrx4, rcrx5, rcrx3); 
                vol1 += tetrahedron_vol(ricrds[0][0][1], rcrx3, rcrx2, rcrx5); 
                vol1 += pyramid_vol(ricrds[0][0][1], ricrds[1][0][1], rcrx1, rcrx5, rcrx2); 
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_ceining_case5(blk_crx, ricrds[0][1][0],
                      ricrds[1][1][0], ricrds[1][0][0], ricrds[0][0][0], rcrx3, rcrx2,
                      ricrds[1][1][1], rcrx4, rcrx5, rcrx1);
                s->vol = box_volume - vol1;
                s->unset = NO; 
                /*
                printf("CSG_VOL: 3pts, rot_height_and_create_angle_vol 25\n");
                print_csg_blk_crx(blk_crx);
                */
                return;
            break;
            default:
                screen("ERROR In rot_height_and_create_angle_vol()"
                       " ceining_corner case %d processing\n",
                        ncase);
                print_csg_blk_crx_r(rbc_rot);
                clean_up(ERROR);  
            break;
            }
            screen("ERROR in rot_height_and_create_angle_vol, ceining_corner\n");
            clean_up(ERROR);
        }
#if defined(NAVIGATOR)
        NAV_LEAVE(rot_height_and_create_angle_vol)
#endif /* defined(NAVIGATOR) */
}

LOCAL int angles_for_create_angle_vol(
        CSG_POINT        *crx1,
        CSG_POINT        *crx2,
        CSG_POINT        *crx3,
        CSG_POINT        *crx4,
        CSG_POINT        *crx5)
{
        static TRI    *tri1 = NULL, *tri2, *tri3;
        float         angl1, angl2, angl3, angl4, angl5;

        if (tri1 == NULL)
        {
            scalar(&tri1,sizeof(TRI_Plus_normal));
            scalar(&tri2,sizeof(TRI_Plus_normal));
            scalar(&tri3,sizeof(TRI_Plus_normal));
        }

        set_time_space_front_tri(tri1,crx1,crx2,crx3);
        set_time_space_front_tri(tri2,crx1,crx3,crx4);
        set_time_space_front_tri(tri3,crx1,crx4,crx5);
        angl1 = scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri2)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri2)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3);

        set_time_space_front_tri(tri1,crx1,crx2,crx5);
        set_time_space_front_tri(tri2,crx2,crx4,crx5);
        set_time_space_front_tri(tri3,crx2,crx3,crx4);
        angl2 = scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri2)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri2)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3);
        set_time_space_front_tri(tri1,crx1,crx2,crx3);
        set_time_space_front_tri(tri2,crx1,crx3,crx5);
        set_time_space_front_tri(tri3,crx3,crx4,crx5);
        angl3 = scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri2)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri2)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3);

        set_time_space_front_tri(tri1,crx1,crx4,crx5);
        set_time_space_front_tri(tri2,crx1,crx2,crx4);
        set_time_space_front_tri(tri3,crx2,crx3,crx4);
        angl4 = scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri2)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri2)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3);

        set_time_space_front_tri(tri1,crx1,crx2,crx5);
        set_time_space_front_tri(tri2,crx2,crx3,crx5);
        set_time_space_front_tri(tri3,crx3,crx4,crx5);
        angl5 = scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri2)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri2)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3) +
                scalar_product(((TRI_Plus_normal*)tri1)->_nor,
                  ((TRI_Plus_normal*)tri3)->_nor,3);

        if(angl1 >= angl2 && angl1 >= angl3 &&
           angl1 >= angl4 && angl1 >= angl5)
            return 1;
        if(angl2 >= angl1 && angl2 >= angl3 &&
           angl2 >= angl4 && angl2 >= angl5)
            return 2;
        if(angl3 >= angl1 && angl3 >= angl2 &&
           angl3 >= angl4 && angl3 >= angl5)
            return 3;
        if(angl4 >= angl1 && angl4 >= angl2 &&
           angl4 >= angl3 && angl4 >= angl5)
            return 4;
        if(angl5 >= angl1 && angl5 >= angl2 &&
           angl5 >= angl3 && angl5 >= angl4)
            return 5;

        printf("ERROR In angles_for_create_angle_vol()\n");
        clean_up(ERROR);
}

LOCAL void  set_time_space_front_tri(
        TRI              *tri,
        CSG_POINT        *crx1,
        CSG_POINT        *crx2,
        CSG_POINT        *crx3)
{
        float         *n, nor[MAXD+1], D;
        int           i;

        tri->__pts[0] = crx1->csg_pt.crx->pt;
        tri->__pts[1] = crx2->csg_pt.crx->pt;
        tri->__pts[2] = crx3->csg_pt.crx->pt;
        set_normal_of_tri(tri);
        D = sqrt(((TRI_Plus_normal*)tri)->_sqr_norm);
        // D = sqrt(tri->sqr_norm);
        n = ((TRI_Plus_normal*)tri)->_nor;
        for (i = 0; i < 3; i++)
            n[i] = n[i]/D;
}

LOCAL void create_CSG_vol_for_four_point(
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        int           i,j,k;
        int           num_isolated = 0;
        COMPONENT     ***comp = blk_crx->comp;
        COMPONENT     min_comp = blk_crx->min_comp;
        CSG_POINT     ***icrds = blk_crx->icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;

#if defined(NAVIGATOR)
        NAV_ENTER(create_CSG_vol_for_four_point)
#endif /* defined(NAVIGATOR) */

        /* Search for isolated points */
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                for (k = 0; k < 2; k++)
                {
                    if (comp[i][j][k] == min_comp)
                    {
                        if (CSG_is_isolated_point(comp,i,j,k,min_comp) == YES)
                        {
                            /* Should build CSG_vol here */
                            printf("IN create_CSG_vol_for_four_point, "
                                "there is isolated_point, Handle this case\n");
                            num_isolated++;
                        }
                    }
                }
            }
        }

        if(num_isolated != 0)
        {
            printf("IN create_CSG_vol_for_four_point, "
                "there are %d isolated_points, Handle this case\n",num_isolated);
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }

        if (num_isolated == 4)
        {
            printf("ERROR IN create_CSG_vol_for_four_point(), num_isolated = 4,");
            printf("Handle this case\n");
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR); 
        }
        else if (num_isolated == 0)
        {
            /* Search for four point combination */

            if (comp[0][0][0] == min_comp && comp[0][0][1] == min_comp &&
                comp[0][1][0] == min_comp && comp[0][1][1] == min_comp)
            {
                rot_plan_and_create_plan_vol(1,0,blk_crx);
                return;
            }
            else if (comp[1][0][0] == min_comp && comp[1][0][1] == min_comp &&
                     comp[1][1][0] == min_comp && comp[1][1][1] == min_comp)
            {
                rot_plan_and_create_plan_vol(1,1,blk_crx);
                return;
            }
            else if (comp[0][0][0] == min_comp && comp[0][0][1] == min_comp &&
                     comp[1][0][0] == min_comp && comp[1][0][1] == min_comp)
            {
                rot_plan_and_create_plan_vol(2,0,blk_crx);
                return;
            }
            else if (comp[0][1][0] == min_comp && comp[0][1][1] == min_comp &&
                     comp[1][1][0] == min_comp && comp[1][1][1] == min_comp)
            {
                rot_plan_and_create_plan_vol(2,1,blk_crx);
                return;
            }
            else if (comp[0][0][0] == min_comp && comp[0][1][0] == min_comp &&
                     comp[1][0][0] == min_comp && comp[1][1][0] == min_comp)
            {
                printf("ERROR IN create_CSG_vol_for_four_point(),"
                        " unknown plane case 1\n");
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);
            }
            else if (comp[0][0][1] == min_comp && comp[0][1][1] == min_comp &&
                     comp[1][0][1] == min_comp && comp[1][1][1] == min_comp)
            {
                printf("ERROR IN create_CSG_vol_for_four_point(), unknown plane case 2\n");
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);
            }
            else
            {
                for (i = 0; i < 2; i++)
                {
                    for (j = 0; j < 2; j++)
                    {
                        for (k = 0; k < 2; k++)
                        {
                            if (comp[i][j][k] == min_comp &&
                                comp[(i+1)%2][j][k] == min_comp &&
                                comp[i][(j+1)%2][k] == min_comp &&
                                comp[i][j][(k+1)%2] == min_comp)
                            {
                                rot_vortex_and_create_star_vol(i,j,k,blk_crx);
                                return;
                            }
                        }
                    }
                }

                for (j = 0; j < 2; j++)
                {
                    for (k = 0; k < 2; k++)
                    {
                        if (csg_is_twist(comp,1,j,k,min_comp) == YES)
                        {
                            rot_stem_and_create_twist_vol(1,j,k,blk_crx);
                            return;
                        }
                    }
                }
                for (i = 0; i < 2; i++)
                {
                    for (k = 0; k < 2; k++)
                    {
                        if (csg_is_twist(comp,2,k,i,min_comp) == YES)
                        {
                            rot_stem_and_create_twist_vol(2,k,i,blk_crx);
                            return;
                        }
                    }
                }
                for (i = 0; i < 2; i++)
                {
                    for (j = 0; j < 2; j++)
                    {
                        if (csg_is_twist(comp,3,i,j,min_comp) == YES)
                        {
                            rot_stem_and_create_twist_vol(3,i,j,blk_crx);
                            return;
                        }
                    }
                }

/* Two edges case */
                for (j = 0; j < 2; j++)
                {
                    for (k = 0; k < 2; k++)
                    {
                        if (comp[0][j][k] == min_comp && comp[1][j][k] == min_comp)
                        {
                            rot_line_and_create_float_vol_4(1,j,k,blk_crx,new_ntg,old_ntg);
                            return;
                        }
                    }
                }
                for (i = 0; i < 2; i++)
                {
                    for (k = 0; k < 2; k++)
                    {
                        if (comp[i][0][k] == min_comp && comp[i][1][k] == min_comp)
                        {
                            rot_line_and_create_float_vol_4(2,k,i,blk_crx,new_ntg,old_ntg);
                            return;
                        }
                    }
                }
                for (i = 0; i < 2; i++)
                {
                    for (j = 0; j < 2; j++)
                    {
                        if (comp[i][j][0] == min_comp && comp[i][j][1] == min_comp)
                        {
                            rot_line_and_create_float_vol_4(3,i,j,blk_crx,new_ntg,old_ntg);
                            return;
                        }
                    }
                }
                printf("ERROR IN create_CSG_vol_for_four_point(), unknown plane case\n");
                print_csg_blk_crx(blk_crx);
                clean_up(ERROR);
            }
            /* end of four points plane case */
        }
        else
        {
            printf("IN create_CSG_vol_for_four_point(),");
            printf("num_isolated = %d \n", num_isolated);
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }

#if defined(NAVIGATOR)
        NAV_LEAVE(create_CSG_vol_for_four_point)
#endif /* defined(NAVIGATOR) */
}

LOCAL   bool csg_is_twist(
        COMPONENT ***comp,
        int i_stem,
        int i1,
        int i2,
        COMPONENT min_comp)
{
        bool status;
#if defined(NAVIGATOR)
        NAV_ENTER(is_twist)
#endif /* defined(NAVIGATOR) */

        status = NO;
        if (i_stem == 1)
        {
            if (
                (comp[0][i1][i2]==min_comp) &&
                (comp[1][i1][i2]==min_comp) &&
                (
                    ((comp[0][(i1+1)%2][i2]==min_comp) &&
                        (comp[1][i1][(i2+1)%2]==min_comp))
                    ||
                    ((comp[1][(i1+1)%2][i2]==min_comp) &&
                        (comp[0][i1][(i2+1)%2]==min_comp))
                )
            )
            status = YES;
        }
        else if (i_stem == 2)
        {
            if (
                (comp[i2][0][i1]==min_comp) &&
                (comp[i2][1][i1]==min_comp) &&
                (
                    ((comp[(i2+1)%2][0][i1]==min_comp) &&
                        (comp[i2][1][(i1+1)%2]==min_comp))
                ||
                    ((comp[(i2+1)%2][1][i1]==min_comp) &&
                        (comp[i2][0][(i1+1)%2]==min_comp))
                )
            )
            status = YES;
        }
        else if (i_stem == 3)
        {
            if (
                (comp[i1][i2][0]==min_comp) &&
                (comp[i1][i2][1]==min_comp) &&
                (
                    ((comp[(i1+1)%2][i2][0]==min_comp) &&
                        (comp[i1][(i2+1)%2][1]==min_comp))
                ||
                    ((comp[(i1+1)%2][i2][1]==min_comp) &&
                        (comp[i1][(i2+1)%2][0]==min_comp))
                )
            )
            status = YES;
        }
#if defined(NAVIGATOR)
        NAV_LEAVE(is_twist)
#endif /* defined(NAVIGATOR) */
        return status;
}               /*end csg_is_twist*/

LOCAL void rot_plan_and_create_plan_vol(
        int              i_normal,
        int              i_plan,
        CSG_BLK_CRX      *blk_crx)
{
        static CSG_BLK_CRX_r *bc_rot,*bc_tmp = NULL;
        static TRI    *tri1, *tri2;
        CSG_POINT     ****icrds;
        CSG_POINT     *crx1, *crx2, *crx3, *crx4;
        float         nor1[MAXD+1], nor2[MAXD+1], D;
        float         *n, angl1, angl2;
        int           i;
        CSG_Solid     *s;
        float         vol1;

#if defined(NAVIGATOR)
        NAV_ENTER(rot_plan_and_create_plan_vol)
#endif /* defined(NAVIGATOR) */

        if (bc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&bc_tmp);
            alloc_csg_blk_crx_r(&bc_rot);
            scalar(&tri1,sizeof(TRI_Plus_normal));
            scalar(&tri2,sizeof(TRI_Plus_normal));
        }

        copy_csg_blk_crx_r(blk_crx,bc_rot);
        copy_csg_blk_crx_r(blk_crx,bc_tmp);
        blk_crx->s = NULL;

        if (i_normal == 1)
        {
            if (i_plan == 0)
            {
                csg_rot_zx_r1(blk_crx,bc_rot,1);
            }
            else
            {
                csg_rot_zx_r1(blk_crx,bc_rot,3);
            }
        }
        if (i_normal == 2)
        {
            if (i_plan == 0)
            {
                csg_rot_yz_r1(blk_crx,bc_rot,3);
            }
            else
            {
                csg_rot_yz_r1(blk_crx,bc_rot,1);
            }
        }
        if (i_normal == 3)
        {
            if (i_plan == 0)
            {
                csg_rot_yz_r1(blk_crx,bc_rot,0);
            }
            else
            {
                csg_rot_yz_r1(blk_crx,bc_rot,2);
            }
        }

        icrds = bc_rot->icrds;

        crx1 = CSG_crx_in_kdir_r(bc_rot,0,0);
        crx2 = CSG_crx_in_kdir_r(bc_rot,1,0);
        crx3 = CSG_crx_in_kdir_r(bc_rot,1,1);
        crx4 = CSG_crx_in_kdir_r(bc_rot,0,1);

        if(crx1 == NULL || crx2 == NULL ||
           crx3 == NULL || crx4 == NULL)
        {
            printf("ERROR in rot_plan_and_create_plan_vol\n");
            printf("one of the crx is NULL\n");
            clean_up(ERROR); 
        } 

         tri1->__pts[0] = crx1->csg_pt.crx->pt;
         tri1->__pts[1] = crx2->csg_pt.crx->pt;
         tri1->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri1);
         D = sqrt(((TRI_Plus_normal*)tri1)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri1)->_nor;
         for (i = 0; i < 3; i++)
             nor1[i] = n[i]/D;

         tri2->__pts[0] = crx2->csg_pt.crx->pt;
         tri2->__pts[1] = crx3->csg_pt.crx->pt;
         tri2->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri2);
         D = sqrt(((TRI_Plus_normal*)tri2)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri2)->_nor;
         for (i = 0; i < 3; i++)
             nor2[i] = n[i]/D;

         angl1 = scalar_product(nor1,nor2,3);

         tri1->__pts[0] = crx1->csg_pt.crx->pt;
         tri1->__pts[1] = crx2->csg_pt.crx->pt;
         tri1->__pts[2] = crx3->csg_pt.crx->pt;
         set_normal_of_tri(tri1);
         D = sqrt(((TRI_Plus_normal*)tri1)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri1)->_nor;
         for (i = 0; i < 3; i++)
             nor1[i] = n[i]/D;

         tri2->__pts[0] = crx1->csg_pt.crx->pt;
         tri2->__pts[1] = crx3->csg_pt.crx->pt;
         tri2->__pts[2] = crx4->csg_pt.crx->pt;
         set_normal_of_tri(tri2);
         D = sqrt(((TRI_Plus_normal*)tri2)->_sqr_norm);
         n = ((TRI_Plus_normal*)tri2)->_nor;
         for (i = 0; i < 3; i++)
             nor2[i] = n[i]/D;

         angl2 = scalar_product(nor1,nor2,3);

         if(angl1 > 1.0000001 || angl1 < -1.0)
         {
             printf("ERROR in rot_plan_and_create_plan_vol()\n ");
             printf("angle1 = %g\n", angl1);
             clean_up(ERROR);
         }
         if(angl2 > 1.0000001 || angl2 < -1.0)
         {
             printf("ERROR in rot_plan_and_create_plan_vol()\n ");
             printf("angle2 = %g\n", angl2);
             clean_up(ERROR);
         }

         vol1 = 0.0;
         if(angl1 >= angl2)
         {
             /* bottom */
             s = creat_vol_for_plane_case(blk_crx, icrds[1][0][0], icrds[0][0][0],
                    icrds[0][1][0], icrds[1][1][0], crx3, crx2, crx4, crx1);
             vol1 += pyramid_vol(crx2, crx4, icrds[0][1][0], icrds[1][0][0], crx1); 
             vol1 += pyramid_vol(crx2, crx4, icrds[0][1][0], icrds[1][0][0], crx3);   
             vol1 += tetrahedron_vol(icrds[0][0][0], icrds[1][0][0], icrds[0][1][0], crx1); 
             vol1 += tetrahedron_vol(icrds[1][1][0], icrds[1][0][0], icrds[0][1][0], crx3); 
             s->vol = vol1;
             s->unset = NO; 

             /* top */
             s = creat_vol_for_plane_case(blk_crx, icrds[0][1][1], icrds[0][0][1],
                    icrds[1][0][1], icrds[1][1][1], crx3, crx4, crx2, crx1);
             s->vol = box_volume - vol1;
             s->unset = NO; 

             return;
         }
         else
         {
             /* bottom */
             s = creat_vol_for_plane_case(blk_crx, icrds[1][1][0], icrds[1][0][0],
                    icrds[0][0][0], icrds[0][1][0], crx4, crx3, crx1, crx2);
             vol1 += pyramid_vol(crx1, crx3, icrds[1][1][0], icrds[0][0][0], crx2); 
             vol1 += pyramid_vol(crx1, crx3, icrds[1][1][0], icrds[0][0][0], crx4); 
             vol1 += tetrahedron_vol(icrds[0][0][0], icrds[1][0][0], icrds[1][1][0], crx2); 
             vol1 += tetrahedron_vol(icrds[0][0][0], icrds[0][1][0], icrds[1][1][0], crx4); 
             s->vol = vol1;
             s->unset = NO; 

             /* top */
             s = creat_vol_for_plane_case(blk_crx, icrds[0][0][1], icrds[1][0][1],
                    icrds[1][1][1], icrds[0][1][1], crx4, crx1, crx3, crx2);
             s->vol = box_volume - vol1;
             s->unset = NO; 

             return;
         }

          printf("ERROR: IN rot_plan_and_create_plan_vol()\n ");
          printf("Could not create vol\n");
          print_csg_blk_crx(blk_crx);
          clean_up(ERROR);

#if defined(NAVIGATOR)
        NAV_LEAVE(rot_plan_and_create_plan_vol)
#endif /* defined(NAVIGATOR) */
}

LOCAL   void rot_vortex_and_create_star_vol(
        int              iv,
        int              jv,
        int              kv,
        CSG_BLK_CRX      *blk_crx)
{
        int              n_rot_xy,n_rot_yz;
        static CSG_BLK_CRX_r  *rbc_rot, *rbc_tmp = NULL;
        CSG_POINT *crx1, *crx2, *crx3, *crx4, *crx5, *crx6;
        CSG_POINT        ****icrds;
        CSG_Solid        *s;
        float            vol1;

        if(rbc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&rbc_tmp);
            alloc_csg_blk_crx_r(&rbc_rot);
        }
        copy_csg_blk_crx_r(blk_crx,rbc_rot);
        copy_csg_blk_crx_r(blk_crx,rbc_tmp);
        rbc_rot->s = NULL;
        blk_crx->s = NULL;

        /* Determine number of rotationas in  */
        /*  x-y and y-z plans respectively    */

        n_rot_xy = csg_num_rotation(iv,jv);
        n_rot_yz = csg_num_rotation(0,kv);

        /* Perform rotations */
        csg_rot_xy_r1(blk_crx,rbc_tmp,n_rot_xy);
        csg_rot_yz_r(rbc_tmp,rbc_rot,n_rot_yz);

        icrds = rbc_rot->icrds;
        crx1 = CSG_crx_in_kdir_r(rbc_rot,1,0);
        crx2 = CSG_crx_in_jdir_r(rbc_rot,0,1);
        crx3 = CSG_crx_in_idir_r(rbc_rot,1,0);
        crx4 = CSG_crx_in_kdir_r(rbc_rot,0,1);
        crx5 = CSG_crx_in_jdir_r(rbc_rot,1,0);
        crx6 = CSG_crx_in_idir_r(rbc_rot,0,1);

        if(crx1->csg_pt.crx->pt == NULL ||
               crx2->csg_pt.crx->pt == NULL ||
               crx3->csg_pt.crx->pt == NULL ||
               crx4->csg_pt.crx->pt == NULL ||
               crx5->csg_pt.crx->pt == NULL ||
               crx6->csg_pt.crx->pt == NULL)
        {
            printf("ERROR in rot_vortex_and_create_star_vol()\n");
            printf("One point is NULL\n");
            clean_up(ERROR);  
        }

        vol1 = 0.0;  
        s = creat_vol_for_corner_star_hexagon(blk_crx, crx1, crx2,crx3,crx4,
              crx5,crx6,icrds[0][1][0],icrds[0][0][1],icrds[0][0][0],icrds[1][0][0]);
        vol1 += tetrahedron_vol(crx1, crx2, crx3, icrds[1][0][0]);
        vol1 += pyramid_vol(crx1, icrds[1][0][0], icrds[0][1][0], crx4, crx3);
        vol1 += pyramid_vol(crx1, icrds[1][0][0], icrds[0][1][0], crx4, crx6);
        vol1 += pyramid_vol(crx5, crx4, icrds[0][1][0], icrds[0][0][0], crx6);
        vol1 += tetrahedron_vol(icrds[0][0][0], icrds[1][0][0], icrds[0][1][0], crx6);
        vol1 += tetrahedron_vol(icrds[0][0][0], icrds[0][0][1], crx6, crx5);
        s->vol = vol1;
        s->unset = NO;  

        s = creat_complement_vol_for_corner_star_hexagon(blk_crx,
              crx1, crx2,crx3,crx4,crx5,crx6,icrds[1][0][1],icrds[1][1][1],
              icrds[1][1][0],icrds[0][1][1]);
        s->vol = box_volume - vol1;
        s->unset = NO; 

        //printf("CSG_VOL: rot_vortex_and_create_star_vol() called\n");
        //print_csg_blk_crx(blk_crx);
}

LOCAL void rot_stem_and_create_twist_vol(
        int              i_stem,
        int              i1,
        int              i2,
        CSG_BLK_CRX      *blk_crx)
{
        COMPONENT ***comp_rot;
        COMPONENT pos_comp = blk_crx->pos_comp;
        COMPONENT neg_comp = blk_crx->neg_comp;
        COMPONENT min_comp = blk_crx->min_comp;
        static CSG_BLK_CRX_r    *bc_rot,*bc_tmp = NULL;
        CSG_POINT *crx1, *crx2, *crx3, *crx4, *crx5, *crx6;
        CSG_POINT        ****icrds;
        CSG_Solid    *s;
        float        vol1;

        if(bc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&bc_tmp);
            alloc_csg_blk_crx_r(&bc_rot);
        }
        copy_csg_blk_crx_r(blk_crx,bc_rot);
        copy_csg_blk_crx_r(blk_crx,bc_tmp);

        /* Rotate the stem to the z-axis */

        if (i_stem == 1)
        {
            int n_rot_yz = csg_num_rotation(i1,i2);
            int n_rot_zx = 3;
            csg_rot_yz_r1(blk_crx,bc_tmp,n_rot_yz);
            csg_rot_zx_r(bc_tmp,bc_rot,n_rot_zx);
        }
        else if (i_stem == 2)
        {
            int n_rot_zx = csg_num_rotation(i1,i2);
            int n_rot_yz = 1;
            csg_rot_zx_r1(blk_crx,bc_tmp,n_rot_zx);
            csg_rot_yz_r(bc_tmp,bc_rot,n_rot_yz);

        }
        else if (i_stem == 3)
        {
            int n_rot_xy = csg_num_rotation(i1,i2);
            csg_rot_xy_r1(blk_crx,bc_rot,n_rot_xy);
        }

        /* There are two possible twists */

        comp_rot = bc_rot->comp;
        if (
            (min_comp==pos_comp &&
             comp_rot[1][0][0]==min_comp &&
             comp_rot[0][1][1]==min_comp))
        {
            icrds = bc_rot->icrds;
            crx1 = CSG_crx_in_kdir_r(bc_rot,1,0);
            crx2 = CSG_crx_in_jdir_r(bc_rot,0,1);
            crx3 = CSG_crx_in_idir_r(bc_rot,1,1);
            crx4 = CSG_crx_in_kdir_r(bc_rot,0,1);
            crx5 = CSG_crx_in_jdir_r(bc_rot,0,0);
            crx6 = CSG_crx_in_idir_r(bc_rot,0,1);
            if(crx1->csg_pt.crx->pt == NULL ||
               crx2->csg_pt.crx->pt == NULL ||
               crx3->csg_pt.crx->pt == NULL ||
               crx4->csg_pt.crx->pt == NULL ||
               crx5->csg_pt.crx->pt == NULL ||
               crx6->csg_pt.crx->pt == NULL)
            {
                printf("ERROR rot_stem_and_create_twist_vol()\n");
                printf("One of the pt is NULL\n");
                clean_up(ERROR);  
            }

            vol1 = 0.0; 
            s = creat_vol_for_ij_twist1(blk_crx,crx1, crx2,crx3,crx4,
                crx5,crx6,icrds[0][0][0],icrds[1][0][0],icrds[0][0][1],
                icrds[0][1][1]);
            vol1 += pyramid_vol(icrds[0][0][1], icrds[0][1][1], crx3, crx6, crx4); 
            vol1 += pyramid_vol(icrds[0][0][1], crx4, crx5, icrds[0][0][0], crx6);
            vol1 += tetrahedron_vol(icrds[0][0][0], crx6, crx1, crx5);
            vol1 += pyramid_vol(icrds[0][0][0], crx5, crx2, icrds[1][0][0], crx1);
            s->vol = vol1;
            s->unset = NO; 

            s = creat_complement_vol_for_ij_twist1(blk_crx,crx1, crx2,crx3,crx4,
                crx5,crx6,icrds[0][1][0],icrds[1][1][0],icrds[1][1][1],
                icrds[1][0][1]);
            s->vol = box_volume - vol1;
            s->unset = NO;

            // printf("CSG_VOL: rot_stem_and_create_twist_vol() called\n");
            // print_csg_blk_crx(blk_crx);
            return;
        }
        else if(
            (min_comp==neg_comp &&
             comp_rot[1][0][0]==min_comp &&
             comp_rot[0][1][1]==min_comp))
        {
            print_csg_blk_crx(blk_crx);
            print_csg_blk_crx_r(bc_rot);
            printf("PORCESSING 2 rot_stem_and_create_twist_vol()"
                   " min_comp = %d pos_comp = %d, neg_comp = %d\n",
                   min_comp, pos_comp, neg_comp);
            clean_up(ERROR);
        }
        else
        {
            //   create_ji_twist(blk_bin);
            /*
            print_csg_blk_crx(blk_crx);
            print_csg_blk_crx_r(bc_rot);
            printf("PORCESSING 3 rot_stem_and_create_twist_vol()"
              " min_comp = %d pos_comp = %d, neg_comp = %d\n",
              min_comp, pos_comp, neg_comp);
            */
            icrds = bc_rot->icrds;
            crx1 = CSG_crx_in_kdir_r(bc_rot,1,0);
            crx2 = CSG_crx_in_idir_r(bc_rot,0,0);
            crx3 = CSG_crx_in_idir_r(bc_rot,1,0);
            crx4 = CSG_crx_in_kdir_r(bc_rot,0,1);
            crx5 = CSG_crx_in_jdir_r(bc_rot,1,0);
            crx6 = CSG_crx_in_jdir_r(bc_rot,1,1);
            if(crx1->csg_pt.crx->pt == NULL ||
               crx2->csg_pt.crx->pt == NULL ||
               crx3->csg_pt.crx->pt == NULL ||
               crx4->csg_pt.crx->pt == NULL ||
               crx5->csg_pt.crx->pt == NULL ||
               crx6->csg_pt.crx->pt == NULL)
            {
                printf("ERROR rot_stem_and_create_twist_vol()\n");
                printf("One of the pt is NULL 2\n");
                clean_up(ERROR);  
            }

            if(min_comp == pos_comp)
            {
                vol1 = 0.0;
                s = creat_vol_for_ji_twist1(blk_crx,crx1, crx2,crx3,crx4,
                      crx5,crx6,icrds[1][0][1],icrds[0][0][1],icrds[0][0][0],
                      icrds[0][1][0]);
                vol1 += pyramid_vol(icrds[0][0][0], icrds[0][1][0], crx3, crx2, icrds[0][0][1]);
                vol1 += pyramid_vol(icrds[0][0][1], icrds[0][1][0], crx4, crx5, crx3);
                vol1 += pyramid_vol(icrds[0][0][1], icrds[1][0][1], crx6, crx5, crx3);
                vol1 += tetrahedron_vol(crx5,crx4,crx3,crx6);
                vol1 += tetrahedron_vol(icrds[0][0][1], icrds[1][0][1], crx2, crx3);
                vol1 += tetrahedron_vol(icrds[1][0][1], crx1, crx2, crx3);
                vol1 += tetrahedron_vol(icrds[1][0][1], crx1, crx3, crx6);
                s->vol = vol1;
                s->unset = NO; 

                s = creat_complement_vol_for_ji_twist1(blk_crx,crx1, crx2,crx3,crx4,
                      crx5,crx6,icrds[0][1][1],icrds[1][1][1],icrds[1][1][0],
                      icrds[1][0][0]);
                s->vol = box_volume - vol1;
                s->unset = NO;

                // printf("CSG_VOL: rot_stem_and_create_twist_vol() called\n");
                // print_csg_blk_crx(blk_crx);
                return;
            }
            else
            {
                print_csg_blk_crx_r(bc_rot);
                printf("PORCESSING rot_stem_and_create_twist_vol() 2\n");
            }
            clean_up(ERROR);
        }

        print_csg_blk_crx_r(bc_rot);
        printf("PORCESSING rot_stem_and_create_twist_vol()\n");
        clean_up(ERROR);
}

LOCAL void rot_line_and_create_float_vol_4(
        int              i_line,
        int              i1,
        int              i2,
        CSG_BLK_CRX      *blk_crx,
        TRI_GRID         *new_ntg,
        TRI_GRID         *old_ntg)
{
        COMPONENT ***comp_rot;
        COMPONENT pos_comp = blk_crx->pos_comp;
        COMPONENT neg_comp = blk_crx->neg_comp;
        COMPONENT min_comp = blk_crx->min_comp;
        static CSG_BLK_CRX_r    *bc_rot,*bc_tmp = NULL;
        CSG_POINT *crx1, *crx2, *crx3, *crx4, *crx5, *crx6, *crx7, *crx8;
        CSG_POINT        ****icrds;
        int              ic[MAXD];
        CSG_Solid        *s;
        float            vol1, vol2; 

        if(bc_tmp == NULL)
        {
            alloc_csg_blk_crx_r(&bc_tmp);
            alloc_csg_blk_crx_r(&bc_rot);
        }
        copy_csg_blk_crx_r(blk_crx,bc_rot);
        copy_csg_blk_crx_r(blk_crx,bc_tmp);

        /* Rotate the line to the z-axis */

        if (i_line == 1)
        {
            int n_rot_yz = csg_num_rotation(i1,i2);
            int n_rot_zx = 3;
            csg_rot_yz_r1(blk_crx,bc_tmp,n_rot_yz);
            csg_rot_zx_r(bc_tmp,bc_rot,n_rot_zx);
        }
        else if (i_line == 2)
        {
            int n_rot_zx = csg_num_rotation(i1,i2);
            int n_rot_yz = 1;
            csg_rot_zx_r1(blk_crx,bc_tmp,n_rot_zx);
            csg_rot_yz_r(bc_tmp,bc_rot,n_rot_yz);

        }
        else if (i_line == 3)
        {

            int n_rot_xy = csg_num_rotation(i1,i2);
            csg_rot_xy_r1(blk_crx,bc_rot,n_rot_xy);
        }

        icrds = bc_rot->icrds;
        comp_rot = bc_rot->comp;

        ic[0] = blk_crx->icrds[0][0][0].csg_pt.icrds[0];
        ic[1] = blk_crx->icrds[0][0][0].csg_pt.icrds[1];
        if(min_comp == comp_rot[0][0][0] && min_comp == comp_rot[0][0][1] &&
           min_comp == comp_rot[1][1][0] && min_comp == comp_rot[1][1][1])
        {
            if(comp_rot[0][0][0] == Regular_grid_comp(ic, new_ntg))
            {
                if(comp_rot[0][0][0] != comp_rot[0][0][1] ||
                   comp_rot[0][0][0] != comp_rot[1][1][0] ||
                   comp_rot[0][0][0] != comp_rot[1][1][1])
                {
                    print_csg_blk_crx_r(bc_rot);
                    print_csg_blk_crx(blk_crx);
                    printf("min_comp = %d\n", min_comp);
                    printf("ERROR case IN rot_line_and_create_float_vol_4()\n");
                    clean_up(ERROR);
                }
                crx1 = CSG_crx_in_jdir_r(bc_rot,0,1);
                crx2 = CSG_crx_in_jdir_r(bc_rot,1,1);
                crx3 = CSG_crx_in_idir_r(bc_rot,0,1);
                crx4 = CSG_crx_in_idir_r(bc_rot,0,0);
                crx5 = CSG_crx_in_idir_r(bc_rot,1,0);
                crx6 = CSG_crx_in_idir_r(bc_rot,1,1);
                crx7 = CSG_crx_in_jdir_r(bc_rot,1,0);
                crx8 = CSG_crx_in_jdir_r(bc_rot,0,0);
                vol1 = vol2 = 0.0;
                s = creat_vol_for_edge_case_angl2(blk_crx,
                       icrds[0][1][1], crx6, crx5,
                       icrds[0][1][0], crx8, crx7);
                vol1 += pyramid_vol(icrds[0][1][1], icrds[0][1][0], crx8, crx7, crx5);
                vol1 += tetrahedron_vol(icrds[0][1][1], crx6, crx7, crx5);
                s->vol = vol1;
                s->unset = NO;

                s = creat_vol_for_edge_case_angl2(blk_crx,
                       icrds[1][0][1], crx3, crx4,
                       icrds[1][0][0], crx1, crx2);
                vol2 += pyramid_vol(icrds[1][0][1], icrds[1][0][0], crx1, crx2, crx4);
                vol2 += tetrahedron_vol(icrds[1][0][1], crx3, crx2, crx4);
                s->vol = vol2;
                s->unset = NO;

                s = create_vol_for_plan_float_vol(blk_crx,
                      crx1,crx2,crx3,crx4,crx5,crx6,crx7,crx8,icrds[1][1][0],
                      icrds[1][1][1],icrds[0][0][0],icrds[0][0][1]);
                s->vol = box_volume - vol1 - vol2;
                s->unset = NO; 
            }
            else
            {
                if(comp_rot[1][0][0] != Regular_grid_comp(ic, new_ntg))
                {
                    print_csg_blk_crx_r(bc_rot);
                    printf("min_comp = %d\n", min_comp);
                    printf("ERROR IN rot_line_and_create_float_vol_4(),"
                        " unknown plane case 3\n");
                    print_csg_blk_crx(blk_crx);
                    clean_up(ERROR);
                }
                crx1 = CSG_crx_in_idir_r(bc_rot,0,0);
                crx2 = CSG_crx_in_idir_r(bc_rot,0,1);
                crx3 = CSG_crx_in_jdir_r(bc_rot,1,0);
                crx4 = CSG_crx_in_jdir_r(bc_rot,0,0);
                crx5 = CSG_crx_in_jdir_r(bc_rot,0,1);
                crx6 = CSG_crx_in_jdir_r(bc_rot,1,1);
                crx7 = CSG_crx_in_idir_r(bc_rot,1,1);
                crx8 = CSG_crx_in_idir_r(bc_rot,1,0);

                vol1 = vol2 = 0.0;
                s = creat_vol_for_edge_case_angl2(blk_crx,
                       icrds[1][1][1], crx6, crx5,
                       icrds[1][1][0], crx8, crx7);
                vol1 += pyramid_vol(icrds[1][1][1], icrds[1][1][0], crx8, crx7, crx5);
                vol1 += tetrahedron_vol(icrds[1][1][1], crx6, crx7, crx5);
                s->vol = vol1;
                s->unset = NO;
 
                s = creat_vol_for_edge_case_angl2(blk_crx,
                       icrds[0][0][1], crx3, crx4,
                       icrds[0][0][0], crx1, crx2);
                vol2 += pyramid_vol(icrds[0][0][1], icrds[0][0][0], crx1, crx2, crx4);
                vol2 += tetrahedron_vol(icrds[0][0][1], crx3, crx2, crx4);
                s->vol = vol2;
                s->unset = NO;

                s = create_vol_for_plan_float_vol(blk_crx,
                      crx1,crx2,crx3,crx4,crx5,crx6,crx7,crx8,icrds[1][0][0],
                      icrds[1][0][1],icrds[0][1][0],icrds[0][1][1]);
                s->vol = box_volume - vol1 - vol2;
                s->unset = NO;
            }
        }
        else
        {
            print_csg_blk_crx_r(bc_rot);
            printf("min_comp = %d\n", min_comp);
            printf("ERROR IN rot_line_and_create_float_vol_4(), unknown plane case\n");
            print_csg_blk_crx(blk_crx);
            clean_up(ERROR);
        }
}

LOCAL int set_irregular_blk(
        int        *icrds,
        TRI_GRID   *new_ntg,
        TRI_GRID   *old_ntg,
        CSG_BLK_CRX  **blk_crx,
        CRXING       **crx[], 
        int          *nc, 
        int          layer)
{

        int        i, j;

        printf("ERROR: CSG_blk_on_front, set_irregular_blk, ic[%d,%d]\n", 
               icrds[0], icrds[1]);
        printf("crxings (1) nc[0,1,2,3] = [%d,%d,%d,%d]\n",
          nc[0], nc[1], nc[2], nc[3]);
        
        for(i = 0; i < 4; i++)
        {
            if(nc[i] != 0)
            {
                for(j = 0; j < nc[i]; j++)
                    print_crxings(crx[i][j], NO);
            }
        }        
        return NO;  
}

LOCAL COMPONENT solid_comp(
        CSG_Solid       *s,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg)
{
        CSG_Vertex      *v;
        int             icrds[MAXD+1];

        v = s->sverts;
        while(v)
        {
            if(v->pt->type == IS_ICRDS)
            {
                icrds[0] = v->pt->csg_pt.icrds[0];
                icrds[1] = v->pt->csg_pt.icrds[1];
                icrds[2] = v->pt->csg_pt.icrds[2];
                if(icrds[2] == 1)
                {
                    return Regular_comp_grid_comp(icrds, new_ntg);
                }
                else
                   return Regular_comp_grid_comp(icrds, old_ntg);
            }
            v = v->nextv;
        }
        printf("ERROR: In solid_comp()\n");
        printf("No COMPONENT found\n");
        solidls(s,2);
        clean_up(ERROR);
}

LOCAL void set_vol_face_par( 
        CSG_BLK_CRX     *blk_crx,
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        float           dt)
{
        CSG_Solid       *s, *root;
        CSG_Face        *f, *statf = NULL;
        CSG_Loop        *l;
        CSG_HalfEdge    *he;
        int             where, num_v;

        s = blk_crx->s;
        if(dt == 0.0)
            dt = old_ntg->comp_grid.h[0];
        if(s == NULL)
        {
            printf("ERROR: In set_vol_face_par(),NULL Vol\n");
            clean_up(ERROR);
        }

        while(s)
        {
            memcpy(s->icrds, blk_crx->icrds[0][0][0].csg_pt.icrds,
                          sizeof(int)*2);
            s->comp = solid_comp(s, new_ntg, old_ntg);
            s->blk = blk_crx;
            s->btm_st = NULL;
            s->top_st = NULL;
            s->n_btm = 0;
            s->n_top = 0;
            s->debug = NO;
            s->merged = NO; 

            if(s->unset == YES)
            {
                printf("ERROR set_vol_face_par, s volume not set\n");
                solidls(s, 2);
                clean_up(ERROR); 
            }

            f = s->sfaces;
            while(f)
            {
                // f->i_stat = f->o_stat = NULL;
                f->i_stat = NULL;
                l = f->floops;
                if(ERROR == faceeq(l, f->face_eqn, new_ntg, dt))
                {
                    clean_up(ERROR);
                }
                f->area = larea(l, f->face_eqn, new_ntg, dt);
                polygon_centroid_3d(l); 
                f->comp = s->comp;
                f = f->nextf;
            }
            s = s->nexts;
        }
}


/* tetrahedron with vertices (a, b, c, d)
 *  volume = 1/6|ab, ac, ad|
 */
LOCAL float tetrahedron_vol(
        CSG_POINT       *v1,
        CSG_POINT       *v2,
        CSG_POINT       *v3,
        CSG_POINT       *v4)
{
        float  p1[3], p2[3], p3[3], p4[3]; 
        float  x21, x31, x41;         
        float  y21, y31, y41;         
        float  z21, z31, z41;         
        float vol = 0.0; 

        CSG_point_Coord(v1, p1);
        CSG_point_Coord(v2, p2);
        CSG_point_Coord(v3, p3);
        CSG_point_Coord(v4, p4);

        x21 = p2[0] - p1[0]; 
        y21 = p2[1] - p1[1]; 
        z21 = p2[2] - p1[2]; 

        x31 = p3[0] - p1[0]; 
        y31 = p3[1] - p1[1]; 
        z31 = p3[2] - p1[2]; 

        x41 = p4[0] - p1[0]; 
        y41 = p4[1] - p1[1]; 
        z41 = p4[2] - p1[2]; 

        vol = x21*y31*z41 + x31*y41*z21 + x41*y21*z31 - 
              z21*y31*x41 - y21*x31*z41 - x21*y41*z31; 

        return fabs(vol)/6.0; 
}

/* Note : v1->v2-> v3->v4->v1 are the base plane
 * of the pyramid, can be none-coplanar.
 */
LOCAL float pyramid_vol(
        CSG_POINT       *v1,
        CSG_POINT       *v2,
        CSG_POINT       *v3,
        CSG_POINT       *v4,
        CSG_POINT       *v5)
{
        return (tetrahedron_vol(v1, v2, v3, v5) +
                tetrahedron_vol(v1, v3, v4, v5)); 
}


#endif /* if defined(TWOD) && defined(CONSERVATIVE_ALG) */
