/*
*				userint.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*			User Supplied Operations
*/

#if !defined(_USERINT_H)
#define _USERINT_H

#include <intfc/int.h>

struct _I_USER_INTERFACE {

	/* Sizes of interface data structures */
	size_t	size_interface;
	size_t	size_point;
	size_t	size_bond;
	size_t	size_curve;
	size_t	size_node;
#if defined(THREED)
	size_t	size_bond_tri;
	size_t	size_tri;
	size_t	size_surface;
#endif /* defined(THREED) */
	size_t	size_hyper_surf;
	size_t	size_hyper_surf_element;
	size_t	size_hyper_surf_bdry;
	size_t	size_o_node;

	/* Variables for interface store*/
	size_t	_ChunkSize;

	/* Dimensionally dependent functions for topology indentification */

 	/* nearest_interface_point() */
	bool	(*_nip)(float*,COMPONENT,INTERFACE*,USE_BOUNDARIES,HYPER_SURF*,
			float*,float*,HYPER_SURF_ELEMENT**,HYPER_SURF**);

	/* long_nearest_interface_point() */
	bool	(*_lnip)(float*,COMPONENT,INTERFACE*,USE_BOUNDARIES,HYPER_SURF*,
			 float*,float*,HYPER_SURF_ELEMENT**,HYPER_SURF**);

	/* nearest_similar_interface_point() */
	bool	(*_nsip)(float*,COMPONENT,COMPONENT,INTERFACE*,USE_BOUNDARIES,
			 HYPER_SURF*,float*,float*,HYPER_SURF_ELEMENT**,
			 HYPER_SURF**);

	/* long_nearest_similar_interface_point() */
	bool	(*_lnsip)(float*,COMPONENT,COMPONENT,struct _INTERFACE*,
			  USE_BOUNDARIES,HYPER_SURF*,float*,float*,
			  HYPER_SURF_ELEMENT**,HYPER_SURF**);

	/* Dimensionally dependent functions for interface element looping */

	bool	(*_next_point)(struct _INTERFACE*,POINT**,
			       HYPER_SURF_ELEMENT**,HYPER_SURF**);
	bool	(*_next_hypersurface)(struct _INTERFACE*,HYPER_SURF**);

	/* Functions used for I/O of boundary type data */

	int	(*_read_boundary_type_from_string)(const char*);
	void	(*_fprint_boundary_type)(FILE*,const char*,int,const char*,
	                                 struct _INTERFACE*);

	/* User defined hooks to interface utility functions */

	/* Interface utility functions */
	void	(*_user_make_interface)(INTERFACE*);
	INTERFACE	*(*_copy_interface)(INTERFACE*);
	int	(*_user_read_print_interface)(INIT_DATA*,const IO_TYPE*,
	                                      INTERFACE*,bool);
	void	(*_fprint_interface)(FILE*,INTERFACE*);
#if defined(THREED)
	void	(*_gview_plot_interface)(const char*,INTERFACE*);
#endif /* defined(THREED) */
	void	(*_user_fprint_interface)(FILE*,INTERFACE*);
	int	(*_delete_interface)(INTERFACE*);

	/* Hypersurface utility functions */
	HYPER_SURF	*(*_make_hypersurface)(COMPONENT,COMPONENT);
	void		(*_user_copy_hyper_surf)(HYPER_SURF*,HYPER_SURF*);

	/* Hypersurface boundary utility functions */
	HYPER_SURF_BDRY	*(*_make_hypersurface_boundary)(void);

	/* Node utility functions */
	NODE	*(*_make_node)(POINT*);
	NODE	*(*_copy_node)(NODE*);
	bool	(*_delete_node)(NODE*);
	void	(*_fprint_node)(FILE*,NODE*);
	void	(*_user_fprint_node)(FILE*,NODE*);
	NODE	*(*_read_node)(INTERFACE*,int);
	int	(*_user_read_node)(NODE*);
	void	(*_user_read_print_node)(NODE*,const IO_TYPE*,bool);

	/* Rect grid utility functions */
		/*Writing*/
	void	(*_fprint_intfc_rect_grids)(FILE*,INTERFACE*);
	void	(*_user_fprint_intfc_rect_grids)(FILE*,INTERFACE*);
		/*Reading*/
	int	(*_read_print_intfc_rect_grids)(const IO_TYPE*,INTERFACE*,
	                                        REMAP*);
	void	(*_user_read_print_intfc_rect_grids)(const IO_TYPE*,INTERFACE*,
						     bool,REMAP*);

	/* Curve utility functions */
	CURVE	*(*_make_curve)(COMPONENT,COMPONENT,NODE*,NODE*);
	CURVE	*(*_copy_curve)(CURVE*,NODE*,NODE*);
	int	(*_delete_curve)(CURVE*);
	void	(*_fprint_curve)(FILE*,CURVE*);
	void	(*_user_fprint_curve)(FILE*,CURVE*);
	CURVE	*(*_read_curve)(INTERFACE*,int);
	void	(*_user_read_curve)(CURVE*);
	bool	(*_user_read_print_curve)(CURVE*,const IO_TYPE*,bool);
	bool	(*_user_split_curve)(int,POINT*,BOND*,CURVE*,CURVE**);
	bool	(*_user_join_curves)(CURVE*,CURVE*,CURVE*);

	/* Bond utilities */
	BOND	*(*_Bond)(POINT*,POINT*);
#if defined(THREED)
	BOND_TRI *(*_link_tri_to_bond)(BOND_TRI*,TRI*,SURFACE*,BOND*,CURVE*);
	void 	(*_reverse_bond)(BOND*);
	void 	(*_reorder_curve_link_list)(CURVE*);
#endif /* defined(THREED) */

	/* Point utility functions */
	POINT	*(*_Point)(float*);
	POINT	*(*_Static_point)(INTERFACE*);
	POINT	*(*_copy_point)(POINT*);
	POINT   *(*_average_points)(bool,POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
		                         POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*);
#if defined(ONED)
	POINT	*(*_make_point)(float*,COMPONENT,COMPONENT);
	int	(*_delete_point)(POINT*);
	void	(*_fprint_point)(FILE*,POINT*);
	void	(*_user_fprint_point)(FILE*,POINT*);
	POINT	*(*_read_point)(INTERFACE*,int);
	void	(*_user_read_point)(INTERFACE*,POINT*);
	POINT	*(*_read_print_point)(INTERFACE*,const IO_TYPE*,bool);
	void	(*_user_read_print_point)(POINT*,const IO_TYPE*,bool);
#endif /* defined(ONED) */
	bool	(*_insert_point_in_bond)(POINT*,BOND*,CURVE*);
	bool	(*_delete_start_of_bond)(BOND*,CURVE*);
	bool	(*_delete_end_of_bond)(BOND*,CURVE*);
#if defined(THREED)
	SURFACE *(*_join_surfaces)(CURVE*);
	bool	(*_insert_point_in_tri)(POINT*,TRI*,SURFACE*);
	bool	(*_insert_point_in_tri_side)(POINT*,int,TRI*,SURFACE*);
	bool	(*_undo_insert_point_in_tri)(POINT*,TRI*,SURFACE*);
	bool	(*_undo_insert_point_in_tri_side)(POINT*,int,TRI*,SURFACE*);
#endif /* defined(THREED) */

#if defined(THREED)
	/* Tri utility functions */
	TRI *(*_make_tri)(POINT*,POINT*,POINT*,
			  POINTER,POINTER,POINTER,int);

	/* Surface utility functions */
	SURFACE	*(*_make_surface)(COMPONENT,COMPONENT,CURVE**,CURVE**);
	SURFACE	*(*_copy_surface)(SURFACE*,CURVE**,CURVE**,bool);
	int	(*_delete_surface)(SURFACE*);
	void	(*_fprint_surface)(FILE*,SURFACE*);
	void	(*_user_fprint_surface)(FILE*,SURFACE*);
	SURFACE	*(*_read_surface)(INTERFACE*,int);
	void	(*_user_read_surface)(SURFACE*);
	void	(*_user_read_print_surface)(SURFACE*,const IO_TYPE*,bool);

	/* C_BOND utility functions */
	C_BOND *(*_CBond)(C_BOND*,POINT*,POINT*,TRI*,TRI*);
	bool	(*_sort_bond_tris)(INTERFACE*);
#endif /* defined(THREED) */

	/* Parallel communication utilities */
	void	(*_send_interface)(INTERFACE*,int);
	INTERFACE	*(*_receive_interface)(int);
	void	(*_reconstruct_interface_pointers)(INTERFACE*,struct Table*,
						   POINTER*,POINTER*);
	void	(*_reconstruct_point_pointers)(POINT*,INTERFACE*,INTERFACE*,
					       POINTER*,POINTER*,int);
	void	(*_reconstruct_node_pointers)(NODE*,INTERFACE*,INTERFACE*,
					      POINTER*,POINTER*,int);
	void	(*_reconstruct_bond_pointers)(BOND*,INTERFACE*,INTERFACE*,
					      POINTER*,POINTER*,int);
	void	(*_reconstruct_curve_pointers)(CURVE*,INTERFACE*,INTERFACE*,
					       POINTER*,POINTER*,int);
#if defined(USE_OVERTURE) && defined(__MPI__)
        /* NON-BLOCKING TYPE COMMUNICATION */
        void    (*_isend_interface)(INTERFACE*,int,int,MPI_Request**,POINTER**);
        INTERFACE       *(*_ireceive_interface)(int,int,MPI_Request**,POINTER**,
                              POINTER**,struct Table**);

        void    (*_isend_intfc_table)(INTERFACE*,int,int,MPI_Request*);
        struct Table  *(*_irecv_intfc_table)(int,int,MPI_Request*);
        void    (*_isend_intfc_chunks)(INTERFACE*,int,int,MPI_Request**,POINTER**);
        INTERFACE *(*_irecv_intfc_chunks)(struct Table*,int,int,MPI_Request**,
                              POINTER**,POINTER**);
#endif /* if defined(USE_OVERTURE) && defined(__MPI__) */
#if defined(THREED)
	void	(*_reconstruct_surface_pointers)(SURFACE*,INTERFACE*,
						 INTERFACE*,POINTER*,
						 POINTER*,int);
	void	(*_reconstruct_tri_pointers)(TRI*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
#endif /* defined(THREED) */

	bool	(*_set_boundary)(INTERFACE*,RECT_GRID*,COMPONENT,float);
#if defined(THREED)
	void	(*_user_install_faces)(SURFACE*,int);
	void	(*_assign_curve_boundary_flag)(CURVE*);
#endif /* defined(THREED) */

	bool	(*_intersections)(INTERFACE*,CROSS**,const bool);
	float   (*_cross_tolerance)(INTERFACE*);
	void	(*_print_intersections)(CROSS*,INTERFACE*);
	int	(*_print_number_of_tangles)(const char*,INTERFACE*,CROSS*);
	void	(*_print_crossing_elements)(CROSS*,INTERFACE*);

	CURVE	*(*_attach_curve_to_node)(CURVE*,POINT*,BOND*,NODE*);
	void	(*_invert_curve)(CURVE*);
	void	(*_reverse_curve)(CURVE*);
	bool	(*_move_closed_loop_node)(CURVE*,BOND*);
	bool	(*_is_subdomain_boundary)(HYPER_SURF*);
	bool	(*_is_subdomain_node)(NODE*);
	bool	(*_is_virtual_fixed_node)(NODE*);
	void	(*_fset_hyper_surf_color)(FILE*,HYPER_SURF*);
	INTERFACE	*(*_zoom_interface)(INTERFACE*,RECT_GRID*,
					    float*,float*,float**);
	void	(*_reflect_interface)(INTERFACE*,float*,float*);
#if defined(THREED)
	void	(*_reflect_surface)(SURFACE*,float*,float*);
#endif /* defined(THREED) */
	void	(*_reflect_curve)(CURVE*,float*,float*);
	void	(*_reflect_node)(NODE*,float*,float*);
	void	(*_reflect_point)(POINT*,float*,float*,INTERFACE*);
	bool	(*_make_interface_topology_lists)(INTERFACE*);

	float	(*_random01)(INTERFACE*);
	unsigned short int _random01_seed[3];

	COMP_LIST	_excluded_comps;

	/* Debugging utilities */
#if defined(THREED)
	bool	(*_consistent_interface)(INTERFACE*);
#endif /* defined(THREED) */

	struct _I_INTERFACE_TOLERANCES {
		float	_Parallel;
		float   _Min_sin_sqr;
		float	_MinScaledSeparation;
		float	_MinScaledLength;
		float   _EndOfCurve;
		float   _StartOfCurve;
		float   _RcbMinScaledSep;
		float   _RobustFac;
		float   _RcbMacTol;
		float   _RcbcRobustFac;
		float   _ReflectTol;
		float   _TolFac;
		int	_ShortCurveNumPoints;
	} _InterfaceTolerances;
};
typedef struct _I_USER_INTERFACE I_USER_INTERFACE;
#if defined(__cplusplus)
typedef I_USER_INTERFACE::_I_INTERFACE_TOLERANCES I_INTERFACE_TOLERANCES;
#else /* defined(__cplusplus) */
typedef struct _I_INTERFACE_TOLERANCES I_INTERFACE_TOLERANCES;
#endif /* defined(__cplusplus) */

struct _I_INTERFACE {
	INTERFACE Intfc;
	I_USER_INTERFACE I_user_intfc;
};
typedef struct _I_INTERFACE I_INTERFACE;

#define	i_interface(intfc)	((I_INTERFACE*) (intfc))
#define	i_user_interface(intfc)	(i_interface(intfc)->I_user_intfc)

#define	ChunkSize(intfc)	(i_user_interface(intfc)._ChunkSize)
#define	InterfaceTolerances(intfc)	(i_user_interface(intfc)._InterfaceTolerances)
#define PARALLEL(intfc)		InterfaceTolerances(intfc)._Parallel
#define MIN_SIN_SQR(intfc)	InterfaceTolerances(intfc)._Min_sin_sqr
#define MIN_SC_SEP(intfc)	InterfaceTolerances(intfc)._MinScaledSeparation
#define MIN_SCALED_LENGTH(intfc) InterfaceTolerances(intfc)._MinScaledLength
#define END_OF_CURVE(intfc)	InterfaceTolerances(intfc)._EndOfCurve
#define START_OF_CURVE(intfc)	InterfaceTolerances(intfc)._StartOfCurve
#define TOL_FAC(intfc)		InterfaceTolerances(intfc)._TolFac
#define RCB_MIN_SC_SEP(intfc)	InterfaceTolerances(intfc)._RcbMinScaledSep
#define ROBUST_FAC(intfc)	InterfaceTolerances(intfc)._RobustFac
#define RCB_MACH_TOL(intfc)	InterfaceTolerances(intfc)._RcbMacTol
#define RCBC_ROBUST_FAC(intfc)	InterfaceTolerances(intfc)._RcbcRobustFac
#define RTOL(intfc)		InterfaceTolerances(intfc)._ReflectTol
#define SHORT_CURVE_NUM_POINTS(intfc)					\
				InterfaceTolerances(intfc)._ShortCurveNumPoints
#define	excluded_comps(intfc)	(i_user_interface(intfc)._excluded_comps)
#define	Random01_seed(intfc)	i_user_interface(intfc)._random01_seed

enum _PRESERVE_USER_HOOKS {
	SAVE_HOOKS,
	RESTORE_HOOKS
};
typedef enum _PRESERVE_USER_HOOKS PRESERVE_USER_HOOKS;

#endif /* !defined(_USERINT_H) */
