/*
*
*                                   map.c
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       This file contains functions that convert topological structure
*       into formats that can be used as input of various programs for
*       generating 3D graphical images of the interface structures.
*
*       TODO:
*/

#if defined(THREED)

#include <intfc/iloc.h>


/*
*                       is_interior_vertex():
*
*       Given a point and a tri, this function tests whether
*       the point p is interior (not on a curve) to the
*       surface by testing if there is a set of tris
*       that surrounds p and yet each bond that has p
*       as a end is not on the boundary. *t_begin is set
*       to the tri that last was tested.
*/

LIB_LOCAL bool is_interior_vertex(
	TRI       *t,
	POINT     *p,
	TRI       **t_begin,
	INTERFACE *intfc)
{
	TRI		*tri = t;
	int		i, j;
	static int	max_loops = 100; /*TOLERANCE*/

	if (!Boundary_point(p))
	{
	    *t_begin = tri;
	    return YES;
	}
	for (j = 0, tri = t; j < max_loops && tri != NULL; j++)
	{
	    for (i = 0; i < 3; i++)
	    {
	    	if (p == Point_of_tri(tri)[i])
	    	{
	    	    if (is_side_bdry(tri,i))
	    	    {
	    	    	*t_begin = tri;
	    	    	return NO;
	    	    }
	    	    *t_begin = tri;
	    	    tri = Tri_on_side(tri,i);
	    	    if (tri == t)
			return YES;
	    	    break;
	    	}
	    }

	    if (i == 3)
	    {
	       (void) printf("ERROR in is_interior_vertex(), ");
	       (void) printf("point (%llu) = (%g %g %g) is not on tri (%llu)\n",
	    	             point_number(p),
	    	             Coords(p)[0], Coords(p)[1], Coords(p)[2],
	    	             tri_number(tri,current_interface()));
	       print_tri(tri,intfc);
	       clean_up(ERROR);
	       return NO;
	    }
	}
	(void) printf("ERROR in is_interior_vertex()\n"
	              "Probably infinite loop at vertex point ");
	(void) printf("(%llu) = (%g %g %g)\n", point_number(p),
	       Coords(p)[0], Coords(p)[1], Coords(p)[2]);
	clean_up(ERROR);
	return NO;
}		/*end is_interior_vertex*/

#endif /* defined(THREED) */
