#if !defined(_INT_AMR_H)
#define _INT_AMR_H

#include <intfc/int.h>

#if defined(USE_OVERTURE) 

/* FOR AMR,  Overture init params */
/*Overture init params */
struct _OVERPARAM {
        float   errorThreshold;
        float   efficiency;
        int     numberOfSmooths;
        int     period;
        int     baseLevel;
        int     numberOfRefinementLevels;
        int     refinementRatio;
        int     extra_buf;
        int     splitpatch;
        int     splitgmax[MAXD];
};
typedef struct _OVERPARAM Overparam;

struct _PATCH_BDRY_FLAG{
        int             patch_bdry;
        int             bdry[3];
        int             bdry_side[3][2];
};
typedef struct _PATCH_BDRY_FLAG Patch_bdry_flag;

struct _Trans_box{
      int     on_item[2];      /* This rect.is from table item */
      int     from_item[2];    /* Could obtain from this table item */
      int     to_item[2];      /* Could be sent to this table item */
      int     base[MAXD];      /* The base and bound in the ralative (on_item) coords. */
      int     bound[MAXD];     /* For front buf send, the base and bound is in the to_item coords */
};
typedef struct _Trans_box Trans_box;

struct _Rect_ComponentGrid{
        int      grid_id;     /* patch grid id */
        int      grid_level;  /* patch grid level */
        int      base[MAXD];  /* grid location index on subdomain */
        int      bound[MAXD]; /* grid location index on subdomain */
        int      lbuf[MAXD];
        int      ubuf[MAXD];
        int      off_set[MAXD]; /* location of index[0,0] offset  */
        int      dim;
        float    L[MAXD];       /* Lower corner of grid */
        float    U[MAXD];       /* Upper corner of grid */
        float    h[MAXD];       /* Grid Spaceing */
};
typedef struct _Rect_ComponentGrid Rect_ComponentGrid;

struct _Rect_ComponentGrid_Collection{
        int      pc_id;       /* the parallel proc id */
        int      dim;
        int      baseLevel;
        int      numberOfRefinementLevels;
        int      numberOfComponentGrids;
        Rect_ComponentGrid   *rect_componentgrids;
};
typedef struct _Rect_ComponentGrid_Collection Rect_ComponentGrid_Collection;

#endif /* defined(USE_OVERTURE) */
#endif /* #if !defined(_INT_AMR_H) */  
