/*
*				hintfc.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if defined(THREED) || defined(TWOD)

#define DEBUG_STRING "hintfc"

#include <hyp/hdecs.h>

#if defined(TWOD) 
LOCAL INTERFACE *h_reconstruct_front_at_grid_crossing2d(Front*,Front*,int);
#endif /* if defined(TWOD) */

/*
*		h_reconstruct_front_at_grid_crossing()
*/

EXPORT	bool h_reconstruct_front_at_grid_crossing(
	Front *front,
        Front *oldfr, 
        int   which_grid)
{
	Wave		*wave = wave_of_front(front);
	INTERFACE	*intfc;
	RECT_GRID	Dual_grid, *comp_grid = wave->rect_grid;
	
	DEBUG_ENTER(h_reconstruct_front_at_grid_crossing)

	set_dual_grid(&Dual_grid,comp_grid);

        switch (comp_grid->dim)
        {
        case 2:
            intfc = h_reconstruct_front_at_grid_crossing2d(front, 
                         oldfr, which_grid); 
        break;
        case 3:
	    intfc = rebuild_intfc_at_crossings3d(
                       wave_tri_soln(wave)->tri_grid,&Dual_grid,front);
        break;
        }

	if (intfc == NULL)
	{
	    (void) printf("WARNING in h_reconstruct_front_at_grid_crossing(), "
		          "in h_rebuild_intfc_at_crossing() returns NULL\n");
	    return NO;
	}
	else
	    front->interf = intfc;
	interface_reconstructed(front->interf) = YES;

#if defined(THREED)
	if (DEBUG && !consistent_interface(front->interf) 
            && comp_grid->dim == 3)
	{
	    screen("ERROR in h_reconstruct_front_at_grid_crossing(), "
		   "the reconstructed interface is inconsistent\n");
	    clean_up(ERROR);
	}
#endif /* if defined(THREED) */
	DEBUG_LEAVE(h_reconstruct_front_at_grid_crossing)
	return YES;
}	/*end h_reconstruct_front_at_grid_crossing*/

#if defined(THREED)
EXPORT  bool h_repair_front_at_grid_crossing(
        Front *front)
{
        Wave            *wave = wave_of_front(front);
        INTERFACE       *intfc;
        RECT_GRID       Dual_grid, *comp_grid = wave->rect_grid;

        DEBUG_ENTER(h_repair_front_at_grid_crossing)

        if (comp_grid->dim != 3)
        {
            (void) printf("WARNING in h_repair_front_at_grid_crossing(), "
                          "dim = %d != 3 not supported\n",
                          comp_grid->dim);
            return NO;
        }

        if (wave_tri_soln(wave) == NULL)
            return YES;
        set_dual_grid(&Dual_grid,comp_grid);

        intfc = repair_intfc_at_crossings3d(wave_tri_soln(wave)->tri_grid,
                                           &Dual_grid,front);

        if (intfc == NULL)
        {
            (void) printf("WARNING in h_repair_front_at_grid_crossing(), "
                          "rebuild_intfc_at_crossings3d() returns NULL\n");
            return NO;
        }
        else
            front->interf = intfc;
        interface_reconstructed(front->interf) = NO;
        if (DEBUG && !consistent_interface(front->interf))
        {
            screen("ERROR in h_repair_front_at_grid_crossing(), "
                   "the repair interface is inconsistent\n");
            clean_up(ERROR);
        }
        DEBUG_LEAVE(h_repair_front_at_grid_crossing)
        return YES;
}       /*end h_repair_front_at_grid_crossing*/
#endif /* if defined(THREED) */

#if defined(TWOD) 
LOCAL	INTERFACE *h_reconstruct_front_at_grid_crossing2d(
	Front *front,
	Front *oldfr,
        int   which_grid)
{
	Wave		*wave = wave_of_front(front);
        TRI_GRID        *new_ntg; 
	RECT_GRID	Dual_grid, *comp_grid = wave->rect_grid;
        RECT_GRID       *expanded_dual_grid, *top_grid;
        int             status; 
	
	DEBUG_ENTER(h_reconstruct_front_at_grid_crossing2d)

	set_dual_grid(&Dual_grid,comp_grid);
        
        /* Can not delete. If so, the interface is not closed.
        delete_subdomain_curves(front->interf);
        delete_passive_boundaries(front->interf);
        */

#if defined(CONSERVATIVE_ALG) 
        new_ntg = rebuild_intfc_at_crossings2d(&Dual_grid,front,oldfr,which_grid); 
        wave_tri_soln(wave)->new_tri_grid = new_ntg; 

        /** make computational grid nodes component here. **/
        new_ntg->tri_grid_hooks = wave->Tri_grid_hooks; 
        start_clock("set_components");
        status = set_components(new_ntg,new_ntg->grid_intfc,ON_COMP_GRID);
#if defined(DEBUG_TRI_GRID)
        if (status == GOOD_STEP && debugging("tri_comps"))
            print_components(new_ntg);
#endif /* defined(DEBUG_TRI_GRID) */
        stop_clock("set_components");
        if (status != GOOD_STEP)
        {
            printf("ERROR: SET comp for COMP_grid failed\n");
            printf("In h_reconstruct_front_at_grid_crossing2d\n");  
            // check_comp_crx_on_comp_grid2d(grid, IS_COMP_GRID);
            // print_interface(intfc);
            clean_up(ERROR);
        }
       
        init_vol_state_storage(new_ntg,new_ntg->grid_intfc,wave->sizest);

        if(which_grid == ON_COMP_GRID)
        {
            /* Reset the front->interf topological grid
             * back to the DUAL_GRID.  
             */
            expanded_dual_grid = &new_ntg->rect_grid;
            top_grid = &topological_grid(new_ntg->grid_intfc);
            new_ntg->grid_intfc->table->new_grid = YES; 
            set_topological_grid(new_ntg->grid_intfc, expanded_dual_grid);
            new_ntg->grid_intfc->table->on_which_grid = ON_DUAL_GRID; 

            /***  do not need anymore. Inside rebuild_intfc_at_crossings2d(),
             ***  instead of using oldfr->interf itself, its copy is used.   
            top_grid = &topological_grid(oldfr->interf);
            oldfr->interf->table->new_grid = YES; 
            set_topological_grid(oldfr->interf, expanded_dual_grid);
            oldfr->interf->table->on_which_grid = ON_DUAL_GRID; 
            ***/
        }
#endif /* if defined(CONSERVATIVE_ALG) */

	DEBUG_LEAVE(h_reconstruct_front_at_grid_crossing2d)
        return new_ntg->grid_intfc; 
}

#endif /* if defined(TWOD) */

#endif /* defined(THREED) || defined(TWOD) */

