/*
*				hhex_intfc.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#define DEBUG_STRING "hintfc"

#include <hyp/hlocaldecs.h>

#if defined(CONSERVATIVE_ALG) && defined(TWOD)

LOCAL void      free_time_space_intfc(TIME_SPACE_INTFC2D**);

LIB_LOCAL int construct_hex_intfc(
	Front      *front,
        Wave       *wave,
        Front      *newfront,
        Wave       *newwave,
        float      dt)
{

        TIME_SPACE_INTFC2D   **ts_intfc;
        int                  i, j, num;
        CRXING               **t_crxes;
        int                  smin[MAXD], smax[MAXD], ic[MAXD];
        TRI_GRID     *newntg = wave_tri_soln(newwave)->tri_grid;
        TRI_GRID     *oldntg = wave_tri_soln(wave)->tri_grid;
 
        DEBUG_ENTER(construct_hex_intfc)

        ts_intfc = time_space_intfc_construct2d(wave_tri_soln(wave)->tri_grid,
                wave_tri_soln(newwave)->tri_grid, front, newfront, &num, dt);
        if(front->step % 10 == 0)
            gview_ts_mesh_tris_plot2d("gviewout", front->step, ts_intfc,
                    num, computational_grid(front->interf), dt);

        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = newntg->comp_grid.gmax[i];
            smin[i] -= newntg->comp_grid.lbuf[i];
            smax[i] += newntg->comp_grid.ubuf[i];
        }

        vector(&t_crxes, oldntg->n_c_reg_nodes, sizeof(CRXING*));
        for(i = 0; i < oldntg->n_c_reg_nodes; i++)
            t_crxes[i] = NULL;  
        oldntg->Volume.t_crxes = t_crxes;

        if(! set_t_crxes_storage_for_volume(ts_intfc, 
                     num, newntg, oldntg, t_crxes, dt))
        {
            printf("ERROR: construct_hex_intfc()\n");
            printf("set_t_crxes_storage_for_reconstruction() failed\n");
            clean_up(ERROR);
        }

        for(j = 0; j < num; j++)
            free_time_space_intfc(&ts_intfc[j]);
        free(ts_intfc);

        if(build_CSG_volume3d(front,newfront,
               newntg, oldntg, t_crxes, dt) != YES)
        {
            printf("ERROR: IN construct_hex_intfc()\n");
            printf("build_CSG_volume3d failed\n");  
            clean_up(ERROR);
        }

        DEBUG_LEAVE(construct_hex_intfc)
        return YES; 
}

LOCAL void free_time_space_intfc(
        TIME_SPACE_INTFC2D **tsintfc)
{
        int  i, num; 

        if((*tsintfc) == NULL) return;

        num = (*tsintfc)->num_tris;
        for(i = 0; i < num; i++)
            free((TRI_Plus_normal*)(*tsintfc)->btris[i].tri); 
        free((*tsintfc)->btris); 
        free(*tsintfc);
}

LIB_LOCAL void set_vol_frac_states(
        Wave    *wave,
        Front   *front)
{

        COMPONENT       comp;
        float           *crds;
        int             icrds[MAXD], icrds_end[MAXD], ic[MAXD];
        int             ic_wv[MAXD], ic_wv2[MAXD];
        int             ic_wv3[MAXD], ic_wv4[MAXD];
        int             dim = wave->rect_grid->dim;
        int             status;
        int             i, j, ii;
        int             max[MAXD], min[MAXD];
        static CRXING   **crx[4] = {NULL,NULL,NULL,NULL};
        int             nc[4]; /* number of CRXING */
        TRI_GRID        *ntg = wave_tri_soln(wave)->tri_grid; 
        size_t          sizest = wave->sizest;
        register Locstate *state;
        register byte     *storage;
        Locstate        st, dflt_state;

        debug_print("hyp","Entered set_vol_frac_states()\n");

        if(NULL == crx[0])
        {
            for(i = 0; i < 4; i++)
                 vector(&crx[i],4,sizeof(CRXING *));
        }

        for (i = 0; i < 2; i++)
        {
            min[i] = 0;
            max[i] = ntg->comp_grid.gmax[i];
            min[i] -= ntg->comp_grid.lbuf[i];
            max[i] += ntg->comp_grid.ubuf[i];
        }

        storage = ntg->vol_rect_state_storage;
        for (i=min[1]; i<max[1]; i++)
        {
            for (j=min[0]; j<max[0]; j++)
            {
                icrds[1] = i;
                icrds[0] = j;
                icrds_end[0] = icrds[0] + 1;
                icrds_end[1] = icrds[1] + 1;

                // if(Comp_blk(icrds,ntg->blk_type,ntg) == F_NO_VOL)
                if(is_complex_blk(Comp_blk(icrds,ntg->blk_type,ntg)))
                {
                    Comp_blk(icrds,ntg->vol_states,ntg) = NULL;
                    continue;
                }
                nc[0] = comp_crossings_in_direction(crx[0],icrds,EAST,ntg);
                nc[2] = comp_crossings_in_direction(crx[2],icrds,NORTH,ntg);
                nc[1] = comp_crossings_in_direction(crx[1],icrds_end,WEST,ntg);
                nc[3] = comp_crossings_in_direction(crx[3],icrds_end,SOUTH,ntg);

                if(nc[1] == 0 && nc[0] == 0 &&
                   nc[2] == 0 && nc[3] == 0)
                {
                    Comp_blk(icrds,ntg->vol_states,ntg) = NULL;
                }
                else if(nc[0] == 1 && nc[2] == 1 &&
                        nc[1] == 0 && nc[3] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    st = state[0];
                    if (tri_solution(crds,comp,wave_tri_soln(wave),
                           st,NULL) == FUNCTION_FAILED)
                    {
                         screen("ERROR in set_vol_frac_states(),"
                                " tri_solution() failed "
                                "in interior region case 1\n");
                         clean_up(ERROR);
                    }

                    ic[0] = icrds[0]+1; ic[1] = icrds[1];
                    st = state[1];
                    assign(st, Rect_state(icrds,wave), sizest);
                    if(Rect_comp(icrds,wave) != Rect_compute_comp(ic,wave))
                    {
                         printf("ERROR set_vol_frac_states(), case1 faild, comp[%d, %d]\n ",
                            Rect_comp(icrds,wave), Rect_compute_comp(ic,wave));
                         clean_up(ERROR);
                    }
                }
                else if(nc[0] == 1 && nc[3] == 1 &&
                        nc[1] == 0 && nc[2] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    st = state[0];
                    assign(st, Rect_state(icrds,wave), sizest);
                    if(Rect_comp(icrds,wave) != Rect_compute_comp(icrds,wave))
                    {
                         printf("ERROR set_vol_frac_states(), case2 faild, comp[%d, %d]\n ",
                            Rect_comp(icrds,wave), Rect_compute_comp(icrds,wave));
                         clean_up(ERROR);
                    }

                    icrds[0]++;
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    icrds[0]--;
                    st = state[1];
                    if (tri_solution(crds,comp,wave_tri_soln(wave),
                           st,NULL) == FUNCTION_FAILED)
                    {
                         screen("ERROR in set_vol_frac_states(),"
                                " tri_solution() failed "
                                "in interior region case2\n");
                         clean_up(ERROR);
                    }
                }
                else if(nc[3] == 1 && nc[1] == 1 &&
                        nc[2] == 0 && nc[0] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    st = state[0];
                    assign(st, Rect_state(icrds,wave), sizest);
                    if(Rect_comp(icrds,wave) != Rect_compute_comp(icrds,wave))
                    {
                         printf("ERROR set_vol_frac_states(), case3 faild, comp[%d, %d]\n ",
                            Rect_comp(icrds,wave), Rect_compute_comp(icrds,wave));
                         clean_up(ERROR);
                    }

                    icrds[0]++;  icrds[1]++;
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    icrds[0]--;  icrds[1]--;
                    st = state[1];
                    if (tri_solution(crds,comp,wave_tri_soln(wave),
                           st,NULL) == FUNCTION_FAILED)
                    {
                         screen("ERROR in set_vol_frac_states(),"
                                " tri_solution() failed "
                                "in interior region case3\n");
                         clean_up(ERROR);
                    }
                }
                else if(nc[1] == 1 && nc[2] == 1 &&
                        nc[0] == 0 && nc[3] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    st = state[0];
                    assign(st, Rect_state(icrds,wave), sizest);
                    if(Rect_comp(icrds,wave) != Rect_compute_comp(icrds,wave))
                    {
                         printf("ERROR set_vol_frac_states(), case4 faild, comp[%d, %d]\n ",
                            Rect_comp(icrds,wave), Rect_compute_comp(icrds,wave));
                         clean_up(ERROR);
                    }

                    icrds[1]++;
                    crds = Rect_compute_coords(icrds,wave);
                    comp = Rect_compute_comp(icrds,wave);
                    icrds[1]--;
                    st = state[1];
                    if (tri_solution(crds,comp,wave_tri_soln(wave),
                           st,NULL) == FUNCTION_FAILED)
                    {
                         screen("ERROR in set_vol_frac_states(),"
                                " tri_solution() failed "
                                "in interior region case4\n");
                         clean_up(ERROR);
                    }
                }
                else if(nc[2] == 1 && nc[3] == 1 &&
                        nc[0] == 0 && nc[1] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    if(Rect_comp(icrds,wave) == Rect_compute_comp(icrds,wave))
                    {
                        assign(state[0], Rect_state(icrds,wave), sizest);

                        icrds[0]++;  icrds[1]++;
                        crds = Rect_compute_coords(icrds,wave);
                        comp = Rect_compute_comp(icrds,wave);
                        icrds[0]--;  icrds[1]--;
                        st = state[1];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in h_regain_vol_states(),"
                                    " tri_solution() failed "
                                    "in interior region case51\n");
                             clean_up(ERROR);
                        }
                    }
                    else
                    {
                         ic[0] = icrds[0]+1; ic[1] = icrds[1]+1;
                         if(Rect_comp(icrds,wave) != Rect_compute_comp(ic,wave))
                         {
                             printf("ERROR set_vol_frac_states(), case52 faild, comp[%d, %d]\n ",
                                Rect_comp(icrds,wave), Rect_compute_comp(ic,wave));
                             clean_up(ERROR);
                         }
                         crds = Rect_compute_coords(icrds,wave);
                         comp = Rect_compute_comp(icrds,wave);
                         st = state[0];
                         if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                         {
                             screen("ERROR in h_regain_vol_states(),"
                                    " tri_solution() failed "
                                    "in interior region case52\n");
                             clean_up(ERROR);
                         }
                         assign(state[1], Rect_state(icrds,wave), sizest);
                     }
                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 0 && nc[3] == 0)
                {
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    if(Rect_comp(icrds,wave) == Rect_compute_comp(icrds,wave))
                    {
                        assign(state[0], Rect_state(icrds,wave), sizest);

                        icrds[0]++;  icrds[1]++;
                        crds = Rect_compute_coords(icrds,wave);
                        comp = Rect_compute_comp(icrds,wave);
                        icrds[0]--;  icrds[1]--;
                        st = state[1];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in h_regain_vol_states(),"
                                    " tri_solution() failed "
                                    "in interior region case61\n");
                             clean_up(ERROR);
                        }
                    }
                    else
                    {
                         ic[0] = icrds[0]+1; ic[1] = icrds[1]+1;
                         if(Rect_comp(icrds,wave) != Rect_compute_comp(ic,wave))
                         {
                             printf("ERROR set_vol_frac_states(), case62 faild, comp[%d, %d]\n ",
                                Rect_comp(icrds,wave), Rect_compute_comp(ic,wave));
                             clean_up(ERROR);
                         }
                         crds = Rect_compute_coords(icrds,wave);
                         comp = Rect_compute_comp(icrds,wave);
                         st = state[0];
                         if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                         {
                             screen("ERROR in h_regain_vol_states(),"
                                    " tri_solution() failed "
                                    "in interior region case62\n");
                             clean_up(ERROR);
                         }
                         assign(state[1], Rect_state(icrds,wave), sizest);
                    }
                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 1 && nc[3] == 1)
                {
                    int         tmp_icrds[MAXD];
                    /* if this is the case, can not determine the interface
                        connection inside the blk by two pts */

                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    ic_wv[0] = icrds[0],    ic_wv[1] = icrds[1]+1;
                    ic_wv2[0] = icrds[0]+1, ic_wv2[1] = icrds[1];
                    ic_wv3[0] = icrds[0],   ic_wv3[1] = icrds[1];
                    ic_wv4[0] = icrds[0]+1, ic_wv4[1] = icrds[1]+1;
                    if(Rect_comp(icrds,wave) == Rect_compute_comp(ic_wv, wave) &&
                       Rect_comp(icrds,wave) == Rect_compute_comp(ic_wv2, wave))
                    {
                        printf("case 1 in set_vol_frac_states() 4 crx\n");

                        comp = Rect_compute_comp(ic_wv3, wave);
                        crds = Rect_compute_coords(ic_wv3, wave);
                        st = state[0];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                                st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in set_vol_frac_states(), tri_solution() failed "
                                            "in interior region 4 crx case1\n");
                             clean_up(ERROR);
                        }
                        comp = Rect_compute_comp(ic_wv4, wave);
                        crds = Rect_compute_coords(ic_wv4, wave);
                        st = state[2];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in set_vol_frac_states(), tri_solution() failed "
                                            "in interior region 4 crx case 11\n");
                             clean_up(ERROR);
                        }
                        assign(state[1], Rect_state(icrds,wave), sizest);
                    }
                    else if(Rect_comp(icrds,wave) == Rect_compute_comp(ic_wv3, wave) &&
                       Rect_comp(icrds,wave) == Rect_compute_comp(ic_wv4, wave))
                    {
                        printf("case 2 in set_vol_frac_states() 4 crx\n");
                        comp = Rect_compute_comp(ic_wv2, wave);
                        crds = Rect_compute_coords(ic_wv2, wave);
                        st = state[1];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in set_vol_frac_states(), tri_solution() failed "
                                            "in interior region 4 crx case21\n");
                             clean_up(ERROR);
                        }
                        comp = Rect_compute_comp(ic_wv, wave);
                        crds = Rect_compute_coords(ic_wv, wave);
                        st = state[2];
                        if (tri_solution(crds,comp,wave_tri_soln(wave),
                               st,NULL) == FUNCTION_FAILED)
                        {
                             screen("ERROR in set_vol_frac_states(), tri_solution() failed "
                                            "in interior region 4 crx case22\n");
                             clean_up(ERROR);
                        }
                        assign(state[0], Rect_state(icrds,wave), sizest);
                    }
                    else
                    {
                        printf("ERROR In set_vol_frac_states()\n");
                        printf("4 crx case assigining memory for states, unknown case\n");
                        printf("ic<%d,%d>\n", icrds[0],icrds[1]);
                        clean_up(ERROR);
                    }
                }
                else
                {
                    printf("ERROR: In set_vol_frac_states()\n");
                    printf("Unkown case for assigining memory for states\n");
                    clean_up(ERROR);
                }
             }
         }


        debug_print("hyp","Left set_vol_frac_states()\n");
}


#endif /* if defined(CONSERVATIVE_ALG) && defined(TWOD) */

