/*
 *                               goverinterp3d.c:
 *
 *       Copyright 1999 by The University at Stony Brook, All rights reserved.
 *
 *       Contains routines for the interpolation of state data for 3D amr.
 */

#define DEBUG_STRING      "goverinterp3d"

#include <gstate/goverlocaldecs.h>

#if defined(USE_OVERTURE)

LIB_LOCAL void g_fill_root_extr_overture_cell_st_from_wv3d(
        Wave       *wv,
        Front      *fr,
        POINTER    cg_func,
        int        grid,
        int        var)
{

        CompositeGrid *cg = (CompositeGrid*)wv->cg_over;
        doubleCompositeGridFunction *uu = (doubleCompositeGridFunction*)cg_func;
        Index         I1,I2,I3;
        static Locstate   st = NULL;
        INTERFACE     *intfc = fr->interf;
        RECT_GRID     *rect_g = wv->rect_grid; 
        COMPONENT     comp; 
        HYPER_SURF    *hs;
        CRXING        *crx[MAX_NUM_CRX];
        int           nc; 
        static const float OFFSET = 0.01; /*TOLERANCE*/ 

        int           ix, iy, iz, ic[MAXD];
        float         crds[MAXD];  
        int           xmin, xmax, ymin, ymax, zmin, zmax;
        int           base1, base2, bound1, bound2, base3, bound3;
        int           base11, base22, bound11, bound22, base33, bound33;

        DEBUG_ENTER(fill_extr_overture_cell_st_from_wv)

        printf("Entered fill_extr_overture_cell_st_from_wv\n");

        if(st == NULL)
            alloc_state(intfc,&st,max(sizeof(VGas),fr->sizest));

        getIndex((*cg)[grid].indexRange(),I1,I2,I3);
        base11 = I1.getBase();
        base22 = I2.getBase();
        base33 = I3.getBase();
        bound11 = I1.getBound();
        bound22 = I2.getBound();
        bound33 = I3.getBound();

        getIndex((*cg)[grid].dimension(),I1,I2,I3);
        base1 = I1.getBase();
        base2 = I2.getBase();
        base3 = I3.getBase();
        bound1 = I1.getBound();
        bound2 = I2.getBound();
        bound3 = I3.getBound();

        /* 
        uu[0].display("density");
        printf("end of print uu dens\n"); 
        */

        for(int axis = 0; axis<cg->numberOfDimensions(); axis++)
        {
            for(int side = Start; side<=End; side++)
            {
                /* 
                printf("Axis [%d], side [%d] boundary type = %d\n",
                   axis, side, rect_boundary_type(intfc,axis,side)); 
                */
                if(rect_boundary_type(intfc,axis,side) == SUBDOMAIN_BOUNDARY)
                    continue;
                if(rect_boundary_type(intfc,axis,side) == REFLECTION_BOUNDARY)
                    continue;
                if(rect_boundary_type(intfc,axis,side) == AMR_SUBDOMAIN_BOUNDARY)
                    continue;
                /* 
                printf(" process: Axis [%d], side [%d] boundary type = %d\n",
                   axis, side, rect_boundary_type(intfc,axis,side)); 
                */
                if(axis == 2 && side == 0)
                {
                    zmin = base3-base33;  zmax = 0;
                    xmin = base1-base11;  xmax = rect_g->gmax[0]+(bound1-bound11);
                    ymin = base2-base22;  ymax = rect_g->gmax[1]+(bound2-bound22);
                    /* 
                    printf(" process: Axis [%d], side [%d] boundary type = %d\n",
                       axis, side, rect_boundary_type(intfc,axis,side)); 
                    printf("X <%d, %d>, Y<%d, %d>, Z<%d, %d>\n",
                          xmin, xmax, ymin, ymax, zmin, zmax); 
                    */
                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            ic[2] = 0; ic[0] = ix; ic[1] = iy; 
                            nc = crossings_in_direction(crx,ic, LOWER, 
                                     wave_tri_soln(wv)->tri_grid);
                            /* 
                            printf("working on ic[%d,%d,%d], # crxing = %d\n",
                                    ic[0], ic[1], ic[2], nc); 
                            print_crxings(crx[0], NO);
                            if(crx[0]->hs == NULL) 
                                printf("crx[0]->hs = NULL\n");
                            */

                            hs = crx[0]->hs;
                            comp = Rect_comp(ic, wv); 
                            crds[0] = rect_g->L[0] + rect_g->h[0]*(0.5+ix);  
                            crds[1] = rect_g->L[1] + rect_g->h[1]*(0.5+iy);  
                            
                            if ((wave_type(hs) == NEUMANN_BOUNDARY) &&
                                (fr->neumann_bdry_state))
                            {
                                for(iz = zmin; iz < zmax; iz++)
                                {
                                    crds[2] = rect_g->L[2] + rect_g->h[2]*(0.5+iz);
                                    if ((*fr->neumann_bdry_state)(crds,comp,
                                          crx[0]->pt,hs,fr, (POINTER)wv,st))
                                    {
                                        printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                        printf("hooked neumann_bdry_state case not implimented\n");
                                        clean_up(ERROR);
                                    }
                                    else
                                    {
                                        /* 
                                        print_general_vector("intfc point for ",crds,3,"");
                                        (void) printf(" comp %d\n",comp);
                                        (*fr->print_state)(state_with_comp(crx[0]->pt, hs, comp));
                                        */

                                        assign(st, state_with_comp(crx[0]->pt, hs, comp), fr->sizest);
                                    } 
                                    if(Params(st) != NULL)
                                        (*uu)[grid](ix+base11,iy+base22,iz+base33) = Dens(st);
                                    else
                                    {
                                        printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                        printf("Dir[%d],side[%d], state st is OBSTACLE\n", axis, side);
                                        clean_up(ERROR);
                                    }
                                }
                            }
                            else if(wave_type(hs) == DIRICHLET_BOUNDARY)
                            {
                                printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                printf("hooked DIRICHLET_BOUNDARY case not implimented\n");
                                clean_up(ERROR);
                            }
                            else
                            {
                                printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                printf("hooked OTHER case not implimented\n");
                                clean_up(ERROR);
                            }
                        }
                    }
                }

                if(axis == 2 && side == 1)
                {
                    zmin = rect_g->gmax[2];  zmax = rect_g->gmax[2]+(bound3-bound33);
                    xmin = base1-base11;  xmax = rect_g->gmax[0]+(bound1-bound11);
                    ymin = base2-base22;  ymax = rect_g->gmax[1]+(bound2-bound22);
                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            ic[2] = rect_g->gmax[2] - 1; ic[0] = ix; ic[1] = iy;
                            nc = crossings_in_direction(crx,ic, UPPER,
                                     wave_tri_soln(wv)->tri_grid);
                            hs = crx[0]->hs;
                            comp = Rect_comp(ic, wv);

                            hs = crx[0]->hs;
                            comp = Rect_comp(ic, wv); 
                            crds[0] = rect_g->L[0] + rect_g->h[0]*(0.5+ix);  
                            crds[1] = rect_g->L[1] + rect_g->h[1]*(0.5+iy);  
                            
                            if ((wave_type(hs) == NEUMANN_BOUNDARY) &&
                                (fr->neumann_bdry_state))
                            {
                                for(iz = zmin; iz < zmax; iz++)
                                {
                                    crds[2] = rect_g->L[2] + rect_g->h[2]*(0.5+iz);
                                    if ((*fr->neumann_bdry_state)(crds,comp,
                                          crx[0]->pt,hs,fr, (POINTER)wv,st))
                                    {
                                        printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                        printf("hooked neumann_bdry_state case not implimented\n");
                                        clean_up(ERROR);
                                    }
                                    else
                                    {
                                        assign(st, state_with_comp(crx[0]->pt, hs, comp), fr->sizest);
                                    } 
                                    if(Params(st) != NULL)
                                        (*uu)[grid](ix+base11,iy+base22,iz+base33) = Dens(st);
                                    else
                                    {
                                        printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                        printf("Dir[%d],side[%d], state st is OBSTACLE\n", axis, side);
                                        clean_up(ERROR);
                                    }
                                }
                            }
                            else if(wave_type(hs) == DIRICHLET_BOUNDARY)
                            {
                                printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                printf("hooked DIRICHLET_BOUNDARY case not implimented\n");
                                clean_up(ERROR);
                            }
                            else
                            {
                                printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                                printf("hooked OTHER case not implimented\n");
                                clean_up(ERROR);
                            }
                        }
                    }
                }

                if(axis == 1 || axis == 0)
                {
                    printf("ERROR in g_fill_root_extr_overture_cell_st_from_wv3d\n");
                    printf("ERROR : Dir[%d] not implimented\n", axis);
                    clean_up(ERROR); 
                }
            }
        }

        /* 
        uu[0].display("density");
        printf("end of print uu dens\n"); 
  
        printf("WAVE tri grid rect_grid\n");
        print_rectangular_grid(&(wave_tri_soln(wv)->tri_grid->rect_grid));
        printf("Wave rect_grid\n"); 
        print_rectangular_grid(wv->rect_grid);
        print_rectangular_grid(fr->rect_grid);
        printf("EXIT in g_fill_root_extr_overture_cell_st_from_wv3d\n");
        exit(0);  
        */

        DEBUG_LEAVE(fill_extr_overture_cell_st_from_wv)
}

#endif /* if defined(USE_OVERTURE) */


