#ifdef MHD
/*
*				edeposition.c:
*
*	Contains initialization routines for energy deposition
*
*/
#include <gdecs/gstate.h>
#include <ginit/ginit.h>            

EXPORT	void init_energy_deposition()
{				
	char	       	   s[Gets_BUF_SIZE];

	scalar(&energy_deposition,sizeof(ENERGY_DEPOSITION));

        screen("Enter the energy deposition time step");
        screen(": ");
        (void) Gets(s);
	(void) sscanf(s,"%d",&energy_deposition.step);

        screen("Enter the component number for the material of the jet");
        screen(": ");
        (void) Gets(s);
	(void) sscanf(s,"%d",&energy_deposition.component);

        screen("Enter the minimal density cut-off");
        screen(": ");
        (void) Gets(s);
	(void) sscan_float(s,&energy_deposition.rho_min);

        screen("Enter the maximum value of the energy deposition");
        screen(": ");
        (void) Gets(s);
        (void) sscan_float(s,&energy_deposition.energy_max[0]);

        screen("Is the energy deposition profile Gaussian? (yes; no = shock type profile)");
        screen(": ");
        (void) Gets(s);
	if (s[0] == 'y' || s[0] == 'Y')
	  {
	    energy_deposition.gauss_profile = YES;

	    screen("Enter the longitudinal coordinate of the energy deposition center");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.lcenter[0]);

	    screen("Enter the coef. of the exponential decay in the radial direction ");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.kr[0]);

	    screen("Enter the coef. of the exponential decay in longitudinal direction");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.kl[0]);
	  }
	else
	  {
	    energy_deposition.gauss_profile = NO;

	    screen("Enter the longitudinal coordinate of the energy deposition center");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.lcenter[0]);

	    screen("Enter radius of the shock type energy profile ");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.R_shock[0]);

	    screen("Enter the coef. of the exponential decay in longitudinal direction ");
	    screen(": ");
	    (void) Gets(s);
	    (void) sscan_float(s,&energy_deposition.kl[0]);
	  }
	return;
} /* end of init_energy_deposition() */
#endif
