/*
*				ghypprotos.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if !defined(_GHYPPROTOS_H)
#define _GHYPPROTOS_H

#if defined(cray)
#define artvsc ARTVSC
#define lwvec1 LWVEC1
#define lwvec2 LWVEC2
#endif /* defined(cray) */

	/* ghyp EXPORTED Function Declarations */
#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */
/*	gflw.F */
FORTRAN	void FORTRAN_NAME(artvsc)(float*,float*,float*,float*,float*,float*,
				  float*,float*,float*,float*,float*,float*,
				  float*,int*);
FORTRAN	void	FORTRAN_NAME(lwvec1)(float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,bool*,int*);
FORTRAN	void	FORTRAN_NAME(lwvec2)(float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     float*,float*,float*,float*,float*,float*,
				     int*,float*,float*,bool*);
#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */

/*	ggodunov.c */
IMPORT	void	godunov(float,float,Locstate,const float*,int,
                        int*,int*,Stencil*);
IMPORT	void	godunovobl(float,float,Tan_stencil*,Locstate,Front*);

/*	glf.c */
IMPORT	void	LF(float,float,Locstate,const float*,int,int*,int*,Stencil*);
IMPORT	void	LFoblique(float,float,Tan_stencil*,Locstate,Front*);

/*	ghyperbolic.c */
IMPORT	TIME_DYNAMICS g_load_state_vectors(int,int*,Vec_Gas*,int,int,
				           Wave*,Wave*,int*,int);
IMPORT	bool	check_ans(const char*,float,float,Locstate,
			  COMPONENT,Stencil*,int);
IMPORT	bool	check_gas(const char*,Locstate*,Locstate,Tan_stencil*,
	                  int,Front*);
IMPORT	void	g_two_side_npt_tang_solver(float,float,Tan_stencil*,
                                           Locstate,Locstate,Front*);
IMPORT	void	point_FD(float,float,Locstate,const float*,
                         int,int*,int*,Stencil*);
IMPORT	void	set_rotation(float**,const float*,int);
// From local to global 
IMPORT  void    g_init_obstacle_states(Vec_Gas*,int,int); 

/*	ghypvec.c */
IMPORT	void	ghyp_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                         int*,int,int,float,float);
IMPORT	void	copy_states_to_new_time_level(int*,Wave*,Wave*,
					      int,int,int*,int);

/*	glw.c */
IMPORT	void	LW_alloc_phys_vecs(Wave*,int);
IMPORT	void	LW_free_phys_vecs(Wave*);
IMPORT	void    LW(float,float,Locstate,const float*,int,int*,int*,Stencil*);
IMPORT	void	LWoblique(float,float,Tan_stencil*,Locstate,Front*);
IMPORT	void	LW_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                       int*,int,int,float,float);

/*	gmuscl.c */
IMPORT	void	oned_MUSCL(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                           Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
			   float,float,int);
IMPORT	void	set_muscl_default_hooks(Muscl_Opts*,Hyp_method*,int);
IMPORT	void	set_muscl_default_opts(Muscl_Opts*,Hyp_method*,int);
/* from local to global */
IMPORT  float   *g_set_vmuscl_vec_gas_storage(float**,Vec_Gas*,Vec_Muscl*,int);

/*      curv_muscl.c */
IMPORT  void    curv_oned_MUSCL(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                           Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
                           float,float,int);
/*	gplm.c */
IMPORT	void	oned_PLM(int,int*,int*,Wave*,Wave*,Front*,Front*,Stencil*,
                         Tan_stencil*,int,int,Vec_Gas*,Vec_Src*,
			 float,float,int);
IMPORT	void	set_plm_default_opts(Muscl_Opts*,Hyp_method*,int);

/*	ghypprt.c */
IMPORT	void	g_print_internal_energy(const char*,float**,Vec_Muscl*,int,int);
IMPORT  void    g_print_state_vectors(int,int,const char**,
                                      float*,float*,float**,int);
IMPORT	void	g_printout_vec_data(const char*,float*,float*,float**,
				    int,int,int,const char*);

/*	grsolve.c */
IMPORT	void	g_exact_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                         float*,float*,Vec_Muscl*);
IMPORT	void	g_gamma_law_fit_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                                 float*,float*,Vec_Muscl*);
IMPORT	void	g_gamma_law_fit_rsolver(int,int,float**,Vec_Gas*,float**,
                                        Vec_Gas*,float**,Vec_Gas*,
				        MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	g_linear_us_up_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,
                                                float*,float*,Vec_Muscl*);
IMPORT	void	g_linear_us_up_rsolver(int,int,float**,Vec_Gas*,float**,
                                       Vec_Gas*,float**,Vec_Gas*,
				       MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	g_muscl_exact_rsolver(int,int,float**,Vec_Gas*,float**,Vec_Gas*,
                                      float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);

/*	gcgrsolve.c */
IMPORT	void	g_cg_Riemann_midstate(int,int,Vec_Gas*,Vec_Gas*,float*,float*,
				      Vec_Muscl*);
IMPORT	void	cg_rsolve(int,int,float**,Vec_Gas*,float**,Vec_Gas*,
                          float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);
IMPORT	void	set_cg_params(CG_PARAMS*);

/*	ghypsub.c */
IMPORT	Muscl_Opts *muscl_options(void);
IMPORT	Vec_Gas	   *g_alloc_vgas(Vec_Gas*,int,int);
IMPORT	Vec_Muscl  *alloc_Vec_Muscl(Vec_Muscl*);
IMPORT	Vec_Muscl  *g_muscl_free_wk_space(Vec_Muscl*);
IMPORT	Vec_Muscl  *load_state_data(int,int*,Front*,Wave*,Stencil*,
                                    Tan_stencil*,Vec_Gas*,Vec_Src*,
				    int,int,int,float,float);
IMPORT	Vec_Src    *muscl_alloc_vsrc(Vec_Src*,int,Wave*);
IMPORT	void	g_MUSCLoblique(float,float,Tan_stencil*,Locstate,Front*);
IMPORT	void	g_assign_wave_state_vectors(int,int*,Wave*,Wave*,Vec_Gas*,
                                            int,int,int*,int);
IMPORT	void	g_muscl_alloc_phys_vecs(Wave*,int);
IMPORT	void	g_muscl_free_phys_vecs(Wave*);
IMPORT	void	clear_Vec_Gas_set_flags(Vec_Gas*);
IMPORT	void	compute_slope_limiting_coeffs(int,int,Vec_Muscl*);
IMPORT	void	copy_vec_state_params(Vec_Gas*,Vec_Gas*,int,int);
IMPORT	void	g_free_vgas(Vec_Gas*);
IMPORT	void	g_free_vsrc(Vec_Src*);
IMPORT	void	g_load_VGas_state_vectors(int,int,Vec_Gas*,int);
IMPORT	void	g_load_muscl_flux(int,int,float**,Vec_Gas*,
                                  MUSCL_FLUX*,Vec_Muscl*);
/*** replaced with  g_compute_Jacobi() 
IMPORT  void    gvol_compute_Jacobi(int,int*,int,int,Stencil*,struct _Vec_Muscl*,
                                Wave*,Front*,Vec_Gas*,int);
***/
/*  curvilinear */
IMPORT  void    g_compute_Jacobi(int,int*,int,int,Stencil*,Tan_stencil*,
                  struct _Vec_Muscl*,Wave*,Front*,Vec_Gas*,int);
IMPORT  void    g_unsplit_cons_src(int,int,int,int*,Tan_stencil*,struct _Vec_Muscl*);

/*	gmoc.c */
IMPORT	void	  g_implicit_characteristic_solve(int,int,Vec_Muscl*);
IMPORT	void	  g_riemann_characteristic_solve(int,int,Vec_Muscl*);
IMPORT	void	  g_first_order_direct_characteristic_solve(int,int,Vec_Muscl*);

/*      gvisc.c */
IMPORT	int	parab_driver(float,float*,Wave*,Front*);
IMPORT  void    parab_npt(float,Front*,Wave*,Wave*);

/* gunsplithypsub.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT  void    g_unsplit_muscl_alloc_phys_vecs(Wave*,int);
IMPORT  void    g_unsplit_muscl_free_phys_vecs(Wave*);
IMPORT  Vec_Muscl  *g_load_unsplit_muscl_state_data(Muscl_Opts*,int,int*,Front*,
                         Wave*,Stencil*,Tan_stencil*,Vec_Gas*,Vec_Gas**,Vec_Src*,int,int,
                         int,float,float);
IMPORT  Vec_Muscl  *g_init_unsplit_muscl_state_data(Muscl_Opts*,int,int*,Front*,
                         Wave*,Stencil*,Tan_stencil*,Vec_Gas*,Vec_Gas**,Vec_Src*,int,int,
                         int,float,float);
IMPORT  bool    g_unsplit_muscl_load_source_vectors(int,int*,Tan_stencil*,float**,
                                            Vec_Gas*,Vec_Src*,float*,int,int,
                                            RECT_GRID*);
IMPORT  void    g_compute_2dunsplit_eigens(int,int,int,int*,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_bct_linear_reconstructor(int,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_N_half_step(int,int,float,float*,int,int*,int,Vec_Muscl*);
IMPORT  void    g_2dunsplit_T_half_step(int,int,float,float*,int,int*,int,Vec_Muscl*);
IMPORT  void    g_unsplit_muscl_exact_rsolver(int,int,int,int*,float**,Vec_Gas*,
                      float**,Vec_Gas*,float**,Vec_Gas*,MUSCL_FLUX*,Vec_Muscl*);
IMPORT  void    ghyp_unsplit_vec(int,int*,float*,Wave*,Wave*,Front*,Front*,
                         int*,int,int,float,float*); 
IMPORT  void    unsplit_point_FD(float*,float,Locstate,const float*,
                    int,int*,int*,Stencil*);
IMPORT  void    g_compute_2dunsplit_art_visc_coefs(int,int,int,int*,int,Vec_Muscl*);
IMPORT  void    set_unsplit_muscl_debug_flag(int);
#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

/* ghypvol.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT  void    contrl_vol_FD(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  void    contrl_vol_FD_ver2(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  void    contrl_vol_update(int*,CSG_BLK_CRX*,CSG_Solid*,
                     Wave*,Wave*,Front*,Front*,float,float*);
IMPORT  int     update_top_face_state(size_t,CSG_Solid*,Locstate);
IMPORT  void    g_alloc_stintfc_st_pool(Wave*);
IMPORT  void    g_free_stintfc_st_pool(void);

/* gDG.c */
IMPORT void     gDG_tri_vec(int*,float*,float,Wave*,Wave*,Front*,Front*,COMPONENT);
IMPORT float    time_step_on_tri(Front*,TRI*);
IMPORT void     show_state_on_tri(const char*,int,Front*);
IMPORT void     show_state_to_rect(const char*,int,Front*);
IMPORT void     con_u_at_pt(Locstate,float*,double*,float*);
/* gDG2.c */
IMPORT void      update_buffer_x_peri(Front*,Mid_soln*,int);
IMPORT void      update_buffer_x_ref(Front*,Mid_soln*,int);
IMPORT void      update_buffer_x_per_y_ref(Front*,Mid_soln*,int);
IMPORT void      update_buffer(Front*,Mid_soln*,int);
IMPORT void      zero_moments(Locstate);
IMPORT void      update_coef(TRI*,Mid_soln*,int,Front*,size_t,int);
IMPORT void      u_x_average(TRI*,Locstate,float*);
IMPORT void      u_y_average(TRI*,Locstate,float*);
IMPORT void      comp_coef(float A[ ][2],float*,float*);
IMPORT float     minmod(float, float);
IMPORT void      R_degree2_term_average(TRI*,Locstate,float*);
IMPORT void      R_degree2_term_average_Liu(TRI*,Locstate,double**,float*);
IMPORT float     ff_g_sin(float*,int,float);
IMPORT float     obtain_time_step_on_tri(Front*);


#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

#endif /* !defined(_GHYPPROTOS_H) */
