/*
*                               gDG2.c
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*/

#include <ghyp/ghyp.h>
#include <gdecs/vecdecs.h>

#if defined(TWOD)

LOCAL double **mass_1st_row = NULL;
LOCAL int       debug_flag = NO;

LOCAL int    find_nghbr_nghbr(TRI *nbtri[3],TRI*,TRI *nnb[9],int*,Front*);
LOCAL void   limiting_2nd_degree_ENO(TRI*, TRI *nbtri[3],TRI *nntri[9],int,int*,Mid_soln*,int);
LOCAL void   limiting_1st_degree_ENO(TRI*, TRI *nbtri[3],TRI *nntri[9],int,int*,Mid_soln*,int);
LOCAL TRI    *min_angle_tri(TRI*,TRI*,TRI**,int,int*);
LOCAL int    min_angle(float*, int);

LOCAL int find_nghbr_nghbr(
	TRI       *nbtri[3],
        TRI       *tri,
        TRI       *nntri[9],
        int       *nn_num,
        Front     *fr)
{
	int       i, j, k, l;
        TRI       *tmp;
        POINT     *p[3];
        int       share_v, N_nn = 0, num_side;

        for(i = 0; i < 3; i++)
            p[i] = Point_of_tri(tri)[i];

        for(i = 0; i < 3; i++)
        {
            num_side = 0;
            if(nbtri[i] != NULL)
            {
                // nbtri has 3 nghbrs.
                for(j = 0; j < 3; j++)
                {
                    tmp = Tri_on_side(nbtri[i],j);
                    if(tmp == tri)
                        continue;
                    share_v = NO;
                    if(tmp != NULL)
                    {
                        for(k = 0; k < 3; k++)
                        {
                            for(l = 0; l < 3; l++)
                            {
                                if(Point_of_tri(tmp)[l] == p[k])
                                {
                                    share_v = YES;
                                    break;
                                }
                            }
                            if(share_v == YES)
                                break;
                        }  
                    }
                    if(share_v == YES)
                    {
                        nntri[N_nn] = tmp;
                        N_nn++; 
                        num_side++;
                    }
                }
            }
            nn_num[i] = num_side;
        }
        return N_nn;
}

// Reconstructed coeffs. are stored in RK_STEP[0]
LOCAL void limiting_1st_degree_ENO(
         TRI       *tri,
         TRI       *nbtri[3],
         TRI       *nntri[9],
         int       N_nn,
         int       *nn_side,
         Mid_soln  *midsoln,
         int       rk_iter)
{
         Locstate st, nbst[3], st2, nnst[9], tmpst, tmpst0;
         float    uavg[4], nbuavg[3][4], nnuavg[9][4], tmpavg[4];
         float    Ravg[4], nbRavg[3][4], nnRavg[9][4], tmpRavg[4];
         float    Lavg[4], nbLavg[3][4], nnLavg[9][4], tmpLavg[4];
         int      i, dim = 2, indx, k;
         double    *cent, *nbcent[3], *tmpcent, *nncent[9];
         float    rside[2], A[2][2];
         float    coef[3][2];
         float    u0, u1, u2, avg1, avg2;
         double **Lmass_matrix = tri->Lmass_matrix;
         float    Ma = 100.0, eps = 0.01;
         float    dir[3];
         int      idir, ipos;
         TRI      *minangle;

         if(rk_iter == RK_STEP)
         {
             st = tri->st;
             for(i = 0; i < 3; i++)
                 nbst[i] = nbtri[i]->st;
             for(i = 0; i < N_nn; i++)
                 nnst[i] = nntri[i]->st;
         }
         else
         {
             st = midsoln[tri->id].st[rk_iter];
             for(i = 0; i < 3; i++)
             {
                 if(nbtri[i]->id >= 0)
                     nbst[i] = midsoln[nbtri[i]->id].st[rk_iter];
                 else
                     nbst[i] = nbtri[i]->st;
             }
             for(i = 0; i < N_nn; i++)
                 nnst[i] = midsoln[nntri[i]->id].st[rk_iter];
         }

         st2 = midsoln[tri->id].st[0];

         uavg[0] = Dens(st);
         uavg[1] = Mom(st)[0];
         uavg[2] = Mom(st)[1];
         uavg[3] = Energy(st);

         R_degree2_term_average(tri,st2,Ravg);

         // 3 neighbor tris
         for(i = 0; i < 3; i++)
         {
             nbuavg[i][0] = Dens(nbst[i]);
             nbuavg[i][1] = Mom(nbst[i])[0];
             nbuavg[i][2] = Mom(nbst[i])[1];
             nbuavg[i][3] = Energy(nbst[i]);

             comp_mass_matrix_1st_row(MAX_N_COEF,nbtri[i],dim,fg_centroid(tri),mass_1st_row);
             R_degree2_term_average_Liu(nbtri[i],st2,mass_1st_row,nbRavg[i]);
         }

         // neighbr's nghbr
         for(i = 0; i < N_nn; i++)
         {
             nnuavg[i][0] = Dens(nnst[i]);
             nnuavg[i][1] = Mom(nnst[i])[0];
             nnuavg[i][2] = Mom(nnst[i])[1];
             nnuavg[i][3] = Energy(nnst[i]);

             comp_mass_matrix_1st_row(MAX_N_COEF,nntri[i],dim,fg_centroid(tri),mass_1st_row);
             R_degree2_term_average_Liu(nntri[i],st2,mass_1st_row,nnRavg[i]);
         }

         for(k = 0; k < N_EQN; k++)
         {
             Lavg[k] = uavg[k]-Ravg[k];
             for(i = 0; i < 3; i++)
                 nbLavg[i][k] = nbuavg[i][k]-nbRavg[i][k];
             for(i = 0; i < N_nn; i++)
                 nnLavg[i][k] = nnuavg[i][k]-nnRavg[i][k];
         }

         cent = fg_centroid(tri);
         for(i = 0; i < 3; i++)
             nbcent[i] = fg_centroid(nbtri[i]);
         for(i = 0; i < N_nn; i++)
             nncent[i] = fg_centroid(nntri[i]);

         for(k = 0; k < N_EQN; k++)
         {
             // linear part of polynomial
             // tri, nbtri[i], + nghbr of nbtri[i] with min angle
             for(i = 0; i < 3; i++)
             {
                 if(nn_side[i] != 0)
                 {
                     minangle = min_angle_tri(tri, nbtri[i], nntri, N_nn, &ipos);
                     rside[0] = nbLavg[i][k] - Lavg[k];
                     rside[1] = nbLavg[ipos][k] - Lavg[k];
                     A[0][0] = (nbcent[i][0]-cent[0]);
                     A[0][1] = (nbcent[i][1]-cent[1]);
                     A[1][0] = (nncent[ipos][0]-cent[0]);
                     A[1][1] = (nncent[ipos][1]-cent[1]);

                     comp_coef(A,rside,coef[i]);
                 }
                 else
                 {
                     // nghbr does not possess nghbrs.
                     TRI *tmparray[12];
                     int jj, ll = 0;
                     for(jj = 0; jj < 3; jj++)
                     {
                         if(nbtri[jj] != nbtri[i])
                         {
                             tmparray[ll] = nbtri[jj];
                             ll++;
                         }
                     }
                     for(jj = 0; jj < N_nn; jj++)
                     {
                         tmparray[ll] = nntri[jj];
                         ll++;
                     }
                     minangle = min_angle_tri(tri, nbtri[i], tmparray, ll, &ipos);
                     if(rk_iter == RK_STEP)
                     {
                         tmpst = minangle->st;
                     }
                     else
                     {
                         if(minangle->id >= 0)
                             tmpst = midsoln[minangle->id].st[rk_iter];
                         else
                             tmpst = minangle->st;
                     }
                     tmpavg[0] = Dens(tmpst);
                     tmpavg[1] = Mom(tmpst)[0];
                     tmpavg[2] = Mom(tmpst)[1];
                     tmpavg[3] = Energy(tmpst);

                     comp_mass_matrix_1st_row(MAX_N_COEF,minangle,dim,fg_centroid(tri),mass_1st_row);
                     R_degree2_term_average_Liu(minangle,st2,mass_1st_row,tmpRavg);
                     for(jj = 0; jj < N_EQN; jj++)
                         tmpLavg[jj] = tmpavg[jj]-tmpRavg[jj];
                     tmpcent = fg_centroid(minangle);

                     rside[0] = nbLavg[i][k] - Lavg[k];
                     rside[1] = tmpLavg[k] - Lavg[k];
                     A[0][0] = (nbcent[i][0]-cent[0]);
                     A[0][1] = (nbcent[i][1]-cent[1]);
                     A[1][0] = (tmpcent[0]-cent[0]);
                     A[1][1] = (tmpcent[1]-cent[1]);

                     comp_coef(A,rside,coef[i]);
                 }
             }             

             avg1 = 1.0/3.0*(coef[0][0] + coef[1][0] + coef[2][0]);
             u1 = minmod(coef[0][0],coef[1][0]);
             u1 = minmod(coef[2][0],u1);
             // u1 = minmod(((1+eps)*u1), avg1);

             avg2 = 1.0/3.0*(coef[0][1] + coef[1][1] + coef[2][1]);
             u2 = minmod(coef[0][1],coef[1][1]);
             u2 = minmod(coef[2][1],u2);
             // u2 = minmod(((1+eps)*u2), avg2);

             u0 = Lavg[k];

             switch(k)
             {
             case 0:
                 dg_Dens(st2)[0] = u0;
                 dg_Dens(st2)[1] = u1;
                 dg_Dens(st2)[2] = u2;
             break;
             case 1:
                 dg_Mom(st2)[0][0] = u0;
                 dg_Mom(st2)[0][1] = u1;
                 dg_Mom(st2)[0][2] = u2;
             break;
             case 2:
                 dg_Mom(st2)[1][0] = u0;
                 dg_Mom(st2)[1][1] = u1;
                 dg_Mom(st2)[1][2] = u2;
             break;
             case 3:
                 dg_Energy(st2)[0] = u0;
                 dg_Energy(st2)[1] = u1;
                 dg_Energy(st2)[2] = u2;
             break;
             }
         } // End of: for(k = 0; k < N_EQN; k++)

         Dens(st2) = Dens(st);
         Mom(st2)[0] = Mom(st)[0];
         Mom(st2)[1] = Mom(st)[1];
         Energy(st2) = Energy(st);
}

// Reconstructed coeffs. are stored in RK_STEP[0]
LOCAL void limiting_2nd_degree_ENO(
         TRI       *tri,
         TRI       *nbtri[3],
         TRI       *nntri[9],
         int       N_nn,
         int       *nn_side,
         Mid_soln  *midsoln,
         int       rk_iter)
{
         Locstate st, nbst[3], st2, nnst[9], tmpst;
         float    uxavg[4], nbuxavg[3][4], nnuxavg[9][4];
         float    uyavg[4], nbuyavg[3][4], nnuyavg[9][4];
         float    tmpuxavg[4], tmpuyavg[4];
         int      i, dim = 2, k;
         double   *cent, *nbcent[3], *nncent[9], *tmpcent;
         float    rside[2], A[2][2];
         float    coefx[3][2], coefy[3][2];
         float    u3, u4, u5, avg3, avg4, avg5;
         double **Lmass_matrix = tri->Lmass_matrix;
         float    Ma = 100.0, eps = 0.01;
         float    dirx[3], diry[3]; // cos of the angle
         float    ud[3][2]; // soln uxx, uxy, uyy computed using one line
         int      idirx, idiry, ipos;
         TRI      *minangle;

         if(rk_iter == RK_STEP)
         {
             st = tri->st;
             for(i = 0; i < 3; i++)
                 nbst[i] = nbtri[i]->st;
             for(i = 0; i < N_nn; i++)
                 nnst[i] = nntri[i]->st;
         }
         else
         {
             st = midsoln[tri->id].st[rk_iter];
             for(i = 0; i < 3; i++)
             {
                 if(nbtri[i]->id >= 0)
                     nbst[i] = midsoln[nbtri[i]->id].st[rk_iter];
                 else
                 {
                     // attached buffer
                     nbst[i] = nbtri[i]->st;
                 }
             }
             for(i = 0; i < N_nn; i++)
                 nnst[i] = midsoln[nntri[i]->id].st[rk_iter];
         }

         st2 = midsoln[tri->id].st[0];
         Set_params(st2,st);
         set_type_of_state(st2,state_type(st));

         cent = fg_centroid(tri);
         for(i = 0; i < 3; i++)
             nbcent[i] = fg_centroid(nbtri[i]);

         for(i = 0; i < N_nn; i++)
             nncent[i] = fg_centroid(nntri[i]);

         u_x_average(tri,st,uxavg);
         u_y_average(tri,st,uyavg);

         for(i = 0; i < 3; i++)
         {
             u_x_average(nbtri[i],nbst[i],nbuxavg[i]);
             u_y_average(nbtri[i],nbst[i],nbuyavg[i]);
         }
         for(i = 0; i < N_nn; i++)
         {
             // printf("find tri[%d] ux\n", nntri[i]->id);
             u_x_average(nntri[i],nnst[i],nnuxavg[i]);
             u_y_average(nntri[i],nnst[i],nnuyavg[i]);
         }


         if((tri->id == 110))
         {
             printf("\n-------------------------------------\n");
             printf("limiting_2nd_degree_ENO New soln of tri (%d): at iteration %d\n", tri->id, rk_iter);
             // print_tri_crds(tri);
             printf("tri neigh:0, 1, 2\n");
             printf("neighbr tri id (%d %d %d)\n", nbtri[0]->id, nbtri[1]->id, nbtri[2]->id);

             printf("tri input state:");
             verbose_print_state("tri:",st);
             printf("print nb0, 1, 2, states\n");
             // verbose_print_state("nb0:",nbst[0]);
             // verbose_print_state("nb1:",nbst[1]);
             // verbose_print_state("nb2:",nbst[2]);
             debug_flag = YES;
         }


         for(k = 0; k < N_EQN; k++)
         {
             // d_x u and d_y u polynomial
             // tri, nbtri[i], + nghbr of nbtri[i] with min angle 
             for(i = 0; i < 3; i++)
             {
                 if(nn_side[i] != 0)
                 {
                     minangle = min_angle_tri(tri, nbtri[i], nntri, N_nn, &ipos); 
                     // d_x u
                     rside[0] = nbuxavg[i][k] - uxavg[k];
                     rside[1] = nnuxavg[ipos][k] - uxavg[k];
                     A[0][0] = 2.0*(nbcent[i][0]-cent[0]);
                     A[0][1] = (nbcent[i][1]-cent[1]);
                     A[1][0] = 2.0*(nncent[ipos][0]-cent[0]);
                     A[1][1] = (nncent[ipos][1]-cent[1]);
                     comp_coef(A,rside,coefx[i]);

                     // d_y u
                     rside[0] = nbuyavg[i][k] - uyavg[k];
                     rside[1] = nnuyavg[ipos][k] - uyavg[k];
                     A[0][0] = (nbcent[i][0]-cent[0]);
                     A[0][1] = 2.0*(nbcent[i][1]-cent[1]);
                     A[1][0] = (nncent[ipos][0]-cent[0]);
                     A[1][1] = 2.0*(nncent[ipos][1]-cent[1]);
                     comp_coef(A,rside,coefy[i]);

                     dirx[i] = (A[0][0]/2.0*A[1][0]/2.0 + A[0][1]*A[1][1])/
                             ( sqrt(sqr(A[0][0]/2.0) + sqr(A[0][1]))*sqrt(sqr(A[1][0]/2.0) + sqr(A[1][1])) );
                     if(debug_flag == YES)
                     {
                         printf("nbtri[%d] use nntri[%d], cos_angle %g\n",nbtri[i]->id, minangle->id, dirx[i]);
                     }
                 }
                 else
                 {
                     // nghbr does not possess nghbrs.
                     TRI *tmparray[12];
                     int jj, ll = 0;
                     for(jj = 0; jj < 3; jj++)
                     {
                         if(nbtri[jj] != nbtri[i])
                         {
                             tmparray[ll] = nbtri[jj];
                             ll++;
                         }
                     }
                     for(jj = 0; jj < N_nn; jj++)
                     {
                         tmparray[ll] = nntri[jj];
                         ll++;
                     }
                     minangle = min_angle_tri(tri, nbtri[i], tmparray, ll, &ipos); 
                     if(rk_iter == RK_STEP)
                         tmpst = minangle->st;
                     else
                     {
                         if(minangle->id >= 0)
                             tmpst = midsoln[minangle->id].st[rk_iter]; 
                         else
                             tmpst = minangle->st;
                     }
                     u_x_average(minangle,tmpst,tmpuxavg);
                     u_y_average(minangle,tmpst,tmpuyavg);
                     tmpcent = fg_centroid(minangle);

                     // d_x u
                     rside[0] = nbuxavg[i][k] - uxavg[k];
                     rside[1] = tmpuxavg[k] - uxavg[k];
                     A[0][0] = 2.0*(nbcent[i][0]-cent[0]);
                     A[0][1] = (nbcent[i][1]-cent[1]);
                     A[1][0] = 2.0*(tmpcent[0]-cent[0]);
                     A[1][1] = (tmpcent[1]-cent[1]);
                     comp_coef(A,rside,coefx[i]);

                     // d_y u
                     rside[0] = nbuyavg[i][k] - uyavg[k];
                     rside[1] = tmpuyavg[k] - uyavg[k];
                     A[0][0] = (nbcent[i][0]-cent[0]);
                     A[0][1] = 2.0*(nbcent[i][1]-cent[1]);
                     A[1][0] = (tmpcent[0]-cent[0]);
                     A[1][1] = 2.0*(tmpcent[1]-cent[1]);
                     comp_coef(A,rside,coefy[i]);

                     dirx[i] = (A[0][0]/2.0*A[1][0]/2.0 + A[0][1]*A[1][1])/
                             ( sqrt(sqr(A[0][0]/2.0) + sqr(A[0][1]))*sqrt(sqr(A[1][0]/2.0) + sqr(A[1][1])) );
                     if(debug_flag == YES)
                     {
                         printf("nbtri[%d] use nntri[%d], cos_angle %g\n",nbtri[i]->id, minangle->id, dirx[i]);
                     }
                 }
             }

             avg3 = 1.0/3.0*(coefx[0][0] + coefx[1][0] + coefx[2][0]);
             u3 = minmod(coefx[0][0],coefx[1][0]);
             u3 = minmod(coefx[2][0],u3);
             // u3 = minmod(((1.0+eps)*u3), avg3);

             avg4 = 1.0/6.0*(coefx[0][1] + coefx[1][1] + coefx[2][1] + coefy[0][0] + coefy[1][0] + coefy[2][0]);
             u4 = minmod(coefx[0][1],coefx[1][1]);
             u4 = minmod(coefx[2][1],u4);
             u4 = minmod(coefy[0][0],u4);
             u4 = minmod(coefy[1][0],u4);
             u4 = minmod(coefy[2][0],u4);
             // u4 = minmod(((1.0+eps)*u4), avg4);

             avg5 = 1.0/3.0*(coefy[0][1] + coefy[1][1] + coefy[2][1]);
             u5 = minmod(coefy[0][1],coefy[1][1]);
             u5 = minmod(coefy[2][1],u5);
             // u5 = minmod(((1.0+eps)*u5), avg5);

             if(debug_flag == YES && k == 0)
             {
                 printf("Uxx cand[%g %g %g] cos(%g %g %g)\n", coefx[0][0], coefx[1][0], coefx[2][0],
                                      dirx[0], dirx[1], dirx[2]);
                 printf("Uxy cand[%g %14.13g %g, %g %14.13g %g]\n", coefx[0][1], coefx[1][1], coefx[2][1],
                                            coefy[0][0], coefy[1][0], coefy[2][0]);
                 // printf("Uxy cand[%g %g %g]\n", coefx[0][1], coefx[1][1], coefx[2][1]);
                 printf("Uyy cand[%g %g %g] cos(%g %g %g)\n", coefy[0][1],coefy[1][1],coefy[2][1],
                                     diry[0], diry[1], diry[2]);
             }

             switch(k)
             {
             case 0:
                 dg_Dens(st2)[3] = u3;
                 dg_Dens(st2)[4] = u4;
                 dg_Dens(st2)[5] = u5;
             break;
             case 1:
                 dg_Mom(st2)[0][3] = u3;
                 dg_Mom(st2)[0][4] = u4;
                 dg_Mom(st2)[0][5] = u5;
             break;
             case 2:
                 dg_Mom(st2)[1][3] = u3;
                 dg_Mom(st2)[1][4] = u4;
                 dg_Mom(st2)[1][5] = u5;
             break;
             case 3:
                 dg_Energy(st2)[3] = u3;
                 dg_Energy(st2)[4] = u4;
                 dg_Energy(st2)[5] = u5;
             break;
             }
             if(debug_flag == YES && k == 0)
             {
                 printf("for[%d] state, coeff(3, 4, 5) = (%g, %g, %g), final(%g, %g, %g), orign(%g %g %g)\n",                               k, u3, u4, u5, dg_Dens(st2)[3], dg_Dens(st2)[4], dg_Dens(st2)[5],
                        dg_Dens(st)[3], dg_Dens(st)[4], dg_Dens(st)[5]);
             }

         } // End of: for(k = 0; k < N_EQN; k++)

         debug_flag = NO;

}

TRI *min_angle_tri(
	TRI  *tri,
        TRI  *nbtri,
        TRI  **nntri,
        int  N_nn,
        int  *ipos)
{
        double   *cent, *nbcent;
        float  dir[3], len;
        int   i, j, dim = 2, min_num;
        float ndir[9][3], cos_th[9];

        cent = fg_centroid(tri);
        nbcent = fg_centroid(nbtri);
        
        for(i = 0; i < dim; i++)
            dir[i] = nbcent[i] - cent[i];
        len = sqrt(sqr(dir[0]) + sqr(dir[1]) );
        for(i = 0; i < dim; i++)
            dir[i] = dir[i]/len;

        for(j = 0; j < N_nn; j++)
        {
            nbcent = fg_centroid(nntri[j]);
            for(i = 0; i < dim; i++)
                ndir[j][i] = nbcent[i] - cent[i];
            len = sqrt(sqr(ndir[j][0]) + sqr(ndir[j][1]) );
            for(i = 0; i < dim; i++)
                ndir[j][i] = ndir[j][i]/len;
            cos_th[j] = dir[0]*ndir[j][0] + dir[1]*ndir[j][1];
        }
        min_num = min_angle(cos_th, N_nn);

        *ipos = min_num;
        return nntri[min_num];
}

LOCAL int min_angle(float *cos_th, int n)
{
        int i, imin = 0;
        float max_cth;
        max_cth = cos_th[0];
        for(i = 1; i < n; i++)
        {
            if(cos_th[i] > max_cth)
            {
                max_cth = cos_th[i];
                imin = i;
            }
        }
        return imin;
}

#endif // if defined(TWOD)
