/*
*
*				gas-main.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#include <ginit/ginit.h>

LOCAL	const char *__FronTier_VERSION__ = "20020808";

EXPORT	int C_MAIN_PROGRAM(
	int			argc,
	char			**argv)
{
	static G_INIT_DATA	Ginit;
	static G_INIT_PHYSICS	GIphys;
	static Grid		grid;
	static CHART		root;
	static G_Front		gfront;
	static G_Wave		gwave;
	static G_Printplot	gprt;
#ifdef MHD
        static M_TO_ELLIP       toel;
#endif
	INIT_DATA		*init = init_data(&Ginit);
	const char		*executable;
	char                    title[1024];
	int			i;

	/*Set executable name*/
	executable = NULL;
	(void) sprintf(title,"\n\t\tWELCOME TO WIND TUNNEL CALCULATIONS\n"
	                     "\t\tFronTier Gas version %s\n",
			     __FronTier_VERSION__);
	title(init) = title;
	for (i = 0; i < argc; ++i)
	{
	    if (strncmp(argv[i],"-spolars",8)==0)
	    {
	    	executable = "spolars";
	    	break;
	    }
            if (strncmp(argv[i],"-gsolvers",9)==0)
            {
                executable = "gsolvers";
                break;
            }
	    if (strncmp(argv[i],"-eosplot",8)==0)
	    {
	    	executable = "eosplot";
	    	break;
	    }
	    if (strncmp(argv[i],"-rage90",7)==0)
	    {
	    	executable = "rage90";
	    	break;
	    }
	}
	if (executable == NULL)
	    executable = strdup(basename(argv[0]));
	if (i < argc)
	{
	    /*remove executable option from argv*/
	    for (argc--; i < argc; ++i)
	    	argv[i] = argv[i+1];
	}

	root.front = (Front*)&gfront;
	root.wave = (Wave*)&gwave;
#ifdef MHD
        root.el_map     = (POINTER)&toel;
#endif
	wave_of_front(root.front) = root.wave;

	chart_of_wave(&gwave) = &root;
	chart_of_front(&gfront) = &root;

	root.grid = &grid;
	GIphys.Iphys.root = &root;
	GIphys.Iphys.prt = (Printplot*)&gprt;
	root.prt = GIphys.Iphys.prt;

	ex_name(init) = executable;

	set_gas_hooks(init,&GIphys.Iphys);

#if defined(TWOD)
	if (strcmp(executable,"spolars") == 0)
	    return sp_main(argc,argv,init,&GIphys.Iphys);
        if (strcmp(executable,"gsolvers") == 0)
            return gsolv_main(argc,argv,init,&GIphys.Iphys);
	if (strcmp(executable,"eosplot") == 0)
	    return eosp_main(argc,argv,init,&GIphys.Iphys);
#endif /* defined(TWOD) */
#if defined(RAGE90)
	if (strcmp(executable,"rage90") == 0)
	    return rage90_main(argc,argv,init,&GIphys.Iphys);
#endif /* defined(RAGE90) */

	return dmain(argc,argv,init,&GIphys.Iphys);
}		/*end main*/

#if defined(mips)
EXPORT	void cvd_bug_workaround(
	Gas         *gas,
	HYPER_SURF  *hs,
	G_INIT_DATA *ginit)
{
	F_HYPER_SURF Fhs;
	F_POINT Fp;

	gas->rho = ERROR_FLOAT;
	bstate_index(hs) = -1;
	ginit->_prompt_for_ref_state = NULL;
	Fhs._wave_type = CONTACT;
	wave_type(hs) = Fhs._wave_type;
	Fp.point._coords[0] = 0.0;
	Fp._left_state = Fp._right_state = NULL;
	print_general_vector("Fp",Fp.point._coords,1,"\n");
}		/*end cvd_bug_workaround*/
#endif /* defined(mips) */
