/*
*				fscatter.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/



#define DEBUG_STRING    "fscatter"
#include <front/fdecs.h>    	/* includes int.h, table.h */

#if defined(CONSERVATIVE_ALG)
LOCAL void       reset_scat_intfc_pt_indx(Front*);
LOCAL void       match_recv_with_sv(Front*); 
LOCAL int        sv_gcurve_match_c(CURVE*,G_Indx_Curve*,float*,
                        int,float,G_Indx_Curve**);  
LOCAL void       gcurve_set_c_indx(CURVE*,G_Indx_Curve*,float*,
                        int,float);  
LOCAL void       prt_gcurve_indx(G_Indx_Curve*);
#endif /* if defined(CONSERVATIVE_ALG) */

		/* LOCAL Function Declarations */

/*
*			scatter_front():
*	
*	This routine does three things:
*	1. cut large intfc according to the size of physical
*	   subdomain;
*	2. extend subdomain intfc and rect_grid up to buffer region;
*	3. fix boundary curves onto extended subdomain ----
*	   virtual domain.
*
*/

EXPORT bool scatter_front(
	Front		*front)
{
	COMPONENT	max_comp;
	INTERFACE	*intfc = front->interf;
	RECT_GRID	*gr = front->rect_grid;
	bool		status;
	bool		sav_copy = copy_intfc_states();
	bool		sav_intrp = interpolate_intfc_states(intfc);
	int		i, dim = gr->dim;
	DEBUG_ENTER(scatter_front)

#if defined(THREED)
	if ((dim == 3) && debugging("consistency"))
	{
	    (void) printf("Check consistency of interface "
	                  "before scatter_front()\n");
	    if (!consistent_interface(intfc))
	    {
		screen("ERROR in scatter_front(),  input interface is "
		       "inconsistent\n");
		clean_up(ERROR);
	    }
	    (void) printf("Interface into scatter_front is consistent\n");
	}
#endif /* defined(THREED) */

	for (i = 0; i < dim; ++i)
	    if ((gr->lbuf[i] > 0) || (gr->ubuf[i] > 0))
		break;
	if (i == dim)
	{
	    status = FUNCTION_SUCCEEDED; /* No subdomains to process */
	}
	else
	{
	    set_copy_intfc_states(YES);
	    interpolate_intfc_states(intfc) = NO;

	    status = form_subintfc_via_communication(front);

	    max_comp = max_component(intfc);
	    pp_global_imax(&max_comp,1L);
	    max_component(intfc) = max_comp;

	    interpolate_intfc_states(intfc) = sav_intrp;
	    set_copy_intfc_states(sav_copy);
	}

#if defined(THREED)
	if ((status) && (dim == 3) && debugging("consistency"))
	{
	    (void) printf("Check consistency of interface ");
	    (void) printf("after scatter_front()\n");
	    if (!consistent_interface(intfc))
	    {
		screen("ERROR in scatter_front(),  output interface is "
		       "inconsistent\n");
		clean_up(ERROR);
	    }
	}
#endif /* defined(THREED) */

#if defined(CONSERVATIVE_ALG)
        if(dim == 2)
            reset_scat_intfc_pt_indx(front);  
#endif /* if defined(CONSERVATIVE_ALG) */

	DEBUG_LEAVE(scatter_front)
	return pp_min_status(status);
}		/*end scatter_front*/


EXPORT	INTERFACE *f_zoom_interface(
	INTERFACE	*intfc,
	RECT_GRID	*gr,
	float		*L,	/* Lower coord of clip box */
	float		*U,	/* upper coord of clip box */
	float		**Q)	/* Rotation matrix */
{
	INTERFACE	*zoom_intfc;

	DEBUG_ENTER(f_zoom_interface)
	zoom_intfc = i_zoom_interface(intfc,gr,L,U,Q);
	copy_rect_grid(computational_grid(intfc),gr);
	rotate_and_zoom_rect_grid(computational_grid(zoom_intfc),L,U,Q);
	DEBUG_LEAVE(f_zoom_interface)
	return zoom_intfc;
}		/*end f_zoom_interface*/

EXPORT	void	delete_subdomain_boundaries(
	INTERFACE	*intfc)
{

	DEBUG_ENTER(delete_subdomain_boundaries)
	switch (intfc->dim)
	{
#if defined(ONED)
	case 1:
	    {
	        POINT **p;
	        for (p = intfc->points; p && *p; ++p)
	        {
		    if (is_subdomain_boundary(Hyper_surf(*p)))
	            {
		        delete_point(*p);
		        if (intfc->points == NULL)
		            break;
		        p = intfc->points-1;
	            }
	        }
	    }
	    break;
#endif /* defined(ONED) */
#if defined(TWOD)
	case 2:
	    delete_subdomain_curves(intfc);
	    break;
#endif /* defined(TWOD) */
#if defined(THREED)
	case 3:/*TODO implement delete_subdomain_boundaries*/
	    break;
#endif /* defined(THREED) */
	}
	DEBUG_LEAVE(delete_subdomain_boundaries)
}		/*end delete_subdomain_boundaries*/


#if defined(CONSERVATIVE_ALG)

LOCAL void match_recv_with_sv(
        Front   *front)
{
        CURVE         **cc;
        G_Indx_Curve  *gc, *gcstart;
        G_Indx_Curve  *matchgc;
        float         min_sc_sep = MIN_SC_SEP(front->interf); 
        float         *h = computational_grid(front->interf)->h; 
        int           dim = front->interf->dim;

        for(cc = front->interf->curves; cc && *cc; cc++)
        {
            if(is_passive_boundary(Hyper_surf(*cc)) ||
               is_subdomain_boundary(Hyper_surf(*cc)) )
                continue;
            gc = front->interf->g_indx_curves;
            while(gc != NULL) 
            {
                gcstart = gc;
                gc = gc->next; 
                if(YES == sv_gcurve_match_c(*cc, gcstart, 
                       h, dim, min_sc_sep, &matchgc))
                {
                    /***
                    if(wave_type(*cc) >= FIRST_PHYSICS_WAVE_TYPE)
                    {
                        printf("Print saved gcurve\n"); 
                        prt_gcurve_indx(matchgc);
                        // print_curve(*cc); 
                    }
                    ***/
                    gcurve_set_c_indx(*cc,matchgc, h, dim, min_sc_sep); 
                }
            }  
        }

        /* 
        printf("AFTER match_recv_with_sv\n"); 
        printf("print unmatched pts\n"); 
        for(cc = front->interf->curves; cc && *cc; cc++)
        {
            if(wave_type(*cc) >= FIRST_PHYSICS_WAVE_TYPE)
                prt_pt_corresp_curve(*cc, YES);
        }
        printf("AFTER match_recv_with_sv "); 
        printf("END OF print unmatched pts\n"); 
        */
}

LOCAL void prt_gcurve_indx(
        G_Indx_Curve  *gcurve)
{
        int i;

        printf("G_Indx_Curve[%d] type [%d]\n", gcurve->curv_id, gcurve->wave_type); 
        for(i = 0; i < gcurve->num; i++)
        {
            printf("[%14.12f %14.12f] indx[%d] corresp_c[%d]\n",
              gcurve->Pt_indx[i].coords[0],
              gcurve->Pt_indx[i].coords[1],
              gcurve->Pt_indx[i].indx,
              gcurve->Pt_indx[i].curv_id);
        }
}

LOCAL void gcurve_set_c_indx(
        CURVE         *cc, 
        G_Indx_Curve  *gcurve,
        float         *h,
        int           dim,
        float         min_sc_sep)
{
        BOND          *b; 
        int           i;

        if(gcurve->curv_id != cc->curv_id)
            cc->curv_id = gcurve->curv_id;
        
        b = cc->first;
        if(b->start->indx == -100)
        {
            for(i = 0; i < gcurve->num; i++)
            {
                if(_scaled_separation(gcurve->Pt_indx[i].coords,
                     Coords(b->start),h,dim) < min_sc_sep*0.01)
                {
                    b->start->indx = gcurve->Pt_indx[i].indx; 
                    b->start->curv_id = gcurve->Pt_indx[i].curv_id; 
                    break; 
                }                   
            }        
        }

        while(b != NULL)
        {
            if(b->end->indx == -100)
            {
                for(i = 0; i < gcurve->num; i++)
                {
                    if(_scaled_separation(gcurve->Pt_indx[i].coords,
                         Coords(b->end),h,dim) < min_sc_sep*0.01)
                    {
                        b->end->indx = gcurve->Pt_indx[i].indx; 
                        b->end->curv_id = gcurve->Pt_indx[i].curv_id; 
                        break; 
                    }                   
                }        
            }
            b = b->next; 
        }
}

LOCAL int sv_gcurve_match_c(
        CURVE         *cc, 
        G_Indx_Curve  *gcurve, 
        float         *h,
        int           dim,
        float         min_sc_sep, 
        G_Indx_Curve  **matchgc)
{
        G_Indx_Curve  *gc; 
        BOND          *b;  
        int           i, num, nmatch; 

        *matchgc = NULL;  

        gc = gcurve;
        nmatch = 0; 
        if(gc->wave_type == wave_type(cc))
        {
            for(i = 0; i < gc->num; i++)
            {
                b = cc->first;
                if(b->start->indx == -100)
                {
                    if(_scaled_separation(gc->Pt_indx[i].coords,
                       Coords(b->start),h,dim) < min_sc_sep*0.01)
                    {
                        nmatch++;
                    }
                }
                while(b != NULL)
                {
                    if(b->end->indx == -100)
                    {
                        if(_scaled_separation(gc->Pt_indx[i].coords,
                           Coords(b->end),h,dim) < min_sc_sep*0.01)
                        {
                            nmatch++;
                            break;
                        }
                    }
                    b = b->next;
                }
            }
        }
        if(nmatch != 0)
            *matchgc = gc;  

        if(*matchgc != NULL)
            return YES;
        return NO; 
}

LOCAL void reset_scat_intfc_pt_indx(
        Front   *front)
{

        CURVE         **cc;
        BOND          *b, *bnxt, *ssetb, *esetb;
        int           frwd, bkwd;
        int           i, frnum, bknum;  
        int           repeat; 
        G_Indx_Curve  *gc, *gcstart;
        int           unset = YES; 
        int           num_curves = 0; 

        if(front->interf->g_indx_curves == NULL)
        {
            // TMP
            for(cc =  front->interf->curves; cc && *cc; cc++)
                num_curves++; 

            for(i =0, cc =  front->interf->curves; cc && *cc; cc++, i++)
            {
                if(wave_type(*cc) >= FIRST_PHYSICS_WAVE_TYPE && (*cc)->curv_id == -1)
                    (*cc)->curv_id = 100*num_curves + i; 
            }
            return;  
        }
        match_recv_with_sv(front); 

        if(front->interf->g_indx_curves != NULL)
        {
            gc = front->interf->g_indx_curves;
            while(gc != NULL)
            {
                gcstart = gc;
                gc = gc->next;
                free(gcstart->Pt_indx);
                free(gcstart);
            }
            front->interf->g_indx_curves = NULL;  
        }

        // TMP
        for(num_curves =0, cc =  front->interf->curves; cc && *cc; cc++)
            num_curves++; 
        for(i =0, cc =  front->interf->curves; cc && *cc; cc++, i++)
        {
            if(wave_type(*cc) >= FIRST_PHYSICS_WAVE_TYPE && (*cc)->curv_id == -1)
            {
                (*cc)->curv_id = 100*num_curves + i; 
                 printf("construct -1 curve in reset_scat_intfc_pt_indx\n");
                 print_curve(*cc);  
            }
        }
}

#endif /* if defined(CONSERVATIVE_ALG) */
