/*
*                       flocaldecs.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       Frontier 3D amr interpolation function calls.
*/

#if !defined(_FLOCALDECS_H)
#define _FLOCALDECS_H

#include <front/fdecs.h>

#if !defined(_FLOAT_EQUAL)
#define _FLOAT_EQUAL
#define float_equal(f1,f2)  (fabs((f1)-(f2)) < 1000.0*MACH_EPS)
#endif /* if !defined(_FLOAT_EQUAL) */

            /* Orignal from fscat2d.c */
/* The first six bits of the Boundary() field are reserved in int.h. */
#if defined(TWOD)
enum {
        CUT_NODE      = 0x0040,
        X_CUT_NODE    = 0x0080,
        CLIP_NODE     = 0x0100,
        LOCAL_NODE    = 0x0200,
        ADJ_BOND_NODE = 0x0400,
        NODE_MASK     = (CUT_NODE|X_CUT_NODE|CLIP_NODE|LOCAL_NODE|ADJ_BOND_NODE)
};

#define is_cut_node(n)                  (Boundary(n) & CUT_NODE)
#define is_x_cut_node(n)                (Boundary(n) & X_CUT_NODE)
#define is_clip_node(n)                 (Boundary(n) & CLIP_NODE)
#define is_local_node(n)                (Boundary(n) & LOCAL_NODE)
#define is_adj_bond_node(n)             (Boundary(n) & ADJ_BOND_NODE)

#define set_adj_bond_cross_node(n)      (Boundary(n) |= ADJ_BOND_NODE)
#define set_imported_node(n)            (Boundary(n) &= ~LOCAL_NODE)
#define clear_node_flags(n)             (Boundary(n) &= ~NODE_MASK)
#endif /* if defined(TWOD) */

          /* Orignal from fadv.c */
#if defined(TWOD)
#define is_bad_status(status)   (                                       \
                                ((status) == BIFURCATION_NODE) ||       \
                                ((status) == CROSS_PAST_CURVE_NODE) ||  \
                                ((status) == MODIFY_TIME_STEP_NODE) ||  \
                                ((status) == REPEAT_TIME_STEP_NODE) ||  \
                                ((status) == NO_CROSS_NODE) ||          \
                                ((status) == ERROR_NODE)                )
#endif /* if defined(TWOD) */

            /* fscat2d.c */
IMPORT  void    print_node_flags(NODE*);
IMPORT  float   sqr_separation(POINT*,POINT*,int);
IMPORT  bool    check_for_cut_nodes(char*,INTERFACE*);
IMPORT  POINT   *bond_crosses_cut_line(BOND*,int,float,int);
IMPORT  void    point_on_cut_line(INTERFACE*,POINT*,BOND*,float,int);
IMPORT  void    clip_to_interior_region(INTERFACE*,int*,int*);
IMPORT  bool    merge_interface(Front*,int);
IMPORT  void    copy_interface_into(INTERFACE*,INTERFACE*);
IMPORT  INTERFACE       *set_send_intfc(INTERFACE*,int,int,int*,int*);

           /* fadv.c */
IMPORT  INTERFACE  *pp_copy_interface(INTERFACE*);
IMPORT  void    set_propagation_limits(Front*,Front*);
IMPORT  int     return_advance_front(Front*,Front**,int,const char*);
#if defined(ONED) || defined(TWOD)
IMPORT  void    copy_hypersurface_flags(INTERFACE*);
#endif /* defined(ONED) || defined(TWOD) */

#if defined(TWOD)
IMPORT  void    reset_hs_flags_on_intfc(INTERFACE*);
IMPORT  void    set_node_doubly_linked_list(INTERFACE*);
IMPORT  void    set_corresponds_for_node_prop(INTERFACE*,INTERFACE*);
IMPORT  void    print_linked_node_list(INTERFACE*);
IMPORT  NODE    *adv_node_loop_after_good_prop(NODE*,NODE*,RPROBLEM**);
IMPORT  NODE    *reorder_node_loop(NODE*,NODE*);
IMPORT  bool    consistent_propagated_loop_orientations(float,float*,
                     Front*,POINTER);
IMPORT  int     rp_modify_time_step(RPROBLEM*,Front*,int);
IMPORT  float   limit_dt_frac(float,Front*);
IMPORT  int     node_modify_time_step(NODE*,Front*,float*,int);
#endif /* if defined(TWOD) */
#if defined(THREED)
IMPORT  void    propagate_surface_points(Front*,Front*,POINTER,float,float*);
IMPORT  void    propagate_curve_points(Front*,Front*,POINTER,float);
IMPORT  int     propagate_node_points(Front*,Front*,POINTER,float,float*);
#endif /* if defined(THREED) */

         /* fredist2d.c */
#if defined(TWOD)
IMPORT  INTERFACE    *make_save_intfc(INTERFACE*);
IMPORT  INTERFACE    *reset_interface_of_front(Front*,INTERFACE**);
#endif /* if defined(TWOD) */

        /* foverture_adv.c */
#if defined(USE_OVERTURE)
#if defined(TWOD)
IMPORT  int     normal_advance_front2d(float,float*,Front*,Front**,POINTER);
IMPORT  int     tangnt_advance_front2d(float,float*,Front*,Front**,POINTER);
IMPORT  int     redist_advance_front2d(float,float*,Front*,Front**,POINTER);
#endif /* if defined(TWOD) */
#if defined(THREED)
IMPORT  int     normal_advance_front3d(float,float*,Front*,Front**,POINTER);
IMPORT  int     tangnt_advance_front3d(float,float*,Front*,Front**,POINTER);
#endif /* if defined(THREED) */
#endif /* if defined(USE_OVERTURE) */

       /* fpatch.c */
#if defined(USE_OVERTURE)
IMPORT  int     set_copy_proc_frs_ver2(Front***,Front**,int,
		                      Wv_on_pc**,int);
IMPORT  void    clear_copy_frs(Front**,Wv_on_pc**,int);
IMPORT  bool    form_patch_subintfc_via_cut(Front*);
IMPORT  void    reinstall_undistribute_fronts_and_misc(Front**,Front**,
                   Wv_on_pc**,int,int,int);
/* IMPORT  void    delete_tmp_fronts_after_distr(Front**,Wv_on_pc**,int,int); */
#endif /* if defined(USE_OVERTURE) */

       /* fpatch2d.c */
#if defined(TWOD) 
#if defined(USE_OVERTURE)
IMPORT  void    delete_intfc_all_curves(INTERFACE*);
IMPORT  int     assembly_distribute_patch_fronts2d(Front**,int,Wv_on_pc**,
		                    int,int);
IMPORT  int     assembly_coarse_patch_fronts2d(Front**,int,Wv_on_pc**,int);
IMPORT  void    clip_patch_fronts_to_interior(Front**,int,COMPONENT*);
#endif /* if defined(USE_OVERTURE) */
#endif /* if defined(TWOD)  */

       /* fpatch3d.c */
#if defined(THREED) 
#if defined(USE_OVERTURE)
IMPORT  int     assembly_distribute_patch_fronts3d(Front**,int,Wv_on_pc**,
		                    int,int);
#endif /* if defined(USE_OVERTURE) */
#endif /* if defined(THREED)  */

       /* famrscat2d.c */
#if defined(TWOD)
#if defined(USE_OVERTURE)
IMPORT  int     scatter_patch_fronts2d(Front**,int,Wv_on_pc**,int,Overparam*,int);
#endif /* if defined(USE_OVERTURE) */
#endif /* if defined(TWOD)  */

#if !defined(SMOOTH_INTERFACE_FOR_SCATTER)
 #define  SMOOTH_INTERFACE_FOR_SCATTER
#endif /* if !defined(SMOOTH_INTERFACE_FOR_SCATTER) */

#if defined(SMOOTH_INTERFACE_FOR_SCATTER)
       /* freconst2d.c */
IMPORT  void    adjust_front_boundary_crxing_spacing(Front*); 
IMPORT  void    adjust_front_boundary_crxing_spacing_1(Front*); 
IMPORT  POINT   *bond_crosses_cut_segment(BOND*,int,int,float,float,float,float*);
#endif /* if defined(SMOOTH_INTERFACE_FOR_SCATTER) */

       /* fscat3d2.c */
#if defined(THREED) 
IMPORT  void      clip_intfc_at_grid_bdry2(INTERFACE*);
#endif /* if defined(THREED)  */
#endif /* if !defined(_FLOCALDECS_H) */

