/*
*				test_init.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains the driver initializing routines, as called in main,
*	and the principle or default initializing subroutines.
*/


#include <driver/ddecs.h>

#define Next_m4(n)              (((n) + 1) % 4)
#define Prev_m4(n)              (((n) + 3) % 4)

	/* LOCAL Function Declarations */
LOCAL   TRI    **read_input_easy_mesh(char*,Front*,int*);
LOCAL   TRI    **read_input_mesh(char*,Front*,int*);
LOCAL   char   *readline(char*,FILE*,char*);
LOCAL   char   *findfield(char *string);
LOCAL   void   comput_normal3d(float*,float*,float*,float*);
LOCAL   void   init_true_diag_triangle_gas_sine(Front*);
LOCAL   int    tris_share_edge(TRI*,TRI*);
// LOCAL   void   attach_buffer_tris(Front*);
// LOCAL   void   clip_tris_to_subdomain(Front*);
// LOCAL   bool   tri_out_rect(TRI*,float*,float*);
LOCAL   void   remove_out_rect_tri(TRI*,SURFACE*);
LOCAL   void   tmp_remove_tri_from_surface(TRI*,SURFACE*);






LOCAL char *readline(
	char *string, 
	FILE *infile, 
	char *infilename)
{
  char *result;

  do {
    result = fgets(string, 1024, infile);
    if (result == (char *) NULL) 
    {
      printf("  Error:  Unexpected end of file in %s.\n",
             infilename);
      clean_up(ERROR);
    }
    while ((*result != '\0') && (*result != '#')
           && (*result != '.') && (*result != '+') && (*result != '-')
           && ((*result < '0') || (*result > '9'))) 
    {
      result++;
    }
  } while ((*result == '#') || (*result == '\0'));
  return result;
}

LOCAL char *findfield(char *string)
{
  char *result;
  result = string;
  while ((*result != '\0') && (*result != '#')
         && (*result != ' ') && (*result != '\t')) {
    result++;
  }
  while ((*result != '\0') && (*result != '#')
         && (*result != '.') && (*result != '+') && (*result != '-')
         && ((*result < '0') || (*result > '9'))) {
    result++;
  }
  if (*result == '#') {
    *result = '\0';
  }
  return result;
}

LOCAL TRI **read_input_mesh(
	char    *name,
	Front   *fr,
        int     *tri_num)
{
	FILE    *fp[7];
	char    outname[7][256];
	int     n_node = 0, i, nodenumber, j, dim = 2;
        int     n_tri, **tri_node, **neigh;
        float   **crds_node, coords[3];
	char    inputline[1024];
        char    *stringptr; 

        TRI        **tri, *tmptri;
        POINT      **p, *pt[4], *tmpp[3];
        INTERFACE  *cur_intfc;
        bool       sav_copy;
        SURFACE    *s;
        float      nor[3];
        int        side;

	sprintf(outname[0],"Mesh/%s.1.node",name);
	sprintf(outname[1],"Mesh/%s.1.ele",name);
	sprintf(outname[2],"Mesh/%s.1.neigh",name);

        if ((fp[0] = fopen(outname[0],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[0]); 
            clean_up(ERROR);
        } 

        if ((fp[1] = fopen(outname[1],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[1]); 
            clean_up(ERROR);
        } 
        
        if ((fp[2] = fopen(outname[2],"r")) == NULL)
        {
            printf("ERROR: read_input_mesh, can not find %s\n",
               outname[2]);
            clean_up(ERROR);
        }


	fscanf(fp[0],"%d %*d %*d %*d\n",&n_node);

        matrix(&crds_node,n_node,dim,sizeof(float));

        printf("TRI n_node = %d\n", n_node);

        for(i = 0; i < n_node; i++)
        {
            stringptr = readline(inputline, fp[0], outname[0]);

            // printf("string %s\n", stringptr);
            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < dim; j++) 
	    {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0') 
                {
                   printf("Error:  Point %d is missing a coordinate in %s.\n",
                     i+1, outname[0]);
                   clean_up(ERROR);
                }
                crds_node[i][j] = (float) strtod(stringptr, &stringptr);
            }
            // printf("node[%d] crds %g %g\n", i+1, crds[0], crds[1]);
        }

        fscanf(fp[1],"%d %*d %*d\n",&n_tri);       

        printf("TRI number = %d\n", n_tri);

        matrix(&tri_node,n_tri,3,sizeof(float));
        matrix(&neigh,n_tri,3,sizeof(float));

        for(i = 0; i < n_tri; i++)
        {
            stringptr = readline(inputline, fp[1], outname[1]);

            // printf("string %s\n", stringptr);
            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                tri_node[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // printf("tri[%d] node[%d %d %d]\n", i+1, tri_node[i][0], tri_node[i][1], tri_node[i][2]);
        }

        fscanf(fp[2],"%*d %*d\n");       
        for(i = 0; i < n_tri; i++)
        {
            fscanf(fp[2],"%*d %d %d %d\n", &neigh[i][0], &neigh[i][1], &neigh[i][2]);  
            // printf("tri[%d] neighbr[%d %d %d]\n", i+1, neigh[i][0], neigh[i][1], neigh[i][2]);
        }

        ////////////////////
        // make_tris
        ////////////////////
        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(fr->interf));
        set_copy_intfc_states(YES);

        if(NULL == (fr->mesh = copy_interface(fr->interf)))
        {
            printf("ERROR make_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(fr->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);
 
        set_alloc_mass_storage_flag(YES);

        s = i_make_surface(2,3,NULL,NULL);

        vector(&p, n_node,sizeof(POINT *));
        vector(&tri, n_tri, sizeof(TRI *));

        for(i = 0; i < n_node; i++)
        {
            coords[0] = crds_node[i][0];
            coords[1] = crds_node[i][1];
            coords[2] = 0.0;
            p[i] = Point(coords);
        }
    
        // triangle pt is COUNTER_CLOCK oriented.
        for(i = 0; i < n_tri; i++)
        {
            pt[0] = p[tri_node[i][0]-1];
            pt[1] = p[tri_node[i][1]-1];
            pt[2] = p[tri_node[i][2]-1];

            comput_normal3d(Coords(pt[0]), Coords(pt[1]), Coords(pt[2]), nor);
            if(nor[2] > 0.0)
            {
                tri[i] = i_make_tri(pt[0],pt[1],pt[2],
                                 NULL,NULL,NULL,YES);
                tri[i]->id = i;
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Lmass_matrix);
                // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                inverse_matrix(tri[i]->Lmass_matrix,MAX_N_COEF,tri[i]->mass_inv);
            }
            else
            {
               tri[i] = i_make_tri(pt[0],pt[2],pt[1],
                                 NULL,NULL,NULL,YES);
               printf("ERROR: CLOCK-wise tri created\n");
               clean_up(ERROR);
            }
            insert_tri_at_tail_of_list(tri[i],s);

            // TMP
            /**
            printf("print tri[%d] coords:\n", i);
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
            **/ 
        }

        s->num_tri = n_tri;

        // Set tri neighbr
        // The first neighbor of triangle i is opposite the first corner of triangle i, and so on.
        for(i = 0; i < n_tri; i++)
        {
            set_01_bdry(Boundary_tri(tri[i]),NO);
            set_12_bdry(Boundary_tri(tri[i]),NO);
            set_20_bdry(Boundary_tri(tri[i]),NO);

            for(j = 0; j < 3; j++)
            {
                side = (j+1)%3;
                if(neigh[i][j] != -1)
                {
                    Tri_on_side(tri[i], side) = tri[neigh[i][j]-1];  
                    if(tris_share_edge(tri[i], tri[neigh[i][j]-1]) == NO)
                    {
                        printf("ERROR: tris do not share edge\n");
                        clean_up(ERROR); 
                    }

                    /**
                    printf("tri[%d] side[%d] is tri[%d]\n", 
                           i+1, (j+1)%3, neigh[i][j]);
                    printf("print tri[%d] coords:\n", i+1);
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
                    printf("print neigh tri[%d] coords:\n", neigh[i][j]);
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[0]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[1]), dim, "\n");
                    print_general_vector("Tri_pt", Coords(Point_of_tri(tri[neigh[i][j]-1])[2]), dim, "\n\n");
                    **/
                }
                else
                {
                    // Boundary_tri(tri[i]) = YES;
                    set_side_bdry(Boundary_tri(tri[i]),side,YES);
                }
            } 

            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
            
            // if(i == 2)
            //     printf("tri[%d] is boundary tri %d, neigh[%d %d %d]\n", 
            //          i, Boundary_tri(tri[i]), neigh[i][0], neigh[i][1], neigh[i][2]);    
             
        }

        free(crds_node);
        free(tri_node); free(neigh);
        free(p); 

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        // NEW
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

#if !defined(_MPI_)
        output_tri_mesh("visual",0,fr->mesh);
#endif // if !defined(_MPI_)

        fclose(fp[0]);
        fclose(fp[1]);
        fclose(fp[2]);

        *tri_num = n_tri;
        return tri;
}

LOCAL TRI **read_input_easy_mesh(
        char    *name,
        Front   *fr,
        int     *tri_num)
{
        FILE    *fp[7];
        char    outname[7][256];
        int     n_node = 0, i, nodenumber, j, dim = 2;
        int     n_tri, **tri_node, **neigh;
        float   **crds_node, coords[3];
        char    inputline[1024];
        char    *stringptr;

        TRI        **tri, *tmptri;
        POINT      **p, *pt[4], *tmpp[3];
        INTERFACE  *cur_intfc;
        bool       sav_copy;
        SURFACE    *s;
        float      nor[3];
        int        side;

        sprintf(outname[0],"Mesh/%s.n",name);
        sprintf(outname[1],"Mesh/%s.e",name);
        sprintf(outname[2],"Mesh/%s.s",name);

        if ((fp[0] = fopen(outname[0],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[0]);
            clean_up(ERROR);
        }
        if ((fp[1] = fopen(outname[1],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[1]);
            clean_up(ERROR);
        }
        if ((fp[2] = fopen(outname[2],"r")) == NULL)
        {
            printf("ERROR: read_input_easy_mesh, can not find %s\n",
               outname[2]);
            clean_up(ERROR);
        }

        fscanf(fp[0],"%d\n",&n_node);
        matrix(&crds_node,n_node,dim,sizeof(float));
        printf("TRI n_node = %d\n", n_node);

        for(i = 0; i < n_node; i++)
        {
            stringptr = readline(inputline, fp[0], outname[0]);
            // printf("print read string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < dim; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Point %d is missing a coordinate in %s.\n",
                     i+1, outname[0]);
                   clean_up(ERROR);
                }
                crds_node[i][j] = (float) strtod(stringptr, &stringptr);
            }
            // printf("node[%d] crds %g %g\n", i+1, crds_node[i][0], crds_node[i][1]);
            // clean_up(0);
        }

        fscanf(fp[1],"%d\n",&n_tri);
        printf("TRI number = %d\n", n_tri);

        matrix(&tri_node,n_tri,3,sizeof(float));
        matrix(&neigh,n_tri,3,sizeof(float));

        for(i = 0; i < n_tri; i++)
        {
            stringptr = readline(inputline, fp[1], outname[1]);
            // printf("string: %s\n", stringptr);

            nodenumber = (int) strtol (stringptr, &stringptr, 0);
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                tri_node[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // NEW, easy_mesh
            for (j = 0; j < 3; j++)
            {
                stringptr = findfield(stringptr);
                if (*stringptr == '\0')
                {
                   printf("Error:  Triangle %d is missing a corner in %s.\n",
                     i+1, outname[1]);
                   clean_up(ERROR);
                }
                neigh[i][j] = strtol(stringptr, &stringptr, 0);
            }
            // printf("tri[%d] node[%d %d %d], neigh[%d %d %d]\n",
            //         i+1, tri_node[i][0], tri_node[i][1], tri_node[i][2], neigh[i][0], neigh[i][1], neigh[i][2]);
            // clean_up(0);
        }
        /**
        fscanf(fp[2],"%*d %*d\n");
        for(i = 0; i < n_tri; i++)
        {
            fscanf(fp[2],"%*d %d %d %d\n", &neigh[i][0], &neigh[i][1], &neigh[i][2]);
            // printf("tri[%d] neighbr[%d %d %d]\n", i+1, neigh[i][0], neigh[i][1], neigh[i][2]);
        }
        **/

        ////////////////////
        // make_tris
        ////////////////////
        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(fr->interf));
        set_copy_intfc_states(YES);

        if(NULL == (fr->mesh = copy_interface(fr->interf)))
        {
            printf("ERROR make_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(fr->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);

        s = i_make_surface(2,3,NULL,NULL);

        vector(&p, n_node,sizeof(POINT *));
        vector(&tri, n_tri, sizeof(TRI *));

        for(i = 0; i < n_node; i++)
        {
            coords[0] = crds_node[i][0];
            coords[1] = crds_node[i][1];
            coords[2] = 0.0;
            p[i] = Point(coords);
        }

        // triangle pt is COUNTER_CLOCK oriented.
        for(i = 0; i < n_tri; i++)
        {
            pt[0] = p[tri_node[i][0]];
            pt[1] = p[tri_node[i][1]];
            pt[2] = p[tri_node[i][2]];

            comput_normal3d(Coords(pt[0]), Coords(pt[1]), Coords(pt[2]), nor);
            if(nor[2] > 0.0)
            {
                tri[i] = i_make_tri(pt[0],pt[1],pt[2],
                                 NULL,NULL,NULL,YES);
                tri[i]->id = i;
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[i],2,tri[i]->Lmass_matrix);
                // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                inverse_matrix(tri[i]->Lmass_matrix,MAX_N_COEF,tri[i]->mass_inv);
            }
            else
            {
               tri[i] = i_make_tri(pt[0],pt[2],pt[1],
                                 NULL,NULL,NULL,YES);
               printf("ERROR: CLOCK-wise tri created\n");
               clean_up(ERROR);
            }
            insert_tri_at_tail_of_list(tri[i],s);
            /**
            printf("print tri[%d] coords:\n", i);
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n");
            **/
        }
        s->num_tri = n_tri;

        // Set tri neighbr
        // The first neighbor of triangle i is opposite the first corner of triangle i, and so on.
        for(i = 0; i < n_tri; i++)
        {
            set_01_bdry(Boundary_tri(tri[i]),NO);
            set_12_bdry(Boundary_tri(tri[i]),NO);
            set_20_bdry(Boundary_tri(tri[i]),NO);

            for(j = 0; j < 3; j++)
            {
                side = (j+1)%3;
                if(neigh[i][j] != -1)
                {
                    // Tri_on_side(tri[i], side) = tri[neigh[i][j]-1];
                    Tri_on_side(tri[i], side) = tri[neigh[i][j]];
                    // if(tris_share_edge(tri[i], tri[neigh[i][j]-1]) == NO)
                    if(tris_share_edge(tri[i], tri[neigh[i][j]]) == NO)
                    {
                        printf("ERROR: tris do not share edge\n");
                        clean_up(ERROR);
                    }
                }
                else
                {
                    // Boundary_tri(tri[i]) = YES;
                    set_side_bdry(Boundary_tri(tri[i]),side,YES);
                }
            }

            if(neigh[i][0] != -1 && neigh[i][1] != -1 && neigh[i][2] != -1)
            {
                Boundary_tri(tri[i]) = NO;
            }
        }

        free(crds_node);
        free(tri_node); free(neigh);
        free(p);

        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        // NEW
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

#if !defined(_MPI_)
        output_tri_mesh("visual",0,fr->mesh);
#endif // if !defined(_MPI_)

        fclose(fp[0]);
        fclose(fp[1]);
        fclose(fp[2]);

        *tri_num = n_tri;

        // printf("EXIT in read_input_easy_mesh\n");
        // exit(0);
        return tri;
}

LOCAL void comput_normal3d(
	float *p0,
        float *p1,
        float *p2,
        float *n)
{
        float s[3][3], ns;
        int   i;

        for(i = 0; i < 3; i++)
        {
            s[0][i] = p1[i] - p0[i];
            s[1][i] = p2[i] - p1[i];
            s[2][i] = p0[i] - p2[i]; 
        }

        n[0] = s[2][1]*s[0][2] - s[2][2]*s[0][1];
        n[1] = s[2][2]*s[0][0] - s[2][0]*s[0][2];
        n[2] = s[2][0]*s[0][1] - s[2][1]*s[0][0];
}


EXPORT void  init_db_Mach_mesh(
	char  *name,
        Front *fr)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2;
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        tri = read_input_easy_mesh(name, fr, &n_tri);
	// tri = read_input_mesh(name, fr, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
            if(Boundary_tri(tri[i]))
            {
                for(side = 0; side < 3; side++)
                {
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        /**
                        if(i == 2)
                        { 
                            printf("print tri[%d] side[%d] boundary:\n", i, side);
                            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[0]), dim, "\n");
                            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[1]), dim, "\n");
                            print_general_vector("Tri_pt", Coords(Point_of_tri(tri[i])[2]), dim, "\n\n");
                            debug_flag = YES;
                        }
                        else
                            debug_flag = NO;
                        **/ 
                           
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];                        

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        
                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side 
                            p[0] = Point_of_tri(tri[i])[side];
                            p[1] = Point_of_tri(tri[i])[(side+1)%3];
                            crds[1] = (Coords(p[0])[1] + Coords(p[1])[1])/2.0;
                            if(crds[1] > 0.16666666666667)
                                fg_e_type(tri[i])[side] = NEUMANN;
                            else
                                fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = CONST_P;
                            tri[i]->BC_type = IN_FLOW; // need

                            if(debug_flag == YES)
                            {
                                printf("tri[%d] side [%d], edge type = %d\n",
                                      i, side, CONST_P);
                            }
                        }
                    }
                }
            }
        }

        free(tri);
}

EXPORT void  init_shock_vort_mesh(
	char  *name,
        Front *fr)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2;
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

	tri = read_input_mesh(name, fr, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
            if(Boundary_tri(tri[i]))
            {
                for(side = 0; side < 3; side++)
                {
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];                        

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        
                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side 
                            // fg_e_type(tri[i])[side] = NEUMANN;
                            // tri[i]->BC_type = OUT_FLOW; // No need since the buffer will be attached
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            // fg_e_type(tri[i])[side] = NEUMANN;
                            // tri[i]->BC_type = IN_FLOW; // No need since the buffer will be attached
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                }
            }
        }

        free(tri);
}


// Split triangles with the rect. diagnoal
// Periodic BC on both sides
EXPORT void init_diag_triangle_vortex_evo(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_diag_triangle_vortex_evo\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,2,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                tri[ix][iy][0] = i_make_tri(pt[0],pt[2],pt[3],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][0]->mass_inv);
                tri[ix][iy][0]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][0],s);

                tri[ix][iy][1] = i_make_tri(pt[0],pt[1],pt[2],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][1]->mass_inv);
                tri[ix][iy][1]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][1],s);

                // TMP
                // print_tri(tri[ix][iy][0],intfc);
                // print_tri(tri[ix][iy][1],intfc);
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                Boundary_tri(tri[ix][iy][0]) = NO;
                Boundary_tri(tri[ix][iy][1]) = NO;

                if (iy != 0)
                {
                    // south
                    Tri_on_side01(tri[ix][iy][1]) = tri[ix][iy-1][0];
                    // TMP
                    // print_tri(tri[ix][iy][0],intfc);
                }
                if(ix !=(imax-1))
                {
                    // east
                    Tri_on_side12(tri[ix][iy][1]) = tri[ix+1][iy][0];
                }
                if(iy !=(jmax-1))
                {
                    // north
                    Tri_on_side12(tri[ix][iy][0]) = tri[ix][iy+1][1];
                }
                if(ix != 0)
                {
                    // west
                    Tri_on_side20(tri[ix][iy][0]) = tri[ix-1][iy][1];
                }
                Tri_on_side01(tri[ix][iy][0]) = tri[ix][iy][1];
                Tri_on_side20(tri[ix][iy][1]) = tri[ix][iy][0];
            }
        }

        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 2; i++)
                {
                    if(iy == 0 && i == 1)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }

                    if(iy == jmax-1 && i == 0)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[1] = SUBDOMAIN;
                    }
                    if(ix == 0 && i == 0)
                    {
                        set_20_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[2] = SUBDOMAIN;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = SUBDOMAIN;
                        fg_e_type(tri[ix][iy][i])[1] = SUBDOMAIN;
                    }
                }
            }
        }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                 tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);
            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {   
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // num_tri++;
        }
        s->num_tri = num_tri;
        // TMP
        // printf("num_tri = %d\n", num_tri);

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

        // printf("EXIT **** Leaving init_diag_triangle_vortex_evo\n");
        // clean_up(0);
}


// Split triangles with the rect. two diagnoals
// Periodic BC on both sides
EXPORT void init_triangle_vortex_evo(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_triangle_vortex_evo\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,4,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                for (i = 0; i < 3; i++)
                    coords[i] = 0.5*(Coords(pt[0])[i]+ Coords(pt[2])[i]);
                midp = Point(coords);

                for (i = 0; i < 4; i++)
                {
                    ip1 = (orient == COUNTER_CLOCK) ? i : Next_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Next_m4(i): i;
                    tri[ix][iy][i] = i_make_tri(pt[ip1],pt[ip2],midp,
                                              NULL,NULL,NULL,YES);
                    // new, compute mass_matrix and inverse on tri
                    comp_mass_matrix(MAX_N_COEF,tri[ix][iy][i],2,tri[ix][iy][i]->Lmass_matrix);
                    // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                    inverse_matrix(tri[ix][iy][i]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][i]->mass_inv);
                    tri[ix][iy][i]->id = num_tri;
                    num_tri++;

                    insert_tri_at_tail_of_list(tri[ix][iy][i],s);
                }
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);

                    if ((i == 0) && (iy != 0))
                    {
                        /* south */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy-1][2];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 1) && ix !=(imax-1))
                    {
                        /* east */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix+1][iy][3];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 2) && iy !=(jmax-1))
                    {
                        /* north */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy+1][0];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    else if ((i == 3) && ix !=0)
                    {
                        /* west */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix-1][iy][1];
                        Boundary_tri(tri[ix][iy][i]) = NO;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    }
                    ip1 = (orient == COUNTER_CLOCK) ? Next_m4(i): Prev_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Prev_m4(i): Next_m4(i);
                    Tri_on_side12(tri[ix][iy][i]) = tri[ix][iy][ip1];
                    Tri_on_side20(tri[ix][iy][i]) = tri[ix][iy][ip2];
                    set_12_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                    set_20_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                }
            }
        }

        /* set tri neighbors */  
            for (iy = 0; iy < jmax; iy++)
            {
                for (ix = 0; ix < imax; ix++)
                {
                    for (i = 0; i < 4; i++)
                    {
                        // set_01_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        // set_12_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        // set_20_bdry(Boundary_tri(tri[ix][iy][i]),NO);
                        if(iy == 0 && i == 0)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                            // tri[ix][iy][i]->BC_type = IN_FLOW;
                            // printf("bottom side boundary tri\n");
                            // print_tri(tri[ix][iy][i],front->interf);
                        }

                        if(iy == jmax-1 && i == 2)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;

                            // printf("top side side boundary tri\n");
                            // print_tri(tri[ix][iy][i],front->interf);
                        }
                        if(ix == 0 && i == 3)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                        }
                        if(ix == imax -1 && i == 1)
                        {
                            // Boundary_tri(tri[ix][iy][i]) = YES;
                            set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                            tri[ix][iy][i]->BC_type = SUBDOMAIN;
                            fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                        }
                    }
                }
            }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                 tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);
            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // num_tri++;
        }
        s->num_tri = num_tri;

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

}


// x direction, REflection BC,
// Top and bottom: Flow through
EXPORT void init_shock_vortex(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        TRI       *nbtri[3];
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3, dim = 2;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR init_shock_vortex\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_shock_vortex\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,4,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        num_tri = 0;
        /* make triangles */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {

                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                for (i = 0; i < 3; i++)
                    coords[i] = 0.5*(Coords(pt[0])[i]+ Coords(pt[2])[i]);
                midp = Point(coords);

                for (i = 0; i < 4; i++)
                {
                    ip1 = (orient == COUNTER_CLOCK) ? i : Next_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Next_m4(i): i;
                    tri[ix][iy][i] = i_make_tri(pt[ip1],pt[ip2],midp,
                                              NULL,NULL,NULL,YES);
                    tri[ix][iy][i]->id = num_tri;
                    num_tri++;
                    // new, compute mass_matrix and inverse on tri
                    comp_mass_matrix(MAX_N_COEF,tri[ix][iy][i],2,tri[ix][iy][i]->Lmass_matrix);
                    // matrix_inv(Lmass_matrix,MAX_N_COEF,mass_inv);
                    inverse_matrix(tri[ix][iy][i]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][i]->mass_inv);

                    insert_tri_at_tail_of_list(tri[ix][iy][i],s);
                }
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    Boundary_tri(tri[ix][iy][i]) = NO;

                    if ((i == 0) && (iy != 0))
                    {
                        /* south */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy-1][2];
                    }
                    else if ((i == 1) && ix !=(imax-1))
                    {
                        /* east */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix+1][iy][3];
                    }
                    else if ((i == 2) && iy !=(jmax-1))
                    {
                        /* north */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix][iy+1][0];
                    }
                    else if ((i == 3) && ix !=0)
                    {
                        /* west */
                        Tri_on_side01(tri[ix][iy][i]) = tri[ix-1][iy][1];
                    }
                    ip1 = (orient == COUNTER_CLOCK) ? Next_m4(i): Prev_m4(i);
                    ip2 = (orient == COUNTER_CLOCK) ? Prev_m4(i): Next_m4(i);
                    Tri_on_side12(tri[ix][iy][i]) = tri[ix][iy][ip1];
                    Tri_on_side20(tri[ix][iy][i]) = tri[ix][iy][ip2];
                }
            }
        }

        // set boundary tris
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 4; i++)
                {
                    if(iy == 0 && i == 0)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = IN_FLOW;
                    }

                    if(iy == jmax-1 && i == 2)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = OUT_FLOW;
                    }
                    if(ix == 0 && i == 3)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        Boundary_tri(tri[ix][iy][i]) = YES;
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        fg_e_type(tri[ix][iy][i])[0] = SUBDOMAIN;
                    }
                }
            }
        }

        for (tmptri = first_tri(s); !at_end_of_tri_list(tmptri,s);
                                                   tmptri = tmptri->next)
        {
            cent = fg_centroid(tmptri);

            if((L[0] < cent[0] && L[1] < cent[1] &&
                U[1] > cent[1] && U[0] > cent[0])
              )
            {
                // print_tri(tmptri,front->mesh);
                NULL;
            }
            else
                tmptri->BC_type = SUBDOMAIN;
            // print_tri(tmptri,intfc);
        }
        s->num_tri = num_tri;
        // TMP
        // printf("num_tri = %d\n", num_tri);

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

        printf("**** Leaving init_shock_vortex\n");
        // clean_up(0);
}

// Split triangles with the rect. diagnoal
// EXACT BC on both sides
LOCAL void init_true_diag_triangle_gas_sine(
        Front           *front)
{
        RECT_GRID   *gr = front->rect_grid;
        HYPER_SURF          *hstmp;
        HYPER_SURF_ELEMENT  *hse;
        INTERFACE           *intfc = front->interf;
        SURFACE             *s;
        float               *L = gr->L;
        float               *U = gr->U;
        int                 i, iy, ix, num_tri = 0;
        TRI       ****tri, *tmptri;
        POINT     ***p, *pt[4], *midp, *corner;
        int       imax, jmax, ip1, ip2, ip3;
        float     coords[MAXD], nor[MAXD] = {0.0, 0.0, 1.0};
        ANGLE_DIRECTION orient;
        INTERFACE       *cur_intfc;
        bool            sav_copy;
        double     *cent;

        cur_intfc = current_interface();
        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(front->interf));
        set_copy_intfc_states(YES);

        if(NULL == (front->mesh = copy_interface(front->interf)))
        {
            printf("ERROR make_diag_triangle_surface\n");
            printf("copy interface failed\n");
            clean_up(ERROR);
        }

        set_current_interface(front->mesh);

        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(front->sizest);
        set_alloc_mass_storage_flag(YES);

        printf("Enter init_diag_triangle_gas_sine\n");
        print_rectangular_grid(gr);

        s = i_make_surface(2,3,NULL,NULL);

        imax = gr->gmax[0]+gr->lbuf[0]+gr->ubuf[0];
        jmax = gr->gmax[1]+gr->lbuf[1]+gr->ubuf[1];

        matrix(&p,imax+1,jmax+1,sizeof(POINT *));
        tri_array(&tri,imax,jmax,2,sizeof(TRI *));

        for (iy = 0; iy <= jmax; iy++)
        {
            for (ix = 0; ix <= imax; ix++)
            {
                coords[0] = vd_cell_edge(ix,0,gr);
                coords[1] = vd_cell_edge(iy,1,gr);
                coords[2] = 0.0;
                p[ix][iy] = Point(coords);
            }
        }
        orient = COUNTER_CLOCK;

        /* make triangles */
        num_tri = 0;
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                pt[0] = p[ix][iy];
                pt[1] = p[ix+1][iy];
                pt[2] = p[ix+1][iy+1];
                pt[3] = p[ix][iy+1];

                tri[ix][iy][0] = i_make_tri(pt[0],pt[2],pt[3],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][0],2,tri[ix][iy][0]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][0]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][0]->mass_inv);
                tri[ix][iy][0]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][0],s);

                tri[ix][iy][1] = i_make_tri(pt[0],pt[1],pt[2],
                                          NULL,NULL,NULL,YES);
                // new, compute mass_matrix and inverse on tri
                comp_mass_matrix(MAX_N_COEF,tri[ix][iy][1],2,tri[ix][iy][1]->Lmass_matrix);
                inverse_matrix(tri[ix][iy][1]->Lmass_matrix,MAX_N_COEF,tri[ix][iy][1]->mass_inv);
                tri[ix][iy][1]->id = num_tri;
                num_tri++;

                insert_tri_at_tail_of_list(tri[ix][iy][1],s);

                // TMP
                // print_tri(tri[ix][iy][0],intfc);
                // print_tri(tri[ix][iy][1],intfc);
            }
        }

        /* set tri neighbors */
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                Boundary_tri(tri[ix][iy][0]) = NO;
                Boundary_tri(tri[ix][iy][1]) = NO;

                if (iy != 0)
                {
                    // south
                    Tri_on_side01(tri[ix][iy][1]) = tri[ix][iy-1][0];
                    // TMP
                    // print_tri(tri[ix][iy][0],intfc);
                }
                if(ix !=(imax-1))
                {
                    // east
                    Tri_on_side12(tri[ix][iy][1]) = tri[ix+1][iy][0];
                }
                if(iy !=(jmax-1))
                {
                    // north
                    Tri_on_side12(tri[ix][iy][0]) = tri[ix][iy+1][1];
                }
                if(ix != 0)
                {
                    // west
                    Tri_on_side20(tri[ix][iy][0]) = tri[ix-1][iy][1];
                }
                Tri_on_side01(tri[ix][iy][0]) = tri[ix][iy][1];
                Tri_on_side20(tri[ix][iy][1]) = tri[ix][iy][0];
            }
        }

        // set boundary type
        // actually, exact BC is imposed
        for (iy = 0; iy < jmax; iy++)
        {
            for (ix = 0; ix < imax; ix++)
            {
                for (i = 0; i < 2; i++)
                {
                    if(iy == 0 && i == 1)
                    {
                        set_01_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[0] = IN_FLOW;
                    }

                    if(iy == jmax-1 && i == 0)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[1] = OUT_FLOW;
                    }
                    if(ix == 0 && i == 0)
                    {
                        set_20_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = IN_FLOW;
                        fg_e_type(tri[ix][iy][i])[2] = IN_FLOW;
                    }
                    if(ix == imax-1 && i == 1)
                    {
                        set_12_bdry(Boundary_tri(tri[ix][iy][i]),YES);
                        tri[ix][iy][i]->BC_type = OUT_FLOW;
                        fg_e_type(tri[ix][iy][i])[1] = OUT_FLOW;
                    }
                }
            }
        }

        s->num_tri = num_tri;

        free(p);
        free(tri);
        set_current_interface(cur_intfc);
        set_copy_intfc_states(sav_copy);

        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);

}

EXPORT void init_diag_triangle_gas_sine(
        char   *fname,
	Front  *front)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2;
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        // return init_true_diag_triangle_gas_sine(front);
        tri = read_input_easy_mesh(fname, front, &n_tri);
        // tri = read_input_mesh(fname, front, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
            if(Boundary_tri(tri[i]))
            {

                // print_tri_crds(tri[i]);

                for(side = 0; side < 3; side++)
                {
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];

                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);

                        // if(debug_flag == YES)
                        //     printf("Normal vec[%g %g] ans %g\n", nor[0], nor[1], ans);

                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                }
            }
        }

        free(tri);
}

EXPORT void init_tri_shock_vortex(
        char   *fname,
        Front  *front)
{
        TRI     **tri;
        int     n_tri, i, side, j, dim = 2;
        float   nor[3], t[3];
        float   dirx[2] = {1.0, 0.0}, ans;
        POINT   *p[3];
        float   crds[MAXD];
        int     debug_flag = NO;

        // return init_shock_vortex(front);
        tri = read_input_easy_mesh(fname, front, &n_tri);
        // tri = read_input_mesh(fname, front, &n_tri);

        for(i = 0; i < n_tri; i++)
        {
            if(Boundary_tri(tri[i]))
            {
                for(side = 0; side < 3; side++)
                {
                    if(Tri_on_side(tri[i], side) == NULL)
                    {
                        for(j = 0; j < dim; j++)
                            t[j] = fg_side_vector(tri[i])[side][j];
                        nor[0] = t[1];
                        nor[1] = -t[0];
                        ans = fabs(nor[0]*dirx[0] + nor[1]*dirx[1]);
                        if(ans > 0.5 && nor[0] > 0.5)
                        {
                            // right side
                            fg_e_type(tri[i])[side] = SUBDOMAIN;
                            // tri[i]->BC_type = OUT_FLOW; // need for bdry_tri_adv_fw()
                        }
                        else if(ans > 0.5 && nor[0] < -0.5)
                        {
                            // left side
                            fg_e_type(tri[i])[side] = SUBDOMAIN;
                            // tri[i]->BC_type = IN_FLOW; // need
                        }
                        else if(ans < 0.5 && nor[1] > 0.5)
                        {
                            // top side
                            fg_e_type(tri[i])[side] = OUT_FLOW;
                            tri[i]->BC_type = OUT_FLOW; // need
                        }
                        else
                        {
                            // bottom side
                            fg_e_type(tri[i])[side] = IN_FLOW;
                            tri[i]->BC_type = IN_FLOW; // need
                        }
                    }
                }
            }
        }

        free(tri);
}

LOCAL int tris_share_edge(
	TRI *tri1,
        TRI *tri2)
{

        int i, j, same =0;
        POINT *p1[3], *p2[3];

        for(i = 0; i < 3; i++)
        {
            p1[i] = Point_of_tri(tri1)[i];
            p2[i] = Point_of_tri(tri2)[i];
        }
        
        for(i = 0; i < 3; i++)
        {
            for(j = 0; j < 3; j++)
            {
                if(p1[i] == p2[j])
                {
                    same++;
                    break;
                }
            }    
        } 

        if(same == 2)
            return YES;
        else 
            return NO;
}


EXPORT void attach_buffer_tris(
	Front *fr)
{
	INTERFACE  *current_intfc, *mesh;
        TRI       *tri, *crsp_tri, *nbtri[3], **tris, **row_tris[20];
        SURFACE   **surf;
        int       side, i, j, dim = 2;
        float     nor[MAXD], t[MAXD], coords[3], u, crds[3];
        POINT     *gp, *p[3];
        int       N_alloc = 500, N_row, N_use =0, N;

        current_intfc = current_interface();
        set_current_interface(fr->mesh);
        i_set_tri_storage_type(FULL_TRI_GEOMETRY);
        i_set_size_of_intfc_state(fr->sizest);

        set_alloc_mass_storage_flag(YES);
        set_comput_tri_geom_flag(YES);

        vector(&tris, N_alloc, sizeof(TRI*));
        row_tris[0] = tris;
        N_row = 1;

        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == IN_FLOW || tri->BC_type == OUT_FLOW ||
                   tri->BC_type == NEUMANN || tri->BC_type == CONST_P ||
                   debugging("shock_vort") || debugging("Sod"))
                {
                    for(side = 0; side < 3; side++)
                    {
                        if(NULL == Tri_on_side(tri,side))
                        {
                            for(i = 0; i < 3; i++)
                                p[i] = Point_of_tri(tri)[(side+i)%3]; 
                            for(i = 0; i < dim; i++)
                                coords[i] = Coords(p[2])[i];
                            coords[2] = 0.0;
                            gp = Point(coords);

                            for(i = 0; i < dim; i++)
                               t[i] = fg_side_vector(tri)[side][i];
                            nor[0] = t[1];
                            nor[1] = -t[0];
                            // projection
                            u = ((Coords(p[2])[0]-Coords(p[0])[0])*(Coords(p[1])[0]-Coords(p[0])[0]) +
                                 (Coords(p[2])[1]-Coords(p[0])[1])*(Coords(p[1])[1]-Coords(p[0])[1]) )
                                    /fg_length_side(tri)[side];

                            crds[0] = Coords(p[0])[0] + u*(Coords(p[1])[0]-Coords(p[0])[0]);
                            crds[1] = Coords(p[0])[1] + u*(Coords(p[1])[1]-Coords(p[0])[1]);

                            i_reflect_point(gp, crds, nor, fr->interf);
                            tris[N_use] = i_make_tri(p[0],gp,p[1], NULL,NULL,NULL,YES);
                            tris[N_use]->id = -1;
                            comp_mass_matrix(MAX_N_COEF,tris[N_use],2,tris[N_use]->Lmass_matrix);
                            inverse_matrix(tris[N_use]->Lmass_matrix,MAX_N_COEF,tris[N_use]->mass_inv);
                            Tri_on_side(tri,side) = tris[N_use];
                            Tri_on_side(tris[N_use],2) = tri; 
                            tris[N_use]->BC_type = SUBDOMAIN;
                            set_side_bdry(Boundary_tri(tris[N_use]),0,YES);
                            set_side_bdry(Boundary_tri(tris[N_use]),1,YES);
                            // The "tri" is not a boundary tri anymore
                            Boundary_tri(tri) = NO;

                            // TMP
                            /**
                            printf("print interior tri:\n");
                            print_tri_crds(tri);
                            printf("print exterior tri:\n");
                            print_tri_crds(tris[N_use]);
                            **/

                            N_use++;

                            if(N_use == N_alloc)
                            {
                                if(N_row +1 >= 20)
                                {
                                    printf("ERROR: attach_buffer_tris, exceed alloc. limit\n");
                                    clean_up(ERROR);
                                }
                                vector(&tris, N_alloc, sizeof(TRI*));
                                row_tris[N_row] = tris;
                                N_row++;
                                N_use = 0;
                            }

                        }
                    }
                }
            }
            // insert tris to the surface
            for(i = 0; i < N_row; i++)
            {
                if(i == N_row-1)
                    N = N_use;
                else
                    N = N_alloc;
                for(j = 0; j < N; j++)
                {
                    insert_tri_at_tail_of_list(row_tris[i][j],*surf);
                }
            }
        }

        set_current_interface(current_intfc);
        set_alloc_mass_storage_flag(NO);
        set_comput_tri_geom_flag(NO);


        for(i = 0; i < N_row; i++)
            free(row_tris[i]);

        // TMP
        /**
        for(surf = fr->mesh->surfaces; surf && *surf; surf++)
        {
            for (tri = first_tri(*surf);
                 !at_end_of_tri_list(tri,*surf); tri = tri->next)
            {
                if(tri->BC_type == SUBDOMAIN)
                    continue;
                if(Boundary_tri(tri))
                {
                    for(side = 0; side < 3; side++)
                    {
                        nbtri[side] = Tri_on_side(tri,side);
                    }
                    printf("tri[%d] cent[%Lg, %Lg] side[%d %d %d]\n", 
                            tri->id, fg_centroid(tri)[0], fg_centroid(tri)[1], 
                            nbtri[0], nbtri[1], nbtri[2]);
                }
            }
        }
        **/
        // END TMP

        // output_tri_mesh("visual", 0, fr->mesh);
        // printf("EXIT in attach_buffer_tris()\n");
        // clean_up(0);
}

EXPORT void clip_tris_to_subdomain(
	Front   *fr)
{
	RECT_GRID *gr = fr->rect_grid;
        float     l[MAXD],u[MAXD], diam;
        int       dir, dim = gr->dim, remove_flag, tri_num = 0, total = 0;
        TRI       *tri, *nbtri[3];
        SURFACE   **s;

        print_rectangular_grid(fr->rect_grid);

        for(s= fr->mesh->surfaces; s&& *s; s++)
        {
            for (tri = first_tri(*s); !at_end_of_tri_list(tri,*s);
                tri = tri->next)
            {
                diam = fg_length_side(tri)[0];
                break;
            }
        }

        pp_global_max(&diam, 1);

        for (dir = 0; dir < dim; ++dir)
        {
            // l[dir] = gr->L[dir] - 0.0005;
            // u[dir] = gr->U[dir] + 0.0005;
            l[dir] = gr->L[dir] - 2.0*diam;
            u[dir] = gr->U[dir] + 2.0*diam;
        }

        printf("clip rect_size, x[%g %g], y[%g %g]\n", l[0], u[0], l[1], u[1]);
        // printf("front rect_side, x[%g %g], y[%g %g]\n", gr->L[0], gr->U[0], gr->L[1], gr->U[1]);

        for (s = fr->mesh->surfaces; s && *s; ++s)
        {
            for (tri=first_tri(*s); !at_end_of_tri_list(tri,*s); tri=tri->next)
            {
                if (tri_out_rect(tri,l,u))
                {
                    /*
                    // printf("tri[%d] outside domain\n", tri->id);
                    for(dir = 0; dir < 3; dir++)
                        nbtri[dir] = Tri_on_side(tri,dir);
 
                    remove_flag = YES;
                    for(dir = 0; dir < 3; dir++)
                    {
                        if(nbtri[dir] != NULL && tri_out_rect(nbtri[dir],l,u) == NO)
                        {
                            remove_flag = NO; 
                            break;
                        }
                    }

                    if(remove_flag == YES)
                        remove_out_domain_tri(tri,*s);
                    */
                    // Do not remove the attached buffers
                    // if(tri->BC_type != SUBDOMAIN)
                        // remove_out_domain_tri(tri,*s);
                        remove_out_rect_tri(tri,*s);
                }
            }
        }


        for (s = fr->mesh->surfaces; s && *s; ++s)
        {
            for (tri=first_tri(*s); !at_end_of_tri_list(tri,*s); tri=tri->next)
            {
                total++; 
                if (tri_out_rect(tri,gr->L,gr->U) == NO)
                {
                    tri_num++;

                    for(dir = 0; dir < 3; dir++)
                        nbtri[dir] = Tri_on_side(tri,dir);

                    if(nbtri[dir] == NULL)
                    {
                        printf("ERROR: interior tri has null neighbr\n");
                        clean_up(ERROR);
                    }
                }
                else
                {
                    tri->BC_type = SUBDOMAIN;
                }
            }

            (*s)->num_tri = total;
        }

        printf("clip_tris_to_subdomain, number of interior tris = %d, total = %d\n", tri_num, total);
        output_tri_mesh("visual",0,fr->mesh);
}

/**
LOCAL bool tri_out_rect(
        TRI             *tri,
        float           *L,
        float           *U)
{
        float           *cent;

        cent = fg_centroid(tri);
        if(cent[0] < L[0] || cent[0] > U[0])
            return YES;
        if(cent[1] < L[1] || cent[1] > U[1])
            return YES;
        return NO;
}       
**/

LOCAL void remove_out_rect_tri(
        TRI             *tri,
        SURFACE         *s)
{
        TRI             *nbtri;
        int             i;

        for (i = 0; i < 3; ++i)
        {
            if (!is_side_bdry(tri,i))
            {
                nbtri = Tri_on_side(tri,i);
                if (nbtri != NULL)
                {
                    if (Tri_on_side01(nbtri) == tri)
                        Tri_on_side01(nbtri) = NULL;
                    else if (Tri_on_side12(nbtri) == tri)
                        Tri_on_side12(nbtri) = NULL;
                    else if (Tri_on_side20(nbtri) == tri)
                        Tri_on_side20(nbtri) = NULL;
                }
            }
        }
        tmp_remove_tri_from_surface(tri,s);
}               /*end remove_out_domain_tri*/


LOCAL  void    tmp_remove_tri_from_surface(
        TRI     *tri,
        SURFACE *s)
{
        int i,j;

        if (tri == NULL)
            return;

        free_these(2,tri->Lmass_matrix,tri->mass_inv);
        free(tri->st);

        --s->num_tri;
        if (tri == first_tri(s))
        {
            first_tri(s) = tri->next;
            first_tri(s)->prev = head_of_tri_list(s);
        }
        else
            tri->prev->next = tri->next;
        if (tri == last_tri(s))
        {
            last_tri(s) = tri->prev;
            last_tri(s)->next = tail_of_tri_list(s);
        }
        else
            tri->next->prev = tri->prev;
        for (i = 0; i < 3; ++i)
        {
            if (is_side_bdry(tri,i))
            {
                NULL;
            }
            else
            {
                TRI *nbtri = Tri_on_side(tri,i);
                if (nbtri != NULL)
                {
                    for (j = 0; j < 3; ++j)
                    {
                        if (Tri_on_side(nbtri,j) == tri)
                        {
                            Tri_on_side(nbtri,j) = NULL;
                            break;
                        }
                    }
                }
            }
            Neighbor_on_side(tri,i) = NULL;
            Tri_workspace(tri) = NULL;
        }
}               /*end tmp_remove_tri_from_surface*/


