/*
*                               tricrx2d.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if defined(TWOD) 

#define DEBUG_STRING "crx_intfc"

#include <tri/trilocaldecs.h>

#if defined(CONSERVATIVE_ALG) 

#define   DEBUG  YES

enum {MAX_NUM_CURVES = 20};

struct _Semi_Build_Curve{
         CURVE   *c; 
         int     n_semi_c; 
         BOND    *firstb[MAX_NUM_CURVES]; 
         BOND    *lastb[MAX_NUM_CURVES]; 
         int     n_bonds[MAX_NUM_CURVES];
}; 
typedef struct _Semi_Build_Curve Semi_Build_Curve; 

LOCAL void        rm_none_crx_on_bdry(TRI_GRID*);
LOCAL void        build_semi_join_curves(Semi_Build_Curve*,BLK_BOND*);
LOCAL int         semi_join_curves_build_splitted_curves(TRI_GRID*,
                           Semi_Build_Curve*,int,JC_BLK_BOND*);
LOCAL void        prt_semi_join_curve(Semi_Build_Curve*,int); 
LOCAL CURVE       *make_closed_c_from_semi_join_c(Semi_Build_Curve*,int,INTERFACE*);
LOCAL void        rm_intfc_no_rebuilt_curves(TRI_GRID*,Semi_Build_Curve*,int); 


LOCAL void rm_none_crx_on_bdry(
         TRI_GRID       *ntg)
{
         CURVE          **c;
         BOND           *b, *newb;

         for(c = ntg->grid_intfc->curves; c && *c; c++)
         {
             if(wave_type(*c) >= FIRST_PHYSICS_WAVE_TYPE) continue; 
             b = (*c)->first;
             while(b != NULL)
             {
                 if(b->end->crx != YES &&
                    b->end != (*c)->end->posn)
                 {
                     if((newb = b->next) != NULL)
                     {
                         delete_start_of_bond(newb,*c); 
                         continue; 
                     }
                 }
                 b = b->next; 
             }
         }

#if defined(DEBUG)
         /*
         printf("rm_none_crx_on_bdry\n"); 
         for(c = ntg->grid_intfc->curves; c && *c; c++)
         {
             if(wave_type(*c) <= FIRST_USER_BOUNDARY_TYPE) continue; 
             if(wave_type(*c) >= FIRST_PHYSICS_WAVE_TYPE) continue; 
             b = (*c)->first;
             if(b->start->crx != YES)
             {
                 if(b->start == (*c)->start->posn)
                     printf("WARNING: Curve start pt no crx point[%14.12f, %14.12f]\n",
                        Coords(b->start)[0], Coords(b->start)[1]); 
                 else
                     printf("WARNING: no crx point[%14.12f, %14.12f]\n",
                        Coords(b->start)[0], Coords(b->start)[1]); 
             }
             while(b)
             { 
                 if(b->end->crx != YES)
                 {
                     if(b->end == (*c)->end->posn)
                         printf("WARNING: Curve end pt no crx point[%14.12f, %14.12f]\n",
                            Coords(b->end)[0], Coords(b->end)[1]); 
                     else
                         printf("WARNING: no crx point[%14.12f, %14.12f]\n",
                            Coords(b->end)[0], Coords(b->end)[1]); 
                 }
                 b = b->next; 
             }
         }
         */ 
#endif /* if defined(DEBUG) */
}

LOCAL   void build_semi_join_curves(
        Semi_Build_Curve  *semi_c,
        BLK_BOND          *bm)
{
        BOND       **bonds; 
        int        num_curves, i, j, k; 
        BOND       **newb, *tmpb, *firstb, *lastb;
        int        num_bonds, n_link_bond;
        int        do_link_again = NO, debug_flag = NO; 

        bonds = bm->cur_bonds;
        num_curves = bm->num_curves;

        for(i = 0; i < num_curves; i++)
        {
            if(wave_type(semi_c[i].c) < FIRST_PHYSICS_WAVE_TYPE)
                continue; 
            if(bonds[i] == NULL)
                continue;

#if defined(DEBUG)
            /*  
            num_bonds = 0;
            tmpb = bonds[i];
            while(tmpb)
            {
                num_bonds++;
                tmpb = tmpb->next;
            }
            if(num_bonds != bm->num_bonds[i])
            {
                printf("ERROR build_semi_join_curves\n");
                printf("Compute num_bonds = %d, saved num_bonds = %d\n",
                   num_bonds, bm->num_bonds[i]); 
                clean_up(ERROR);  
            }
            */
#endif /* if defined(DEBUG) */

            num_bonds = bm->num_bonds[i]; 
            vector(&newb, num_bonds, sizeof(BOND*));
            tmpb = bonds[i]; j = 0;
            while(tmpb)
            {
                newb[j++] = tmpb;
                tmpb = tmpb->next;
            }

            firstb = lastb = newb[0];
            firstb->next = firstb->prev = NULL;
            newb[0] = NULL;
            n_link_bond = 1; 

link_remain_bond: 
            for(j = 1; j < num_bonds; j++)
            {
                for(k = 1; k < num_bonds; k++)
                {
                    if(newb[k] != NULL)
                    {
                        if(lastb->end == newb[k]->start)
                        {
                            lastb->next = newb[k];
                            newb[k]->prev = lastb;
                            newb[k]->next = NULL;
                            lastb = newb[k];
                            newb[k] = NULL;
                            n_link_bond++; 
                            break;
                        }
                        if(firstb->start == newb[k]->end)
                        {
                            firstb->prev = newb[k];
                            newb[k]->next = firstb;
                            newb[k]->prev = NULL;
                            firstb = newb[k];
                            newb[k] = NULL;
                            n_link_bond++; 
                            break;
                        }
                    }
                }
            }
            for(j = 0; j < num_bonds; j++)
            {
                if(newb[j] != NULL)
                {
                    do_link_again = YES; 
                    debug_flag = YES; 
                    break; 
                }
            }

            semi_c[i].firstb[semi_c[i].n_semi_c] = firstb; 
            semi_c[i].lastb[semi_c[i].n_semi_c] = lastb; 
            semi_c[i].n_bonds[semi_c[i].n_semi_c] = n_link_bond; 
            semi_c[i].n_semi_c++;
            if(do_link_again)
            {
                firstb = lastb = newb[j];
                firstb->next = firstb->prev = NULL;
                newb[j] = NULL;
                n_link_bond = 1; 
                do_link_again = NO; 
                goto link_remain_bond; 
            }

            free(newb);

            if(semi_c[i].n_semi_c == 1)
            {
                semi_c[i].c->num_points = num_bonds+1;
                semi_c[i].c->first = firstb;
                semi_c[i].c->last = lastb;
            }
            /*  
            curves[i]->num_points = num_bonds+1;
            curves[i]->first = firstb;
            curves[i]->last = lastb;
            */
        }
}

LOCAL   void prt_semi_join_curve(
        Semi_Build_Curve  *semi_c,
        int               n)
{
        BOND        *b;  
        int         chgline = 0; 

        printf("[%d] part first and last bond,"
            " total bonds = %d\n", n, semi_c->n_bonds[n]);

        b = semi_c->firstb[n];
        while(b)
        {
            chgline++;
            printf("%12.10f, %12.10f ->",
                  Coords(b->start)[0],
                  Coords(b->start)[1]);
            if(chgline %4 == 0)
                printf("\n");
            if(b == semi_c->lastb[n])
                printf("%12.10f, %12.10f -> ",
                   Coords(b->end)[0],
                   Coords(b->end)[1]);
            b = b->next;
        }
        printf("\n");
}

LOCAL   CURVE  *make_closed_c_from_semi_join_c(
        Semi_Build_Curve  *semi_c, 
        int             j, 
        INTERFACE       *intfc)
{
        CURVE           *ncurve, *curve, *cs[2];
        BOND            Btmp;  
        BOND            *c0first, *c0last;
        NODE            *snode, *enode; 
        bool            sav_copy, sav_scss;

        sav_copy = copy_intfc_states();
        set_size_of_intfc_state(size_of_state(intfc));
        set_copy_intfc_states(YES);
        sav_scss = interpolate_states_at_split_curve_node();
        set_interpolate_states_at_split_curve_node(NO);

        curve = semi_c->c; 
        if((snode = make_node(semi_c->firstb[j]->start)) == NULL)
        {
            printf("ERROR make_closed_c_from_semi_join_c\n");
            printf("Can not make node\n");
            clean_up(ERROR);   
        }
        if (is_bdry(curve))
            set_is_bdry(snode);
        else
            set_not_bdry(snode);
        c0first = curve->first;  c0last = curve->last;
        Btmp.start = curve->first->start;
        Btmp.end = curve->last->end;
        Btmp.prev = Btmp.next = NULL;
        curve->first = curve->last = &Btmp;
        if((ncurve = copy_curve(curve,snode,snode)) == NULL)
        {
            printf("ERROR make_closed_c_from_semi_join_c\n");
            printf("Can not make curve\n");
            clean_up(ERROR);   
        }
        /**** For the purpose of using user_split_curve ****/
        if((cs[1] = copy_curve(ncurve,snode,snode)) == NULL)
        {
            printf("ERROR make_closed_c_from_semi_join_c\n");
            printf("Can not make curve 2\n");
            clean_up(ERROR);   
        }
        ncurve->first = semi_c->firstb[j]; 
        ncurve->last = semi_c->lastb[j]; 
        set_closed_node(snode); 
        curve->first = c0first;
        curve->last = c0last;

        negative_component(ncurve) = negative_component(curve);
        positive_component(ncurve) = positive_component(curve);
    
        /*** user part set curve ***/
        /*** a reuse of user_split_curve ***/
        cs[0] = ncurve;

        if (user_split_curve(NO,snode->posn,ncurve->first,curve,cs) != YES)
        {
            printf("ERROR make_closed_c_from_semi_join_c\n");
            printf("user_split_curve failed\n");
            clean_up(ERROR);   
        }         

        (void) delete_curve(cs[1]); 
        ncurve->num_points =  semi_c->n_bonds[j]+1;

        // assign(left_end_state(ncurve),left_state(snode->posn),sizest);
        // assign(right_end_state(ncurve),right_state(snode->posn),sizest);
        // start_status(ncurve) = end_status(ncurve) = INCIDENT;
                    
        /**** CONSERVATION  ****/

        set_copy_intfc_states(sav_copy);
        set_interpolate_states_at_split_curve_node(sav_scss);
        return ncurve; 
}

LOCAL   int semi_join_curves_build_splitted_curves(
        TRI_GRID       *ntg,
        Semi_Build_Curve  *semi_c,
        int               num_curves,
        JC_BLK_BOND    *jc_blk_bond)
{
        INTERFACE       *ntg_intfc = ntg->grid_intfc;
        CURVE           *ncurve, *curve;
        int             i, j, k;
        JC_BLK_BOND     *tmpjcb, *tmpjcb2;
        int             debug_flag = NO;

        for(i = 0; i < num_curves; i++)
        {
            if(semi_c[i].n_semi_c > 1)
                debug_flag = YES;
        }

#if defined(DEBUG)
        if(debugging("stitch_curves2d"))
        {
            printf("Print semi_join_curves_build_splitted_curves\n"); 
            if(jc_blk_bond->next != NULL)
            {
                printf("The join curve bonds\n");
                tmpjcb = jc_blk_bond->next;
                while(tmpjcb != NULL)
                {
                    print_bond(tmpjcb->jc_bond);
                    tmpjcb = tmpjcb->next;
                }
            }
            printf("End Print semi_join_curves_build_splitted_curves\n"); 
        }
#endif /*  if defined(DEBUG) */

        for(i = 0; i < num_curves; i++)
        {
            if(semi_c[i].n_semi_c > 1)
            {
                curve = semi_c[i].c; 
                for(j = 0; j < semi_c[i].n_semi_c; j++)
                {
                    if(! node_of_point(semi_c[i].firstb[j]->start,
                               semi_c[i].c->interface) &&
                       ! node_of_point(semi_c[i].lastb[j]->end,
                               semi_c[i].c->interface))    
                    {
                        /*
                        printf("[%d]'s \n", i);
                        printf("pure new curve\n");   
                        prt_semi_join_curve(&semi_c[i], j);
                        */
                        if(semi_c[i].firstb[j]->start == 
                           semi_c[i].lastb[j]->end)
                        {
                            make_closed_c_from_semi_join_c(&semi_c[i], j, ntg_intfc); 
                        }
                        else
                        {
                            printf("ERROR semi_join_curves_build_splitted_curves\n"); 
                            printf("make open curve, need to implement\n");
                            clean_up(ERROR); 
                        }
                    } 
                    else if( node_of_point(semi_c[i].firstb[j]->start,
                               semi_c[i].c->interface) &&
                              node_of_point(semi_c[i].lastb[j]->end,
                               semi_c[i].c->interface))    
                    {
                        /*
                        printf("[%d]'s \n", i);
                        printf("still old curve\n");   
                        prt_semi_join_curve(&semi_c[i], j);
                        */
                        semi_c[i].c->num_points = semi_c[i].n_bonds[j]+1;
                        semi_c[i].c->first = semi_c[i].firstb[j];
                        semi_c[i].c->last = semi_c[i].lastb[j];
                    }
                    else
                    {
                        printf("ERROR semi_join_curves_build_splitted_curves\n");
                        printf("New case\n");
                        prt_semi_join_curve(&semi_c[i], j);
                        clean_up(ERROR); 
                    }
                }
            }
        }

        return debug_flag; 
 
        if(debug_flag == YES)
        {
            printf("Implement case\n");
            printf("EXIT in semi_join_curves_build_splitted_curves\n"); 
            printf("in stitch_curves2d\n");
            clean_up(ERROR);
        }
}

/** apply only to the tracked physical curves **/
LOCAL void rm_intfc_no_rebuilt_curves(
        TRI_GRID       *ntg,
        Semi_Build_Curve  *semi_c,
        int            num_curves)
{
        INTERFACE      *intfc = ntg->grid_intfc;
        NODE           **n;
        CURVE          **c;
        int            i; 
        CURVE          **delete_curves = NULL;
        NODE           **delete_nodes = NULL; 
        
        for(c = intfc->curves; c && *c; c++)
        {
            if(wave_type(*c) < FIRST_PHYSICS_WAVE_TYPE)
                continue;
            for(i = 0; i < num_curves; i++)
            {
                if(semi_c[i].n_semi_c == 0 && 
                   (*c) == semi_c[i].c)
                {
                    if (! add_to_pointers((POINTER)*c,(POINTER**)&delete_curves))
                    {
                        screen("ERROR in rm_intfc_no_rebuilt_curves(), "
                            "add_to_pointers() failed\n");
                        clean_up(ERROR);
                    }
                    semi_c[i].c = NULL; 
                }
            }     
        }

        for (c = delete_curves; c && *c; c++)
            (void) delete_curve(*c);

        delete_nodes = NULL;
        for (n = intfc->nodes; n && *n; n++)
        {
            if (((*n)->in_curves == NULL) && ((*n)->out_curves == NULL))
            {
                if (! add_to_pointers((POINTER)*n,(POINTER**)&delete_nodes))
                {
                    screen("ERROR in delete_patch_all_curves(), "
                              "add_to_pointers() failed\n");
                    clean_up(ERROR);
                }
            }
        }

        for (n = delete_nodes; n && *n; n++)
            (void) delete_node(*n);
}

LIB_LOCAL   void stitch_curves2d(
         TRI_GRID       *ntg,
         BLK_BOND       *bm,
         JC_BLK_BOND    *jc_blk_bond,
         int            *smin,
         int            *smax)
{
        INTERFACE       *ntg_intfc = ntg->grid_intfc;
        BOND            **bonds;
        CURVE           **c, *ncurve, *c0, *c1;
        BOND            **newb, *tmpb, *firstb, *lastb;
        int             i, j, k, num_curves, alloc_cn;
        int             num_bonds, n_link_bond;
        JC_BLK_BOND     *tmpjcb, *tmpjcb2; 
        Semi_Build_Curve  *semi_c = NULL; 
        bool sav_intrp = interpolate_intfc_states(ntg->grid_intfc);
        int             stop_fr_debug = NO; 
 
        DEBUG_ENTER(stitch_curves2d)

        if(current_interface() != ntg_intfc)
        {
             printf("ERROR stitch_curves2d\n");
             printf("set current interface \n");
             clean_up(ERROR); 
        }

        bonds = bm->cur_bonds; 
        num_curves = bm->num_curves; 

        if(semi_c == NULL)
        {
            alloc_cn = num_curves + MAX_NUM_CURVES;
            vector(&semi_c,num_curves,sizeof(Semi_Build_Curve)); 
        }
        for(i = 0, c = ntg_intfc->curves; c && *c; i++, c++)
        {
            semi_c[i].c = *c;
            semi_c[i].n_semi_c = 0;  
        }

        build_semi_join_curves(semi_c, bm); 

#if defined(DEBUG)
        if(debugging("stitch_curves2d"))
        {
            printf("stitch_curves2d, print half constructed curve bonds\n"); 
            for(i = 0; i < num_curves; i++)
            {
                if(semi_c[i].n_semi_c >= 1)
                {
                    printf("Curve(curve_number %lld) is built by [%d] parts\n",
                         curve_number(semi_c[i].c), semi_c[i].n_semi_c);
                    for(j = 0; j < semi_c[i].n_semi_c; j++)
                    {
                        printf("Curve(curve_number %lld) part [%d]:\n",
                              curve_number(semi_c[i].c),  j);
                        prt_semi_join_curve(&semi_c[i], j);
                    }
                }
                else
                {
                    if(wave_type(semi_c[i].c) < FIRST_PHYSICS_WAVE_TYPE)
                        printf("Boundary Curve(curve_number %lld)"
                        " does not reconstruct\n",curve_number(semi_c[i].c)); 
                    else
                        printf("Tracked Curve(curve_number %lld)"
                        " does not reconstruct\n",curve_number(semi_c[i].c)); 
                }
            }
        }
#endif /* if defined(DEBUG) */

        /*** remove the non-reconstructed curves from interface 
         ***/
        rm_intfc_no_rebuilt_curves(ntg, semi_c, num_curves); 

        stop_fr_debug = semi_join_curves_build_splitted_curves(ntg,
             semi_c, num_curves, jc_blk_bond);

        if(jc_blk_bond->next != NULL)
        {
            tmpjcb = jc_blk_bond->next;
            while(tmpjcb != NULL)
            {
                c0 = tmpjcb->c0; 
                c1 = tmpjcb->c1; 
                // printf("join curves\n"); 
                // print_curve(c0); 
                // print_curve(c1); 
                interpolate_intfc_states(ntg_intfc) = YES;
                if(positive_component(c0) != positive_component(c1) ||
                   negative_component(c0) != negative_component(c1))
                {
                    printf("ERROR stitch_curves2d\n");
                    printf("The joined curves are not consistent\n");
                    print_curve(c0); 
                    print_curve(c1); 
                    print_bond(tmpjcb->jc_bond);
                    clean_up(ERROR); 
                }
                if(tmpjcb->jc_bond->end == c0->first->start &&
                   tmpjcb->jc_bond->start == c1->last->end)
                {
                    if(NULL == (ncurve = make_curve(negative_component(c0),
                               positive_component(c0),c1->start,
                               c0->end)))
                    {
                        printf("ERROR, stitch_curves2d\n");
                        printf("Does not make new curve\n");
                        clean_up(ERROR); 
                    }
                    if (is_bdry(c1))
                        set_is_bdry(ncurve);
                    else
                        set_not_bdry(ncurve);
                    ncurve->first = c1->first;
                    ncurve->last = c0->last; 
                    c1->last->next = tmpjcb->jc_bond;
                    tmpjcb->jc_bond->prev = c1->last;
                    c0->first->prev = tmpjcb->jc_bond;
                    tmpjcb->jc_bond->next = c0->first;
                    tmpjcb->jc_bond = NULL; 
                }
                else if(tmpjcb->jc_bond->end == c1->first->start &&
                   tmpjcb->jc_bond->start == c0->last->end)
                {
                    if(NULL == (ncurve = make_curve(negative_component(c0),
                               positive_component(c0),c0->start,
                               c1->end)))
                    {
                        printf("ERROR, stitch_curves2d\n");
                        printf("Does not make new curve 2\n");
                        clean_up(ERROR); 
                    }
                    if (is_bdry(c1))
                        set_is_bdry(ncurve);
                    else
                        set_not_bdry(ncurve);
                    ncurve->first = c0->first;
                    ncurve->last = c1->last; 
                    c0->last->next = tmpjcb->jc_bond;
                    tmpjcb->jc_bond->prev = c0->last;
                    c1->first->prev = tmpjcb->jc_bond;
                    tmpjcb->jc_bond->next = c1->first;
                    tmpjcb->jc_bond = NULL; 
                }
                else
                {
                    printf("ERROR stitch_curves2d\n");
                    printf("The new joining curves case\n");
                    print_curve(c0);
                    print_curve(c1);
                    print_bond(tmpjcb->jc_bond);
                    clean_up(ERROR);
                }
                ncurve->num_points += (c0->num_points + c1->num_points);
                if (!user_join_curves(ncurve,c0,c1))
                {
                    printf("ERROR stitch_curves2d\n");
                    printf("The user joining curves failed\n");
                    clean_up(ERROR);
                }
                tmpjcb2 = jc_blk_bond->next;
                while(tmpjcb2)
                {
                    if(tmpjcb2 != tmpjcb)
                    {
                        if(c0 == tmpjcb2->c0)
                            tmpjcb2->c0 = ncurve; 
                        if(c1 == tmpjcb2->c0) 
                            tmpjcb2->c0 = ncurve; 
                        if(c0 == tmpjcb2->c1)
                            tmpjcb2->c1 = ncurve; 
                        if(c1 == tmpjcb2->c1) 
                            tmpjcb2->c1 = ncurve; 
                    }
                    tmpjcb2 = tmpjcb2->next;
                }

                (void) delete_curve(c0);
                (void) delete_curve(c1);

                // printf("THe new joint curve\n"); 
                // print_curve(ncurve); 
                tmpjcb = tmpjcb->next;
            }
            interpolate_intfc_states(ntg_intfc) = sav_intrp;
        }

        free(semi_c);

        if(stop_fr_debug)
        {
            // printf("In stitch_curves2d, print intfc and exit\n"); 
            // print_interface(ntg_intfc); 
            // clean_up(ERROR); 
        }

        rm_none_crx_on_bdry(ntg); 

        DEBUG_LEAVE(stitch_curves2d)
}


#endif /* if defined(CONSERVATIVE_ALG) */
#endif /* if defined(TWOD) */

