/*
*				tricrx2d2.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#define DEBUG_STRING    "tricrx2d2"
#include <tri/trilocaldecs.h>

#if defined(TWOD) && defined(CONSERVATIVE_ALG)

struct _CRX_TMP_STORE {
        int           num;
                      /* number of TRI stored */
        TRI           *tri_array[4];
                      /* approximately, should not be
                         exceeded in any situation. */
        POINT         *crx_p[2];
                      /*segment intersecting with time line */
        int           icrds[MAXD];
        float         crx_crds[MAXD];  
        int           is_edge[4];
                      /* If TRI's edge intersects with time line,
                         set to YES, other wise, set to NO. */
};
typedef struct _CRX_TMP_STORE CRX_TMP_STORE;

struct _mask_blk_curv{
        CURVE     *c;
        POINT     **tript;
        int       num;
}; 
typedef struct _mask_blk_curv mask_blk_curv;

enum _C_TYPE {
        PURE       = 1,  /* The new curve pts comes from the same old curve */
        COMPOSITE  = 2   /* The new curve pts comes from different old curves */
};
typedef enum _C_TYPE C_TYPE;

/*** CURVE construction type ***/
enum _C_CONFIG_TYPE {
        UNKNOWN_CONFIG  = 0x0001,
        SPLIT           = 0x0002,  /* it is a portion of some curve. */
        JOIN            = 0x0004,  /* it is a composition of several curves */
        REGULAR         = 0x0008,
        CONFIG_MASK    = (UNKNOWN_CONFIG|SPLIT|JOIN|REGULAR)
};
typedef enum _C_CONFIG_TYPE C_CONFIG_TYPE;

struct _TS_Surf_Config2d{
        CURVE  *nc;
        CURVE  *oc;
        POINT  *nsp, *nep;
        POINT  *osp, *oep;
        int    nsindx[2], neindx[2];   /* curv_id and indx on point */
        int    osindx[2], oeindx[2];
        C_CONFIG_TYPE  config_type; 

        struct _TS_Surf_Config2d *prev;
        struct _TS_Surf_Config2d *next;
};
typedef struct _TS_Surf_Config2d TS_Surf_Config2d;

#define is_unknown_type(type)   ((type) & UNKNOWN_CONFIG)
#define is_split_type(type)     ((type) & SPLIT)
#define is_join_type(type)      ((type) & JOIN)
#define is_regular_type(type)   ((type) & REGULAR)
#define clear_type_flag(type)   ((type) &= ~CONFIG_MASK)

#define type_is_set(type)       (                              \
                                    (is_unknown_type(type)) || \
                                    (is_split_type(type))   || \
                                    (is_join_type(type))    || \
                                    (is_regular_type(type))    \
                                )
#define regular_type_only(type) (                              \
                                    is_regular_type(type) &&   \
                                    (!is_split_type(type)) &&  \
                                    (!is_join_type(type))  &&  \
                                    (!is_unknown_type(type))   \
                                )
#define split_type_only(type)   (                                \
                                    is_split_type(type) &&       \
                                    (!is_regular_type(type)) &&  \
                                    (!is_join_type(type))  &&    \
                                    (!is_unknown_type(type))     \
                                )

/*** LOCAL VARIABLE ***/
LOCAL   float   crx_tol, crx_tolv, crx_toll;

/*** LOCAL FUNCTION ***/
LOCAL TIME_SPACE_INTFC2D  *reg_time_space_intfc_construct2d(TRI_GRID*,TRI_GRID*,
                                CURVE*,CURVE*,float);
LOCAL POINT     **curve_crx_to_array(CURVE*,float,int*);
LOCAL int       find_coresp_new_bond(BOND*,CURVE*,CURVE*,BOND**,BOND**,int*);
LOCAL int       find_corresp_new_pt(POINT**,int,POINT**,int,CURVE*,CURVE*,int,int*);
LOCAL int       find_shortest_dist_candidate(POINT*,POINT*,POINT**,int,int,int*);
LOCAL void      build_time_space_tri(BOND_TRI*,POINT*,POINT*,POINT*,BOND*,CURVE*,int);
LOCAL int       contruct_time_space_tri_intfc1(TIME_SPACE_INTFC2D*,
                     POINT**,int,POINT**,int,CURVE*,CURVE*); 
LOCAL int       contruct_time_space_tri_intfc2(TIME_SPACE_INTFC2D*,
                     POINT**,int,POINT**,int,CURVE*,CURVE*); 
LOCAL int       nearest_newp_to_oldp2(POINT**,int,POINT**,int,
                    CURVE*,CURVE*,int,int,int*);
LOCAL void      region_of_t_lines(TRI*,int*,int*,RECT_GRID*,int*,int*);
LOCAL int       tri_edge_crossing_time(TRI*,int*,float*,float*,float,int*);
LOCAL float     shortest_2line_dist_zdir(int,float*,float*,float*,float*,float*);
LOCAL void      insert_time_line_crossings(CRX_TMP_STORE*,CRXING**,TRI_GRID*,TRI_GRID*,float);

LOCAL int       count_init_vol_state_storage(TRI_GRID*,INTERFACE*,int*);  

LOCAL void      mark_no_correspond_region(TRI_GRID*,TRI_GRID*,int*); 

LOCAL CURVE     *correspond_curve_from_other_intfc(CURVE*,INTERFACE*);
LOCAL void      prt_ts_intfc_curv_corsp(INTERFACE*,INTERFACE*,int);
LOCAL CURVE     *curve_join_type(CURVE*,INTERFACE*,INTERFACE*,C_CONFIG_TYPE*);
LOCAL void      print_join_type(C_CONFIG_TYPE);
LOCAL POINT     **seg_curve_crx_to_array(CURVE*,float,int*,int,int,int);
LOCAL void      prt_points_vec(POINT**,int);
/*
LOCAL void      mask_no_vol_construction_blk_by_cpt(TRI_GRID*,CURVE*,
                     POINT**,int); 
*/
LOCAL int       pt_on_crx(POINT*,int*,int*,RECT_GRID*,TRI_GRID*,
                     GRID_DIRECTION*,int*);
LOCAL void      mask_the_block(int*,GRID_DIRECTION,RECT_GRID*,TRI_GRID*);
LOCAL void      store_cpt_for_mask(CURVE*,POINT**,int,mask_blk_curv*,int*);
LOCAL void      mask_no_vol_const_blk(TRI_GRID*,INTERFACE*,mask_blk_curv*,int);
LOCAL void      move_closed_node_to_min_indx(CURVE*);
LOCAL void      add_unused_oldc_to_mask(CURVE**,int,mask_blk_curv*,int*);
LOCAL void      add_unused_curve_to_mask(CURVE*,mask_blk_curv*,int*); 

LOCAL TS_Surf_Config2d  *time_space_intfc_config2d(Front*,Front*,int*); 
LOCAL void      curve_seg_start_end_indx(CURVE*,int,int*,int*); 
LOCAL int       make_bubble_like_case(CURVE*,INTERFACE*,int***);
LOCAL TS_Surf_Config2d  *set_make_bubble_like_case_curve_fig(CURVE*,
                       CURVE*,int**,int,C_CONFIG_TYPE,TS_Surf_Config2d**); 
LOCAL TS_Surf_Config2d  *set_reg_split_curve_fig(CURVE*,CURVE*,
                           C_CONFIG_TYPE,TS_Surf_Config2d**);
LOCAL TIME_SPACE_INTFC2D  *split_seg_time_space_intfc_construct2d(TRI_GRID*,
                       TRI_GRID*,TS_Surf_Config2d*,float,mask_blk_curv*,int*,
                       mask_blk_curv*,int*); 
LOCAL void      free_surf_fig(TS_Surf_Config2d*); 
LOCAL void      prt_ts_surf_fig(TS_Surf_Config2d*);


LOCAL void      prt_points_vec(
        POINT       **pt,
        int         num)
{
        int         i; 
        for(i = 0; i < num; i++)
        {
            printf("[%d][%14.12f %14.12f] indx = %d, corresp C %d crx[%d]\n",
                 i, Coords(pt[i])[0],Coords(pt[i])[1],
                 pt[i]->indx, pt[i]->curv_id, pt[i]->crx);
        }
}

/*
LOCAL void mask_no_vol_construction_blk_by_cpt(
        TRI_GRID        *ntg,
        CURVE           *c,
        POINT           **pt, 
        int             num)
{
        POINT           *startp, *endp;
        BOND            *b;
        int             ip[MAXD], smin[MAXD], smax[MAXD];
        int             icp[MAXD], i, dim;
        RECT_GRID       *gr, *compgr; 
        GRID_DIRECTION  grid_dir;
        int             stopstart = NO, stopend = NO; 

        if(pt != NULL)
        {
            startp = pt[0];
            endp = pt[num-1];
        }
        else
            startp = endp = NULL;

        dim = ntg->comp_grid.dim;
        compgr = &(ntg->comp_grid);
        gr = &(ntg->aug_comp_grid); 

        for(i = 0; i < dim; i++)
        {
            smin[i] = -gr->lbuf[i];
            smax[i] = gr->ubuf[i] + gr->gmax[i];
        }

        set_crx_indx_local_global(ntg,ON_COMP_GRID);

        b = c->first;
        while(b)
        {
            if(b->start != startp)
            {
                if(b->start->crx == YES &&
                   pt_on_crx(b->start,smin,smax,gr,
                        ntg,&grid_dir,ip) == YES)
                {
                    icp[0] = ip[0] - compgr->lbuf[0] - 1; 
                    icp[1] = ip[1] - compgr->lbuf[1] - 1; 
                    mask_the_block(icp,grid_dir,compgr,ntg);
                }
            }
            else
            {
                stopstart = YES; 
                break; 
            }
            b = b->next; 
        }

        if (endp == NULL)
            return;

        b = c->last;
        while(b)
        {
            if(b->end != endp)
            {
                grid_dir = -1; 
                if(b->end->crx == YES &&
                   pt_on_crx(b->end,smin,smax,gr,
                        ntg,&grid_dir,ip) == YES)
                {
                    icp[0] = ip[0] - compgr->lbuf[0] - 1; 
                    icp[1] = ip[1] - compgr->lbuf[1] - 1; 
                    mask_the_block(icp,grid_dir,compgr,ntg);
                }
            }
            else
            {
                break;
                stopend = YES; 
            }
            b = b->prev; 
        }
}
*/

LOCAL void mask_the_block(
        int        *ip,
        GRID_DIRECTION grid_dir,
        RECT_GRID  *gr,
        TRI_GRID   *ntg)
{
        int        ic[MAXD]; 

        if(grid_dir == EAST)
        {
            ic[0] = ip[0]; 
            if((ic[1] = ip[1]) < (gr->gmax[1] + gr->ubuf[1]))
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
            if((ic[1] = ip[1]-1) >= -gr->lbuf[1])
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
        }
        else if(grid_dir == WEST)
        {
            ic[0] = ip[0] - 1; 
            if((ic[1] = ip[1]) < (gr->gmax[1] + gr->ubuf[1]))
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
            if((ic[1] = ip[1]-1) >= -gr->lbuf[1])
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
        }
        else if(grid_dir == SOUTH)
        {
            ic[1] = ip[1] - 1; 
            if((ic[0] = ip[0]) < gr->ubuf[0] + gr->gmax[0]) 
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
            if((ic[0] = ip[0]-1) >= -gr->lbuf[0]) 
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
        }
        else if(grid_dir == NORTH)
        {
            ic[1] = ip[1]; 
            if((ic[0] = ip[0]) < gr->ubuf[0] + gr->gmax[0]) 
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
            if((ic[0] = ip[0]-1) >= -gr->lbuf[0]) 
                Comp_blk(ic,ntg->blk_type,ntg) |= F_NO_VOL; 
        }
}

LOCAL int pt_on_crx(
        POINT      *pt,
        int        *smin,
        int        *smax,
        RECT_GRID  *gr,
        TRI_GRID   *ntg,
        GRID_DIRECTION  *grid_dir,
        int        *ip)
{
        int             *seg_crx_count;
        int             **seg_crx_lists;
        CRXING          *crx_store;
        int             ic[MAXD]; 
        int             i, k, nc, list; 

        seg_crx_count = ntg->c_seg_crx_count;
        seg_crx_lists = ntg->c_seg_crx_lists;
        crx_store = ntg->c_crx_store;

        rect_in_which(Coords(pt),ic,gr);

        for(ip[1] = ic[1]-1; ip[1] <= ic[1]+1; ip[1]++)
        {
            for(ip[0]=ic[0]-1; ip[0] <= ic[0]+1; ip[0]++)
            {
                for(i = 0; i < gr->dim; i++)
                {
                    if(ip[i] < smin[i])
                        ip[i] = smin[i];
                    if(ip[i] > smax[i])
                        ip[i] = smax[i];
                }
                if(ip[0] < smax[0] && ip[1] < smax[1])
                {
                    k = seg_index2d(ip,EAST);
                    nc = seg_crx_count[k]; 
                    for(i = 0; i < nc; i++)
                    {
                        list = seg_crx_lists[k][i];
                        if(crx_store[list].pt == pt)
                        {
                            *grid_dir = EAST;
                            return YES; 
                        }
                    }
                    k = seg_index2d(ip,NORTH);
                    nc = seg_crx_count[k]; 
                    for(i = 0; i < nc; i++)
                    {
                        list = seg_crx_lists[k][i];
                        if(crx_store[list].pt == pt)
                        {
                            *grid_dir = NORTH;
                            return YES; 
                        }
                    }
                }
                else if(ip[0] == smax[0])
                {
                    k = seg_index2d(ip,WEST);
                    nc = seg_crx_count[k]; 
                    for(i = 0; i < nc; i++)
                    {
                        list = seg_crx_lists[k][i];
                        if(crx_store[list].pt == pt)
                        {
                            *grid_dir = WEST;
                            return YES; 
                        }
                    }
                    if(ip[1] != smin[1])
                    {
                        k = seg_index2d(ip,SOUTH);
                        nc = seg_crx_count[k]; 
                        for(i = 0; i < nc; i++)
                        {
                            list = seg_crx_lists[k][i];
                            if(crx_store[list].pt == pt)
                            {
                                *grid_dir = SOUTH;
                                return YES; 
                            }
                        }
                    }
                }
                else if(ip[1] == smax[1])
                {
                    k = seg_index2d(ip,SOUTH);
                    nc = seg_crx_count[k]; 
                    for(i = 0; i < nc; i++)
                    {
                        list = seg_crx_lists[k][i];
                        if(crx_store[list].pt == pt)
                        {
                            *grid_dir = SOUTH;
                            return YES; 
                        }
                    }
                    if(ip[0] != smax[0])
                    {
                        k = seg_index2d(ip,EAST);
                        nc = seg_crx_count[k]; 
                        for(i = 0; i < nc; i++)
                        {
                            list = seg_crx_lists[k][i];
                            if(crx_store[list].pt == pt)
                            {
                                *grid_dir = EAST;
                                return YES; 
                            }
                        }
                    }
                }
                else
                {
                    printf("ERROR pt_on_crx\n");
                    clean_up(ERROR); 
                }
            }
        }

        return NO;
}        

LOCAL POINT **seg_curve_crx_to_array(
        CURVE           *newc,
        float           dt,
        int             *num,
        int             startindx,
        int             endindx,
        int             curv_id)
{
        int             i;
        POINT           **newp, *endp = NULL;
        BOND            *newb;

        newb = newc->last;
        while(newb)
        {
            if(newb->end->crx == YES &&
               newb->end->indx <= endindx &&
               newb->end->curv_id != -1)
            {
                endp = newb->end;
                break;
            }
            newb = newb->prev;
        }
        if(endp == NULL)
        {
            printf("ERROR: seg_curve_crx_to_array,\n");
            printf("Does not find the end point\n");
            printf("curve_number %llu , curv_id = %d, sindx %d ,eindx %d\n",
             curve_number(newc), newc->curv_id,
             startindx, endindx);
            prt_pt_corresp_curve(newc, NO);
            clean_up(ERROR);
        }
        /*
        else
        {
            printf("The end point of the curve\n"); 
            printf("[%14.12f %14.12f] indx = %d, corresp C %d crx[%d]\n",
             Coords(endp)[0],Coords(endp)[1],
             endp->indx, endp->curv_id, endp->crx);
        }
        */

        vector(&newp,(newc->num_points+1),sizeof(POINT*));
        i = 0;
        newb = newc->first;
        if(newb->start->crx == YES &&
           newb->start->indx >= startindx &&
           newb->start->curv_id != -1)
        {
            newp[i] = newb->start;
            newp[i]->_coords[2] = dt;
            i++;
        }
        while(newb)
        {
            if(i != 0)
            {
                if(newb->end->crx == YES &&
                   newb->end == endp )
                {
                    newp[i] = newb->end;
                    newp[i]->_coords[2] = dt;
                    i++;
                    break;
                }
                else if(newb->end->crx == YES &&
                   newb->end != endp )
                {
                    newp[i] = newb->end;
                    newp[i]->_coords[2] = dt;
                    i++;
                }
            }
            else
            {
                if(newb->end->crx == YES &&
                   newb->end->indx >= startindx &&
                   newb->end->curv_id != -1)
                {
                    newp[i] = newb->end;
                    newp[i]->_coords[2] = dt;
                    i++;
                    if(newb->end == endp)
                        break;
                }
            }
            newb = newb->next;
        }
        newp[i] = NULL;
        i++;
        (*num) = i;
        return newp;
}


LOCAL TIME_SPACE_INTFC2D *reg_time_space_intfc_construct2d(
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        CURVE           *newc,
        CURVE           *oldc,
        float           dt)
{
        TIME_SPACE_INTFC2D  *t_s_intfc = NULL;
        POINT               **newp, **oldp;      /* all points pointer on interface
                                                    store here*/
        int                 total_old = 0, total_new = 0;
                                                /* index of points on old curve,
                                                   total number of CRXING points
                                                   on old curve and new curve.
                                                 */
        int             i, ipp;    /* ipp, point int position in newp array */
        int             numtris,  newtris,  oldtris;  
        BOND_TRI        *btris;
       
        DEBUG_ENTER(reg_time_space_intfc_construct2d)

        scalar(&t_s_intfc, sizeof(TIME_SPACE_INTFC2D));
        newp = curve_crx_to_array(newc,dt,&total_new);
        oldp = curve_crx_to_array(oldc,0.0,&total_old);
        total_new--; 
        total_old--; 
        if(total_new <= 0)
        {
            printf("ERROR: New curve is NULL in reg_time_space_intfc_construct2d()\n");
            print_curve(newc);
            printf("End of print New curve\n");
            print_interface(newc->interface);
            printf("End of print New interface in reg_time_space_intfc_construct2d()\n");
            clean_up(ERROR);
        }
        if(total_old <= 0)
        {
            printf("ERROR: OLd curve is NULL in reg_time_space_intfc_construct2d()\n");
            print_curve(oldc);
            printf("End of print Old curve\n");
            print_interface(oldc->interface);
            printf("End of print Old interface in reg_time_space_intfc_construct2d()\n");
            clean_up(ERROR);
        }

#if defined(DEBUG)
        /* 
        printf("IN t_time_space_intfc_construct2d, interface curves print\n");
        printf("OLD CURVE  ************* NEW CURVE \n");
        for(i = 0; i< total_old; i++)
            printf("oldp[%d](%15.12f, %15.12f)->indx = [%d]\n",
                i,oldp[i]->_coords[0], oldp[i]->_coords[1], oldp[i]->indx);
        for(i = 0; i< total_new; i++)
            printf("newp[%d](%15.12f, %15.12f)->indx = [%d]\n",
                i,newp[i]->_coords[0], newp[i]->_coords[1],
                newp[i]->indx);
        printf("Old and New Curves\n"); 
        print_curve(oldc); 
        print_curve(newc); 
        */
#endif /* if defined(DEBUG) */

        /* Correct index of the nodes of the curve */
        /* Index might be changed by other curves */

        oldc->first->start->indx = oldc->sindx; 
        oldc->last->end->indx = oldc->eindx; 
        /*
        newc->first->start->indx = newc->sindx; 
        newc->last->end->indx = newc->eindx; 
        */
        if(newp[0]->indx > newc->sindx)
            newp[0]->indx = newc->sindx;
        if(newp[total_new-1]->indx > newc->eindx)
            newp[total_new-1]->indx = newc->eindx;

    
        /* Starting to construct TRI which has one EDGE on OLD CURVE */ 
        /* A simple N-gon can be triangulized by N-2 triangles  */
        numtris = total_old + total_new + 20; 
        vector(&btris, numtris, sizeof(BOND_TRI)); 
        t_s_intfc->btris = btris;  

        contruct_time_space_tri_intfc2(t_s_intfc,oldp,
              total_old,newp,total_new,oldc,newc); 

        free_these(2,newp, oldp); 
 
        DEBUG_LEAVE(reg_time_space_intfc_construct2d)
        return t_s_intfc;  
}

/*** contruct_time_space_tri_intfc2() ****/
/*** This function is used by reg_time_space_intfc_construct2d()
 *** and split_reg_time_space_intfc_construct2d()
 *** Note, DO NOT USE CURVE (oldc, newc) even they are
 *** passed into the function.  Because the triangles
 *** might be built based on only a portion of the curves.
 ***/
LOCAL int contruct_time_space_tri_intfc2(
        TIME_SPACE_INTFC2D *tsintfc,
        POINT              **oldp,
        int                total_old,
        POINT              **newp,
        int                total_new,
        CURVE              *oldc,
        CURVE              *newc)
{
        int             ipp, ipp2, ipp3;   
                             /* ipp, image point int position in newp
                              * for oldp[i];
                              * ipp2, image point int position in newp
                              * for oldp[i+1].  
                              * ipp3: best fit image pt from [ipp, ipp2]
                              * to build the tri: {oldp[i], newp[ipp3], oldp[i+1]}. 
                              */
        int             numtris,  newtris,  oldtris;
        BOND_TRI        *btris;
        POINT           **start, **end;  
        int             i, j; 

        btris = tsintfc->btris;
        oldtris = ipp = i = 0;
        while(oldp[i] && oldp[i+1])
        {
#if defined(DEBUG)
            /*
            printf("Old Point[%17.15f, %17.15f] indx[%d]\n",
                 Coords(oldp[i+1])[0], Coords(oldp[i+1])[1],
                 oldp[i+1]->indx);
            */
#endif /* if defined(DEBUG) */
            nearest_newp_to_oldp2(oldp,total_old,newp,total_new,
                oldc, newc, i+1, ipp, &ipp2); 
#if defined(DEBUG)
            /*
            printf("Correspond New Point[%17.15f, %17.15f] indx[%d]\n",
                    Coords(newp[ipp2])[0], Coords(newp[ipp2])[1],
                    newp[ipp2]->indx);
            */
#endif /* if defined(DEBUG) */
            if (NO == find_shortest_dist_candidate(oldp[i], oldp[i+1],
                    newp, ipp, ipp2, &ipp3))
            {
                printf("ERROR in contruct_time_space_tri_intfc2\n");
                printf("find_shortest_dist_candidate failed\n");  
                clean_up(ERROR);
            }
            
            build_time_space_tri(btris, oldp[i], 
                newp[ipp3], oldp[i+1], NULL, oldc, oldtris);
            oldtris++;
            ipp = ipp2; 
            i++;
        }
        tsintfc->num_old_tris = oldtris; 

        /* Build rest of tris have edges on the New Curve */
        i = oldtris;  
        newtris = 0; 
        start = newp;
        if(oldtris != 0)
        {
            end = &(btris[0].tri->__pts[1]);   
            while((*start) != (*end))
            {
                build_time_space_tri(btris, *start, *(start+1),
                 btris[0].tri->__pts[0], NULL, newc, i);  
                i++;
                newtris++; 
                start++;  
            }
            for(j = 0; j < oldtris-1; j++)
            {
                end = &(btris[j+1].tri->__pts[1]); 
                while((*start) != (*end))
                {
                    build_time_space_tri(btris, *start, *(start+1),
                     btris[j+1].tri->__pts[0], NULL, newc, i);  
                    i++;
                    newtris++; 
                    start++;  
                }
            }

            end = &(newp[total_new-1]);
            while((*start) != (*end))
            {
                build_time_space_tri(btris, *start, *(start+1),
                 btris[oldtris-1].tri->__pts[2], NULL, newc, i);
                i++;
                newtris++;
                start++;
            }
        }
        else
        {
            if(total_old != 1)
            {
                printf("ERROR contruct_time_space_tri_intfc2\n");
                printf("Does not construct the old curve tris\n"); 
                printf("total_new = %d total_old = %d\n",
                    total_new, total_old); 
                clean_up(ERROR);
            }
            end = &(newp[total_new-1]);   
            while((*start) != (*end))
            {
                build_time_space_tri(btris, *start, *(start+1),
                 oldp[0], NULL, newc, i);
                i++;
                newtris++;
                start++;
            }
        }

        tsintfc->num_new_tris = newtris;
        tsintfc->num_tris = newtris + oldtris; 
        /*
        printf("End new pts[%g, %g]\n", Coords(*end)[0], Coords(*end)[1]); 
        printf("New tris = %d, Old tris = %d, total_p = %d\n",
                oldtris, newtris, total_old+total_new);  

        for(i = 0; i < newtris+oldtris; i++)
        {
            printf("Print tri[%d]:\n", i);
            print_tri2d(btris[i].tri);  
        }
        */

        return YES; 
}


/* Do not do search on CURVE oldc and newc */
/* Because the POINT (oldp, newp) might consist of 
 * only a portion of the curves ***/
LOCAL int nearest_newp_to_oldp2(
        POINT     **oldp,
        int       old_len,
        POINT     **newp,
        int       new_len,
        CURVE     *oldc,
        CURVE     *newc,
        int       oldip,
        int       ips,  /* Start searching position in newp array */
        int       *bestipp)
{
        int      i, newips, newipe;
        int      oldindx;
        int      dropright, dropleft; 
        float    edge, shortest = HUGE_VAL;  

        newips = ips;
        if(newips + 1 == new_len)
        {
            *bestipp = ips;  
            return YES;
        }
        oldindx = oldp[oldip]->indx;

        for(i = newips; i < new_len; i++)
        {
            if(newp[i]->indx > oldindx)
                break;
        }
        newipe = i;
        if(newipe == new_len)
            newipe--;
 
        // Only one point, no other choices. 
        if(newips == newipe)
        {
            *bestipp = newips;
            return YES;  
        }
 
        dropright = NO;  
        for(i = newips; i <= newipe; i++)
        {
            if(newp[i]->indx == oldindx)
            {
                dropright = YES;  
                break; 
            }
        } 
        // for an old pt with index [i],
        // its propagated image is contained between
        // new bond [i-1, i]  etc. (more tricky case 
        // is contraction and when new point contains 
        // indx -100).  

        if(dropright == YES)
        {
            newipe = i;  
            if(newips == newipe)
            {
                *bestipp = newips;
                return YES;  
            }
        }

        dropleft = NO; 
        for(i = newipe; i >= newips; i--)
        {
            if(newp[i]->indx < oldindx && newp[i]->indx != -100)
            {
                dropleft = YES;
                break; 
            }  
        }
        if(dropleft == YES)
        {
            newips = i;     
            if(newips == newipe)
            {
                *bestipp = newips;
                return YES;  
            }
        }

        for(i = newips; i <= newipe; i++)
        {
            edge = distance_between_positions(Coords(oldp[oldip]), 
                       Coords(newp[i]), 2);
            if(edge < shortest)
            {
                *bestipp = i;
                shortest = edge;  
            }
        } 
        return YES; 
} 

/*   contruct_time_space_tri_intfc1() builds triangles 
 *   which have an edge on old curve by finding out a point on the
 *   new curve. 
 */
LOCAL int contruct_time_space_tri_intfc1(
        TIME_SPACE_INTFC2D *tsintfc,
        POINT              **oldp,
        int                total_old,
        POINT              **newp,
        int                total_new,
        CURVE              *oldc,
        CURVE              *newc)
{
        int             i, ipp;    /* ipp, point int position in newp array */
        int             numtris,  newtris,  oldtris;
        BOND_TRI        *btris;

        btris = tsintfc->btris;  
        oldtris = ipp = i = 0;
        while(oldp[i] && oldp[i+1])
        {
#if defined(DEBUG)
            /*
            printf("Old Point[%17.15f, %17.15f] [%17.15f, %17.15f] indx[%d,%d]\n",
                 Coords(oldp[i])[0], Coords(oldp[i])[1],
                 Coords(oldp[i+1])[0], Coords(oldp[i+1])[1],
                 oldp[i]->indx, oldp[i+1]->indx);
            */
#endif /* if defined(DEBUG) */
            find_corresp_new_pt(oldp, total_old, newp, total_new,
                oldc, newc, i, &ipp);
#if defined(DEBUG)
            /*
            printf("Correspond New Point[%17.15f, %17.15f] indx[%d]\n",
                    Coords(newp[ipp])[0], Coords(newp[ipp])[1],
                    newp[ipp]->indx);
            */
#endif /* if defined(DEBUG) */
            build_time_space_tri(btris, oldp[i], newp[ipp], oldp[i+1], NULL, oldc, oldtris);
            oldtris++;
            i++;
        }
        tsintfc->num_old_tris = oldtris;
  
        return YES; 
}

LOCAL int find_corresp_new_pt(
        POINT     **oldp, 
        int       old_len,
        POINT     **newp,
        int       new_len, 
        CURVE     *oldc,
        CURVE     *newc,
        int       olds,
        int       *ipp)
{
        int      i, newips, newipe;  
        int      oldindx, nxtoldindx;

        newips = *ipp; 
        if(newips + 1 == new_len)
            return YES; 
        oldindx = oldp[olds]->indx;
        nxtoldindx = oldp[olds+1]->indx; 

#if defined(DEBUG)
        if(nxtoldindx - oldindx != 1)
        {
            printf("ERROR find_coresp_new_bond\n");
            printf("oldbond pts index not diff by 1, start[%d] end[%d]\n",
                    oldindx, nxtoldindx);
            printf("Point[%17.15f, %17.15f], [%17.15f, %17.15f]\n",
                    Coords(oldp[olds])[0], Coords(oldp[olds])[1], 
                    Coords(oldp[olds+1])[0], Coords(oldp[olds+1])[1]);
            print_curve(oldc);
            printf("The corresponding new c is:\n");
            print_curve(newc);
            clean_up(ERROR);
        }
#endif /* if defined(DEBUG) */

        for(i = newips; i < new_len; i++)
        {
            if(newp[i]->indx > nxtoldindx)
                break; 
        }
        newipe = i; 
        if(newipe == new_len)
            newipe--; 

        if(newips == newipe)
        {
            *ipp = newips; 
            return YES; 
        } 

        if (NO == find_shortest_dist_candidate(oldp[olds], oldp[olds+1],
            newp, newips, newipe, ipp))
        {
            printf("ERROR in find_corresp_new_pt\n");
            clean_up(ERROR);  
        }
        return YES; 
}

LOCAL int find_shortest_dist_candidate(
        POINT  *oldps, 
        POINT  *oldpe,
        POINT  **newp, 
        int    newips, 
        int    newipe, 
        int    *ipp)
{
        int      i; 
        float    edge, edge1, edge2, shortest;
        float    div, avg; 

        div = shortest = HUGE_VAL;  
        for(i = newips; i <= newipe; i++)
        {
            edge1 = distance_between_positions(Coords(oldps), Coords(newp[i]), 2);  
            edge2 = distance_between_positions(Coords(oldpe), Coords(newp[i]), 2);  
            edge = (edge1 + edge2); 
            if(edge < shortest)
            {
                *ipp = i;
                shortest = edge; 
            }
        }
        return YES;  
}

/* All bonds with indx less than can be corresponding
 * candidates.  
 */
LOCAL int find_coresp_new_bond(
        BOND            *oldb,
        CURVE           *oldc,
        CURVE           *newc, 
        BOND            **newbs,
        BOND            **newbe,
        int             *bnum)
{
        BOND            *tnewb; 
        int             oldindx, nxtoldindx; 
        int             num;  
 
        *newbe = NULL; 
        if((*newbs) == NULL)
            (*newbs) = tnewb = newc->first;
        else
            tnewb = (*newbs);     
 
        oldindx = oldb->start->indx; 
        nxtoldindx = oldb->end->indx; 

        /*
        printf("start newbond [%d,%d]\n",
                tnewb->start->indx, tnewb->end->indx);
        print_bond(tnewb);
        */
#if defined(DEBUG) 
        if(nxtoldindx - oldindx != 1)
        {
            printf("ERROR find_coresp_new_bond\n");
            printf("oldbond pts index not diff by 1, start[%d] end[%d]\n",
                    oldb->start->indx, oldb->end->indx);
            print_bond(oldb);
            print_curve(oldc);
            printf("The corresponding new c is:\n");
            print_curve(newc);
            clean_up(ERROR);  
        }
#endif /* if defined(DEBUG) */
        
        if(tnewb == NULL)
        {
            printf("ERROR find_coresp_new_bond\n");
            printf("oldbond pts index start[%d] end[%d]\n",
                    oldb->start->indx, oldb->end->indx);
            print_bond(oldb);
            printf("This bond does not have the corresp new b\n"); 
            print_curve(oldc);
            printf("The corresponding new c is:\n");
            print_curve(newc);
            clean_up(ERROR);  
        }
        
        while(tnewb)
        {
            if(tnewb->start->indx >= nxtoldindx)
            {
                *newbe = tnewb;
                break;  
            } 
            tnewb = tnewb->next; 
        }

        if((*newbe) == NULL)
        {
            *newbe = newc->last; 
            /*
            printf("ERROR find_coresp_new_bond\n");
            printf("oldbond pts index start[%d] end[%d]\n",
                    oldb->start->indx, oldb->end->indx);
            print_bond(oldb);
            printf("This bond does not have the corresp endb\n"); 
            print_curve(oldc);
            printf("start Newb[%d,%d]\n", (*newbs)->start->indx, 
                                          (*newbs)->end->indx);
            print_bond(*newbs);  
            printf("The corresponding new c is:\n");
            print_curve(newc);
            clean_up(ERROR);  
            */
        }

        *bnum = 0; 
        for(tnewb = *newbs; tnewb != *newbe; tnewb = tnewb->next)
            (*bnum)++; 
        return YES;  
}

LOCAL POINT **curve_crx_to_array(
        CURVE           *newc,
        float           dt,
        int             *num)
{
        int             i;
        POINT           **newp;
        BOND            *newb;

        vector(&newp,(newc->num_points+1),sizeof(POINT*));
        i = 0;
        newb = newc->first;
        while(newb)
        {
            if(newb->start->crx == YES)
            {
                newp[i] = newb->start;
                newp[i]->_coords[2] = dt;
                i++;
            }
            newb = newb->next;
        }
        if(! is_closed_curve(newc))
        {
            if(newc->last->end->crx == YES)
            {
                newp[i] = newc->last->end;
                newp[i]->_coords[2] = dt;
                i++;
            }
        }

        newp[i] = NULL;
        i++; 
        (*num) = i;
        return newp;
}

/* When construct space time interface, 
 * BOND *b is not set 
 */
LOCAL void build_time_space_tri(
          BOND_TRI       *btris,
          POINT          *p1,
          POINT          *p2,
          POINT          *p3,
          BOND           *b,
          CURVE          *c,
          int            n)
{
          // btris[n].tri = make_tri(p1, p2, p3, NULL, NULL, NULL, 0); 
          scalar(&(btris[n].tri), sizeof(TRI_Plus_normal)); 
          btris[n].tri->__pts[0] = p1;
          btris[n].tri->__pts[1] = p2;
          btris[n].tri->__pts[2] = p3;
          set_normal_of_tri(btris[n].tri);
          btris[n].curve = c;
          btris[n].bond = b;
}

LIB_LOCAL void print_tri2d(
	TRI     *tri_head)
{
        POINT      *p[3];
        int        i, side;
        int        tri_n = 0;
        TRI        *tri;

        const char *sideno[] = {"12", "23", "31"};

        tri = tri_head;
        if (tri == NULL)
        {
            (void) fprintf(stdout,"NULL Triangle\n");
            return;
        }

        while(tri)
        {
            p[0] = Point_of_tri(tri)[0];
            p[1] = Point_of_tri(tri)[1];
            p[2] = Point_of_tri(tri)[2];

            (void) fprintf(stdout,"Normal = ( %g %g %g )\n",
                      Tri_normal(tri)[0],Tri_normal(tri)[1],
                      Tri_normal(tri)[2]);

            for (i = 0; i < 3; i++)
            {
                (void) fprintf(stdout,"p%d: ",i);
                if (p[i] != NULL)
                    (void) fprintf(stdout,"( %g %g %g ) ",
                           Coords(p[i])[0],Coords(p[i])[1],Coords(p[i])[2]);
                else
                    (void) fprintf(stdout,"NULL ");
                (void) fprintf(stdout,"\n");
                // (void) fprintf(stdout,"%lu\n",point_number(p[i]));
            }
            (void) fprintf(stdout,"\n");
            tri = tri->next;
        }

}

EXPORT int set_t_crxes_storage_for_volume(
        TIME_SPACE_INTFC2D  **ts_intfc,
        int                 num, 
        TRI_GRID            *new_ntg,
        TRI_GRID            *old_ntg,
        CRXING              **t_crxes,
        float               dt)
{
        int                 i, j, k, mm, smin[MAXD+1], smax[MAXD+1];
        int                 ntri; 
        TRI                 *tri;  
        BOND_TRI            *btris;
        float               *L, *h;
        int                 ic_base[MAXD], ic_bound[MAXD], ic_now[MAXD];
                            /* To store icrds of possible intersecting time line */
        int                 n_crx;
        float               coords[MAXD+1], crds_crx[MAXD+1];
        TRI                 *tri_head;
        CRX_TMP_STORE       *tmp_tri_t_crx;
        int                 *crx_flag; 
        int                 tmpnum, on_edge;
        float           min_sc_sep = MIN_SC_SEP(old_ntg->grid_intfc);/*TOLERANCE*/ 

        DEBUG_ENTER(set_t_crxes_storage_for_volume)

        for (i = 0; i < old_ntg->rect_grid.dim; i++)
        {
            smin[i] = 0;
            smax[i] = old_ntg->comp_grid.gmax[i];
            smin[i] -= old_ntg->comp_grid.lbuf[i];
            smax[i] += old_ntg->comp_grid.ubuf[i];
        }
        smin[2] = 0; smax[2] = 1;    /* In time direction */

        vector(&tmp_tri_t_crx, old_ntg->n_c_reg_nodes, sizeof(CRX_TMP_STORE)); 
        vector(&crx_flag, old_ntg->n_c_reg_nodes, sizeof(int)); 

        for(i= smin[0]; i < smax[0]+1; i++)
            for(j = smin[1]; j < smax[1]+1; j++)
        {
            ic_base[0] = i; ic_base[1] = j;
            Comp_node(ic_base,tmp_tri_t_crx,old_ntg).num = 0;
            Comp_node(ic_base,crx_flag,old_ntg) = NO;
        }
        L = new_ntg->comp_grid.L;
        h = new_ntg->comp_grid.h;
        h[2] = dt; 

        crx_tol = 0.0000001*min(h[0], h[1]);
        crx_tolv = 100.0*sqr(crx_tol);
        crx_toll = sqr(crx_tol);

        for(mm = 0; mm < num; mm++)
        {
            if(ts_intfc[mm] == NULL)
                continue; 
            btris = ts_intfc[mm]->btris;
            for(ntri = 0; ntri < ts_intfc[mm]->num_tris; ntri++)
            {
                region_of_t_lines(btris[ntri].tri, ic_base, 
                      ic_bound, &old_ntg->comp_grid, smin, smax);  
 
                for(i = ic_base[0]; i <= ic_bound[0]; i++)
                {
                    for(j = ic_base[1]; j <= ic_bound[1]; j++)
                    {
                        ic_now[0] = i; ic_now[1] = j;  
                        for (k = 0; k < 2; k++)
                            coords[k] = Coords(Regular_comp_grid_node(ic_now,old_ntg))[k]; 
                        /*
                        for (k = 0; k < 2; k++)
                            coords[k] = L[k] + ic_now[k]*h[k];
                        */
                        coords[2] = 0; 
                        if(Regular_comp_grid_comp(ic_now,old_ntg) !=
                           Regular_comp_grid_comp(ic_now,new_ntg))
                        {
                            if(tri_edge_crossing_time(btris[ntri].tri, ic_now,
                                 coords, crds_crx, dt, &on_edge) == YES)
                            {
                                if(Comp_node(ic_now,crx_flag,old_ntg) == NO)
                                {
                                    tmpnum = Comp_node(ic_now,tmp_tri_t_crx,old_ntg).num; 
                                    Comp_node(ic_now,crx_flag,old_ntg) = YES;
                                    for(k = 0; k < 3; k++)
                                        Comp_node(ic_now,tmp_tri_t_crx,old_ntg).crx_crds[k] = crds_crx[k];
                                    for(k = 0; k < 2; k++)
                                        Comp_node(ic_now,tmp_tri_t_crx,old_ntg).icrds[k] = ic_now[k];

                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).tri_array[tmpnum] = btris[ntri].tri; 
                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).is_edge[tmpnum] = on_edge; 
                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).num++; 
                                    /*
                                    printf("Ic[%d,%d] crossed by tri at [%17.15f, %17.15f, %17.15f]\n", 
                                        ic_now[0], ic_now[1], crds_crx[0], crds_crx[1], crds_crx[2]); 
                                    */
                                }
#if defined(DEBUG)
                                else
                                {
                                    float differ = 0.0;
                                    differ = _scaled_separation(
                                               Comp_node(ic_now,tmp_tri_t_crx,old_ntg).crx_crds,
                                               crds_crx, h, 3);  
                                    tmpnum = Comp_node(ic_now,tmp_tri_t_crx,old_ntg).num; 
                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).tri_array[tmpnum] = btris[ntri].tri; 
                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).is_edge[tmpnum] = on_edge; 
                                    Comp_node(ic_now,tmp_tri_t_crx,old_ntg).num++; 
                                    if(differ > min_sc_sep*0.0001)
                                    {
                                        printf("WARNING: in set_t_crxes_storage_for_volume\n");
                                        printf("Another tri crossed T-line [%d,%d]\n", ic_now[0], ic_now[1]); 
                                        printf("The scaled DIfference = %17.15f\n", differ); 
                                        printf("Crxing one [%17.15f, %17.15f, %17.15f]\n", 
                                                  crds_crx[0], crds_crx[1], crds_crx[2]);
                                        printf("Crxing two [%17.15f, %17.15f, %17.15f]\n", 
                                                Comp_node(ic_now,tmp_tri_t_crx,old_ntg).crx_crds[0], 
                                                Comp_node(ic_now,tmp_tri_t_crx,old_ntg).crx_crds[1], 
                                                Comp_node(ic_now,tmp_tri_t_crx,old_ntg).crx_crds[2]);
                                        geomview_intfc_plot2d("gviewout",0,
                                           old_ntg->grid_intfc,&(old_ntg->comp_grid));
                                        geomview_intfc_plot2d("gviewout",1,
                                           new_ntg->grid_intfc,&(old_ntg->comp_grid));
                                        clean_up(ERROR); 
                                    }
                                }
#endif /* if defined(DEBUG) */
                            }
                        }
                    }
                }
            }
        }

        mark_no_correspond_region(old_ntg,new_ntg,crx_flag); 

        insert_time_line_crossings(tmp_tri_t_crx, t_crxes, new_ntg, old_ntg, dt);

        free_these(2, tmp_tri_t_crx, crx_flag);  
        DEBUG_LEAVE(set_t_crxes_storage_for_volume)
        return YES;  
}

LOCAL void mark_no_correspond_region(
        TRI_GRID       *old_ntg,
        TRI_GRID       *new_ntg,
        int            *crx_flag) 
{
        int            i, j, dim, smin[MAXD], smax[MAXD];
        int            ic[MAXD], inconsist = 0;
        int            xx, yy, icrds[MAXD]; 

        dim = old_ntg->rect_grid.dim;
        for (i = 0; i < dim; i++)
        {
            smin[i] = 0;
            smax[i] = old_ntg->comp_grid.gmax[i];
            smin[i] -= old_ntg->comp_grid.lbuf[i];
            smax[i] += old_ntg->comp_grid.ubuf[i];
        }

        for(i= smin[0]; i < smax[0]+1; i++)
            for(j = smin[1]; j < smax[1]+1; j++)
        {
            ic[0] = i; ic[1] = j;
            if(Regular_comp_grid_comp(ic,old_ntg) !=
               Regular_comp_grid_comp(ic,new_ntg))
            {
                if(Comp_node(ic,crx_flag,old_ntg) != YES)
                {
                    for(xx = ic[0] -1; xx <= ic[0]; xx++)
                    {
                        for(yy = ic[1] -1; yy <= ic[1]; yy++)
                        {
                            if(xx >= smin[0] && xx < smax[0] &&
                               yy >= smin[1] && yy < smax[1])
                            {
                                icrds[0] = xx; icrds[1] = yy; 
                                Comp_blk(icrds,old_ntg->blk_type,old_ntg) |= F_NO_VOL; 
                                // printf("WARNING mark_no_correspond_region" 
                                //     " blk[%d %d] not set vol\n",icrds[0],icrds[1]);
                            }
                        }
                    }
                    /*
                    printf("WARNING in mark_no_correspond_region\n");
                    printf("Ic[%d,%d] [%g, %g] not crossed by tri\n",
                        ic[0], ic[1],
                        Coords(Regular_comp_grid_node(ic,old_ntg))[0],
                        Coords(Regular_comp_grid_node(ic,old_ntg))[1]);
                    printf("old_comp[%d], new_comp[%d]\n",
                      Regular_comp_grid_comp(ic,old_ntg),
                      Regular_comp_grid_comp(ic,new_ntg));
                    inconsist++;
                    */
                }
            }
        }

        /*
        if(inconsist != 0)
        {
            printf("ERROR mark_no_correspond_region, # inconsist = %d\n",
              inconsist);
            printf("print computational grid\n");
            print_rectangular_grid(&(old_ntg->comp_grid));
            clean_up(ERROR);
        }
        */
}

LOCAL void insert_time_line_crossings(
        CRX_TMP_STORE      *tri_crx_tmp,
        CRXING             **t_crxes,
        TRI_GRID           *new_ntg,
        TRI_GRID           *old_ntg,
        float              dt)
{
        int                i, j, k;
        int                smin[MAXD+1], smax[MAXD+1];
        int                ic[MAXD+1];
        float              *L, *h;
        float              *crx_crds;
        INTERFACE          *cintfc;
 
        DEBUG_ENTER(insert_time_line_crossings)

        cintfc = current_interface();
        set_current_interface(old_ntg->grid_intfc);        

        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = old_ntg->comp_grid.gmax[i];
            smin[i] -= old_ntg->comp_grid.lbuf[i];
            smax[i] += old_ntg->comp_grid.ubuf[i];
            /* might should use glb_comp_grid instead */
        }
        smin[2] = 0; smax[2] = 1;    /* In time direction */
        L = old_ntg->comp_grid.L;
        h = old_ntg->comp_grid.h;

        for(i= smin[0]; i <= smax[0]; i++)
           for(j = smin[1]; j <= smax[1]; j++)
        {
            ic[0] = i; ic[1] = j;
            if(Regular_comp_grid_comp(ic,old_ntg) !=
               Regular_comp_grid_comp(ic,new_ntg))
            {
                scalar(&Comp_node(ic,t_crxes,old_ntg),sizeof(CRXING));
                crx_crds = Comp_node(ic,tri_crx_tmp,old_ntg).crx_crds;
                Comp_node(ic,t_crxes,old_ntg)->pt = Point(crx_crds);
                Coords(Comp_node(ic,t_crxes,old_ntg)->pt)[2] = crx_crds[2];
                Comp_node(ic,t_crxes,old_ntg)->lcomp = Regular_comp_grid_comp(ic, new_ntg);
                Comp_node(ic,t_crxes,old_ntg)->ucomp =  Regular_comp_grid_comp(ic, old_ntg);
                Comp_node(ic,t_crxes,old_ntg)->hs =  NULL;
            }
        }
        set_current_interface(cintfc);  

        DEBUG_LEAVE(insert_time_line_crossings)
}


LOCAL int tri_edge_crossing_time(
        TRI             *tri,
        int             *icrds,
        float           *crds_start,
        float           *crds_crx,
        float           dt,
        int             *on_edge)
{
        float       norm[MAXD+1],D;
        const float *n; 
        float       crds_end[MAXD+1];
        int         i;
        float       *p1,*p2,d,pe_crx[MAXD+1];
        const float wt_tol = 1.0e-12;

        n = Tri_normal(tri);
        D = Mag3d(n);
        for (i = 0; i < 3; ++i)
            norm[i] = n[i]/D;        

        D = 0.0;
        for (i = 0; i < 3; i++)
        {
             D += norm[i]*Coords(Point_of_tri(tri)[0])[i];
             crds_crx[i] = crds_end[i] = crds_start[i];
        }
        crds_end[2] = crds_start[2] + dt;

        /* check for tri edge on grid edge */
        /* check for tri edge on grid edge */

        for (i = 0; i < 3; ++i)
        {
            p1 = Coords(Point_of_tri(tri)[i]);
            p2 = Coords(Point_of_tri(tri)[(i+1)%3]);

            d = shortest_2line_dist_zdir(2,crds_start,p1,p2,crds_crx,pe_crx);
            if (d > crx_toll)
                continue;

            if (within_interval(crds_start[2],crds_end[2],crds_crx[2]) &&
                within_interval(p1[0],p2[0],pe_crx[0])  &&
                within_interval(p1[1],p2[1],pe_crx[1])  &&
                within_interval(p1[2],p2[2],pe_crx[2]))
            {
                *on_edge = YES;
                return YES;
            }
            else
                return NO;
        }


        /* check for tri interior on grid edge */

        crds_crx[2] = (D - (norm[0]*crds_start[0] +
                           norm[1]*crds_start[1]))/norm[2];
        if(within_interval(crds_start[2],crds_end[2],crds_crx[2])
           &&
          (within_tri(crds_crx,Coords(Point_of_tri(tri)[0]),
                      Coords(Point_of_tri(tri)[1]),
                      Coords(Point_of_tri(tri)[2]),norm,0.0) == YES))
        {
            (*on_edge) = NO;
            return YES;
        }
        else
            return NO;
}

LOCAL void region_of_t_lines(
        TRI        *tri,
        int        *base,
        int        *bound,
        RECT_GRID  *gr,  
        int        *smin, 
        int        *smax)
{
        int        i;
        float      tl[3], tu[3];
        const float  *p0, *p1, *p2;
        float      center[3];

        p0 = Coords(Point_of_tri(tri)[0]);
        p1 = Coords(Point_of_tri(tri)[1]);
        p2 = Coords(Point_of_tri(tri)[2]);

        for (i = 0; i < 2; ++i)
        {
            tl[i] = min(p0[i],p1[i]);
            if (tl[i] > p2[i])
                tl[i] = p2[i];
            base[i] = cell_floor(tl[i],i,gr);
            tu[i] = max(p0[i],p1[i]);
            if (tu[i] < p2[i])
                tu[i] = p2[i];
            bound[i] = cell_ceil(tu[i],i,gr);
        }
        for(i = 0; i < 2; i++)
        {
            base[i]  -= 1; 
            bound[i] += 1;   
            if(base[i] < smin[i])
                base[i] = smin[i]; 
            if(bound[i] > smax[i])
                bound[i] = smax[i];  
        }

        /*
        for (i = 0; i < 2; ++i)
        {
            center[i] = (Coords(Point_of_tri(tri)[0])[i] +
                         Coords(Point_of_tri(tri)[1])[i] +
                         Coords(Point_of_tri(tri)[2])[i])/3.0;
        }
        Tri_icoords(tri)[0] = cell_index(center[0],0,gr);
        Tri_icoords(tri)[1] = cell_index(center[1],1,gr);

        for(i = 0; i < 2; i++)
        {
            base[i] = bound[i] = Tri_icoords(tri)[i];
            base[i]  -= 2; 
            bound[i] += 2;   
            if(base[i] < smin[i])
                base[i] = smin[i]; 
            if(bound[i] > smax[i])
                bound[i] = smax[i];  
        }
        */
}

LOCAL float shortest_2line_dist_zdir(
        int   dir,
        float *crds_start,
        float *p1,
        float *p2,
        float *pl1,
        float *pl2)
{
        int i,i0,i1,i2;
        float d;
        float t1, t2;
        float denom;

        i0 = dir;
        i1 = (dir+1)%3;
        i2 = (dir+2)%3;

        denom = (p1[i1]-p2[i1])*(p1[i1]-p2[i1])+
                      (p1[i2]-p2[i2])*(p1[i2]-p2[i2]);


        if (fabs(denom) >= crx_toll)
        {
            /* parameters corresponding to the closest points */

            t2 = ((p1[i1]-crds_start[i1])*(p1[i1]-p2[i1])+
                (p1[i2]-crds_start[i2])*(p1[i2]-p2[i2]))/denom;

            t1 = p1[i0]-crds_start[i0]+(p2[i0]-p1[i0])*t2;

            /* p1: point on the first curve closest to the second curve */
            /* p2: point on the second curve closest to the first curve */

            for (i = 0; i < 3; ++i)
            {
                pl1[i] = crds_start[i];
                pl2[i] = t2*(p2[i]-p1[i])+p1[i];
            }
            pl1[i0] += t1;
        }
        else /* curves are parallel */
        {
            pl1[i0] = p1[i0];
            pl1[i1] = crds_start[i1];
            pl1[i2] = crds_start[i2];

            for (i = 0; i < 3; ++i)
                pl2[i] = p1[i];
        }
        /* shortest distance between curves */

        d = (pl1[0]-pl2[0])*(pl1[0]-pl2[0])+(pl1[1]-pl2[1])*
            (pl1[1]-pl2[1])+(pl1[2]-pl2[2])*(pl1[2]-pl2[2]);

        return d;
}       /* end shortest_2line_dist_dir */



EXPORT int init_vol_state_storage(
       TRI_GRID    *ntg,
       INTERFACE   *intfc,
       size_t      sizest)
{
        COMPONENT       comp;
        float           *crds;
        int             icrds[MAXD], icrds_end[MAXD], ic[MAXD];
        int             ic_wv[MAXD], ic_wv2[MAXD];
        int             ic_wv3[MAXD], ic_wv4[MAXD];
        RECT_GRID       aug_comp_grid = ntg->aug_comp_grid;
        int             dim = ntg->rect_grid.dim;
        int             status;
        int             i, j, ii;
        int             max[MAXD], min[MAXD];
        static CRXING   **crx[4] = {NULL,NULL,NULL,NULL};
        int             nc[4]; /* number of CRXING */
        register Locstate *state;
        register byte     *storage;
        Locstate        st, dflt_state;
        int             count, nstorage_count; 

        if(NULL == crx[0])
        {
            for(i = 0; i < 4; i++)
                 vector(&crx[i],4,sizeof(CRXING *));
        }


        for (i = 0; i < 2; i++)
        {
            min[i] = 0;
            max[i] = ntg->comp_grid.gmax[i];
            min[i] -= ntg->comp_grid.lbuf[i];
            max[i] += ntg->comp_grid.ubuf[i];
        }

        count = count_init_vol_state_storage(ntg, intfc, &nstorage_count);

        VECTOR(ntg,vol_rect_state_storage, nstorage_count, sizest);
        VECTOR(ntg,vol_states,
          (aug_comp_grid.gmax[0])*(aug_comp_grid.gmax[1]),
                     sizeof(Locstate*));

        /* see init_triangulation_storage() */

        storage = ntg->vol_rect_state_storage; 
        for (i=min[1]; i<max[1]; i++)
        {
            for (j=min[0]; j<max[0]; j++)
            {
                icrds[1] = i;
                icrds[0] = j;

                // if(Comp_blk(icrds,ntg->blk_type,ntg) == F_NO_VOL)
                // {
                //     Comp_blk(icrds,ntg->vol_states,ntg) = NULL;
                //     continue;
                // }

                icrds_end[0] = icrds[0] + 1;
                icrds_end[1] = icrds[1] + 1;
                nc[0] = comp_crossings_in_direction(crx[0],icrds,EAST,ntg);
                nc[2] = comp_crossings_in_direction(crx[2],icrds,NORTH,ntg);
                nc[1] = comp_crossings_in_direction(crx[1],icrds_end,WEST,ntg);
                nc[3] = comp_crossings_in_direction(crx[3],icrds_end,SOUTH,ntg);

                if(nc[1] == 0 && nc[0] == 0 &&
                   nc[2] == 0 && nc[3] == 0)
                {
                    Comp_blk(icrds,ntg->vol_states,ntg) = NULL;
                }
                else if(nc[0] == 1 && nc[2] == 1 &&
                        nc[1] == 0 && nc[3] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                           2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(nc[0] == 1 && nc[3] == 1 &&
                        nc[1] == 0 && nc[2] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                           2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(nc[3] == 1 && nc[1] == 1 &&
                        nc[2] == 0 && nc[0] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                               2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(nc[1] == 1 && nc[2] == 1 &&
                        nc[0] == 0 && nc[3] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                           2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(nc[2] == 1 && nc[3] == 1 &&
                        nc[0] == 0 && nc[1] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                           2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 0 && nc[3] == 0)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                             2,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 2;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }

                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 1 && nc[3] == 1)
                {
                    vector(&Comp_blk(icrds,ntg->vol_states,ntg),
                           3,sizeof(Locstate));
                    state = Comp_blk(icrds,ntg->vol_states,ntg);
                    for (ii = 0;  ii < 3;  ii++)
                    {
                        *state++ = (Locstate) storage;
                        storage += sizest;
                    }
                }
                else if(is_complex_blk(Comp_blk(icrds,ntg->blk_type,ntg)))
                {
                    Comp_blk(icrds,ntg->vol_states,ntg) = NULL;
                    continue;
                }
                else
                {
                    printf("ERROR: In init_vol_state_storage()\n");
                    printf("Unkown case for assigining memory for states\n");
                    clean_up(ERROR);
                }
            }
        }
        return nstorage_count; 
}


LOCAL int count_init_vol_state_storage(
       TRI_GRID    *ntg,
       INTERFACE   *intfc,
       int         *nstorage_count)
{
        COMPONENT       comp;
        int             icrds[MAXD], icrds_end[MAXD], ic[MAXD];
        int             dim = ntg->rect_grid.dim;
        int             status;
        int             i, j;
        int             max[MAXD], min[MAXD];
        static CRXING   **crx[4] = {NULL,NULL,NULL,NULL};
        int             nc[4]; /* number of CRXING */
        int             count = 0, st_count = 0; 

     
        if(NULL == crx[0])
        {
            for(i = 0; i < 4; i++)
                 vector(&crx[i],4,sizeof(CRXING *));
        }

        *nstorage_count = 0;  

        for (i = 0; i < 2; i++)
        {
            min[i] = 0;
            max[i] = ntg->comp_grid.gmax[i];
            min[i] -= ntg->comp_grid.lbuf[i];
            max[i] += ntg->comp_grid.ubuf[i];
        }

        /* see init_triangulation_storage() */
        for (i=min[1]; i<max[1]; i++)
        {
            for (j=min[0]; j<max[0]; j++)
            {
                icrds[1] = i;
                icrds[0] = j;

                // if(Comp_blk(icrds,ntg->blk_type,ntg) == F_NO_VOL)
                // {
                //     count += 1; 
                //     continue;
                // }

                icrds_end[0] = icrds[0] + 1;
                icrds_end[1] = icrds[1] + 1;
                nc[0] = comp_crossings_in_direction(crx[0],icrds,EAST,ntg);
                nc[2] = comp_crossings_in_direction(crx[2],icrds,NORTH,ntg);
                nc[1] = comp_crossings_in_direction(crx[1],icrds_end,WEST,ntg);
                nc[3] = comp_crossings_in_direction(crx[3],icrds_end,SOUTH,ntg);

                if(nc[1] == 0 && nc[0] == 0 &&
                   nc[2] == 0 && nc[3] == 0)
                {
                    count += 1; 
                }
                else if(nc[0] == 1 && nc[2] == 1 &&
                        nc[1] == 0 && nc[3] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[0] == 1 && nc[3] == 1 &&
                        nc[1] == 0 && nc[2] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[3] == 1 && nc[1] == 1 &&
                        nc[2] == 0 && nc[0] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[1] == 1 && nc[2] == 1 &&
                        nc[0] == 0 && nc[3] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[2] == 1 && nc[3] == 1 &&
                        nc[0] == 0 && nc[1] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 0 && nc[3] == 0)
                {
                    count += 2; 
                    st_count += 2; 
                }
                else if(nc[1] == 1 && nc[0] == 1 &&
                        nc[2] == 1 && nc[3] == 1)
                {
                    count += 3; 
                    st_count += 3; 
                }
                else if(is_complex_blk(Comp_blk(icrds,ntg->blk_type,ntg)))
                {
                    count += 1; 
                    continue;
                }
                else
                {
                    printf("ERROR: In count_init_vol_state_storage()\n");
                    printf("Unkown case for assigining memory for states\n");
                    clean_up(ERROR);
                }
            }
        }

        *nstorage_count = st_count;
        return count;    
}

EXPORT TIME_SPACE_INTFC2D **time_space_intfc_construct2d(
        TRI_GRID     *tri_grid,
        TRI_GRID     *newtri_grid,
        Front        *front,
        Front        *newfront,
        int          *num,
        float        dt)
{
        INTERFACE    *intfc = front->interf;
        INTERFACE    *newintfc = newfront->interf;
        CURVE        *oldc, **unusedoldc;
        CURVE        **nc, *newc;
        int          i, corresp_n;
        int          j, num_oldc;
        TIME_SPACE_INTFC2D   **t_s_intfc = NULL;
        C_CONFIG_TYPE  join_type;
        C_TYPE       c_type;
        int          changed_open_close;
        TS_Surf_Config2d  *surf_fig, *tmp_fig; 
        mask_blk_curv   mask_old[50], mask_new[50];
        int          n_omask = 0, n_nmask = 0; 

        DEBUG_ENTER(time_space_intfc_construct2d)

        num_oldc = 0;
        for (nc = intfc->curves; nc && *nc; nc++)
        {
           if(wave_type(*nc) <= FIRST_USER_BOUNDARY_TYPE)
                continue;
           num_oldc++;
        }
        vector(&unusedoldc,num_oldc,sizeof(CURVE*));
        for (i = 0, nc = intfc->curves; nc && *nc; nc++)
        {
           if(wave_type(*nc) <= FIRST_USER_BOUNDARY_TYPE)
                continue;
           unusedoldc[i] = *nc;
           i++; 
        }

        surf_fig = time_space_intfc_config2d(front, newfront, &corresp_n);
   
        vector(&t_s_intfc, (corresp_n+5), sizeof(TIME_SPACE_INTFC2D*)); 

        tmp_fig = surf_fig;
        i = 0; 
        while(tmp_fig)
        {
#if defined(DEBUG)
            if(debugging("ts_surf_construct2d"))
                prt_ts_surf_fig(tmp_fig); 
#endif /* if defined(DEBUG) */

            if(is_join_type(tmp_fig->config_type))
                c_type = COMPOSITE;
            else
                c_type = PURE;
            newc = tmp_fig->nc;
            oldc = tmp_fig->oc;
            if(oldc == NULL)
            {
                add_unused_curve_to_mask(newc,mask_new,&n_nmask);
                // NEW add
                tmp_fig = tmp_fig->next;
                continue; 
            }
            
            for(j = 0; j < num_oldc; j++)
            {
                if(unusedoldc[j] == oldc)
                {
                    unusedoldc[j] = NULL;
                    break;
                }
            }
    
            if(c_type == PURE)
            {
                if(regular_type_only(tmp_fig->config_type))
                {
                    t_s_intfc[i] = reg_time_space_intfc_construct2d(
                        newtri_grid, tri_grid, newc, oldc, dt);
                    i++;
                }
                else if(split_type_only(tmp_fig->config_type))
                {
                    t_s_intfc[i] = split_seg_time_space_intfc_construct2d(
                        newtri_grid, tri_grid, tmp_fig, dt,mask_old, &n_omask,
                        mask_new, &n_nmask);
                    i++;
                }
            }
            else
            {
                printf("ERROR implement time_space_intfc_construct2d_ver2\n");
                printf("COMPOSITE type\n"); 
                print_join_type(tmp_fig->config_type);
                clean_up(ERROR); 
            }

            tmp_fig = tmp_fig->next; 
        }
        *num = i;
        add_unused_oldc_to_mask(unusedoldc, num_oldc,mask_old,&n_omask);
        mask_no_vol_const_blk(tri_grid, intfc,mask_old,n_omask);
        mask_no_vol_const_blk(newtri_grid, newintfc,mask_new,n_nmask);
        free(unusedoldc);
        
        free_surf_fig(surf_fig); 

        DEBUG_LEAVE(time_space_intfc_construct2d)
        return t_s_intfc; 
}

LOCAL void prt_ts_surf_fig(
        TS_Surf_Config2d  *surf_fig)
{
       printf("----- Start to print TS_Surf_Config -----\n"); 
        printf("TS_Surf config type:\n");
        print_join_type(surf_fig->config_type); 

        if(surf_fig->nc != NULL)
            printf("%s New Curve#[%llu]'s ts_build curv_id[%d]\n",
                   wave_type_as_string(wave_type(surf_fig->nc),
                     surf_fig->nc->interface),
                   curve_number(surf_fig->nc), 
                   surf_fig->nc->curv_id);
        if(surf_fig->oc != NULL)
            printf("%s Old Curve#[%llu]'s ts_build curv_id[%d]\n",
                   wave_type_as_string(wave_type(surf_fig->oc),
                     surf_fig->oc->interface),
                   curve_number(surf_fig->oc), 
                   surf_fig->oc->curv_id);

       printf("Nstart-indx[%d %d], Nend-indx[%d %d]\n",
           surf_fig->nsindx[0], surf_fig->nsindx[1], 
           surf_fig->neindx[0], surf_fig->neindx[1]);

       printf("----- End of printing TS_Surf_Config -----\n"); 
}

LOCAL void free_surf_fig(
        TS_Surf_Config2d  *surf_fig)
{
        TS_Surf_Config2d  *tmp_fig;

        tmp_fig = surf_fig;
        while(tmp_fig)
        {
            if(tmp_fig->next != NULL)
            {
                surf_fig = tmp_fig->next;
                free(tmp_fig);  
                tmp_fig = surf_fig;
            }
            else
            {
                free(tmp_fig);  
                break; 
            }
        }
}

/* Onyl a portion of the new curve and a portion of the old curve */
LOCAL TIME_SPACE_INTFC2D *split_seg_time_space_intfc_construct2d(
        TRI_GRID        *new_ntg,
        TRI_GRID        *old_ntg,
        TS_Surf_Config2d *surf_fig,
        float           dt,
        mask_blk_curv   *mask_old,
        int             *n_omask,
        mask_blk_curv   *mask_new,
        int             *n_nmask)
{
        int             startindx = -1, endindx = -1;
        CURVE           *newc; 
        CURVE           *oldc;
        TIME_SPACE_INTFC2D  *t_s_intfc = NULL;
        POINT           **newp, **oldp;      /* all points pointer on interface
                                                    store here*/
        int             total_old = 0, total_new = 0;
                                            /* index of points on old curve,
                                               total number of CRXING points
                                               on old curve and new curve.
                                             */
        int             numtris,  newtris,  oldtris;
        BOND_TRI        *btris;
        BOND            *b;

        DEBUG_ENTER(split_seg_time_space_intfc_construct2d)
 
        startindx = surf_fig->nsindx[1]; 
        endindx = surf_fig->neindx[1]; 
        newc = surf_fig->nc; 
        oldc = surf_fig->oc; 

        if(startindx == -1 && endindx == -1)
        {
            printf("WARNING: split_seg_time_space_intfc_construct2d\n");
            printf("null time-space intface\n");
            printf("newc %llu, construction curv_id[%d]:\n",
               curve_number(newc), newc->curv_id);
            newp = NULL; total_new = 0;
            add_unused_curve_to_mask(newc,mask_new,n_nmask);
            DEBUG_LEAVE(split_seg_time_space_intfc_construct2d)
            return NULL;
        }
        
        scalar(&t_s_intfc, sizeof(TIME_SPACE_INTFC2D));
        newp = seg_curve_crx_to_array(newc,dt,&total_new,
                    startindx,endindx,newc->curv_id);
        oldp = seg_curve_crx_to_array(oldc,0.0,&total_old,
                    startindx,endindx,oldc->curv_id);
        total_new--;
        total_old--;
                                                                                                      
        if(total_new <= 0 || total_old <= 0)
        {
            printf("ERROR: split_seg_time_space_intfc_construct2d()\n");
            printf("total_new = %d total_old = %d\n",
                total_new, total_old);
            printf("startindx = %d, endindx = %d\n",startindx, endindx); 
            
            printf("Print new curve_number() %llu curv_id %d \n",
                 curve_number(newc), (newc)->curv_id);
            prt_pt_corresp_curve(newc, NO);
            // print_curve(newc);
            printf("End of print New curve\n");
            printf("Print old curve_number() %llu curv_id %d\n",
                  curve_number(oldc), (oldc)->curv_id);
            prt_pt_corresp_curve(oldc, NO);
            // print_curve(oldc);
            printf("End of print old curve\n");
            clean_up(ERROR);
        }
        /* Starting to construct TRI which has one EDGE on OLD CURVE */
        /* A simple N-gon can be triangulized by N-2 triangles  */
        numtris = total_old + total_new + 20;
        vector(&btris, numtris, sizeof(BOND_TRI));
        t_s_intfc->btris = btris;

        contruct_time_space_tri_intfc2(t_s_intfc,oldp,
              total_old,newp,total_new,oldc,newc);

        /*** MASK THE REGION Covered by curves which does
         *** NOT construction space-time interface.
         ***/
        store_cpt_for_mask(oldc,oldp,total_old,mask_old,n_omask); 
        store_cpt_for_mask(newc,newp,total_new,mask_new,n_nmask); 

        free_these(2,newp,oldp);
        DEBUG_LEAVE(split_seg_time_space_intfc_construct2d)
        return t_s_intfc;
}

LOCAL TS_Surf_Config2d *time_space_intfc_config2d(
        Front        *front,
        Front        *newfront,
        int          *numfig)
{
        INTERFACE    *intfc = front->interf;
        INTERFACE    *newintfc = newfront->interf;
        CURVE        *oldc, **unusedoldc;
        CURVE        **nc;
        int          i, num_oldc;
        C_CONFIG_TYPE  join_type;
        C_TYPE       c_type;
        int          changed_open_close;
        TS_Surf_Config2d  *surf_fig = NULL, *tmpfig; 

        DEBUG_ENTER(time_space_intfc_config2d)

#if defined(DEBUG)
        if(debugging("ts_surf_config2d"))
        {
            geomview_intfc_plot2d("gviewout",0,
               front->interf, front->rect_grid);
            geomview_intfc_plot2d("gviewout",1,
               newfront->interf, newfront->rect_grid);
            prt_ts_intfc_curv_corsp(intfc,newintfc, NO);
        }
#endif /* if defined(DEBUG) */

        for(nc = newintfc->curves; nc && *nc; nc++)
        {
            if(is_closed_curve(*nc))
                move_closed_node_to_min_indx(*nc);
        }

        for(nc = newintfc->curves; nc && *nc; nc++)
        {
            if(wave_type(*nc) <= FIRST_USER_BOUNDARY_TYPE)
                continue;
            oldc = curve_join_type(*nc,newintfc,intfc,&join_type);
            if(is_join_type(join_type))
                c_type = COMPOSITE; 
            else
                c_type = PURE; 

            if(oldc == NULL)
            {
                printf("WARNING time_space_intfc_config2d\n");
                printf("New curve does not find its corresp. old\n");
                if(surf_fig == NULL)
                {
                    scalar(&surf_fig, sizeof(TS_Surf_Config2d));
                    surf_fig->prev = surf_fig->next = NULL;
                    surf_fig->config_type = join_type;
                    surf_fig->nc = *nc;
                    surf_fig->oc = oldc;
                }
                else
                {
                    scalar(&tmpfig, sizeof(TS_Surf_Config2d));
                    tmpfig->prev = tmpfig->next = NULL;
                    tmpfig->config_type = join_type;
                    tmpfig->nc = *nc;
                    tmpfig->oc = oldc;
                    surf_fig->prev = tmpfig;
                    tmpfig->next = surf_fig;
                    surf_fig = tmpfig;
                }
                continue; 
            }

            if((is_closed_curve(*nc) && is_closed_curve(oldc)) ||
                ((! is_closed_curve(*nc)) && (! is_closed_curve(oldc))) )
                changed_open_close = NO;
            else
                changed_open_close = YES;

            if(c_type == PURE)
            {
                if(regular_type_only(join_type))
                {
                    if(changed_open_close == NO)
                    {
                        if(surf_fig == NULL)
                        {
                            scalar(&surf_fig, sizeof(TS_Surf_Config2d));
                            surf_fig->prev = surf_fig->next = NULL; 
                            surf_fig->config_type = join_type;  
                            surf_fig->nc = *nc;
                            surf_fig->oc = oldc;
                        }    
                        else
                        {
                            scalar(&tmpfig, sizeof(TS_Surf_Config2d));
                            tmpfig->prev = tmpfig->next = NULL; 
                            tmpfig->config_type = join_type;  
                            tmpfig->nc = *nc;
                            tmpfig->oc = oldc;
                            surf_fig->prev = tmpfig;
                            tmpfig->next = surf_fig;
                            surf_fig = tmpfig; 
                        }
                    }
                    else
                    {
                        printf("ERROR in time_space_intfc_config2d\n");
                        printf("curves changed topology in regular_type case\n");
                        printf("Space-time with newc %llu, construction curv_id[%d]:\n",
                           curve_number(*nc), (*nc)->curv_id);
                        print_join_type(join_type);
                        prt_pt_corresp_curve(*nc, NO);
                        print_curve(*nc);
                        print_curve(oldc);
                        clean_up(ERROR);
                    }
                }
                else if(split_type_only(join_type))
                {
                    int n_bubble, **indxmatr; 
                    if(changed_open_close == NO)
                    {
                        if( 0 != (n_bubble = make_bubble_like_case(*nc, newintfc, &indxmatr)))
                        {
                            // printf("split NOT changed open_close make bubble\n"); 
                            // print_curve(*nc); 
                            tmpfig = set_make_bubble_like_case_curve_fig(*nc, oldc,
                                   indxmatr, n_bubble, join_type, &surf_fig);  
                            free(indxmatr); 
                        }
                        else
                        {
                            // printf("split NOT changed open_close NOT make bubble\n"); 
                            // print_curve(*nc); 
                            tmpfig = set_reg_split_curve_fig(*nc, oldc,
                                  join_type, &surf_fig);
                        }
                    }
                    else
                    {
                        if( 0 != (n_bubble = make_bubble_like_case(*nc, newintfc, &indxmatr)))
                        {
                            printf("ERROR (Implement) time_space_intfc_config2d\n"); 
                            printf("split changed open_close make bubble\n"); 
                            print_curve(*nc); 
                            free(indxmatr); 
                            clean_up(ERROR); 
                        }
                        else
                        {
                            // printf("split changed open_close NOT make bubble\n"); 
                            // print_curve(*nc); 
                            tmpfig = set_reg_split_curve_fig(*nc, oldc,
                                  join_type, &surf_fig);
                        }
                    }
                }
                else
                {
                    printf("ERROR time_space_intfc_config2d, unimplemented"
                       " type of curve correspondence\n");
                    print_join_type(join_type);
                    printf("New curv constr id[%d] \n", (*nc)->curv_id);
                    // prt_pt_corresp_curve(*nc,YES);
                    print_curve(*nc);
                    clean_up(ERROR);
                }
            }
            else
            {
                printf("ERROR time_space_intfc_config2d,"
                       " COMPOSITE curve\n");
                print_join_type(join_type);
                prt_pt_corresp_curve(*nc, NO);
                print_curve(*nc);
                clean_up(ERROR);
            }
        }

        tmpfig = surf_fig; 
        *numfig = 0; 
        while(tmpfig)
        {
            /*
            printf("Construct surf[%d] new_c[%llu], sindx-eindx[%d %d]\n",
                 *numfig, curve_number(tmpfig->nc), 
                 tmpfig->nsindx[1], tmpfig->neindx[1]); 
            */
            (*numfig)++; 
            tmpfig = tmpfig->next;
        }

        DEBUG_LEAVE(time_space_intfc_config2d)
        return surf_fig; 
}

LOCAL TS_Surf_Config2d *set_reg_split_curve_fig(
        CURVE      *ncurve, 
        CURVE      *oldc, 
        C_CONFIG_TYPE  join_type, 
        TS_Surf_Config2d **surf_fig)
{
        int        sindx = -1, eindx = -1;
        TS_Surf_Config2d *first_fig = NULL;

        curve_seg_start_end_indx(ncurve, ncurve->curv_id, &sindx, &eindx);
        if(sindx == -1 && eindx == -1)
            return NULL;
 
        scalar(&first_fig, sizeof(TS_Surf_Config2d));
        first_fig->prev = first_fig->next = NULL;
        first_fig->config_type = join_type;
        first_fig->nc = ncurve;
        first_fig->oc = oldc;
        first_fig->nsindx[0] = ncurve->curv_id;
        first_fig->nsindx[1] = sindx;
        first_fig->neindx[0] = ncurve->curv_id;
        first_fig->neindx[1] = eindx;
         
        if((*surf_fig) == NULL)
            (*surf_fig) = first_fig;
        else
        {
            first_fig->next = (*surf_fig);
            (*surf_fig)->prev = first_fig;
            (*surf_fig) = first_fig;
        }

        return first_fig; 
}

LOCAL TS_Surf_Config2d *set_make_bubble_like_case_curve_fig(
        CURVE      *ncurve, 
        CURVE      *oldc, 
        int        **indxmatr,
        int        n_bubble,
        C_CONFIG_TYPE  join_type,
        TS_Surf_Config2d **surf_fig)
{
        CURVE      **cc; 
        int        sindx = -1, eindx = -1;
        int        sindx2 = -1, eindx2 = -1;
        int        i, j; 
        INTERFACE  *nintfc = ncurve->interface; 
        TS_Surf_Config2d  *tmp_fig, *first_fig = NULL, *last_fig = NULL; 

        curve_seg_start_end_indx(ncurve, ncurve->curv_id, &sindx, &eindx);

        // bubble sort indxmatr in order by sorting startindx.
        for(i = 0; i < n_bubble; i++)
        {
            for(j = n_bubble -1; j > i; j--)
            {
                if(indxmatr[j][1] < indxmatr[j-1][1])
                {
                    int tmpswap[3]; 
                    tmpswap[0] = indxmatr[j][0]; 
                    tmpswap[1] = indxmatr[j][1]; 
                    tmpswap[2] = indxmatr[j][2]; 
                    indxmatr[j][0] = indxmatr[j-1][0]; 
                    indxmatr[j][1] = indxmatr[j-1][1]; 
                    indxmatr[j][2] = indxmatr[j-1][2]; 
                    indxmatr[j-1][0] = tmpswap[0]; 
                    indxmatr[j-1][1] = tmpswap[1]; 
                    indxmatr[j-1][2] = tmpswap[2]; 
                }
            } 
        } 
        // should exclude the case that self including in indxmatr 
        
        for(i = 0; i <= n_bubble; i++)
        {
            if(i == 0)
            {
                sindx2 = sindx; 
                eindx2 = indxmatr[i][1]; 
            }
            else if(i == n_bubble)
            {
                sindx2 = indxmatr[i-1][2];
                eindx2 = eindx;
            }
            else
            {
                sindx2 = indxmatr[i-1][2];
                eindx2 = indxmatr[i][1];
            }

            if((first_fig) == NULL)
            {
                scalar(&first_fig, sizeof(TS_Surf_Config2d));
                last_fig = first_fig; 
                first_fig->prev = first_fig->next = NULL;
                first_fig->config_type = join_type;
                first_fig->nc = ncurve;
                first_fig->oc = oldc;
                first_fig->nsindx[0] = ncurve->curv_id; 
                first_fig->nsindx[1] = sindx2; 
                first_fig->neindx[0] = ncurve->curv_id; 
                first_fig->neindx[1] = eindx2; 
            }
            else
            {
                scalar(&tmp_fig, sizeof(TS_Surf_Config2d));
                tmp_fig->prev = tmp_fig->next = NULL;
                tmp_fig->config_type = join_type;
                tmp_fig->nc = ncurve;
                tmp_fig->oc = oldc;
                tmp_fig->nsindx[0] = ncurve->curv_id; 
                tmp_fig->nsindx[1] = sindx2; 
                tmp_fig->neindx[0] = ncurve->curv_id; 
                tmp_fig->neindx[1] = eindx2; 
                first_fig->prev = tmp_fig;
                tmp_fig->next = first_fig;
                first_fig = tmp_fig;
            }
        }

        if((*surf_fig) == NULL)
            (*surf_fig) = first_fig;
        else
        {
            last_fig->next = (*surf_fig);
            (*surf_fig)->prev = last_fig; 
            (*surf_fig) = first_fig; 
        }

        return first_fig; 
}

/** curve_seg_start_end_indx()
 ** can not handle new curve points coming from
 ** different old curve points appear 
 ** altenerately. For exsample,
 ** (pts from c0)->(pts from c1)->(pts from c0)
 **/  
LOCAL void curve_seg_start_end_indx(
        CURVE      *curve,
        int        curv_id,
        int        *sindx,
        int        *eindx)
{
        BOND         *b;

        (*sindx) = (*eindx) = -1; 

        b = curve->first;
        while(b)
        {
            if(b->start->curv_id == curv_id && b->start->indx != -100)
            {
                if((*sindx) != -1)
                    (*eindx) = b->start->indx;
                else
                    (*sindx) = (*eindx) = b->start->indx;        
            }
            b = b->next; 
        }

        if(! is_closed_curve(curve))
        {
            b = curve->last;  
            if(b->end->curv_id == curv_id && b->end->indx != -100)
            {
                if((*sindx) != -1)
                    (*eindx) = b->end->indx;
                else
                    (*sindx) = (*eindx) = b->end->indx;        
            }
        }
}

/*   make_bubble_like_case()
 * Assume the "curve" and the other curves which
 * have the same curve_id are composed of points
 * from  single old curve only. This function
 * detects if there is the figure such as a bubble
 * detaches from the main body (curve).
 */
LOCAL int make_bubble_like_case(
        CURVE      *curve,
        INTERFACE  *newintfc,
        int        ***indxmatr)
{
        CURVE        **cc; 
        int          sindx = -1, eindx = -1; 
        int          sindx2 = -1, eindx2 = -1; 
        int          ncase = 0; 
        int          i, **savindx = NULL, nalloc = 5;

        curve_seg_start_end_indx(curve, curve->curv_id, &sindx, &eindx);
        if(sindx == -1 && eindx == -1)
        {
            *indxmatr = NULL; 
            return 0; 
        }

        for (cc = newintfc->curves; cc && *cc; cc++)
        {
            if(*cc == curve) continue;
            if((*cc)->curv_id != curve->curv_id)
                continue; 
            curve_seg_start_end_indx(*cc,(*cc)->curv_id,&sindx2,&eindx2);

            if(sindx2 == -1 && eindx2 == -1)
                continue; 
            if(sindx <= sindx2 && eindx >= eindx2)
            {
                /** curve contains *cc **/
                if(savindx == NULL)
                    matrix(&savindx, nalloc, 3, sizeof(int)); 
                if(ncase < nalloc)
                {
                    savindx[ncase][0] = (*cc)->curv_id; 
                    savindx[ncase][1] = sindx2; 
                    savindx[ncase][2] = eindx2; 
                }
                else
                {
                    int **tmpindx;
                    nalloc += 5; 
                    matrix(&tmpindx, nalloc, 3, sizeof(int));
                    for(i = 0; i < ncase; i++)
                    {
                        tmpindx[i][0] = savindx[i][0]; 
                        tmpindx[i][1] = savindx[i][1]; 
                        tmpindx[i][2] = savindx[i][2]; 
                    }
                    free(savindx); 
                    savindx = tmpindx; 
                }
                ncase++; 
            }
            /*
            if(sindx2 <= sindx && eindx2 >= eindx)
            {
                // cc contains curve 
            }
            */
        }
     
        *indxmatr = savindx; 
        return ncase; 
}

LOCAL void add_unused_curve_to_mask(
        CURVE        *c,
        mask_blk_curv *mask_c,
        int           *n_mask) 
{
        if(c == NULL) return;

        mask_c[*n_mask].c = c;
        mask_c[*n_mask].tript = NULL;
        mask_c[*n_mask].num = 0;
        (*n_mask)++;  
}

LOCAL void add_unused_oldc_to_mask(
        CURVE        **cc,
        int          num,
        mask_blk_curv *mask_c,
        int           *n_mask) 
{
        int          i = 0;

        for(i = 0; i < num; i++)
        {
            if(cc[i] == NULL)
                continue; 
            mask_c[*n_mask].c = cc[i];
            mask_c[*n_mask].tript = NULL;
            mask_c[*n_mask].num = 0;
            (*n_mask)++;  
        }
}

/** move_closed_node_to_min_indx **/
/* If the curve does join with others,
 * the joining part indx is not considered as a min.
 */
LOCAL void move_closed_node_to_min_indx(
        CURVE        *c) 
{
        BOND         *b, *minb = NULL;
        int          min_indx = 99999999;

        b = c->first;
        while(b)
        {
            if(b->start->indx < min_indx &&
               b->start->indx >= 0 &&
               b->start->curv_id == c->curv_id)
            {
                minb = b; 
                min_indx = b->start->indx; 
            }
            b = b->next; 
        }

        if(minb != NULL)
            move_closed_loop_node(c,minb); 
}

LOCAL void mask_no_vol_const_blk(
        TRI_GRID     *ntg,
        INTERFACE    *intfc,
        mask_blk_curv *mask_old,
        int           n_omask)
{
        int          i, j, found; 
        int          in_list; 
        CURVE        **cc; 
        BOND         *b; 
        int          icp[MAXD], ip[MAXD], smin[MAXD], smax[MAXD];
        RECT_GRID    *gr, *compgr;
        GRID_DIRECTION  grid_dir;

        if(n_omask == 0)
            return; 

        set_crx_indx_local_global(ntg,ON_COMP_GRID); 

        compgr = &(ntg->comp_grid);
        gr = &(ntg->aug_comp_grid);
        for(i = 0; i < gr->dim; i++)
        {
            smin[i] = -gr->lbuf[i];
            smax[i] = gr->ubuf[i] + gr->gmax[i];
        }

        for(cc = intfc->curves; cc && *cc; cc++)
        {
            found = NO;
            for(i = 0; i < n_omask; i++)
            {
                if(mask_old[i].c == *cc)
                {
                    found = YES; 
                    break; 
                }
            }
            if(found == YES)
            {
                b = (*cc)->first;
                while(b)
                {
                    if(b->start->crx == YES)
                    {
                        in_list = NO; 
                        for(j = 0; j < mask_old[i].num; j++)
                        {
                            if(b->start == mask_old[i].tript[j])
                            {
                                in_list = YES; 
                                break; 
                            }
                        }
                        if(in_list == NO)
                        {
                            if(pt_on_crx(b->start,smin,smax,gr,
                               ntg,&grid_dir,ip) == YES)
                            {
                                icp[0] = ip[0] - compgr->lbuf[0] - 1;
                                icp[1] = ip[1] - compgr->lbuf[1] - 1;
                                mask_the_block(icp,grid_dir,compgr,ntg);
                            }
                        }
                    }
                    b = b->next; 
                } 
                // prt_points_vec(mask_old[i].tript,mask_old[i].num); 
                if(mask_old[i].tript != NULL)
                    free(mask_old[i].tript); 
            }
        }

        n_omask = 0; 
}

LOCAL void store_cpt_for_mask(
        CURVE        *curve,
        POINT        **pt,
        int          num,
        mask_blk_curv  *mask_old,
        int            *n_omask)
{
        int    j, newnum;
        POINT  **tmppt;

        for(j = 0; j < (*n_omask); j++)
        {
            if(mask_old[j].c == curve)
            {
                if(num == 0)
                    return; 
                newnum = mask_old[j].num + num;
                vector(&tmppt, newnum, sizeof(POINT*));
                assign(tmppt,pt,num*sizeof(POINT*));
                assign(&tmppt[num],mask_old[j].tript,
                   mask_old[j].num*sizeof(POINT*));
                free(mask_old[j].tript); 
                mask_old[j].tript = tmppt; 
                mask_old[j].num = newnum; 
                return;
            }
        }

        if(num == 0)
        {
            mask_old[*n_omask].c = curve;
            mask_old[*n_omask].tript = NULL;
            mask_old[*n_omask].num = num;
            (*n_omask)++; 
            return; 
        }
        vector(&tmppt, num, sizeof(POINT*));
        assign(tmppt, pt, num*sizeof(POINT*));
        mask_old[*n_omask].c = curve;
        mask_old[*n_omask].tript = tmppt;
        mask_old[*n_omask].num = num;
        (*n_omask)++; 
}

/* correspond_curve_from_other_intfc() 
 * becomes a debug function call.
 */
LOCAL CURVE *correspond_curve_from_other_intfc(
        CURVE        *curve,
        INTERFACE    *intfc)
{
        CURVE           **c;
        int             num = 0;

        if(curve->curv_id == -1)
        {
            printf("ERROR In correspond_curve_from_other_intfc()\n");
            printf("Input curve id is -1\n");
            print_curve(curve);
            clean_up(ERROR);
        }

        for (c = intfc->curves; c && *c; c++)
        {
            if((*c)->curv_id == -1)
                continue;
            if((*c)->curv_id == curve->curv_id)
            {
                num++;
            }
        }
        if(num > 1)
        {
            printf("WARNING in correspond_curve_from_other_intfc()\n");
            printf("# of corresp curves = %d, this curve_id = %d\n",
                 num, curve->curv_id);
        }

        for (c = intfc->curves; c && *c; c++)
        {
            if((*c)->curv_id == curve->curv_id)
            {
                if (wave_type(*c) != wave_type(curve))
                {
                    printf("ERROR In correspond_curve_from_other_intfc() "
                          "wave_type mismatch()\n");
                    clean_up(ERROR);
                }
                return *c;
            }
        }

        return NULL;
}

LOCAL void prt_ts_intfc_curv_corsp(
        INTERFACE    *intfc,
        INTERFACE    *newintfc,
        int          prt_curv)
{
        CURVE        **c, *oldc;
        int          newnum, num;

        newnum = num = 0;
        for (c = newintfc->curves; c && *c; c++)
        {
           if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
               newnum++;
        }
        for (c = intfc->curves; c && *c; c++)
        {
           if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
               num++;
        }
        printf("There are %d new curves and %d old curves\n", newnum,num);
        printf("    ***** NEW intfc CURVEs: *****\n"); 
        for (c = newintfc->curves; c && *c; c++)
        {
            if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
            {
                printf("%s Curve#[%llu]'s ts_build curv_id[%d]\n",
                   wave_type_as_string(wave_type(*c),newintfc),
                   curve_number(*c), (*c)->curv_id);
            }
        }
        printf("    ***** OLD intfc CURVEs: *****\n"); 
        for (c = intfc->curves; c && *c; c++)
        {
            if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
            {
                printf("%s Curve#[%llu]'s ts_build curv_id[%d]\n",
                   wave_type_as_string(wave_type(*c),newintfc),
                   curve_number(*c), (*c)->curv_id);
            }
        }

        printf("\nPrint NEW CURVE # and its corsp OLD CURVE #\n\n");
        for (c = newintfc->curves; c && *c; c++)
        {
            if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
            {
                printf("%s Curve#[%llu]'s ts_build curv_id[%d]: ",
                   wave_type_as_string(wave_type(*c),newintfc),
                   curve_number(*c), (*c)->curv_id);
                oldc = correspond_curve_from_other_intfc(*c, intfc);
                printf(" correspond to %s Curve#[%llu] curv_id[%d]\n",
                   wave_type_as_string(wave_type(oldc),newintfc),
                   curve_number(oldc), (oldc)->curv_id);
            }
        }

        if(prt_curv == YES)
        {
            printf("\nPrint New Curve and its Corresponding Old Curve\n");
            for (c = newintfc->curves; c && *c; c++)
            {
               if(wave_type(*c) > FIRST_USER_BOUNDARY_TYPE)
               {
                   printf("NEW Curve#[%llu]'s ts_build curv_id[%d]: ",
                      curve_number(*c), (*c)->curv_id);
                   oldc = correspond_curve_from_other_intfc(*c, intfc);
                   printf(" correspond to Curve#[%llu] curv_id[%d]\n",
                      curve_number(oldc), (oldc)->curv_id);
                   printf("-----------NEW CURVE-------------:\n");
                   print_curve(*c);
                   printf("-----------OLD CURVE-------------:\n");
                   print_curve(oldc);
               }
            }
        }
}

LOCAL void print_join_type(
        C_CONFIG_TYPE  type)
{
        printf("The correspond flag %x: ",type);
        if(is_split_type(type))
            printf("SPLIT ");
        if(is_join_type(type))
            printf("JOIN ");
        if(is_regular_type(type))
            printf("REGULAR ");
        if(is_unknown_type(type))
            printf("UNKNOWN_CONFIG ");
        printf("\n");
}

LOCAL CURVE *curve_join_type(
        CURVE      *ncurve,
        INTERFACE  *newintfc,
        INTERFACE  *intfc,
        C_CONFIG_TYPE  *join_type)
{
        CURVE      **cc;
        BOND       *b;
        int        num = 0;

        if(ncurve->curv_id == -1)
        {
            printf("ERROR In curve_join_type()\n");
            printf("Input curve id is -1\n");
            print_curve(ncurve);
            clean_up(ERROR);
        }

        {
            int tmp = (C_CONFIG_TYPE)(*join_type);
            clear_type_flag(tmp);
            *join_type = (C_CONFIG_TYPE)tmp;
            // clear_type_flag((*join_type));
        }
        b = ncurve->first;

        if(b->start->curv_id != ncurve->curv_id &&
           b->start->curv_id != -1)
        { 
            int tmp = (C_CONFIG_TYPE)(*join_type);
            tmp |= JOIN;
            (*join_type) = (C_CONFIG_TYPE)tmp;
            // (*join_type) |= JOIN;
        }
        while(b != NULL)
        {
            if(b->end->curv_id != ncurve->curv_id &&
               b->end->curv_id != -1)
            {
                int tmp = (C_CONFIG_TYPE)(*join_type);
                tmp |= JOIN;
                (*join_type) = (C_CONFIG_TYPE)tmp;
                // (*join_type) |= JOIN;
                break;
            }
            b = b->next;
        }

        for (cc = newintfc->curves; cc && *cc; cc++)
        {
            if(wave_type(*cc) <= FIRST_USER_BOUNDARY_TYPE)
                continue;
            if(*cc == ncurve) continue;
            if((*cc)->curv_id == ncurve->curv_id)
            {
                int tmp = (C_CONFIG_TYPE)(*join_type);
                tmp |= SPLIT;
                (*join_type) = (C_CONFIG_TYPE)tmp;
                // *join_type |= SPLIT;
                break;
            }
        }

        for (cc = intfc->curves; cc && *cc; cc++)
        {
            if((*cc)->curv_id == -1)
                continue;
            if((*cc)->curv_id == ncurve->curv_id)
                num++;
        }
        if(num > 1)
        {
            printf("ERROR in curve_join_type()\n");
            printf("# of corresp curves = %d, this curve_id = %d\n",
                 num, ncurve->curv_id);
            print_curve(ncurve);
            clean_up(ERROR);
        }

        for (cc = intfc->curves; cc && *cc; cc++)
        {
            if((*cc)->curv_id == ncurve->curv_id)
            {
                if (wave_type(*cc) != wave_type(ncurve))
                {
                    printf("ERROR In curve_join_type() "
                          "wave_type mismatch()\n");
                    printf("curve id(old) %d, (new) %d\n", 
                             (*cc)->curv_id, ncurve->curv_id); 
                    print_curve(*cc); 
                    print_curve(ncurve); 
                    print_join_type(*join_type);
                    prt_pt_corresp_curve(*cc, NO);
                    prt_pt_corresp_curve(ncurve, NO);
                    geomview_intfc_plot2d("gviewout",1,newintfc,computational_grid(newintfc));
                    geomview_intfc_plot2d("gviewout",0,intfc,computational_grid(intfc));
                    clean_up(ERROR);
                }
                if(! type_is_set(*join_type))
                {
                    int tmp;
                    tmp = (int)(*join_type);
                    tmp |= REGULAR;
                    *join_type = (C_CONFIG_TYPE)tmp;
                    // *join_type |= REGULAR;
                }
                return *cc;
            }
        }

        *join_type = UNKNOWN_CONFIG;
        return NULL;
}


#endif /* defined(TWOD) && defined(CONSERVATIVE_ALG) */
