/*
*				tricrx.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if defined(THREED) || defined(TWOD)

#define DEBUG_STRING "crx_intfc"

#include <tri/trilocaldecs.h>

	/*LOCAL Function Prototypes*/
LOCAL   COMPONENT   next_side_comp_at_crx(GRID_PT*,CRXING*);
LOCAL   COMPONENT   this_side_comp_at_crx(GRID_PT*,CRXING*);
LOCAL	bool	check_comp_at(int*,GRID_DIRECTION,TRI_GRID*,int*,int*,bool);
LOCAL   bool    unphysical_edge(int*,GRID_DIRECTION,TRI_GRID*,int*,int*,
                        CRX_TYPE);
LOCAL   bool    check_and_repair_crx(TRI_GRID*,int*,int*);
LOCAL	bool	curves_on_bdry_side(int,int,INTERFACE*);
LOCAL	bool	reconstruct_intfc3d_in_box(TRI_GRID*,int*,int*,bool);
LOCAL   bool    track_comp_and_repair3d(int*,int*,int*,TRI_GRID*);
LOCAL   bool    repair_intfc3d_in_box(TRI_GRID*,int*,int*);
LOCAL	bool	remove_unphysical_crossings3d(TRI_GRID*,TRI_GRID*,
					      int*,int*);
LOCAL	int	crossings_on_edge(float**,float*,float*,int,int);
LOCAL	int	walk_comp_along_grid_line(TRI_GRID*,int*,int*,int*,int*,
					  GRID_DIRECTION);
LOCAL   int     fill_missing_crx(TRI_GRID*,int*,int*,GRID_DIRECTION,int);
LOCAL   void    set_reconstruction_boxes(int*,int*,int**,int,RECT_BOX**);
LOCAL	void	adjust_for_min_spacing(CRXING*,float,float*,int,int);
LOCAL	void	fill_block_crx(int,int,int,BLK_CRX*,int*,
			       GRID_DIRECTION,TRI_GRID*);
LOCAL	void	multi_crx_debug(CRX_SORT*,int,GRID_PT*,float*,float*,int);
LOCAL	void	print_crx_sort(CRX_SORT*,int,GRID_PT*);
LOCAL	void	print_edge_crxings(GRID_PT*,TRI_GRID*);
LOCAL	int	rm_unphy_crx_along_grid_line(TRI_GRID*,int*,int*,int*,int*,
					     GRID_DIRECTION,CRX_TYPE);
LOCAL	void	set_crx_storage_for_reconstruction(TRI_GRID*);
LOCAL   void    set_grid_crx_edge(RECT_GRID*,int*,GRID_DIRECTION,
                                      float*,float*,int*,int*);
LOCAL	void 	show_grid_components(int*,int*,int,TRI_GRID*);
LOCAL   void    show_component_along_line(int,int,int*,int*,int,TRI_GRID*);
LOCAL   void    eliminate_same_crossings(int*,int*,TRI_GRID*);
LOCAL   void    adjust_crossings(int*,int*,TRI_GRID*);
LOCAL   void    fill_physical_comps(int*,int*,int*,TRI_GRID*);
LOCAL   void    remove_unphysical_crxings(int*,int*,int*,TRI_GRID*,CRX_TYPE);
LOCAL   int     record_unphysical_ips(int*,int*,TRI_GRID*,int**);
LOCAL   int     check_and_unset_bad_comp(int*,int*,TRI_GRID*);
LOCAL   bool    seal_strip_with_tris(RECT_BOX*,TRI**,int*,int,POINT**,
                                float*,char*,bool);
LOCAL   bool    unset_comp_exist(int*,int*,TRI_GRID*);
LOCAL   bool    ip_connected(int**,int,int*);
LOCAL   bool    overlapping_boxes(RECT_BOX*,RECT_BOX*);
LOCAL   bool    tri_recorded(TRI*,TRI**,int);
LOCAL   bool    null_side_loop(TRI*,int,ORIENTATION,TRI***,int**,POINT***,
                                int*,float**);
LOCAL   bool    null_side_tri_in_list(TRI**,int,TRI**,int*);
LOCAL   bool    grid_based_box_untangle(TRI_GRID*,RECT_BOX*);
LOCAL   bool    adjacent_cell(int*,int*);
LOCAL   bool    check_extension_of_surface(TRI**, int, SURFACE*);
LOCAL   void    gview_show_box_tri(RECT_BOX*,TRI**,int,FILE*);
LOCAL   void    find_nearest_tri_pair(TRI**,int,TRI**,int,TRI**,
                        int*,TRI**,int*,RECT_BOX*);
LOCAL   void    find_nearest_tri_pair_new(TRI**,int,TRI**,int,TRI**,
                        int*,TRI**,int*,RECT_BOX*);
LOCAL   bool    null_sides_with_suitable_angle(TRI*, int, TRI*, int);
LOCAL   bool    bifurcation_detected(TRI**, int, TRI***, int*, TRI***, int*);

enum { ALL_DIR_SEARCHED	= -100 };
#define	Grid_point(p)	(GRID_PT *)(p)->pointer

/*
*               repair_intfc_at_crossings3d():
*/

EXPORT  INTERFACE       *repair_intfc_at_crossings3d(
        TRI_GRID  *old_ntg,
        RECT_GRID *dual_grid,
        Front     *front)
{
        INTERFACE *intfc;
        TRI_GRID  *new_ntg;
        int       **ic_of_node;
        bool      sav_intrp = interpolate_intfc_states(intfc);
        int       i, smin[3], smax[3];
        size_t    sizest = front->sizest;
        int       *gmax = old_ntg->rect_grid.gmax;
        DEBUG_ENTER(repair_intfc_at_crossings3d)

        /* set reconstruction boundary and tolerance */

        for (i = 0; i < 3; ++i)
        {
            smin[i] = 0;
            smax[i] = gmax[i];
            /*
            if (old_ntg->tg_grid.lbuf[i] != 0)
                smin[i] += old_ntg->tg_grid.lbuf[i] - 1;
            if (old_ntg->tg_grid.ubuf[i] != 0)
                smax[i] -= old_ntg->tg_grid.ubuf[i] - 1;
                */
        }

        set_size_of_intfc_state(sizest);
        set_copy_intfc_states(YES);

        intfc = front->interf;
        print_storage("Entering repair_intfc_at_crossings3d","crx_store");

        scalar(&new_ntg,sizeof(TRI_GRID));

        new_ntg->tri_grid_hooks = old_ntg->tri_grid_hooks;
        new_ntg->grid_intfc = intfc;
        set_tri_grid_rect_grids(new_ntg,dual_grid,intfc);
        set_tri3d_tolerances(new_ntg);

        ic_of_node = set_node_index_list(new_ntg);
        set_dual_interface_topology(new_ntg);
        set_crx_storage_for_reconstruction(new_ntg);

        start_clock("insert_grid_crossings3d");
        interpolate_intfc_states(intfc) = YES;
        insert_grid_crossings3d(new_ntg,front);
        stop_clock("insert_grid_crossings3d");
        print_storage("After insert_grid_crossings3d","crx_store");

        start_clock("reconstruct_intfc3d_in_box");
        if (!repair_intfc3d_in_box(new_ntg,smin,smax))
        {
            interpolate_intfc_states(intfc) = sav_intrp;
            new_ntg->grid_intfc = NULL;
            free_grid_lines(&new_ntg->rect_grid);
            free_tri_grid(new_ntg);
            free(new_ntg);
            free(ic_of_node);
            DEBUG_LEAVE(repair_intfc_at_crossings3d)
            return NULL;
        }
        stop_clock("reconstruct_intfc3d_in_box");
        print_storage("After reconstruct_intfc3d_in_box","crx_store");

        interpolate_intfc_states(intfc) = sav_intrp;

        identify_detached_surface_curve_pair(intfc);

        reset_intfc_num_points(intfc);
        /*
        delete_interface(front->interf);
        */
        front->interf = copy_interface(intfc);
        print_storage("After copy_interface","crx_store");
        free_grid_lines(&new_ntg->rect_grid);
        free_tri_grid(new_ntg);/*deletes new_ntg->grid_intfc*/
        free(new_ntg);
        free(ic_of_node);
        print_storage("After free_tri_grid","crx_store");
        DEBUG_LEAVE(repair_intfc_at_crossings3d)
        return front->interf;
}       /*end repair_intfc_at_crossings3d*/


/*
*		rebuild_intfc_at_crossings3d():
*/

EXPORT	INTERFACE	*rebuild_intfc_at_crossings3d(
	TRI_GRID  *old_ntg,
	RECT_GRID *dual_grid,
	Front     *front)
{
	INTERFACE *intfc = front->interf;
	TRI_GRID  *new_ntg;
	int 	  **ic_of_node;
	bool   sav_intrp = interpolate_intfc_states(intfc);
	int 	  i, smin[3], smax[3];
	size_t	  sizest = front->sizest;
	DEBUG_ENTER(rebuild_intfc_at_crossings3d)

	/* set reconstruction boundary and tolerance */

	for (i = 0; i < 3; ++i)
	{
	    smin[i] = 0;	
	    smax[i] = old_ntg->rect_grid.gmax[i]; /*expanded_dual_grid*/

            if (old_ntg->tg_grid.lbuf[i] != 0)
		smin[i] += old_ntg->tg_grid.lbuf[i] - 1;
	    else if (curves_on_bdry_side(i,0,intfc) == YES)
	        smin[i] += 1;
            if (old_ntg->tg_grid.ubuf[i] != 0)
		smax[i] -= old_ntg->tg_grid.ubuf[i] - 1;
	    else if (curves_on_bdry_side(i,1,intfc) == YES)
	        smax[i] -= 1;
	}
	
	set_size_of_intfc_state(sizest);
	set_copy_intfc_states(YES);

	print_storage("Entering rebuild_intfc_at_crossings3d","crx_store");

	scalar(&new_ntg,sizeof(TRI_GRID));

	new_ntg->tri_grid_hooks = old_ntg->tri_grid_hooks;
	new_ntg->grid_intfc = intfc;
	set_tri_grid_rect_grids(new_ntg,dual_grid,intfc);
	set_tri3d_tolerances(new_ntg);

	ic_of_node = set_node_index_list(new_ntg);
	set_dual_interface_topology(new_ntg);
	set_crx_storage_for_reconstruction(new_ntg);

	start_clock("insert_grid_crossings3d");
	interpolate_intfc_states(intfc) = YES;
	insert_grid_crossings3d(new_ntg,front);
	stop_clock("insert_grid_crossings3d");
	print_storage("After insert_grid_crossings3d","crx_store");

	start_clock("remove_unphysical_crossings3d");
	if (!remove_unphysical_crossings3d(old_ntg,new_ntg,smin,smax))
	{
	    interpolate_intfc_states(intfc) = sav_intrp;
	    new_ntg->grid_intfc = NULL;
	    free_grid_lines(&new_ntg->rect_grid);
	    free_tri_grid(new_ntg);
	    free(new_ntg);
	    free(ic_of_node);
	    DEBUG_LEAVE(rebuild_intfc_at_crossings3d)
	    return NULL;
	}
	stop_clock("remove_unphysical_crossings3d");
	strip_subdomain_bdry_curves(intfc);

	start_clock("reconstruct_intfc3d_in_box");
	if (!reconstruct_intfc3d_in_box(new_ntg,smin,smax,YES))
	{
	    interpolate_intfc_states(intfc) = sav_intrp;
	    new_ntg->grid_intfc = NULL;
	    free_grid_lines(&new_ntg->rect_grid);
	    free_tri_grid(new_ntg);
	    free(new_ntg);
	    free(ic_of_node);
	    DEBUG_LEAVE(rebuild_intfc_at_crossings3d)
	    return NULL;
	}
	stop_clock("reconstruct_intfc3d_in_box");
	print_storage("After reconstruct_intfc3d_in_box","crx_store");

	interpolate_intfc_states(intfc) = NO;
	install_subdomain_bdry_curves(intfc);
	interpolate_intfc_states(intfc) = sav_intrp;

	identify_detached_surface_curve_pair(intfc);

	reset_intfc_num_points(intfc);
	intfc = copy_interface(intfc);
	print_storage("After copy_interface","crx_store");
	free_grid_lines(&new_ntg->rect_grid);
	free_tri_grid(new_ntg);/*deletes new_ntg->grid_intfc*/
	free(new_ntg);
	free(ic_of_node);
	print_storage("After free_tri_grid","crx_store");
	DEBUG_LEAVE(rebuild_intfc_at_crossings3d)
	return intfc;
}	/*end rebuild_intfc_at_crossings3d*/

LOCAL	bool	curves_on_bdry_side(
	int       dir,
	int       side,
	INTERFACE *intfc)
{
	RECT_GRID *gr = computational_grid(intfc);
	CURVE     **c;
	int       idir, iside;
	
	for (c = intfc->curves; c && *c; ++c)
	{
	    if (!is_bdry(*c))
		continue;
	    (void) rect_bdry_side_for_curve(&idir,&iside,*c,gr);
	    if ((idir == dir) && (iside == side))
		return YES;
	}
	return NO;
}		/*end curves_on_bdry_side*/

LOCAL	void set_crx_storage_for_reconstruction(
	TRI_GRID *ntg)
{
	int *gmax = ntg->rect_grid.gmax;
	int dim = ntg->rect_grid.dim;
	int n_segs,n_crx,i,n_reg_nodes;

	n_segs = 0;
	n_reg_nodes = 1;
	for (i = 0; i < dim; ++i)
	{
	    n_segs += gmax[i]*(gmax[(i+1)%3] + 1)*(gmax[(i+2)%3] + 1);
	    n_reg_nodes *= gmax[i] + 1;
	}
	ntg->n_segs = n_segs;

	VECTOR(ntg,seg_crx_count,n_segs,INT);
	for (i = 0; i < n_segs; ++i)
	    ntg->seg_crx_count[i] = 0;

	n_crx = count_grid_crossings_on_intfc3d(ntg);
	ntg->n_crx = n_crx;
	init_seg_crx_lists(ntg,n_crx,n_segs,ON_DUAL_GRID);
	alloc_components_array(ntg,n_reg_nodes);
}	/*end set_crx_storage_for_reconstruction*/

LOCAL   bool remove_unphysical_crossings3d(
        TRI_GRID *ogrid,
        TRI_GRID *ngrid,
        int *smin,
        int *smax)
{
        bool   status;
        int       *gmax = ngrid->rect_grid.gmax;
        COMPONENT *comp = ngrid->components;
        int       i, n_reg_node;

        DEBUG_ENTER(remove_unphysical_crossings3d)

        n_reg_node = (gmax[0]+1)*(gmax[1]+1)*(gmax[2]+1);
        for (i = 0; i < n_reg_node; ++i)
            comp[i] = NO_COMP;

        status = track_comp_through_crxings3d(smin,smax,gmax,ngrid,SINGLE);

        DEBUG_LEAVE(remove_unphysical_crossings3d)
        return FUNCTION_SUCCEEDED;
}       /* end remove_unphysical_crossings3d */

LOCAL   bool repair_intfc3d_in_box(
        TRI_GRID  *ntg,
        int *smin,
        int *smax)
{
        COMPONENT *comp = ntg->components;
        int i,n_reg_node;
        int *gmax = ntg->rect_grid.gmax;
        bool status;

        if (debugging("set_component"))
            (void) printf("Entering repair_intfc3d_in_box()\n");

        n_reg_node = (gmax[0]+1)*(gmax[1]+1)*(gmax[2]+1);
        for (i = 0; i < n_reg_node; ++i)
            comp[i] = NO_COMP;

        status = track_comp_and_repair3d(smin,smax,gmax,ntg);
        status = pp_min_status(status);
        if (status == FUNCTION_FAILED)
        {
            screen("track_comp_and_repair3d() failed!\n");
            return status;
        }
        if (debugging("set_component"))
            (void) printf("Leaving repair_intfc3d_in_box()\n");
        return status;
}       /* end repair_intfc3d_in_box */


LOCAL 	bool reconstruct_intfc3d_in_box(
	TRI_GRID  *ntg,
	int *smin,
	int *smax,
        bool full_reconst)
{
	int		*gmax = ntg->rect_grid.gmax;
	INTERFACE	*ntg_intfc = ntg->grid_intfc;
	BLK_TRI		****blk_mem, *bm, *blk_mem_store;
        COMPONENT       ***compon;
	COMPONENT	c,*comp = ntg->components;
	int		ix, iy, iz, ixx, iyy, izz;
	int             i, j, k, ic, nbc, ip[3];
	static SURFACE	**s;
	static BLK_CRX	*blk_crx;
	BLK_INFO        blk_info;
        int             n_fr_blk = 0;

	DEBUG_ENTER(reconstruct_intfc3d_in_box)

	blk_info.num_surfs = 0;
        for (i = 0, s = ntg_intfc->surfaces; s && *s; ++i, ++s)
            ++blk_info.num_surfs;

        compon = (table_of_interface(ntg_intfc))->compon3d;
        for (iz = smin[2]; iz < smax[2]; ++iz)
            for (iy = smin[1]; iy < smax[1]; ++iy)
                for (ix = smin[0]; ix < smax[0]; ++ix)
                    if (compon[iz][iy][ix] == ONFRONT)
                        n_fr_blk++;

	vector(&blk_info.surfs,blk_info.num_surfs,sizeof(SURFACE*));
	vector(&blk_info.cur_tris,blk_info.num_surfs,sizeof(TRI*));
        for (i = 0, s = ntg_intfc->surfaces; s && *s; ++i, ++s)
        {
            blk_info.surfs[i] = *s;
            if (full_reconst)
            {
                (*s)->num_tri = 0;
                blk_info.cur_tris[i] = NULL;
            }
            else
                blk_info.cur_tris[i] = last_tri(*s);
        }

	if (blk_crx == NULL)
	    blk_crx = alloc_blk_crx(YES);
	tri_array(&blk_mem,smax[2]-smin[2],smax[1]-smin[1],smax[0]-smin[0],
	          sizeof(BLK_TRI*));
	vector(&blk_mem_store,n_fr_blk,sizeof(BLK_TRI));

	nbc = 0;
	for (iz = smin[2]; iz < smax[2]; ++iz)
	{
            for (iy = smin[1]; iy < smax[1]; ++iy)
            {
                for (ix = smin[0]; ix < smax[0]; ++ix)
	        {
	            ixx = ix - smin[0];
	            iyy = iy - smin[1];
	            izz = iz - smin[2];
	            if (compon[iz][iy][ix] == ONFRONT)
	            {
	                bm = blk_mem[izz][iyy][ixx] = &blk_mem_store[nbc++];
	                bm->blk_info = &blk_info;
			blk_crx->num_comps = 0;
	                for (i = 0; i < 2; ++i)
	                {
	                    for (j = 0; j < 2; ++j)
	                    {
	                        for (k = 0; k < 2; ++k)
	                        {
	                            c = comp[d_index3d(ix+i,iy+j,iz+k,gmax)];
				    for (ic = 0; ic < blk_crx->num_comps; ++ic)
				    {
				    	if (c == blk_crx->comps[ic])
		                        {
				            ++blk_crx->nv[ic];
				            break;
				        }
				    }
				    if (ic == blk_crx->num_comps)
				    {
				    	blk_crx->comps[ic] = c;
					blk_crx->nv[ic] = 1;
					++blk_crx->num_comps;
				    }
	                            blk_crx->comp[i][j][k] = c;
	                            blk_crx->ix[i][j][k] = i;
	                            blk_crx->iy[i][j][k] = j;
	                            blk_crx->iz[i][j][k] = k;
	                        }
	                    }
	                }
			for (i = 0; i < blk_crx->num_comps-1; ++i)
			{
			    for (j = 1; j < blk_crx->num_comps; ++j)
			    {
			    	if (blk_crx->nv[i] > blk_crx->nv[j])
				{
				    int nv_tmp;
				    COMPONENT c_tmp;
				    nv_tmp = blk_crx->nv[i];
				    blk_crx->nv[i] = blk_crx->nv[j];
				    blk_crx->nv[j] = nv_tmp;
				    c_tmp = blk_crx->comps[i];
				    blk_crx->comps[i] = blk_crx->comps[j];
				    blk_crx->comps[j] = c_tmp;
				}
			    }
			}
			for (i = 0; i < 2; ++i)
			{
			    for (j = 0; j < 2; ++j)
			    {
				if (blk_crx->comp[0][i][j] !=
				    blk_crx->comp[1][i][j])
				{
				    ip[0] = ix;
				    ip[1] = iy + i;
				    ip[2] = iz + j;
				    fill_block_crx(0,i,j,blk_crx,ip,EAST,ntg);
				}
				else
				    blk_crx->crx[0][i][j]->p = NULL;

				if (blk_crx->comp[j][0][i] !=
				    blk_crx->comp[j][1][i])
				{
				    ip[0] = ix + j;
				    ip[1] = iy;
				    ip[2] = iz + i;
				    fill_block_crx(1,i,j,blk_crx,ip,NORTH,ntg);
				}
				else
				    blk_crx->crx[1][i][j]->p = NULL;

				if (blk_crx->comp[i][j][0] !=
				    blk_crx->comp[i][j][1])
				{
				    ip[0] = ix + i;
				    ip[1] = iy + j;
				    ip[2] = iz;
				    fill_block_crx(2,i,j,blk_crx,ip,UPPER,ntg);
				}
				else
				    blk_crx->crx[2][i][j]->p = NULL;
			    }
			}
	                if (!construct_comp2_blk(blk_crx,bm))
	                {
	                    free(blk_mem);
	                    free(blk_mem_store);
	                    DEBUG_LEAVE(reconstruct_crx_intfc3d)
	                    return FUNCTION_FAILED;
	                }

	                if (ixx != 0)
	                    stitch_adj_blk(blk_mem[izz][iyy][ixx-1],bm);
	                if (iyy != 0)
	                    stitch_adj_blk(blk_mem[izz][iyy-1][ixx],bm);
	                if (izz != 0)
	                    stitch_adj_blk(blk_mem[izz-1][iyy][ixx],bm);
		    }
	            else
	                blk_mem[izz][iyy][ixx] = NULL;
	        }
	    }
	}
	for (iz = smin[2]; iz < smax[2]; ++iz)
	{
            for (iy = smin[1]; iy < smax[1]; ++iy)
            {
                for (ix = smin[0]; ix < smax[0]; ++ix)
	        {
	            ixx = ix - smin[0];
	            iyy = iy - smin[1];
	            izz = iz - smin[2];
	            if (compon[iz][iy][ix] == ONFRONT)
	            {
	                bm = blk_mem[izz][iyy][ixx];
	                if (bm->num_null_sides == 0)
	                    continue;
			bm->blk_info = &blk_info;
	                if (ix != smax[0]-1)
	                    remove_null_pair(bm,blk_mem[izz][iyy][ixx+1],0);
	                if (iy != smax[1]-1)
	                    remove_null_pair(bm,blk_mem[izz][iyy+1][ixx],1);
	                if (iz != smax[2]-1)
	                    remove_null_pair(bm,blk_mem[izz+1][iyy][ixx],2);
	            }
	        }
	    }
	}


	for (i = 0, s = ntg_intfc->surfaces; s && *s; ++i, ++s)
	{
	    if (blk_info.cur_tris[i] != NULL)
	    {
		last_tri(*s) = blk_info.cur_tris[i];
		last_tri(*s)->next = tail_of_tri_list(*s);
		first_tri(*s)->prev = head_of_tri_list(*s);
	    }
	}
	for (i = 0, s = ntg_intfc->surfaces; s && *s; ++i, ++s)
	    if ((*s)->num_tri == 0)
	    	delete_surface(*s);

	free(blk_mem);
	free(blk_mem_store);
	DEBUG_LEAVE(reconstruct_intfc3d_in_box)
	return FUNCTION_SUCCEEDED;
}	/* end reconstruct_intfc3d_in_box */

LOCAL   void fill_block_crx(
        int            i,
        int            j,
        int            k,
        BLK_CRX        *blk_crx,
        int            *ip,
        GRID_DIRECTION dir,
        TRI_GRID       *ntg)
{
        int l,nc,list;
        CRXING *crx;

        l = seg_index3d(ip[0],ip[1],ip[2],dir);
        nc = ntg->seg_crx_count[l];
        if (nc != 0)
        {
            list = ntg->seg_crx_lists[l][0];
            crx = &ntg->crx_store[list];
            blk_crx->crx[i][j][k]->s = Surface_of_hs(crx->hs);
            blk_crx->crx[i][j][k]->p = crx->pt;
        }
}       /* end fill_block_crx */


EXPORT 	bool track_comp_through_crxings3d(
	int 	 *smin,
	int 	 *smax,
	int 	 *gmax,
	TRI_GRID *ntg,
	CRX_TYPE crx_type)
{
        int count = 0; 
	DEBUG_ENTER(track_comp_through_crxings3d)

        /* eliminate duplicate crossings */
        adjust_crossings(smin,smax,ntg);

        /* assign components and isolate unphysical clusters */
        fill_physical_comps(smin,smax,gmax,ntg);

        /* annihilate unphysical clusters */
        while(unset_comp_exist(smin,smax,ntg))
        {
            remove_unphysical_crxings(smin,smax,gmax,ntg,crx_type);
            if (count++ == 4)
            {
                screen("ERROR: unset component still exist after 4 rounds!\n");
                clean_up(ERROR);
            }
        }

        /* check and repair crossings */
        if (!check_and_repair_crx(ntg,smin,smax))
        {
            DEBUG_LEAVE(track_comp_through_crxings3d)
            return FUNCTION_FAILED;
        }
	DEBUG_LEAVE(track_comp_through_crxings3d)
	return FUNCTION_SUCCEEDED;
}	/* end track_comp_through_crxings3d */

#define         MAX_NUM_UNPHY_IP                1000
#define         MAX_NULL_SIDE_LOOP              80

LOCAL   int box_index;

LOCAL   bool track_comp_and_repair3d(
        int  *smin,
        int  *smax,
        int        *gmax,
        TRI_GRID   *ntg)
{
        int num_ip,i;
        static int **ips;
        RECT_BOX *boxes,*pb;

        DEBUG_ENTER(track_comp_and_repair3d)

        if (ips == NULL)
        {
            stat_matrix(&ips,MAX_NUM_UNPHY_IP,3,INT);
        }

        /* eliminate duplicate crossings */
        adjust_crossings(smin,smax,ntg);

        /* assign components and isolate unphysical clusters */
        fill_physical_comps(smin,smax,gmax,ntg);

        /* record all unphysical ip's */
        num_ip = record_unphysical_ips(smin,smax,ntg,ips);
        if (num_ip == 0)
        {
            DEBUG_LEAVE(track_comp_and_repair3d)
            return FUNCTION_SUCCEEDED;
        }
        if (debugging("box_intfc"))
        {
            if (consistent_interface(ntg->grid_intfc))
            {
                (void) printf("Before untangle, interface is consistent!\n");
            }
        }

        set_current_interface(ntg->grid_intfc);
        set_reconstruction_boxes(smin,smax,ips,num_ip,&boxes);

        box_index = 0;
        for (pb = boxes; pb != NULL; pb = pb->next)
        {
            pb->grid = &ntg->rect_grid;
            for (i = 0; i < 3; ++i)
            {
                pb->smin = smin;
                pb->smax = smax;
            }
            if (debugging("box_intfc"))
            {
                printf("\nRectangular box:\n");
                printf("bmin = %-2d  %-2d  %-2d\n",pb->bmin[0],
                        pb->bmin[1],pb->bmin[2]);
                printf("bmax = %-2d  %-2d  %-2d\n",pb->bmax[0],
                        pb->bmax[1],pb->bmax[2]);
            }
            if (!grid_based_box_untangle(ntg,pb))
            {
                DEBUG_LEAVE(track_comp_and_repair3d)
                return FUNCTION_FAILED;
            }

            box_index++;
        }

        if (debugging("box_intfc"))
        {
            if (consistent_interface(ntg->grid_intfc))
            {
                (void) printf("After untangle, interface is consistent!\n");
            }
        }

        DEBUG_LEAVE(track_comp_and_repair3d)
        return FUNCTION_SUCCEEDED;
}       /* end track_comp_and_repair3d */

EXPORT  void initialize_comp_via_crossings(
        TRI_GRID        *ntg)
{
        int             *gmax = ntg->rect_grid.gmax;
        int             ip[3], ipn[3], n_reg_node;
        int             i,k,l,nc,list;
        CRXING          *crx;
        COMPONENT       c, *comp;
        GRID_DIRECTION  dir[3] = {EAST,NORTH,UPPER};

        DEBUG_ENTER(initialize_comp_via_crossings)

        printf("Entering initialize_comp_via_crossings()\n");
        n_reg_node = (gmax[0]+1)*(gmax[1]+1)*(gmax[2]+1);

        comp = ntg->components;
        for (i = 0; i < n_reg_node; ++i)
            comp[i] = NO_COMP;

        /*
        for (ip[2] = 0; ip[2] < gmax[2]; ++ip[2])
        {
            for (ip[1] = 0; ip[1] < gmax[1]; ++ip[1])
            {
                for (ip[0] = 0; ip[0] < gmax[0]; ++ip[0])
                {
                    c = comp[d_index3d(ip[0],ip[1],ip[2],gmax)];
                    for (i = 0; i < 3; ++i)
                    {
                        if (c == ERROR_COMP) continue;
                        k = seg_index3d(ip[0],ip[1],ip[2],dir[i]);
                        nc = ntg->seg_crx_count[k];
                        if (nc == 0) continue;
                        list = ntg->seg_crx_lists[k][0];
                        crx = ntg->crx_store+list;
                        if (c == NO_COMP)
                        {
                            c = comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                        = crx->lcomp;
                        }
                        else if (c != crx->lcomp)
                            c = comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                        = ERROR_COMP;
                        list = ntg->seg_crx_lists[k][nc-1];
                        crx = ntg->crx_store+list;
                        ipn[0] = ip[0];
                        ipn[1] = ip[1];
                        ipn[2] = ip[2];
                        ipn[i] = ip[i] + 1;
                        comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]
                                        = crx->ucomp;
                    }
                }
            }
        }
        */
        /*
        for (ip[2] = 0; ip[2] <= gmax[2]; ++ip[2])
        {
            for (ip[1] = 0; ip[1] <= gmax[1]; ++ip[1])
            {
                for (ip[0] = 0; ip[0] < gmax[0]; ++ip[0])
                {
                    k = seg_index3d(ip[0],ip[1],ip[2],EAST);
                    nc = ntg->seg_crx_count[k];
                }
            }
        }
        {
            int smin[3];
            smin[0] = smin[1] = smin[2] = 0;
            show_grid_components(smin,gmax,2,ntg);
        }
        printf("Leaving initialize_comp_via_crossings()\n");
        exit(0);
        */

        DEBUG_LEAVE(initialize_comp_via_crossings)
}               /*end initialize_comp_via_crossings*/

LOCAL   bool grid_based_box_untangle(
        TRI_GRID *ntg,
        RECT_BOX *box)
{
        struct          Table *T;
        int             *gmax,*smin,*smax;
        TRI             **tris,**tri_list,**in_tris,**out_tris,
                        **sub_in_tris1, **sub_in_tris2, **sub_tris;
        TRI             *in_tri,*out_tri,**new_tris,**null_tris;
        SURFACE         **surfs,*surf;
        INTERFACE       *intfc = ntg->grid_intfc;
        int             i,j,k,l,nt,total_nt;
        int             num_tris,num_in_tris,num_out_tris,num_new_tris,
                        num_fill_tris,num_null_sides,*null_sides, sub_tri_side;
        TRI             *tri, *sub_tri, *nbtri,*last_tris[6];
        FILE            *file;
        char            dname[100],fname[100];
        bool            status;
        POINT           *p0,*p1,*p2,**side_pts;
        int             in_side,out_side, num_sub_in_tris1, num_sub_in_tris2,
                        num_sub_tris;
        bool            end_in_stitch;
        float           dist1,dist2,*tnor;


        smin = box->bmin;
        smax = box->bmax;
        gmax = ntg->rect_grid.gmax;

        if (debugging("box_intfc"))
        {
            (void) printf("Checking consistency before box untangle\n");
            if (!consistent_interface(ntg->grid_intfc))
                clean_up(ERROR);
        }
        remove_unphysical_crxings(smin,smax,gmax,ntg,SINGLE);
        check_and_repair_crx(ntg,smin,smax);

        T = table_of_interface(intfc);
        total_nt = num_tris = num_out_tris = 0;
        for (k = box->bmin[2]; k < box->bmax[2]; ++k)
            for (j = box->bmin[1]; j < box->bmax[1]; ++j)
                for (i = box->bmin[0]; i < box->bmax[0]; ++i)
                    total_nt += T->num_of_tris[k][j][i];

        vector(&tri_list,total_nt,sizeof(TRI*));
        vector(&in_tris,total_nt*3,sizeof(TRI*));
        vector(&out_tris,total_nt,sizeof(TRI*));
        vector(&new_tris, total_nt, sizeof(TRI*));

        for (k = box->bmin[2]; k < box->bmax[2]; ++k)
        {
            for (j = box->bmin[1]; j < box->bmax[1]; ++j)
            {
                for (i = box->bmin[0]; i < box->bmax[0]; ++i)
                {
                    tris = T->tris[k][j][i];
                        nt = T->num_of_tris[k][j][i];
                    for (l = 0; l < nt; ++l)
                    {
                        if (!tri_recorded(tris[l],tri_list,num_tris))
                            tri_list[num_tris++] = tris[l];
                    }
                }
           }
        }
        /*TMP*/
        printf("num_tris = %d\n",num_tris);
        for (i = 0; i < num_tris; ++i)
        {
            int BB = NO;
            tri = tri_list[i];
            for (j = 0; j < 3; ++j)
            {
                if (is_side_bdry(tri,j))
                {
                    out_tris[num_out_tris++] = tri;
                    BB = YES;
                    continue;
                }
                nbtri = Tri_on_side(tri_list[i],j);
                    if (nbtri == NULL)
                        continue;
                    if (!tri_recorded(nbtri,out_tris,num_out_tris) &&
                           !tri_recorded(nbtri,tri_list,num_tris))
                                  out_tris[num_out_tris++] = nbtri;
           }
           if (BB) continue;
           remove_tri_from_surface(tri_list[i],tri_list[i]->surf,NO);
        }
        if (debugging("box_intfc"))
        {
            show_grid_components(smin,smax,0,ntg);
            sprintf(dname,"box-%d-%d",pp_mynode(),box_index);
            if (create_directory(dname,YES) == FUNCTION_FAILED)
            {
                (void) printf("WARNING: in debugging box_intfc, directory "
                          "%s doesn't exist and can't be created\n",dname);
            }
            sprintf(fname,"%s/removal.list",dname);
            file = fopen(fname,"w");
            gview_show_box_tri(box,tri_list,num_tris,file);
            fclose(file);

            sprintf(fname,"%s/neighbor.list",dname);
            file = fopen(fname,"w");
            gview_show_box_tri(box,out_tris,num_out_tris,file);
            fclose(file);
        }

        i = 0;
        for (surfs = intfc->surfaces; surfs && *surfs; ++surfs)
        {
            last_tris[i++] = last_tri(*surfs);
        }
        reconstruct_intfc3d_in_box(ntg,smin,smax,NO);
        i = num_in_tris = 0;
        for (surfs = intfc->surfaces; surfs && *surfs; ++surfs)
        {
            if (at_end_of_tri_list(last_tris[i],*surfs))
                continue;
            for (tri = last_tris[i]->next; !at_end_of_tri_list(tri,*surfs);
                        tri = tri->next)
            {
                in_tris[num_in_tris++] = tri;
                assign_tri_icoords(box->grid,tri);
            }
            ++i;
        }
        /*TMP*/
        printf("num_in_tris = %d\n",num_in_tris);
        num_fill_tris = num_in_tris;

        if (debugging("box_intfc"))
        {
            sprintf(fname,"%s/reconst.list",dname);
            file = fopen(fname,"w");
            gview_show_box_tri(box,in_tris,num_fill_tris,file);
            fclose(file);

            for (i = 0; i < num_out_tris; ++i)
            {
                in_tris[num_fill_tris++] = out_tris[i];
            }
            sprintf(fname,"%s/nb-new.list",dname);
            file = fopen(fname,"w");
            gview_show_box_tri(box,in_tris,num_fill_tris,file);
            fclose(file);
        }
        /*Bifurcation detection and procession*/
        if (bifurcation_detected(in_tris, num_in_tris, &sub_in_tris1,
                 &num_sub_in_tris1, &sub_in_tris2, &num_sub_in_tris2))
        {
            if (debugging("box_intfc"))
            {
                sprintf(fname,"%s/sub_in_tris1.list",dname);
                file = fopen(fname,"w");
                gview_show_box_tri(box,sub_in_tris1,num_sub_in_tris1,file);
                fclose(file);

                sprintf(fname,"%s/sub_in_tris2.list",dname);
                file = fopen(fname,"w");
                gview_show_box_tri(box,sub_in_tris2,num_sub_in_tris2,file);
                fclose(file);

            }
            if ( num_sub_in_tris1 < num_sub_in_tris2 )
            {
                num_sub_tris = num_sub_in_tris1;
                sub_tris = sub_in_tris1;
            }
            else
            {
                num_sub_tris = num_sub_in_tris2;
                sub_tris = sub_in_tris2;
            }

            if( !null_side_tri_in_list(sub_tris,num_sub_tris,
                                &sub_tri,&sub_tri_side))
                printf("Error when self-seal the sub_tris list!\n");
            null_side_loop(sub_tri,sub_tri_side,POSITIVE_ORIENTATION,&null_tris,
                        &null_sides,&side_pts,&num_null_sides,&tnor);
            if (num_null_sides == 3)
            {
                surf = null_tris[0]->surf;
                if (null_tris[0] == null_tris[1] &&
                    null_tris[1] == null_tris[2])
                {
                    remove_tri_from_surface(null_tris[0],surf,NO);
                    for (i = 0; i < num_sub_tris; ++i)
                    {
                        if (sub_tris[i] == sub_tri)
                        {
                            for (j = i; j < num_sub_tris-1; ++j)
                                sub_tris[j] = sub_tris[j+1];
                            --num_sub_tris;
                        }
                   }
                   for (i = 0; i < num_in_tris; ++i)
                   {
                       if (in_tris[i] == sub_tri)
                       {
                           for (j = i; j < num_in_tris-1; ++j)
                               in_tris[j] = in_tris[j+1];
                           --num_in_tris;
                       }
                   }
                }
                else
                {
                    TRI *new_tri;
                    new_tri = make_tri(side_pts[0],side_pts[2],side_pts[1],
                                        NULL,NULL,NULL,NO);
                    insert_tri_at_tail_of_list(new_tri,surf);

                    for (i = 0; i < 3; ++i)
                        link_neighbor_tris(new_tri,null_tris[i]);
                }
            }
            seal_strip_with_tris(box,null_tris,null_sides,num_null_sides,
                        side_pts,tnor,fname,NO);
        }

        /* Reconnect in and out tris */
        find_nearest_tri_pair_new(in_tris,num_in_tris,out_tris,num_out_tris,
                        &in_tri,&in_side,&out_tri,&out_side,box);
        l = 0;
        num_new_tris = 0;
        while (in_tri != NULL && out_tri != NULL)
        {
            TRI *new_tri1,*new_tri2;
            surf = in_tri->surf;
            p0 = Point_of_tri(in_tri)[in_side];
            p1 = Point_of_tri(out_tri)[out_side];
            p2 = Point_of_tri(in_tri)[Next_m3(in_side)];
            new_tri1 = make_tri(p0,p1,p2,NULL,NULL,NULL,NO);
            new_tris[num_new_tris++] = new_tri1;
            insert_tri_at_tail_of_list(new_tri1,surf);
            link_neighbor_tris(new_tri1,in_tri);
            p0 = Point_of_tri(out_tri)[Next_m3(out_side)];
            p1 = Point_of_tri(out_tri)[out_side];
            p2 = Point_of_tri(in_tri)[in_side];
            new_tri2 = make_tri(p0,p1,p2,NULL,NULL,NULL,NO);
            new_tris[num_new_tris++] = new_tri2;
            insert_tri_at_tail_of_list(new_tri2,surf);

            link_neighbor_tris(new_tri2,out_tri);
            link_neighbor_tris(new_tri2,new_tri1);
            find_nearest_tri_pair_new(in_tris,num_in_tris,out_tris,num_out_tris,
                        &in_tri,&in_side,&out_tri,&out_side,box);
            if (++l > 500) exit(0);
        }

        for (i = 0; i < num_new_tris-1; ++i)
            for (j = i; j < num_new_tris; ++j)
                link_neighbor_tris(new_tris[i],new_tris[j]);

        /* Self-seal the in_tris list */
        l = 0;
        while (null_side_tri_in_list(in_tris,num_in_tris,&in_tri,&in_side))
        {
            null_side_loop(in_tri,in_side,POSITIVE_ORIENTATION,&null_tris,
                        &null_sides,&side_pts,&num_null_sides,&tnor);
            if (num_null_sides == 3)
            {
                surf = null_tris[0]->surf;
                if (null_tris[0] == null_tris[1] &&
                    null_tris[1] == null_tris[2])
                {
                    remove_tri_from_surface(null_tris[0],surf,NO);
                    for (i = 0; i < num_in_tris; ++i)
                    {
                        if (in_tris[i] == in_tri)
                        {
                            for (j = i; j < num_in_tris-1; ++j)
                                in_tris[j] = in_tris[j+1];
                            --num_in_tris;
                        }
                   }
                }
                else
                {
                    TRI *new_tri;
                    new_tri = make_tri(side_pts[0],side_pts[2],side_pts[1],
                                        NULL,NULL,NULL,NO);
                    insert_tri_at_tail_of_list(new_tri,surf);

                    for (i = 0; i < 3; ++i)
                        link_neighbor_tris(new_tri,null_tris[i]);
                }
                continue;
            }
            if (debugging("box_intfc"))
            {
                sprintf(fname,"%s/seal-in-%d",dname,l);
                                l++;
            }
            if (l > 10) exit(0);

           seal_strip_with_tris(box,null_tris,null_sides,num_null_sides,
                        side_pts,tnor,fname,NO);
        }

        /* Self-seal the out_tris list */
        l = 0;
        while (null_side_tri_in_list(out_tris,num_out_tris,&out_tri,&out_side))
        {
            null_side_loop(out_tri,out_side,POSITIVE_ORIENTATION,&null_tris,
                        &null_sides,&side_pts,&num_null_sides,&tnor);
            if (num_null_sides == 3)
            {
                surf = null_tris[0]->surf;
                if (null_tris[0] == null_tris[1] &&
                    null_tris[1] == null_tris[2])
                {
                    remove_tri_from_surface(null_tris[0],surf,NO);
                    for (i = 0; i < num_out_tris; ++i)
                    {
                        if (out_tris[i] == out_tri)
                        {
                            for (j = i; j < num_out_tris-1; ++j)
                                out_tris[j] = out_tris[j+1];
                            --num_out_tris;
                        }
                    }
                }
                else
                {
                    TRI *new_tri;
                    new_tri = make_tri(side_pts[0],side_pts[2],side_pts[1],
                                        NULL,NULL,NULL,NO);
                    insert_tri_at_tail_of_list(new_tri,surf);
                    for (i = 0; i < 3; ++i)
                    {
                        link_neighbor_tris(new_tri,null_tris[i]);
                    }
                }
                continue;
            }//end if(num_sides==3)

            if (debugging("box_intfc"))
            {
                sprintf(fname,"%s/seal-out-%d",dname,l);
                                l++;
            }
            seal_strip_with_tris(box,null_tris,null_sides,num_null_sides,
                        side_pts,tnor,fname,NO);
        }

        if (debugging("box_intfc"))
        {
            /*
            printf("Global Check extension of surface "
                                "before leaving box_untangle!\n");

            for (surfs = intfc->surfaces; surfs && *surfs; ++surfs)
            {
                check_extension_of_surface_global(*surfs);
            }
            printf("Finish Global checking extension of"
                        "surface before leaving box_untangle!\n");
            */

            (void) printf("Checking consistency after box untangle\n");
            if (consistent_interface(ntg->grid_intfc))
            {
                (void) printf("Interface is consistent!\n");
            }
            else
            {
                printf("Interface is inconsistent!\n");
                clean_up(ERROR);
            }
        }
        free_these(4,tri_list,in_tris,out_tris,new_tris);
        return FUNCTION_SUCCEEDED;
}       /* end grid_based_box_untangle */

/*************************************************************************
*                                                                        *
*                         /\                                             *
*                        /  \ in_tri                                     *
*                       /    \                                           *
*                    vi---------------------------------|                *
*                     /| in_side                        |                *
*                    / |                                |                *
*                   /  |                                |                *
*         base_tri  \  |      strip to be triangulated  |                *
*                    \ |                                |                *
*                     \| out_side                       |                *
*                    vo---------------------------------|                *
*                       \    /                                           *
*                        \  / out_tri                                    *
*                         \/                                             *
*                                                                        *
*************************************************************************/

LOCAL   bool seal_strip_with_tris(
        RECT_BOX *box,
        TRI **null_tris,
        int *null_sides,
        int num_null_sides,
        POINT **pts,
        float *tnor,
        char *base_name,
        bool zero_base)
{
        POINT *p0,*p1,*p2,*vi,*vo;
        TRI *new_tri,**newtris,**debug_tris;
        TRI *in_tri,*out_tri,*base_tri;
        int in_side,out_side;
        int i,j,num_newtris;
        int i_base,i_in,i_out;
        bool end_in_stitch = NO;
        float dist1,dist2,min_dist = HUGE;
        SURFACE *surf;
        FILE *file;
        char fname[100];

        if (debugging("box_intfc"))
        {
            sprintf(fname,"%s-nullsides.list",base_name);
            file = fopen(fname,"w");
            gview_show_box_tri(box,null_tris,num_null_sides,file);
            fclose(file);
        }
            if (zero_base) i_base = 0;
            else
            {
                /* Determine base_tri:*/
                for (i = 0; i < num_null_sides; ++i)
                {
                    check_tri_and_neighbor(null_tris[i]);
                    p1 = Point_of_tri(null_tris[i])[null_sides[i]];
                    p2 = Point_of_tri(null_tris[(i+1)%num_null_sides])
                        [Next_m3(null_sides[(i+1)%num_null_sides])];
                    dist1 = distance_between_positions(Coords(p1),
                                        Coords(p2),3);
                    if (dist1 < min_dist)
                    {
                        i_base = i;
                        min_dist = dist1;
                    }
                }
            }
            i_out = (i_base+num_null_sides-1)%num_null_sides;
            i_in  = (i_base+1)%num_null_sides;

            in_tri   = null_tris[i_in];
            base_tri = null_tris[i_base];
            out_tri  = null_tris[i_out];
            in_side  = null_sides[i_in];
            out_side = null_sides[i_out];

            check_tri_and_neighbor(out_tri);

            vi = Point_of_tri(in_tri)[null_sides[i_in]];
            vo = Point_of_tri(out_tri)[Next_m3(null_sides[i_out])];
            surf = base_tri->surf;

        if (debugging("box_intfc"))
        {
            vector(&debug_tris,300,sizeof(TRI*));
            num_newtris = 0;
            for (i = 0; i < num_null_sides; ++i)
                debug_tris[num_newtris++] = null_tris[i];
        }
        while (!end_in_stitch)
        {
            dist1 = distance_between_positions(Coords(vo),
                        Coords(Point_of_tri(in_tri)[Next_m3(in_side)]),3);
            dist2 = distance_between_positions(Coords(vi),
                        Coords(Point_of_tri(out_tri)[out_side]),3);

            if ((null_tris[i_in] == null_tris[(i_in+1)%num_null_sides])||
                (null_tris[i_base] == null_tris[i_out]))
            {
                p0 = vi;
                p1 = vo;
                p2 = Point_of_tri(in_tri)[Next_m3(in_side)];
                new_tri = make_tri(p0,p1,p2,(POINTER)base_tri,
                                NULL,(POINTER)in_tri,NO);
                insert_tri_at_tail_of_list(new_tri,surf);
                link_neighbor_tris(new_tri,in_tri);
                link_neighbor_tris(new_tri,base_tri);
                if (debugging("box_intfc"))
                {
                    debug_tris[num_newtris++] = new_tri;
                    sprintf(fname,"%s-debug-%d.list",base_name, num_newtris-num_null_sides);
                    file = fopen(fname,"w");
                    gview_show_box_tri(box,debug_tris,num_newtris,file);
                    fclose(file);
                }
                vi = p2;
                i_in  = (i_in+1)%num_null_sides;
                in_tri = null_tris[i_in];
                in_side = null_sides[i_in];
                if (in_tri == out_tri)
                {
                    end_in_stitch = YES;
                    break;
                }
            }
            else if ((null_tris[i_out] ==
                null_tris[(i_out-1+num_null_sides)%num_null_sides])||
                    (null_tris[i_base] == null_tris[i_in]))
            {
                p0 = vo;
                p1 = Point_of_tri(out_tri)[out_side];
                p2 = vi;
                new_tri = make_tri(p0,p1,p2,(POINTER)out_tri,
                                NULL,(POINTER)base_tri,NO);
                insert_tri_at_tail_of_list(new_tri,surf);
                link_neighbor_tris(new_tri,out_tri);
                link_neighbor_tris(new_tri,base_tri);

                if (debugging("box_intfc"))
                {
                    debug_tris[num_newtris++] = new_tri;
                    sprintf(fname,"%s-debug-%d.list",base_name, num_newtris-num_null_sides);
                    file = fopen(fname,"w");
                    gview_show_box_tri(box,debug_tris,num_newtris,file);
                    fclose(file);
                }

                vo = p1;
                i_out = (i_out+num_null_sides-1)%num_null_sides;
                out_tri = null_tris[i_out];
                out_side = null_sides[i_out];
                if (out_tri == in_tri)
                {
                    end_in_stitch = YES;
                    break;
                }
            }
            else if (dist1 < dist2)
            {
                p0 = vi;
                p1 = vo;
                p2 = Point_of_tri(in_tri)[Next_m3(in_side)];
                new_tri = make_tri(p0,p1,p2,(POINTER)base_tri,
                                NULL,(POINTER)in_tri,NO);
                insert_tri_at_tail_of_list(new_tri,surf);
                link_neighbor_tris(new_tri,in_tri);
                link_neighbor_tris(new_tri,base_tri);


                if (debugging("box_intfc"))
                {
                    debug_tris[num_newtris++] = new_tri;
                    sprintf(fname,"%s-debug-%d.list",base_name, num_newtris-num_null_sides);
                    file = fopen(fname,"w");
                    gview_show_box_tri(box,debug_tris,num_newtris,file);
                    fclose(file);
                }

                vi = p2;
                i_in  = (i_in+1)%num_null_sides;
                in_tri = null_tris[i_in];
                in_side = null_sides[i_in];
                if (in_tri == out_tri)
                {
                    end_in_stitch = YES;
                    break;
                }
            }
            else
            {
                p0 = vo;
                p1 = Point_of_tri(out_tri)[out_side];
                p2 = vi;
                new_tri = make_tri(p0,p1,p2,(POINTER)out_tri,
                                NULL,(POINTER)base_tri,NO);
                insert_tri_at_tail_of_list(new_tri,surf);
                link_neighbor_tris(new_tri,out_tri);
                link_neighbor_tris(new_tri,base_tri);

                if (debugging("box_intfc"))
                {
                    debug_tris[num_newtris++] = new_tri;
                    sprintf(fname,"%s-debug-%d.list",base_name, num_newtris-num_null_sides);
                    file = fopen(fname,"w");
                    gview_show_box_tri(box,debug_tris,num_newtris,file);
                    fclose(file);
                }


                vo = p1;
                i_out = (i_out+num_null_sides-1)%num_null_sides;
                out_tri = null_tris[i_out];
                out_side = null_sides[i_out];
                if (out_tri == in_tri)
                {
                    end_in_stitch = YES;
                    break;
                }
            }
            base_tri = new_tri;
            if (Point_of_tri(in_tri)[Next_m3(in_side)] ==
                Point_of_tri(out_tri)[out_side])
            {
                p0 = vi;
                p1 = vo;
                p2 = Point_of_tri(out_tri)[out_side];
                base_tri = new_tri;
                new_tri = make_tri(p0,p1,p2,(POINTER)base_tri,
                                (POINTER)out_tri,(POINTER)in_tri,NO);
                insert_tri_at_tail_of_list(new_tri,surf);
                link_neighbor_tris(new_tri,in_tri);
                link_neighbor_tris(new_tri,out_tri);
                link_neighbor_tris(new_tri,base_tri);

                if (debugging("box_intfc"))
                {
                    debug_tris[num_newtris++] = new_tri;
                    sprintf(fname,"%s-debug-%d.list",base_name, num_newtris-num_null_sides);
                    file = fopen(fname,"w");
                    gview_show_box_tri(box,debug_tris,num_newtris,file);
                    fclose(file);
                }
                end_in_stitch = YES;
            }
        }
        if (debugging("box_intfc"))
        {
            sprintf(fname,"%s-newtris.list",base_name);
            file = fopen(fname,"w");
            gview_show_box_tri(box,debug_tris,num_newtris,file);
            fclose(file);
            free_these(1,debug_tris);
        }
        return FUNCTION_SUCCEEDED;
}       /* end seal_strip_with_tris */

/*
        Note:Function find_nearest_tri_pair() is gonna replace by
             find_nearest_tri_pair_new()
*/
LOCAL   void find_nearest_tri_pair(
        TRI **in_tris,
        int num_in_tris,
        TRI **out_tris,
        int num_out_tris,
        TRI **in_tri,
        int *in_side,
        TRI **out_tri,
        int *out_side,
        RECT_BOX *box)
{
        float *pi,*po;
        int i,j,k,l;
        float dist;
        float min_dist = HUGE;
        RECT_GRID *rgr = box->grid;
        int ipo[3],*ipi;

        *in_tri = *out_tri = NULL;

        for (i = 0; i < num_out_tris; ++i)
        {
            for (j = 0; j < 3; ++j)
            {
                if (Tri_on_side(out_tris[i],j) == NULL)
                {
                    po = Coords(Point_of_tri(out_tris[i])[j]);
                    rect_in_which(po,ipo,rgr);
                    for (k = 0; k < num_in_tris; ++k)
                    {
                        ipi = Tri_icoords(in_tris[k]);
                        if (!adjacent_cell(ipo,ipi))
                            continue;
                        for (l = 0; l < 3; ++l)
                        {
                            if (Tri_on_side(in_tris[k],l) != NULL)
                                continue;
                            pi = Coords(Point_of_tri(in_tris[k])[Next_m3(l)]);
                            dist = distance_between_positions(pi,po,3);
                            if (dist < min_dist)
                            {
                                min_dist = dist;
                                *out_tri = out_tris[i];
                                *out_side = j;
                                *in_tri = in_tris[k];
                                *in_side = l;
                            }
                        }
                    }
                }
            }
        }
}       /* end find_nearest_tri_pair */

LOCAL   void find_nearest_tri_pair_new(
        TRI **in_tris,
        int num_in_tris,
        TRI **out_tris,
        int num_out_tris,
        TRI **in_tri,
        int *in_side,
        TRI **out_tri,
        int *out_side,
        RECT_BOX *box)
{
        float *pi,*po, *pi1, *po1;
        int i,j,k,l;
        float dist;
        float min_dist = HUGE;
        RECT_GRID *rgr = box->grid;
        int ipo[3],*ipi;

        *in_tri = *out_tri = NULL;

        for (i = 0; i < num_out_tris; ++i)
        {
            for (j = 0; j < 3; ++j)
            {
                if (Tri_on_side(out_tris[i],j) == NULL)
                {
                    po = Coords(Point_of_tri(out_tris[i])[j]);
                    po1 = Coords(Point_of_tri(out_tris[i])[Next_m3(j)]);
                    rect_in_which(po,ipo,rgr);
                    for (k = 0; k < num_in_tris; ++k)
                    {
                        ipi = Tri_icoords(in_tris[k]);
                        if (!adjacent_cell(ipo,ipi))
                            continue;
                        for (l = 0; l < 3; ++l)
                        {
                            if (Tri_on_side(in_tris[k],l) != NULL)
                                continue;

                            /*Find suitable null sides pair*/
                            if (!null_sides_with_suitable_angle(out_tris[i],
                                        j, in_tris[k], l))
                                continue;

                            pi = Coords(Point_of_tri(in_tris[k])[Next_m3(l)]);
                            pi1 = Coords(Point_of_tri(in_tris[k])[l]);
                            dist = distance_between_positions(pi,po,3)+
                                      distance_between_positions(pi1, po1, 3);
                            if (dist < min_dist)
                            {
                                min_dist = dist;
                                *out_tri = out_tris[i];
                                *out_side = j;
                                *in_tri = in_tris[k];
                                *in_side = l;
                            }
                        }
                    }
                }
            }
        }
}       /* end find_nearest_tri_pair_new */

LOCAL   void gview_show_box_tri(
        RECT_BOX *box,
        TRI **tris,
        int num_tris,
        FILE *file)
{
        static const char *indent = "    ";
        POINT *p;
        int i,j,k;
        int nls;        /* number of grid lines */
        float *L = box->grid->L;
        float *U = box->grid->U;
        float *h = box->grid->h;

        (void) fprintf(file,"{ LIST\n");

        nls = (box->bmax[0] - box->bmin[0] + 1)*
              (box->bmax[1] - box->bmin[1] + 1) +
              (box->bmax[1] - box->bmin[1] + 1)*
              (box->bmax[2] - box->bmin[2] + 1) +
              (box->bmax[2] - box->bmin[2] + 1)*
              (box->bmax[0] - box->bmin[0] + 1);

        (void) fprintf(file,"%s{\n%s%sOFF\n%s%s%6d %6d %6d\n",
                        indent,indent,indent,indent,indent,
                        2*nls,nls,0);
        for (i = box->bmin[0]; i <= box->bmax[0]; ++i)
        {
            for (j = box->bmin[1]; j <= box->bmax[1]; ++j)
            {
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + i*h[0],L[1] + j*h[1],
                        L[2] + box->bmin[2]*h[2]);
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + i*h[0],L[1] + j*h[1],
                        L[2] + box->bmax[2]*h[2]);
            }
        }
        for (j = box->bmin[1]; j <= box->bmax[1]; ++j)
        {
            for (k = box->bmin[2]; k <= box->bmax[2]; ++k)
            {
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + box->bmin[0]*h[0],L[1] + j*h[1],
                        L[2] + k*h[2]);
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + box->bmax[0]*h[0],L[1] + j*h[1],
                        L[2] + k*h[2]);
            }
        }
        for (k = box->bmin[2]; k <= box->bmax[2]; ++k)
        {
            for (i = box->bmin[0]; i <= box->bmax[0]; ++i)
            {
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + i*h[0],L[1] + box->bmin[1]*h[1],
                        L[2] + k*h[2]);
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        L[0] + i*h[0],L[1] + box->bmax[1]*h[1],
                        L[2] + k*h[2]);
            }
        }
        for (i = 0; i < nls; ++i)
        {
            (void) fprintf(file,"%s%s%-4d %-4d %-4d\n",indent,indent,
                        2,2*i,2*i+1);
        }
        (void) fprintf(file,"%s}\n",indent);

        (void) fprintf(file,"%s{\n%s%sOFF\n%s%s%6d %6d %6d\n",
                        indent,indent,indent,indent,indent,
                        3*num_tris,num_tris,0);
        for (i = 0; i < num_tris; ++i)
        {
            for (j = 0; j < 3; ++j)
            {
                p = Point_of_tri(tris[i])[j];
                (void) fprintf(file, "%s%s%-9g %-9g %-9g\n",indent,indent,
                        Coords(p)[0],Coords(p)[1],Coords(p)[2]);
            }
        }
        for (i = 0; i < num_tris; ++i)
        {
            (void) fprintf(file,"%s%s%-4d %-4d %-4d %-4d\n",indent,indent,
                        3,3*i,3*i+1,3*i+2);
        }
        (void) fprintf(file,"%s}\n",indent);
        (void) fprintf(file,"}\n");
}       /* end gview_show_box_tri */

LOCAL   bool tri_recorded(
        TRI *tri,
        TRI **tri_list,
        int num_tris)
{
        int i;
        for (i = 0; i < num_tris; ++i)
            if (tri == tri_list[i]) return YES;
        return NO;
}       /* end tri_recorded */

LOCAL   void set_reconstruction_boxes(
        int *smin,
        int *smax,
        int **ips,
        int num_ip,
        RECT_BOX **boxes)
{
        RECT_BOX Box,*box,*nbox;
        int **pip,nb,itmp[3];
        int i,j,k;

        Box.prev = Box.next = NULL;
        box = &Box;

        i = 0;
        while (i < num_ip)
        {
            box->next = (RECT_BOX *)store(sizeof(RECT_BOX));
            box->next->prev = box;
            box->next->next = NULL;
            box = box->next;
            pip = ips + i;
            nb = 1;
            for (j = i+1; j < num_ip; ++j)
            {
                if (ip_connected(pip,nb,ips[j]))
                {
                    if (j > i+nb)
                    {
                        for (k = 0; k < 3; ++k)
                        {
                            itmp[k] = ips[j][k];
                            ips[j][k] = pip[nb][k];
                            pip[nb][k] = itmp[k];
                        }
                    }
                    j = i + nb;
                    nb++;
                }
            }
            for (k = 0; k < 3; k++)
                box->bmin[k] = box->bmax[k] = pip[0][k];
            for (j = 1; j < nb; j++)
            {
                for (k = 0; k < 3; k++)
                {
                    if (box->bmin[k] > pip[j][k])
                        box->bmin[k] = pip[j][k];
                    if (box->bmax[k] < pip[j][k])
                        box->bmax[k] = pip[j][k];
                }
            }
            i += nb;
        }
        for (box = Box.next; box != NULL; box = box->next)
        {
            for (i = 0; i < 3; i++)
            {
                box->bmin[i]--;
                box->bmax[i]++;
                /*
                if (box->bmin[i] < smin[i]) box->bmin[i] = smin[i];
                if (box->bmax[i] > smax[i]) box->bmax[i] = smax[i];
                */
                if ((box->bmin[i] < smin[i]) || (box->bmax[i] > smax[i]))
                {
                    box->bmin[i] = smin[i];
                    box->bmax[i] = smax[i];
                }
            }
        }
        /* Merge overlapping boxes */
        for (box = Box.next; box != NULL; box = box->next)
        {
            for (nbox = box->next; nbox != NULL; nbox = nbox->next)
            {
                if (overlapping_boxes(box,nbox))
                {
                    for (i = 0; i < 3; ++i)
                    {
                        box->bmin[i] = min(box->bmin[i],nbox->bmin[i]);
                        box->bmax[i] = max(box->bmax[i],nbox->bmax[i]);
                    }
                    nbox->prev->next = nbox->next;
                    if (nbox->next != NULL)
                        nbox->next->prev = nbox->prev;
                    nbox = box;
                }
            }
        }
        *boxes = Box.next;
}       /* end set_reconstruction_boxes */

LOCAL   bool overlapping_boxes(
        RECT_BOX *box1,
        RECT_BOX *box2)
{
        int i,j,k,ip[3];
        for (i = 0; i < 2; ++i)
        {
            ip[0] = (i == 0) ? box1->bmin[0] : box1->bmax[0];
            if (ip[0] > box2->bmax[0] || ip[0] < box2->bmin[0])
                continue;
            for (j = 0; j < 2; ++j)
            {
                ip[1] = (j == 0) ? box1->bmin[1] : box1->bmax[1];
                if (ip[1] > box2->bmax[1] || ip[1] < box2->bmin[1])
                    continue;
                for (k = 0; k < 2; ++k)
                {
                    ip[2] = (k == 0) ? box1->bmin[2] : box1->bmax[2];
                    if (ip[2] > box2->bmax[2] || ip[2] < box2->bmin[2])
                        continue;
                    return YES;
                }
            }
        }
        for (i = 0; i < 2; ++i)
        {
            ip[0] = (i == 0) ? box2->bmin[0] : box2->bmax[0];
            if (ip[0] > box1->bmax[0] || ip[0] < box1->bmin[0])
                continue;
            for (j = 0; j < 2; ++j)
            {
                ip[1] = (j == 0) ? box2->bmin[1] : box2->bmax[1];
                if (ip[1] > box1->bmax[1] || ip[1] < box1->bmin[1])
                    continue;
                for (k = 0; k < 2; ++k)
                {
                    ip[2] = (k == 0) ? box2->bmin[2] : box2->bmax[2];
                    if (ip[2] > box1->bmax[2] || ip[2] < box1->bmin[2])
                        continue;
                    return YES;
                }
            }
        }
        return NO;
}       /* end end overlapping_box */


LOCAL   bool ip_connected(
        int **ips,
        int nb,
        int *ip)
{
        int i,k,ni,na;
        for (i = 0; i < nb; ++i)
        {
            ni = na = 0;
            for (k = 0; k < 3; ++k)
            {
                if (ips[i][k] == ip[k])
                    ni++;
                else if (ips[i][k] - ip[k] == 1 ||
                         ips[i][k] - ip[k] == -1)
                    na++;
            }
            if (ni == 2 && na == 1) return YES;
        }
        return NO;
}       /* end ip_connected */

LOCAL   int record_unphysical_ips(
        int      *smin,
        int      *smax,
        TRI_GRID *ntg,
        int      **ips)
{
        GRID_DIRECTION  dir[6] = {WEST,EAST,SOUTH,NORTH,LOWER,UPPER};
        int             ip[3],i,num_ip = 0;;
        DEBUG_ENTER(record_unphysical_ips)

        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    for (i = 0; i < 6; ++i)
                    {
                        if (ip[0] == smin[0] && dir[i] == WEST)
                            continue;
                        if (ip[0] == smax[0] && dir[i] == EAST)
                            continue;
                        if (ip[1] == smin[1] && dir[i] == SOUTH)
                            continue;
                        if (ip[1] == smax[1] && dir[i] == NORTH)
                            continue;
                        if (ip[2] == smin[2] && dir[i] == LOWER)
                            continue;
                        if (ip[2] == smax[2] && dir[i] == UPPER)
                            continue;
                        if (unphysical_edge(ip,dir[i],ntg,smin,smax,MULTIPLE)
                                != YES)
                        {
                            ips[num_ip][0] = ip[0];
                            ips[num_ip][1] = ip[1];
                            ips[num_ip][2] = ip[2];
                            /*TMP*/
                            printf("ip = %d %d %d\n",ip[0],ip[1],ip[2]);
                            ++num_ip;
                            break;
                        }
                    }
                }
            }
        }
        DEBUG_LEAVE(record_unphysical_ips)
        return num_ip;
}       /* end record_unphysical_ips */

LOCAL   bool unset_comp_exist(
        int      *smin,
        int      *smax,
        TRI_GRID *ntg)
{
        COMPONENT       *comp = ntg->components;
        int             *gmax = ntg->rect_grid.gmax;
        int             ip[3];

        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] == NO_COMP)
                        return YES;
                }
            }
        }
        return NO;
}       /* end unset_comp_exist */

LOCAL   int check_and_unset_bad_comp(
        int      *smin,
        int      *smax,
        TRI_GRID *ntg)
{
        GRID_DIRECTION  dir[6] = {WEST,EAST,SOUTH,NORTH,LOWER,UPPER};
        int             ip[3],i,num_bad_nb;
        int             status = YES;
        int             *gmax = ntg->rect_grid.gmax;
        COMPONENT       *comp = ntg->components;
        bool            ***unset;
        DEBUG_ENTER(check_and_unset_bad_comp)

        tri_array(&unset,gmax[0]+1,gmax[1]+1,gmax[2]+1,sizeof(bool));
        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    num_bad_nb = 0;
                    for (i = 0; i < 6; ++i)
                    {
                        if (ip[0] == smin[0] && dir[i] == WEST)
                            continue;
                        if (ip[0] == smax[0] && dir[i] == EAST)
                            continue;
                        if (ip[1] == smin[1] && dir[i] == SOUTH)
                            continue;
                        if (ip[1] == smax[1] && dir[i] == NORTH)
                            continue;
                        if (ip[2] == smin[2] && dir[i] == LOWER)
                            continue;
                        if (ip[2] == smax[2] && dir[i] == UPPER)
                            continue;
                        if (unphysical_edge(ip,dir[i],ntg,smin,smax,MULTIPLE)
                                        != YES)
                        {
                            ++num_bad_nb;
                            status = NO;
                        }
                    }
                    if (num_bad_nb != 0)
                        unset[ip[0]][ip[1]][ip[2]] = YES;
                    else
                        unset[ip[0]][ip[1]][ip[2]] = NO;
                }
            }
        }
        if (status == YES)
        {
            free_these(1,unset);
            DEBUG_LEAVE(check_and_unset_bad_comp)
            return status;
        }
        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    if (unset[ip[0]][ip[1]][ip[2]] == YES)
                        comp[d_index3d(ip[0],ip[1],ip[2],gmax)] = NO_COMP;
                }
            }
        }
        free_these(1,unset);
        DEBUG_LEAVE(check_and_unset_bad_comp)
        return status;
}       /* end check_and_unset_bad_comp */

LOCAL   void fill_physical_comps(
        int      *smin,
        int      *smax,
        int      *gmax,
        TRI_GRID *ntg)
{
        int             k,l,nc,list,step;
        int             ip[3];
        COMPONENT       *comp = ntg->components;
        COMPONENT       cn;
        CRXING          *crx;
        bool            status;

        for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[2] = smin[2]+1; ip[2] < smax[2]; ++ip[2])
                {
                    if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] == NO_COMP)
                    {
                        k = seg_index3d(ip[0],ip[1],ip[2],LOWER);
                        nc = ntg->seg_crx_count[k];
                        if (nc == 0)
                        {
                            k = seg_index3d(ip[0],ip[1],ip[2],UPPER);
                            nc = ntg->seg_crx_count[k];
                            if (nc == 0)
                                continue;
                            list = ntg->seg_crx_lists[k][0];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->lcomp;
                        }
                        else
                        {
                            list = ntg->seg_crx_lists[k][nc-1];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->ucomp;
                        }
                    }

                    if (ip[2] != 0)
                    {
                        cn = comp[d_index3d(ip[0],ip[1],ip[2]-1,gmax)];
                        if (cn == NO_COMP)
                        {
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,LOWER);
                        }
                    }
                    if (ip[2] != smax[2])
                    {
                        cn = comp[d_index3d(ip[0],ip[1],ip[2]+1,gmax)];
                        if (cn == NO_COMP)
                        {
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,UPPER);
                            ip[2] += step;
                        }
                    }
                }
            }
        }
        status = check_and_unset_bad_comp(smin,smax,ntg);
        if (status == YES)
            return;
        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
            {
                for (ip[1] = smin[1]+1; ip[1] < smax[1]; ++ip[1])
                {
                    if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] == NO_COMP)
                    {
                        k = seg_index3d(ip[0],ip[1],ip[2],SOUTH);
                        nc = ntg->seg_crx_count[k];
                        if (nc == 0)
                        {
                            k = seg_index3d(ip[0],ip[1],ip[2],NORTH);
                            nc = ntg->seg_crx_count[k];
                            if (nc == 0)
                                continue;
                            list = ntg->seg_crx_lists[k][0];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->lcomp;
                        }
                        else
                        {
                            list = ntg->seg_crx_lists[k][nc-1];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->ucomp;
                        }
                    }

                    if (ip[1] != 0)
                    {
                        cn = comp[d_index3d(ip[0],ip[1]-1,ip[2],gmax)];
                        if (cn == NO_COMP)
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,SOUTH);
                    }
                    if (ip[1] != smax[1])
                    {
                        cn = comp[d_index3d(ip[0],ip[1]+1,ip[2],gmax)];
                        if (cn == NO_COMP)
                        {
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,NORTH);
                            ip[1] += step;
                        }
                    }
                }
            }
        }
        status = check_and_unset_bad_comp(smin,smax,ntg);
        if (status == YES)
            return;
        for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
        {
            for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
            {
                for (ip[0] = smin[0]+1; ip[0] < smax[0]; ++ip[0])
                {
                    if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] == NO_COMP)
                    {
                        k = seg_index3d(ip[0],ip[1],ip[2],WEST);
                        nc = ntg->seg_crx_count[k];
                        if (nc == 0)
                        {
                            k = seg_index3d(ip[0],ip[1],ip[2],EAST);
                            nc = ntg->seg_crx_count[k];
                            if (nc == 0)
                                continue;
                            list = ntg->seg_crx_lists[k][0];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->lcomp;
                        }
                        else
                        {
                            list = ntg->seg_crx_lists[k][nc-1];
                            crx = ntg->crx_store+list;
                            comp[d_index3d(ip[0],ip[1],ip[2],gmax)]
                                                = crx->ucomp;
                        }
                    }

                    if (ip[0] != 0)
                    {
                        cn = comp[d_index3d(ip[0]-1,ip[1],ip[2],gmax)];
                        if (cn == NO_COMP)
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,WEST);
                    }
                    if (ip[0] != smax[0])
                    {
                        cn = comp[d_index3d(ip[0]+1,ip[1],ip[2],gmax)];
                        if (cn == NO_COMP)
                        {
                            step = walk_comp_along_grid_line(ntg,smin,smax,
                                                             gmax,ip,EAST);
                            ip[0] += step;
                        }
                    }

                }
            }
        }
        status = check_and_unset_bad_comp(smin,smax,ntg);
        if (debugging("crx_intfc"))
        {
            if (status != YES)
            {
                printf("After third check: status = %d\n",status);
                show_grid_components(smin,gmax,2,ntg);
            }
        }
}       /* end fill_physical_comps */

LOCAL   void remove_unphysical_crxings(
        int      *smin,
        int      *smax,
        int      *gmax,
        TRI_GRID *ntg,
        CRX_TYPE crx_type)
{
        int             ix, iy, iz, step;
        int             ip[3];
        COMPONENT       *comp = ntg->components;
        COMPONENT       c,cn;

        /* remove unphysical crossings */

        for (ix = smin[0]; ix <= smax[0]; ++ix)
        {
            ip[0] = ix;
            for (iy = smin[1]; iy <= smax[1]; ++iy)
            {
                ip[1] = iy;
                for (iz = smin[2]; iz <= smax[2]; ++iz)
                {
                    ip[2] = iz;
                    c = comp[d_index3d(ix,iy,iz,gmax)];
                    if (c == NO_COMP)
                        continue;

                    if (iz != 0)
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,LOWER,crx_type);
                    if (iz != smax[2])
                    {
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,UPPER,crx_type);
                        iz += step;
                    }
                }
            }
        }
        for (iz = smin[2]; iz <= smax[2]; ++iz)
        {
            ip[2] = iz;
            for (ix = smin[0]; ix <= smax[0]; ++ix)
            {
                ip[0] = ix;
                for (iy = smin[1]; iy <= smax[1]; ++iy)
                {
                    ip[1] = iy;
                    c = comp[d_index3d(ix,iy,iz,gmax)];
                    if (c == NO_COMP)
                        continue;

                    if (iy != 0)
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,SOUTH,crx_type);
                    if (iy != smax[1])
                    {
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,NORTH,crx_type);
                        iy += step;
                    }
                }
            }
        }
        for (iy = smin[1]; iy <= smax[1]; ++iy)
        {
            ip[1] = iy;
            for (iz = smin[2]; iz <= smax[2]; ++iz)
            {
                ip[2] = iz;
                for (ix = smin[0]; ix <= smax[0]; ++ix)
                {
                    ip[0] = ix;
                    c = comp[d_index3d(ix,iy,iz,gmax)];
                    if (c == NO_COMP)
                        continue;
                    if (ix != 0)
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,WEST,crx_type);
                    if (ix != smax[0])
                    {
                        step = rm_unphy_crx_along_grid_line(ntg,smin,smax,
                                                     gmax,ip,EAST,crx_type);
                        ix += step;
                    }
                }
            }
        }
}       /* end remove_unphysical_crxings */

LIB_LOCAL bool next_ip_in_dir(
	const int *ip,
	int       dir,
	int       *ipn,
	int *smin,
	int *smax)
{
	int i;

	for (i = 0; i < 3; ++i)
	    ipn[i] = ip[i];
	switch (dir)
	{
	case WEST:
	    ipn[0] -= 1;
	    if (ipn[0] < smin[0])
	        return NO;
	    break;
	case EAST:
	    ipn[0] += 1;
	    if (ipn[0] > smax[0])
	        return NO;
	    break;
	case SOUTH:
	    ipn[1] -= 1;
	    if (ipn[1] < smin[1])
	        return NO;
	    break;
	case NORTH:
	    ipn[1] += 1;
	    if (ipn[1] > smax[1])
	        return NO;
	    break;
	case LOWER:
	    ipn[2] -= 1;
	    if (ipn[2] < smin[2])
	        return NO;
	    break;
	case UPPER:
	    ipn[2] += 1;
	    if (ipn[2] > smax[2])
	        return NO;
	}
	return YES;
}	/* end next_ip_in_dir */

LOCAL COMPONENT next_side_comp_at_crx(
	GRID_PT *gp,
	CRXING *crx)
{
	switch (gp->cur_dir)
	{
	case WEST:
	case SOUTH:
	case LOWER:
	    return crx->lcomp;
	case EAST:
	case NORTH:
	case UPPER:
	    return crx->ucomp;
	}
	return NO_COMP;
}		/*end next_side_comp_at_crx*/

LOCAL COMPONENT this_side_comp_at_crx(
	GRID_PT *gp,
	CRXING *crx)
{
	switch (gp->cur_dir)
	{
	case WEST:
	case SOUTH:
	case LOWER:
	    return crx->ucomp;
	case EAST:
	case NORTH:
	case UPPER:
	    return crx->lcomp;
	}
	return NO_COMP;
}		/*end this_side_comp_at_crx*/

LOCAL   bool check_and_repair_crx(
        TRI_GRID *ntg,
        int      *smin,
        int      *smax)
{
        GRID_DIRECTION  dir[6] = {EAST,NORTH,UPPER,WEST,SOUTH,LOWER};
        int             ip[3],ipn[3],i;
        int             num_crx_fill = 0;
        int             nic,l,nc,list;
        int             *gmax = ntg->rect_grid.gmax;
        CRXING          *crx;
        COMPONENT       *comp = ntg->components;
        bool            dir_ic[6];
        DEBUG_ENTER(check_and_repair_crx)

        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    nic = 0;
                    for (i = 0; i < 6; ++i)
                    {
                        dir_ic[i] = NO;
                        if (ip[0] == smax[0] && dir[i] == EAST)
                            continue;
                        if (ip[1] == smax[1] && dir[i] == NORTH)
                            continue;
                        if (ip[2] == smax[2] && dir[i] == UPPER)
                            continue;
                        if (ip[0] == smin[0] && dir[i] == WEST)
                            continue;
                        if (ip[1] == smin[1] && dir[i] == SOUTH)
                            continue;
                        if (ip[2] == smin[2] && dir[i] == LOWER)
                            continue;
                        if (check_comp_at(ip,dir[i],ntg,smin,smax,NO) != YES)
                        {
                            dir_ic[i] = YES;
                            ++nic;
                        }
                    }
                    if (nic > 3)
                    {
                        for (i = 0; i < 6; ++i)
                        {
                            if (!dir_ic[i]) continue;
                            l = seg_index3d(ip[0],ip[1],ip[2],dir[i]);
                            nc = ntg->seg_crx_count[l];
                            if (nc != 0)
                            {
                                if (i < 3)
                                {
                                    list = ntg->seg_crx_lists[l][0];
                                    crx = &ntg->crx_store[list];
                                    comp[d_index3d(ip[0],ip[1],ip[2],gmax)] =
                                                crx->lcomp;
                                }
                                else
                                {
                                    list = ntg->seg_crx_lists[l][nc-1];
                                    crx = &ntg->crx_store[list];
                                    comp[d_index3d(ip[0],ip[1],ip[2],gmax)] =
                                                crx->ucomp;
                                }

                            }
                            else if (next_ip_in_dir(ip,dir[i],ipn,smin,smax))
                            {
                                comp[d_index3d(ip[0],ip[1],ip[2],gmax)] =
                                    comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)];
                            }
                        }
                    }
                }
            }
        }
        for (ip[2] = smin[2]; ip[2] <= smax[2]; ++ip[2])
        {
            for (ip[1] = smin[1]; ip[1] <= smax[1]; ++ip[1])
            {
                for (ip[0] = smin[0]; ip[0] <= smax[0]; ++ip[0])
                {
                    for (i = 0; i < 3; ++i)
                    {
                        if (ip[0] == smax[0] && dir[i] == EAST)
                            continue;
                        if (ip[1] == smax[1] && dir[i] == NORTH)
                            continue;
                        if (ip[2] == smax[2] && dir[i] == UPPER)
                            continue;
                        if (check_comp_at(ip,dir[i],ntg,smin,smax,YES) != YES)
                        {
                            (void) next_ip_in_dir(ip,dir[i],ipn,smin,smax);
                            num_crx_fill = fill_missing_crx(ntg,ip,ipn,
                                        dir[i],num_crx_fill);
                            if (num_crx_fill == MAX_CRX_FILL)
                            {
                                (void) printf("WARNING in "
                                          "check_and_repair_crx(), "
                                          "too many missing crossings.\n");
                                DEBUG_LEAVE(check_and_repair_crx)
                                return NO;
                            }
                        }
                        if (num_crx_fill == MAX_CRX_FILL)
                        {
                            (void) printf("WARNING in "
                                          "check_and_repair_crx(), "
                                          "too many missing crossings.\n");
                            DEBUG_LEAVE(check_and_repair_crx)
                            return NO;
                        }
                    }
                }
            }
        }
        if (num_crx_fill != 0)
        {
            ntg->n_crx += num_crx_fill;
            (void) printf("WARNING %d crossings are missing, will fill!\n",
                   num_crx_fill);
        }
        DEBUG_LEAVE(check_and_repair_crx)
        return YES;
}       /* end check_and_repair_crx */

LOCAL int fill_missing_crx(
        TRI_GRID *ntg,
        int *ip,
        int *ipn,
        GRID_DIRECTION  dir,
        int num_crx_fill)
{
        COMPONENT       ***comp3d;
        COMPONENT       *comp = ntg->components;
        COMPONENT       lcomp, ucomp;
        CRXING          *crx_fill = &ntg->crx_store[ntg->n_crx];
        INTERFACE       *ntg_intfc = ntg->grid_intfc;
        HYPER_SURF      *hs;
        Locstate        sl, su;
        POINT           *p;
        RECT_GRID       *expanded_dual_grid = &ntg->rect_grid;
        float           coords[MAXD];
        int             *gmax = expanded_dual_grid->gmax;
        int             l;

        comp3d = (table_of_interface(ntg_intfc))->compon3d;
        for (l = 0; l < 3; ++l)
        {
            coords[l] = expanded_dual_grid->L[l] +
                        ip[l]*expanded_dual_grid->h[l];
        }
        if (dir == EAST)
            coords[0] += 0.5*expanded_dual_grid->h[0];
        else if (dir == NORTH)
            coords[1] += 0.5*expanded_dual_grid->h[1];
        else if (dir == UPPER)
            coords[2] += 0.5*expanded_dual_grid->h[2];
        lcomp = comp[d_index3d(ip[0],ip[1],ip[2],gmax)];
        ucomp = comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)];
        p = Point(coords);
        sl = left_state(p);
        su = right_state(p);
        ntg->grid_intfc->modified = NO;
        (void) nearest_intfc_state(coords,lcomp,ntg->grid_intfc,
                                sl,NULL,&hs);
        if (negative_component(hs) == lcomp)
            (void) nearest_intfc_state(coords,ucomp,ntg->grid_intfc,
                                su,NULL,&hs);
        else
        {
            (void) nearest_intfc_state(coords,ucomp,ntg->grid_intfc,
                           sl,NULL,&hs);
            (void) nearest_intfc_state(coords,lcomp,ntg->grid_intfc,
                           su,NULL,&hs);
        }
        crx_fill[num_crx_fill].pt  = p;
        crx_fill[num_crx_fill].hs = hs;
        crx_fill[num_crx_fill].lcomp = lcomp;
        crx_fill[num_crx_fill].ucomp = ucomp;
        l = seg_index3d(ip[0],ip[1],ip[2],dir);
        ntg->seg_crx_count[l] = 1;
        ntg->seg_crx_lists[l] = &(ntg->seg_crx_lists_store[
                        ntg->n_crx + num_crx_fill]);
        ntg->seg_crx_lists[l][0] = ntg->n_crx + num_crx_fill;
        if (dir == EAST)
        {
            comp3d[ip[2]-1][ip[1]-1][ip[0]] = ONFRONT;
            if (ip[1] != gmax[1])
                comp3d[ip[2]-1][ip[1]][ip[0]] = ONFRONT;
            if (ip[2] != gmax[2])
                comp3d[ip[2]][ip[1]-1][ip[0]] = ONFRONT;
            if (ip[1] != gmax[1] && ip[2] != gmax[2])
                comp3d[ip[2]][ip[1]][ip[0]] = ONFRONT;
        }
        else if (dir == NORTH)
        {
            comp3d[ip[2]-1][ip[1]][ip[0]-1] = ONFRONT;
            if (ip[0] != gmax[0])
                comp3d[ip[2]-1][ip[1]][ip[0]] = ONFRONT;
            if (ip[2] != gmax[2])
                comp3d[ip[2]][ip[1]][ip[0]-1] = ONFRONT;
            if (ip[0] != gmax[0] && ip[2] != gmax[2])
                comp3d[ip[2]][ip[1]][ip[0]] = ONFRONT;
        }
        else if (dir == UPPER)
        {
            comp3d[ip[2]][ip[1]-1][ip[0]-1] = ONFRONT;
            if (ip[0] != gmax[0])
                comp3d[ip[2]][ip[1]-1][ip[0]] = ONFRONT;
            if (ip[1] != gmax[1])
                comp3d[ip[2]][ip[1]][ip[0]-1] = ONFRONT;
            if (ip[0] != gmax[0] && ip[1] != gmax[1])
                comp3d[ip[2]][ip[1]][ip[0]] = ONFRONT;
        }
        if (debugging("comp_crx"))
        {
            int ipmin[3],ipmax[3];
            for (l = 0; l < 3; ++l)
            {
                ipmin[l] = ip[l] - 5;
                ipmax[l] = ip[l] + 5;
            }
            (void) printf("X-view of grid components:\n");
            show_grid_components(ipmin,ipmax,0,ntg);
            (void) printf("Z-view of grid components:\n");
            show_grid_components(ipmin,ipmax,2,ntg);
        }
        return num_crx_fill+1;
}       /* end fill_missing_crx */

LOCAL   void adjust_crossings(
        int      *smin,
        int      *smax,
        TRI_GRID *ntg)
{
        int            ix,iy,iz;
        GRID_DIRECTION dir[3] = {EAST,NORTH,UPPER};
        int            ip[3],i,k,l,m,nc,list1;
        CRXING         *crx1;
        float          grid_crds;
        float          *L = ntg->rect_grid.L;
        float          *h = ntg->rect_grid.h;

        for (iz = smin[2]; iz <= smax[2]; ++iz)
        {
            ip[2] = iz;
            for (iy = smin[1]; iy <= smax[1]; ++iy)
            {
                ip[1] = iy;
                for (ix = smin[0]; ix <= smax[0]; ++ix)
                {
                    ip[0] = ix;
                    for (i = 0; i < 3; ++i)
                    {
                        if (ix == smax[0] && dir[i] == EAST)
                            continue;
                        if (iy == smax[1] && dir[i] == NORTH)
                            continue;
                        if (iz == smax[2] && dir[i] == UPPER)
                            continue;
                        k = seg_index3d(ix,iy,iz,dir[i]);
                        nc = ntg->seg_crx_count[k];
                        if (nc != 0)
                        {
                            list1 = ntg->seg_crx_lists[k][0];
                            crx1 = ntg->crx_store+list1;
                            grid_crds = L[i] + ip[i]*h[i];
                            adjust_for_min_spacing(crx1,grid_crds,h,nc,i);
                        }
                    }
                }
            }
        }
}               /*end adjust_crossings */


LOCAL	void eliminate_same_crossings(
	int      *smin,
	int      *smax,
	TRI_GRID *ntg)
{
	int 	       ix,iy,iz;
	GRID_DIRECTION dir[3] = {EAST,NORTH,UPPER};
	int 	       ip[3],i,k,l,m,nc,list1;
	CRXING 	       *crx1;
	float 	       grid_crds;
	float 	       *L = ntg->rect_grid.L;
	float 	       *h = ntg->rect_grid.h;

	for (iz = smin[2]; iz <= smax[2]; ++iz)
	{
	    ip[2] = iz;
	    for (iy = smin[1]; iy <= smax[1]; ++iy)
	    {
	        ip[1] = iy;
	        for (ix = smin[0]; ix <= smax[0]; ++ix)
	        {
	            ip[0] = ix;
	            for (i = 0; i < 3; ++i)
	            {
	                if (ix == smax[0] && dir[i] == EAST)
	                    continue;
	                if (iy == smax[1] && dir[i] == NORTH)
	                    continue;
	                if (iz == smax[2] && dir[i] == UPPER)
	                    continue;
	                k = seg_index3d(ix,iy,iz,dir[i]);
	                nc = ntg->seg_crx_count[k];
	                if (nc != 0)
	                {
			    for (l = 0; l < nc; ++l)
	                    {
	                        list1 = ntg->seg_crx_lists[k][l];
	                        crx1 = ntg->crx_store+list1;
	                        if (crx1->lcomp == NO_COMP)
	                        {
	                            for (m = l; m < nc - 1; ++m)
	                                ntg->seg_crx_lists[k][m] =
	                                        ntg->seg_crx_lists[k][m+1];
	                            --l;
	                            --nc;
	                            --ntg->seg_crx_count[k];
	                        }
	                    }
			    if (nc != 0)
			    {
	                        list1 = ntg->seg_crx_lists[k][0];
	                        crx1 = ntg->crx_store+list1;
	                        grid_crds = L[i] + ip[i]*h[i];
	                        adjust_for_min_spacing(crx1,grid_crds,h,nc,i);
			    }
	                }
	            }
	        }
	    }
	}
}		/*end eliminate_same_crossings*/

LOCAL void adjust_for_min_spacing(
	CRXING		*crxings,
	float		crds_start,
	float		*h,
	int		n_crx,
	int		dir)
{
	int	i;
	float	crds_end;
	float	mgs = 0.004*h[dir];/*TOLERANCE*/
	float   pmin, pmax;
	float   ps, pe, nps, npe, m, b;

	crds_end = crds_start + h[dir];
	pmin = crds_start + mgs;
	pmax = crds_end - mgs;
	ps = Coords(crxings[0].pt)[dir];
	pe = Coords(crxings[n_crx-1].pt)[dir];
	if ((pmin <= ps) && (pe <= pmax))
	    return;
	if (n_crx == 1)
	{
	    if (ps < pmin)
	        Coords(crxings[0].pt)[dir] = pmin;
	    if (pe > pmax)
	        Coords(crxings[0].pt)[dir] = pmax;
	    return;
	}
	nps = max(ps,pmin);
	npe = min(pe,pmax);
	m = (npe - nps)/(pe - ps);
	b = (nps*pe - npe*ps)/(pe - ps);
	for (i = 0; i < n_crx; ++i)
	    Coords(crxings[i].pt)[dir] = m*Coords(crxings[i].pt)[dir] + b;
}		/*end adjust_for_min_spacing*/

LOCAL	bool check_comp_at(
	int            *ip,
	GRID_DIRECTION dir,
	TRI_GRID       *ntg,
	int            *smin,
	int            *smax,
        bool           vocal)
{
	COMPONENT 	*comp = ntg->components;
	int 		*gmax = ntg->rect_grid.gmax;
	int 		ipn[MAXD];
	int 		k,nc,list;
	CRXING 		*crx;
	float fp[MAXD];

	if (next_ip_in_dir(ip,dir,ipn,smin,smax) != YES)
	    return YES;

	k = seg_index3d(ip[0],ip[1],ip[2],dir);
	nc = ntg->seg_crx_count[k];
	if (nc == 0)
	{
	    if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] ==
		comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
	        return YES;
	    else
	    {
                if (vocal)
                {
                    rect_grid_corner(&ntg->rect_grid,ip,fp);
                    (void) printf("\nWARNING in check_comp_at(), "
                              "Inconsistent component at "
                              "neighboring grid point\n");
                    (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                    (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                    rect_grid_corner(&ntg->rect_grid,ipn,fp);
                    (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                    (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                    (void) printf("  Number of crossings = %d\n\n",nc);
                }
		return NO;
	    }
	}
	else if (nc == 1)
	{
	    list = ntg->seg_crx_lists[k][0];
	    crx = &(ntg->crx_store[list]);
	    switch (dir)
	    {
	    case EAST:
	    case NORTH:
	    case UPPER:
	        if (crx->lcomp != comp[d_index3d(ip[0],ip[1],ip[2],gmax)])
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "lower component of cross does "
                                  "not agree with grid\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                        (void) printf("crx->lcomp = %d  crx->ucomp = %d\n",
                                        crx->lcomp,crx->ucomp);
                    }
	            return NO;
	        }
	        if (crx->ucomp != comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "upper component of cross does "
                                  "not agree with grid\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                        (void) printf("crx->lcomp = %d  crx->ucomp = %d\n",
                                        crx->lcomp,crx->ucomp);
                    }
	            return NO;
	        }
	        if (crx->ucomp == crx->lcomp)
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "lower component of cross equal "
                                  "to upper component\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                        (void) printf("crx->lcomp = %d  crx->ucomp = %d\n",
                                        crx->lcomp,crx->ucomp);
                    }
	            return NO;
	        }
	        return YES;
	    case WEST:
	    case SOUTH:
	    case LOWER:
	        if (crx->ucomp != comp[d_index3d(ip[0],ip[1],ip[2],gmax)])
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "upper component of cross does "
                                  "not agree with grid\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                    }
	            return NO;
	        }
	        if (crx->lcomp != comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "lower component of cross does "
                                  "not agree with grid\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                    }
	            return NO;
	        }
	        if (crx->ucomp == crx->lcomp)
	        {
                    if (vocal)
                    {
                        (void) printf("WARNING in check_comp_at(), "
                                  "lower component of cross equal "
                                  "to upper component\n");
                        rect_grid_corner(&ntg->rect_grid,ip,fp);
                        (void) printf("  ip  = ( %7d %7d %7d ) comp = %2d  ",
                              ip[0],ip[1],ip[2],
                              comp[d_index3d(ip[0],ip[1],ip[2],gmax)]);
                        (void) printf("fp  = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        rect_grid_corner(&ntg->rect_grid,ipn,fp);
                        (void) printf("  ipn = ( %7d %7d %7d ) comp = %2d  ",
                              ipn[0],ipn[1],ipn[2],
                              comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)]);
                        (void) printf("fpn = ( %g %g %g )\n",
                              fp[0],fp[1],fp[2]);
                        (void) printf("  Number of crossings = %d\n\n",nc);
                    }
	            return NO;
	        }
	        return YES;
	    default:
                if (vocal)
	            (void) printf("WARNING in check_comp_at(), "
	                      "invalid dir %d\n",dir);
	        return NO;
	    }
	}
	else
	{
	    GRID_PT 	gp;
	    int 	i;
	    COMPONENT 	next_comp;

	    for (i = 0; i < MAXD; ++i) 
	        gp.ip[i] = ip[i];
	    gp.cur_dir = dir;
	    gp.comp = comp[d_index3d(ip[0],ip[1],ip[2],gmax)];
	    
	    if (edge_comp_walk(&gp,ntg,&next_comp,MULTIPLE,ON_DUAL_GRID) == UNPHYSICAL_EDGE)
	    {
                if(vocal)
                {
	            (void) printf("WARNING in check_comp_at() UNPHYSICAL_EDGE "
			      "detected.\n");
		    print_edge_crxings(&gp,ntg);
                }
                return NO; 
	    }
	    return YES;
	}
}		/*end check_comp_at*/

LOCAL   bool unphysical_edge(
        int            *ip,
        GRID_DIRECTION dir,
        TRI_GRID       *ntg,
        int            *smin,
        int            *smax,
        CRX_TYPE        crx_type)
{
        COMPONENT       *comp = ntg->components;
        int             *gmax = ntg->rect_grid.gmax;
        int             ipn[MAXD];
        int             k,nc,list;
        CRXING          *crx;
        float fp[MAXD];

        if (next_ip_in_dir(ip,dir,ipn,smin,smax) != YES)
            return YES;

        k = seg_index3d(ip[0],ip[1],ip[2],dir);
        nc = ntg->seg_crx_count[k];
        if (nc == 0)
        {
            if (comp[d_index3d(ip[0],ip[1],ip[2],gmax)] ==
                comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
                return YES;
            else
                return NO;
        }
        else if (nc == 1)
        {
            list = ntg->seg_crx_lists[k][0];
            crx = &(ntg->crx_store[list]);
            switch (dir)
            {
            case EAST:
            case NORTH:
            case UPPER:
                if (crx->lcomp != comp[d_index3d(ip[0],ip[1],ip[2],gmax)])
                    return NO;
                if (crx->ucomp != comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
                    return NO;
                if (crx->ucomp == crx->lcomp)
                    return NO;
                return YES;
            case WEST:
            case SOUTH:
            case LOWER:
                if (crx->ucomp != comp[d_index3d(ip[0],ip[1],ip[2],gmax)])
                    return NO;
                if (crx->lcomp != comp[d_index3d(ipn[0],ipn[1],ipn[2],gmax)])
                    return NO;
                if (crx->ucomp == crx->lcomp)
                    return NO;
                return YES;
            default:
                return NO;
            }
        }
        else
        {
            GRID_PT     gp;
            int         i;
            COMPONENT   next_comp;

            if (crx_type == SINGLE)
                return NO;
            for (i = 0; i < MAXD; ++i)
                gp.ip[i] = ip[i];
            gp.cur_dir = dir;
            gp.comp = comp[d_index3d(ip[0],ip[1],ip[2],gmax)];

            if (edge_comp_walk(&gp,ntg,&next_comp,MULTIPLE,ON_DUAL_GRID) == UNPHYSICAL_EDGE)
                return NO;
            return YES;
        }
}               /*end unphysical_edge*/

/* NOTE: This function is also used by the 2D case */
LIB_LOCAL EDGE_TYPE edge_comp_walk(
	GRID_PT 	*gp,
	TRI_GRID 	*ntg,
	COMPONENT	*next_comp,
	CRX_TYPE	crx_type,
        int             which_grid)
{
	int 		*ip = gp->ip, dim;
	GRID_DIRECTION 	dir = gp->cur_dir;
	int 		seg_index,crx_count,list;
	RECT_GRID 	*expanded_grid;
	int   		i,axis,polarity;
	float 		start[MAXD],end[MAXD];
	COMPONENT 	current_comp;
	CRXING    	**crxing;
	CRX_SORT  	*crx_sort;
	float		**crxing_point;
	int		unphysical_crxing_count = 0,unphys_crxing;
	EDGE_TYPE	status_of_edge;
        int             *seg_crx_count;
        int             **seg_crx_lists;
        CRXING          *crx_store;

        if(which_grid == ON_DUAL_GRID)
        {
            expanded_grid = &ntg->rect_grid;
            seg_crx_count = ntg->seg_crx_count;
            seg_crx_lists = ntg->seg_crx_lists;
            crx_store = ntg->crx_store;
        }
#if defined(CONSERVATIVE_ALG) 
        else
        {
            expanded_grid = &ntg->aug_comp_grid;
            seg_crx_count = ntg->c_seg_crx_count;
            seg_crx_lists = ntg->c_seg_crx_lists;
            crx_store = ntg->c_crx_store;
        }
#endif /* if defined(CONSERVATIVE_ALG) */
        dim = expanded_grid->dim;

        if(dim == 3)
            seg_index = seg_index3d(ip[0],ip[1],ip[2],dir);
        else if(dim == 2)
            seg_index = seg_index2d(ip,dir);
	crx_count = seg_crx_count[seg_index];
	set_grid_crx_edge(expanded_grid,ip,
			  dir,start,end,&axis,&polarity);

	if (crx_count == 0)
	{
	    *next_comp = gp->comp;
	    return PHYSICAL_EDGE;
	}

        /* track the components through the crossings of the edge */

	vector(&crxing,crx_count,sizeof(CRXING *));
	vector(&crxing_point,crx_count,sizeof(float *));
	vector(&crx_sort,crx_count,sizeof(CRX_SORT));
	for (i = 0; i < crx_count; ++i)
	{
	    list = seg_crx_lists[seg_index][i];
	    crx_sort[i].crx = crxing[i] = &(crx_store[list]);
	    crxing_point[i] = Coords(crxing[i]->pt);
	    crx_sort[i].compare_coord = &crxing_point[i][axis];
	}

	if (debugging("tolerance"))
	    (void) crossings_on_edge(crxing_point,start,end,axis,crx_count);

	if (crx_count == 1)
	{
	    if (gp->comp == this_side_comp_at_crx(gp,crxing[0]))
	    {
	        *next_comp = next_side_comp_at_crx(gp,crxing[0]);
		status_of_edge = PHYSICAL_EDGE;
	    }
	    else
	    {
	        status_of_edge = UNPHYSICAL_EDGE;
	    }
	    free_these(3,crxing,crx_sort,crxing_point);
	    return status_of_edge;
	}

	if (polarity == + 1) 
	    qsort((POINTER)crx_sort,crx_count,sizeof(CRX_SORT),crx_ascend);
	else
	    qsort((POINTER)crx_sort,crx_count,sizeof(CRX_SORT),crx_descend);

	current_comp = gp->comp;

	for (i = 0; i < crx_count; ++i)
	{
	    if (current_comp != this_side_comp_at_crx(gp,crx_sort[i].crx))
	    {
	        if (debugging("multi_crx"))
		{
		    (void) printf("WARNING in edge_comp_walk(), "
				  "unphysical crossing detected, count = %d\n",
				  unphysical_crxing_count);
		    (void) printf("      crossing %d  current_comp = %d  "
				  "grid_point->comp = %d  "
				  "this_side_comp_at_crx() = %d\n",
				  i,current_comp,gp->comp,
				  this_side_comp_at_crx(gp,crx_sort[i].crx));
		}
		++unphysical_crxing_count;
		unphys_crxing = i;
	    }
	    else
	        current_comp = next_side_comp_at_crx(gp,crx_sort[i].crx);
	}

	if (unphysical_crxing_count == 0) 
	{
	    if (crx_type == SINGLE)
	    {
		if (current_comp == this_side_comp_at_crx(gp,crx_sort[0].crx))
		{
	    	    *next_comp = current_comp;
		    ntg->seg_crx_count[seg_index] = 0;
		    status_of_edge = PHYSICAL_EDGE;
		}
		else if (current_comp == next_side_comp_at_crx(gp,
							       crx_sort[0].crx))
		{
	    	    *next_comp = current_comp;
		    ntg->seg_crx_count[seg_index] = 1;
		    status_of_edge = PHYSICAL_EDGE;
		}
		else
		    status_of_edge = UNPHYSICAL_EDGE;
	    }
	    else
	    {
		status_of_edge = PHYSICAL_EDGE;
	    	*next_comp = current_comp;
	    }
	}
	else 
	{
	    status_of_edge = UNPHYSICAL_EDGE;
	    if (debugging("multi_crx"))
	        multi_crx_debug(crx_sort,crx_count,gp,start,end,unphys_crxing);
	}

        free_these(3,crxing,crx_sort,crxing_point);
        return status_of_edge;
}		/*end edge_comp_walk*/

LOCAL 	void 	print_edge_crxings(
	GRID_PT  *gp,
	TRI_GRID *ntg)
{
	CRX_SORT  	  *crx_sort;
	CRXING    	  **crxing;
	RECT_GRID 	  *expanded_dual_grid = &ntg->rect_grid;
	float 		  start[MAXD],end[MAXD];
	float		  **crxing_point;
	int 		  *ip = gp->ip;
	GRID_DIRECTION 	  dir = gp->cur_dir;
	int 		  seg_index,crx_count,list;
	int   		  i,axis,polarity;
	static const char *sdir[] = { "X","Y","Z" };

        seg_index = seg_index3d(ip[0],ip[1],ip[2],dir);
	crx_count = ntg->seg_crx_count[seg_index];
	set_grid_crx_edge(expanded_dual_grid,ip,
			  dir,start,end,&axis,&polarity);

	(void) printf("ip  ( %3d %3d %3d )  comp = %2d crx_cnt = %2d  ",
		      ip[0],ip[1],ip[2],gp->comp,crx_count);
	(void) printf("dir = %s\n",grid_direction_name(dir));
	(void) printf("\nstart = ( %g %g %g)  "
		      "end = ( %g %g %g )  axis = %s  polarity = %d\n",
		      start[0],start[1],start[2],end[0],end[1],end[2],
		      sdir[axis],polarity);

	if (crx_count == 0)
	{
	    (void) printf("edge has no crossings\n");
	    return;
	}

        /* track the components through the crossings of the edge */

	vector(&crxing,crx_count,sizeof(CRXING *));
	vector(&crxing_point,crx_count,sizeof(float *));
	vector(&crx_sort,crx_count,sizeof(CRX_SORT));
	for (i = 0; i < crx_count; ++i)
	{
	    list = ntg->seg_crx_lists[seg_index][i];
	    crx_sort[i].crx = crxing[i] = &(ntg->crx_store[list]);
	    crxing_point[i] = Coords(crxing[i]->pt);
	    crx_sort[i].compare_coord = &crxing_point[i][axis];
	}
	
	if (polarity == + 1) 
	    qsort((POINTER)crx_sort,crx_count,sizeof(CRX_SORT),crx_ascend);
	else
	    qsort((POINTER)crx_sort,crx_count,sizeof(CRX_SORT),crx_descend);

	print_crx_sort(crx_sort,crx_count,gp);

	free(crxing);
	free(crx_sort);
	free(crxing_point);
}		/*end print_edge_crxings*/

LOCAL 	int 	crossings_on_edge(
	float 		**crossing,
	float 		*start,
	float 		*end,
	int 		axis,
	int 		crx_count)
{
	float 	   lesser,greater;
	int   	   i,j,i_crx;
	static const char *sdir[] = {"X","Y","Z"};
  
	lesser = min(start[axis],end[axis]);
	greater = max(start[axis],end[axis]);

	for (i_crx = 0; i_crx < crx_count; ++i_crx)
	{
	    for (i = 1; i < 3; ++i)
	    {
	        j = (axis + i)%3;
		if (crossing[i_crx][j] != start[j])
		{
		    (void) printf("TOLERANCE in crossings_on_edge(), crossing "
				  "not on grid line, axis = %d  delta = %g\n",
				  j,crossing[i_crx][j]-start[j]);
		    (void) printf("         number of crossings = %d  "
				  "i_crx = %d  axis = %1s  lesser = %g  "
				  "greater = %g\n",
				  crx_count,i_crx,sdir[axis],lesser,greater);
		    (void) printf("         start =    ( %g %g %g )  "
				  "end = ( %g %g %g )\n",
				  start[0],start[1],start[2],
				  end[0],end[1],end[2]);
		    (void) printf("         crossing = ( %g %g %g )\n",
				  crossing[i_crx][0],crossing[i_crx][1],
				  crossing[i_crx][2]);
		    (void) printf("         crossing - start = ( %g %g %g )\n",
				  crossing[i_crx][0]-start[0],
				  crossing[i_crx][1]-start[1],
				  crossing[i_crx][2]-start[2]);
		    return NO;
		}
	    }

	    if (crossing[i_crx][axis]<lesser || crossing[i_crx][axis]>greater)
            {
	        (void) printf("TOLERANCE in crossings_on_edge(), "
			      "crossing not between grid points.\n");
		(void) printf("       number of crossings = %d  i_crx = %d  "
			      "axis = %1s  lesser = %g  greater = %g\n",
			      crx_count,i_crx,sdir[axis],lesser,greater);
		(void) printf("       start =    ( %g %g %g )  "
			      "end = ( %g %g %g )\n",
			      start[0],start[1],start[2],end[0],end[1],end[2]);
		(void) printf("       crossing = ( %g %g %g )\n",
			      crossing[i_crx][0],crossing[i_crx][1],
			      crossing[i_crx][2]);
		return NO;
	    }
	}
	return YES;
}  		/*end crossings_on_edge*/

LOCAL 	void 	print_crx_sort(
	CRX_SORT 	*crx_sort,
	int 		nc,
	GRID_PT		*gp)
{
  	int i;
	(void) printf("%2s  %8s  %30s  %3s  %3s  %3s  %3s   %5s\n","i",
		      "compare","crx->pt          ","l_c","u_c","ths","nxt",
		      "delta");
	for (i = 0; i < nc; ++i)
	{
	    (void) printf("%2d  %g  ( %g %g %g )  "
			  "%3d  %3d  %3d  %3d",i,
			  *(crx_sort[i].compare_coord),
			  Coords(crx_sort[i].crx->pt)[0],
			  Coords(crx_sort[i].crx->pt)[1],
			  Coords(crx_sort[i].crx->pt)[2],
			  crx_sort[i].crx->lcomp,crx_sort[i].crx->ucomp,
			  this_side_comp_at_crx(gp,crx_sort[i].crx),
			  next_side_comp_at_crx(gp,crx_sort[i].crx));
	    if (i < nc-1) 
	        (void) printf(" %g\n",*(crx_sort[i].compare_coord) - 
			      *(crx_sort[i+1].compare_coord));
	    else
	        (void) printf("\n");
	}
} 		/*end print_crx_sort*/

LOCAL void 	set_grid_crx_edge(
	RECT_GRID 	*rect_grid,
	int 		*ip,
	GRID_DIRECTION 	dir,
	float 		*start,
	float 		*end,
	int 		*axis,
	int 		*polarity)
{
	int 	i;
	float 	L[MAXD],h[MAXD];
	DEBUG_ENTER(set_grid_crx_edge)

	for (i = 0; i < rect_grid->dim; ++i)
	{
	    L[i] = rect_grid->L[i];
	    h[i] = rect_grid->h[i];
	    end[i] = start[i] = L[i] + ip[i] * h[i];
	}


	switch (dir)
	{
	case EAST: 
	    end[0] = start[0] + h[0];
	    *axis = 0;
	    *polarity = + 1;
	    break;
	case WEST:
	    end[0] = start[0] - h[0];
	    *axis = 0;
	    *polarity = - 1;
	    break;
	case NORTH:
	    end[1] = start[1] + h[1];
	    *axis = 1;
	    *polarity = + 1;
	    break;
	case SOUTH:
	    end[1] = start[1] - h[1];
	    *axis = 1;
	    *polarity = - 1;
	    break;
	case UPPER:
	    end[2] = start[2] + h[2];
	    *axis = 2;
	    *polarity = + 1;
	    break;
	case LOWER:
	    end[2] = start[2] - h[2];
	    *axis = 2;
	    *polarity = - 1;
	    break;
        default:
	    screen("ERROR in set_grid_crx_edge(), "
		   "unknown direction = %d\n",dir);
	    clean_up(ERROR);
	}
	DEBUG_LEAVE(set_grid_crx_edge)
}  		/*end set_grid_crx_edge*/

LOCAL	void	multi_crx_debug(
	CRX_SORT	*crx_sort,
	int		crx_count,
	GRID_PT		*gp,
	float		*start,
	float		*end,
	int		unphys_crxing)
{
  	float		**polyline;
	float		h;
	int 		i, j;
	SURFACE		*surf;
	char 		fname[256];
	static int	error_cnt = 0;

	print_crx_sort(crx_sort,crx_count,gp);
	matrix(&polyline,crx_count+2,3,sizeof(float));
	for (j = 0; j < 3; ++j)
	{
	    polyline[0][j] = start[j];
	    polyline[crx_count+1][j] = end[j];
	}
	for (i = 0; i < crx_count; ++i)
	    for (j = 0; j < 3; ++j)
	        polyline[i+1][j] = Coords(crx_sort[i].crx->pt)[j];
	(void) sprintf(fname,"edge_crx_%d",error_cnt);
	gview_polyline("edge_comp_walk",fname,polyline,crx_count+2,pYELLOW,3);

	for (i = 0; i < crx_count+1; ++i)
	{
	    (void) sprintf(fname,"seg_of_crx_%d_error%d",i,error_cnt);
	    gview_polyline("edge_comp_walk",fname,polyline+i,2,pWHITE,6);
	}

	for (h = 0, i = 0; i < 3; ++i)
	    h += fabs(start[i]-end[i]);
	surf = crx_sort[0].crx->hs->obj.s;
	(void) sprintf(fname,"surf_%d",error_cnt);
	gview_local_surface(surf,"edge_comp_walk",fname,pBLUE,
			    Coords(crx_sort[unphys_crxing].crx->pt),
			    0.3*h);/*TOLERANCE*/
	++error_cnt;
	free(polyline);
}		/*end multi_crx_debug*/

LOCAL	int	walk_comp_along_grid_line(
	TRI_GRID       *ntg,
	int            *smin,
	int            *smax,
	int            *gmax,
	int            *ip,
	GRID_DIRECTION dir)
{
	COMPONENT *comp = ntg->components;
	COMPONENT current_comp;
	CRXING	  *crx;
	int 	  ip1[3], ip2[3];
	int	  i,k,nc,list,step;
	bool	  crx_is_physical = YES;

	for (i = 0; i < 3; ++i)
	    ip1[i] = ip[i];
	current_comp = comp[d_index3d(ip1[0],ip1[1],ip1[2],gmax)];
	step = 0;
	while (next_ip_in_dir(ip1,dir,ip2,smin,smax))
	{
	    k = seg_index3d(ip1[0],ip1[1],ip1[2],dir);
	    nc = ntg->seg_crx_count[k];
	    if (dir == EAST || dir == NORTH || dir == UPPER)
	    {
		for (i = 0; i < nc; ++i)
		{
		    list = ntg->seg_crx_lists[k][i];
		    crx = &(ntg->crx_store[list]);
		    if (crx->lcomp == current_comp)
			current_comp = crx->ucomp;
		    else
		    {
			crx_is_physical = NO;
			break;
		    }
		}
	    }
	    else
	    {
		for (i = nc-1; i >= 0; --i)
		{
		    list = ntg->seg_crx_lists[k][i];
		    crx = &(ntg->crx_store[list]);
		    if (crx->ucomp == current_comp)
			current_comp = crx->lcomp;
		    else
		    {
			crx_is_physical = NO;
			break;
		    }
		}
	    }
	    if (!crx_is_physical) 
		break;
	    ++step;
	    comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] = current_comp;
	    if (dir == LOWER || dir == UPPER)
	    {
		if (ip[0] != smin[0])
		{
	    	    k = seg_index3d(ip2[0],ip2[1],ip2[2],WEST);
	    	    nc = ntg->seg_crx_count[k];
		    if (nc == 0)
		    {
		    	next_ip_in_dir(ip2,WEST,ip1,smin,smax);
			if (comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] !=
			    comp[d_index3d(ip1[0],ip1[1],ip1[2],gmax)])
			    crx_is_physical = NO;
		    }
		    else
		    {
			list = ntg->seg_crx_lists[k][nc-1];
			crx = ntg->crx_store+list;
			if (crx->ucomp != current_comp)
			    crx_is_physical = NO;
		    }
		}
		if (ip[1] != smin[1])
		{
	    	    k = seg_index3d(ip2[0],ip2[1],ip2[2],SOUTH);
	    	    nc = ntg->seg_crx_count[k];
		    if (nc == 0)
		    {
		    	next_ip_in_dir(ip2,SOUTH,ip1,smin,smax);
			if (comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] !=
			    comp[d_index3d(ip1[0],ip1[1],ip1[2],gmax)])
			    crx_is_physical = NO;
		    }
		    else
		    {
			list = ntg->seg_crx_lists[k][nc-1];
			crx = ntg->crx_store+list;
			if (crx->ucomp != current_comp)
			    crx_is_physical = NO;
		    }
		}
	        if (!crx_is_physical) 
		    break;
	    }
	    for (i = 0; i < 3; ++i)
		ip1[i] = ip2[i];
	}
	return step;
}	/* end walk_comp_along_grid_line */

LOCAL	int	rm_unphy_crx_along_grid_line(
	TRI_GRID       *ntg,
	int            *smin,
	int            *smax,
	int            *gmax,
	int            *ip,
	GRID_DIRECTION dir,
	CRX_TYPE       crx_type)
{
	COMPONENT *comp = ntg->components;
	COMPONENT current_comp,cn,cl,cu;
	CRXING	  *crx,*crx1;
	int 	  ip1[3],ip2[3];
	int	  i,k,nc,list,l,step;
        int       unphysical_encountered = NO;

	for (i = 0; i < 3; ++i)
	    ip1[i] = ip[i];
	current_comp = comp[d_index3d(ip1[0],ip1[1],ip1[2],gmax)];
        step = 0;
	while (next_ip_in_dir(ip1,dir,ip2,smin,smax))
	{
            cn = comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)];
	    k = seg_index3d(ip1[0],ip1[1],ip1[2],dir);
	    nc = ntg->seg_crx_count[k];
            if (cn != NO_COMP)
            {
                if (dir == EAST || dir == NORTH || dir == UPPER)
                {
                    cl = current_comp;
                    cu = cn;
                }
                else
                {
                    cu = current_comp;
                    cl = cn;
                }
                if (nc == 0)
                {
                    if (cl == cu) break;
                    else
                    {
                        (void) printf("WARNING: no crxing between adjacent ");
                        (void) printf("points with different components!\n");
                        (void) printf("ip1 = %d %d %d  comp = %d\n",
                                        ip1[0],ip1[1],ip1[2],current_comp);
                        (void) printf("ip2 = %d %d %d  comp = %d\n",
                                        ip2[0],ip2[1],ip2[2],cn);
                        break;
                    }
                }
                else
                {
                    if (crx_type == SINGLE)
                    {
                        if (cl == cu)
                        {
                            ntg->seg_crx_count[k] = 0;
                            break;
                        }
                        for (i = 0; i < nc; ++i)
                        {
                            list = ntg->seg_crx_lists[k][i];
                            crx = &(ntg->crx_store[list]);
                            if (crx->lcomp == cl && crx->ucomp == cu)
                            {
                                ntg->seg_crx_lists[k][0] =
                                        ntg->seg_crx_lists[k][i];
                                ntg->seg_crx_count[k] = 1;
                                break;
                            }
                        }
                        if (i < nc) break;
                        if (i == nc)
                        {
                            (void) printf("WARNING: No suitable crxing!\n");
                            ntg->seg_crx_count[k] = 0;
                            break;
                        }
                    }
                }
            }
	    if (dir == EAST || dir == NORTH || dir == UPPER)
	    {
		for (i = 0; i < nc; ++i)
		{
		    list = ntg->seg_crx_lists[k][i];
		    crx = &(ntg->crx_store[list]);
		    if (crx->lcomp == current_comp)
			current_comp = crx->ucomp;
		    else
		    {
                        if (i < nc-1)
                        {
                            list = ntg->seg_crx_lists[k][i+1];
                            crx1 = &(ntg->crx_store[list]);
                            if (crx->ucomp = crx1->lcomp)
                            {
                                /* Find unphysical doublet */
                                for (l = i; l < nc-2; ++l)
                                    ntg->seg_crx_lists[k][l] =
                                        ntg->seg_crx_lists[k][l+2];
                                nc -= 2;
                                ntg->seg_crx_count[k] -= 2;
                                --i;
                            }
                            else
                            {
                                for (l = i; l < nc-1; ++l)
                                    ntg->seg_crx_lists[k][l] =
                                        ntg->seg_crx_lists[k][l+1];
                                --i;
                                --nc;
                                --ntg->seg_crx_count[k];
                                unphysical_encountered = YES;
                                break;
                            }
                        }
                        else
                        {
                            --ntg->seg_crx_count[k];
                            unphysical_encountered = YES;
                            break;
                        }
		    }
		}
	    }
	    else
	    {
		for (i = nc-1; i >= 0; --i)
		{
		    list = ntg->seg_crx_lists[k][i];
		    crx = &(ntg->crx_store[list]);
		    if (crx->ucomp == current_comp)
			current_comp = crx->lcomp;
		    else
		    {
                        if (i > 0)
                        {
                            list = ntg->seg_crx_lists[k][i-1];
                            crx1 = &(ntg->crx_store[list]);
                            if (crx->lcomp = crx1->ucomp)
                            {
                                /* Find unphysical doublet */
                                for (l = i-1; l < nc-2; ++l)
                                    ntg->seg_crx_lists[k][l] =
                                        ntg->seg_crx_lists[k][l+2];
                                nc -= 2;
                                ntg->seg_crx_count[k] -= 2;
                                --i;
                            }
                            else
                            {
                                for (l = i; l < nc-1; ++l)
                                    ntg->seg_crx_lists[k][l] =
                                        ntg->seg_crx_lists[k][l+1];
                                --nc;
                                --ntg->seg_crx_count[k];
                                unphysical_encountered = YES;
                                break;
                            }
                        }
                        else
                        {
                            for (l = i; l < nc-1; ++l)
                                ntg->seg_crx_lists[k][l] =
                                    ntg->seg_crx_lists[k][l+1];
                            --nc;
                            --ntg->seg_crx_count[k];
                            unphysical_encountered = YES;
                            break;
                        }
		    }
		}
	    }
            if (unphysical_encountered) break;
            if (comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] == NO_COMP)
                comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] = current_comp;
            else if (comp[d_index3d(ip2[0],ip2[1],ip2[2],gmax)] != current_comp)
                break;
            if (crx_type == SINGLE && nc != 1)
            {
                if (nc%2 == 0)
                    ntg->seg_crx_count[k] = 0;
                else
                    ntg->seg_crx_count[k] = 1;
            }
            for (i = 0; i < 3; ++i)
                ip1[i] = ip2[i];
            ++step;
	}
	return step;
}	/* end rm_unphy_crx_along_grid_line */

#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */

LIB_LOCAL	int 	crx_ascend(
	const void 	*c1,
	const void 	*c2)
{
  	if (*(((CRX_SORT*)c1)->compare_coord) >
	    *(((CRX_SORT*)c2)->compare_coord)) return 1;
	else return -1;
}		/*end crx_ascend*/

LIB_LOCAL	int 	crx_descend(
	const void 	*c1,
	const void 	*c2)
{
  	if (*(((CRX_SORT*)c1)->compare_coord) <
	    *(((CRX_SORT*)c2)->compare_coord)) return 1;
  	else return -1;
}		/*end crx_descend*/

#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */

LOCAL	void show_grid_components(
	int *smin,
	int *smax,
	int idir,
	TRI_GRID *ntg)
{
	int 		ix,iy,iz,k,nc;
	COMPONENT       *comp = ntg->components;
	int 		*gmax = ntg->rect_grid.gmax;

	if (idir == 0)
	{
	    for (ix = smin[0]; ix <= smax[0]; ++ix)
	    {
		printf("\n\t\tix = %d\n\n",ix);
	    	for (iy = smin[1]; iy <= smax[1]; ++iy)
		{
		    for (iz = smin[2]; iz <= smax[2]; ++iz)
		    {
                        if (iz != smax[2])
                        {
			    k = seg_index3d(ix,iy,iz,UPPER);
			    nc = ntg->seg_crx_count[k];
			    if (nc == 0)
		    	        printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
		    	    else if (nc == 1)
		    	        printf("%2d|",comp[d_index3d(ix,iy,iz,gmax)]);
                            else
                                printf("%2d*",comp[d_index3d(ix,iy,iz,gmax)]);
                        }
                        else
                            printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
		    }
		    printf("\n");
		    for (iz = smin[2]; iz <= smax[2]; ++iz)
		    {
			k = seg_index3d(ix,iy,iz,NORTH);
			nc = ntg->seg_crx_count[k];
			if (nc == 0)
		    	    printf("  ");
		    	else if (nc == 1)
		    	    printf(" - ");
                        else
                            printf(" * ");
		    }
		    printf("\n");
		}
	    }
	}
	else if (idir == 1)
	{
	    for (iy = smin[1]; iy <= smax[1]; ++iy)
	    {
		printf("\n\t\tiy = %d\n\n",iy);
		for (iz = smin[2]; iz <= smax[2]; ++iz)
		{
	    	    for (ix = smin[0]; ix <= smax[0]; ++ix)
		    {
                        if (ix != smax[0])
                        {
                            k = seg_index3d(ix,iy,iz,EAST);
                            nc = ntg->seg_crx_count[k];
                            if (nc == 0)
                                printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
                            else if (nc == 1)
                                printf("%2d|",comp[d_index3d(ix,iy,iz,gmax)]);
                            else
                                printf("%2d*",comp[d_index3d(ix,iy,iz,gmax)]);
                        }
                        else
                            printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
		    }
		    printf("\n");
	    	    for (ix = smin[0]; ix <= smax[0]; ++ix)
		    {
			k = seg_index3d(ix,iy,iz,UPPER);
			nc = ntg->seg_crx_count[k];
			if (nc == 0)
		    	    printf("  ");
		    	else if (nc == 1)
		    	    printf(" - ");
                        else
		    	    printf(" * ");
		    }
		    printf("\n");
		}
	    }
	}
	else
	{
	    for (iz = smin[2]; iz <= smax[2]; ++iz)
	    {
		printf("\n\t\tiz = %d\n\n",iz);
	    	for (ix = smin[0]; ix <= smax[0]; ++ix)
		{
	    	    for (iy = smin[1]; iy <= smax[1]; ++iy)
		    {
                        if (iy != smax[1])
                        {
                            k = seg_index3d(ix,iy,iz,NORTH);
                            nc = ntg->seg_crx_count[k];
                            if (nc == 0)
                                printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
                            else if (nc == 1)
                                printf("%2d|",comp[d_index3d(ix,iy,iz,gmax)]);
                            else
                                printf("%2d*",comp[d_index3d(ix,iy,iz,gmax)]);
                        }
                        else
                            printf("%2d ",comp[d_index3d(ix,iy,iz,gmax)]);
		    }
		    printf("\n");
	    	    for (iy = smin[1]; iy <= smax[1]; ++iy)
		    {
			k = seg_index3d(ix,iy,iz,EAST);
			nc = ntg->seg_crx_count[k];
			if (nc == 0)
                            printf("   ");
                        else if (nc == 1)
                            printf(" - ");
                        else
                            printf(" * ");
		    }
		    printf("\n");
		}
	    }
	}
}	/* end show_grid_components */

LOCAL   void show_component_along_line(
        int i1,
        int i2,
        int *smin,
        int *smax,
        int idir,
        TRI_GRID *ntg)
{
        int             ix,iy,iz,k,nc;
        COMPONENT       *comp = ntg->components;
        int             *gmax = ntg->rect_grid.gmax;

        if (idir == 0)
        {
            for (ix = smin[0]; ix <= smax[0]; ++ix)
            {
                k = seg_index3d(ix,i1,i2,EAST);
                nc = ntg->seg_crx_count[k];
                if (nc == 0)
                    printf("%2d ",comp[d_index3d(ix,i1,i2,gmax)]);
                else if (nc == 1)
                    printf("%2d|",comp[d_index3d(ix,i1,i2,gmax)]);
                else
                    printf("%2d*",comp[d_index3d(ix,i1,i2,gmax)]);
                if ((ix+1)%20 == 0) printf("\n");
            }
        }
        else if (idir == 1)
        {
            for (iy = smin[1]; iy <= smax[1]; ++iy)
            {
                k = seg_index3d(i2,iy,i1,NORTH);
                nc = ntg->seg_crx_count[k];
                if (nc == 0)
                    printf("%2d ",comp[d_index3d(i2,iy,i1,gmax)]);
                else if (nc == 1)
                    printf("%2d|",comp[d_index3d(i2,iy,i1,gmax)]);
                else
                    printf("%2d*",comp[d_index3d(i2,iy,i1,gmax)]);
                if ((iy+1)%20 == 0) printf("\n");
            }
        }
        else
        {
            for (iz = smin[2]; iz <= smax[2]; ++iz)
            {
                k = seg_index3d(i1,i2,iz,UPPER);
                nc = ntg->seg_crx_count[k];
                if (nc == 0)
                    printf("%2d ",comp[d_index3d(i1,i2,iz,gmax)]);
                else if (nc == 1)
                    printf("%2d|",comp[d_index3d(i1,i2,iz,gmax)]);
                else
                    printf("%2d*",comp[d_index3d(i1,i2,iz,gmax)]);
                if ((iz+1)%20 == 0) printf("\n");
            }
        }
        printf("\n");
}       /* end show_component_along_line */

LOCAL   bool null_side_loop(
        TRI *start,
        int start_side,
        ORIENTATION orient,
        TRI ***tris,
        int **sides,
        POINT ***side_points,
        int *num_sides,
        float **tnor)
{
        POINT *p;
        int i, j, k, i_diff, side = start_side;
        TRI *next_tri = start;
        static TRI **null_tris;
        static int *null_sides;
        static POINT **pts;
        static float normal[MAXD];
        float v1[MAXD],v2[MAXD],cprod[MAXD];

        if (null_tris == NULL)
        {
            vector(&null_tris,MAX_NULL_SIDE_LOOP,sizeof(TRI*));
            vector(&null_sides,MAX_NULL_SIDE_LOOP,INT);
            vector(&pts,MAX_NULL_SIDE_LOOP,sizeof(POINT*));
        }
        for (i = 0; i < 3; ++i) normal[i] = 0.0;
        *num_sides = 0;
        pts[0] = (orient == POSITIVE_ORIENTATION) ? Point_of_tri(start)[side] :
                        Point_of_tri(start)[Next_m3(side)];
        do
        {
            null_tris[*num_sides] = next_tri;
            null_sides[*num_sides] = side;
            ++(*num_sides);
            if (orient == POSITIVE_ORIENTATION)
            {
                if (debugging("null_loop"))
                {
                    printf("side:  %d %d\n",Point_of_tri(next_tri)[side],
                                Point_of_tri(next_tri)[Next_m3(side)]);
                }
                pts[*num_sides] = p = Point_of_tri(next_tri)[Next_m3(side)];
                // printf("%f %f %f\n",Coords(p)[0],Coords(p)[1],Coords(p)[2]);
                if (*num_sides > 300)
                {
                    /*TMP
                    int i;
                    for (i = 0; i < *num_sides; ++i)
                        printf("%d %d %d\n",2,i,i+1);
                    printf("%d %d %d\n",*num_sides,*num_sides,0);
                    exit(0);*/
                }
                if (p == pts[0]) break;
                side = next_null_sided_tri(next_tri,p,&next_tri);
            }
            else
            {
                if (debugging("null_loop"))
                {
                    printf("side:  %d %d\n",Point_of_tri(next_tri)[
                                Next_m3(side)],Point_of_tri(next_tri)[side]);
                }
                pts[*num_sides] = p = Point_of_tri(next_tri)[side];
                if (p == pts[0]) break;
                side = prev_null_sided_tri(next_tri,p,&next_tri);
            }
            if (next_tri == NULL)
            {
                printf("Cannot continue the loop\n");
                clean_up(ERROR);
            }

        }
        while (next_tri != start || side != start_side);

        /* Check for double loop */
        /*TMP
        for (i = 0; i < *num_sides; ++i)
            printf("pts[%d] = %d\n",i,pts[i]);
        {
            float dp[3];
            for (i = 0; i < 3; ++i)
                dp[i] = Coords(pts[4])[i] - Coords(pts[1])[i];
            printf("dp = %g %g %g\n",dp[0],dp[1],dp[2]);
        }*/
        for (i = 1; i < *num_sides-1; ++i)
        {
            for (j = i+1; j < *num_sides; ++j)
            {
                if (pts[i] == pts[j])
                {
                    i_diff = j - i;
                    for (k = i; k < *num_sides-i_diff; ++k)
                    {
                        null_tris[k] = null_tris[k+i_diff];
                        null_sides[k] = null_sides[k+i_diff];
                        pts[k] = pts[k+i_diff];
                    }
                    pts[*num_sides-i_diff] = pts[*num_sides];
                    (*num_sides) -= i_diff;
                    --i;
                    break;
                }
            }
        }

        for (j = 0; j < 3; ++j) normal[j] = 0.0;
        for (i = 0; i < *num_sides; ++i)
        {
            difference(Coords(pts[i]),Coords(pts[i+1]),v1,3);
            difference(Coords(pts[(i+2)%(*num_sides+1)]),
                        Coords(pts[i+1]),v2,3);
            Cross3d(v2,v1,cprod);
            for (j = 0; j < 3; ++j) normal[j] += cprod[j];
        }
        if (orient == NEGATIVE_ORIENTATION)
            for (j = 0; j < 3; ++j) normal[j] *= -1.0;
        *tris = null_tris;
        *sides = null_sides;
        *side_points = pts;
        *tnor = normal;
        return YES;
}       /* end null_side_loop */

LOCAL   bool null_side_tri_in_list(
        TRI **tris,
        int num_tris,
        TRI **tri,
        int *side)
{
        int i,j;
        for (i = 0; i < num_tris; ++i)
        {
            for (j = 0; j < 3; ++j)
            {
                if (Neighbor_on_side(tris[i],j) == NULL)
                {
                    *tri = tris[i];
                    *side = j;
                    return YES;
                }
            }
        }
        *tri = NULL;
        return NO;
}       /* end null_side_tri_in_list */

LOCAL   bool adjacent_cell(
        int *icrds1,
        int *icrds2)
{
        int i,num_idn,num_nb;
        num_idn = num_nb = 0;
        for (i = 0; i < 3; ++i)
        {
            if (icrds1[i] == icrds2[i]) num_idn++;
            if (icrds1[i] - icrds2[i] == 1 ||
                icrds1[i] - icrds2[i] == -1)
                num_nb++;
        }
        if (num_idn == 2 && num_nb == 1) return YES;
        else return NO;
}       /* end adjacent_cell */

LOCAL   bool check_extension_of_surface(
        TRI **tri_list,
        int num_tris,
        SURFACE *s)
{
        TRI *tri1,*tri2,*t[2];
        POINT *p1,*p2;
        int i,j,k,count;

        printf("Entering check_extension_of_surface!\n");

        for (k = 0; k < num_tris; ++k)
        {
            tri1 = tri_list[k];
            for (i = 0; i < 3; ++i)
            {
                p1 = Point_of_tri(tri1)[i];
                p2 = Point_of_tri(tri1)[(i+1)%3];
                count = 0;
                for (tri2 = first_tri(s); !at_end_of_tri_list(tri2,s);
                        tri2 = tri2->next)
                {
                    if (tri1 == tri2) continue;
                    for (j = 0; j < 3; ++j)
                    {
                        if ((p1 == Point_of_tri(tri2)[j] &&
                             p2 == Point_of_tri(tri2)[(j+1)%3]) ||
                            (p1 == Point_of_tri(tri2)[(j+1)%3] &&
                             p2 == Point_of_tri(tri2)[j]))
                        {
                            t[count++] = tri2;
                            if (count == 2)
                            {
                                printf("Triple edge found\n");
                                printf("Triangle 1:\n");
                                print_tri(tri1,s->interface);
                                printf("Triangle 2:\n");
                                print_tri(t[0],s->interface);
                                printf("Triangle 3:\n");
                                print_tri(t[1],s->interface);
                                clean_up(ERROR);
                            }
                        }
                    }
                }
            }
        }
        printf("Surface contains no triple edge "
               "and is topologically sound!\n");
        return YES;
}       /* end check_extension_of_surface */


LOCAL   bool null_sides_with_suitable_angle(
        TRI *tri1,
        int side1,
        TRI *tri2,
        int side2)
{
        float *p0, *p1, *q0, *q1;
        float u0[3], u1[3], pm[3], qm[3], pq[3], tm[3];
        float r0, r1, ke, dm, cosu=0;
        int i;
        float thres = 0.1;

        p0 = Coords(Point_of_tri(tri1)[side1]);
        p1 = Coords(Point_of_tri(tri1)[Next_m3(side1)]);
        q0 = Coords(Point_of_tri(tri2)[side2]);
        q1 = Coords(Point_of_tri(tri2)[Next_m3(side2)]);
        r0 = distance_between_positions(p0, p1, 3);
        r1 = distance_between_positions(q0, q1, 3);

        for (i=0; i<3; ++i)
        {
            pm[i] = (p1[i] + p0[i])/2.0;
            qm[i] = (q1[i] + q0[i])/2.0;
            u0[i] = (p1[i] - p0[i])/r0;
            u1[i] = (q1[i] - q0[i])/r1;
            tm[i] = pm[i] - q0[i];
        }
        ke = Dot3d(tm, u1);
        for (i=0; i<3; ++i)
            pq[i] = q0[i] + ke*u1[i];

        /*dm is the distance between the midpoint of side2 and the projection
          of the mid point of side1 on side2*/
        dm = distance_between_positions(pq, qm, 3);

        cosu = Dot3d(u0, u1);
        if (((1+cosu) < thres)&&(dm < max(r0, r1)/2.0))
            return YES;
        else
            return NO;

}       /* end null_sides_with_suitable_angle */

LOCAL   bool bifurcation_detected(
        TRI **tri_list,
        int num_tris,
        TRI ***sub_tris1,
        int *num_sub_tris1,
        TRI ***sub_tris2,
        int *num_sub_tris2)
{
        TRI **null_tris;
        static  TRI **mom_list, **sub_list1, **sub_list2;
        static  TRI ***sub_tris;
        TRI *start_tri;
        int i, start_side, num_null_sides, num_mom_tris,num_sub_list1,
            num_sub_list2, *null_sides,  count=0;
        int num_sub_tris[4];
        POINT **side_pts;
        float *tnor;
        bool bifurcation_found = NO;

        if (mom_list == NULL)
        {
            matrix(&sub_tris, 4, MAX_NULL_SIDE_LOOP, sizeof(TRI*));
            vector(&mom_list, MAX_NULL_SIDE_LOOP, sizeof(TRI*));
            vector(&sub_list1, MAX_NULL_SIDE_LOOP, sizeof(TRI*));
            vector(&sub_list2, MAX_NULL_SIDE_LOOP, sizeof(TRI*));
        }

        for(i = 0; i < num_tris; ++i)
                mom_list[i] = tri_list[i];
        num_mom_tris = num_tris;
        while (null_side_tri_in_list(mom_list,num_mom_tris,
                                &start_tri,&start_side))
        {
            num_sub_list1 = 0;
            num_sub_list2 = 0;
            null_side_loop(start_tri,start_side,POSITIVE_ORIENTATION,
                &null_tris,&null_sides,&side_pts,&num_null_sides,&tnor);
            for (i = 0; i < num_mom_tris; ++i)
            {
                if (!tri_recorded(mom_list[i], null_tris, num_null_sides))
                    sub_list2[num_sub_list2++] = mom_list[i];
                else
                    sub_list1[num_sub_list1++] = mom_list[i];
            }
            for (i = 0; i < num_sub_list1; ++i)
                sub_tris[count][i] = sub_list1[i];
            num_sub_tris[count] = num_sub_list1;
            num_mom_tris = num_sub_list2;
            for (i = 0; i < num_mom_tris; ++i)
                mom_list[i] = sub_list2[i];

            count++;
            if (count > 3)
                break;

        }

        if (count > 2)
        {
            screen("Bifurcation:More than two null_side_loop in tri_list!\n");
            clean_up(ERROR);
        }
        else if (count == 2)
                bifurcation_found = YES;
        else
                bifurcation_found = NO;
        *sub_tris1 = sub_tris[0];
        *num_sub_tris1 = num_sub_tris[0];
        *sub_tris2 = sub_tris[1];
        *num_sub_tris2 = num_sub_tris[1];

        return bifurcation_found;
}       /* end bifurcation_detected */

#endif /* defined(THREED) || defined(TWOD) */
