/*
*                               tri_csgutil.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#define DEBUG_STRING "tri"

#include <tri/trilocaldecs.h>

#if defined(CONSERVATIVE_ALG) && defined(TWOD)

LOCAL void      single_vol_to_geomview(FILE*,CSG_Solid*,float*); 
LOCAL void      vol_face_to_geomview(FILE*,CSG_Face*,float*); 
LOCAL void      stat_face_to_tri(int*,int*,CSG_Face*,TRI_GRID*,void(*)(Locstate)); 


LOCAL void single_vol_to_geomview(
        FILE            *fp,
        CSG_Solid       *s,
        float           *colormap)
{
        CSG_Face        *f;

        f = s->sfaces;
        while(f)
        {
            vol_face_to_geomview(fp,f,colormap);
            f = f->nextf;
        }
}

LOCAL void vol_face_to_geomview(
        FILE           *fp,
        CSG_Face       *f,
        float          *colormap)
{
        CSG_Vertex      *v;
        CSG_HalfEdge    *he;
        float           vpt[3];
        int             i, nV;

        nV = 0;
        he = f->floops->ledg;
        do
        {
            nV++;
        }while((he = he->nxt) != f->floops->ledg);

        fprintf(fp,"{ OFF\n%d %d %d\n\n",nV, 1, nV);

        he = f->floops->ledg;
        do
        {
            v = he->vtx;
            CSG_point_Coord(v->pt, vpt);
            fprintf(fp,"%f %f %f\n",
                vpt[0], vpt[1],vpt[2]);
        }while((he = he->nxt) != f->floops->ledg);

        fprintf(fp,"%d\t",nV);
        for(i=0; i<nV; i++)
            fprintf(fp,"%d ",i);
        fprintf(fp,"%f %f %f\n}",colormap[0],colormap[1],colormap[2]);
}




EXPORT int CSG_vol_to_geomview(
        char           *dname,
        int            step, 
        CSG_BLK_CRX    **csg_blk_crx,
        TRI_GRID       *old_ntg,
        float          dt)
{

        static char   *fname = NULL, *ppfname = NULL;
        static size_t fname_len = 0, ppfname_len = 0;
        char          outname[256],outdir[256];
        int           i, myid, numnodes;
        const char    *nstep;
        FILE          *fp;
        static float  **clrmap = NULL;
        float         ccolor[4] = {0.0, 0.0, 0.0, 1.0};
        CSG_BLK_CRX   *blk_crx;
        int           j, smin[MAXD], smax[MAXD];
        int           icrds[MAXD+1], icrds2[MAXD+1];
        RECT_GRID     comp_grid = old_ntg->comp_grid;
        int           lbuf[MAXD], ubuf[MAXD];
        COMPONENT     comp;
        CSG_Vertex    *v;
        int           last = 0;
        static int    loop = 0;

        DEBUG_ENTER(CSG_vol_to_geomview)

        myid = pp_mynode(); numnodes = pp_numnodes();
        sprintf(outdir,"%s/%s",dname,"ts_vol");
        ppfname = set_ppfname(ppfname,"ts_vol",&ppfname_len);
        nstep = right_flush(step,7);
        sprintf(outname,"%s.ts%s",ppfname,nstep);


        if (create_directory(dname,YES) == FUNCTION_FAILED)
        {
            (void) printf("WARNING in CSG_vol_to_geomview(), directory "
                          "%s doesn't exist and can't be created\n",dname);
            return NO;
        }
        if (create_directory(outdir,YES) == FUNCTION_FAILED)
        {
            (void) printf("WARNING in CSG_vol_to_geomview(), directory "
                         "%s doesn't exist and can't be created\n",outdir);
            return NO;
        }

        fname = get_list_file_name(fname,outdir,outname,&fname_len);
        if ((fp = fopen(fname,"w")) == NULL)
        {
            (void) printf("WARNING in CSG_vol_to_geomview(), "
                           "can't open %s\n",fname);
            return NO;
        }


        for (i = 0; i < 2; i++)
        {
            smin[i] = 0;
            smax[i] = old_ntg->comp_grid.gmax[i];
            smin[i] -= old_ntg->comp_grid.lbuf[i];
            smax[i] += old_ntg->comp_grid.ubuf[i];
        }

        if(clrmap == NULL)
        {
            vector(&clrmap,6,sizeof(float*));
            for(i = 0; i < 6; i++)
                vector(&clrmap[i],4,sizeof(float));
            set_default_clr_map(clrmap, 6);
        }

        fprintf(fp,"{ LIST \n");
        for(i= smin[0]; i < smax[0]; i++)
            for(j = smin[1]; j < smax[1]; j++)
        {
            icrds[0] = i; icrds[1] = j;
            blk_crx = Comp_blk(icrds,csg_blk_crx,old_ntg);
            if(blk_crx)
            {
                if(last == 0)
                {
                    single_vol_to_geomview(fp, blk_crx->s,clrmap[0]);
                    last = 1;
                }
                else if(last ==1)
                {
                    single_vol_to_geomview(fp, blk_crx->s,clrmap[1]);
                    last = 2;
                }
                else
                {
                    single_vol_to_geomview(fp, blk_crx->s,clrmap[2]);
                    last = 0;
                }
            }
        }

        gview_time_mesh_plot2d(fp, &(old_ntg->comp_grid), dt, ccolor);

        fprintf(fp,"}\n");
        fclose(fp);

        DEBUG_LEAVE(CSG_vol_to_geomview)
        return YES; 
}

EXPORT void top_and_btm_stat_with_tri(
        int           *ic,
        CSG_Solid     *s,
        TRI_GRID      *ntg,
        TRI_GRID      *otg,
        int           option, /* 1: both, 2: top only */
        void          (*print_state)(Locstate))
{
        CSG_Face      *f;
        int           where[3];
        int           icrds[MAXD];

        s->n_top = s->n_btm = 0; 
        s->btm_st = NULL;
        s->top_st = NULL;
        f = s->sfaces;
        while(f)
        {
            if(YES == long_is_top_or_bottom_face(f,where))
            {
                if(rect_in_which(f->centroid,icrds, &ntg->comp_grid) 
                        == FUNCTION_FAILED)
                {
                    printf("ERROR in top_and_btm_stat_with_tri(), "
                           "rect_in_which() failed\n");
                    printf("crds<%f,%f>\n",f->centroid[0],f->centroid[1]);
                    printf("face %d <%f, %f, %f>: stencil state is :\n",
                            f->faceno, f->face_eqn[0],
                            f->face_eqn[1], f->face_eqn[2]);
                    solidls(f->fsolid,2);
                    clean_up(ERROR);
                }
                if(option == 1)
                { 
                    if(where[2] == 1)
                    {
                        stat_face_to_tri(icrds,where,f,ntg,print_state);
                        s->top_st = f->i_stat;
                        s->n_top++;
                    }
                    else
                    {
                        stat_face_to_tri(icrds,where,f,otg,print_state);
                        s->btm_st = f->i_stat;
                        s->n_btm++;
                    }
                }
                else if(option == 2)
                {
                    if(where[2] == 1)
                    {
                        stat_face_to_tri(icrds,where,f,ntg,print_state);
                        s->top_st = f->i_stat;
                        s->n_top++;
                    }
                }
                else
                {
                    printf("ERROR top_and_btm_stat_with_tri\n");
                    printf("Unimplemented set options %d\n", option); 
                    clean_up(ERROR); 
                }
            }
            f = f->nextf;
        }
}


/*** 
    stat_face_to_tri(): If a face (from the buttom or the top of a volume)
    contains the rectangular cell center. The f->i_stat is set to
    Regular_grid_state(). Otherwise, it takes its storage from 
    Comp_blk(ic,ntg->vol_states,ntg). By doing so, we do not have to 
    reassign the volume states back to the wave after update. 
 ***/
LOCAL void stat_face_to_tri(
        int           *ic,
        int           *where,
        CSG_Face      *f,
        TRI_GRID      *ntg,
        void          (*print_state)(Locstate))
{
        int             ic_end[MAXD], ic_wv[MAXD], ic_wv2[MAXD];
        int             ic_wv3[MAXD], ic_wv4[MAXD];
        static CRXING   **crx[4] = {NULL,NULL,NULL,NULL};
        int             i, nc[4]; /* number of CRXING */
        register Locstate *state;
        COMPONENT       comp;
        float           *centcrds; 

        if(NULL == crx[0])
        {
            for(i = 0; i < 4; i++)
                 vector(&crx[i],4,sizeof(CRXING *));
        }

        ic_end[0] = ic[0] + 1;
        ic_end[1] = ic[1] + 1;
        comp = Regular_comp_grid_comp(where,ntg);
        centcrds = Coords(Regular_grid_node(ic, ntg)); 

        nc[0] = comp_crossings_in_direction(crx[0],ic,EAST,ntg);
        nc[2] = comp_crossings_in_direction(crx[2],ic,NORTH,ntg);
        nc[1] = comp_crossings_in_direction(crx[1],ic_end,WEST,ntg);
        nc[3] = comp_crossings_in_direction(crx[3],ic_end,SOUTH,ntg);

        if(nc[1] == 0 && nc[0] == 0 &&
           nc[2] == 0 && nc[3] == 0)
        {
             f->i_stat = Regular_grid_state(ic,ntg);
             if(f->comp != Regular_comp_grid_comp(ic, ntg))
             {
                 printf("ERROR stat_face_to_tri, f->comp[%d] != grid_comp[%d]\n",
                    f->comp, Regular_comp_grid_comp(ic, ntg)); 
                 clean_up(ERROR);  
             }
        }
        else if(nc[0] == 1 && nc[2] == 1 &&
                nc[1] == 0 && nc[3] == 0)
        {
             state = Comp_blk(ic,ntg->vol_states,ntg);
             if(0 == memcmp(ic, where, sizeof(int)*2))
             {
                 if(comp != Regular_comp_grid_comp(ic, ntg) ||
                    f->comp != Regular_comp_grid_comp(ic, ntg))
                 {
                     printf("ERROR stat_face_to_tri case1, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                 }
                 f->i_stat = state[0];
             }
             else
             {
                 f->i_stat = Regular_grid_state(ic,ntg);
                 /*** OLD
                 if(comp != Regular_comp_grid_comp(ic_end, ntg) ||
                    f->comp != Regular_comp_grid_comp(ic_end, ntg))
                 {
                     printf("ERROR stat_face_to_tri case11, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_end, ntg));
                     clean_up(ERROR); 
                 }
                 f->i_stat = state[1];
                 ***/
             }
        }
        else if(nc[0] == 1 && nc[3] == 1 &&
                nc[1] == 0 && nc[2] == 0)
        {
             state = Comp_blk(ic,ntg->vol_states,ntg);
             ic_wv[0] = ic[0]+1; ic_wv[1] = ic[1];
             if(0 == memcmp(ic_wv, where, sizeof(int)*2))
             {
                 if(comp != Regular_comp_grid_comp(ic_wv, ntg) ||
                    f->comp != Regular_comp_grid_comp(ic_wv, ntg))
                 {
                     printf("ERROR stat_face_to_tri case2, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_wv, ntg));
                     clean_up(ERROR); 
                 }
                 f->i_stat = state[1];
             }
             else
             {
                 f->i_stat = Regular_grid_state(ic,ntg);
                 /*** OLD 
                 if(comp != Regular_comp_grid_comp(ic, ntg) ||
                    f->comp != Regular_comp_grid_comp(ic, ntg))
                 {
                     printf("ERROR stat_face_to_tri case21, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                 }
                 f->i_stat = state[0];
                 ***/
             }
        }
        else if(nc[3] == 1 && nc[1] == 1 &&
                nc[2] == 0 && nc[0] == 0)
        {
            state = Comp_blk(ic,ntg->vol_states,ntg);
            if(0 == memcmp(ic_end, where, sizeof(int)*2))
            {
                if(comp != Regular_comp_grid_comp(ic_end, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic_end, ntg))
                {
                     printf("ERROR stat_face_to_tri case3, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_end, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[1];
            }
            else
            {
                f->i_stat = Regular_grid_state(ic,ntg);
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic, ntg))
                {
                     printf("ERROR stat_face_to_tri case31, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[0];
                ***/
            }
        }
        else if(nc[1] == 1 && nc[2] == 1 &&
                nc[0] == 0 && nc[3] == 0)
        {
            state = Comp_blk(ic,ntg->vol_states,ntg);
            ic_wv[0] = ic[0]; ic_wv[1] = ic[1]+1;
            if(0 == memcmp(ic_wv, where, sizeof(int)*2))
            {
                if(comp != Regular_comp_grid_comp(ic_wv, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic_wv, ntg))
                {
                     printf("ERROR stat_face_to_tri case4, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_wv, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[1];
            }
            else
            {
                f->i_stat = Regular_grid_state(ic,ntg);
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic, ntg))
                {
                     printf("ERROR stat_face_to_tri case41, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[0];
                ***/
            }
        }
        else if(nc[2] == 1 && nc[3] == 1 &&
                nc[0] == 0 && nc[1] == 0)
        {
            state = Comp_blk(ic,ntg->vol_states,ntg);
            ic_wv[0] = ic[0]+1; ic_wv[1] = ic[1];
            if(0 == memcmp(ic, where, sizeof(int)*2) ||
               0 == memcmp(ic_wv, where, sizeof(int)*2))
            {
                if(YES == point_in_face2d(f->floops, centcrds))
                    f->i_stat = Regular_grid_state(ic,ntg);
                else
                    f->i_stat = state[0];
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic, ntg))
                {
                     printf("ERROR stat_face_to_tri case5, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[0];
                ***/
            }
            else
            {
                if(YES == point_in_face2d(f->floops, centcrds))
                    f->i_stat = Regular_grid_state(ic,ntg);
                else
                    f->i_stat = state[1];
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic_end, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic_end, ntg))
                {
                     printf("ERROR stat_face_to_tri case51, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_end, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[1];
                ***/
            }
        }
        else if(nc[1] == 1 && nc[0] == 1 &&
                nc[2] == 0 && nc[3] == 0)
        {
            state = Comp_blk(ic,ntg->vol_states,ntg);
            ic_wv[0] = ic[0]; ic_wv[1] = ic[1]+1;
            if(0 == memcmp(ic, where, sizeof(int)*2) ||
               0 == memcmp(ic_wv, where, sizeof(int)*2))
            {
                if(YES == point_in_face2d(f->floops, centcrds))
                    f->i_stat = Regular_grid_state(ic,ntg);
                else
                    f->i_stat = state[0];
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic, ntg))
                {
                     printf("ERROR stat_face_to_tri case6, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[0];
                ***/
            }
            else
            {
                if(YES == point_in_face2d(f->floops, centcrds))
                    f->i_stat = Regular_grid_state(ic,ntg);
                else
                    f->i_stat = state[1];
                /*** OLD
                if(comp != Regular_comp_grid_comp(ic_end, ntg) ||
                   f->comp != Regular_comp_grid_comp(ic_end, ntg))
                {
                     printf("ERROR stat_face_to_tri case61, comps[%d,%d,%d]\n",
                       comp, f->comp, Regular_comp_grid_comp(ic_end, ntg));
                     clean_up(ERROR); 
                }
                f->i_stat = state[1];
                ***/
            }
        }
        else if(nc[1] == 1 && nc[0] == 1 &&
                nc[2] == 1 && nc[3] == 1)
        {
            state = Comp_blk(ic,ntg->vol_states,ntg);
            ic_wv[0] = ic[0],   ic_wv[1] = ic[1]+1;
            ic_wv2[0] = ic[0]+1, ic_wv2[1] = ic[1];
            ic_wv3[0] = ic[0], ic_wv3[1] = ic[1];
            ic_wv4[0] = ic[0]+1, ic_wv4[1] = ic[1]+1;
            if(Regular_grid_comp(ic,ntg) == Regular_comp_grid_comp(ic_wv, ntg) &&
               Regular_grid_comp(ic,ntg) == Regular_comp_grid_comp(ic_wv2, ntg))
            {
                if(where[0] == ic_wv3[0] && where[1] == ic_wv3[1])
                {
                    f->i_stat = state[0];
                }
                else if(where[0] == ic_wv4[0] && where[1] == ic_wv4[1])
                {
                    f->i_stat = state[2];
                }
                else if((where[0] == ic_wv[0] && where[1] == ic_wv[1]) ||
                        (where[0] == ic_wv2[0] && where[1] == ic_wv2[1]))
                {
                    if(YES == point_in_face2d(f->floops, centcrds))
                        f->i_stat = Regular_grid_state(ic,ntg);
                    else
                    {
                        printf("ERROR In stat_face_to_tri()\n");
                        printf("This guy should take reg cell states\n");
                        clean_up(ERROR); 
                        f->i_stat = state[1];
                    }
                    /*** OLD 
                    f->i_stat = state[1];
                    ***/
                }
                else
                {
                    printf("ERROR: In stat_face_to_tri()\n");
                    printf("3pt case for assigining memory for states1, unknow case\n");
                    printf("where <%d,%d,%d>, ic<%d,%d>\n",
                    where[0], where[1],where[2], ic[0],ic[1]);
                    clean_up(ERROR);
                }
            }
            else if(Regular_grid_comp(ic,ntg) == Regular_comp_grid_comp(ic_wv3, ntg) &&
               Regular_grid_comp(ic,ntg) == Regular_comp_grid_comp(ic_wv4, ntg))
            {
                if((where[0] == ic_wv3[0] && where[1] == ic_wv3[1]) ||
                   (where[0] == ic_wv4[0] && where[1] == ic_wv4[1]))
                {
                    if(YES == point_in_face2d(f->floops, centcrds))
                        f->i_stat = Regular_grid_state(ic,ntg);
                    else
                    {
                        printf("ERROR In stat_face_to_tri()\n");
                        printf("This guy should take reg cell states 2\n");
                        clean_up(ERROR); 
                        f->i_stat = state[0];
                    }
                    /*** OLD
                    f->i_stat = state[0];
                    ***/
                }
                else if(where[0] == ic_wv2[0] && where[1] == ic_wv2[1])
                {
                    f->i_stat = state[1];
                }
                else if(where[0] == ic_wv[0] && where[1] == ic_wv[1])
                {
                    f->i_stat = state[2];
                }
                else
                {
                    printf("ERROR: In stat_face_to_tri()\n");
                    printf("3pt case for assigining memory for states2, unknow case\n");
                    printf("where <%d,%d,%d>, ic<%d,%d>\n",
                    where[0], where[1],where[2], ic[0],ic[1]);
                    clean_up(ERROR);
                }
            }
            else
            {
                printf("ERROR In  stat_face_to_tri()\n");
                printf("3pt case for assigining memory for states, unknown case\n");
                printf("where <%d,%d,%d>, ic<%d,%d>\n",
                    where[0], where[1],where[2], ic[0],ic[1]);
                clean_up(ERROR);
            }
        }
        else
        {
            printf("ERROR: In stat_face_to_tri()\n");
            printf("Unkown case for assigining memory for states\n");
            clean_up(ERROR);
        }

        if(f->i_stat == NULL)
        {
            printf("ERROR stat_face_to_tri()\n");
            printf("f->i_stat is null\n");
            clean_up(ERROR);  
        }
}

#endif /* if defined(CONSERVATIVE_ALG) && defined(TWOD) */

