/*
*                       tri_CSGdef.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       External definitions for the triangulated grid construction.
*/


#if !defined(_TRI_CSGDEF_H)
#define _TRI_CSGDEF_H

#include <tri/trigrid.h>

struct _CSG_POINT{
        int    type;   /* icrds or BBI_POINT(CRXING) */
        union {
        int            icrds[MAXD+1];
        CRXING         *crx;
        } csg_pt;
};

struct _CSG_BLK_CRX {
        int             type;
        COMPONENT       ***comp;
        CSG_POINT       ***icrds;
                        /* store actual icoords
                       for blk corner, since there is rotation */
        int             ***ix;
        int             ***iy;
        int             ***iz;
        COMPONENT       pos_comp;
        COMPONENT       neg_comp;
        COMPONENT       min_comp;
        CSG_POINT       ***crx;   /* the crxing points on edge */
        CSG_Solid       *s;
};

/* for rotation */
struct _CSG_BLK_CRX_r {
        int             type;
        COMPONENT       ***comp;
        CSG_POINT       ****icrds;
        int             ***ix;
        int             ***iy;
        int             ***iz;
        COMPONENT       pos_comp;
        COMPONENT       neg_comp;
        COMPONENT       min_comp;
        CSG_POINT       ****crx;   /* the crxing points on edge */
        CSG_Solid       *s;
};

struct _CSG_merger {
        CSG_BLK_CRX     *blk;          /* where s originally from */
        CSG_Solid       *s;            /* the Solid need to be merged */
        CSG_HalfEdge    *he;           /* On merging face of s        */
        CSG_HalfEdge    *h_nghbr[20];  /*  the candidate the s can
                                           be merged to, the solid which
                                           state face is TRI has
                                           two neighbors,  the which
                                           state face is  quadri. has
                                           one neighbor.  */
        int             n_nghbr;       /* number of h_nghbr[] stored,
                                          for multiple merging case usage */
        int             merge;         /* = YES, or NO, some vol might not
                                          be able to be merged during the 1st merging
                                          process */
        struct _CSG_merger   *next;
        struct _CSG_merger   *prev;
};

struct _Solid_neighbor {
        int    type;   /* ICRDS or SOLID */
        union {
        int            icrds[MAXD];
        CSG_Solid      *s;  
        } nghbr;
}; 

struct _CSG_Solid {
        unsigned long    solidno;    /* Solid identifier  */
        int              icrds[MAXD]; /* The blk id     */
        CSG_BLK_CRX      *blk;       /* where its from before merge */
        CSG_Face         *sfaces;    /* pointers to list of faces */
        CSG_Edge         *sedges;    /* pointers to list of edges */
        CSG_Vertex       *sverts;    /* pointers to list of vertices */
        CSG_Solid        *nexts;
        CSG_Solid        *prevs;
        COMPONENT        comp;
        Locstate         btm_st, top_st;
                         /* before merge, top and btm face states */
        int              n_btm, n_top; /* # of btm faces and top faces after merge */
        float            vol; 
        bool             unset; 
        bool             merged;  /* Used exclusively in perform_merge_solid(). 
                                   * Default value is NO. 
                                   * If a solid can not be merged due to some reason
                                   * in this function, this flag is set to YES.
                                   * Then this function will not be called again.
                                   * See CSG_vol_merger()
                                   */
        int              debug;
};

struct _CSG_Face {
        unsigned long    faceno;      /* Face identifier  */
        CSG_Solid        *fsolid;     /* back pointer to solid */
        CSG_Loop         *flout;      /* pointer to outer loop */
        CSG_Loop         *floops;     /* pointer to list of loops */
        float            face_eqn[4]; /* face equation, face normal */
        float            centroid[3]; /* face centroid */
        float            area;        /* face area  */
        Locstate         i_stat;      /* states at face center, associated with tri states */
        Locstate         smid;        /* This smid does not apply to front face state */
                                      /* Pointer to interior s-t-intfc mid. st. soln. */
        Locstate         art_visc_st_x;
        Locstate         art_visc_st_y; /* artificial viscosity part */
        COMPONENT        comp;        /* for debug top and btm state */
        CSG_Face         *nextf;      /* pointer to next face */
        CSG_Face         *prevf;      /* pointer to previous face */
};

struct _CSG_Loop {
        CSG_HalfEdge     *ledg;      /* ptr to ring of halfedges */
        CSG_Face         *lface;      /* back pointer to face */
        CSG_Loop         *nextl;      /* pointer to next loop   */
        CSG_Loop         *prevl;      /* pointer to previous loop */
};

struct _CSG_Edge {
        CSG_HalfEdge     *he1;        /* pointer to right halfedge  */
        CSG_HalfEdge     *he2;        /* pointer to left halfedge   */
        CSG_Edge         *nexte;      /* pointer to next edge */
        CSG_Edge         *preve;      /* pointer to previous edge */
};

struct _CSG_HalfEdge {
        CSG_Edge         *edg;        /* pointer to parent edge */
        CSG_Vertex       *vtx;        /* pointer to starting vertex */
        CSG_Loop         *wloop;      /* back pointer to loop */
        CSG_HalfEdge     *nxt;        /* pointer to next halfedge */
        CSG_HalfEdge     *prv;        /* pointer to previous halfedge */
};

struct _CSG_Vertex {
        unsigned long    vertexno;    /* vertex identifier  */
        CSG_HalfEdge     *vedge;      /* pointer to a halfedge */
        CSG_POINT        *pt;         /* pointer to point   */
        CSG_Vertex       *nextv;      /* pointer to next vertex */
        CSG_Vertex       *prevv;      /* pointer to previous vertex */
};

union _CSG_Node {
        CSG_Solid        s;
        CSG_Face         f;
        CSG_Loop         l;
        CSG_HalfEdge     h;
        CSG_Vertex       v;
        CSG_Edge         e;
};

#endif /* if !defined(_TRI_CSGDEF_H) */



