/*
*                       tri_CSG.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       External definitions for the triangulated grid construction.
*/


#if !defined(_TRI_CSG_H)
#define _TRI_CSG_H

// #include <tri/trigrid.h>

#define             CSG_SOLID      0
#define             CSG_FACE       1
#define             CSG_LOOP       2
#define             CSG_HALFEDGE   3
#define             CSG_EDGE       4
#define             CSG_VERTEX     5

#define mate(he)    (((he) == (he)->edg->he1)? \
                    (he)->edg->he2 : (he)->edg->he1)

# define        PLUS            0
# define        MINUS           1

enum {
        IS_SOLID =  10,
        IS_ICRDS = 100,
        IS_BBI_P = 101,
        IS_TOP_FACE = 102,
        IS_BTM_FACE = 103
};

enum {
        UNSET = 0x0000,
        F_VOL = 0x0002,     /* On front, can build volume */
        F_NO_GBS = 0x0004,  /* On front, BLK is NOT GRID_BASED  */
        F_NO_VOL = 0x0008,  /* On front, but does not build volume */
        OFF_FRONT = 0x0010  /* Off front BLK */
};  

#define is_complex_blk(type)     (((type) & F_NO_GBS) ||  \
                                 ((type) & F_NO_VOL))

typedef struct _CSG_POINT         CSG_POINT;
typedef struct _CSG_BLK_CRX       CSG_BLK_CRX;
typedef struct _CSG_BLK_CRX_r     CSG_BLK_CRX_r; /* for rotation */
typedef struct _CSG_merger        CSG_merger;
typedef struct _Solid_neighbor    Solid_nghbr;

typedef struct _CSG_Solid         CSG_Solid;
typedef struct _CSG_Face          CSG_Face;
typedef struct _CSG_Loop          CSG_Loop;
typedef struct _CSG_HalfEdge      CSG_HalfEdge;
typedef struct _CSG_Vertex        CSG_Vertex;
typedef struct _CSG_Edge          CSG_Edge;
typedef union  _CSG_Node          CSG_Node;

#endif /* if !defined(_TRI_CSG_H) */



