/*
*				iprotos.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if !defined(_IPROTOS_H)
#define _IPROTOS_H

#include <intfc/int.h>

 /* libintfc.a EXPORTED Function Declarations*/

/*	comp.c*/
IMPORT	COMPONENT	component(float*,INTERFACE*);
IMPORT	COMPONENT	long_component(float*,INTERFACE*);
IMPORT	COMPONENT	nearest_interior_comp(bool,COMPONENT,
					      float*,INTERFACE*);
IMPORT	COMPONENT	new_component(COMPONENT);
IMPORT	bool	is_excluded_comp(COMPONENT,INTERFACE*);
IMPORT	int	check_comps_at_nodes(INTERFACE*,O_NODE**);
IMPORT	int	comps_consistent_at_node(NODE*);
IMPORT	void	exclude_comp(COMPONENT,INTERFACE*);
IMPORT	void	set_topological_grid(INTERFACE*,RECT_GRID*);
IMPORT	void	show_COMP(FILE*,INTERFACE*);

/*	iblkb.c*/
IMPORT	int     construct_bdry_blk(BLK_CRX*,BLK_TRI*);

/*	iecomps.c*/
IMPORT	bool	equivalent_comps(COMPONENT,COMPONENT,INTERFACE*);
IMPORT	const COMPONENT	*equivalent_components_list(COMPONENT,int*,INTERFACE*);
IMPORT  void	fprint_comp_equiv_lists(FILE*,INTERFACE*);
IMPORT  void	fprint_comp_equiv_lists(FILE*,INTERFACE*);
IMPORT	void	set_equivalent_comps(COMPONENT,COMPONENT,INTERFACE*);

/*	ifourier.c*/
IMPORT  FOURIER_POLY    *get_fourier_bubble(float*,float*,int,const char*);
IMPORT  FOURIER_POLY    *get_fourier_multi_mode(float*,float*,int,const char*);
IMPORT  FOURIER_POLY    *get_fourier_mixed(float*,float*,int,const char*);
IMPORT  FOURIER_POLY    *get_fourier_random(float*,float*,int,const char*);
IMPORT	FOURIER_POLY	*allocate_fourier_poly(int,int,ALIGN*);
IMPORT	FOURIER_POLY	*get_fourier_coeffs(float*,float*,int,const char*);
IMPORT	LEGENDRE_POLY	*get_legendre_coeffs(float,const char*);
IMPORT  LEGENDRE_POLY   *get_legendre_mixed(float,const char*);
IMPORT  LEGENDRE_POLY   *get_legendre_multi_mode(float,const char*,const char*);
IMPORT  LEGENDRE_POLY   *get_legendre_random(float,const char*);
IMPORT  LEGENDRE_POLY   *allocate_legendre_poly(int,ALIGN*);
IMPORT	float		fourier_poly(float*,FOURIER_POLY*);
IMPORT	float		legendre_poly(float,LEGENDRE_POLY*);
IMPORT	int		random_bubble_num_modes(const char*,int*,int*,int);
IMPORT	int		spherical_num_modes(const char*,int*,int*,float*);
IMPORT	void		init_random_modes(int,int,int,int,FOURIER_POLY*,
					  float*,float*);

/*	intfc.c*/
IMPORT	BOND	*i_Bond(POINT*,POINT*);
IMPORT	CURVE	**split_curve(POINT*,BOND*,CURVE*,
			      COMPONENT,COMPONENT,COMPONENT,COMPONENT);
IMPORT	CURVE	*curve_of_bond(BOND*,INTERFACE*);
IMPORT	CURVE	*i_copy_curve(CURVE*,NODE*,NODE*);
IMPORT	CURVE	*i_make_curve(COMPONENT,COMPONENT,NODE*,NODE*);
IMPORT	CURVE	*join_curves(CURVE*,CURVE*,COMPONENT,COMPONENT,BOND**);
IMPORT	INTERFACE	*i_copy_interface(INTERFACE*);
IMPORT	INTERFACE	*current_interface(void);
IMPORT	INTERFACE	*make_interface(int);
IMPORT	INTERFACE	*read_print_interface(INIT_DATA*,const IO_TYPE*,
                                              bool,int*);
IMPORT	INTERFACE	*read_interface(void);
IMPORT	HYPER_SURF *i_make_hypersurface(COMPONENT,COMPONENT);
IMPORT	HYPER_SURF_BDRY	*i_make_hypersurface_boundary(void);
IMPORT	NODE	*i_copy_node(NODE*);
IMPORT	NODE	*i_make_node(POINT*);
IMPORT	NODE	*node_of_point(POINT*,INTERFACE*);
IMPORT	POINT	*i_Point(float*);
IMPORT	POINT	*i_Static_point(INTERFACE*);
IMPORT	POINT	*i_copy_point(POINT*);
IMPORT	POINT	*i_make_point(float*,COMPONENT,COMPONENT);
IMPORT	POINTER	init_table_Store(size_t,INIT_DATA*);
IMPORT	POINTER	Store(size_t);
IMPORT	POINTER	store(size_t);
IMPORT	bool	exists_interface(INTERFACE*);
IMPORT	bool	i_delete_end_of_bond(BOND*,CURVE*);
IMPORT	bool	i_delete_node(NODE*);
IMPORT	bool	i_delete_start_of_bond(BOND*,CURVE*);
IMPORT	bool	i_insert_point_in_bond(POINT*,BOND*,CURVE*);
IMPORT	bool	next_bond(INTERFACE*,BOND**,CURVE**);
IMPORT	bool	next_curve(INTERFACE*,CURVE**);
IMPORT	bool	next_hypersurface1d(INTERFACE*,HYPER_SURF**);
IMPORT	const char *i_boundary_type_as_string(int);
IMPORT	float	i_random01(INTERFACE*);
IMPORT	int	i_delete_curve(CURVE*);
IMPORT	int	i_delete_interface(INTERFACE*);
IMPORT	int	i_delete_point(POINT*);
IMPORT	struct	Table	*interface_table_list(void);
IMPORT	struct	Table	*table_of_interface(INTERFACE*);
IMPORT	uint64_t	bond_number(BOND*,INTERFACE*);
IMPORT	uint64_t	curve_number(CURVE*);
IMPORT	uint64_t	hypersurface_boundary_number(HYPER_SURF_BDRY*);
IMPORT	uint64_t	hypersurface_element_number(HYPER_SURF_ELEMENT*,
						    INTERFACE*);
IMPORT	uint64_t	hypersurface_number(HYPER_SURF*);
IMPORT	uint64_t	interface_number(INTERFACE*);
IMPORT	uint64_t	node_number(NODE*);
IMPORT	uint64_t	point_number(POINT*);
IMPORT	uint64_t	table_number(struct Table*);
IMPORT	int	i_read_boundary_type_from_string(const char*);
IMPORT	void	delete_from_cross_list(CROSS*);
IMPORT	void	fprint_hypersurface(FILE*,HYPER_SURF*);
IMPORT	void	i_fprint_interface(FILE*,INTERFACE*);
IMPORT	void	print_hypersurface(HYPER_SURF*);
IMPORT	void	print_hypersurface_boundaries(HYPER_SURF_BDRY**);
IMPORT	void	set_current_interface(INTERFACE*);
#if defined(THREED)
IMPORT	POINT *i_average_points(bool,POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
	                             POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*);
IMPORT	ORIENTATION orientation_of_bond_at_tri(BOND*,TRI*);
IMPORT	bool	delete_side_of_tri(TRI*,SURFACE*,int);
IMPORT	bool	delete_vertex_of_tri(POINT*pt,TRI*,SURFACE*);
EXPORT	bool	flip_diagonal(TRI*,int);
EXPORT	bool	retriangulate_polygon(POINT**,int,POINT**,int,const float*,
				      TRI**,int,SURFACE*,BOND_TRI**,TRI**,
				      TRI***,int*);
IMPORT	int side_of_tri_with_bond(BOND*,TRI*);
IMPORT	uint64_t	bond_tri_number(BOND_TRI*,INTERFACE*);
IMPORT	uint64_t	surface_number(SURFACE*);
IMPORT	uint64_t	tri_number(TRI*,INTERFACE*);
IMPORT  void    print_rect_bdry_of_intfc(INTERFACE*);
#endif /* defined(THREED) */

/*	irefl.c*/
IMPORT	void	i_reflect_node(NODE*,float*,float*);
IMPORT	void	i_reflect_curve(CURVE*,float*,float*);
IMPORT	void	i_reflect_point(POINT*,float*,float*,INTERFACE*);
#if defined(THREED)
IMPORT	void	i_reflect_surface(SURFACE*,float*,float*);
#endif /* defined(THREED) */

/*	iscatter.c*/
IMPORT	int	domain_id(int*,int*,int);
IMPORT	int	neighbor_id(int*,int*,int,int,PP_GRID*);
IMPORT	void	find_Cartesian_coordinates(int,PP_GRID*,int*);
IMPORT	void	print_PP_GRID_structure(PP_GRID*);

/*	isub.c*/
IMPORT	BDRY_SIDE rect_bdry_side_for_curve(int*,int*,CURVE*,RECT_GRID*);
IMPORT	P_LINK	*add_to_hash_table(POINTER,POINTER,P_LINK*,int);
IMPORT	POINTER	find_from_hash_table(POINTER,P_LINK*,int);
IMPORT	bool	i_is_comp_in_list(COMPONENT,COMP_LIST*);
IMPORT	float	scalar_product_on_bonds(BOND*,BOND*,int);
IMPORT	float	scaled_bond_length(BOND*,float*,int);
#if !defined(separation)
IMPORT float separation(POINT*,POINT*,int);
#endif /* !defined(separation) */
IMPORT	int	curve_in_curve_list(CURVE*,CURVE**);
IMPORT	void	i_add_comp_to_list(COMPONENT,COMP_LIST*,INTERFACE*);
IMPORT	void	rect_bdry_side_for_hyper_surf(int*,int*,HYPER_SURF*,
					      RECT_GRID*);
IMPORT	void	reset_hash_table(P_LINK*,int);
IMPORT	void	reset_intfc_num_points(INTERFACE*);
IMPORT	void	vector_product_on_bonds(BOND*,BOND*,int,float*);
#if defined(TWOD)
IMPORT	float	area_of_closed_curve(CURVE*);
IMPORT	ANGLE_DIRECTION	c1_to_c2_direction(O_CURVE*,O_CURVE*);
IMPORT	bool	robust_cross_bonds(BOND*,int,BOND*,int,float*,float*,
				   RECT_GRID*,POINT*);
IMPORT	int	cross_sign(BOND*,BOND*);
IMPORT	int	intersect_bond_with_curve_segment(BOND*,BOND*,BOND*,O_CURVE*,
					  BOND**,POINT*,RECT_GRID*);
IMPORT	int	is_short_curve(CURVE*,ORIENTATION,RECT_GRID*,float);
IMPORT	int	robust_cross_bond_circle(BOND*,POINT*,float,float*,POINT*);
IMPORT	int	robust_extend_bond_to_cross_bond(BOND*,ORIENTATION,BOND*,
					float*,float*,POINT*,float*,int);
IMPORT	int	robust_extend_bonds_to_cross(BOND*,ORIENTATION,
					     int,BOND*,ORIENTATION,int,
					     POINT*,float*,float*,POINT*,
					     RECT_GRID*);
IMPORT	int	robust_quad_roots_in_interval(double*,double,double,double,
					      double,double,double);
IMPORT	void	big_angle(BOND*,CURVE*,BOND*,CURVE*,float*,float*,RECT_GRID*);
#endif /* defined(TWOD) */
#if defined(THREED)
IMPORT	int	set_tri_list_around_point(POINT*,TRI*,TRI***,INTERFACE*);
IMPORT	int	tri_list_computed_by_normal(POINT*,TRI*,TRI***,INTERFACE*);
IMPORT	const float* const *side_vector(const TRI*);
IMPORT	const float        *vector_on_tri_side(const TRI*,int,float*);
IMPORT	const float        *length_side(const TRI*);
IMPORT	const float	   *Tri_normal(const TRI*);
IMPORT	float              length_of_tri_side(const TRI*,int);
IMPORT	float              sqr_norm(const TRI*);
IMPORT	void	area_weighted_normal3d(POINT*,HYPER_SURF_ELEMENT*,
                                       HYPER_SURF*,float*);
IMPORT	void	average_position_of_surface(float*,SURFACE*);
IMPORT	void	omit_vertex_in_plane_fit(void);
IMPORT	void	plane_fit_normal3d(POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
				   float*);
IMPORT	void	reset_normal_on_intfc(INTERFACE*);
IMPORT	void	set_normal_of_tri(TRI*);
#endif /* defined(THREED) */

/*	iuserintfc.c*/
IMPORT	I_USER_INTERFACE	*i_user_hook(int);
IMPORT	void	SetChunkSize(size_t);
IMPORT	void	i_preserve_user_hooks(int,PRESERVE_USER_HOOKS);

/*	ppcopy.c*/
IMPORT	INTERFACE	*i_receive_interface(int);
IMPORT	POINTER	_new_address(INTERFACE*,POINTER,POINTER*,POINTER*,int);
IMPORT	void	i_reconstruct_bond_pointers(BOND*,INTERFACE*,INTERFACE*,
					    POINTER*,POINTER*,int);
IMPORT	void	i_reconstruct_curve_pointers(CURVE*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
IMPORT	void	i_reconstruct_interface_pointers(INTERFACE*,struct Table*,
						 POINTER*,POINTER*);
IMPORT	void	i_reconstruct_node_pointers(NODE*,INTERFACE*,INTERFACE*,
					    POINTER*,POINTER*,int);
IMPORT	void	i_reconstruct_point_pointers(POINT*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
IMPORT	void	i_send_interface(INTERFACE*,int);

#if defined(USE_OVERTURE)  && defined(__MPI__)
IMPORT  void    i_isend_interface(INTERFACE*,int,int,MPI_Request**,POINTER**);
IMPORT  INTERFACE     *i_ireceive_interface(int,int,MPI_Request**,POINTER**,
                           POINTER**,struct Table**);
IMPORT  void    isend_intfc_table(INTERFACE*,int,int,MPI_Request*);
IMPORT  void    i_isend_intfc_chunks(INTERFACE*,int,int,MPI_Request**,POINTER**);
IMPORT  INTERFACE *i_irecv_intfc_chunks(struct Table*,int,int,MPI_Request**,
                              POINTER**,POINTER**);

#endif /* if defined(USE_OVERTURE) && defined(__MPI__) */

/*	shift.c*/
IMPORT	INTERFACE *remap_interface(INTERFACE*,
				   void (*)(POINT*,BOND*,CURVE*,POINT*,BOND*,
					   CURVE*,bool,RECT_GRID*,POINTER),
				   void (*)(INTERFACE*,INTERFACE*,
					   void (*remap)(POINT*,BOND*,CURVE*,
							POINT*,BOND*,CURVE*,
							bool,RECT_GRID*,
							POINTER),
					   POINTER),
				   POINTER);

/*	top.c*/
IMPORT	BDRY_SIDE boundary_side(const float*,const RECT_GRID*,float);
IMPORT	BDRY_SIDE nearest_boundary(float*,RECT_GRID*);
IMPORT	BOND	*random_bond_on_curve(CURVE*);
IMPORT	CURVE	*adjacent_curve(CURVE*,ORIENTATION,ANGLE_DIRECTION,
				ORIENTATION*);
IMPORT	CURVE	*i_attach_curve_to_node(CURVE*,POINT*,BOND*,NODE*);
IMPORT	CURVE	*i_make_fourier_curve(int,float,float,FOURIER_POLY*,
				      COMPONENT,COMPONENT);
IMPORT	CURVE	*read_curve_from_file(COMPONENT,COMPONENT,NODE*,NODE*,char*);
IMPORT	O_NODE	*make_onode(NODE*);
IMPORT	bool	bonds_in_strict_order(BOND*,BOND*);
IMPORT	bool	points_in_strict_order(POINT*,BOND*,POINT*,BOND*,int);
IMPORT	const char *bdry_side_as_string(BDRY_SIDE);
IMPORT	float	curve_length(CURVE*);
IMPORT	int	intersect_ray_with_boundary(float*,float*,float*,float*,
					    float*,int);
IMPORT	int	intersect_ray_with_curve(POINT*,float*,BOND*,BOND*,
					 CURVE*,ORIENTATION,BOND**,POINT*);
IMPORT	int	intersect_ray_with_sector(POINT*,POINT*,float*,float**,
					  float*,int);
IMPORT	bool	i_move_closed_loop_node(CURVE*,BOND*);
IMPORT	int	num_curves_at_node(NODE*,int*,int*);
IMPORT	void	change_node_of_curve(CURVE*,ORIENTATION,NODE*);
IMPORT	void	i_cut_curve(POINT*,BOND*,CURVE*,ORIENTATION);
IMPORT	void	copy_o_curve(O_CURVE*,O_CURVE*);
IMPORT	void	delete_list(POINTER**);
IMPORT	void	i_invert_curve(CURVE*);
IMPORT	void	i_reverse_curve(CURVE*);
IMPORT	void	invert_bond(BOND*);
IMPORT	void	merge_and_delete_nodes(NODE*,NODE*);
IMPORT	void	nearest_boundary_point(float*,float*,RECT_GRID*);
IMPORT	void	plot_interface(INTERFACE*,const char*,int*,int*,const char*);
IMPORT	void	print_bdry_side(const char*,BDRY_SIDE,const char*);
IMPORT	void	print_bond(BOND*);
IMPORT	void	print_bond_list(CURVE*);
IMPORT	void	print_curve_with_orient(CURVE*,ORIENTATION);
IMPORT	void	print_int_vector(const char*,const int*,int,const char*);
IMPORT	void	print_o_curve(O_CURVE*);
IMPORT	void	print_o_curve_family(O_CURVE_FAMILY*);
IMPORT	void	print_onode(O_NODE*);
IMPORT	void	print_onode_list(O_NODE**);
IMPORT	void	rbl_after_move_node(NODE*);
IMPORT	void	set_bond_length(BOND*,int);
IMPORT	void	set_point_of_bond(POINT*,BOND*,ORIENTATION,int);
IMPORT	void	update_num_points(INTERFACE*);

/*	zoom.c*/
IMPORT	INTERFACE	*i_zoom_interface(INTERFACE*,RECT_GRID*,
					  float*,float*,float**);
IMPORT	void    clip_interface2d(INTERFACE*);
IMPORT	void	rotate_and_zoom_rect_grid(RECT_GRID*,float*,float*,float**);

#if defined(ONED)
/*	comp1d.c*/
IMPORT	bool consistent_components1d(INTERFACE*);
IMPORT	bool	make_point_comp_lists(INTERFACE*);
IMPORT	void	show_point_comp_lists(INTERFACE*);

/*	setb1d.c*/

#endif /* defined(ONED) */

#if defined(TWOD)
/*	comp2d.c*/
IMPORT	bool	make_bond_comp_lists(INTERFACE*);
IMPORT	float	shortest_distance2d(float*,BOND*,POINT**,float*,SIDE*);

/*	cross2d.c*/
IMPORT	int	find_companion_cross(CROSS*,CROSS**,ORIENTATION*,ORIENTATION*,
				     ORIENTATION*,ORIENTATION*);
IMPORT	void	add_to_cross_list(CROSS**,CURVE*,BOND*,CURVE*,BOND*,POINT*);
IMPORT	void	insert_in_cross_list(CROSS*,CROSS*);
IMPORT	void	print_cross(CROSS*);
IMPORT	void	print_cross_list(CROSS*);
IMPORT	void	rcl_after_delete_bond_fragment_at_node(CROSS*,POINT*,
						       CURVE*,ORIENTATION);
IMPORT	void	rcl_after_insert_point(CROSS*,POINT*,BOND*);
IMPORT	void	rcl_after_join(CROSS*,CURVE*,CURVE*,CURVE*);
IMPORT	void	rcl_after_split(CROSS*,POINT*,BOND*,CURVE*,CURVE**);

/*	isect2d.c*/
IMPORT	bool	bond_crosses_curve(BOND*,CURVE*,POINT*,BOND**,ORIENTATION);
IMPORT	bool	cross_bonds(BOND*,BOND*,POINT*);

/*	setb2d.c*/
IMPORT	bool	i_set_boundary2d(INTERFACE*,RECT_GRID*,COMPONENT,float);
/*      igview.c */
IMPORT  void    set_default_clr_map(float**,int);
IMPORT  void    geomview_intfc_plot2d(const char*,int,INTERFACE*,RECT_GRID*);
#if defined(CONSERVATIVE_ALG)
IMPORT  void    gview_time_mesh_plot2d(FILE*,RECT_GRID*,float,float*);
IMPORT  void    gview_time_space_intfc_plot2d(FILE*,TIME_SPACE_INTFC2D**,
                       RECT_GRID*,int,float**);
IMPORT void     gview_ts_mesh_tris_plot2d(const char*,int,TIME_SPACE_INTFC2D**,int,
                       RECT_GRID*,float);
#endif /* if defined(CONSERVATIVE_ALG) */
#endif /* defined(TWOD) */

#if defined(THREED) || defined(TWOD)
/* igview.c */
IMPORT  char    *set_ppfname(char*,const char*,size_t*);
IMPORT  char    *get_list_file_name(char*,const char*,const char*,size_t*);
#endif /* if defined(THREED) || defined(TWOD) */

#if defined(THREED)
/*	comp3d.c*/
IMPORT	bool	make_tri_comp_lists(INTERFACE*);
IMPORT	bool	within_tri(const float*,const float*,const float*,
	                   const float*,const float*,float);
IMPORT	bool	i_insert_point_in_tri(POINT*,TRI*,SURFACE*);
IMPORT	bool	i_insert_point_in_tri_side(POINT*,int,TRI*,SURFACE*);
IMPORT	bool	i_undo_insert_point_in_tri(POINT*,TRI*,SURFACE*);
IMPORT	bool	i_undo_insert_point_in_tri_side(POINT*,int,TRI*,SURFACE*);
IMPORT  bool    tri_edge_crossing(TRI*,float*,float*,int,int*,int*,float*);
IMPORT	void	assign_tri_icoords(RECT_GRID*,TRI*);

/* 	idiagnostic.c*/
IMPORT	int  	index_of_pointer(POINTER*,POINTER);
IMPORT  int 	points_on_surface(SURFACE*);
IMPORT 	void 	print_blk_tri(BLK_TRI*);
IMPORT	void 	print_bond(BOND*);
IMPORT  void 	points_of_interface(INTERFACE*);
IMPORT	bool	the_tri(TRI*);
IMPORT	bool	the_BOND(BOND*);
IMPORT	bool	the_point(POINT*);
IMPORT  bool    check_tri_and_neighbor(TRI*);
IMPORT  void    print_tri_coords(TRI*);

	/*igview.c*/
IMPORT	void	gview_bounding_box(FILE*,const float*,const float*,
	                           int,const char*);
IMPORT  void    gview_cube(FILE*,const float*,const float*);
IMPORT  void 	gview_local_surface(SURFACE*,const char*,const char*,
				    SURFACE_COLOR,const float*,float);
IMPORT	void	gview_plot_axes(const char*,const char*,const float*,
				const float*,const float*,const float*);
IMPORT	void	gview_plot_coord_sys(const char*,const char*,const float*,
	                             const float*,const float*,const float*,
				     const float*,const float*);
IMPORT	void	gview_plot_polyline(const char*,const char*,POINT**,
	                            int,bool,float,float,float,float,
				    const float*,const float*);
IMPORT	void	gview_plot_triangle_list(const char*,const char*,TRI**,int,
	                                 float,float,float,float,float,float,
					 float,const float*,const float*);
IMPORT	void	gview_plot_vertices(const char*,const char*,POINT**,
	                            int,const float*,const float*);
IMPORT	void	gview_plot_c_curve(const C_CURVE*,int,const char*);
IMPORT  void    gview_plot_curve(const CURVE*,const char*,const char*,
				 SURFACE_COLOR,int);
IMPORT	void	gview_plot_tri_and_point_list(const char*,TRI**,
	                                      const float*,int,float* const*,
					      SURFACE_COLOR,float,int,int);
IMPORT	void	gview_plot_tri_list(const char*,TRI**,int);
IMPORT  void    gview_polyline(const char*,const char*,float* const*,
			       int,SURFACE_COLOR,int);
IMPORT  void 	gview_surface(SURFACE*,const char*,SURFACE_COLOR);
IMPORT	void	geomview_interface_plot(const char*,INTERFACE*,RECT_GRID*);
IMPORT	void	set_point_list_bounding_box(POINT**,int,float*,
	                                    float*,bool,bool);
IMPORT	void	set_tri_list_bounding_box(TRI**,int,float*,float*,
	                                  bool,bool);
IMPORT	void	set_vector_bounding_box(const float*,const float*,float,
	                                float*,float*,bool,bool);

/*	int3d.c*/
IMPORT	BOND_TRI *i_link_tri_to_bond(BOND_TRI*,TRI*,SURFACE*,BOND*,CURVE*);
IMPORT	SURFACE	*i_copy_surface(SURFACE*,CURVE**,CURVE**,bool);
IMPORT	SURFACE *i_join_surfaces(CURVE*);
IMPORT	SURFACE	*i_make_surface(COMPONENT,COMPONENT,CURVE**,CURVE**);
IMPORT	SURFACE	*i_read_surface(INTERFACE*,int);
IMPORT	TRI	*i_make_tri(POINT*,POINT*,POINT*,POINTER,POINTER,POINTER,int);
IMPORT	TRI	*Next_tri_at_vertex(TRI*,POINT*);
IMPORT	TRI	*Prev_tri_at_vertex(TRI*,POINT*);
IMPORT	bool    curve_is_in_surface_bdry(SURFACE*,CURVE*,ORIENTATION*);
IMPORT	bool    find_surfaces_to_join_at_curve(CURVE*,SURFACE**,SURFACE**);
IMPORT	bool    i_sort_bond_tris(INTERFACE*);
IMPORT	bool	next_tri(INTERFACE*,TRI**,SURFACE**);
IMPORT	bool	remove_curve_from_surface_bdry(SURFACE*,CURVE*,ORIENTATION);
IMPORT	bool	tris_on_side_of_bond_for_join(BOND*,TRI**,int*,TRI**,int*);
IMPORT  bool    link_neighbor_tris(TRI*,TRI*);
IMPORT	int	i_delete_surface(SURFACE*);
IMPORT	void 	i_reverse_bond(BOND*);
IMPORT	void 	i_reorder_curve_link_list(CURVE*);
IMPORT	void	insert_tri_at_head_of_list(TRI*,SURFACE*);
IMPORT	void	insert_tri_at_tail_of_list(TRI*,SURFACE*);
IMPORT	void	install_curve_in_surface_bdry(SURFACE*,CURVE*,ORIENTATION);
IMPORT	void	link_tri_list_to_surface(TRI*,TRI*,SURFACE*);
IMPORT	void	null_tri_array_numbers(INTERFACE*);
IMPORT	void	print_tri(TRI*,INTERFACE*);
IMPORT	void	remove_tri_from_surface(TRI*,SURFACE*,bool);
IMPORT	void	rotate_triangle(TRI*,int);

/*	iprt3d.c*/
IMPORT	void	print_c_bond(C_BOND*,INTERFACE*);
IMPORT	void	print_c_curve(C_CURVE*,INTERFACE*);
IMPORT	void	print_c_surf(C_SURF*,INTERFACE*);
IMPORT	void	print_c_surf_flag(C_SURF_FLAG*);


/*	isect3d.c*/
IMPORT	C_BOND	*i_CBond(C_BOND*,POINT*,POINT*,TRI*,TRI*);
IMPORT	void	i_print_intersections3d(CROSS*,INTERFACE*);

/*	map.c*/

/*	setb3d.c*/
IMPORT	bool	i_set_boundary3d(INTERFACE*,RECT_GRID*,COMPONENT,float);

/*	trisurf.c*/
IMPORT	void	oblique_planar_surface_triangulation(SURFACE*,RECT_GRID*); 
IMPORT	void	planar_hole_surface_triangulation(SURFACE*,RECT_GRID*,
						  POINT*,POINT*,POINT*,POINT*);
IMPORT	void	planar_surface_triangulation(SURFACE*,RECT_GRID*,const bool);

/*	icheck3d.c*/
IMPORT	bool	i_consistent_interface(INTERFACE*);
IMPORT	void	null_sides_are_consistent(void);

#endif /* defined(THREED) */

/*	userhooks.c */
IMPORT	BOND	*Bond(POINT*,POINT*);
IMPORT	CURVE	*attach_curve_to_node(CURVE*,POINT*,BOND*,NODE*);
IMPORT	CURVE	*copy_curve(CURVE*,NODE*,NODE*);
IMPORT	CURVE	*make_curve(COMPONENT,COMPONENT,NODE*,NODE*);
IMPORT	CURVE	*read_curve(INTERFACE*,int);
IMPORT	HYPER_SURF *make_hypersurface(COMPONENT,COMPONENT);
IMPORT	HYPER_SURF_BDRY	*make_hypersurface_boundary(void);
IMPORT	INTERFACE	*copy_interface(INTERFACE*);
IMPORT	INTERFACE	*zoom_interface(INTERFACE*,RECT_GRID*,
					float*,float*,float**);
IMPORT	NODE	*copy_node(NODE*);
IMPORT	NODE	*make_node(POINT*);
IMPORT	NODE	*read_node(INTERFACE*,int);
IMPORT	POINT	*Point(float*);
IMPORT	POINT	*Static_point(INTERFACE*);
IMPORT	POINT	*average_points(bool,POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*,
	                             POINT*,HYPER_SURF_ELEMENT*,HYPER_SURF*);
IMPORT	POINT	*copy_point(POINT*);
IMPORT	bool	delete_end_of_bond(BOND*,CURVE*);
IMPORT	bool	delete_node(NODE*);
IMPORT	bool	delete_start_of_bond(BOND*,CURVE*);
IMPORT	bool	insert_point_in_bond(POINT*,BOND*,CURVE*);
IMPORT	bool	intersections(INTERFACE*,CROSS**,const bool);
IMPORT	bool	is_subdomain_boundary(HYPER_SURF*);
IMPORT	bool	is_subdomain_node(NODE*);
IMPORT	bool	is_virtual_fixed_node(NODE*);
IMPORT	bool	long_nearest_interface_point(float*,COMPONENT,INTERFACE*,
					     USE_BOUNDARIES,HYPER_SURF*,float*,
					     float*,HYPER_SURF_ELEMENT**,
					     HYPER_SURF**);
IMPORT	bool	long_nearest_similar_interface_point(float*,COMPONENT,COMPONENT,
						     INTERFACE*,USE_BOUNDARIES,
						     HYPER_SURF*,float*,float*,
						     HYPER_SURF_ELEMENT**,
						     HYPER_SURF**);
IMPORT	bool	move_closed_loop_node(CURVE*,BOND*);
IMPORT	bool	nearest_interface_point(float*,COMPONENT,INTERFACE*,
					USE_BOUNDARIES,HYPER_SURF*,float*,
					float*,HYPER_SURF_ELEMENT**,
					HYPER_SURF**);
IMPORT	bool	nearest_similar_interface_point(float*,COMPONENT,COMPONENT,
						INTERFACE*,USE_BOUNDARIES,
						HYPER_SURF*,float*,float*,
						HYPER_SURF_ELEMENT**,
						HYPER_SURF**);
IMPORT	bool	make_interface_topology_lists(INTERFACE*);
IMPORT	bool	next_point(INTERFACE*,POINT**,HYPER_SURF_ELEMENT**,
			   HYPER_SURF**);
IMPORT	bool	next_hypersurface(INTERFACE*,HYPER_SURF**);
IMPORT	bool	set_boundary(INTERFACE*,RECT_GRID*,COMPONENT,float);
IMPORT	bool	user_join_curves(CURVE*,CURVE*,CURVE*);
IMPORT	bool	user_split_curve(int,POINT*,BOND*,CURVE*,CURVE**);
IMPORT	float	random01(INTERFACE*);
IMPORT	float	cross_tolerance(INTERFACE*);
IMPORT	int	delete_curve(CURVE*);
IMPORT	int	delete_interface(INTERFACE*);
IMPORT	int	print_number_of_tangles(const char*,INTERFACE*,CROSS*);
IMPORT	int	read_boundary_type_from_string(const char*,INTERFACE*);
IMPORT	int	read_print_intfc_rect_grids(const IO_TYPE*,INTERFACE*,REMAP*);
IMPORT	int	user_read_node(NODE*);
IMPORT	int	user_read_print_interface(INIT_DATA*,const IO_TYPE*,
                                          INTERFACE*,bool);
IMPORT	void	fprint_boundary_type(FILE*,const char*,int,const char*,
				     INTERFACE*);
IMPORT	void	fprint_curve(FILE*,CURVE*);
IMPORT	void	fprint_interface(FILE*,INTERFACE*);
IMPORT	void	fprint_intfc_rect_grids(FILE*,INTERFACE*);
IMPORT	void	fprint_node(FILE*,NODE*);
IMPORT	void	invert_curve(CURVE*);
IMPORT	void	reverse_curve(CURVE*);
IMPORT	void	print_curve(CURVE*);
IMPORT	void	print_interface(INTERFACE*);
IMPORT	void	print_node(NODE*);
IMPORT	void	print_intersections(CROSS*,INTERFACE*);
IMPORT	void	print_crossing_elements(CROSS*,INTERFACE*);
IMPORT	void	reflect_interface(INTERFACE*,float*,float*);
IMPORT	void	reflect_node(NODE*,float*,float*);
IMPORT	void	reflect_curve(CURVE*,float*,float*);
IMPORT	void	reflect_point(POINT*,float*,float*,INTERFACE*);
IMPORT	void	fset_hyper_surf_color(FILE*,HYPER_SURF*);
IMPORT	void	user_copy_hyper_surf(HYPER_SURF*,HYPER_SURF*);
IMPORT	void	user_fprint_curve(FILE*,CURVE*);
IMPORT	void	user_fprint_interface(FILE*,INTERFACE*);
IMPORT	void	user_fprint_intfc_rect_grids(FILE*,INTERFACE*);
IMPORT	void	user_fprint_node(FILE*,NODE*);
IMPORT	void	user_make_interface(INTERFACE*);
IMPORT	void	user_read_curve(CURVE*);
IMPORT	bool	user_read_print_curve(CURVE*,const IO_TYPE*,bool);
IMPORT	void	user_read_print_intfc_rect_grids(const IO_TYPE*,INTERFACE*,
						 bool,REMAP*);
IMPORT	void	user_read_print_node(NODE*,const IO_TYPE*,bool);
#if defined(ONED)
IMPORT	POINT	*make_point(float*,COMPONENT,COMPONENT);
IMPORT	POINT	*read_point(INTERFACE*,int);
IMPORT	POINT	*read_print_point(INTERFACE*,const IO_TYPE*,bool);
IMPORT	int	delete_point(POINT*);
IMPORT	void	fprint_point(FILE*,POINT*);
IMPORT	void	print_point(POINT*);
IMPORT	void	user_fprint_point(FILE*,POINT*);
IMPORT	void	user_read_print_point(POINT*,const IO_TYPE*,bool);
IMPORT	void	user_read_point(INTERFACE*,POINT*);
#endif /* defined(ONED) */
IMPORT	INTERFACE	*receive_interface(int);
IMPORT	void	reconstruct_bond_pointers(BOND*,INTERFACE*,INTERFACE*,
					  POINTER*,POINTER*,int);
IMPORT	void	reconstruct_curve_pointers(CURVE*,INTERFACE*,INTERFACE*,
					   POINTER*,POINTER*,int);
IMPORT	void	reconstruct_interface_pointers(INTERFACE*,struct Table*,
					       POINTER*,POINTER*);
IMPORT	void	reconstruct_node_pointers(NODE*,INTERFACE*,INTERFACE*,
					  POINTER*,POINTER*,int);
IMPORT	void	reconstruct_point_pointers(POINT*,INTERFACE*,INTERFACE*,
					   POINTER*,POINTER*,int);
IMPORT	void	send_interface(INTERFACE *,int);

#if defined(USE_OVERTURE) && defined(__MPI__)
IMPORT  INTERFACE   *ireceive_interface(int,int,MPI_Request**,
                             POINTER**,POINTER**,struct Table**);
IMPORT  void    isend_interface(INTERFACE *,int,int,MPI_Request**,POINTER**);
IMPORT  void    isend_intfc_chunks(INTERFACE*,int,int,MPI_Request**,POINTER**);
IMPORT  INTERFACE   *irecv_intfc_chunks(struct Table*,int,int,MPI_Request**,
                            POINTER**,POINTER**);
IMPORT  void    ireconstruct_interface_pointers(INTERFACE *,struct Table*,POINTER*,POINTER*);
#endif /* if defined(USE_OVERTURE) && defined(__MPI__) */

#if defined(THREED)
IMPORT	BOND_TRI *link_tri_to_bond(BOND_TRI*,TRI*,SURFACE*,BOND*,CURVE*);
IMPORT	C_BOND	*CBond(C_BOND*,POINT*,POINT*,TRI*,TRI*);
IMPORT	SURFACE *copy_surface(SURFACE*,CURVE**,CURVE**,bool);
IMPORT	SURFACE *join_surfaces(CURVE*);
IMPORT	SURFACE *make_surface(COMPONENT,COMPONENT,CURVE**,CURVE**);
IMPORT	SURFACE *read_surface(INTERFACE*,int);
IMPORT	TRI	*make_tri(POINT*,POINT*,POINT*,POINTER,POINTER,POINTER,int);
IMPORT	bool	consistent_interface(INTERFACE*);
IMPORT	bool	insert_point_in_tri(POINT*,TRI*,SURFACE*);
IMPORT	bool	insert_point_in_tri_side(POINT*,int,TRI*,SURFACE*);
IMPORT	bool sort_bond_tris(INTERFACE*);
IMPORT	bool	undo_insert_point_in_tri(POINT*,TRI*,SURFACE*);
IMPORT	bool	undo_insert_point_in_tri_side(POINT*,int,TRI*,SURFACE*);
IMPORT	int	delete_surface(SURFACE*);
IMPORT	void 	reverse_bond(BOND*);
IMPORT	void 	reorder_curve_link_list(CURVE*);
IMPORT	void	assign_curve_boundary_flag(CURVE*);
IMPORT	void	gview_plot_interface(const char*,INTERFACE*);
IMPORT	void	fprint_surface(FILE*,SURFACE*);
IMPORT	void	print_surface(SURFACE*);
IMPORT	void	reconstruct_surface_pointers(SURFACE*,INTERFACE*,INTERFACE*,
					     POINTER*,POINTER*,int);
IMPORT	void	reconstruct_tri_pointers(TRI*,INTERFACE*,INTERFACE*,
					 POINTER*,POINTER*,int);
IMPORT	void	reflect_surface(SURFACE*,float*,float*);
IMPORT	void	user_fprint_surface(FILE*,SURFACE*);
IMPORT	void	user_install_faces(SURFACE*,int);
IMPORT	void	user_read_print_surface(SURFACE*,const IO_TYPE*,bool);
IMPORT	void	user_read_surface(SURFACE*);
IMPORT void     print_nodes_of_intfc(const INTERFACE*);

/*      iredist.c */
IMPORT	void  	equi_redist_curve_seg(CURVE*,BOND*,BOND*,int,float,float,
					RECT_GRID*);
IMPORT	void	rect_bdry_curve_redist(CURVE*,ORIENTATION,RECT_GRID*,float*);
IMPORT  void    rect_bdry_redist2d(INTERFACE*,RECT_GRID*,int);
IMPORT 	bool 	i_delete_point_adjacent_to_node(CURVE*,ORIENTATION);
IMPORT  bool  	closed_curve_node_redistribute(INTERFACE*,bool);


/*      imkcurve.c */
IMPORT	CURVE	*make_elliptic_curve(ELLIP_PARAMS*,COMPONENT,COMPONENT,float);
IMPORT	void	coords_on_ellips(float*,float*,ELLIP_PARAMS*);


/*      imksurf.c */
IMPORT  bool 	make_bdry_surfaces(INTERFACE*,RECT_GRID*);
IMPORT	bool    make_comp2_surface(RECT_GRID*,COMPONENT,COMPONENT,
                        float (*func)(POINTER,float*),POINTER,
                        SURFACE**);
IMPORT	bool	make_comp3_surfaces(RECT_GRID*,COMPONENT,COMPONENT,COMPONENT,
                        float (*func1)(POINTER,float*),POINTER,
                        float (*func2)(POINTER,float*),POINTER,
                        SURFACE***,CURVE**);
IMPORT	float	ellipsoid_func(POINTER,float*);
IMPORT	float	plane_func(POINTER,float*);
IMPORT	float	bdry_box_func(POINTER,float*);

/*      iblkc2.c */
IMPORT  BLK_CRX *alloc_blk_crx(bool);
IMPORT  int     construct_comp2_blk(BLK_CRX*,BLK_TRI*);
IMPORT  void    stitch_inside_blk(BLK_TRI*);
IMPORT  void    stitch_adj_blk(BLK_TRI*,BLK_TRI*);
IMPORT  void    remove_null_pair(BLK_TRI*,BLK_TRI*,int);
IMPORT  void    create_triangle(BLK_TRI*,POINT*,POINT*,POINT*,SURFACE*);
IMPORT  void    reorder_curve_link_list(CURVE*);
#endif /* defined(THREED) */

#if defined(THREED)
/*	ixgraph.c */
IMPORT  FILE 	*xgraph_file_open(const char*,const char*,
				  const COORDINATE_PLANE);
IMPORT  void 	xgraph_RECT_GRID(const char*,RECT_GRID*);
IMPORT  void 	xgraph_affine_vector(FILE*,float*,float*,
				     const COORDINATE_PLANE,const char*);
IMPORT  void 	xgraph_curve(FILE*,CURVE*,const COORDINATE_PLANE);
IMPORT  void 	xgraph_interface_curves(const char*,const char*,INTERFACE*,
					const COORDINATE_PLANE);
IMPORT  void  	xgraph_interface_nodes(const char*,const char*,INTERFACE*,
				       const COORDINATE_PLANE);
IMPORT  void 	xgraph_interface_surfaces(const char*,const char*,INTERFACE*,
					  const COORDINATE_PLANE);
IMPORT  void 	xgraph_line_segment(FILE*,float*,float*,
				    const COORDINATE_PLANE,const char*);
IMPORT  void 	xgraph_new_data_set(FILE*);
IMPORT  void 	xgraph_point(FILE*,float*,const COORDINATE_PLANE,const char*);
IMPORT  void 	xgraph_tri(FILE*,TRI*,const COORDINATE_PLANE);
IMPORT  void 	xgraph_tris_list(FILE*,TRI**,int,const COORDINATE_PLANE);
#endif /* defined(THREED) */

#if defined(TWOD)
/* i2dblk.c   */
IMPORT  int     reconstruct_blk_intfc2d(BLK_CRX2*,BLK_BOND*,JC_BLK_BOND*);
IMPORT  void    vol_alloc_blk_crx2d(BLK_CRX2**);
#if defined(CONSERVATIVE_ALG)
IMPORT  int     prt_pt_corresp_curve(CURVE*,int);
#endif /* if defined(CONSERVATIVE_ALG) */
#endif /* if defined(TWOD) */

#if defined(USE_OVERTURE)
/*   intfc_amr.c  */
IMPORT int      box_intersect(int*,int*,int*,int*,int,int*,int*);
IMPORT Trans_box  *add_to_box(int*,int*,int,Trans_box*,int*,int*);
IMPORT int      box_in_boxes(int*,int*,Trans_box*,int,int);
IMPORT int      point_in_boxes(int*,Trans_box*,int,int);
IMPORT void     set_amr_intfc_tol(INTERFACE*,float);
IMPORT void     print_rect_componentgrid(Rect_ComponentGrid);

#endif /* if defined(USE_OVERTURE) */

#endif /* !defined(_IPROTOS_H) */
