/*
*				idiagnositc.c:
*
*
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if defined(THREED)

#include <intfc/iloc.h>

LOCAL 	void 	data_of_point(POINT*,int);
	
EXPORT 	int 	index_of_pointer(
	POINTER	*array,
	POINTER p)
{
  	int i=0;
	while (*array != p) 
	{
	    ++array;
	    ++i;
        }
	return i;
} 		/*end index_of_pointer*/

/*
*			points_on_surface():
*
*	Counts number of unique points on surface.
*/	

EXPORT  int 	points_on_surface(
	SURFACE 	*s)
{
  	int		i, num_points;
	TRI		*tri;
	POINT		*p;

	for (tri = first_tri(s); !at_end_of_tri_list(tri,s); tri = tri->next)
	{
	    Index_of_point(Point_of_tri(tri)[0]) = Index_of_point(Point_of_tri(tri)[1]) =
	        Index_of_point(Point_of_tri(tri)[2]) = ERROR;
	}
	num_points = 0;
	for (tri = first_tri(s); !at_end_of_tri_list(tri,s); tri = tri->next)
	{
	    for (i = 0; i < 3; ++i)
	    {
		p = Point_of_tri(tri)[i];
		if (Index_of_point(p) == ERROR)
	        {
		    Index_of_point(p) = num_points++;
		}
	    }
	}
	return num_points;
} 		/*end points_on_surface*/

/*
*
*			points_of_interface()
*
*	Diagnostic function, prints POINT information for all points
*	in interface, in tabular form.
*
*/

EXPORT 	void 	points_of_interface(
	INTERFACE	*intfc)
{
  	POINT *p;
	HYPER_SURF_ELEMENT *hse;
	HYPER_SURF *hs;
	int i = 0;
	if (intfc->dim != 3)
	    return;
	(void) printf("\nBEGIN points_of_interface() intfc = %p\n",intfc);

	next_point(intfc,NULL,NULL,NULL);
	while (next_point(intfc,&p,&hse,&hs))
	{
	    if (i % 20 == 0)
	    {
		(void) printf("\n");
		(void) printf("   pnt   pnt         "
			      "------------coords-----------     "
			      "flag   -private-      ----pointers----\n");
		(void) printf("   cnt   num    bdry    "
			      "x          y          z        "
			      "bdry   sort  int      HSE          HS \n");
		(void) printf("=================================="
			      "====================="
			      "==================    ================\n");
	    }
	    data_of_point(p,i++);
	}
	(void) printf("END points_of_interface() intfc = %p\n",intfc);
	(void) printf("\n");
	return;
}		/*end points_of_interface*/

LOCAL 	void 	data_of_point(
	POINT	 		*p,	
	int			i)
{
	(void) printf("%6d %llu %3d %g %g %g %5d %5s    \n",
		      i,point_number(p),Boundary(p),
		      Coords(p)[0],Coords(p)[1],Coords(p)[2],
		      Boundary_point(p),
		      y_or_n(sorted(p)));
}	       /*end data_of_point*/

EXPORT 	void 	print_blk_tri(
	BLK_TRI *blk_tri)
{
	int i;
	TRI *tri;

  	(void) printf("print_blk_tri()  blk_tri = %p\n",blk_tri);
	(void) printf("num_surfs = %d  num_tris = %2d  num_null_sides = %2d  "
		      "first = %p\n",
		      blk_tri->blk_info->num_surfs,blk_tri->num_tris, 
		      blk_tri->num_null_sides,blk_tri->first);
	(void) printf("\n");
	for (i = 0, tri = blk_tri->first[0]; i < blk_tri->num_tris[0];
	     ++i, tri = tri->next)
	{
	    (void) printf("i = %3d\n",i);
	    print_tri(tri,blk_tri->surfs[0]->interface);
	}
} 		/*end print_blk_tri*/

/*
*	The following program can be used to identify a triangle
*	for selective debugging. The past experience tells us that
*	it is much easy to debug when a specific triangle is identified.
*	The use of this function requires input of the coordinates
*	for the three vertices of the triangle which must be filled
*	in the commented place.
*
*/

EXPORT bool the_tri(TRI *tri)
{
	int i,j;
	float tol = 1.0e-5;	/* vertices coords must have at least */
				/* five digits after decimal points */
        float p[3][3] = {{0.775890, 0.775400, 2.875004}, /* Place holder for */
                         {0.775104, 0.775487, 2.875721}, /* coords of points */
                         {0.775104, 0.775487, 2.875721}}; /* of the triangle */

        float p1[3] = {0.787465,0.763251,2.887505};
        float p2[3] = {0.762743,0.787722,2.863938};
        int p1_found,p2_found;
        p1_found = p2_found = NO;
        for (i = 0; i < 3; i++)
        {
            if (fabs(Coords(Point_of_tri(tri)[i])[0] - p1[0]) < tol &&
                fabs(Coords(Point_of_tri(tri)[i])[1] - p1[1]) < tol &&
                fabs(Coords(Point_of_tri(tri)[i])[2] - p1[2]) < tol)
                p1_found = YES;
        }
        for (i = 0; i < 3; i++)
        {
            if (fabs(Coords(Point_of_tri(tri)[i])[0] - p2[0]) < tol &&
                fabs(Coords(Point_of_tri(tri)[i])[1] - p2[1]) < tol &&
                fabs(Coords(Point_of_tri(tri)[i])[2] - p2[2]) < tol)
                p2_found = YES;
        }
        if (p1_found && p2_found) return YES;
        else return NO;
	
}	/* end the_tri */

/*      This function is to catch the triangle for */
/*      the detection using the function the_tri() */

EXPORT void print_tri_coords(TRI* tri)
{
        POINT *p;
        int i,j;
        for (i = 0; i < 3; i++)
        {
            p = Point_of_tri(tri)[i];
            printf("%f %f %f\n",Coords(p)[0],Coords(p)[1],Coords(p)[2]);
        }
}       /* end print_tri_coords */

EXPORT  bool check_tri_and_neighbor(TRI *tri)
{
        int i,j;
        TRI *nbtri;
        bool status = YES;
        for (i = 0; i < 3; i++)
        {
            if (is_side_bdry(tri,i))
                continue;
            nbtri = Tri_on_side(tri,i);
            if (nbtri != NULL)
            {
                for (j = 0; j < 3; j++)
                {
                    if (is_side_bdry(nbtri,j))
                        continue;
                    if (Tri_on_side(nbtri,j) == tri)
                    {
                        if (Point_of_tri(tri)[i] !=
                            Point_of_tri(nbtri)[Next_m3(j)] ||
                            Point_of_tri(tri)[Next_m3(i)] !=
                            Point_of_tri(nbtri)[j])
                        {
                            printf("Inconsistency on tri side %d: "
                                "ps = %d  pe = %d\n",i,
                                Point_of_tri(tri)[i],
                                Point_of_tri(tri)[Next_m3(i)]);
                            printf("Inconsistency on nbtri side %d: "
                                "ps = %d  pe = %d\n",j,
                                Point_of_tri(nbtri)[Next_m3(j)],
                                Point_of_tri(nbtri)[j]);
                            status = NO;
                        }
                    }
                    break;
                }
                if (j == 3)
                {
                    printf("The %d-th neighbor is not linked\n",i);
                }
            }
        }
        return status;
}       /* end check_tri_and_neighbor */

/*
*	The following program can be used to identify a bond
*	for selective debugging. The past experience tells us that
*	it is much easy to debug when a specific bond is identified.
*	The use of this function requires input of the coordinates
*	for the two end points of the bond which must be filled
*	in the commented place.
*
*/

EXPORT bool the_bond(BOND *b)
{
	int i;
	float tol = 1.0e-5;	/* vertices coords must have at least */
				/* five digits after decimal points */

	float p[2][3] = {{2.52965, 2.200004, 2.200004},	/* Place holder for */
			 {2.2, 2.52965,  2.2}};	/* coords of end points */
	
	for (i = 0; i < 3; i++)
	{
	    if (fabs(Coords(b->start)[i] - p[0][i]) > tol)
			return NO;
	}
	for (i = 0; i < 3; i++)
	{
	    if (fabs(Coords(b->end)[i] - p[1][i]) > tol)
			return NO;
	}
	return YES;
}	/* end the_bond */

/*
*	The following program can be used to identify a 3D point
*	for selective debugging. The past experience tells us that
*	it is much easy to debug when a specific point is identified.
*	The use of this function requires input of the coordinates
*	for the point. 
*
*/

EXPORT bool the_point(POINT *pt)
{
	int i;
	float tol = 1.0e-5;	/* vertices coords must have at least */
				/* five digits after decimal points */

        float p[3] = {0.025000, 0.025000, 1.901263};    /* Place holder for */
					/* coords of the point */
	
	for (i = 0; i < 3; i++)
	{
	    if (fabs(Coords(pt)[i] - p[i]) > tol)
			return NO;
	}
	return YES;
}	/* end the_point */
#endif /* defined(THREED) */
