/*
*				iblkb.c:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Containing function of rebuilding interface within a mesh block.
*
*/

#if defined(THREED)

#include <intfc/int.h>

#define DEBUG_STRING "blk_intfc"

LOCAL	bool is_case_b1(BLK_CRX*);
LOCAL	bool is_case_b2(BLK_CRX*);
LOCAL	bool is_case_b3(BLK_CRX*);
LOCAL	bool is_case_b4(BLK_CRX*);
LOCAL	void x_rot(BLK_CRX*);
LOCAL	void y_rot(BLK_CRX*);
LOCAL	void z_rot(BLK_CRX*);
LOCAL	void blk_case_b1(BLK_CRX*,BLK_TRI*);
LOCAL	void blk_case_b2(BLK_CRX*,BLK_TRI*);
LOCAL	void blk_case_b3(BLK_CRX*,BLK_TRI*);
LOCAL	void blk_case_b4(BLK_CRX*,BLK_TRI*);
LOCAL	void rot_24(BLK_CRX*,int);

EXPORT	int construct_bdry_blk(
	BLK_CRX *blk_crx,
	BLK_TRI *blk_mem)
{
	int i;

	if (blk_crx->nv[0] > 4)
	{
	    screen("ERROR: in construct_bdry_blk(), no such case!\n");
	    clean_up(ERROR);
	}

	for (i = 0; i < 24; i++)
	{
	    if (blk_crx->nv[0] == 1)
	    {
		if (is_case_b1(blk_crx))
		{
		    blk_case_b1(blk_crx,blk_mem);
	    	    break;
		}
	    }
	    else if (blk_crx->nv[0] == 2)
	    {
		if (is_case_b2(blk_crx))
		{
		    blk_case_b2(blk_crx,blk_mem);
	    	    break;
		}
	    }
	    else if (blk_crx->nv[0] == 4)
	    {
		if (is_case_b3(blk_crx))
		{
		    blk_case_b3(blk_crx,blk_mem);
	    	    break;
		}
		if (is_case_b4(blk_crx))
		{
		    blk_case_b4(blk_crx,blk_mem);
	    	    break;
		}
	    }
	    rot_24(blk_crx,i);
	}
	stitch_inside_blk(blk_mem);

	return FUNCTION_SUCCEEDED;
}	/* end reconstruct_blk_intfc */

LOCAL	bool is_case_b1(BLK_CRX *blk_crx)
{
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT *comps = blk_crx->comps;

	if (comp[0][0][0] != comps[1]) return NO;
	if (comp[0][0][1] != comps[1]) return NO;
	if (comp[0][1][0] != comps[1]) return NO;
	if (comp[0][1][1] != comps[1]) return NO;
	if (comp[1][0][0] != comps[1]) return NO;
	if (comp[1][0][1] != comps[0]) return NO;
	if (comp[1][1][0] != comps[1]) return NO;
	if (comp[1][1][1] != comps[1]) return NO;
	return YES;
}	/* end is_case_b1 */

LOCAL	bool is_case_b2(BLK_CRX *blk_crx)
{
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT *comps = blk_crx->comps;

	if (comp[0][0][0] != comps[1]) return NO;
	if (comp[0][0][1] != comps[1]) return NO;
	if (comp[0][1][0] != comps[1]) return NO;
	if (comp[0][1][1] != comps[1]) return NO;
	if (comp[1][0][0] != comps[0]) return NO;
	if (comp[1][0][1] != comps[0]) return NO;
	if (comp[1][1][0] != comps[1]) return NO;
	if (comp[1][1][1] != comps[1]) return NO;
	return YES;
}	/* end is_case_b2 */

LOCAL	bool is_case_b3(BLK_CRX *blk_crx)
{
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT *comps = blk_crx->comps;

	if (comp[0][0][0] != comps[1]) return NO;
	if (comp[0][1][0] != comps[1]) return NO;
	if (comp[1][0][0] != comps[1]) return NO;
	if (comp[1][1][0] != comps[1]) return NO;
	if (comp[0][0][1] != comps[0]) return NO;
	if (comp[0][1][1] != comps[0]) return NO;
	if (comp[1][0][1] != comps[0]) return NO;
	if (comp[1][1][1] != comps[0]) return NO;
	if (blk_crx->curve_crx[0][0] != NULL &&
	    blk_crx->curve_crx[0][1] != NULL &&
	    blk_crx->curve_crx[1][0] != NULL &&
	    blk_crx->curve_crx[1][1] != NULL)
	    return YES;
	else
	    return NO;
}	/* end is_case_b3 */

LOCAL	bool is_case_b4(BLK_CRX *blk_crx)
{
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT *comps = blk_crx->comps;

	if (comp[0][0][0] != comps[1]) return NO;
	if (comp[0][1][0] != comps[1]) return NO;
	if (comp[1][0][0] != comps[1]) return NO;
	if (comp[1][1][0] != comps[1]) return NO;
	if (comp[0][0][1] != comps[0]) return NO;
	if (comp[0][1][1] != comps[0]) return NO;
	if (comp[1][0][1] != comps[0]) return NO;
	if (comp[1][1][1] != comps[0]) return NO;
	if (blk_crx->curve_crx[0][0] != NULL &&
	    blk_crx->curve_crx[0][1] != NULL &&
	    blk_crx->curve_crx[1][0] == NULL &&
	    blk_crx->curve_crx[1][1] == NULL)
	    return YES;
	else
	    return NO;
}	/* end is_case_b4 */

LOCAL 	void blk_case_b1(
        BLK_CRX *bc,
        BLK_TRI *bm)
{
        POINT *p1, *p2, *p3;
	SURFACE *s1,*s2,*s3;
	CURVE *c1,*c2,*c3;
 
	/* Create bonds */

	bm->num_curves = 3;
	bm->num_surfaces = 3;
	bm->curves[0] = c1 = bc->curve_crx[0][1]->c;
	p1 = bc->curve_crx[0][1]->p;
        p2 = bc->node_crx->p;
	if (p1 == c1->start->posn)
	    bm->bonds[0] = Bond(p1,p2);
	else
	    bm->bonds[0] = Bond(p2,p1);

	bm->curves[1] = c2 = bc->curve_crx[1][0]->c;
	p1 = bc->curve_crx[1][0]->p;
        p2 = bc->node_crx->p;
	if (p1 == c2->start->posn)
	    bm->bonds[1] = Bond(p1,p2);
	else
	    bm->bonds[1] = Bond(p2,p1);

	bm->curves[2] = c3 = bc->curve_crx[2][1]->c;
	p1 = bc->curve_crx[2][1]->p;
        p2 = bc->node_crx->p;
	if (p1 == c3->start->posn)
	    bm->bonds[2] = Bond(p1,p2);
	else
	    bm->bonds[2] = Bond(p2,p1);

	/* First surface */

	bm->surfs[0] = s1 = bc->crx[0][0][1]->s;
	bm->num_null_sides[0] = 6;
        p1 = bc->crx[0][0][1]->p;
        p2 = bc->curve_crx[2][1]->p;
        p3 = bc->curve_crx[1][0]->p;
	if (bc->comps[0] == positive_component(s1))
	    create_triangle(bm,p1,p2,p3,s1);
	else
	    create_triangle(bm,p1,p3,p2,s1);

        p1 = bc->node_crx->p;
        p2 = bc->curve_crx[1][0]->p;
        p3 = bc->curve_crx[2][1]->p;
	if (bc->comps[0] == positive_component(s1))
	    create_triangle(bm,p1,p2,p3,s1);
	else
	    create_triangle(bm,p1,p3,p2,s1);

	/* Second surface */

	bm->num_null_sides[1] = 6;
	bm->surfs[1] = s2 = bc->crx[1][1][1]->s;
        p1 = bc->crx[1][1][1]->p;
        p2 = bc->curve_crx[0][1]->p;
        p3 = bc->curve_crx[2][1]->p;
	if (bc->comps[0] == positive_component(s2))
	    create_triangle(bm,p1,p2,p3,s2);
	else
	    create_triangle(bm,p1,p3,p2,s2);
 
        p1 = bc->node_crx->p;
        p2 = bc->curve_crx[2][1]->p;
        p3 = bc->curve_crx[0][1]->p;
	if (bc->comps[0] == positive_component(s2))
	    create_triangle(bm,p1,p2,p3,s2);
	else
	    create_triangle(bm,p1,p3,p2,s2);

	/* Third surface */

	bm->num_null_sides[2] = 6;
	bm->surfs[2] = s3 = bc->crx[2][1][0]->s;
	p1 = bc->crx[2][1][0]->p;
        p2 = bc->curve_crx[1][0]->p;
        p3 = bc->curve_crx[0][1]->p;
	if (bc->comps[0] == positive_component(s3))
	    create_triangle(bm,p1,p2,p3,s3);
	else
	    create_triangle(bm,p1,p3,p2,s3);

        p1 = bc->node_crx->p;
        p2 = bc->curve_crx[0][1]->p;
        p3 = bc->curve_crx[1][0]->p;
	if (bc->comps[0] == positive_component(s3))
	    create_triangle(bm,p1,p2,p3,s3);
	else
	    create_triangle(bm,p1,p3,p2,s3);
}       /* end blk_case_b1 */


LOCAL	void blk_case_b2(
        BLK_CRX *bc,
        BLK_TRI *bm)
{
        POINT *p1, *p2, *p3;
	SURFACE *s1,*s2;
	CURVE *c;

	/* Create the bond */

	bm->num_curves = 1;
	bm->num_surfaces = 2;

	bm->curves[0] = bc->curve_crx[2][1]->c;
	p1 = bc->curve_crx[2][0]->p;
	p2 = bc->curve_crx[2][1]->p;
	bm->bonds[0] = Bond(p2,p1);

	if (bc->curve_crx[0][0] != NULL ||
	    bc->curve_crx[0][1] != NULL)
	{
	    c = bm->curves[bm->num_curves] = (bc->curve_crx[0][0]) ?
	    	bc->curve_crx[0][0]->c : bc->curve_crx[0][1]->c;
	    p1 = (bc->curve_crx[0][0]) ? bc->curve_crx[0][0]->p :
	    	bc->curve_crx[0][1]->p;
	    if (c->start->posn == bc->curve_crx[2][0]->p ||
	    	c->end->posn == bc->curve_crx[2][0]->p)
	    {
	    	p2 = bc->curve_crx[2][0]->p;
	    }
	    else if (c->start->posn == bc->curve_crx[2][1]->p ||
	        c->end->posn == bc->curve_crx[2][1]->p)
	    {
	    	p2 = bc->curve_crx[2][1]->p;
	    }
	    bm->bonds[bm->num_curves++] = Bond(p2,p1);
	}
	if (bc->curve_crx[1][0] != NULL ||
	    bc->curve_crx[1][1] != NULL)
	{
	    c = bm->curves[bm->num_curves] = (bc->curve_crx[1][0]) ?
	    	bc->curve_crx[1][0]->c : bc->curve_crx[1][1]->c;
	    p1 = (bc->curve_crx[1][0]) ? bc->curve_crx[1][0]->p :
	    	bc->curve_crx[1][1]->p;
	    if (c->start->posn == bc->curve_crx[2][0]->p ||
	    	c->end->posn == bc->curve_crx[2][0]->p)
	    {
	    	p2 = bc->curve_crx[2][0]->p;
	    }
	    else if (c->start->posn == bc->curve_crx[2][1]->p ||
	        c->end->posn == bc->curve_crx[2][1]->p)
	    {
	    	p2 = bc->curve_crx[2][1]->p;
	    }
	    bm->bonds[bm->num_curves++] = Bond(p2,p1);
	}

	/* First surface */

	bm->num_null_sides[0] = 6;
	bm->surfs[0] = s1 = bc->crx[0][0][1]->s;
        p1 = bc->crx[0][0][1]->p;
        p2 = bc->crx[0][0][0]->p;
        p3 = bc->curve_crx[2][1]->p;
	if (bc->comps[0] == positive_component(s1))
	    create_triangle(bm,p1,p3,p2,s1);
	else
	    create_triangle(bm,p1,p2,p3,s1);

        p1 = bc->curve_crx[2][0]->p;
        p2 = bc->curve_crx[2][1]->p;
        p3 = bc->crx[0][0][0]->p;
	if (bc->comps[0] == positive_component(s1))
	    create_triangle(bm,p1,p3,p2,s1);
	else
	    create_triangle(bm,p1,p2,p3,s1);

	/* Second surface */

	bm->num_null_sides[1] = 6;
	bm->surfs[1] = s2 = bc->crx[1][0][1]->s;
	p1 = bc->curve_crx[2][1]->p;
	p2 = bc->crx[1][0][1]->p;
	p3 = bc->crx[1][1][1]->p;
	if (bc->comps[0] == positive_component(s2))
	    create_triangle(bm,p1,p3,p2,s2);
	else
	    create_triangle(bm,p1,p2,p3,s2);

	p1 = bc->crx[1][0][1]->p;
	p2 = bc->curve_crx[2][1]->p;
	p3 = bc->curve_crx[2][0]->p;
	if (bc->comps[0] == positive_component(s2))
	    create_triangle(bm,p1,p3,p2,s2);
	else
	    create_triangle(bm,p1,p2,p3,s2);
}       /* end blk_case_b2 */

LOCAL 	void blk_case_b3(
        BLK_CRX *bc,
        BLK_TRI *bm)
{
	POINT *p1,*p2,*p3;
	SURFACE *s;

	bm->num_curves = 2;
	bm->num_surfaces = 1;

	bm->curves[0] = (bc->curve_crx[0][0]->c != NULL) ?
		bc->curve_crx[0][0]->c : bc->curve_crx[0][1]->c;
	bm->curves[1] = (bc->curve_crx[1][0]->c != NULL) ?
		bc->curve_crx[1][0]->c : bc->curve_crx[1][1]->c;

	p1 = bc->curve_crx[0][0]->p;
	p2 = bc->curve_crx[0][1]->p;
	bm->bonds[0] = Bond(p1,p2);
	p1 = bc->curve_crx[1][0]->p;
	p2 = bc->curve_crx[1][1]->p;
	bm->bonds[1] = Bond(p1,p2);

	bm->surfs[0] = s = bc->crx[2][0][0]->s;
	p1 = bc->crx[2][0][0]->p;
	p2 = bc->crx[2][0][1]->p;
	p3 = bc->crx[2][1][0]->p;
	if (bc->comps[0] == positive_component(s))
	    create_triangle(bm,p1,p2,p3,s);
	else
	    create_triangle(bm,p1,p3,p2,s);

	p1 = bc->crx[2][1][1]->p;
	if (bc->comps[0] == positive_component(s))
	    create_triangle(bm,p1,p3,p2,s);
	else
	    create_triangle(bm,p1,p2,p3,s);
}       /* end blk_case_b3 */

LOCAL 	void blk_case_b4(
        BLK_CRX *bc,
        BLK_TRI *bm)
{
	POINT *p1,*p2,*p3;
	SURFACE *s;

	bm->num_curves = 1;
	bm->num_surfaces = 1;

	bm->curves[0] = bc->curve_crx[0][0]->c;
	p1 = bc->curve_crx[0][0]->p;
	p2 = bc->curve_crx[0][1]->p;
	bm->bonds[0] = Bond(p1,p2);

	bm->surfs[0] = s = bc->crx[2][0][0]->s;
	p1 = bc->crx[2][0][0]->p;
	p2 = bc->crx[2][0][1]->p;
	p3 = bc->crx[2][1][0]->p;
	if (bc->comps[0] == positive_component(s))
	    create_triangle(bm,p1,p2,p3,s);
	else
	    create_triangle(bm,p1,p3,p2,s);

	p1 = bc->crx[2][1][1]->p;
	if (bc->comps[0] == positive_component(s))
	    create_triangle(bm,p1,p3,p2,s);
	else
	    create_triangle(bm,p1,p2,p3,s);
}       /* end blk_case_b4 */

LOCAL	void rot_24(
	BLK_CRX *blk_crx,
	int n)
{
	if (n < 16)
	{
	    x_rot(blk_crx);
	    if ((n+1)%4 == 0) 
	    	y_rot(blk_crx);
	}
	else if (n == 16)
	{
	    z_rot(blk_crx);
	    x_rot(blk_crx);
	}
	else if (n == 20)
	{
	    z_rot(blk_crx);
	    z_rot(blk_crx);
	    x_rot(blk_crx);
	}
	else if (n < 24)
	{
	    x_rot(blk_crx);
	}
}	/* end rot_24 */

LOCAL	void x_rot(BLK_CRX *blk_crx)
{
	int i;
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT comp_tmp;
	BBI_POINT ****crx = blk_crx->crx;
	BBI_POINT ***curve_crx = blk_crx->curve_crx;
	BBI_POINT *crx_tmp;

	for (i = 0; i < 2; i++)
	{
	    comp_tmp = comp[i][0][0];
	    comp[i][0][0] = comp[i][1][0];
	    comp[i][1][0] = comp[i][1][1];
	    comp[i][1][1] = comp[i][0][1];
	    comp[i][0][1] = comp_tmp;
	    crx_tmp = crx[2][i][0];
	    crx[2][i][0] = crx[1][0][i];
	    crx[1][0][i] = crx[2][i][1];
	    crx[2][i][1] = crx[1][1][i];
	    crx[1][1][i] = crx_tmp;
	}
	crx_tmp = curve_crx[1][0];
	curve_crx[1][0] = curve_crx[2][0];
	curve_crx[2][0] = curve_crx[1][1];
	curve_crx[1][1] = curve_crx[2][1];
	curve_crx[2][1] = crx_tmp;
	crx_tmp = crx[0][0][0];
	crx[0][0][0] = crx[0][1][0];
	crx[0][1][0] = crx[0][1][1];
	crx[0][1][1] = crx[0][0][1];
	crx[0][0][1] = crx_tmp;
}	/* end x_rot */

LOCAL	void y_rot(BLK_CRX *blk_crx)
{
	int j;
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT comp_tmp;
	BBI_POINT ****crx = blk_crx->crx;
	BBI_POINT ***curve_crx = blk_crx->curve_crx;
	BBI_POINT *crx_tmp;

	for (j = 0; j < 2; j++)
	{
	    comp_tmp = comp[0][j][0];
	    comp[0][j][0] = comp[0][j][1];
	    comp[0][j][1] = comp[1][j][1];
	    comp[1][j][1] = comp[1][j][0];
	    comp[1][j][0] = comp_tmp;
	    crx_tmp = crx[2][0][j];
	    crx[2][0][j] = crx[0][j][1];
	    crx[0][j][1] = crx[2][1][j];
	    crx[2][1][j] = crx[0][j][0];
	    crx[0][j][0] = crx_tmp;
	}
	crx_tmp = curve_crx[2][0];
	curve_crx[2][0] = curve_crx[0][0];
	curve_crx[0][0] = curve_crx[2][1];
	curve_crx[2][1] = curve_crx[0][1];
	curve_crx[0][1] = crx_tmp;
	crx_tmp = crx[1][0][0];
	crx[1][0][0] = crx[1][1][0];
	crx[1][1][0] = crx[1][1][1];
	crx[1][1][1] = crx[1][0][1];
	crx[1][0][1] = crx_tmp;
}	/* end y_rot */

LOCAL	void z_rot(BLK_CRX *blk_crx)
{
	int k;
	COMPONENT ***comp = blk_crx->comp;
	COMPONENT comp_tmp;
	BBI_POINT ****crx = blk_crx->crx;
	BBI_POINT ***curve_crx = blk_crx->curve_crx;
	BBI_POINT *crx_tmp;

	for (k = 0; k < 2; k++)
	{
	    comp_tmp = comp[0][0][k];
	    comp[0][0][k] = comp[1][0][k];
	    comp[1][0][k] = comp[1][1][k];
	    comp[1][1][k] = comp[0][1][k];
	    comp[0][1][k] = comp_tmp;
	    crx_tmp = crx[0][0][k];
	    crx[0][0][k] = crx[1][k][1];
	    crx[1][k][1] = crx[0][1][k];
	    crx[0][1][k] = crx[1][k][0];
	    crx[1][k][0] = crx_tmp;
	}
	crx_tmp = curve_crx[0][0];
	curve_crx[0][0] = curve_crx[1][0];
	curve_crx[1][0] = curve_crx[0][1];
	curve_crx[0][1] = curve_crx[1][1];
	curve_crx[1][1] = crx_tmp;
	crx_tmp = crx[2][0][0];
	crx[2][0][0] = crx[2][1][0];
	crx[2][1][0] = crx[2][1][1];
	crx[2][1][1] = crx[2][0][1];
	crx[2][0][1] = crx_tmp;
}	/* end z_rot */
#endif /* defined(THREED) */
