/*
*				array.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*/

#if !defined(_ARRAY_H)
#define _ARRAY_H

#include <cdecs.h>

struct _POINTER_Q {
	struct _POINTER_Q *prev, *next;
	POINTER pointer;
};
typedef struct _POINTER_Q POINTER_Q;

#define add_to_pointer_queue(ptr,pq)				\
	generic_add_to_pointer_queue((POINTER)(ptr),(pq))
#define pointer_is_in_array(p,pa)				\
	_pointer_is_in_array((POINTER)(p),(POINTER*)(pa))
#define index_of_pointer_in_array(p,pa,pi)			\
	_index_of_pointer_in_array((POINTER)(p),(POINTER*)(pa),pi)
#define add_to_pointers(p,ppa)					\
	_add_to_pointers((POINTER)(p),(POINTER**)(ppa))
#define delete_from_pointers(p,ppa)				\
	_delete_from_pointers((POINTER)(p),(POINTER**)(ppa))
#define	add_to_ordered_pointers(np,ap,ppa)			\
	_add_to_ordered_pointers((POINTER)(np),(POINTER)(ap),(POINTER**)(ppa))
#define	delete_from_ordered_pointers(p,ppa)			\
	_delete_from_ordered_pointers((POINTER)(p),(POINTER**)(ppa))
#define	delete_from_ordered_pointers_at_location(i,ppa)		\
	_delete_from_ordered_pointers_at_location(i,(POINTER**)(ppa))
#define unique_add_to_pointers(p,ppa)				\
	_unique_add_to_pointers((POINTER)(p),(POINTER**)(ppa))
#define delete_from_pointers_if_present(p,ppa)			\
	_delete_from_pointers_if_present((POINTER)(p),(POINTER**)(ppa))

enum {
	PQ_DEFAULTS		    = 0,
	PQ_BLOCK_SIZE,
	PQ_ALLOC_TYPE,
	PQ_ALLOC_SIZE_FOR_POINTERS,
	N_PQ_OPTS
};


/*
*				size_of_pointers():
*
*	Returns the number of Pointers in a Pointer set:
*/
#define size_of_pointers(pset) 						\
		((pset) ? (((int *)(pset))[-2])/sizeof(POINTER) : 0 )

	/* arrayutils.c EXPORTED Function Prototypes */

IMPORT	POINTER_Q *delete_from_pointer_queue(POINTER_Q*);
IMPORT	POINTER_Q *generic_add_to_pointer_queue(POINTER,POINTER_Q*);
IMPORT	POINTER_Q *head_of_pointer_queue(POINTER_Q*);
IMPORT	POINTER_Q *tail_of_pointer_queue(POINTER_Q*);
IMPORT	bool	  _add_to_ordered_pointers(POINTER,POINTER,POINTER**);
IMPORT	bool	  _add_to_pointers(POINTER, POINTER**);
IMPORT	bool	  _delete_from_ordered_pointers(POINTER,POINTER**);
IMPORT	bool	  _delete_from_ordered_pointers_at_location(int,POINTER**);
IMPORT	bool	  _delete_from_pointers(POINTER,POINTER**);
IMPORT	bool	  _delete_from_pointers_if_present(POINTER,POINTER**);
IMPORT	bool	  _pointer_is_in_array(POINTER, POINTER*);
IMPORT	bool	  _index_of_pointer_in_array(POINTER, POINTER*,int*);
IMPORT	bool	  _unique_add_to_pointers(POINTER, POINTER**);
IMPORT	void	  set_pointer_queue_opts(int,...);

#endif /* !defined(_ARRAY_H) */
