/*
*			hprotos.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*/

#if !defined(_HPROTOS_H)
#define _HPROTOS_H

#include <hyp/hdecs.h>

	/* Hyp EXPORTED Function Declarations*/
	/* hdriver.c*/
IMPORT	int	hyp_scalar_driver(float,float*,Wave*,Front*);
IMPORT	int	hyp_vector_driver(float,float*,Wave*,Front*);
#if defined(CONSERVATIVE_ALG)
IMPORT  int     hyp_parab_mix_driver(float,float*,Wave*,Front*,
                   int(*)(float,float*,Wave*,Front*));
#endif /* #if defined(CONSERVATIVE_ALG) */

	/* hinit.c*/
IMPORT	bool	h_read_print_max_wave_speed_info(INIT_DATA*,const IO_TYPE*,
                                                 Wave*);
IMPORT  bool    h_read_print_max_viscosity_info(INIT_DATA*,const IO_TYPE*,Wave*);
IMPORT	void	h_set_interface_hooks(int);
IMPORT	void	init_point_source_composition(Wave*,
					      void (*)(Wave*,int,Locstate*));
IMPORT	void	 prompt_for_hyp_method(INIT_DATA*);
IMPORT	void	 prompt_for_unsplit_options(INIT_DATA*);
IMPORT	void     set_hyp_hooks(INIT_DATA*);
IMPORT	void	 set_hyperbolic_method(INIT_DATA*,Wave*,
		       int (**)(float,float*,Wave*,Front*),
                       int (**)(float,float*,Wave*,Front*,
                          int(*)(float,float*,Wave*,Front*)));

	/* hnpt.c*/
IMPORT	void	hyp_npt(int,int*,float,float,Wave*,Wave*,Front*,
			Front*,COMPONENT);
IMPORT	void	set_hyp_npt_globals(Wave*);

	/* hprint.c*/
IMPORT	void	h_fprint_max_wave_speed_info(FILE*,Wave*);

/* For parabolic step */
IMPORT	void	h_fprint_max_viscosity_info(FILE*,Wave*);

IMPORT	void	h_print_H_Front_structure(Front*);
IMPORT	void	print_Stencil(Stencil*);
IMPORT	void	print_Wave_structure(Wave*);
IMPORT	void	print_pt_sources(Wave*);
#if defined(TWOD)
IMPORT	void	print_tri_soln(FILE*,Front*,Wave*,TRI_SOLN*,size_t,
			       float (**)(float*,Front*,Wave*,
					 COMPONENT,Locstate));
IMPORT  void    print_non_tri_soln(FILE*,Front*,Wave*,TRI_SOLN*,size_t,
                                   float (**)(float*,Front*,Wave*,
                                              COMPONENT,Locstate));
#endif /* defined(TWOD) */

	/* hpseudo.c */
IMPORT	int            pseudo_unsplit_driver(float,float*,Wave*,Front*);
IMPORT	void	       h_set_unsplit_options(UnsplitStencilOptions*);


	/* hscatter.c*/
IMPORT  bool    h_iscatter_states(Wave*,Front*,int*,int);
IMPORT  bool    h_scatter_states(Wave*,Front*,int*,int);
IMPORT	void	SetDefaultHypPPBlockSize(int);
IMPORT	void	SetHypPPBlockSize(size_t);
IMPORT  void    reflect_states_across_domain(int*,int,int,Front*,Wave*);
IMPORT  void    pp_receive_large_data(byte*,size_t,int);
IMPORT  void    pp_send_large_data(byte*,size_t,int);

	/* hsoln.c*/
IMPORT	float	measure_of_linear_element(LINEAR_ELEMENT*,TRI_SOLN*);
IMPORT	int	copy_hyp_solution_function(Wave*,Wave*);
IMPORT	int	hyp_tri_grid_driver(Front*,Wave*,RECT_GRID*);
IMPORT	int	init_hyp_solution_function(Wave*,Front*);
IMPORT	void	evaluate_dirichlet_boundary_state(float*,HYPER_SURF*,Front*,
						  Wave*,Locstate);
IMPORT	void	h_hyp_solution(float*,COMPONENT,HYPER_SURF*,SIDE,Front*,
			       Wave*,Locstate,Locstate);
IMPORT	void	reinit_hyp_solution_function(Wave*,Front*);
IMPORT	void	states_on_bilinear_element(Locstate*,BILINEAR_ELEMENT*,
					   TRI_GRID*);
IMPORT  void    set_tri_soln_struct(TRI_SOLN*,INTERFACE*,TRI_GRID*,size_t,
                                     INTERPOLATORS*,EL_INTEGRALS*,UNSPLIT*);
	/* hsub.c*/
IMPORT	Stencil	*alloc_stencil(int,Front*);
IMPORT	float	h_max_hyp_time_step(Wave*,float*);

/* For parabolic step */
IMPORT	float	h_max_parab_time_step(Wave*,float*);

IMPORT	int	*set_iperm(int,int);
IMPORT	int	is_source_block(Wave*,INTERFACE*,COMPONENT,int*);
IMPORT  int	reflect_pt_about_Nbdry(float*,float*,float*,COMPONENT,
				       HYPER_SURF*,Front*);
IMPORT	void	free_pt_source_interior_vectors(Wave*);
IMPORT	void	h_copy_into_front(Front*,Front*);
IMPORT	void	h_set_default_front_parameters(INIT_DATA*,Front*);
IMPORT	void	set_pt_source_interior_vectors(Wave*);
IMPORT	void	set_sweep_limits(Wave*,int,int*,int*,int*);

	/* hvec.c*/
IMPORT	void	hyp_reg_vec(int,int*,float,float,Wave*,Wave*,
			    Front*,Front*,COMPONENT);

	/* hwave.c*/
IMPORT	h_MaxWaveSpeed	*h_alloc_MaxWaveSpeed(h_MaxWaveSpeed*,Wave*);
IMPORT	void	h_assign_wave_parameters(Wave*,Wave*);
IMPORT	void	h_copy_into_wave(Wave*,Wave*);
IMPORT	void	h_free_wave(Wave*);
IMPORT	void	h_initialize_max_wave_speed(Wave*);
IMPORT	void	h_set_default_wave_parameters(INIT_DATA*,Wave*);
IMPORT	void	h_set_max_wave_speed(int,float,Locstate,float*,Wave*);
IMPORT  void    h_set_max_viscosity(float,Locstate,float*,Wave*);
IMPORT  h_MaxViscosity  *h_alloc_MaxViscosity(h_MaxViscosity*,Wave*);
	/* hintfc.c*/
IMPORT	bool	h_reconstruct_front_at_grid_crossing(Front*,Front*,int);
IMPORT  bool    h_repair_front_at_grid_crossing(Front*);

#if defined(USE_OVERTURE)
       /* hamr_dricer.c */
IMPORT  int     hyp_amr_split_driver(float,float*,Wave**,Front**,
                   Front**,int,Wv_on_pc**,int,CompositeGrid*,
                   doubleCompositeGridFunction*,
                   doubleCompositeGridFunction*,Overparam*,
                   void(*)(int,int*,float,float,
                    Wave*,Wave*,Front*,Front*,COMPONENT));
IMPORT  int     hyp_patch_split_driver(float,float*,Wave*,Front*,Front*,
                   CompositeGrid*, doubleCompositeGridFunction*,
                   doubleCompositeGridFunction*,
                   void (*)(int,int*,float,float,Wave*,Wave*,
                    Front*,Front*,COMPONENT));
IMPORT  int     reinstall_undistribute_patch(Wave***,Front***,Wave**,
                   Front**,Wv_on_pc**,int,int);
IMPORT  int     reinstall_mini_undistribute_patch(Wave***,Front***,int*,
                   Wave**,Front**,Wv_on_pc**,int,int,int);
IMPORT  void    patch_wave_trans(Wave**,Wave**,Wv_on_pc**,int,int,int,int);
IMPORT  int     fast_reinstall_undistribute_patch(Wave***,Front***,Wave**,
                   Front**,Wv_on_pc**,int,int);
IMPORT  int     fast_reinstall_undistribute_patch2(Wave***,Front**,Wave**,
                   Front**,Wv_on_pc**,int,int,int);
IMPORT  void    fast_patch_wave_trans(Wave**,Wave**,Front**,
                   Wv_on_pc**,int,int,int,int);
IMPORT  TRI_SOLN  *copy_AMR_tri_soln_storage(TRI_SOLN*,Wave*);
IMPORT  bool    h_scatter_patch_states(Wave**,Front**,Overparam*,
                   Wv_on_pc**,int,int*,int);
IMPORT  void    free_copy_patches(Wave**,Front**,Wv_on_pc**,int);

       /* hamrscatter.c */
IMPORT  void    average_fine_to_coarse_st(Wave**,Front**,int,
                  Wv_on_pc**,int,Overparam*);
IMPORT  void    wave_intrp_buf_blks(Wave**,Front**,int,
                  Wv_on_pc**,int,Overparam*);
#endif /* if defined(USE_OVERTURE) */

#endif /* !defined(_HPROTOS_H) */
