/*
*                       hlocaldecs.h:
*
*       Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*       Frontier 3D amr interpolation function calls.
*/

#if !defined(_HLOCALDECS_H)
#define _HLOCALDECS_H

#include <hyp/hdecs.h>

#if defined(USE_OVERTURE)
struct _Amr_intrp_pt{
      int     ic[MAXD];   /* IC is recorded in the local table item[][] coords */
                          /* i.e. 0 ----> gmax[] */
      int     on_item[2]; /* For recv: ic. is intrped on table item[][],
                             i.e. recv from (on_item) [][] */
                          /* For send: ic. is from table item[][],
                             i.e. send to(on_item) [][] */
};
typedef struct _Amr_intrp_pt Amr_intrp_pt;
struct _Amr_intrp_set{
      int     item[2]; /* This set of points is from table item */
      int     n_pts;
      Amr_intrp_pt *apts;
};
typedef struct _Amr_intrp_set Amr_intrp_set;

struct _Amr_avg_set{
      int     item[2];    /* This set of points is from table item */
      int     num_box;
      Trans_box  *avgbox;
};
typedef struct _Amr_avg_set Amr_avg_set;

struct _Intrp_cps{
        int num;
        COMPONENT   *comp;
        Locstate    *state;
        byte        *state_storage;
};
typedef struct _Intrp_cps Intrp_cps;

struct _PP_cps{
        int   me[2];
        int   from_it[2];
        int   to_it[2];
        int   num;
        byte  *ipp_buf;
#if defined(__MPI__)
        int         ipp_tag;
        MPI_Request ipp_reqs;
        MPI_Status  ipp_stat;
#endif /* if defined(__MPI__) */
};
typedef struct _PP_cps PP_cps;

/* hamrscatter.c */
IMPORT  void    wave_set_recv_intrp_blks_in_dir(Front**,Wave**,int,
                  Overparam*,Wv_on_pc**,int,int*,int,Amr_intrp_set**,int*,
                  Amr_intrp_set**,int*);
IMPORT  PP_cps  **wave_post_recv_intrp_blks(Front**,Wave**,int,
                    Amr_intrp_set*,int,Overparam*,Wv_on_pc**,int);
IMPORT  void    wave_intrp_buf_blks_in_dir(Front**,Wave**,int,
                  Overparam*,Wv_on_pc**,int,int*,int,PP_cps**,
                  Amr_intrp_set*,int,Amr_intrp_set*,int);

#endif /* if defined(USE_OVERTURE) */

enum _CRX_SIDE {
        PREV = -1,
        NEXT =  1
};
typedef enum _CRX_SIDE CRX_SIDE;

/* hsoln.c */
IMPORT void   h_hyp_grad_solution(float*,COMPONENT,HYPER_SURF*,SIDE,Front*,
                                     Wave*,Locstate*);

/* hsoln2.c */
#if defined(CONSERVATIVE_ALG)
IMPORT int    init_hyp_solution_function2(TRI_GRID*,Wave*,Front*);
#endif /* if defined(CONSERVATIVE_ALG) */

/* hhex_intfc.c */
#if defined(CONSERVATIVE_ALG)
IMPORT int    construct_hex_intfc(Front*,Wave*,Front*,Wave*,float);
IMPORT void   set_vol_frac_states(Wave*,Front*);  
#endif /* if defined(CONSERVATIVE_ALG) */

/* hscatter.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT int    scatter_frac_cell_states(Wave*,Front*); 
#endif /* if defined(CONSERVATIVE_ALG) && defined(TWOD) */

/* hunsplitvec.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT void   hyp_unsplit_reg_vec(int*,float*,
                    float,Wave*,Wave*,Front*,Front*,COMPONENT); 
IMPORT int    copy_hyp_soln_state(Wave*,Wave*); 

/* IMPORT void   set_unsplit_sweep_limits(Wave*,int,int*,int*,int*);  */
#endif /* if defined(CONSERVATIVE_ALG) && defined(TWOD) */

/* hnpt.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT void   hyp_unsplit_npt(int,int*,float*,float,Wave*,Wave*,Wave*,Front*,Front*,COMPONENT);
#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

/* hconsvnpt.c */
#if defined(CONSERVATIVE_ALG) && defined(TWOD)
IMPORT void   hyp_consv_npt(int,int*,float*,float,Wave*,Wave*,Front*,Front*,COMPONENT);
#endif /* #if defined(CONSERVATIVE_ALG) && defined(TWOD) */

#endif /* if !defined(_HLOCALDECS_H) */
