/*
 *                               goverinterp2d.c:
 *
 *       Copyright 1999 by The University at Stony Brook, All rights reserved.
 *
 *       Contains routines for the interpolation of state data for 2D amr.
 */

#define DEBUG_STRING      "goverinterp2d"

#include <gstate/goverlocaldecs.h>

#if defined(USE_OVERTURE)

LIB_LOCAL void g_fill_root_extr_overture_cell_st_from_wv2d(
        Wave       *wv,
        Front      *fr,
        POINTER    cg_func,
        int        grid,
        int        var)
{

        CompositeGrid *cg = (CompositeGrid*)wv->cg_over;
        /*
        doubleCompositeGridFunction& uu = *((doubleCompositeGridFunction*)cg_func);
        */
        doubleCompositeGridFunction *uu = (doubleCompositeGridFunction*)cg_func;
        Index      I1,I2,I3;

        INTERFACE  *rt_interf = fr->interf;
        int        ix, iy;
        int        xmin, xmax, ymin, ymax;
        int        base1,base2,bound1,bound2;
        int        base11,base22,bound11,bound22;

        DEBUG_ENTER(fill_extr_overture_cell_st_from_wv)

        getIndex((*cg)[grid].indexRange(),I1,I2,I3);
        base11 = I1.getBase();
        base22 = I2.getBase();
        bound11 = I1.getBound();
        bound22 = I2.getBound();


        getIndex((*cg)[grid].dimension(),I1,I2,I3);
        base1 = I1.getBase();
        base2 = I2.getBase();
        bound1 = I1.getBound();
        bound2 = I2.getBound();

        for(int axis = 0; axis<cg->numberOfDimensions(); axis++)
        {
            for(int side = Start; side<=End; side++)
            {
                if(rect_boundary_type(rt_interf,axis,side) == SUBDOMAIN_BOUNDARY)
                    continue;
                if(rect_boundary_type(rt_interf,axis,side) == REFLECTION_BOUNDARY)
                    continue;
                if(rect_boundary_type(rt_interf,axis,side) == AMR_SUBDOMAIN_BOUNDARY)
                    continue;
                if(axis == 0 and side == 0)
                {
                    if((*cg)[grid].boundaryCondition()(0,1) == 0)
                        ymin = base22;
                    else
                        ymin = base2;
                    if((*cg)[grid].boundaryCondition()(1,1) == 0)
                        ymax = bound22;
                    else
                        ymax = bound2;
                    xmin=base1; xmax=base11;
                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            (*uu)[grid](ix,iy,0) = (*uu)[grid](0,iy,0);
                        }
                    }
                }
                if(axis == 0 and side == 1)
                {
                    if((*cg)[grid].boundaryCondition()(0,1) == 0)
                        ymin = base22;
                    else
                        ymin = base2;
                    if((*cg)[grid].boundaryCondition()(1,1) == 0)
                        ymax = bound22;
                    else
                        ymax = bound2;
                    xmin=bound11; xmax=bound1;
                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            (*uu)[grid](ix,iy,0) = (*uu)[grid](bound11-1,iy,0);
                        }
                    }
                }
                if(axis == 1 and side == 0)
                {
                    if((*cg)[grid].boundaryCondition()(0,0) == 0)
                        xmin = base11;
                    else
                        xmin = base1;
                    if((*cg)[grid].boundaryCondition()(1,0) == 0)
                        xmax = bound11;
                    else
                        xmax = bound1;
                    ymin=base2; ymax=base22;
                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            (*uu)[grid](ix,iy,0) = (*uu)[grid](ix,0,0);
                        }
                    }
                }
                if(axis == 1 and side == 1)
                {
                    if((*cg)[grid].boundaryCondition()(0,0) == 0)
                        xmin = base11;
                    else
                        xmin = base1;
                    if((*cg)[grid].boundaryCondition()(1,0) == 0)
                        xmax = bound11;
                    else
                        xmax = bound1;
                    ymin=bound22; ymax=bound2;

                    for (iy = ymin; iy < ymax; iy++)
                    {
                        for (ix = xmin; ix < xmax; ix++)
                        {
                            (*uu)[grid](ix,iy,0) = (*uu)[grid](ix,bound22-1,0);
                        }
                    }
                }
            }
        }
        for (ix = base1; ix <= bound1; ix++)
        {
            (*uu)[grid](ix,bound2,0) = (*uu)[grid](ix,bound2-1,0);
        }
        for (iy = base2; iy <= bound2; iy++)
        {
            (*uu)[grid](bound1,iy,0) = (*uu)[grid](bound1-1,iy,0);
        }

        DEBUG_LEAVE(fill_extr_overture_cell_st_from_wv)
}

#endif /* if defined(USE_OVERTURE) */


