/*
*				gtop.c:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*			User Supplied Operations
*	for gas dynamical specific interface operations.
*/


#include <gdecs/gdecs.h>

EXPORT	void	g_reflect_point(
	POINT		*point,/* point being reflected */
	float		*p,	/* point on reflection plane */
	float		*n,	/* normal to plane */
	INTERFACE	*intfc)	/* interface being reflected */
{
	f_reflect_point(point,p,n,intfc);
#if defined(ONED)
	if (intfc->dim == 1)
	    wave_type(point) = opposite_wave_type(wave_type(point));
#endif /*defined(ONED)*/
}		/*end f_reflect_point*/


#if defined(TWOD)
EXPORT  void    g_reflect_node2d(
	NODE		*node,/* node being reflected */
	float		*p,     /* point on reflection plane */
	float		*n)     /* normal to plane */
{
	float		*pt = Coords(node->posn);
	RP_DATA		*RP;

	if ((RP = Rp_data(node)) != NULL)
	{
	    INTERFACE	*intfc = node->interface;
	    int	i;
	    float	beta;

	    beta = PI + 2.0*angle(n[0],n[1]);
	    RP->ang_dir = Opposite_ang_dir(RP->ang_dir);
	    for (i = 0; i < MAX_N_CURVES; i++)
	    {
	    	reflect_state(RP->state[i],intfc,pt,p,n);
	    	RP->ang[i] = normalized_angle(beta - RP->ang[i]);
	    	RP->theta[i] = normalized_angle(beta - RP->theta[i]);
	    }
	}
	f_reflect_node2d(node,p,n);
}		/*end g_reflect_node2d*/

EXPORT	void g_delete_small_loops(
	Front		*fr)
{
	CURVE		**c;
	INTERFACE	*intfc = fr->interf;
	NODE		*m;
	float		perim_tol;
	float		*h = computational_grid(intfc)->h;

	perim_tol = h[0] + h[1];

label_2:
	for (c = intfc->curves;  c && *c;  c++)
	{
	    if (!is_closed_curve(*c)) continue;
	    if (wave_type(*c) < FIRST_PHYSICS_WAVE_TYPE) continue;

	    if (((*c)->num_points < 5) ||
		    (curve_length(*c) < 4.0*perim_tol)) /*TOLERANCE*/
	    {
	    	if (is_shock_wave(wave_type(*c)))
	    	{
	    	    float area = area_of_closed_curve(*c);
	    	    if ((area > 0.0) && is_backward_wave(wave_type(*c)))
	    	    {
	    	    	wave_type(*c) = FORWARD_SHOCK_WAVE;
	    	    }
	    	    if ((area < 0.0) && is_forward_wave(wave_type(*c)))
	    	    {
	    	    	wave_type(*c) = BACKWARD_SHOCK_WAVE;
	    	    }
	    	    continue;
	    	}
	    	else
	    	{
	    	    m = (*c)->start;
	    	    (void) delete_curve(*c);
	    	    if (node_type(m) == CLOSED_NODE)
	    	    	(void) delete_node(m);
	    	    goto label_2;
	    	}
	    }
	}
}		/*end g_delete_small_loops*/
#endif /* defined(TWOD) */
