/*
*				gintfcprotos.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	This file contains the structures for gas dynamics states.
*/

#if !defined(_GINTFCPROTOS_H)

	/* gintfc EXPORTED Function Declarations */

/*	gintfcpert.c */
#if defined(TWOD) || defined(THREED)
IMPORT	SINE_PERT *alloc_and_copy_sine_pert_structure(SINE_PERT*,Front*);
IMPORT	SINE_PERT *alloc_sine_pert_structure(int,Front*);
IMPORT	float	  pert_interface(SINE_PERT*,float*,float,int);
#endif /* defined(TWOD) || defined(THREED) */

/*	gintfc/guserintfc.c */
IMPORT	G_USER_INTERFACE	*g_user_hook(int);
IMPORT	bool	g_form_subintfc_via_communication2d(Front*);

#if defined(USE_OVERTURE)
IMPORT  int     g_assembly_fine_patch_fronts_to_one(Front**,Front*);
#if defined(TWOD)
IMPORT  bool    g_form_patch_subintfc_via_cut2d(Front*);
IMPORT  bool    g_form_patch_subintfc_2d(Front*,COMPONENT);
#endif /* if defined(TWOD) */
#if defined(THREED)
IMPORT  bool    g_form_patch_subintfc_via_cut3d(Front*);
IMPORT  bool    g_form_patch_subintfc_3d(Front*,COMPONENT);
#endif /* if defined(THREED) */
#endif /* if defined(USE_OVERTURE) */

IMPORT	float	prompt_for_surface_tension(const int,const char*);
IMPORT	void	constant_density_stratified_state(Locstate,float,
						  float,Locstate);
IMPORT	void	g_preserve_user_hooks(int,PRESERVE_USER_HOOKS);
IMPORT	void	g_set_interface_hooks(int);
IMPORT	void	g_set_stratified_state(void(*)(Locstate,float,float,Locstate),
				       const char*);
IMPORT  void    g_user_fprint_node(FILE*,NODE*);
IMPORT	void	isentropic_stratified_state(Locstate,float,float,Locstate);
IMPORT	void	isothermal_stratified_state(Locstate,float,float,Locstate);
IMPORT	void	stratified_state(INTERFACE*,Locstate,float,float,Locstate);

/*      gintfc/muserintfc.c */
#ifdef MHD
IMPORT  void    m_set_interface_hooks(int);
#endif

/*	gintfc/gtop.c */
IMPORT	void	g_reflect_point(POINT*,float*,float*,INTERFACE*);
#if defined(TWOD)
IMPORT	void	g_delete_small_loops(Front*);
IMPORT	void	g_reflect_node2d(NODE*,float*,float*);
#endif /* defined(TWOD) */

/*	gintfc/gtypes.c */
IMPORT	bool	g_is_correspondence_possible(HYPER_SURF*,HYPER_SURF*,
					  HYPER_SURF_BDRY**,HYPER_SURF_BDRY**);
IMPORT	int	opposite_wave_type(int);
IMPORT	void	set_fixed_status(CURVE*,ORIENTATION);
IMPORT	void	set_incident_status(CURVE*,ORIENTATION);
IMPORT	void	set_start_end_status(Front*);
IMPORT	void	set_status_at_node(CURVE*,ORIENTATION,int);

/*	gintfc/guserhooks.c */
IMPORT	void	w_speed(float*,Locstate,Locstate,Locstate,Locstate,float*,
			float,float*,int,Front*);
IMPORT	void	unsplit_w_speed2d(USWSSten2d*,Locstate,Locstate,float*);
IMPORT	void	npt_w_speed(WSSten*,Locstate,Locstate,float*);

#if defined(THREED)
/*	gintfc/gcheck3d.c */
IMPORT	bool	g_consistent_interface(INTERFACE*);
#endif /* defined(THREED) */

#endif /* !defined(_GINTFCPROTOS_H) */
